/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateScope;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionTemplate;

public class CPPMethodTemplate
extends CPPFunctionTemplate
implements ICPPMethod {
    public CPPMethodTemplate(IASTName name) {
        super(name);
    }

    public IASTDeclaration getPrimaryDeclaration() {
        IASTDeclaration[] members;
        if (this.declarations != null) {
            IASTName[] iASTNameArray = this.declarations;
            int n = this.declarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName declaration = iASTNameArray[n2];
                IASTNode parent = declaration.getParent();
                while (!(parent instanceof IASTDeclaration) && parent != null) {
                    parent = parent.getParent();
                }
                IASTDeclaration decl = (IASTDeclaration)parent;
                if (decl != null && decl.getParent() instanceof ICPPASTCompositeTypeSpecifier) {
                    return decl;
                }
                ++n2;
            }
        }
        if (this.definition != null) {
            IASTNode parent = this.definition.getParent();
            while (!(parent instanceof IASTDeclaration) && parent != null) {
                parent = parent.getParent();
            }
            IASTDeclaration decl = (IASTDeclaration)parent;
            if (decl != null && decl.getParent() instanceof ICPPASTCompositeTypeSpecifier) {
                return decl;
            }
        }
        char[] myName = this.getTemplateName().getLookupKey();
        IScope scope = this.getScope();
        if (scope instanceof ICPPTemplateScope) {
            try {
                scope = scope.getParent();
            }
            catch (DOMException dOMException) {
                return null;
            }
        }
        ICPPClassScope clsScope = (ICPPClassScope)scope;
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)ASTInternal.getPhysicalNodeOfScope(clsScope);
        IASTDeclaration[] iASTDeclarationArray = members = compSpec.getMembers();
        int n = members.length;
        int n3 = 0;
        while (n3 < n) {
            IASTDeclaration member = iASTDeclarationArray[n3];
            if (member instanceof ICPPASTTemplateDeclaration) {
                IASTName name;
                IASTDeclaration decl = ((ICPPASTTemplateDeclaration)member).getDeclaration();
                if (decl instanceof IASTSimpleDeclaration) {
                    IASTDeclarator[] dtors;
                    IASTDeclarator[] iASTDeclaratorArray = dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                    int n4 = dtors.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IASTDeclarator dtor = iASTDeclaratorArray[n5];
                        IASTName name2 = ASTQueries.findInnermostDeclarator(dtor).getName();
                        if (CharArrayUtils.equals(name2.getLookupKey(), myName) && name2.resolveBinding() == this) {
                            return member;
                        }
                        ++n5;
                    }
                } else if (decl instanceof IASTFunctionDefinition && CharArrayUtils.equals((name = ASTQueries.findInnermostDeclarator(((IASTFunctionDefinition)decl).getDeclarator()).getName()).getLookupKey(), myName) && name.resolveBinding() == this) {
                    return member;
                }
            }
            ++n3;
        }
        return null;
    }

    @Override
    public int getVisibility() {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl == null) {
            ICPPClassType cls = this.getClassOwner();
            if (cls != null) {
                return cls.getKey() == 3 ? 3 : 1;
            }
            return 3;
        }
        IASTCompositeTypeSpecifier cls = (IASTCompositeTypeSpecifier)decl.getParent();
        IASTDeclaration[] members = cls.getMembers();
        ICPPASTVisibilityLabel vis = null;
        IASTDeclaration[] iASTDeclarationArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration member = iASTDeclarationArray[n2];
            if (member instanceof ICPPASTVisibilityLabel) {
                vis = (ICPPASTVisibilityLabel)member;
            } else if (member == decl) break;
            ++n2;
        }
        if (vis != null) {
            return vis.getVisibility();
        }
        if (cls.getKey() == 3) {
            return 3;
        }
        return 1;
    }

    @Override
    public ICPPClassType getClassOwner() {
        IScope scope = this.getScope();
        if (scope instanceof ICPPTemplateScope) {
            try {
                scope = scope.getParent();
            }
            catch (DOMException dOMException) {
                return null;
            }
        }
        if (scope instanceof ICPPClassScope) {
            return ((ICPPClassScope)scope).getClassType();
        }
        return null;
    }

    @Override
    public boolean isVirtual() {
        ICPPASTDeclSpecifier declSpec;
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl instanceof ICPPASTTemplateDeclaration && (declSpec = this.getDeclSpecifier(((ICPPASTTemplateDeclaration)decl).getDeclaration())) != null) {
            return declSpec.isVirtual();
        }
        return false;
    }

    @Override
    public boolean isStatic(boolean resolveAll) {
        ICPPASTDeclSpecifier declSpec;
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl instanceof ICPPASTTemplateDeclaration && (declSpec = this.getDeclSpecifier(((ICPPASTTemplateDeclaration)decl).getDeclaration())) != null) {
            return declSpec.getStorageClass() == 3;
        }
        return false;
    }

    @Override
    public boolean isInline() {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl instanceof ICPPASTTemplateDeclaration && ((ICPPASTTemplateDeclaration)decl).getDeclaration() instanceof IASTFunctionDefinition) {
            return true;
        }
        return super.isInline();
    }

    @Override
    public boolean isDestructor() {
        char[] name = this.getNameCharArray();
        return name.length > 1 && name[0] == '~';
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public boolean isExplicit() {
        ICPPASTDeclSpecifier declSpec;
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl instanceof ICPPASTTemplateDeclaration && (declSpec = this.getDeclSpecifier(((ICPPASTTemplateDeclaration)decl).getDeclaration())) != null) {
            return declSpec.isExplicit();
        }
        return false;
    }

    @Override
    public boolean isPureVirtual() {
        ICPPASTFunctionDeclarator functionDeclarator = this.findFunctionDeclarator();
        if (functionDeclarator != null) {
            return functionDeclarator.isPureVirtual();
        }
        return false;
    }

    @Override
    public boolean isOverride() {
        ICPPASTFunctionDeclarator functionDeclarator = this.findFunctionDeclarator();
        if (functionDeclarator != null) {
            return functionDeclarator.isOverride();
        }
        return false;
    }

    @Override
    public boolean isFinal() {
        ICPPASTFunctionDeclarator functionDeclarator = this.findFunctionDeclarator();
        if (functionDeclarator != null) {
            return functionDeclarator.isFinal();
        }
        return false;
    }

    private ICPPASTFunctionDeclarator findFunctionDeclarator() {
        IASTName target = null;
        target = this.declarations != null && this.declarations.length > 0 ? this.declarations[0] : this.definition;
        if (target != null) {
            IASTDeclarator dtor;
            IASTNode parent = target.getParent();
            while (!(parent instanceof IASTDeclarator) && parent != null) {
                parent = parent.getParent();
            }
            if (parent instanceof IASTDeclarator && (dtor = ASTQueries.findTypeRelevantDeclarator((IASTDeclarator)parent)) instanceof ICPPASTFunctionDeclarator) {
                return (ICPPASTFunctionDeclarator)dtor;
            }
        }
        return null;
    }
}

