/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.text.c.hover.AbstractCEditorTextHover;
import org.eclipse.cdt.internal.ui.text.c.hover.CEditorTextHoverDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.ui.IEditorPart;

public class BestMatchHover
extends AbstractCEditorTextHover {
    private List<CEditorTextHoverDescriptor> fTextHoverSpecifications;
    private List<ITextHover> fInstantiatedTextHovers;
    private ITextHover fBestHover;

    public BestMatchHover() {
        this.installTextHovers();
    }

    public BestMatchHover(IEditorPart editor) {
        this();
        this.setEditor(editor);
    }

    private void installTextHovers() {
        CEditorTextHoverDescriptor[] hoverDescs = CUIPlugin.getDefault().getCEditorTextHoverDescriptors();
        this.fTextHoverSpecifications = new ArrayList<CEditorTextHoverDescriptor>(hoverDescs.length - 1);
        this.fInstantiatedTextHovers = new ArrayList<ITextHover>(hoverDescs.length - 1);
        int i = 0;
        while (i < hoverDescs.length) {
            if (!"org.eclipse.cdt.ui.BestMatchHover".equals(hoverDescs[i].getId())) {
                this.fTextHoverSpecifications.add(hoverDescs[i]);
                this.fInstantiatedTextHovers.add(null);
            }
            ++i;
        }
    }

    private void checkTextHovers() {
        if (this.fTextHoverSpecifications == null) {
            return;
        }
        boolean allCreated = true;
        int i = 0;
        while (i < this.fTextHoverSpecifications.size()) {
            CEditorTextHoverDescriptor spec = this.fTextHoverSpecifications.get(i);
            if (spec != null) {
                ICEditorTextHover hover = spec.createTextHover();
                if (hover != null) {
                    hover.setEditor(this.getEditor());
                    this.fInstantiatedTextHovers.set(i, hover);
                    this.fTextHoverSpecifications.set(i, null);
                } else {
                    allCreated = false;
                }
            }
            ++i;
        }
        if (allCreated) {
            this.fTextHoverSpecifications = null;
        }
    }

    @Override
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        for (ITextHover hover : this.fInstantiatedTextHovers) {
            String s;
            if (hover == null || (s = hover.getHoverInfo(textViewer, hoverRegion)) == null || s.trim().length() <= 0) continue;
            this.fBestHover = hover;
            return s;
        }
        return null;
    }

    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        this.checkTextHovers();
        this.fBestHover = null;
        if (this.fInstantiatedTextHovers == null) {
            return null;
        }
        for (ITextHover hover : this.fInstantiatedTextHovers) {
            if (hover == null) continue;
            if (hover instanceof ITextHoverExtension2) {
                Object info = ((ITextHoverExtension2)hover).getHoverInfo2(textViewer, hoverRegion);
                if (info == null) continue;
                this.fBestHover = hover;
                return info;
            }
            String s = hover.getHoverInfo(textViewer, hoverRegion);
            if (s == null || s.trim().length() <= 0) continue;
            this.fBestHover = hover;
            return s;
        }
        return null;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fBestHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fBestHover).getHoverControlCreator();
        }
        return null;
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fBestHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fBestHover).getInformationPresenterControlCreator();
        }
        return null;
    }
}

