/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.param.RootProblemPreference;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.QuickFixMessages;
import org.eclipse.cdt.codan.ui.AbstractCodanCMarkerResolution;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;

public class CaseBreakQuickFixComment
extends AbstractCodanCMarkerResolution {
    public String getLabel() {
        return QuickFixMessages.CaseBreakQuickFixComment_Label;
    }

    public void apply(IMarker marker, IDocument document) {
        try {
            int line = marker.getAttribute("lineNumber", -1);
            if (line < 0) {
                return;
            }
            int offset = document.getLineOffset(line);
            String indent = this.getIndentationStr(document, line);
            String comment = this.getNoBreakComment(marker);
            String editStr = String.format("%s/* %s */\n", indent, comment);
            InsertEdit edit = new InsertEdit(offset, editStr);
            edit.apply(document);
        }
        catch (MalformedTreeException malformedTreeException) {
            return;
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    private String getIndentationStr(IDocument document, int line) throws BadLocationException {
        int prevLine = line - 1;
        IRegion lineInformation = document.getLineInformation(prevLine);
        String prevLineStr = document.get(lineInformation.getOffset(), lineInformation.getLength());
        int nonSpace = prevLineStr.indexOf(prevLineStr.trim());
        String indent = prevLineStr.substring(0, nonSpace);
        return indent;
    }

    private String getNoBreakComment(IMarker marker) {
        IProblem problem = this.getProblem(marker);
        RootProblemPreference map = (RootProblemPreference)problem.getPreference();
        String comment = (String)map.getChildValue("no_break_comment");
        if (comment == null || comment.trim().length() == 0) {
            comment = "no break";
        }
        return comment;
    }
}

