/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.memory;

public enum DeviceMemoryType {
    constant,
    generic,
    global,
    local,
    shared;

    private static final String[] NAMES;

    static {
        DeviceMemoryType[] values = DeviceMemoryType.values();
        NAMES = new String[values.length];
        int i = 0;
        while (i < values.length) {
            DeviceMemoryType.NAMES[i] = values[i].name();
            ++i;
        }
    }

    public static String[] names() {
        return NAMES;
    }

    public String getCast() {
        return String.format("(@%s void*) ", this.name());
    }

    public static String fromCudaGdbType(String typeName) {
        int memspace = typeName.indexOf("@");
        if (memspace >= 0) {
            int memspaceEnd = typeName.indexOf(" ", memspace + 1);
            if (memspaceEnd < 0) {
                memspaceEnd = typeName.length() - 1;
            }
            String name = typeName.substring(memspace + 1, memspaceEnd);
            DeviceMemoryType[] deviceMemoryTypeArray = DeviceMemoryType.values();
            int n = deviceMemoryTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DeviceMemoryType type = deviceMemoryTypeArray[n2];
                if (type.name().equals(name)) {
                    return type.name();
                }
                ++n2;
            }
        }
        return global.name();
    }
}

