/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaObjectsFactory;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Warp
extends AbstractDMContext
implements ICudaRuntimeObject {
    private final short id;
    private final StreamingMultiprocessor sm;

    public static int getWarpKey(short device, short sm, short warp) {
        return (device << 20) + (sm << 10) + warp;
    }

    public Warp(StreamingMultiprocessor sm, short id) {
        super(sm.getSessionId(), new IDMContext[]{sm});
        this.sm = sm;
        this.id = id;
    }

    @Override
    public void accept(ICudaVisitor visitor) {
        visitor.visitWarp(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Warp) {
            return ((Warp)obj).getId() == this.getId() && ((Warp)obj).sm.equals(this.sm);
        }
        return false;
    }

    public short getDeviceId() {
        return ((Device)DMContexts.getAncestorOfType((IDMContext)this, Device.class)).getId();
    }

    public short getId() {
        return this.id;
    }

    public Lane getLane(short i) throws CudaException {
        return CudaObjectsFactory.getInstance().newLane(this, i);
    }

    public short getSMId() {
        return ((StreamingMultiprocessor)DMContexts.getAncestorOfType((IDMContext)this, StreamingMultiprocessor.class)).getId();
    }

    @Override
    public void getState(DataRequestMonitor<CudaRuntimeInformation> rm) {
        ((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)this, ICudaApplication.class)).getWarpState(this, rm);
    }

    @Override
    public ElementType getType() {
        return ElementType.warp;
    }

    public int hashCode() {
        return Warp.getWarpKey(this.getDeviceId(), this.getSMId(), this.getId());
    }

    @Override
    public void toHardwareElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        drm.setData((Object)this);
        drm.done();
    }

    @Override
    public void toLogicalElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        try {
            this.getLane((short)0).toLogicalElement(drm);
        }
        catch (CudaException e) {
            drm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
            drm.done();
        }
    }

    public String toString() {
        return String.format("%s warp %d", this.getParents()[0], this.id);
    }
}

