/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.connection;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.DataBindingUtil;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.ui.connection.RemoteConnectionCombo;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class RemoteConnectionField {
    private final RemoteConnectionCombo connections;
    private final WizardContext context;
    private PropertyDescriptor<IRemoteConnection> property;

    public RemoteConnectionField(Composite composite, WizardContext context) {
        this.context = context;
        Label lblRemoteSystem = new Label(composite, 0);
        lblRemoteSystem.setText("Remote connection:");
        this.connections = new RemoteConnectionCombo(composite);
        Control combo = this.connections.getControl();
        GridData gd_combo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 50;
        combo.setLayoutData((Object)gd_combo);
        Button btnNew = new Button(composite, 0);
        btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteConnectionField.this.addRemoteConnection();
            }
        });
        btnNew.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnNew.setText("Manage...");
    }

    protected void addRemoteConnection() {
        IRemoteConnection connection = this.connections.manage();
        if (connection != null) {
            this.context.setProperty(this.property, (Object)connection);
        }
    }

    public void bind(DataBindingContext bindingContext, PropertyDescriptor<IRemoteConnection> property) {
        this.property = property;
        IObservableValue remoteConnectionProperty = this.context.observeProperty(property);
        bindingContext.bindValue(this.connections.observeSelection(), remoteConnectionProperty);
        DataBindingUtil.bindEnablement((DataBindingContext)bindingContext, (IObservableValue)remoteConnectionProperty, (Control[])new Control[0]);
    }

    public IStatus validate() {
        IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.property);
        if (connection == null) {
            return CoreUtil.errorStatus((String)"Remote connection is not selected", (Object[])new Object[0]);
        }
        return CoreUtil.OK_STATUS;
    }
}

