/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.internal.toolkit;

import com.nvidia.common.internal.toolkit.CudaToolkit;
import com.nvidia.common.internal.toolkit.IToolkitLookup;
import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.OS;
import org.eclipse.core.runtime.IPath;

public final class ToolkitOnPath
implements IToolkitLookup {
    private IPath getToolkitOnPath() {
        OS localOS = OS.local();
        String nvcc = ICudaToolkit.Tool.Nvcc.executable(localOS);
        IPath nvccPath = CoreUtil.getFileOnPath(nvcc);
        return nvccPath != null ? nvccPath.removeLastSegments(1) : null;
    }

    @Override
    public ICudaToolkit[] discover() {
        IPath path = this.getToolkitOnPath();
        if (path != null) {
            return new ICudaToolkit[]{new CudaToolkit("path.toolkit", path, "CUDA Toolkit on the path")};
        }
        return null;
    }
}

