/* $Id: tstIEMAImplDataFpuBinary1.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data - r151068 on Intel(R) Core(TM) i9-10980XE CPU @ 3.00GHz.
 */

/*
 * Copyright (C) 2022-2023 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

FPU_BINARY_R80_TEST_T const g_aTests_fadd_r80_by_r80[] =
{
    { 0x007f, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfd0000000000,14846) }, /* #0/0/0/m = #0 */
    { 0x0000, 0x1b9c, 0xb3a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfd0000000000,14846) }, /* #0/0/0/u = #1 */
    { 0x0020, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfd0000000000,14846) }, /* #0/0/0/0x20 = #2 */
    { 0x017f, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/0/1/m = #3 */
    { 0x0100, 0x1b9c, 0xb3a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/0/1/u = #4 */
    { 0x0120, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/0/1/0x20 = #5 */
    { 0x027f, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa000,14846) }, /* #0/0/2/m = #6 */
    { 0x0200, 0x1b9c, 0xb1a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa000,14846) }, /* #0/0/2/u = #7 */
    { 0x0220, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa000,14846) }, /* #0/0/2/0x20 = #8 */
    { 0x037f, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/0/3/m = #9 */
    { 0x0300, 0x1b9c, 0xb3a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/0/3/u = #10 */
    { 0x0320, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/0/3/0x20 = #11 */
    { 0x047f, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfd0000000000,14846) }, /* #0/1/0/m = #12 */
    { 0x0400, 0x1b9c, 0xb3a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfd0000000000,14846) }, /* #0/1/0/u = #13 */
    { 0x0420, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfd0000000000,14846) }, /* #0/1/0/0x20 = #14 */
    { 0x057f, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/1/1/m = #15 */
    { 0x0500, 0x1b9c, 0xb3a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/1/1/u = #16 */
    { 0x0520, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/1/1/0x20 = #17 */
    { 0x067f, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa800,14846) }, /* #0/1/2/m = #18 */
    { 0x0600, 0x1b9c, 0xb3a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa800,14846) }, /* #0/1/2/u = #19 */
    { 0x0620, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa800,14846) }, /* #0/1/2/0x20 = #20 */
    { 0x077f, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/1/3/m = #21 */
    { 0x0700, 0x1b9c, 0xb3a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/1/3/u = #22 */
    { 0x0720, 0x1b9c, 0x3320, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846) }, /* #0/1/3/0x20 = #23 */
    { 0x087f, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfc0000000000,14846) }, /* #0/2/0/m = #24 */
    { 0x0800, 0x1b9c, 0xb1a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfc0000000000,14846) }, /* #0/2/0/u = #25 */
    { 0x0820, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfc0000000000,14846) }, /* #0/2/0/0x20 = #26 */
    { 0x097f, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/2/1/m = #27 */
    { 0x0900, 0x1b9c, 0xb1a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/2/1/u = #28 */
    { 0x0920, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/2/1/0x20 = #29 */
    { 0x0a7f, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa000,14846) }, /* #0/2/2/m = #30 */
    { 0x0a00, 0x1b9c, 0xb1a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa000,14846) }, /* #0/2/2/u = #31 */
    { 0x0a20, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa000,14846) }, /* #0/2/2/0x20 = #32 */
    { 0x0b7f, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/2/3/m = #33 */
    { 0x0b00, 0x1b9c, 0xb1a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/2/3/u = #34 */
    { 0x0b20, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/2/3/0x20 = #35 */
    { 0x0c7f, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfc0000000000,14846) }, /* #0/3/0/m = #36 */
    { 0x0c00, 0x1b9c, 0xb1a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfc0000000000,14846) }, /* #0/3/0/u = #37 */
    { 0x0c20, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfc0000000000,14846) }, /* #0/3/0/0x20 = #38 */
    { 0x0d7f, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/3/1/m = #39 */
    { 0x0d00, 0x1b9c, 0xb1a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/3/1/u = #40 */
    { 0x0d20, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/3/1/0x20 = #41 */
    { 0x0e7f, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa000,14846) }, /* #0/3/2/m = #42 */
    { 0x0e00, 0x1b9c, 0xb1a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa000,14846) }, /* #0/3/2/u = #43 */
    { 0x0e20, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa000,14846) }, /* #0/3/2/0x20 = #44 */
    { 0x0f7f, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/3/3/m = #45 */
    { 0x0f00, 0x1b9c, 0xb1a0, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/3/3/u = #46 */
    { 0x0f20, 0x1b9c, 0x3120, RTFLOAT80U_INIT_C(0,0xc5698fe5d891a8b3,4279), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a2,14846), RTFLOAT80U_INIT_C(1,0xcf7bfccdf55aa0a1,14846) }, /* #0/3/3/0x20 = #47 */
    { 0x007f, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557550000000000,9442) }, /* #1/0/0/m = #48 */
    { 0x0000, 0xf555, 0xf7a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557550000000000,9442) }, /* #1/0/0/u = #49 */
    { 0x0020, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557550000000000,9442) }, /* #1/0/0/0x20 = #50 */
    { 0x017f, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/0/1/m = #51 */
    { 0x0100, 0xf555, 0xf7a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/0/1/u = #52 */
    { 0x0120, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/0/1/0x20 = #53 */
    { 0x027f, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a800,9442) }, /* #1/0/2/m = #54 */
    { 0x0200, 0xf555, 0xf5a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a800,9442) }, /* #1/0/2/u = #55 */
    { 0x0220, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a800,9442) }, /* #1/0/2/0x20 = #56 */
    { 0x037f, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/0/3/m = #57 */
    { 0x0300, 0xf555, 0xf7a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/0/3/u = #58 */
    { 0x0320, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/0/3/0x20 = #59 */
    { 0x047f, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557550000000000,9442) }, /* #1/1/0/m = #60 */
    { 0x0400, 0xf555, 0xf7a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557550000000000,9442) }, /* #1/1/0/u = #61 */
    { 0x0420, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557550000000000,9442) }, /* #1/1/0/0x20 = #62 */
    { 0x057f, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/1/1/m = #63 */
    { 0x0500, 0xf555, 0xf7a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/1/1/u = #64 */
    { 0x0520, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/1/1/0x20 = #65 */
    { 0x067f, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00b000,9442) }, /* #1/1/2/m = #66 */
    { 0x0600, 0xf555, 0xf7a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00b000,9442) }, /* #1/1/2/u = #67 */
    { 0x0620, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00b000,9442) }, /* #1/1/2/0x20 = #68 */
    { 0x077f, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/1/3/m = #69 */
    { 0x0700, 0xf555, 0xf7a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/1/3/u = #70 */
    { 0x0720, 0xf555, 0x7720, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442) }, /* #1/1/3/0x20 = #71 */
    { 0x087f, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557540000000000,9442) }, /* #1/2/0/m = #72 */
    { 0x0800, 0xf555, 0xf5a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557540000000000,9442) }, /* #1/2/0/u = #73 */
    { 0x0820, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557540000000000,9442) }, /* #1/2/0/0x20 = #74 */
    { 0x097f, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/2/1/m = #75 */
    { 0x0900, 0xf555, 0xf5a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/2/1/u = #76 */
    { 0x0920, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/2/1/0x20 = #77 */
    { 0x0a7f, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a800,9442) }, /* #1/2/2/m = #78 */
    { 0x0a00, 0xf555, 0xf5a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a800,9442) }, /* #1/2/2/u = #79 */
    { 0x0a20, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a800,9442) }, /* #1/2/2/0x20 = #80 */
    { 0x0b7f, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/2/3/m = #81 */
    { 0x0b00, 0xf555, 0xf5a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/2/3/u = #82 */
    { 0x0b20, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/2/3/0x20 = #83 */
    { 0x0c7f, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557540000000000,9442) }, /* #1/3/0/m = #84 */
    { 0x0c00, 0xf555, 0xf5a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557540000000000,9442) }, /* #1/3/0/u = #85 */
    { 0x0c20, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa557540000000000,9442) }, /* #1/3/0/0x20 = #86 */
    { 0x0d7f, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/3/1/m = #87 */
    { 0x0d00, 0xf555, 0xf5a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/3/1/u = #88 */
    { 0x0d20, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/3/1/0x20 = #89 */
    { 0x0e7f, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a800,9442) }, /* #1/3/2/m = #90 */
    { 0x0e00, 0xf555, 0xf5a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a800,9442) }, /* #1/3/2/u = #91 */
    { 0x0e20, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a800,9442) }, /* #1/3/2/0x20 = #92 */
    { 0x0f7f, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/3/3/m = #93 */
    { 0x0f00, 0xf555, 0xf5a0, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/3/3/u = #94 */
    { 0x0f20, 0xf555, 0x7520, RTFLOAT80U_INIT_C(1,0xa55754963e00a919,9442), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xa55754963e00a918,9442) }, /* #1/3/3/0x20 = #95 */
    { 0x007f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/0/0/m = #96 */
    { 0x0000, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/0/0/u = #97 */
    { 0x0001, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/0/0/0x1 = #98 */
    { 0x017f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/0/1/m = #99 */
    { 0x0100, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/0/1/u = #100 */
    { 0x0101, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/0/1/0x1 = #101 */
    { 0x027f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/0/2/m = #102 */
    { 0x0200, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/0/2/u = #103 */
    { 0x0201, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/0/2/0x1 = #104 */
    { 0x037f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/0/3/m = #105 */
    { 0x0300, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/0/3/u = #106 */
    { 0x0301, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/0/3/0x1 = #107 */
    { 0x047f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/1/0/m = #108 */
    { 0x0400, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/1/0/u = #109 */
    { 0x0401, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/1/0/0x1 = #110 */
    { 0x057f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/1/1/m = #111 */
    { 0x0500, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/1/1/u = #112 */
    { 0x0501, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/1/1/0x1 = #113 */
    { 0x067f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/1/2/m = #114 */
    { 0x0600, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/1/2/u = #115 */
    { 0x0601, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/1/2/0x1 = #116 */
    { 0x077f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/1/3/m = #117 */
    { 0x0700, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/1/3/u = #118 */
    { 0x0701, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/1/3/0x1 = #119 */
    { 0x087f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/2/0/m = #120 */
    { 0x0800, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/2/0/u = #121 */
    { 0x0801, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/2/0/0x1 = #122 */
    { 0x097f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/2/1/m = #123 */
    { 0x0900, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/2/1/u = #124 */
    { 0x0901, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/2/1/0x1 = #125 */
    { 0x0a7f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/2/2/m = #126 */
    { 0x0a00, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/2/2/u = #127 */
    { 0x0a01, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/2/2/0x1 = #128 */
    { 0x0b7f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/2/3/m = #129 */
    { 0x0b00, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/2/3/u = #130 */
    { 0x0b01, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/2/3/0x1 = #131 */
    { 0x0c7f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/3/0/m = #132 */
    { 0x0c00, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/3/0/u = #133 */
    { 0x0c01, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/3/0/0x1 = #134 */
    { 0x0d7f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/3/1/m = #135 */
    { 0x0d00, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/3/1/u = #136 */
    { 0x0d01, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/3/1/0x1 = #137 */
    { 0x0e7f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/3/2/m = #138 */
    { 0x0e00, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/3/2/u = #139 */
    { 0x0e01, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/3/2/0x1 = #140 */
    { 0x0f7f, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/3/3/m = #141 */
    { 0x0f00, 0x2478, 0xb481, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684) }, /* #2/3/3/u = #142 */
    { 0x0f01, 0x2478, 0x3401, RTFLOAT80U_INIT_C(0,0x9db127187f70d625,2684), RTFLOAT80U_INIT_C(1,0xe6e5fb7e2bbb935,18814), RTFLOAT80U_INIT_IND(1) }, /* #2/3/3/0x1 = #143 */
    { 0x007f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/0/0/m = #144 */
    { 0x0000, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/0/0/u = #145 */
    { 0x0001, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/0/0/0x1 = #146 */
    { 0x017f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/0/1/m = #147 */
    { 0x0100, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/0/1/u = #148 */
    { 0x0101, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/0/1/0x1 = #149 */
    { 0x027f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/0/2/m = #150 */
    { 0x0200, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/0/2/u = #151 */
    { 0x0201, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/0/2/0x1 = #152 */
    { 0x037f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/0/3/m = #153 */
    { 0x0300, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/0/3/u = #154 */
    { 0x0301, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/0/3/0x1 = #155 */
    { 0x047f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/1/0/m = #156 */
    { 0x0400, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/1/0/u = #157 */
    { 0x0401, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/1/0/0x1 = #158 */
    { 0x057f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/1/1/m = #159 */
    { 0x0500, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/1/1/u = #160 */
    { 0x0501, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/1/1/0x1 = #161 */
    { 0x067f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/1/2/m = #162 */
    { 0x0600, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/1/2/u = #163 */
    { 0x0601, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/1/2/0x1 = #164 */
    { 0x077f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/1/3/m = #165 */
    { 0x0700, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/1/3/u = #166 */
    { 0x0701, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/1/3/0x1 = #167 */
    { 0x087f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/2/0/m = #168 */
    { 0x0800, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/2/0/u = #169 */
    { 0x0801, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/2/0/0x1 = #170 */
    { 0x097f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/2/1/m = #171 */
    { 0x0900, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/2/1/u = #172 */
    { 0x0901, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/2/1/0x1 = #173 */
    { 0x0a7f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/2/2/m = #174 */
    { 0x0a00, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/2/2/u = #175 */
    { 0x0a01, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/2/2/0x1 = #176 */
    { 0x0b7f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/2/3/m = #177 */
    { 0x0b00, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/2/3/u = #178 */
    { 0x0b01, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/2/3/0x1 = #179 */
    { 0x0c7f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/3/0/m = #180 */
    { 0x0c00, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/3/0/u = #181 */
    { 0x0c01, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/3/0/0x1 = #182 */
    { 0x0d7f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/3/1/m = #183 */
    { 0x0d00, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/3/1/u = #184 */
    { 0x0d01, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/3/1/0x1 = #185 */
    { 0x0e7f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/3/2/m = #186 */
    { 0x0e00, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/3/2/u = #187 */
    { 0x0e01, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/3/2/0x1 = #188 */
    { 0x0f7f, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/3/3/m = #189 */
    { 0x0f00, 0x52dc, 0xf081, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055) }, /* #3/3/3/u = #190 */
    { 0x0f01, 0x52dc, 0x7001, RTFLOAT80U_INIT_C(0,0xc112ef2ad3e706a8,21055), RTFLOAT80U_INIT_C(0,0x9a14977ac0c08e34,32767), RTFLOAT80U_INIT_C(0,0xda14977ac0c08e34,32767) }, /* #3/3/3/0x1 = #191 */
    { 0x007f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/0/0/m = #192 */
    { 0x0000, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/0/0/u = #193 */
    { 0x017f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/0/1/m = #194 */
    { 0x0100, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/0/1/u = #195 */
    { 0x027f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/0/2/m = #196 */
    { 0x0200, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/0/2/u = #197 */
    { 0x037f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/0/3/m = #198 */
    { 0x0300, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/0/3/u = #199 */
    { 0x047f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/1/0/m = #200 */
    { 0x0400, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/1/0/u = #201 */
    { 0x057f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/1/1/m = #202 */
    { 0x0500, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/1/1/u = #203 */
    { 0x067f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/1/2/m = #204 */
    { 0x0600, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/1/2/u = #205 */
    { 0x077f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/1/3/m = #206 */
    { 0x0700, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/1/3/u = #207 */
    { 0x087f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/2/0/m = #208 */
    { 0x0800, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/2/0/u = #209 */
    { 0x097f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/2/1/m = #210 */
    { 0x0900, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/2/1/u = #211 */
    { 0x0a7f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/2/2/m = #212 */
    { 0x0a00, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/2/2/u = #213 */
    { 0x0b7f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/2/3/m = #214 */
    { 0x0b00, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/2/3/u = #215 */
    { 0x0c7f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/3/0/m = #216 */
    { 0x0c00, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/3/0/u = #217 */
    { 0x0d7f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/3/1/m = #218 */
    { 0x0d00, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/3/1/u = #219 */
    { 0x0e7f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/3/2/m = #220 */
    { 0x0e00, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/3/2/u = #221 */
    { 0x0f7f, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/3/3/m = #222 */
    { 0x0f00, 0xee6a, 0x7400, RTFLOAT80U_INIT_C(1,0xb6ce4fef48879004,20050), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767), RTFLOAT80U_INIT_C(1,0xdf8fc90198fc3f20,32767) }, /* #4/3/3/u = #223 */
    { 0x007f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/0/m = #224 */
    { 0x0000, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/0/0/u = #225 */
    { 0x0001, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/0/0x1 = #226 */
    { 0x017f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/1/m = #227 */
    { 0x0100, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/0/1/u = #228 */
    { 0x0101, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/1/0x1 = #229 */
    { 0x027f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/2/m = #230 */
    { 0x0200, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/0/2/u = #231 */
    { 0x0201, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/2/0x1 = #232 */
    { 0x037f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/3/m = #233 */
    { 0x0300, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/0/3/u = #234 */
    { 0x0301, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/0/3/0x1 = #235 */
    { 0x047f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/0/m = #236 */
    { 0x0400, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/1/0/u = #237 */
    { 0x0401, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/0/0x1 = #238 */
    { 0x057f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/1/m = #239 */
    { 0x0500, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/1/1/u = #240 */
    { 0x0501, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/1/0x1 = #241 */
    { 0x067f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/2/m = #242 */
    { 0x0600, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/1/2/u = #243 */
    { 0x0601, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/2/0x1 = #244 */
    { 0x077f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/3/m = #245 */
    { 0x0700, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/1/3/u = #246 */
    { 0x0701, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/1/3/0x1 = #247 */
    { 0x087f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/0/m = #248 */
    { 0x0800, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/2/0/u = #249 */
    { 0x0801, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/0/0x1 = #250 */
    { 0x097f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/1/m = #251 */
    { 0x0900, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/2/1/u = #252 */
    { 0x0901, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/1/0x1 = #253 */
    { 0x0a7f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/2/m = #254 */
    { 0x0a00, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/2/2/u = #255 */
    { 0x0a01, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/2/0x1 = #256 */
    { 0x0b7f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/3/m = #257 */
    { 0x0b00, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/2/3/u = #258 */
    { 0x0b01, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/2/3/0x1 = #259 */
    { 0x0c7f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/0/m = #260 */
    { 0x0c00, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/3/0/u = #261 */
    { 0x0c01, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/0/0x1 = #262 */
    { 0x0d7f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/1/m = #263 */
    { 0x0d00, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/3/1/u = #264 */
    { 0x0d01, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/1/0x1 = #265 */
    { 0x0e7f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/2/m = #266 */
    { 0x0e00, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/3/2/u = #267 */
    { 0x0e01, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/2/0x1 = #268 */
    { 0x0f7f, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/3/m = #269 */
    { 0x0f00, 0x50f9, 0xf081, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654) }, /* #5/3/3/u = #270 */
    { 0x0f01, 0x50f9, 0x7001, RTFLOAT80U_INIT_C(1,0xefca2168a36d9e12,27654), RTFLOAT80U_INIT_C(0,0x5920c25c77b1e05c,32767), RTFLOAT80U_INIT_IND(1) }, /* #5/3/3/0x1 = #271 */
    { 0x007f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015600000000000,18782) }, /* #6/0/0/m = #272 */
    { 0x0000, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/0/u = #273 */
    { 0x0022, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015600000000000,18782) }, /* #6/0/0/0x22 = #274 */
    { 0x0020, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/0/u0x2 = #275 */
    { 0x0002, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015600000000000,18782) }, /* #6/0/0/u0x20 = #276 */
    { 0x017f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/1/m = #277 */
    { 0x0100, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/1/u = #278 */
    { 0x0122, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/1/0x22 = #279 */
    { 0x0120, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/1/u0x2 = #280 */
    { 0x0102, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/1/u0x20 = #281 */
    { 0x027f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b000,18782) }, /* #6/0/2/m = #282 */
    { 0x0200, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/2/u = #283 */
    { 0x0222, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b000,18782) }, /* #6/0/2/0x22 = #284 */
    { 0x0220, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/2/u0x2 = #285 */
    { 0x0202, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b000,18782) }, /* #6/0/2/u0x20 = #286 */
    { 0x037f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/3/m = #287 */
    { 0x0300, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/3/u = #288 */
    { 0x0322, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/3/0x22 = #289 */
    { 0x0320, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/3/u0x2 = #290 */
    { 0x0302, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/0/3/u0x20 = #291 */
    { 0x047f, 0x5902, 0x7322, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015610000000000,18782) }, /* #6/1/0/m = #292 */
    { 0x0400, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/1/0/u = #293 */
    { 0x0422, 0x5902, 0x7322, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015610000000000,18782) }, /* #6/1/0/0x22 = #294 */
    { 0x0420, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/1/0/u0x2 = #295 */
    { 0x0402, 0x5902, 0xf3a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015610000000000,18782) }, /* #6/1/0/u0x20 = #296 */
    { 0x057f, 0x5902, 0x7322, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b094,18782) }, /* #6/1/1/m = #297 */
    { 0x0500, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/1/1/u = #298 */
    { 0x0522, 0x5902, 0x7322, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b094,18782) }, /* #6/1/1/0x22 = #299 */
    { 0x0520, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/1/1/u0x2 = #300 */
    { 0x0502, 0x5902, 0xf3a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b094,18782) }, /* #6/1/1/u0x20 = #301 */
    { 0x067f, 0x5902, 0x7322, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b800,18782) }, /* #6/1/2/m = #302 */
    { 0x0600, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/1/2/u = #303 */
    { 0x0622, 0x5902, 0x7322, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b800,18782) }, /* #6/1/2/0x22 = #304 */
    { 0x0620, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/1/2/u0x2 = #305 */
    { 0x0602, 0x5902, 0xf3a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b800,18782) }, /* #6/1/2/u0x20 = #306 */
    { 0x077f, 0x5902, 0x7322, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b094,18782) }, /* #6/1/3/m = #307 */
    { 0x0700, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/1/3/u = #308 */
    { 0x0722, 0x5902, 0x7322, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b094,18782) }, /* #6/1/3/0x22 = #309 */
    { 0x0720, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/1/3/u0x2 = #310 */
    { 0x0702, 0x5902, 0xf3a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b094,18782) }, /* #6/1/3/u0x20 = #311 */
    { 0x087f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015600000000000,18782) }, /* #6/2/0/m = #312 */
    { 0x0800, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/0/u = #313 */
    { 0x0822, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015600000000000,18782) }, /* #6/2/0/0x22 = #314 */
    { 0x0820, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/0/u0x2 = #315 */
    { 0x0802, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015600000000000,18782) }, /* #6/2/0/u0x20 = #316 */
    { 0x097f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/1/m = #317 */
    { 0x0900, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/1/u = #318 */
    { 0x0922, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/1/0x22 = #319 */
    { 0x0920, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/1/u0x2 = #320 */
    { 0x0902, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/1/u0x20 = #321 */
    { 0x0a7f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b000,18782) }, /* #6/2/2/m = #322 */
    { 0x0a00, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/2/u = #323 */
    { 0x0a22, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b000,18782) }, /* #6/2/2/0x22 = #324 */
    { 0x0a20, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/2/u0x2 = #325 */
    { 0x0a02, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b000,18782) }, /* #6/2/2/u0x20 = #326 */
    { 0x0b7f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/3/m = #327 */
    { 0x0b00, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/3/u = #328 */
    { 0x0b22, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/3/0x22 = #329 */
    { 0x0b20, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/3/u0x2 = #330 */
    { 0x0b02, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/2/3/u0x20 = #331 */
    { 0x0c7f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015600000000000,18782) }, /* #6/3/0/m = #332 */
    { 0x0c00, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/0/u = #333 */
    { 0x0c22, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015600000000000,18782) }, /* #6/3/0/0x22 = #334 */
    { 0x0c20, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/0/u0x2 = #335 */
    { 0x0c02, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015600000000000,18782) }, /* #6/3/0/u0x20 = #336 */
    { 0x0d7f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/1/m = #337 */
    { 0x0d00, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/1/u = #338 */
    { 0x0d22, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/1/0x22 = #339 */
    { 0x0d20, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/1/u0x2 = #340 */
    { 0x0d02, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/1/u0x20 = #341 */
    { 0x0e7f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b000,18782) }, /* #6/3/2/m = #342 */
    { 0x0e00, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/2/u = #343 */
    { 0x0e22, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b000,18782) }, /* #6/3/2/0x22 = #344 */
    { 0x0e20, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/2/u0x2 = #345 */
    { 0x0e02, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b000,18782) }, /* #6/3/2/u0x20 = #346 */
    { 0x0f7f, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/3/m = #347 */
    { 0x0f00, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/3/u = #348 */
    { 0x0f22, 0x5902, 0x7122, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/3/0x22 = #349 */
    { 0x0f20, 0x5902, 0xf182, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/3/u0x2 = #350 */
    { 0x0f02, 0x5902, 0xf1a2, RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782), RTFLOAT80U_INIT_C(1,0xe2aa55d2182f941e,0), RTFLOAT80U_INIT_C(1,0xe015603c88c1b093,18782) }, /* #6/3/3/u0x20 = #351 */
    { 0x007f, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad0000000000,6518) }, /* #7/0/0/m = #352 */
    { 0x0000, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/0/u = #353 */
    { 0x0022, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad0000000000,6518) }, /* #7/0/0/0x22 = #354 */
    { 0x0020, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/0/u0x2 = #355 */
    { 0x0002, 0x23fc, 0xb1a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad0000000000,6518) }, /* #7/0/0/u0x20 = #356 */
    { 0x017f, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/1/m = #357 */
    { 0x0100, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/1/u = #358 */
    { 0x0122, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/1/0x22 = #359 */
    { 0x0120, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/1/u0x2 = #360 */
    { 0x0102, 0x23fc, 0xb1a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/1/u0x20 = #361 */
    { 0x027f, 0x23fc, 0x3322, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2f000,6518) }, /* #7/0/2/m = #362 */
    { 0x0200, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/2/u = #363 */
    { 0x0222, 0x23fc, 0x3322, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2f000,6518) }, /* #7/0/2/0x22 = #364 */
    { 0x0220, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/2/u0x2 = #365 */
    { 0x0202, 0x23fc, 0xb3a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2f000,6518) }, /* #7/0/2/u0x20 = #366 */
    { 0x037f, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/3/m = #367 */
    { 0x0300, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/3/u = #368 */
    { 0x0322, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/3/0x22 = #369 */
    { 0x0320, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/3/u0x2 = #370 */
    { 0x0302, 0x23fc, 0xb1a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/0/3/u0x20 = #371 */
    { 0x047f, 0x23fc, 0x3322, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baae0000000000,6518) }, /* #7/1/0/m = #372 */
    { 0x0400, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/1/0/u = #373 */
    { 0x0422, 0x23fc, 0x3322, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baae0000000000,6518) }, /* #7/1/0/0x22 = #374 */
    { 0x0420, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/1/0/u0x2 = #375 */
    { 0x0402, 0x23fc, 0xb3a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baae0000000000,6518) }, /* #7/1/0/u0x20 = #376 */
    { 0x057f, 0x23fc, 0x3322, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec69,6518) }, /* #7/1/1/m = #377 */
    { 0x0500, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/1/1/u = #378 */
    { 0x0522, 0x23fc, 0x3322, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec69,6518) }, /* #7/1/1/0x22 = #379 */
    { 0x0520, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/1/1/u0x2 = #380 */
    { 0x0502, 0x23fc, 0xb3a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec69,6518) }, /* #7/1/1/u0x20 = #381 */
    { 0x067f, 0x23fc, 0x3322, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2f000,6518) }, /* #7/1/2/m = #382 */
    { 0x0600, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/1/2/u = #383 */
    { 0x0622, 0x23fc, 0x3322, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2f000,6518) }, /* #7/1/2/0x22 = #384 */
    { 0x0620, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/1/2/u0x2 = #385 */
    { 0x0602, 0x23fc, 0xb3a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2f000,6518) }, /* #7/1/2/u0x20 = #386 */
    { 0x077f, 0x23fc, 0x3322, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec69,6518) }, /* #7/1/3/m = #387 */
    { 0x0700, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/1/3/u = #388 */
    { 0x0722, 0x23fc, 0x3322, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec69,6518) }, /* #7/1/3/0x22 = #389 */
    { 0x0720, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/1/3/u0x2 = #390 */
    { 0x0702, 0x23fc, 0xb3a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec69,6518) }, /* #7/1/3/u0x20 = #391 */
    { 0x087f, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad0000000000,6518) }, /* #7/2/0/m = #392 */
    { 0x0800, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/0/u = #393 */
    { 0x0822, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad0000000000,6518) }, /* #7/2/0/0x22 = #394 */
    { 0x0820, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/0/u0x2 = #395 */
    { 0x0802, 0x23fc, 0xb1a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad0000000000,6518) }, /* #7/2/0/u0x20 = #396 */
    { 0x097f, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/1/m = #397 */
    { 0x0900, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/1/u = #398 */
    { 0x0922, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/1/0x22 = #399 */
    { 0x0920, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/1/u0x2 = #400 */
    { 0x0902, 0x23fc, 0xb1a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/1/u0x20 = #401 */
    { 0x0a7f, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2e800,6518) }, /* #7/2/2/m = #402 */
    { 0x0a00, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/2/u = #403 */
    { 0x0a22, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2e800,6518) }, /* #7/2/2/0x22 = #404 */
    { 0x0a20, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/2/u0x2 = #405 */
    { 0x0a02, 0x23fc, 0xb1a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2e800,6518) }, /* #7/2/2/u0x20 = #406 */
    { 0x0b7f, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/3/m = #407 */
    { 0x0b00, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/3/u = #408 */
    { 0x0b22, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/3/0x22 = #409 */
    { 0x0b20, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/3/u0x2 = #410 */
    { 0x0b02, 0x23fc, 0xb1a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/2/3/u0x20 = #411 */
    { 0x0c7f, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad0000000000,6518) }, /* #7/3/0/m = #412 */
    { 0x0c00, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/0/u = #413 */
    { 0x0c22, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad0000000000,6518) }, /* #7/3/0/0x22 = #414 */
    { 0x0c20, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/0/u0x2 = #415 */
    { 0x0c02, 0x23fc, 0xb1a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad0000000000,6518) }, /* #7/3/0/u0x20 = #416 */
    { 0x0d7f, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/1/m = #417 */
    { 0x0d00, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/1/u = #418 */
    { 0x0d22, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/1/0x22 = #419 */
    { 0x0d20, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/1/u0x2 = #420 */
    { 0x0d02, 0x23fc, 0xb1a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/1/u0x20 = #421 */
    { 0x0e7f, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2e800,6518) }, /* #7/3/2/m = #422 */
    { 0x0e00, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/2/u = #423 */
    { 0x0e22, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2e800,6518) }, /* #7/3/2/0x22 = #424 */
    { 0x0e20, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/2/u0x2 = #425 */
    { 0x0e02, 0x23fc, 0xb1a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2e800,6518) }, /* #7/3/2/u0x20 = #426 */
    { 0x0f7f, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/3/m = #427 */
    { 0x0f00, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/3/u = #428 */
    { 0x0f22, 0x23fc, 0x3122, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/3/0x22 = #429 */
    { 0x0f20, 0x23fc, 0xb182, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/3/u0x2 = #430 */
    { 0x0f02, 0x23fc, 0xb1a2, RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518), RTFLOAT80U_INIT_C(1,0x7e6dd328acae122,0), RTFLOAT80U_INIT_C(1,0xd6baad2dc5d2ec68,6518) }, /* #7/3/3/u0x20 = #431 */
    { 0x007f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/0/0/m = #432 */
    { 0x0000, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/0/0/u = #433 */
    { 0x017f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/0/1/m = #434 */
    { 0x0100, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/0/1/u = #435 */
    { 0x027f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/0/2/m = #436 */
    { 0x0200, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/0/2/u = #437 */
    { 0x037f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/0/3/m = #438 */
    { 0x0300, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/0/3/u = #439 */
    { 0x047f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/1/0/m = #440 */
    { 0x0400, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/1/0/u = #441 */
    { 0x057f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/1/1/m = #442 */
    { 0x0500, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/1/1/u = #443 */
    { 0x067f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/1/2/m = #444 */
    { 0x0600, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/1/2/u = #445 */
    { 0x077f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/1/3/m = #446 */
    { 0x0700, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/1/3/u = #447 */
    { 0x087f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/2/0/m = #448 */
    { 0x0800, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/2/0/u = #449 */
    { 0x097f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/2/1/m = #450 */
    { 0x0900, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/2/1/u = #451 */
    { 0x0a7f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/2/2/m = #452 */
    { 0x0a00, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/2/2/u = #453 */
    { 0x0b7f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/2/3/m = #454 */
    { 0x0b00, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/2/3/u = #455 */
    { 0x0c7f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/3/0/m = #456 */
    { 0x0c00, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/3/0/u = #457 */
    { 0x0d7f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/3/1/m = #458 */
    { 0x0d00, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/3/1/u = #459 */
    { 0x0e7f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/3/2/m = #460 */
    { 0x0e00, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/3/2/u = #461 */
    { 0x0f7f, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/3/3/m = #462 */
    { 0x0f00, 0x103f, 0x3000, RTFLOAT80U_INIT_C(0,0x9abefbf6441ab5b1,6201), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #8/3/3/u = #463 */
    { 0x007f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/0/0/m = #464 */
    { 0x0000, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/0/0/u = #465 */
    { 0x017f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/0/1/m = #466 */
    { 0x0100, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/0/1/u = #467 */
    { 0x027f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/0/2/m = #468 */
    { 0x0200, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/0/2/u = #469 */
    { 0x037f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/0/3/m = #470 */
    { 0x0300, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/0/3/u = #471 */
    { 0x047f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/1/0/m = #472 */
    { 0x0400, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/1/0/u = #473 */
    { 0x057f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/1/1/m = #474 */
    { 0x0500, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/1/1/u = #475 */
    { 0x067f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/1/2/m = #476 */
    { 0x0600, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/1/2/u = #477 */
    { 0x077f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/1/3/m = #478 */
    { 0x0700, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/1/3/u = #479 */
    { 0x087f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/2/0/m = #480 */
    { 0x0800, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/2/0/u = #481 */
    { 0x097f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/2/1/m = #482 */
    { 0x0900, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/2/1/u = #483 */
    { 0x0a7f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/2/2/m = #484 */
    { 0x0a00, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/2/2/u = #485 */
    { 0x0b7f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/2/3/m = #486 */
    { 0x0b00, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/2/3/u = #487 */
    { 0x0c7f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/3/0/m = #488 */
    { 0x0c00, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/3/0/u = #489 */
    { 0x0d7f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/3/1/m = #490 */
    { 0x0d00, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/3/1/u = #491 */
    { 0x0e7f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/3/2/m = #492 */
    { 0x0e00, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/3/2/u = #493 */
    { 0x0f7f, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/3/3/m = #494 */
    { 0x0f00, 0x55df, 0x7500, RTFLOAT80U_INIT_C(1,0xb8c897e16690cca5,18076), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #9/3/3/u = #495 */
    { 0x007f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/0/m = #496 */
    { 0x0000, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/0/0/u = #497 */
    { 0x0001, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/0/0x1 = #498 */
    { 0x017f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/1/m = #499 */
    { 0x0100, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/0/1/u = #500 */
    { 0x0101, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/1/0x1 = #501 */
    { 0x027f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/2/m = #502 */
    { 0x0200, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/0/2/u = #503 */
    { 0x0201, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/2/0x1 = #504 */
    { 0x037f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/3/m = #505 */
    { 0x0300, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/0/3/u = #506 */
    { 0x0301, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/3/0x1 = #507 */
    { 0x047f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/0/m = #508 */
    { 0x0400, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/1/0/u = #509 */
    { 0x0401, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/0/0x1 = #510 */
    { 0x057f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/1/m = #511 */
    { 0x0500, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/1/1/u = #512 */
    { 0x0501, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/1/0x1 = #513 */
    { 0x067f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/2/m = #514 */
    { 0x0600, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/1/2/u = #515 */
    { 0x0601, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/2/0x1 = #516 */
    { 0x077f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/3/m = #517 */
    { 0x0700, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/1/3/u = #518 */
    { 0x0701, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/3/0x1 = #519 */
    { 0x087f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/0/m = #520 */
    { 0x0800, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/2/0/u = #521 */
    { 0x0801, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/0/0x1 = #522 */
    { 0x097f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/1/m = #523 */
    { 0x0900, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/2/1/u = #524 */
    { 0x0901, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/1/0x1 = #525 */
    { 0x0a7f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/2/m = #526 */
    { 0x0a00, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/2/2/u = #527 */
    { 0x0a01, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/2/0x1 = #528 */
    { 0x0b7f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/3/m = #529 */
    { 0x0b00, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/2/3/u = #530 */
    { 0x0b01, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/3/0x1 = #531 */
    { 0x0c7f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/0/m = #532 */
    { 0x0c00, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/3/0/u = #533 */
    { 0x0c01, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/0/0x1 = #534 */
    { 0x0d7f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/1/m = #535 */
    { 0x0d00, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/3/1/u = #536 */
    { 0x0d01, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/1/0x1 = #537 */
    { 0x0e7f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/2/m = #538 */
    { 0x0e00, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/3/2/u = #539 */
    { 0x0e01, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/2/0x1 = #540 */
    { 0x0f7f, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/3/m = #541 */
    { 0x0f00, 0x2605, 0xb481, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422) }, /* #10/3/3/u = #542 */
    { 0x0f01, 0x2605, 0x3401, RTFLOAT80U_INIT_C(1,0x824395d648414cf2,27422), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/3/0x1 = #543 */
    { 0x007f, 0xf6c5, 0x7620, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011d0000000000,12330) }, /* #11/0/0/m = #544 */
    { 0x0000, 0xf6c5, 0xf6a0, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011d0000000000,12330) }, /* #11/0/0/u = #545 */
    { 0x0020, 0xf6c5, 0x7620, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011d0000000000,12330) }, /* #11/0/0/0x20 = #546 */
    { 0x017f, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/0/1/m = #547 */
    { 0x0100, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/0/1/u = #548 */
    { 0x027f, 0xf6c5, 0x7620, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7f000,12330) }, /* #11/0/2/m = #549 */
    { 0x0200, 0xf6c5, 0xf6a0, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7f000,12330) }, /* #11/0/2/u = #550 */
    { 0x0220, 0xf6c5, 0x7620, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7f000,12330) }, /* #11/0/2/0x20 = #551 */
    { 0x037f, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/0/3/m = #552 */
    { 0x0300, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/0/3/u = #553 */
    { 0x047f, 0xf6c5, 0x7420, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c0000000000,12330) }, /* #11/1/0/m = #554 */
    { 0x0400, 0xf6c5, 0xf4a0, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c0000000000,12330) }, /* #11/1/0/u = #555 */
    { 0x0420, 0xf6c5, 0x7420, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c0000000000,12330) }, /* #11/1/0/0x20 = #556 */
    { 0x057f, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/1/1/m = #557 */
    { 0x0500, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/1/1/u = #558 */
    { 0x067f, 0xf6c5, 0x7420, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7e800,12330) }, /* #11/1/2/m = #559 */
    { 0x0600, 0xf6c5, 0xf4a0, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7e800,12330) }, /* #11/1/2/u = #560 */
    { 0x0620, 0xf6c5, 0x7420, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7e800,12330) }, /* #11/1/2/0x20 = #561 */
    { 0x077f, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/1/3/m = #562 */
    { 0x0700, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/1/3/u = #563 */
    { 0x087f, 0xf6c5, 0x7620, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011d0000000000,12330) }, /* #11/2/0/m = #564 */
    { 0x0800, 0xf6c5, 0xf6a0, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011d0000000000,12330) }, /* #11/2/0/u = #565 */
    { 0x0820, 0xf6c5, 0x7620, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011d0000000000,12330) }, /* #11/2/0/0x20 = #566 */
    { 0x097f, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/2/1/m = #567 */
    { 0x0900, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/2/1/u = #568 */
    { 0x0a7f, 0xf6c5, 0x7620, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7f000,12330) }, /* #11/2/2/m = #569 */
    { 0x0a00, 0xf6c5, 0xf6a0, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7f000,12330) }, /* #11/2/2/u = #570 */
    { 0x0a20, 0xf6c5, 0x7620, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7f000,12330) }, /* #11/2/2/0x20 = #571 */
    { 0x0b7f, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/2/3/m = #572 */
    { 0x0b00, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/2/3/u = #573 */
    { 0x0c7f, 0xf6c5, 0x7420, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c0000000000,12330) }, /* #11/3/0/m = #574 */
    { 0x0c00, 0xf6c5, 0xf4a0, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c0000000000,12330) }, /* #11/3/0/u = #575 */
    { 0x0c20, 0xf6c5, 0x7420, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c0000000000,12330) }, /* #11/3/0/0x20 = #576 */
    { 0x0d7f, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/3/1/m = #577 */
    { 0x0d00, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/3/1/u = #578 */
    { 0x0e7f, 0xf6c5, 0x7420, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7e800,12330) }, /* #11/3/2/m = #579 */
    { 0x0e00, 0xf6c5, 0xf4a0, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7e800,12330) }, /* #11/3/2/u = #580 */
    { 0x0e20, 0xf6c5, 0x7420, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7e800,12330) }, /* #11/3/2/0x20 = #581 */
    { 0x0f7f, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/3/3/m = #582 */
    { 0x0f00, 0xf6c5, 0x7400, RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xa3011c95dbc7ecc8,12330) }, /* #11/3/3/u = #583 */
    { 0x007f, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/0/0/m = #584 */
    { 0x0000, 0x4df7, 0xf7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/0/0/u = #585 */
    { 0x0020, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/0/0/0x20 = #586 */
    { 0x017f, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/0/1/m = #587 */
    { 0x0100, 0x4df7, 0xf7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/0/1/u = #588 */
    { 0x0120, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/0/1/0x20 = #589 */
    { 0x027f, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/0/2/m = #590 */
    { 0x0200, 0x4df7, 0xf7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/0/2/u = #591 */
    { 0x0220, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/0/2/0x20 = #592 */
    { 0x037f, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/0/3/m = #593 */
    { 0x0300, 0x4df7, 0xf7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/0/3/u = #594 */
    { 0x0320, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/0/3/0x20 = #595 */
    { 0x047f, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32754) }, /* #12/1/0/m = #596 */
    { 0x0400, 0x4df7, 0xf5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32754) }, /* #12/1/0/u = #597 */
    { 0x0420, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32754) }, /* #12/1/0/0x20 = #598 */
    { 0x057f, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/1/1/m = #599 */
    { 0x0500, 0x4df7, 0xf5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/1/1/u = #600 */
    { 0x0520, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/1/1/0x20 = #601 */
    { 0x067f, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32754) }, /* #12/1/2/m = #602 */
    { 0x0600, 0x4df7, 0xf5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32754) }, /* #12/1/2/u = #603 */
    { 0x0620, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32754) }, /* #12/1/2/0x20 = #604 */
    { 0x077f, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/1/3/m = #605 */
    { 0x0700, 0x4df7, 0xf5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/1/3/u = #606 */
    { 0x0720, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/1/3/0x20 = #607 */
    { 0x087f, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/2/0/m = #608 */
    { 0x0800, 0x4df7, 0xf7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/2/0/u = #609 */
    { 0x0820, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/2/0/0x20 = #610 */
    { 0x097f, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/2/1/m = #611 */
    { 0x0900, 0x4df7, 0xf7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/2/1/u = #612 */
    { 0x0920, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/2/1/0x20 = #613 */
    { 0x0a7f, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/2/2/m = #614 */
    { 0x0a00, 0x4df7, 0xf7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/2/2/u = #615 */
    { 0x0a20, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0x8000000000000000,32755) }, /* #12/2/2/0x20 = #616 */
    { 0x0b7f, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/2/3/m = #617 */
    { 0x0b00, 0x4df7, 0xf7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/2/3/u = #618 */
    { 0x0b20, 0x4df7, 0x7720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754) }, /* #12/2/3/0x20 = #619 */
    { 0x0c7f, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32754) }, /* #12/3/0/m = #620 */
    { 0x0c00, 0x4df7, 0xf5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32754) }, /* #12/3/0/u = #621 */
    { 0x0c20, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32754) }, /* #12/3/0/0x20 = #622 */
    { 0x0d7f, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/3/1/m = #623 */
    { 0x0d00, 0x4df7, 0xf5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/3/1/u = #624 */
    { 0x0d20, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/3/1/0x20 = #625 */
    { 0x0e7f, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32754) }, /* #12/3/2/m = #626 */
    { 0x0e00, 0x4df7, 0xf5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32754) }, /* #12/3/2/u = #627 */
    { 0x0e20, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32754) }, /* #12/3/2/0x20 = #628 */
    { 0x0f7f, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/3/3/m = #629 */
    { 0x0f00, 0x4df7, 0xf5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/3/3/u = #630 */
    { 0x0f20, 0x4df7, 0x7520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32754), RTFLOAT80U_INIT_C(1,0x8a7754448e75acf3,5753), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32754) }, /* #12/3/3/0x20 = #631 */
    { 0x007f, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/0/0/m = #632 */
    { 0x0000, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/0/0/u = #633 */
    { 0x0028, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/0/0/0x28 = #634 */
    { 0x0020, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/0/0/u0x8 = #635 */
    { 0x0008, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/0/0/u0x20 = #636 */
    { 0x017f, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/0/1/m = #637 */
    { 0x0100, 0xa1d2, 0xb1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/0/1/u = #638 */
    { 0x0120, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/0/1/0x20 = #639 */
    { 0x027f, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/0/2/m = #640 */
    { 0x0200, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/0/2/u = #641 */
    { 0x0228, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/0/2/0x28 = #642 */
    { 0x0220, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/0/2/u0x8 = #643 */
    { 0x0208, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/0/2/u0x20 = #644 */
    { 0x037f, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/0/3/m = #645 */
    { 0x0300, 0xa1d2, 0xb1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/0/3/u = #646 */
    { 0x0320, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/0/3/0x20 = #647 */
    { 0x047f, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #13/1/0/m = #648 */
    { 0x0400, 0xa1d2, 0xb1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #13/1/0/u = #649 */
    { 0x0420, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #13/1/0/0x20 = #650 */
    { 0x057f, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/1/1/m = #651 */
    { 0x0500, 0xa1d2, 0xb1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/1/1/u = #652 */
    { 0x0520, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/1/1/0x20 = #653 */
    { 0x067f, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #13/1/2/m = #654 */
    { 0x0600, 0xa1d2, 0xb1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #13/1/2/u = #655 */
    { 0x0620, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #13/1/2/0x20 = #656 */
    { 0x077f, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/1/3/m = #657 */
    { 0x0700, 0xa1d2, 0xb1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/1/3/u = #658 */
    { 0x0720, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/1/3/0x20 = #659 */
    { 0x087f, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/0/m = #660 */
    { 0x0800, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/2/0/u = #661 */
    { 0x0828, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/0/0x28 = #662 */
    { 0x0820, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/2/0/u0x8 = #663 */
    { 0x0808, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/0/u0x20 = #664 */
    { 0x097f, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/1/m = #665 */
    { 0x0900, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/2/1/u = #666 */
    { 0x0928, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/1/0x28 = #667 */
    { 0x0920, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/2/1/u0x8 = #668 */
    { 0x0908, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/1/u0x20 = #669 */
    { 0x0a7f, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/2/m = #670 */
    { 0x0a00, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/2/2/u = #671 */
    { 0x0a28, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/2/0x28 = #672 */
    { 0x0a20, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/2/2/u0x8 = #673 */
    { 0x0a08, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/2/u0x20 = #674 */
    { 0x0b7f, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/3/m = #675 */
    { 0x0b00, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/2/3/u = #676 */
    { 0x0b28, 0xa1d2, 0x3328, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/3/0x28 = #677 */
    { 0x0b20, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #13/2/3/u0x8 = #678 */
    { 0x0b08, 0xa1d2, 0xb3a8, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(0) }, /* #13/2/3/u0x20 = #679 */
    { 0x0c7f, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #13/3/0/m = #680 */
    { 0x0c00, 0xa1d2, 0xb1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #13/3/0/u = #681 */
    { 0x0c20, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #13/3/0/0x20 = #682 */
    { 0x0d7f, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/3/1/m = #683 */
    { 0x0d00, 0xa1d2, 0xb1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/3/1/u = #684 */
    { 0x0d20, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/3/1/0x20 = #685 */
    { 0x0e7f, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #13/3/2/m = #686 */
    { 0x0e00, 0xa1d2, 0xb1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #13/3/2/u = #687 */
    { 0x0e20, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #13/3/2/0x20 = #688 */
    { 0x0f7f, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/3/3/m = #689 */
    { 0x0f00, 0xa1d2, 0xb1a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/3/3/u = #690 */
    { 0x0f20, 0xa1d2, 0x3120, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,25703), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #13/3/3/0x20 = #691 */
    { 0x007f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/0/0/m = #692 */
    { 0x0000, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/0/0/u = #693 */
    { 0x0001, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/0/0/0x1 = #694 */
    { 0x017f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/0/1/m = #695 */
    { 0x0100, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/0/1/u = #696 */
    { 0x0101, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/0/1/0x1 = #697 */
    { 0x027f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/0/2/m = #698 */
    { 0x0200, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/0/2/u = #699 */
    { 0x0201, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/0/2/0x1 = #700 */
    { 0x037f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/0/3/m = #701 */
    { 0x0300, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/0/3/u = #702 */
    { 0x0301, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/0/3/0x1 = #703 */
    { 0x047f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/1/0/m = #704 */
    { 0x0400, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/1/0/u = #705 */
    { 0x0401, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/1/0/0x1 = #706 */
    { 0x057f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/1/1/m = #707 */
    { 0x0500, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/1/1/u = #708 */
    { 0x0501, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/1/1/0x1 = #709 */
    { 0x067f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/1/2/m = #710 */
    { 0x0600, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/1/2/u = #711 */
    { 0x0601, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/1/2/0x1 = #712 */
    { 0x077f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/1/3/m = #713 */
    { 0x0700, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/1/3/u = #714 */
    { 0x0701, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/1/3/0x1 = #715 */
    { 0x087f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/2/0/m = #716 */
    { 0x0800, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/2/0/u = #717 */
    { 0x0801, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/2/0/0x1 = #718 */
    { 0x097f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/2/1/m = #719 */
    { 0x0900, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/2/1/u = #720 */
    { 0x0901, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/2/1/0x1 = #721 */
    { 0x0a7f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/2/2/m = #722 */
    { 0x0a00, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/2/2/u = #723 */
    { 0x0a01, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/2/2/0x1 = #724 */
    { 0x0b7f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/2/3/m = #725 */
    { 0x0b00, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/2/3/u = #726 */
    { 0x0b01, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/2/3/0x1 = #727 */
    { 0x0c7f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/3/0/m = #728 */
    { 0x0c00, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/3/0/u = #729 */
    { 0x0c01, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/3/0/0x1 = #730 */
    { 0x0d7f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/3/1/m = #731 */
    { 0x0d00, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/3/1/u = #732 */
    { 0x0d01, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/3/1/0x1 = #733 */
    { 0x0e7f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/3/2/m = #734 */
    { 0x0e00, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/3/2/u = #735 */
    { 0x0e01, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/3/2/0x1 = #736 */
    { 0x0f7f, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/3/3/m = #737 */
    { 0x0f00, 0x3fde, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #14/3/3/u = #738 */
    { 0x0f01, 0x3fde, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x679213b9e41c4fec,25894), RTFLOAT80U_INIT_IND(1) }, /* #14/3/3/0x1 = #739 */
    { 0x007f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/0/0/m = #740 */
    { 0x0000, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/0/0/u = #741 */
    { 0x0001, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/0/0/0x1 = #742 */
    { 0x017f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/0/1/m = #743 */
    { 0x0100, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/0/1/u = #744 */
    { 0x0101, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/0/1/0x1 = #745 */
    { 0x027f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/0/2/m = #746 */
    { 0x0200, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/0/2/u = #747 */
    { 0x0201, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/0/2/0x1 = #748 */
    { 0x037f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/0/3/m = #749 */
    { 0x0300, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/0/3/u = #750 */
    { 0x0301, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/0/3/0x1 = #751 */
    { 0x047f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/1/0/m = #752 */
    { 0x0400, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/1/0/u = #753 */
    { 0x0401, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/1/0/0x1 = #754 */
    { 0x057f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/1/1/m = #755 */
    { 0x0500, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/1/1/u = #756 */
    { 0x0501, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/1/1/0x1 = #757 */
    { 0x067f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/1/2/m = #758 */
    { 0x0600, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/1/2/u = #759 */
    { 0x0601, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/1/2/0x1 = #760 */
    { 0x077f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/1/3/m = #761 */
    { 0x0700, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/1/3/u = #762 */
    { 0x0701, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/1/3/0x1 = #763 */
    { 0x087f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/2/0/m = #764 */
    { 0x0800, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/2/0/u = #765 */
    { 0x0801, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/2/0/0x1 = #766 */
    { 0x097f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/2/1/m = #767 */
    { 0x0900, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/2/1/u = #768 */
    { 0x0901, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/2/1/0x1 = #769 */
    { 0x0a7f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/2/2/m = #770 */
    { 0x0a00, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/2/2/u = #771 */
    { 0x0a01, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/2/2/0x1 = #772 */
    { 0x0b7f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/2/3/m = #773 */
    { 0x0b00, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/2/3/u = #774 */
    { 0x0b01, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/2/3/0x1 = #775 */
    { 0x0c7f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/3/0/m = #776 */
    { 0x0c00, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/3/0/u = #777 */
    { 0x0c01, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/3/0/0x1 = #778 */
    { 0x0d7f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/3/1/m = #779 */
    { 0x0d00, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/3/1/u = #780 */
    { 0x0d01, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/3/1/0x1 = #781 */
    { 0x0e7f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/3/2/m = #782 */
    { 0x0e00, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/3/2/u = #783 */
    { 0x0e01, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/3/2/0x1 = #784 */
    { 0x0f7f, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/3/3/m = #785 */
    { 0x0f00, 0x5c29, 0xf481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #15/3/3/u = #786 */
    { 0x0f01, 0x5c29, 0x7401, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xac39ae546e90c802,32767), RTFLOAT80U_INIT_C(1,0xec39ae546e90c802,32767) }, /* #15/3/3/0x1 = #787 */
    { 0x007f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/0/0/m = #788 */
    { 0x0000, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/0/0/u = #789 */
    { 0x017f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/0/1/m = #790 */
    { 0x0100, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/0/1/u = #791 */
    { 0x027f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/0/2/m = #792 */
    { 0x0200, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/0/2/u = #793 */
    { 0x037f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/0/3/m = #794 */
    { 0x0300, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/0/3/u = #795 */
    { 0x047f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/1/0/m = #796 */
    { 0x0400, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/1/0/u = #797 */
    { 0x057f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/1/1/m = #798 */
    { 0x0500, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/1/1/u = #799 */
    { 0x067f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/1/2/m = #800 */
    { 0x0600, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/1/2/u = #801 */
    { 0x077f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/1/3/m = #802 */
    { 0x0700, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/1/3/u = #803 */
    { 0x087f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/2/0/m = #804 */
    { 0x0800, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/2/0/u = #805 */
    { 0x097f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/2/1/m = #806 */
    { 0x0900, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/2/1/u = #807 */
    { 0x0a7f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/2/2/m = #808 */
    { 0x0a00, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/2/2/u = #809 */
    { 0x0b7f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/2/3/m = #810 */
    { 0x0b00, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/2/3/u = #811 */
    { 0x0c7f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/3/0/m = #812 */
    { 0x0c00, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/3/0/u = #813 */
    { 0x0d7f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/3/1/m = #814 */
    { 0x0d00, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/3/1/u = #815 */
    { 0x0e7f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/3/2/m = #816 */
    { 0x0e00, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/3/2/u = #817 */
    { 0x0f7f, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/3/3/m = #818 */
    { 0x0f00, 0xbd1e, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767), RTFLOAT80U_INIT_C(0,0xd22375d5bd82189c,32767) }, /* #16/3/3/u = #819 */
    { 0x007f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/0/m = #820 */
    { 0x0000, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/0/0/u = #821 */
    { 0x0001, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/0/0x1 = #822 */
    { 0x017f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/1/m = #823 */
    { 0x0100, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/0/1/u = #824 */
    { 0x0101, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/1/0x1 = #825 */
    { 0x027f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/2/m = #826 */
    { 0x0200, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/0/2/u = #827 */
    { 0x0201, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/2/0x1 = #828 */
    { 0x037f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/3/m = #829 */
    { 0x0300, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/0/3/u = #830 */
    { 0x0301, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/3/0x1 = #831 */
    { 0x047f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/0/m = #832 */
    { 0x0400, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/1/0/u = #833 */
    { 0x0401, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/0/0x1 = #834 */
    { 0x057f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/1/m = #835 */
    { 0x0500, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/1/1/u = #836 */
    { 0x0501, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/1/0x1 = #837 */
    { 0x067f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/2/m = #838 */
    { 0x0600, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/1/2/u = #839 */
    { 0x0601, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/2/0x1 = #840 */
    { 0x077f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/3/m = #841 */
    { 0x0700, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/1/3/u = #842 */
    { 0x0701, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/3/0x1 = #843 */
    { 0x087f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/0/m = #844 */
    { 0x0800, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/2/0/u = #845 */
    { 0x0801, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/0/0x1 = #846 */
    { 0x097f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/1/m = #847 */
    { 0x0900, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/2/1/u = #848 */
    { 0x0901, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/1/0x1 = #849 */
    { 0x0a7f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/2/m = #850 */
    { 0x0a00, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/2/2/u = #851 */
    { 0x0a01, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/2/0x1 = #852 */
    { 0x0b7f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/3/m = #853 */
    { 0x0b00, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/2/3/u = #854 */
    { 0x0b01, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/3/0x1 = #855 */
    { 0x0c7f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/0/m = #856 */
    { 0x0c00, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/3/0/u = #857 */
    { 0x0c01, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/0/0x1 = #858 */
    { 0x0d7f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/1/m = #859 */
    { 0x0d00, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/3/1/u = #860 */
    { 0x0d01, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/1/0x1 = #861 */
    { 0x0e7f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/2/m = #862 */
    { 0x0e00, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/3/2/u = #863 */
    { 0x0e01, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/2/0x1 = #864 */
    { 0x0f7f, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/3/m = #865 */
    { 0x0f00, 0xafd0, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681) }, /* #17/3/3/u = #866 */
    { 0x0f01, 0xafd0, 0x3501, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,15681), RTFLOAT80U_INIT_C(0,0x1cbc35b1a7307bb8,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/3/0x1 = #867 */
    { 0x007f, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d0000000000,0) }, /* #18/0/0/m = #868 */
    { 0x0000, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/0/0/u = #869 */
    { 0x0032, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d0000000000,0) }, /* #18/0/0/0x32 = #870 */
    { 0x0030, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/0/0/u0x2 = #871 */
    { 0x0022, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a50000000000,24572) }, /* #18/0/0/u0x10 = #872 */
    { 0x0012, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d0000000000,0) }, /* #18/0/0/u0x20 = #873 */
    { 0x017f, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/0/1/m = #874 */
    { 0x0100, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/0/1/u = #875 */
    { 0x0102, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/0/1/0x2 = #876 */
    { 0x0112, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/0/1/0x12[!] = #877 */
    { 0x0110, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/0/1/u0x2 = #878 */
    { 0x0102, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/0/1/u0x10 = #879 */
    { 0x027f, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b3800,0) }, /* #18/0/2/m = #880 */
    { 0x0200, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/0/2/u = #881 */
    { 0x0232, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b3800,0) }, /* #18/0/2/0x32 = #882 */
    { 0x0230, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/0/2/u0x2 = #883 */
    { 0x0222, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673800,24572) }, /* #18/0/2/u0x10 = #884 */
    { 0x0212, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b3800,0) }, /* #18/0/2/u0x20 = #885 */
    { 0x037f, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/0/3/m = #886 */
    { 0x0300, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/0/3/u = #887 */
    { 0x0302, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/0/3/0x2 = #888 */
    { 0x0312, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/0/3/0x12[!] = #889 */
    { 0x0310, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/0/3/u0x2 = #890 */
    { 0x0302, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/0/3/u0x10 = #891 */
    { 0x047f, 0x1db6, 0x3732, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0e0000000000,0) }, /* #18/1/0/m = #892 */
    { 0x0400, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/1/0/u = #893 */
    { 0x0432, 0x1db6, 0x3732, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0e0000000000,0) }, /* #18/1/0/0x32 = #894 */
    { 0x0430, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/1/0/u0x2 = #895 */
    { 0x0422, 0x1db6, 0xb7b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a60000000000,24572) }, /* #18/1/0/u0x10 = #896 */
    { 0x0412, 0x1db6, 0xb7b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0e0000000000,0) }, /* #18/1/0/u0x20 = #897 */
    { 0x057f, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/1/1/m = #898 */
    { 0x0500, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/1/1/u = #899 */
    { 0x0502, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/1/1/0x2 = #900 */
    { 0x0512, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/1/1/0x12[!] = #901 */
    { 0x0510, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/1/1/u0x2 = #902 */
    { 0x0502, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/1/1/u0x10 = #903 */
    { 0x067f, 0x1db6, 0x3732, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b4000,0) }, /* #18/1/2/m = #904 */
    { 0x0600, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/1/2/u = #905 */
    { 0x0632, 0x1db6, 0x3732, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b4000,0) }, /* #18/1/2/0x32 = #906 */
    { 0x0630, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/1/2/u0x2 = #907 */
    { 0x0622, 0x1db6, 0xb7b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f674000,24572) }, /* #18/1/2/u0x10 = #908 */
    { 0x0612, 0x1db6, 0xb7b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b4000,0) }, /* #18/1/2/u0x20 = #909 */
    { 0x077f, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/1/3/m = #910 */
    { 0x0700, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/1/3/u = #911 */
    { 0x0702, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/1/3/0x2 = #912 */
    { 0x0712, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/1/3/0x12[!] = #913 */
    { 0x0710, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/1/3/u0x2 = #914 */
    { 0x0702, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/1/3/u0x10 = #915 */
    { 0x087f, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d0000000000,0) }, /* #18/2/0/m = #916 */
    { 0x0800, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/2/0/u = #917 */
    { 0x0832, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d0000000000,0) }, /* #18/2/0/0x32 = #918 */
    { 0x0830, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/2/0/u0x2 = #919 */
    { 0x0822, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a50000000000,24572) }, /* #18/2/0/u0x10 = #920 */
    { 0x0812, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d0000000000,0) }, /* #18/2/0/u0x20 = #921 */
    { 0x097f, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/2/1/m = #922 */
    { 0x0900, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/2/1/u = #923 */
    { 0x0902, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/2/1/0x2 = #924 */
    { 0x0912, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/2/1/0x12[!] = #925 */
    { 0x0910, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/2/1/u0x2 = #926 */
    { 0x0902, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/2/1/u0x10 = #927 */
    { 0x0a7f, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b3800,0) }, /* #18/2/2/m = #928 */
    { 0x0a00, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/2/2/u = #929 */
    { 0x0a32, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b3800,0) }, /* #18/2/2/0x32 = #930 */
    { 0x0a30, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/2/2/u0x2 = #931 */
    { 0x0a22, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673800,24572) }, /* #18/2/2/u0x10 = #932 */
    { 0x0a12, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b3800,0) }, /* #18/2/2/u0x20 = #933 */
    { 0x0b7f, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/2/3/m = #934 */
    { 0x0b00, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/2/3/u = #935 */
    { 0x0b02, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/2/3/0x2 = #936 */
    { 0x0b12, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/2/3/0x12[!] = #937 */
    { 0x0b10, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/2/3/u0x2 = #938 */
    { 0x0b02, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/2/3/u0x10 = #939 */
    { 0x0c7f, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d0000000000,0) }, /* #18/3/0/m = #940 */
    { 0x0c00, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/3/0/u = #941 */
    { 0x0c32, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d0000000000,0) }, /* #18/3/0/0x32 = #942 */
    { 0x0c30, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/3/0/u0x2 = #943 */
    { 0x0c22, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a50000000000,24572) }, /* #18/3/0/u0x10 = #944 */
    { 0x0c12, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d0000000000,0) }, /* #18/3/0/u0x20 = #945 */
    { 0x0d7f, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/3/1/m = #946 */
    { 0x0d00, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/3/1/u = #947 */
    { 0x0d02, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/3/1/0x2 = #948 */
    { 0x0d12, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/3/1/0x12[!] = #949 */
    { 0x0d10, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/3/1/u0x2 = #950 */
    { 0x0d02, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/3/1/u0x10 = #951 */
    { 0x0e7f, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b3800,0) }, /* #18/3/2/m = #952 */
    { 0x0e00, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/3/2/u = #953 */
    { 0x0e32, 0x1db6, 0x3532, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b3800,0) }, /* #18/3/2/0x32 = #954 */
    { 0x0e30, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/3/2/u0x2 = #955 */
    { 0x0e22, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673800,24572) }, /* #18/3/2/u0x10 = #956 */
    { 0x0e12, 0x1db6, 0xb5b2, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b3800,0) }, /* #18/3/2/u0x20 = #957 */
    { 0x0f7f, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/3/3/m = #958 */
    { 0x0f00, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/3/3/u = #959 */
    { 0x0f02, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/3/3/0x2 = #960 */
    { 0x0f12, 0x1db6, 0x3502, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0x64f0d2aac7b39d0,0) }, /* #18/3/3/0x12[!] = #961 */
    { 0x0f10, 0x1db6, 0xb582, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #18/3/3/u0x2 = #962 */
    { 0x0f02, 0x1db6, 0xb592, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xf9b0f2d55384c62f,0), RTFLOAT80U_INIT_C(1,0xc9e1a5558f673a00,24572) }, /* #18/3/3/u0x10 = #963 */
    { 0x007f, 0xbd39, 0x372a, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/0/0/m = #964 */
    { 0x0000, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/0/u = #965 */
    { 0x002a, 0xbd39, 0x372a, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/0/0/0x2a = #966 */
    { 0x0028, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/0/u0x2 = #967 */
    { 0x0022, 0xbd39, 0xb7aa, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #19/0/0/u0x8 = #968 */
    { 0x000a, 0xbd39, 0xb7aa, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/0/0/u0x20 = #969 */
    { 0x017f, 0xbd39, 0x3722, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/1/m = #970 */
    { 0x0100, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/1/u = #971 */
    { 0x0122, 0xbd39, 0x3722, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/1/0x22 = #972 */
    { 0x0120, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/1/u0x2 = #973 */
    { 0x0102, 0xbd39, 0xb7a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/1/u0x20 = #974 */
    { 0x027f, 0xbd39, 0x372a, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/0/2/m = #975 */
    { 0x0200, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/2/u = #976 */
    { 0x022a, 0xbd39, 0x372a, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/0/2/0x2a = #977 */
    { 0x0228, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/2/u0x2 = #978 */
    { 0x0222, 0xbd39, 0xb7aa, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #19/0/2/u0x8 = #979 */
    { 0x020a, 0xbd39, 0xb7aa, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/0/2/u0x20 = #980 */
    { 0x037f, 0xbd39, 0x3722, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/3/m = #981 */
    { 0x0300, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/3/u = #982 */
    { 0x0322, 0xbd39, 0x3722, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/3/0x22 = #983 */
    { 0x0320, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/3/u0x2 = #984 */
    { 0x0302, 0xbd39, 0xb7a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/0/3/u0x20 = #985 */
    { 0x047f, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #19/1/0/m = #986 */
    { 0x0400, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/1/0/u = #987 */
    { 0x0422, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #19/1/0/0x22 = #988 */
    { 0x0420, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/1/0/u0x2 = #989 */
    { 0x0402, 0xbd39, 0xb5a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #19/1/0/u0x20 = #990 */
    { 0x057f, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/1/1/m = #991 */
    { 0x0500, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/1/1/u = #992 */
    { 0x0522, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/1/1/0x22 = #993 */
    { 0x0520, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/1/1/u0x2 = #994 */
    { 0x0502, 0xbd39, 0xb5a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/1/1/u0x20 = #995 */
    { 0x067f, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #19/1/2/m = #996 */
    { 0x0600, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/1/2/u = #997 */
    { 0x0622, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #19/1/2/0x22 = #998 */
    { 0x0620, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/1/2/u0x2 = #999 */
    { 0x0602, 0xbd39, 0xb5a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #19/1/2/u0x20 = #1000 */
    { 0x077f, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/1/3/m = #1001 */
    { 0x0700, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/1/3/u = #1002 */
    { 0x0722, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/1/3/0x22 = #1003 */
    { 0x0720, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/1/3/u0x2 = #1004 */
    { 0x0702, 0xbd39, 0xb5a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/1/3/u0x20 = #1005 */
    { 0x087f, 0xbd39, 0x372a, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/2/0/m = #1006 */
    { 0x0800, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/0/u = #1007 */
    { 0x082a, 0xbd39, 0x372a, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/2/0/0x2a = #1008 */
    { 0x0828, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/0/u0x2 = #1009 */
    { 0x0822, 0xbd39, 0xb7aa, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #19/2/0/u0x8 = #1010 */
    { 0x080a, 0xbd39, 0xb7aa, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/2/0/u0x20 = #1011 */
    { 0x097f, 0xbd39, 0x3722, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/1/m = #1012 */
    { 0x0900, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/1/u = #1013 */
    { 0x0922, 0xbd39, 0x3722, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/1/0x22 = #1014 */
    { 0x0920, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/1/u0x2 = #1015 */
    { 0x0902, 0xbd39, 0xb7a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/1/u0x20 = #1016 */
    { 0x0a7f, 0xbd39, 0x372a, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/2/2/m = #1017 */
    { 0x0a00, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/2/u = #1018 */
    { 0x0a2a, 0xbd39, 0x372a, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/2/2/0x2a = #1019 */
    { 0x0a28, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/2/u0x2 = #1020 */
    { 0x0a22, 0xbd39, 0xb7aa, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,8191) }, /* #19/2/2/u0x8 = #1021 */
    { 0x0a0a, 0xbd39, 0xb7aa, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_INF(0) }, /* #19/2/2/u0x20 = #1022 */
    { 0x0b7f, 0xbd39, 0x3722, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/3/m = #1023 */
    { 0x0b00, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/3/u = #1024 */
    { 0x0b22, 0xbd39, 0x3722, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/3/0x22 = #1025 */
    { 0x0b20, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/3/u0x2 = #1026 */
    { 0x0b02, 0xbd39, 0xb7a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/2/3/u0x20 = #1027 */
    { 0x0c7f, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #19/3/0/m = #1028 */
    { 0x0c00, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/3/0/u = #1029 */
    { 0x0c22, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #19/3/0/0x22 = #1030 */
    { 0x0c20, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/3/0/u0x2 = #1031 */
    { 0x0c02, 0xbd39, 0xb5a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #19/3/0/u0x20 = #1032 */
    { 0x0d7f, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/3/1/m = #1033 */
    { 0x0d00, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/3/1/u = #1034 */
    { 0x0d22, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/3/1/0x22 = #1035 */
    { 0x0d20, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/3/1/u0x2 = #1036 */
    { 0x0d02, 0xbd39, 0xb5a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/3/1/u0x20 = #1037 */
    { 0x0e7f, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #19/3/2/m = #1038 */
    { 0x0e00, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/3/2/u = #1039 */
    { 0x0e22, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #19/3/2/0x22 = #1040 */
    { 0x0e20, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/3/2/u0x2 = #1041 */
    { 0x0e02, 0xbd39, 0xb5a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #19/3/2/u0x20 = #1042 */
    { 0x0f7f, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/3/3/m = #1043 */
    { 0x0f00, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/3/3/u = #1044 */
    { 0x0f22, 0xbd39, 0x3522, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/3/3/0x22 = #1045 */
    { 0x0f20, 0xbd39, 0xb582, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #19/3/3/u0x2 = #1046 */
    { 0x0f02, 0xbd39, 0xb5a2, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x221f05f5347776ce,0), RTFLOAT80U_INIT_C(0,0xfffffffffffffffe,32766) }, /* #19/3/3/u0x20 = #1047 */
    { 0x007f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/0/m = #1048 */
    { 0x0000, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/0/u = #1049 */
    { 0x017f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/1/m = #1050 */
    { 0x0100, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/1/u = #1051 */
    { 0x027f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/2/m = #1052 */
    { 0x0200, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/2/u = #1053 */
    { 0x037f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/3/m = #1054 */
    { 0x0300, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/0/3/u = #1055 */
    { 0x047f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/0/m = #1056 */
    { 0x0400, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/0/u = #1057 */
    { 0x057f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/1/m = #1058 */
    { 0x0500, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/1/u = #1059 */
    { 0x067f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/2/m = #1060 */
    { 0x0600, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/2/u = #1061 */
    { 0x077f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/3/m = #1062 */
    { 0x0700, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/1/3/u = #1063 */
    { 0x087f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/0/m = #1064 */
    { 0x0800, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/0/u = #1065 */
    { 0x097f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/1/m = #1066 */
    { 0x0900, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/1/u = #1067 */
    { 0x0a7f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/2/m = #1068 */
    { 0x0a00, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/2/u = #1069 */
    { 0x0b7f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/3/m = #1070 */
    { 0x0b00, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/2/3/u = #1071 */
    { 0x0c7f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/0/m = #1072 */
    { 0x0c00, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/0/u = #1073 */
    { 0x0d7f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/1/m = #1074 */
    { 0x0d00, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/1/u = #1075 */
    { 0x0e7f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/2/m = #1076 */
    { 0x0e00, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/2/u = #1077 */
    { 0x0f7f, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/3/m = #1078 */
    { 0x0f00, 0x68d2, 0x7000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #20/3/3/u = #1079 */
    { 0x007f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/0/0/m = #1080 */
    { 0x0000, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/0/0/u = #1081 */
    { 0x017f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/0/1/m = #1082 */
    { 0x0100, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/0/1/u = #1083 */
    { 0x027f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/0/2/m = #1084 */
    { 0x0200, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/0/2/u = #1085 */
    { 0x037f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/0/3/m = #1086 */
    { 0x0300, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/0/3/u = #1087 */
    { 0x047f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/1/0/m = #1088 */
    { 0x0400, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/1/0/u = #1089 */
    { 0x057f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/1/1/m = #1090 */
    { 0x0500, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/1/1/u = #1091 */
    { 0x067f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/1/2/m = #1092 */
    { 0x0600, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/1/2/u = #1093 */
    { 0x077f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/1/3/m = #1094 */
    { 0x0700, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/1/3/u = #1095 */
    { 0x087f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/2/0/m = #1096 */
    { 0x0800, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/2/0/u = #1097 */
    { 0x097f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/2/1/m = #1098 */
    { 0x0900, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/2/1/u = #1099 */
    { 0x0a7f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/2/2/m = #1100 */
    { 0x0a00, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/2/2/u = #1101 */
    { 0x0b7f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/2/3/m = #1102 */
    { 0x0b00, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/2/3/u = #1103 */
    { 0x0c7f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/3/0/m = #1104 */
    { 0x0c00, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/3/0/u = #1105 */
    { 0x0d7f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/3/1/m = #1106 */
    { 0x0d00, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/3/1/u = #1107 */
    { 0x0e7f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/3/2/m = #1108 */
    { 0x0e00, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/3/2/u = #1109 */
    { 0x0f7f, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/3/3/m = #1110 */
    { 0x0f00, 0x1824, 0x3000, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #21/3/3/u = #1111 */
    { 0x007f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/0/m = #1112 */
    { 0x0000, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/0/0/u = #1113 */
    { 0x0001, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/0/0x1 = #1114 */
    { 0x017f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/1/m = #1115 */
    { 0x0100, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/0/1/u = #1116 */
    { 0x0101, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/1/0x1 = #1117 */
    { 0x027f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/2/m = #1118 */
    { 0x0200, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/0/2/u = #1119 */
    { 0x0201, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/2/0x1 = #1120 */
    { 0x037f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/3/m = #1121 */
    { 0x0300, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/0/3/u = #1122 */
    { 0x0301, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/3/0x1 = #1123 */
    { 0x047f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/0/m = #1124 */
    { 0x0400, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/1/0/u = #1125 */
    { 0x0401, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/0/0x1 = #1126 */
    { 0x057f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/1/m = #1127 */
    { 0x0500, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/1/1/u = #1128 */
    { 0x0501, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/1/0x1 = #1129 */
    { 0x067f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/2/m = #1130 */
    { 0x0600, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/1/2/u = #1131 */
    { 0x0601, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/2/0x1 = #1132 */
    { 0x077f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/3/m = #1133 */
    { 0x0700, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/1/3/u = #1134 */
    { 0x0701, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/3/0x1 = #1135 */
    { 0x087f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/0/m = #1136 */
    { 0x0800, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/2/0/u = #1137 */
    { 0x0801, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/0/0x1 = #1138 */
    { 0x097f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/1/m = #1139 */
    { 0x0900, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/2/1/u = #1140 */
    { 0x0901, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/1/0x1 = #1141 */
    { 0x0a7f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/2/m = #1142 */
    { 0x0a00, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/2/2/u = #1143 */
    { 0x0a01, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/2/0x1 = #1144 */
    { 0x0b7f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/3/m = #1145 */
    { 0x0b00, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/2/3/u = #1146 */
    { 0x0b01, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/3/0x1 = #1147 */
    { 0x0c7f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/0/m = #1148 */
    { 0x0c00, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/3/0/u = #1149 */
    { 0x0c01, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/0/0x1 = #1150 */
    { 0x0d7f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/1/m = #1151 */
    { 0x0d00, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/3/1/u = #1152 */
    { 0x0d01, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/1/0x1 = #1153 */
    { 0x0e7f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/2/m = #1154 */
    { 0x0e00, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/3/2/u = #1155 */
    { 0x0e01, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/2/0x1 = #1156 */
    { 0x0f7f, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/3/m = #1157 */
    { 0x0f00, 0xb601, 0xb481, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #22/3/3/u = #1158 */
    { 0x0f01, 0xb601, 0x3401, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/3/0x1 = #1159 */
    { 0x007f, 0x2fd5, 0x3720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/0/0/m = #1160 */
    { 0x0000, 0x2fd5, 0xb7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/0/0/u = #1161 */
    { 0x0020, 0x2fd5, 0x3720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/0/0/0x20 = #1162 */
    { 0x017f, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/0/1/m = #1163 */
    { 0x0100, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/0/1/u = #1164 */
    { 0x027f, 0x2fd5, 0x3720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/0/2/m = #1165 */
    { 0x0200, 0x2fd5, 0xb7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/0/2/u = #1166 */
    { 0x0220, 0x2fd5, 0x3720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/0/2/0x20 = #1167 */
    { 0x037f, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/0/3/m = #1168 */
    { 0x0300, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/0/3/u = #1169 */
    { 0x047f, 0x2fd5, 0x3520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32758) }, /* #23/1/0/m = #1170 */
    { 0x0400, 0x2fd5, 0xb5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32758) }, /* #23/1/0/u = #1171 */
    { 0x0420, 0x2fd5, 0x3520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32758) }, /* #23/1/0/0x20 = #1172 */
    { 0x057f, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/1/1/m = #1173 */
    { 0x0500, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/1/1/u = #1174 */
    { 0x067f, 0x2fd5, 0x3520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32758) }, /* #23/1/2/m = #1175 */
    { 0x0600, 0x2fd5, 0xb5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32758) }, /* #23/1/2/u = #1176 */
    { 0x0620, 0x2fd5, 0x3520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32758) }, /* #23/1/2/0x20 = #1177 */
    { 0x077f, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/1/3/m = #1178 */
    { 0x0700, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/1/3/u = #1179 */
    { 0x087f, 0x2fd5, 0x3720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/2/0/m = #1180 */
    { 0x0800, 0x2fd5, 0xb7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/2/0/u = #1181 */
    { 0x0820, 0x2fd5, 0x3720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/2/0/0x20 = #1182 */
    { 0x097f, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/2/1/m = #1183 */
    { 0x0900, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/2/1/u = #1184 */
    { 0x0a7f, 0x2fd5, 0x3720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/2/2/m = #1185 */
    { 0x0a00, 0x2fd5, 0xb7a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/2/2/u = #1186 */
    { 0x0a20, 0x2fd5, 0x3720, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x8000000000000000,32759) }, /* #23/2/2/0x20 = #1187 */
    { 0x0b7f, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/2/3/m = #1188 */
    { 0x0b00, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/2/3/u = #1189 */
    { 0x0c7f, 0x2fd5, 0x3520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32758) }, /* #23/3/0/m = #1190 */
    { 0x0c00, 0x2fd5, 0xb5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32758) }, /* #23/3/0/u = #1191 */
    { 0x0c20, 0x2fd5, 0x3520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32758) }, /* #23/3/0/0x20 = #1192 */
    { 0x0d7f, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/3/1/m = #1193 */
    { 0x0d00, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/3/1/u = #1194 */
    { 0x0e7f, 0x2fd5, 0x3520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32758) }, /* #23/3/2/m = #1195 */
    { 0x0e00, 0x2fd5, 0xb5a0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32758) }, /* #23/3/2/u = #1196 */
    { 0x0e20, 0x2fd5, 0x3520, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32758) }, /* #23/3/2/0x20 = #1197 */
    { 0x0f7f, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/3/3/m = #1198 */
    { 0x0f00, 0x2fd5, 0x3500, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758) }, /* #23/3/3/u = #1199 */
    { 0x007f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/0/0/m = #1200 */
    { 0x0000, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/0/0/u = #1201 */
    { 0x0001, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/0/0/0x1 = #1202 */
    { 0x017f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/0/1/m = #1203 */
    { 0x0100, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/0/1/u = #1204 */
    { 0x0101, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/0/1/0x1 = #1205 */
    { 0x027f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/0/2/m = #1206 */
    { 0x0200, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/0/2/u = #1207 */
    { 0x0201, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/0/2/0x1 = #1208 */
    { 0x037f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/0/3/m = #1209 */
    { 0x0300, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/0/3/u = #1210 */
    { 0x0301, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/0/3/0x1 = #1211 */
    { 0x047f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/1/0/m = #1212 */
    { 0x0400, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/1/0/u = #1213 */
    { 0x0401, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/1/0/0x1 = #1214 */
    { 0x057f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/1/1/m = #1215 */
    { 0x0500, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/1/1/u = #1216 */
    { 0x0501, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/1/1/0x1 = #1217 */
    { 0x067f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/1/2/m = #1218 */
    { 0x0600, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/1/2/u = #1219 */
    { 0x0601, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/1/2/0x1 = #1220 */
    { 0x077f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/1/3/m = #1221 */
    { 0x0700, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/1/3/u = #1222 */
    { 0x0701, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/1/3/0x1 = #1223 */
    { 0x087f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/2/0/m = #1224 */
    { 0x0800, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/2/0/u = #1225 */
    { 0x0801, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/2/0/0x1 = #1226 */
    { 0x097f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/2/1/m = #1227 */
    { 0x0900, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/2/1/u = #1228 */
    { 0x0901, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/2/1/0x1 = #1229 */
    { 0x0a7f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/2/2/m = #1230 */
    { 0x0a00, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/2/2/u = #1231 */
    { 0x0a01, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/2/2/0x1 = #1232 */
    { 0x0b7f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/2/3/m = #1233 */
    { 0x0b00, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/2/3/u = #1234 */
    { 0x0b01, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/2/3/0x1 = #1235 */
    { 0x0c7f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/3/0/m = #1236 */
    { 0x0c00, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/3/0/u = #1237 */
    { 0x0c01, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/3/0/0x1 = #1238 */
    { 0x0d7f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/3/1/m = #1239 */
    { 0x0d00, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/3/1/u = #1240 */
    { 0x0d01, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/3/1/0x1 = #1241 */
    { 0x0e7f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/3/2/m = #1242 */
    { 0x0e00, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/3/2/u = #1243 */
    { 0x0e01, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/3/2/0x1 = #1244 */
    { 0x0f7f, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/3/3/m = #1245 */
    { 0x0f00, 0x607a, 0xf081, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465) }, /* #24/3/3/u = #1246 */
    { 0x0f01, 0x607a, 0x7001, RTFLOAT80U_INIT_C(0,0x6ebb7e106c3b0f48,32465), RTFLOAT80U_INIT_C(1,0xc6766614b0d1a717,858), RTFLOAT80U_INIT_IND(1) }, /* #24/3/3/0x1 = #1247 */
    { 0x007f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/0/0/m = #1248 */
    { 0x0000, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/0/0/u = #1249 */
    { 0x0001, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/0/0/0x1 = #1250 */
    { 0x017f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/0/1/m = #1251 */
    { 0x0100, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/0/1/u = #1252 */
    { 0x0101, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/0/1/0x1 = #1253 */
    { 0x027f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/0/2/m = #1254 */
    { 0x0200, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/0/2/u = #1255 */
    { 0x0201, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/0/2/0x1 = #1256 */
    { 0x037f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/0/3/m = #1257 */
    { 0x0300, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/0/3/u = #1258 */
    { 0x0301, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/0/3/0x1 = #1259 */
    { 0x047f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/1/0/m = #1260 */
    { 0x0400, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/1/0/u = #1261 */
    { 0x0401, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/1/0/0x1 = #1262 */
    { 0x057f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/1/1/m = #1263 */
    { 0x0500, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/1/1/u = #1264 */
    { 0x0501, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/1/1/0x1 = #1265 */
    { 0x067f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/1/2/m = #1266 */
    { 0x0600, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/1/2/u = #1267 */
    { 0x0601, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/1/2/0x1 = #1268 */
    { 0x077f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/1/3/m = #1269 */
    { 0x0700, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/1/3/u = #1270 */
    { 0x0701, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/1/3/0x1 = #1271 */
    { 0x087f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/2/0/m = #1272 */
    { 0x0800, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/2/0/u = #1273 */
    { 0x0801, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/2/0/0x1 = #1274 */
    { 0x097f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/2/1/m = #1275 */
    { 0x0900, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/2/1/u = #1276 */
    { 0x0901, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/2/1/0x1 = #1277 */
    { 0x0a7f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/2/2/m = #1278 */
    { 0x0a00, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/2/2/u = #1279 */
    { 0x0a01, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/2/2/0x1 = #1280 */
    { 0x0b7f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/2/3/m = #1281 */
    { 0x0b00, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/2/3/u = #1282 */
    { 0x0b01, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/2/3/0x1 = #1283 */
    { 0x0c7f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/3/0/m = #1284 */
    { 0x0c00, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/3/0/u = #1285 */
    { 0x0c01, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/3/0/0x1 = #1286 */
    { 0x0d7f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/3/1/m = #1287 */
    { 0x0d00, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/3/1/u = #1288 */
    { 0x0d01, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/3/1/0x1 = #1289 */
    { 0x0e7f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/3/2/m = #1290 */
    { 0x0e00, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/3/2/u = #1291 */
    { 0x0e01, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/3/2/0x1 = #1292 */
    { 0x0f7f, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/3/3/m = #1293 */
    { 0x0f00, 0x1b2f, 0xb181, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697) }, /* #25/3/3/u = #1294 */
    { 0x0f01, 0x1b2f, 0x3101, RTFLOAT80U_INIT_C(1,0x7d074d2dad9af273,18697), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #25/3/3/0x1 = #1295 */
    { 0x007f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/0/0/m = #1296 */
    { 0x0000, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/0/0/u = #1297 */
    { 0x0001, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/0/0/0x1 = #1298 */
    { 0x017f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/0/1/m = #1299 */
    { 0x0100, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/0/1/u = #1300 */
    { 0x0101, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/0/1/0x1 = #1301 */
    { 0x027f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/0/2/m = #1302 */
    { 0x0200, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/0/2/u = #1303 */
    { 0x0201, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/0/2/0x1 = #1304 */
    { 0x037f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/0/3/m = #1305 */
    { 0x0300, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/0/3/u = #1306 */
    { 0x0301, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/0/3/0x1 = #1307 */
    { 0x047f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/1/0/m = #1308 */
    { 0x0400, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/1/0/u = #1309 */
    { 0x0401, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/1/0/0x1 = #1310 */
    { 0x057f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/1/1/m = #1311 */
    { 0x0500, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/1/1/u = #1312 */
    { 0x0501, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/1/1/0x1 = #1313 */
    { 0x067f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/1/2/m = #1314 */
    { 0x0600, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/1/2/u = #1315 */
    { 0x0601, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/1/2/0x1 = #1316 */
    { 0x077f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/1/3/m = #1317 */
    { 0x0700, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/1/3/u = #1318 */
    { 0x0701, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/1/3/0x1 = #1319 */
    { 0x087f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/2/0/m = #1320 */
    { 0x0800, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/2/0/u = #1321 */
    { 0x0801, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/2/0/0x1 = #1322 */
    { 0x097f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/2/1/m = #1323 */
    { 0x0900, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/2/1/u = #1324 */
    { 0x0901, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/2/1/0x1 = #1325 */
    { 0x0a7f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/2/2/m = #1326 */
    { 0x0a00, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/2/2/u = #1327 */
    { 0x0a01, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/2/2/0x1 = #1328 */
    { 0x0b7f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/2/3/m = #1329 */
    { 0x0b00, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/2/3/u = #1330 */
    { 0x0b01, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/2/3/0x1 = #1331 */
    { 0x0c7f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/3/0/m = #1332 */
    { 0x0c00, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/3/0/u = #1333 */
    { 0x0c01, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/3/0/0x1 = #1334 */
    { 0x0d7f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/3/1/m = #1335 */
    { 0x0d00, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/3/1/u = #1336 */
    { 0x0d01, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/3/1/0x1 = #1337 */
    { 0x0e7f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/3/2/m = #1338 */
    { 0x0e00, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/3/2/u = #1339 */
    { 0x0e01, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/3/2/0x1 = #1340 */
    { 0x0f7f, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/3/3/m = #1341 */
    { 0x0f00, 0x94da, 0xb481, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646) }, /* #26/3/3/u = #1342 */
    { 0x0f01, 0x94da, 0x3401, RTFLOAT80U_INIT_C(0,0x4ead135a950d0a9b,11646), RTFLOAT80U_INIT_C(1,0x540c0f51dfd3e95d,8982), RTFLOAT80U_INIT_IND(1) }, /* #26/3/3/0x1 = #1343 */
    { 0x007f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/0/m = #1344 */
    { 0x0000, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/0/0/u = #1345 */
    { 0x0001, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/0/0x1 = #1346 */
    { 0x017f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/1/m = #1347 */
    { 0x0100, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/0/1/u = #1348 */
    { 0x0101, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/1/0x1 = #1349 */
    { 0x027f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/2/m = #1350 */
    { 0x0200, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/0/2/u = #1351 */
    { 0x0201, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/2/0x1 = #1352 */
    { 0x037f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/3/m = #1353 */
    { 0x0300, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/0/3/u = #1354 */
    { 0x0301, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/3/0x1 = #1355 */
    { 0x047f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/0/m = #1356 */
    { 0x0400, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/1/0/u = #1357 */
    { 0x0401, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/0/0x1 = #1358 */
    { 0x057f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/1/m = #1359 */
    { 0x0500, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/1/1/u = #1360 */
    { 0x0501, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/1/0x1 = #1361 */
    { 0x067f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/2/m = #1362 */
    { 0x0600, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/1/2/u = #1363 */
    { 0x0601, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/2/0x1 = #1364 */
    { 0x077f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/3/m = #1365 */
    { 0x0700, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/1/3/u = #1366 */
    { 0x0701, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/3/0x1 = #1367 */
    { 0x087f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/0/m = #1368 */
    { 0x0800, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/2/0/u = #1369 */
    { 0x0801, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/0/0x1 = #1370 */
    { 0x097f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/1/m = #1371 */
    { 0x0900, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/2/1/u = #1372 */
    { 0x0901, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/1/0x1 = #1373 */
    { 0x0a7f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/2/m = #1374 */
    { 0x0a00, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/2/2/u = #1375 */
    { 0x0a01, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/2/0x1 = #1376 */
    { 0x0b7f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/3/m = #1377 */
    { 0x0b00, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/2/3/u = #1378 */
    { 0x0b01, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/3/0x1 = #1379 */
    { 0x0c7f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/0/m = #1380 */
    { 0x0c00, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/3/0/u = #1381 */
    { 0x0c01, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/0/0x1 = #1382 */
    { 0x0d7f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/1/m = #1383 */
    { 0x0d00, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/3/1/u = #1384 */
    { 0x0d01, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/1/0x1 = #1385 */
    { 0x0e7f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/2/m = #1386 */
    { 0x0e00, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/3/2/u = #1387 */
    { 0x0e01, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/2/0x1 = #1388 */
    { 0x0f7f, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/3/m = #1389 */
    { 0x0f00, 0x74ae, 0xf481, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277) }, /* #27/3/3/u = #1390 */
    { 0x0f01, 0x74ae, 0x7401, RTFLOAT80U_INIT_C(1,0x1368723b3faf3fc9,23277), RTFLOAT80U_INIT_C(1,0xbd941bb6b8140753,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/3/0x1 = #1391 */
    { 0x007f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/0/m = #1392 */
    { 0x0000, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/0/0/u = #1393 */
    { 0x0001, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/0/0x1 = #1394 */
    { 0x017f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/1/m = #1395 */
    { 0x0100, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/0/1/u = #1396 */
    { 0x0101, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/1/0x1 = #1397 */
    { 0x027f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/2/m = #1398 */
    { 0x0200, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/0/2/u = #1399 */
    { 0x0201, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/2/0x1 = #1400 */
    { 0x037f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/3/m = #1401 */
    { 0x0300, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/0/3/u = #1402 */
    { 0x0301, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/0/3/0x1 = #1403 */
    { 0x047f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/0/m = #1404 */
    { 0x0400, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/1/0/u = #1405 */
    { 0x0401, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/0/0x1 = #1406 */
    { 0x057f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/1/m = #1407 */
    { 0x0500, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/1/1/u = #1408 */
    { 0x0501, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/1/0x1 = #1409 */
    { 0x067f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/2/m = #1410 */
    { 0x0600, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/1/2/u = #1411 */
    { 0x0601, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/2/0x1 = #1412 */
    { 0x077f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/3/m = #1413 */
    { 0x0700, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/1/3/u = #1414 */
    { 0x0701, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/1/3/0x1 = #1415 */
    { 0x087f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/0/m = #1416 */
    { 0x0800, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/2/0/u = #1417 */
    { 0x0801, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/0/0x1 = #1418 */
    { 0x097f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/1/m = #1419 */
    { 0x0900, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/2/1/u = #1420 */
    { 0x0901, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/1/0x1 = #1421 */
    { 0x0a7f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/2/m = #1422 */
    { 0x0a00, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/2/2/u = #1423 */
    { 0x0a01, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/2/0x1 = #1424 */
    { 0x0b7f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/3/m = #1425 */
    { 0x0b00, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/2/3/u = #1426 */
    { 0x0b01, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/2/3/0x1 = #1427 */
    { 0x0c7f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/0/m = #1428 */
    { 0x0c00, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/3/0/u = #1429 */
    { 0x0c01, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/0/0x1 = #1430 */
    { 0x0d7f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/1/m = #1431 */
    { 0x0d00, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/3/1/u = #1432 */
    { 0x0d01, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/1/0x1 = #1433 */
    { 0x0e7f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/2/m = #1434 */
    { 0x0e00, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/3/2/u = #1435 */
    { 0x0e01, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/2/0x1 = #1436 */
    { 0x0f7f, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/3/m = #1437 */
    { 0x0f00, 0xc180, 0xf181, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124) }, /* #28/3/3/u = #1438 */
    { 0x0f01, 0xc180, 0x7101, RTFLOAT80U_INIT_C(1,0x61f592adebc1292c,22124), RTFLOAT80U_INIT_C(1,0xd348f87a754e29b8,32767), RTFLOAT80U_INIT_IND(1) }, /* #28/3/3/0x1 = #1439 */
    { 0x007f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/0/m = #1440 */
    { 0x0000, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/0/0/u = #1441 */
    { 0x0001, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/0/0x1 = #1442 */
    { 0x017f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/1/m = #1443 */
    { 0x0100, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/0/1/u = #1444 */
    { 0x0101, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/1/0x1 = #1445 */
    { 0x027f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/2/m = #1446 */
    { 0x0200, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/0/2/u = #1447 */
    { 0x0201, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/2/0x1 = #1448 */
    { 0x037f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/3/m = #1449 */
    { 0x0300, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/0/3/u = #1450 */
    { 0x0301, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/0/3/0x1 = #1451 */
    { 0x047f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/0/m = #1452 */
    { 0x0400, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/1/0/u = #1453 */
    { 0x0401, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/0/0x1 = #1454 */
    { 0x057f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/1/m = #1455 */
    { 0x0500, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/1/1/u = #1456 */
    { 0x0501, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/1/0x1 = #1457 */
    { 0x067f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/2/m = #1458 */
    { 0x0600, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/1/2/u = #1459 */
    { 0x0601, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/2/0x1 = #1460 */
    { 0x077f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/3/m = #1461 */
    { 0x0700, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/1/3/u = #1462 */
    { 0x0701, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/1/3/0x1 = #1463 */
    { 0x087f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/0/m = #1464 */
    { 0x0800, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/2/0/u = #1465 */
    { 0x0801, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/0/0x1 = #1466 */
    { 0x097f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/1/m = #1467 */
    { 0x0900, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/2/1/u = #1468 */
    { 0x0901, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/1/0x1 = #1469 */
    { 0x0a7f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/2/m = #1470 */
    { 0x0a00, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/2/2/u = #1471 */
    { 0x0a01, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/2/0x1 = #1472 */
    { 0x0b7f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/3/m = #1473 */
    { 0x0b00, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/2/3/u = #1474 */
    { 0x0b01, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/2/3/0x1 = #1475 */
    { 0x0c7f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/0/m = #1476 */
    { 0x0c00, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/3/0/u = #1477 */
    { 0x0c01, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/0/0x1 = #1478 */
    { 0x0d7f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/1/m = #1479 */
    { 0x0d00, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/3/1/u = #1480 */
    { 0x0d01, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/1/0x1 = #1481 */
    { 0x0e7f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/2/m = #1482 */
    { 0x0e00, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/3/2/u = #1483 */
    { 0x0e01, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/2/0x1 = #1484 */
    { 0x0f7f, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/3/m = #1485 */
    { 0x0f00, 0xaa73, 0xb081, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860) }, /* #29/3/3/u = #1486 */
    { 0x0f01, 0xaa73, 0x3001, RTFLOAT80U_INIT_C(1,0x79b9550663da2bda,10860), RTFLOAT80U_INIT_C(1,0x6da6f9f656ac3a8d,32767), RTFLOAT80U_INIT_IND(1) }, /* #29/3/3/0x1 = #1487 */
    { 0x007f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/0/m = #1488 */
    { 0x0000, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/0/0/u = #1489 */
    { 0x0001, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/0/0x1 = #1490 */
    { 0x017f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/1/m = #1491 */
    { 0x0100, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/0/1/u = #1492 */
    { 0x0101, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/1/0x1 = #1493 */
    { 0x027f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/2/m = #1494 */
    { 0x0200, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/0/2/u = #1495 */
    { 0x0201, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/2/0x1 = #1496 */
    { 0x037f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/3/m = #1497 */
    { 0x0300, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/0/3/u = #1498 */
    { 0x0301, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/0/3/0x1 = #1499 */
    { 0x047f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/0/m = #1500 */
    { 0x0400, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/1/0/u = #1501 */
    { 0x0401, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/0/0x1 = #1502 */
    { 0x057f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/1/m = #1503 */
    { 0x0500, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/1/1/u = #1504 */
    { 0x0501, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/1/0x1 = #1505 */
    { 0x067f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/2/m = #1506 */
    { 0x0600, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/1/2/u = #1507 */
    { 0x0601, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/2/0x1 = #1508 */
    { 0x077f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/3/m = #1509 */
    { 0x0700, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/1/3/u = #1510 */
    { 0x0701, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/1/3/0x1 = #1511 */
    { 0x087f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/0/m = #1512 */
    { 0x0800, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/2/0/u = #1513 */
    { 0x0801, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/0/0x1 = #1514 */
    { 0x097f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/1/m = #1515 */
    { 0x0900, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/2/1/u = #1516 */
    { 0x0901, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/1/0x1 = #1517 */
    { 0x0a7f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/2/m = #1518 */
    { 0x0a00, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/2/2/u = #1519 */
    { 0x0a01, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/2/0x1 = #1520 */
    { 0x0b7f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/3/m = #1521 */
    { 0x0b00, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/2/3/u = #1522 */
    { 0x0b01, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/2/3/0x1 = #1523 */
    { 0x0c7f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/0/m = #1524 */
    { 0x0c00, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/3/0/u = #1525 */
    { 0x0c01, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/0/0x1 = #1526 */
    { 0x0d7f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/1/m = #1527 */
    { 0x0d00, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/3/1/u = #1528 */
    { 0x0d01, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/1/0x1 = #1529 */
    { 0x0e7f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/2/m = #1530 */
    { 0x0e00, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/3/2/u = #1531 */
    { 0x0e01, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/2/0x1 = #1532 */
    { 0x0f7f, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/3/m = #1533 */
    { 0x0f00, 0xf4d3, 0xf481, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411) }, /* #30/3/3/u = #1534 */
    { 0x0f01, 0xf4d3, 0x7401, RTFLOAT80U_INIT_C(1,0x4d7f0d980ba2bcbb,25411), RTFLOAT80U_INIT_C(1,0x8eabcba7687b6d6a,0), RTFLOAT80U_INIT_IND(1) }, /* #30/3/3/0x1 = #1535 */
    { 0x007f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/0/m = #1536 */
    { 0x0000, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/0/0/u = #1537 */
    { 0x0001, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/0/0x1 = #1538 */
    { 0x017f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/1/m = #1539 */
    { 0x0100, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/0/1/u = #1540 */
    { 0x0101, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/1/0x1 = #1541 */
    { 0x027f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/2/m = #1542 */
    { 0x0200, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/0/2/u = #1543 */
    { 0x0201, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/2/0x1 = #1544 */
    { 0x037f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/3/m = #1545 */
    { 0x0300, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/0/3/u = #1546 */
    { 0x0301, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/0/3/0x1 = #1547 */
    { 0x047f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/0/m = #1548 */
    { 0x0400, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/1/0/u = #1549 */
    { 0x0401, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/0/0x1 = #1550 */
    { 0x057f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/1/m = #1551 */
    { 0x0500, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/1/1/u = #1552 */
    { 0x0501, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/1/0x1 = #1553 */
    { 0x067f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/2/m = #1554 */
    { 0x0600, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/1/2/u = #1555 */
    { 0x0601, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/2/0x1 = #1556 */
    { 0x077f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/3/m = #1557 */
    { 0x0700, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/1/3/u = #1558 */
    { 0x0701, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/1/3/0x1 = #1559 */
    { 0x087f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/0/m = #1560 */
    { 0x0800, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/2/0/u = #1561 */
    { 0x0801, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/0/0x1 = #1562 */
    { 0x097f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/1/m = #1563 */
    { 0x0900, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/2/1/u = #1564 */
    { 0x0901, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/1/0x1 = #1565 */
    { 0x0a7f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/2/m = #1566 */
    { 0x0a00, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/2/2/u = #1567 */
    { 0x0a01, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/2/0x1 = #1568 */
    { 0x0b7f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/3/m = #1569 */
    { 0x0b00, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/2/3/u = #1570 */
    { 0x0b01, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/2/3/0x1 = #1571 */
    { 0x0c7f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/0/m = #1572 */
    { 0x0c00, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/3/0/u = #1573 */
    { 0x0c01, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/0/0x1 = #1574 */
    { 0x0d7f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/1/m = #1575 */
    { 0x0d00, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/3/1/u = #1576 */
    { 0x0d01, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/1/0x1 = #1577 */
    { 0x0e7f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/2/m = #1578 */
    { 0x0e00, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/3/2/u = #1579 */
    { 0x0e01, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/2/0x1 = #1580 */
    { 0x0f7f, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/3/m = #1581 */
    { 0x0f00, 0x4c42, 0xf481, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698) }, /* #31/3/3/u = #1582 */
    { 0x0f01, 0x4c42, 0x7401, RTFLOAT80U_INIT_C(0,0x1343282f7d708eeb,2698), RTFLOAT80U_INIT_C(1,0x2be96344686019a9,0), RTFLOAT80U_INIT_IND(1) }, /* #31/3/3/0x1 = #1583 */
    { 0x007f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/0/0/m = #1584 */
    { 0x0000, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/0/0/u = #1585 */
    { 0x0001, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/0/0/0x1 = #1586 */
    { 0x017f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/0/1/m = #1587 */
    { 0x0100, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/0/1/u = #1588 */
    { 0x0101, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/0/1/0x1 = #1589 */
    { 0x027f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/0/2/m = #1590 */
    { 0x0200, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/0/2/u = #1591 */
    { 0x0201, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/0/2/0x1 = #1592 */
    { 0x037f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/0/3/m = #1593 */
    { 0x0300, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/0/3/u = #1594 */
    { 0x0301, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/0/3/0x1 = #1595 */
    { 0x047f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/1/0/m = #1596 */
    { 0x0400, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/1/0/u = #1597 */
    { 0x0401, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/1/0/0x1 = #1598 */
    { 0x057f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/1/1/m = #1599 */
    { 0x0500, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/1/1/u = #1600 */
    { 0x0501, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/1/1/0x1 = #1601 */
    { 0x067f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/1/2/m = #1602 */
    { 0x0600, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/1/2/u = #1603 */
    { 0x0601, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/1/2/0x1 = #1604 */
    { 0x077f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/1/3/m = #1605 */
    { 0x0700, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/1/3/u = #1606 */
    { 0x0701, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/1/3/0x1 = #1607 */
    { 0x087f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/2/0/m = #1608 */
    { 0x0800, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/2/0/u = #1609 */
    { 0x0801, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/2/0/0x1 = #1610 */
    { 0x097f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/2/1/m = #1611 */
    { 0x0900, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/2/1/u = #1612 */
    { 0x0901, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/2/1/0x1 = #1613 */
    { 0x0a7f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/2/2/m = #1614 */
    { 0x0a00, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/2/2/u = #1615 */
    { 0x0a01, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/2/2/0x1 = #1616 */
    { 0x0b7f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/2/3/m = #1617 */
    { 0x0b00, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/2/3/u = #1618 */
    { 0x0b01, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/2/3/0x1 = #1619 */
    { 0x0c7f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/3/0/m = #1620 */
    { 0x0c00, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/3/0/u = #1621 */
    { 0x0c01, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/3/0/0x1 = #1622 */
    { 0x0d7f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/3/1/m = #1623 */
    { 0x0d00, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/3/1/u = #1624 */
    { 0x0d01, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/3/1/0x1 = #1625 */
    { 0x0e7f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/3/2/m = #1626 */
    { 0x0e00, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/3/2/u = #1627 */
    { 0x0e01, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/3/2/0x1 = #1628 */
    { 0x0f7f, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/3/3/m = #1629 */
    { 0x0f00, 0x021a, 0xb081, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589) }, /* #32/3/3/u = #1630 */
    { 0x0f01, 0x021a, 0x3001, RTFLOAT80U_INIT_C(1,0x528c1aef7d6c732c,23589), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #32/3/3/0x1 = #1631 */
    { 0x007f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/0/0/m = #1632 */
    { 0x0000, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/0/0/u = #1633 */
    { 0x0001, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/0/0/0x1 = #1634 */
    { 0x017f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/0/1/m = #1635 */
    { 0x0100, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/0/1/u = #1636 */
    { 0x0101, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/0/1/0x1 = #1637 */
    { 0x027f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/0/2/m = #1638 */
    { 0x0200, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/0/2/u = #1639 */
    { 0x0201, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/0/2/0x1 = #1640 */
    { 0x037f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/0/3/m = #1641 */
    { 0x0300, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/0/3/u = #1642 */
    { 0x0301, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/0/3/0x1 = #1643 */
    { 0x047f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/1/0/m = #1644 */
    { 0x0400, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/1/0/u = #1645 */
    { 0x0401, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/1/0/0x1 = #1646 */
    { 0x057f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/1/1/m = #1647 */
    { 0x0500, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/1/1/u = #1648 */
    { 0x0501, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/1/1/0x1 = #1649 */
    { 0x067f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/1/2/m = #1650 */
    { 0x0600, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/1/2/u = #1651 */
    { 0x0601, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/1/2/0x1 = #1652 */
    { 0x077f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/1/3/m = #1653 */
    { 0x0700, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/1/3/u = #1654 */
    { 0x0701, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/1/3/0x1 = #1655 */
    { 0x087f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/2/0/m = #1656 */
    { 0x0800, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/2/0/u = #1657 */
    { 0x0801, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/2/0/0x1 = #1658 */
    { 0x097f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/2/1/m = #1659 */
    { 0x0900, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/2/1/u = #1660 */
    { 0x0901, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/2/1/0x1 = #1661 */
    { 0x0a7f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/2/2/m = #1662 */
    { 0x0a00, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/2/2/u = #1663 */
    { 0x0a01, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/2/2/0x1 = #1664 */
    { 0x0b7f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/2/3/m = #1665 */
    { 0x0b00, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/2/3/u = #1666 */
    { 0x0b01, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/2/3/0x1 = #1667 */
    { 0x0c7f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/3/0/m = #1668 */
    { 0x0c00, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/3/0/u = #1669 */
    { 0x0c01, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/3/0/0x1 = #1670 */
    { 0x0d7f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/3/1/m = #1671 */
    { 0x0d00, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/3/1/u = #1672 */
    { 0x0d01, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/3/1/0x1 = #1673 */
    { 0x0e7f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/3/2/m = #1674 */
    { 0x0e00, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/3/2/u = #1675 */
    { 0x0e01, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/3/2/0x1 = #1676 */
    { 0x0f7f, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/3/3/m = #1677 */
    { 0x0f00, 0x7160, 0xf181, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559) }, /* #33/3/3/u = #1678 */
    { 0x0f01, 0x7160, 0x7101, RTFLOAT80U_INIT_C(0,0x24432792bd67c1b6,29559), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #33/3/3/0x1 = #1679 */
    { 0x007f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/0/m = #1680 */
    { 0x0000, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/0/0/u = #1681 */
    { 0x0001, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/0/0x1 = #1682 */
    { 0x017f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/1/m = #1683 */
    { 0x0100, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/0/1/u = #1684 */
    { 0x0101, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/1/0x1 = #1685 */
    { 0x027f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/2/m = #1686 */
    { 0x0200, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/0/2/u = #1687 */
    { 0x0201, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/2/0x1 = #1688 */
    { 0x037f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/3/m = #1689 */
    { 0x0300, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/0/3/u = #1690 */
    { 0x0301, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/0/3/0x1 = #1691 */
    { 0x047f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/0/m = #1692 */
    { 0x0400, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/1/0/u = #1693 */
    { 0x0401, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/0/0x1 = #1694 */
    { 0x057f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/1/m = #1695 */
    { 0x0500, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/1/1/u = #1696 */
    { 0x0501, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/1/0x1 = #1697 */
    { 0x067f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/2/m = #1698 */
    { 0x0600, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/1/2/u = #1699 */
    { 0x0601, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/2/0x1 = #1700 */
    { 0x077f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/3/m = #1701 */
    { 0x0700, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/1/3/u = #1702 */
    { 0x0701, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/1/3/0x1 = #1703 */
    { 0x087f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/0/m = #1704 */
    { 0x0800, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/2/0/u = #1705 */
    { 0x0801, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/0/0x1 = #1706 */
    { 0x097f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/1/m = #1707 */
    { 0x0900, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/2/1/u = #1708 */
    { 0x0901, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/1/0x1 = #1709 */
    { 0x0a7f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/2/m = #1710 */
    { 0x0a00, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/2/2/u = #1711 */
    { 0x0a01, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/2/0x1 = #1712 */
    { 0x0b7f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/3/m = #1713 */
    { 0x0b00, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/2/3/u = #1714 */
    { 0x0b01, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/2/3/0x1 = #1715 */
    { 0x0c7f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/0/m = #1716 */
    { 0x0c00, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/3/0/u = #1717 */
    { 0x0c01, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/0/0x1 = #1718 */
    { 0x0d7f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/1/m = #1719 */
    { 0x0d00, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/3/1/u = #1720 */
    { 0x0d01, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/1/0x1 = #1721 */
    { 0x0e7f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/2/m = #1722 */
    { 0x0e00, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/3/2/u = #1723 */
    { 0x0e01, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/2/0x1 = #1724 */
    { 0x0f7f, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/3/m = #1725 */
    { 0x0f00, 0xc418, 0xf481, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130) }, /* #34/3/3/u = #1726 */
    { 0x0f01, 0xc418, 0x7401, RTFLOAT80U_INIT_C(0,0x608e22ffb05eda02,25130), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #34/3/3/0x1 = #1727 */
    { 0x007f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/0/0/m = #1728 */
    { 0x0000, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/0/0/u = #1729 */
    { 0x0001, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/0/0/0x1 = #1730 */
    { 0x017f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/0/1/m = #1731 */
    { 0x0100, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/0/1/u = #1732 */
    { 0x0101, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/0/1/0x1 = #1733 */
    { 0x027f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/0/2/m = #1734 */
    { 0x0200, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/0/2/u = #1735 */
    { 0x0201, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/0/2/0x1 = #1736 */
    { 0x037f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/0/3/m = #1737 */
    { 0x0300, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/0/3/u = #1738 */
    { 0x0301, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/0/3/0x1 = #1739 */
    { 0x047f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/1/0/m = #1740 */
    { 0x0400, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/1/0/u = #1741 */
    { 0x0401, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/1/0/0x1 = #1742 */
    { 0x057f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/1/1/m = #1743 */
    { 0x0500, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/1/1/u = #1744 */
    { 0x0501, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/1/1/0x1 = #1745 */
    { 0x067f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/1/2/m = #1746 */
    { 0x0600, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/1/2/u = #1747 */
    { 0x0601, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/1/2/0x1 = #1748 */
    { 0x077f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/1/3/m = #1749 */
    { 0x0700, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/1/3/u = #1750 */
    { 0x0701, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/1/3/0x1 = #1751 */
    { 0x087f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/2/0/m = #1752 */
    { 0x0800, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/2/0/u = #1753 */
    { 0x0801, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/2/0/0x1 = #1754 */
    { 0x097f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/2/1/m = #1755 */
    { 0x0900, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/2/1/u = #1756 */
    { 0x0901, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/2/1/0x1 = #1757 */
    { 0x0a7f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/2/2/m = #1758 */
    { 0x0a00, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/2/2/u = #1759 */
    { 0x0a01, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/2/2/0x1 = #1760 */
    { 0x0b7f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/2/3/m = #1761 */
    { 0x0b00, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/2/3/u = #1762 */
    { 0x0b01, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/2/3/0x1 = #1763 */
    { 0x0c7f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/3/0/m = #1764 */
    { 0x0c00, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/3/0/u = #1765 */
    { 0x0c01, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/3/0/0x1 = #1766 */
    { 0x0d7f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/3/1/m = #1767 */
    { 0x0d00, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/3/1/u = #1768 */
    { 0x0d01, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/3/1/0x1 = #1769 */
    { 0x0e7f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/3/2/m = #1770 */
    { 0x0e00, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/3/2/u = #1771 */
    { 0x0e01, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/3/2/0x1 = #1772 */
    { 0x0f7f, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/3/3/m = #1773 */
    { 0x0f00, 0xc85c, 0xf081, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802) }, /* #35/3/3/u = #1774 */
    { 0x0f01, 0xc85c, 0x7001, RTFLOAT80U_INIT_C(0,0x112fc24b86a50a75,31802), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #35/3/3/0x1 = #1775 */
    { 0x007f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/0/0/m = #1776 */
    { 0x0000, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/0/0/u = #1777 */
    { 0x0001, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/0/0/0x1 = #1778 */
    { 0x017f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/0/1/m = #1779 */
    { 0x0100, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/0/1/u = #1780 */
    { 0x0101, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/0/1/0x1 = #1781 */
    { 0x027f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/0/2/m = #1782 */
    { 0x0200, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/0/2/u = #1783 */
    { 0x0201, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/0/2/0x1 = #1784 */
    { 0x037f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/0/3/m = #1785 */
    { 0x0300, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/0/3/u = #1786 */
    { 0x0301, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/0/3/0x1 = #1787 */
    { 0x047f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/1/0/m = #1788 */
    { 0x0400, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/1/0/u = #1789 */
    { 0x0401, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/1/0/0x1 = #1790 */
    { 0x057f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/1/1/m = #1791 */
    { 0x0500, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/1/1/u = #1792 */
    { 0x0501, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/1/1/0x1 = #1793 */
    { 0x067f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/1/2/m = #1794 */
    { 0x0600, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/1/2/u = #1795 */
    { 0x0601, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/1/2/0x1 = #1796 */
    { 0x077f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/1/3/m = #1797 */
    { 0x0700, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/1/3/u = #1798 */
    { 0x0701, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/1/3/0x1 = #1799 */
    { 0x087f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/2/0/m = #1800 */
    { 0x0800, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/2/0/u = #1801 */
    { 0x0801, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/2/0/0x1 = #1802 */
    { 0x097f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/2/1/m = #1803 */
    { 0x0900, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/2/1/u = #1804 */
    { 0x0901, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/2/1/0x1 = #1805 */
    { 0x0a7f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/2/2/m = #1806 */
    { 0x0a00, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/2/2/u = #1807 */
    { 0x0a01, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/2/2/0x1 = #1808 */
    { 0x0b7f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/2/3/m = #1809 */
    { 0x0b00, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/2/3/u = #1810 */
    { 0x0b01, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/2/3/0x1 = #1811 */
    { 0x0c7f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/3/0/m = #1812 */
    { 0x0c00, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/3/0/u = #1813 */
    { 0x0c01, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/3/0/0x1 = #1814 */
    { 0x0d7f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/3/1/m = #1815 */
    { 0x0d00, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/3/1/u = #1816 */
    { 0x0d01, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/3/1/0x1 = #1817 */
    { 0x0e7f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/3/2/m = #1818 */
    { 0x0e00, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/3/2/u = #1819 */
    { 0x0e01, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/3/2/0x1 = #1820 */
    { 0x0f7f, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/3/3/m = #1821 */
    { 0x0f00, 0x613d, 0xf181, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767) }, /* #36/3/3/u = #1822 */
    { 0x0f01, 0x613d, 0x7101, RTFLOAT80U_INIT_C(0,0x95ec8f0e7ba2a435,32767), RTFLOAT80U_INIT_C(0,0xca55b71ede676cf3,20737), RTFLOAT80U_INIT_C(0,0xd5ec8f0e7ba2a435,32767) }, /* #36/3/3/0x1 = #1823 */
    { 0x007f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/0/0/m = #1824 */
    { 0x0000, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/0/0/u = #1825 */
    { 0x0001, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/0/0/0x1 = #1826 */
    { 0x017f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/0/1/m = #1827 */
    { 0x0100, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/0/1/u = #1828 */
    { 0x0101, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/0/1/0x1 = #1829 */
    { 0x027f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/0/2/m = #1830 */
    { 0x0200, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/0/2/u = #1831 */
    { 0x0201, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/0/2/0x1 = #1832 */
    { 0x037f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/0/3/m = #1833 */
    { 0x0300, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/0/3/u = #1834 */
    { 0x0301, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/0/3/0x1 = #1835 */
    { 0x047f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/1/0/m = #1836 */
    { 0x0400, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/1/0/u = #1837 */
    { 0x0401, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/1/0/0x1 = #1838 */
    { 0x057f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/1/1/m = #1839 */
    { 0x0500, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/1/1/u = #1840 */
    { 0x0501, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/1/1/0x1 = #1841 */
    { 0x067f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/1/2/m = #1842 */
    { 0x0600, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/1/2/u = #1843 */
    { 0x0601, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/1/2/0x1 = #1844 */
    { 0x077f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/1/3/m = #1845 */
    { 0x0700, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/1/3/u = #1846 */
    { 0x0701, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/1/3/0x1 = #1847 */
    { 0x087f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/2/0/m = #1848 */
    { 0x0800, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/2/0/u = #1849 */
    { 0x0801, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/2/0/0x1 = #1850 */
    { 0x097f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/2/1/m = #1851 */
    { 0x0900, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/2/1/u = #1852 */
    { 0x0901, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/2/1/0x1 = #1853 */
    { 0x0a7f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/2/2/m = #1854 */
    { 0x0a00, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/2/2/u = #1855 */
    { 0x0a01, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/2/2/0x1 = #1856 */
    { 0x0b7f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/2/3/m = #1857 */
    { 0x0b00, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/2/3/u = #1858 */
    { 0x0b01, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/2/3/0x1 = #1859 */
    { 0x0c7f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/3/0/m = #1860 */
    { 0x0c00, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/3/0/u = #1861 */
    { 0x0c01, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/3/0/0x1 = #1862 */
    { 0x0d7f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/3/1/m = #1863 */
    { 0x0d00, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/3/1/u = #1864 */
    { 0x0d01, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/3/1/0x1 = #1865 */
    { 0x0e7f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/3/2/m = #1866 */
    { 0x0e00, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/3/2/u = #1867 */
    { 0x0e01, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/3/2/0x1 = #1868 */
    { 0x0f7f, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/3/3/m = #1869 */
    { 0x0f00, 0xee8a, 0xf481, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767) }, /* #37/3/3/u = #1870 */
    { 0x0f01, 0xee8a, 0x7401, RTFLOAT80U_INIT_C(0,0x86272c6d7854c9a0,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,3908), RTFLOAT80U_INIT_C(0,0xc6272c6d7854c9a0,32767) }, /* #37/3/3/0x1 = #1871 */
    { 0x007f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/0/0/m = #1872 */
    { 0x0000, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/0/0/u = #1873 */
    { 0x0001, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/0/0/0x1 = #1874 */
    { 0x017f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/0/1/m = #1875 */
    { 0x0100, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/0/1/u = #1876 */
    { 0x0101, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/0/1/0x1 = #1877 */
    { 0x027f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/0/2/m = #1878 */
    { 0x0200, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/0/2/u = #1879 */
    { 0x0201, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/0/2/0x1 = #1880 */
    { 0x037f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/0/3/m = #1881 */
    { 0x0300, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/0/3/u = #1882 */
    { 0x0301, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/0/3/0x1 = #1883 */
    { 0x047f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/1/0/m = #1884 */
    { 0x0400, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/1/0/u = #1885 */
    { 0x0401, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/1/0/0x1 = #1886 */
    { 0x057f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/1/1/m = #1887 */
    { 0x0500, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/1/1/u = #1888 */
    { 0x0501, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/1/1/0x1 = #1889 */
    { 0x067f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/1/2/m = #1890 */
    { 0x0600, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/1/2/u = #1891 */
    { 0x0601, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/1/2/0x1 = #1892 */
    { 0x077f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/1/3/m = #1893 */
    { 0x0700, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/1/3/u = #1894 */
    { 0x0701, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/1/3/0x1 = #1895 */
    { 0x087f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/2/0/m = #1896 */
    { 0x0800, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/2/0/u = #1897 */
    { 0x0801, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/2/0/0x1 = #1898 */
    { 0x097f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/2/1/m = #1899 */
    { 0x0900, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/2/1/u = #1900 */
    { 0x0901, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/2/1/0x1 = #1901 */
    { 0x0a7f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/2/2/m = #1902 */
    { 0x0a00, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/2/2/u = #1903 */
    { 0x0a01, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/2/2/0x1 = #1904 */
    { 0x0b7f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/2/3/m = #1905 */
    { 0x0b00, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/2/3/u = #1906 */
    { 0x0b01, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/2/3/0x1 = #1907 */
    { 0x0c7f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/3/0/m = #1908 */
    { 0x0c00, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/3/0/u = #1909 */
    { 0x0c01, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/3/0/0x1 = #1910 */
    { 0x0d7f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/3/1/m = #1911 */
    { 0x0d00, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/3/1/u = #1912 */
    { 0x0d01, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/3/1/0x1 = #1913 */
    { 0x0e7f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/3/2/m = #1914 */
    { 0x0e00, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/3/2/u = #1915 */
    { 0x0e01, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/3/2/0x1 = #1916 */
    { 0x0f7f, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/3/3/m = #1917 */
    { 0x0f00, 0xb159, 0xb181, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767) }, /* #38/3/3/u = #1918 */
    { 0x0f01, 0xb159, 0x3101, RTFLOAT80U_INIT_C(1,0x963487ff7ed78893,32767), RTFLOAT80U_INIT_C(1,0x4c172b5e8a9e5206,16783), RTFLOAT80U_INIT_IND(1) }, /* #38/3/3/0x1 = #1919 */
    { 0x007f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/0/0/m = #1920 */
    { 0x0000, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/0/0/u = #1921 */
    { 0x0001, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/0/0/0x1 = #1922 */
    { 0x017f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/0/1/m = #1923 */
    { 0x0100, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/0/1/u = #1924 */
    { 0x0101, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/0/1/0x1 = #1925 */
    { 0x027f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/0/2/m = #1926 */
    { 0x0200, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/0/2/u = #1927 */
    { 0x0201, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/0/2/0x1 = #1928 */
    { 0x037f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/0/3/m = #1929 */
    { 0x0300, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/0/3/u = #1930 */
    { 0x0301, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/0/3/0x1 = #1931 */
    { 0x047f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/1/0/m = #1932 */
    { 0x0400, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/1/0/u = #1933 */
    { 0x0401, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/1/0/0x1 = #1934 */
    { 0x057f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/1/1/m = #1935 */
    { 0x0500, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/1/1/u = #1936 */
    { 0x0501, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/1/1/0x1 = #1937 */
    { 0x067f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/1/2/m = #1938 */
    { 0x0600, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/1/2/u = #1939 */
    { 0x0601, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/1/2/0x1 = #1940 */
    { 0x077f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/1/3/m = #1941 */
    { 0x0700, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/1/3/u = #1942 */
    { 0x0701, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/1/3/0x1 = #1943 */
    { 0x087f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/2/0/m = #1944 */
    { 0x0800, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/2/0/u = #1945 */
    { 0x0801, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/2/0/0x1 = #1946 */
    { 0x097f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/2/1/m = #1947 */
    { 0x0900, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/2/1/u = #1948 */
    { 0x0901, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/2/1/0x1 = #1949 */
    { 0x0a7f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/2/2/m = #1950 */
    { 0x0a00, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/2/2/u = #1951 */
    { 0x0a01, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/2/2/0x1 = #1952 */
    { 0x0b7f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/2/3/m = #1953 */
    { 0x0b00, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/2/3/u = #1954 */
    { 0x0b01, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/2/3/0x1 = #1955 */
    { 0x0c7f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/3/0/m = #1956 */
    { 0x0c00, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/3/0/u = #1957 */
    { 0x0c01, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/3/0/0x1 = #1958 */
    { 0x0d7f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/3/1/m = #1959 */
    { 0x0d00, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/3/1/u = #1960 */
    { 0x0d01, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/3/1/0x1 = #1961 */
    { 0x0e7f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/3/2/m = #1962 */
    { 0x0e00, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/3/2/u = #1963 */
    { 0x0e01, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/3/2/0x1 = #1964 */
    { 0x0f7f, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/3/3/m = #1965 */
    { 0x0f00, 0x1c87, 0xb481, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767) }, /* #39/3/3/u = #1966 */
    { 0x0f01, 0x1c87, 0x3401, RTFLOAT80U_INIT_C(1,0xa8deeae09a660d0e,32767), RTFLOAT80U_INIT_C(0,0x96788fa1b0eb4769,32767), RTFLOAT80U_INIT_C(1,0xe8deeae09a660d0e,32767) }, /* #39/3/3/0x1 = #1967 */
    { 0x007f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/0/0/m = #1968 */
    { 0x0000, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/0/0/u = #1969 */
    { 0x0001, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/0/0/0x1 = #1970 */
    { 0x017f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/0/1/m = #1971 */
    { 0x0100, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/0/1/u = #1972 */
    { 0x0101, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/0/1/0x1 = #1973 */
    { 0x027f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/0/2/m = #1974 */
    { 0x0200, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/0/2/u = #1975 */
    { 0x0201, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/0/2/0x1 = #1976 */
    { 0x037f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/0/3/m = #1977 */
    { 0x0300, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/0/3/u = #1978 */
    { 0x0301, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/0/3/0x1 = #1979 */
    { 0x047f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/1/0/m = #1980 */
    { 0x0400, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/1/0/u = #1981 */
    { 0x0401, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/1/0/0x1 = #1982 */
    { 0x057f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/1/1/m = #1983 */
    { 0x0500, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/1/1/u = #1984 */
    { 0x0501, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/1/1/0x1 = #1985 */
    { 0x067f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/1/2/m = #1986 */
    { 0x0600, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/1/2/u = #1987 */
    { 0x0601, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/1/2/0x1 = #1988 */
    { 0x077f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/1/3/m = #1989 */
    { 0x0700, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/1/3/u = #1990 */
    { 0x0701, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/1/3/0x1 = #1991 */
    { 0x087f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/2/0/m = #1992 */
    { 0x0800, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/2/0/u = #1993 */
    { 0x0801, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/2/0/0x1 = #1994 */
    { 0x097f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/2/1/m = #1995 */
    { 0x0900, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/2/1/u = #1996 */
    { 0x0901, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/2/1/0x1 = #1997 */
    { 0x0a7f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/2/2/m = #1998 */
    { 0x0a00, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/2/2/u = #1999 */
    { 0x0a01, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/2/2/0x1 = #2000 */
    { 0x0b7f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/2/3/m = #2001 */
    { 0x0b00, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/2/3/u = #2002 */
    { 0x0b01, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/2/3/0x1 = #2003 */
    { 0x0c7f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/3/0/m = #2004 */
    { 0x0c00, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/3/0/u = #2005 */
    { 0x0c01, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/3/0/0x1 = #2006 */
    { 0x0d7f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/3/1/m = #2007 */
    { 0x0d00, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/3/1/u = #2008 */
    { 0x0d01, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/3/1/0x1 = #2009 */
    { 0x0e7f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/3/2/m = #2010 */
    { 0x0e00, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/3/2/u = #2011 */
    { 0x0e01, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/3/2/0x1 = #2012 */
    { 0x0f7f, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/3/3/m = #2013 */
    { 0x0f00, 0xed17, 0xf581, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767) }, /* #40/3/3/u = #2014 */
    { 0x0f01, 0xed17, 0x7501, RTFLOAT80U_INIT_C(0,0x89da1c241dd1f45e,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767), RTFLOAT80U_INIT_C(1,0xdc0c6393e20b8392,32767) }, /* #40/3/3/0x1 = #2015 */
    { 0x007f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/0/m = #2016 */
    { 0x0000, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/0/0/u = #2017 */
    { 0x0001, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/0/0x1 = #2018 */
    { 0x017f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/1/m = #2019 */
    { 0x0100, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/0/1/u = #2020 */
    { 0x0101, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/1/0x1 = #2021 */
    { 0x027f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/2/m = #2022 */
    { 0x0200, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/0/2/u = #2023 */
    { 0x0201, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/2/0x1 = #2024 */
    { 0x037f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/3/m = #2025 */
    { 0x0300, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/0/3/u = #2026 */
    { 0x0301, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/0/3/0x1 = #2027 */
    { 0x047f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/0/m = #2028 */
    { 0x0400, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/1/0/u = #2029 */
    { 0x0401, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/0/0x1 = #2030 */
    { 0x057f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/1/m = #2031 */
    { 0x0500, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/1/1/u = #2032 */
    { 0x0501, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/1/0x1 = #2033 */
    { 0x067f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/2/m = #2034 */
    { 0x0600, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/1/2/u = #2035 */
    { 0x0601, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/2/0x1 = #2036 */
    { 0x077f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/3/m = #2037 */
    { 0x0700, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/1/3/u = #2038 */
    { 0x0701, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/1/3/0x1 = #2039 */
    { 0x087f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/0/m = #2040 */
    { 0x0800, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/2/0/u = #2041 */
    { 0x0801, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/0/0x1 = #2042 */
    { 0x097f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/1/m = #2043 */
    { 0x0900, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/2/1/u = #2044 */
    { 0x0901, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/1/0x1 = #2045 */
    { 0x0a7f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/2/m = #2046 */
    { 0x0a00, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/2/2/u = #2047 */
    { 0x0a01, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/2/0x1 = #2048 */
    { 0x0b7f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/3/m = #2049 */
    { 0x0b00, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/2/3/u = #2050 */
    { 0x0b01, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/2/3/0x1 = #2051 */
    { 0x0c7f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/0/m = #2052 */
    { 0x0c00, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/3/0/u = #2053 */
    { 0x0c01, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/0/0x1 = #2054 */
    { 0x0d7f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/1/m = #2055 */
    { 0x0d00, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/3/1/u = #2056 */
    { 0x0d01, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/1/0x1 = #2057 */
    { 0x0e7f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/2/m = #2058 */
    { 0x0e00, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/3/2/u = #2059 */
    { 0x0e01, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/2/0x1 = #2060 */
    { 0x0f7f, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/3/m = #2061 */
    { 0x0f00, 0x8dc1, 0xb581, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767) }, /* #41/3/3/u = #2062 */
    { 0x0f01, 0x8dc1, 0x3501, RTFLOAT80U_INIT_C(0,0xa98be7726d0d66ed,32767), RTFLOAT80U_INIT_C(0,0x70ebf00b746c8d84,32767), RTFLOAT80U_INIT_IND(1) }, /* #41/3/3/0x1 = #2063 */
    { 0x007f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/0/0/m = #2064 */
    { 0x0000, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/0/0/u = #2065 */
    { 0x0001, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/0/0/0x1 = #2066 */
    { 0x017f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/0/1/m = #2067 */
    { 0x0100, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/0/1/u = #2068 */
    { 0x0101, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/0/1/0x1 = #2069 */
    { 0x027f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/0/2/m = #2070 */
    { 0x0200, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/0/2/u = #2071 */
    { 0x0201, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/0/2/0x1 = #2072 */
    { 0x037f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/0/3/m = #2073 */
    { 0x0300, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/0/3/u = #2074 */
    { 0x0301, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/0/3/0x1 = #2075 */
    { 0x047f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/1/0/m = #2076 */
    { 0x0400, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/1/0/u = #2077 */
    { 0x0401, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/1/0/0x1 = #2078 */
    { 0x057f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/1/1/m = #2079 */
    { 0x0500, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/1/1/u = #2080 */
    { 0x0501, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/1/1/0x1 = #2081 */
    { 0x067f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/1/2/m = #2082 */
    { 0x0600, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/1/2/u = #2083 */
    { 0x0601, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/1/2/0x1 = #2084 */
    { 0x077f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/1/3/m = #2085 */
    { 0x0700, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/1/3/u = #2086 */
    { 0x0701, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/1/3/0x1 = #2087 */
    { 0x087f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/2/0/m = #2088 */
    { 0x0800, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/2/0/u = #2089 */
    { 0x0801, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/2/0/0x1 = #2090 */
    { 0x097f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/2/1/m = #2091 */
    { 0x0900, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/2/1/u = #2092 */
    { 0x0901, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/2/1/0x1 = #2093 */
    { 0x0a7f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/2/2/m = #2094 */
    { 0x0a00, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/2/2/u = #2095 */
    { 0x0a01, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/2/2/0x1 = #2096 */
    { 0x0b7f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/2/3/m = #2097 */
    { 0x0b00, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/2/3/u = #2098 */
    { 0x0b01, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/2/3/0x1 = #2099 */
    { 0x0c7f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/3/0/m = #2100 */
    { 0x0c00, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/3/0/u = #2101 */
    { 0x0c01, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/3/0/0x1 = #2102 */
    { 0x0d7f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/3/1/m = #2103 */
    { 0x0d00, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/3/1/u = #2104 */
    { 0x0d01, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/3/1/0x1 = #2105 */
    { 0x0e7f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/3/2/m = #2106 */
    { 0x0e00, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/3/2/u = #2107 */
    { 0x0e01, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/3/2/0x1 = #2108 */
    { 0x0f7f, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/3/3/m = #2109 */
    { 0x0f00, 0xe4ab, 0xf481, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767) }, /* #42/3/3/u = #2110 */
    { 0x0f01, 0xe4ab, 0x7401, RTFLOAT80U_INIT_C(0,0xbece167a4f806cad,32767), RTFLOAT80U_INIT_C(1,0x916199a509a42ddb,0), RTFLOAT80U_INIT_C(0,0xfece167a4f806cad,32767) }, /* #42/3/3/0x1 = #2111 */
    { 0x007f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/0/0/m = #2112 */
    { 0x0000, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/0/0/u = #2113 */
    { 0x0001, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/0/0/0x1 = #2114 */
    { 0x017f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/0/1/m = #2115 */
    { 0x0100, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/0/1/u = #2116 */
    { 0x0101, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/0/1/0x1 = #2117 */
    { 0x027f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/0/2/m = #2118 */
    { 0x0200, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/0/2/u = #2119 */
    { 0x0201, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/0/2/0x1 = #2120 */
    { 0x037f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/0/3/m = #2121 */
    { 0x0300, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/0/3/u = #2122 */
    { 0x0301, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/0/3/0x1 = #2123 */
    { 0x047f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/1/0/m = #2124 */
    { 0x0400, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/1/0/u = #2125 */
    { 0x0401, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/1/0/0x1 = #2126 */
    { 0x057f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/1/1/m = #2127 */
    { 0x0500, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/1/1/u = #2128 */
    { 0x0501, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/1/1/0x1 = #2129 */
    { 0x067f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/1/2/m = #2130 */
    { 0x0600, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/1/2/u = #2131 */
    { 0x0601, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/1/2/0x1 = #2132 */
    { 0x077f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/1/3/m = #2133 */
    { 0x0700, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/1/3/u = #2134 */
    { 0x0701, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/1/3/0x1 = #2135 */
    { 0x087f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/2/0/m = #2136 */
    { 0x0800, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/2/0/u = #2137 */
    { 0x0801, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/2/0/0x1 = #2138 */
    { 0x097f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/2/1/m = #2139 */
    { 0x0900, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/2/1/u = #2140 */
    { 0x0901, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/2/1/0x1 = #2141 */
    { 0x0a7f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/2/2/m = #2142 */
    { 0x0a00, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/2/2/u = #2143 */
    { 0x0a01, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/2/2/0x1 = #2144 */
    { 0x0b7f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/2/3/m = #2145 */
    { 0x0b00, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/2/3/u = #2146 */
    { 0x0b01, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/2/3/0x1 = #2147 */
    { 0x0c7f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/3/0/m = #2148 */
    { 0x0c00, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/3/0/u = #2149 */
    { 0x0c01, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/3/0/0x1 = #2150 */
    { 0x0d7f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/3/1/m = #2151 */
    { 0x0d00, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/3/1/u = #2152 */
    { 0x0d01, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/3/1/0x1 = #2153 */
    { 0x0e7f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/3/2/m = #2154 */
    { 0x0e00, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/3/2/u = #2155 */
    { 0x0e01, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/3/2/0x1 = #2156 */
    { 0x0f7f, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/3/3/m = #2157 */
    { 0x0f00, 0x8281, 0xb081, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767) }, /* #43/3/3/u = #2158 */
    { 0x0f01, 0x8281, 0x3001, RTFLOAT80U_INIT_C(1,0x833612c07a86019c,32767), RTFLOAT80U_INIT_C(1,0x6e83c5765deae6d9,0), RTFLOAT80U_INIT_C(1,0xc33612c07a86019c,32767) }, /* #43/3/3/0x1 = #2159 */
    { 0x007f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/0/m = #2160 */
    { 0x0000, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/0/0/u = #2161 */
    { 0x0001, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/0/0x1 = #2162 */
    { 0x017f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/1/m = #2163 */
    { 0x0100, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/0/1/u = #2164 */
    { 0x0101, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/1/0x1 = #2165 */
    { 0x027f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/2/m = #2166 */
    { 0x0200, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/0/2/u = #2167 */
    { 0x0201, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/2/0x1 = #2168 */
    { 0x037f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/3/m = #2169 */
    { 0x0300, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/0/3/u = #2170 */
    { 0x0301, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/0/3/0x1 = #2171 */
    { 0x047f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/0/m = #2172 */
    { 0x0400, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/1/0/u = #2173 */
    { 0x0401, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/0/0x1 = #2174 */
    { 0x057f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/1/m = #2175 */
    { 0x0500, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/1/1/u = #2176 */
    { 0x0501, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/1/0x1 = #2177 */
    { 0x067f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/2/m = #2178 */
    { 0x0600, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/1/2/u = #2179 */
    { 0x0601, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/2/0x1 = #2180 */
    { 0x077f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/3/m = #2181 */
    { 0x0700, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/1/3/u = #2182 */
    { 0x0701, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/1/3/0x1 = #2183 */
    { 0x087f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/0/m = #2184 */
    { 0x0800, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/2/0/u = #2185 */
    { 0x0801, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/0/0x1 = #2186 */
    { 0x097f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/1/m = #2187 */
    { 0x0900, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/2/1/u = #2188 */
    { 0x0901, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/1/0x1 = #2189 */
    { 0x0a7f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/2/m = #2190 */
    { 0x0a00, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/2/2/u = #2191 */
    { 0x0a01, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/2/0x1 = #2192 */
    { 0x0b7f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/3/m = #2193 */
    { 0x0b00, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/2/3/u = #2194 */
    { 0x0b01, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/2/3/0x1 = #2195 */
    { 0x0c7f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/0/m = #2196 */
    { 0x0c00, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/3/0/u = #2197 */
    { 0x0c01, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/0/0x1 = #2198 */
    { 0x0d7f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/1/m = #2199 */
    { 0x0d00, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/3/1/u = #2200 */
    { 0x0d01, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/1/0x1 = #2201 */
    { 0x0e7f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/2/m = #2202 */
    { 0x0e00, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/3/2/u = #2203 */
    { 0x0e01, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/2/0x1 = #2204 */
    { 0x0f7f, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/3/m = #2205 */
    { 0x0f00, 0xb93d, 0xb181, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767) }, /* #44/3/3/u = #2206 */
    { 0x0f01, 0xb93d, 0x3101, RTFLOAT80U_INIT_C(1,0x944bfbc08cd8b280,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #44/3/3/0x1 = #2207 */
    { 0x007f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/0/0/m = #2208 */
    { 0x0000, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/0/0/u = #2209 */
    { 0x0001, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/0/0/0x1 = #2210 */
    { 0x017f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/0/1/m = #2211 */
    { 0x0100, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/0/1/u = #2212 */
    { 0x0101, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/0/1/0x1 = #2213 */
    { 0x027f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/0/2/m = #2214 */
    { 0x0200, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/0/2/u = #2215 */
    { 0x0201, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/0/2/0x1 = #2216 */
    { 0x037f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/0/3/m = #2217 */
    { 0x0300, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/0/3/u = #2218 */
    { 0x0301, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/0/3/0x1 = #2219 */
    { 0x047f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/1/0/m = #2220 */
    { 0x0400, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/1/0/u = #2221 */
    { 0x0401, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/1/0/0x1 = #2222 */
    { 0x057f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/1/1/m = #2223 */
    { 0x0500, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/1/1/u = #2224 */
    { 0x0501, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/1/1/0x1 = #2225 */
    { 0x067f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/1/2/m = #2226 */
    { 0x0600, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/1/2/u = #2227 */
    { 0x0601, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/1/2/0x1 = #2228 */
    { 0x077f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/1/3/m = #2229 */
    { 0x0700, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/1/3/u = #2230 */
    { 0x0701, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/1/3/0x1 = #2231 */
    { 0x087f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/2/0/m = #2232 */
    { 0x0800, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/2/0/u = #2233 */
    { 0x0801, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/2/0/0x1 = #2234 */
    { 0x097f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/2/1/m = #2235 */
    { 0x0900, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/2/1/u = #2236 */
    { 0x0901, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/2/1/0x1 = #2237 */
    { 0x0a7f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/2/2/m = #2238 */
    { 0x0a00, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/2/2/u = #2239 */
    { 0x0a01, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/2/2/0x1 = #2240 */
    { 0x0b7f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/2/3/m = #2241 */
    { 0x0b00, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/2/3/u = #2242 */
    { 0x0b01, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/2/3/0x1 = #2243 */
    { 0x0c7f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/3/0/m = #2244 */
    { 0x0c00, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/3/0/u = #2245 */
    { 0x0c01, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/3/0/0x1 = #2246 */
    { 0x0d7f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/3/1/m = #2247 */
    { 0x0d00, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/3/1/u = #2248 */
    { 0x0d01, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/3/1/0x1 = #2249 */
    { 0x0e7f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/3/2/m = #2250 */
    { 0x0e00, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/3/2/u = #2251 */
    { 0x0e01, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/3/2/0x1 = #2252 */
    { 0x0f7f, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/3/3/m = #2253 */
    { 0x0f00, 0x048a, 0xb481, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767) }, /* #45/3/3/u = #2254 */
    { 0x0f01, 0x048a, 0x3401, RTFLOAT80U_INIT_C(0,0xb7c6545704e4d6d8,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xf7c6545704e4d6d8,32767) }, /* #45/3/3/0x1 = #2255 */
    { 0x007f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/0/m = #2256 */
    { 0x0000, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/0/0/u = #2257 */
    { 0x0001, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/0/0x1 = #2258 */
    { 0x017f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/1/m = #2259 */
    { 0x0100, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/0/1/u = #2260 */
    { 0x0101, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/1/0x1 = #2261 */
    { 0x027f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/2/m = #2262 */
    { 0x0200, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/0/2/u = #2263 */
    { 0x0201, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/2/0x1 = #2264 */
    { 0x037f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/3/m = #2265 */
    { 0x0300, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/0/3/u = #2266 */
    { 0x0301, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/0/3/0x1 = #2267 */
    { 0x047f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/0/m = #2268 */
    { 0x0400, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/1/0/u = #2269 */
    { 0x0401, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/0/0x1 = #2270 */
    { 0x057f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/1/m = #2271 */
    { 0x0500, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/1/1/u = #2272 */
    { 0x0501, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/1/0x1 = #2273 */
    { 0x067f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/2/m = #2274 */
    { 0x0600, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/1/2/u = #2275 */
    { 0x0601, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/2/0x1 = #2276 */
    { 0x077f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/3/m = #2277 */
    { 0x0700, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/1/3/u = #2278 */
    { 0x0701, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/1/3/0x1 = #2279 */
    { 0x087f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/0/m = #2280 */
    { 0x0800, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/2/0/u = #2281 */
    { 0x0801, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/0/0x1 = #2282 */
    { 0x097f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/1/m = #2283 */
    { 0x0900, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/2/1/u = #2284 */
    { 0x0901, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/1/0x1 = #2285 */
    { 0x0a7f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/2/m = #2286 */
    { 0x0a00, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/2/2/u = #2287 */
    { 0x0a01, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/2/0x1 = #2288 */
    { 0x0b7f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/3/m = #2289 */
    { 0x0b00, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/2/3/u = #2290 */
    { 0x0b01, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/2/3/0x1 = #2291 */
    { 0x0c7f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/0/m = #2292 */
    { 0x0c00, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/3/0/u = #2293 */
    { 0x0c01, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/0/0x1 = #2294 */
    { 0x0d7f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/1/m = #2295 */
    { 0x0d00, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/3/1/u = #2296 */
    { 0x0d01, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/1/0x1 = #2297 */
    { 0x0e7f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/2/m = #2298 */
    { 0x0e00, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/3/2/u = #2299 */
    { 0x0e01, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/2/0x1 = #2300 */
    { 0x0f7f, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/3/m = #2301 */
    { 0x0f00, 0xccba, 0xf481, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767) }, /* #46/3/3/u = #2302 */
    { 0x0f01, 0xccba, 0x7401, RTFLOAT80U_INIT_C(0,0x8245b83ddf122cc9,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #46/3/3/0x1 = #2303 */
    { 0x007f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/0/0/m = #2304 */
    { 0x0000, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/0/0/u = #2305 */
    { 0x0001, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/0/0/0x1 = #2306 */
    { 0x017f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/0/1/m = #2307 */
    { 0x0100, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/0/1/u = #2308 */
    { 0x0101, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/0/1/0x1 = #2309 */
    { 0x027f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/0/2/m = #2310 */
    { 0x0200, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/0/2/u = #2311 */
    { 0x0201, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/0/2/0x1 = #2312 */
    { 0x037f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/0/3/m = #2313 */
    { 0x0300, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/0/3/u = #2314 */
    { 0x0301, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/0/3/0x1 = #2315 */
    { 0x047f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/1/0/m = #2316 */
    { 0x0400, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/1/0/u = #2317 */
    { 0x0401, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/1/0/0x1 = #2318 */
    { 0x057f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/1/1/m = #2319 */
    { 0x0500, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/1/1/u = #2320 */
    { 0x0501, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/1/1/0x1 = #2321 */
    { 0x067f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/1/2/m = #2322 */
    { 0x0600, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/1/2/u = #2323 */
    { 0x0601, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/1/2/0x1 = #2324 */
    { 0x077f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/1/3/m = #2325 */
    { 0x0700, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/1/3/u = #2326 */
    { 0x0701, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/1/3/0x1 = #2327 */
    { 0x087f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/2/0/m = #2328 */
    { 0x0800, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/2/0/u = #2329 */
    { 0x0801, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/2/0/0x1 = #2330 */
    { 0x097f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/2/1/m = #2331 */
    { 0x0900, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/2/1/u = #2332 */
    { 0x0901, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/2/1/0x1 = #2333 */
    { 0x0a7f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/2/2/m = #2334 */
    { 0x0a00, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/2/2/u = #2335 */
    { 0x0a01, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/2/2/0x1 = #2336 */
    { 0x0b7f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/2/3/m = #2337 */
    { 0x0b00, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/2/3/u = #2338 */
    { 0x0b01, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/2/3/0x1 = #2339 */
    { 0x0c7f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/3/0/m = #2340 */
    { 0x0c00, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/3/0/u = #2341 */
    { 0x0c01, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/3/0/0x1 = #2342 */
    { 0x0d7f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/3/1/m = #2343 */
    { 0x0d00, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/3/1/u = #2344 */
    { 0x0d01, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/3/1/0x1 = #2345 */
    { 0x0e7f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/3/2/m = #2346 */
    { 0x0e00, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/3/2/u = #2347 */
    { 0x0e01, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/3/2/0x1 = #2348 */
    { 0x0f7f, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/3/3/m = #2349 */
    { 0x0f00, 0x78e8, 0xf081, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767) }, /* #47/3/3/u = #2350 */
    { 0x0f01, 0x78e8, 0x7001, RTFLOAT80U_INIT_C(0,0xb9fe522e1d21de30,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xf9fe522e1d21de30,32767) }, /* #47/3/3/0x1 = #2351 */
    { 0x007f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/0/0/m = #2352 */
    { 0x0000, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/0/0/u = #2353 */
    { 0x017f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/0/1/m = #2354 */
    { 0x0100, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/0/1/u = #2355 */
    { 0x027f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/0/2/m = #2356 */
    { 0x0200, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/0/2/u = #2357 */
    { 0x037f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/0/3/m = #2358 */
    { 0x0300, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/0/3/u = #2359 */
    { 0x047f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/1/0/m = #2360 */
    { 0x0400, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/1/0/u = #2361 */
    { 0x057f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/1/1/m = #2362 */
    { 0x0500, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/1/1/u = #2363 */
    { 0x067f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/1/2/m = #2364 */
    { 0x0600, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/1/2/u = #2365 */
    { 0x077f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/1/3/m = #2366 */
    { 0x0700, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/1/3/u = #2367 */
    { 0x087f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/2/0/m = #2368 */
    { 0x0800, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/2/0/u = #2369 */
    { 0x097f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/2/1/m = #2370 */
    { 0x0900, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/2/1/u = #2371 */
    { 0x0a7f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/2/2/m = #2372 */
    { 0x0a00, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/2/2/u = #2373 */
    { 0x0b7f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/2/3/m = #2374 */
    { 0x0b00, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/2/3/u = #2375 */
    { 0x0c7f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/3/0/m = #2376 */
    { 0x0c00, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/3/0/u = #2377 */
    { 0x0d7f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/3/1/m = #2378 */
    { 0x0d00, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/3/1/u = #2379 */
    { 0x0e7f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/3/2/m = #2380 */
    { 0x0e00, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/3/2/u = #2381 */
    { 0x0f7f, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/3/3/m = #2382 */
    { 0x0f00, 0x77ed, 0x7500, RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767), RTFLOAT80U_INIT_C(0,0xaaf7e5de19877812,23507), RTFLOAT80U_INIT_C(1,0xdbeeb210b96910d0,32767) }, /* #48/3/3/u = #2383 */
    { 0x007f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/0/0/m = #2384 */
    { 0x0000, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/0/0/u = #2385 */
    { 0x017f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/0/1/m = #2386 */
    { 0x0100, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/0/1/u = #2387 */
    { 0x027f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/0/2/m = #2388 */
    { 0x0200, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/0/2/u = #2389 */
    { 0x037f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/0/3/m = #2390 */
    { 0x0300, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/0/3/u = #2391 */
    { 0x047f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/1/0/m = #2392 */
    { 0x0400, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/1/0/u = #2393 */
    { 0x057f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/1/1/m = #2394 */
    { 0x0500, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/1/1/u = #2395 */
    { 0x067f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/1/2/m = #2396 */
    { 0x0600, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/1/2/u = #2397 */
    { 0x077f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/1/3/m = #2398 */
    { 0x0700, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/1/3/u = #2399 */
    { 0x087f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/2/0/m = #2400 */
    { 0x0800, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/2/0/u = #2401 */
    { 0x097f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/2/1/m = #2402 */
    { 0x0900, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/2/1/u = #2403 */
    { 0x0a7f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/2/2/m = #2404 */
    { 0x0a00, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/2/2/u = #2405 */
    { 0x0b7f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/2/3/m = #2406 */
    { 0x0b00, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/2/3/u = #2407 */
    { 0x0c7f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/3/0/m = #2408 */
    { 0x0c00, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/3/0/u = #2409 */
    { 0x0d7f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/3/1/m = #2410 */
    { 0x0d00, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/3/1/u = #2411 */
    { 0x0e7f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/3/2/m = #2412 */
    { 0x0e00, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/3/2/u = #2413 */
    { 0x0f7f, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/3/3/m = #2414 */
    { 0x0f00, 0xeac9, 0x7000, RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xf32906b150becd97,32767) }, /* #49/3/3/u = #2415 */
    { 0x007f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/0/0/m = #2416 */
    { 0x0000, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/0/0/u = #2417 */
    { 0x0001, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/0/0/0x1 = #2418 */
    { 0x017f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/0/1/m = #2419 */
    { 0x0100, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/0/1/u = #2420 */
    { 0x0101, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/0/1/0x1 = #2421 */
    { 0x027f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/0/2/m = #2422 */
    { 0x0200, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/0/2/u = #2423 */
    { 0x0201, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/0/2/0x1 = #2424 */
    { 0x037f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/0/3/m = #2425 */
    { 0x0300, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/0/3/u = #2426 */
    { 0x0301, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/0/3/0x1 = #2427 */
    { 0x047f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/1/0/m = #2428 */
    { 0x0400, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/1/0/u = #2429 */
    { 0x0401, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/1/0/0x1 = #2430 */
    { 0x057f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/1/1/m = #2431 */
    { 0x0500, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/1/1/u = #2432 */
    { 0x0501, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/1/1/0x1 = #2433 */
    { 0x067f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/1/2/m = #2434 */
    { 0x0600, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/1/2/u = #2435 */
    { 0x0601, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/1/2/0x1 = #2436 */
    { 0x077f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/1/3/m = #2437 */
    { 0x0700, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/1/3/u = #2438 */
    { 0x0701, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/1/3/0x1 = #2439 */
    { 0x087f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/2/0/m = #2440 */
    { 0x0800, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/2/0/u = #2441 */
    { 0x0801, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/2/0/0x1 = #2442 */
    { 0x097f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/2/1/m = #2443 */
    { 0x0900, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/2/1/u = #2444 */
    { 0x0901, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/2/1/0x1 = #2445 */
    { 0x0a7f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/2/2/m = #2446 */
    { 0x0a00, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/2/2/u = #2447 */
    { 0x0a01, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/2/2/0x1 = #2448 */
    { 0x0b7f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/2/3/m = #2449 */
    { 0x0b00, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/2/3/u = #2450 */
    { 0x0b01, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/2/3/0x1 = #2451 */
    { 0x0c7f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/3/0/m = #2452 */
    { 0x0c00, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/3/0/u = #2453 */
    { 0x0c01, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/3/0/0x1 = #2454 */
    { 0x0d7f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/3/1/m = #2455 */
    { 0x0d00, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/3/1/u = #2456 */
    { 0x0d01, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/3/1/0x1 = #2457 */
    { 0x0e7f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/3/2/m = #2458 */
    { 0x0e00, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/3/2/u = #2459 */
    { 0x0e01, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/3/2/0x1 = #2460 */
    { 0x0f7f, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/3/3/m = #2461 */
    { 0x0f00, 0x87b0, 0xb581, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767) }, /* #50/3/3/u = #2462 */
    { 0x0f01, 0x87b0, 0x3501, RTFLOAT80U_INIT_C(0,0xc2d72c07d00373de,32767), RTFLOAT80U_INIT_C(0,0x12ad087d5cb0b9b,24660), RTFLOAT80U_INIT_IND(1) }, /* #50/3/3/0x1 = #2463 */
    { 0x007f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/0/m = #2464 */
    { 0x0000, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/0/u = #2465 */
    { 0x0001, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/0/0x1 = #2466 */
    { 0x017f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/1/m = #2467 */
    { 0x0100, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/1/u = #2468 */
    { 0x0101, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/1/0x1 = #2469 */
    { 0x027f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/2/m = #2470 */
    { 0x0200, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/2/u = #2471 */
    { 0x0201, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/2/0x1 = #2472 */
    { 0x037f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/3/m = #2473 */
    { 0x0300, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/3/u = #2474 */
    { 0x0301, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/0/3/0x1 = #2475 */
    { 0x047f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/0/m = #2476 */
    { 0x0400, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/0/u = #2477 */
    { 0x0401, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/0/0x1 = #2478 */
    { 0x057f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/1/m = #2479 */
    { 0x0500, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/1/u = #2480 */
    { 0x0501, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/1/0x1 = #2481 */
    { 0x067f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/2/m = #2482 */
    { 0x0600, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/2/u = #2483 */
    { 0x0601, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/2/0x1 = #2484 */
    { 0x077f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/3/m = #2485 */
    { 0x0700, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/3/u = #2486 */
    { 0x0701, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/1/3/0x1 = #2487 */
    { 0x087f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/0/m = #2488 */
    { 0x0800, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/0/u = #2489 */
    { 0x0801, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/0/0x1 = #2490 */
    { 0x097f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/1/m = #2491 */
    { 0x0900, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/1/u = #2492 */
    { 0x0901, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/1/0x1 = #2493 */
    { 0x0a7f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/2/m = #2494 */
    { 0x0a00, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/2/u = #2495 */
    { 0x0a01, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/2/0x1 = #2496 */
    { 0x0b7f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/3/m = #2497 */
    { 0x0b00, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/3/u = #2498 */
    { 0x0b01, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/2/3/0x1 = #2499 */
    { 0x0c7f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/0/m = #2500 */
    { 0x0c00, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/0/u = #2501 */
    { 0x0c01, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/0/0x1 = #2502 */
    { 0x0d7f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/1/m = #2503 */
    { 0x0d00, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/1/u = #2504 */
    { 0x0d01, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/1/0x1 = #2505 */
    { 0x0e7f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/2/m = #2506 */
    { 0x0e00, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/2/u = #2507 */
    { 0x0e01, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/2/0x1 = #2508 */
    { 0x0f7f, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/3/m = #2509 */
    { 0x0f00, 0x051c, 0xb581, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/3/u = #2510 */
    { 0x0f01, 0x051c, 0x3501, RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767), RTFLOAT80U_INIT_C(1,0x91e4c6b8d7abe3ff,32767), RTFLOAT80U_INIT_C(1,0xe1bb99a3c7ee9dbd,32767) }, /* #51/3/3/0x1 = #2511 */
    { 0x007f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/0/0/m = #2512 */
    { 0x0000, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/0/0/u = #2513 */
    { 0x017f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/0/1/m = #2514 */
    { 0x0100, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/0/1/u = #2515 */
    { 0x027f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/0/2/m = #2516 */
    { 0x0200, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/0/2/u = #2517 */
    { 0x037f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/0/3/m = #2518 */
    { 0x0300, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/0/3/u = #2519 */
    { 0x047f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/1/0/m = #2520 */
    { 0x0400, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/1/0/u = #2521 */
    { 0x057f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/1/1/m = #2522 */
    { 0x0500, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/1/1/u = #2523 */
    { 0x067f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/1/2/m = #2524 */
    { 0x0600, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/1/2/u = #2525 */
    { 0x077f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/1/3/m = #2526 */
    { 0x0700, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/1/3/u = #2527 */
    { 0x087f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/2/0/m = #2528 */
    { 0x0800, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/2/0/u = #2529 */
    { 0x097f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/2/1/m = #2530 */
    { 0x0900, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/2/1/u = #2531 */
    { 0x0a7f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/2/2/m = #2532 */
    { 0x0a00, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/2/2/u = #2533 */
    { 0x0b7f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/2/3/m = #2534 */
    { 0x0b00, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/2/3/u = #2535 */
    { 0x0c7f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/3/0/m = #2536 */
    { 0x0c00, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/3/0/u = #2537 */
    { 0x0d7f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/3/1/m = #2538 */
    { 0x0d00, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/3/1/u = #2539 */
    { 0x0e7f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/3/2/m = #2540 */
    { 0x0e00, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/3/2/u = #2541 */
    { 0x0f7f, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/3/3/m = #2542 */
    { 0x0f00, 0xd36a, 0x7100, RTFLOAT80U_INIT_C(0,0xc9db31ef3a7dbf35,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767), RTFLOAT80U_INIT_C(1,0xe8ceb184e6b99fa0,32767) }, /* #52/3/3/u = #2543 */
    { 0x007f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/0/m = #2544 */
    { 0x0000, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/0/0/u = #2545 */
    { 0x0001, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/0/0x1 = #2546 */
    { 0x017f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/1/m = #2547 */
    { 0x0100, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/0/1/u = #2548 */
    { 0x0101, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/1/0x1 = #2549 */
    { 0x027f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/2/m = #2550 */
    { 0x0200, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/0/2/u = #2551 */
    { 0x0201, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/2/0x1 = #2552 */
    { 0x037f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/3/m = #2553 */
    { 0x0300, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/0/3/u = #2554 */
    { 0x0301, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/0/3/0x1 = #2555 */
    { 0x047f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/0/m = #2556 */
    { 0x0400, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/1/0/u = #2557 */
    { 0x0401, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/0/0x1 = #2558 */
    { 0x057f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/1/m = #2559 */
    { 0x0500, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/1/1/u = #2560 */
    { 0x0501, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/1/0x1 = #2561 */
    { 0x067f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/2/m = #2562 */
    { 0x0600, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/1/2/u = #2563 */
    { 0x0601, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/2/0x1 = #2564 */
    { 0x077f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/3/m = #2565 */
    { 0x0700, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/1/3/u = #2566 */
    { 0x0701, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/1/3/0x1 = #2567 */
    { 0x087f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/0/m = #2568 */
    { 0x0800, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/2/0/u = #2569 */
    { 0x0801, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/0/0x1 = #2570 */
    { 0x097f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/1/m = #2571 */
    { 0x0900, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/2/1/u = #2572 */
    { 0x0901, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/1/0x1 = #2573 */
    { 0x0a7f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/2/m = #2574 */
    { 0x0a00, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/2/2/u = #2575 */
    { 0x0a01, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/2/0x1 = #2576 */
    { 0x0b7f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/3/m = #2577 */
    { 0x0b00, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/2/3/u = #2578 */
    { 0x0b01, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/2/3/0x1 = #2579 */
    { 0x0c7f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/0/m = #2580 */
    { 0x0c00, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/3/0/u = #2581 */
    { 0x0c01, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/0/0x1 = #2582 */
    { 0x0d7f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/1/m = #2583 */
    { 0x0d00, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/3/1/u = #2584 */
    { 0x0d01, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/1/0x1 = #2585 */
    { 0x0e7f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/2/m = #2586 */
    { 0x0e00, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/3/2/u = #2587 */
    { 0x0e01, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/2/0x1 = #2588 */
    { 0x0f7f, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/3/m = #2589 */
    { 0x0f00, 0xa69b, 0xb481, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767) }, /* #53/3/3/u = #2590 */
    { 0x0f01, 0xa69b, 0x3401, RTFLOAT80U_INIT_C(1,0xe6e3aa1193183bb8,32767), RTFLOAT80U_INIT_C(0,0x524e9caab7037fab,32767), RTFLOAT80U_INIT_IND(1) }, /* #53/3/3/0x1 = #2591 */
    { 0x007f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/0/0/m = #2592 */
    { 0x0000, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/0/0/u = #2593 */
    { 0x017f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/0/1/m = #2594 */
    { 0x0100, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/0/1/u = #2595 */
    { 0x027f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/0/2/m = #2596 */
    { 0x0200, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/0/2/u = #2597 */
    { 0x037f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/0/3/m = #2598 */
    { 0x0300, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/0/3/u = #2599 */
    { 0x047f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/1/0/m = #2600 */
    { 0x0400, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/1/0/u = #2601 */
    { 0x057f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/1/1/m = #2602 */
    { 0x0500, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/1/1/u = #2603 */
    { 0x067f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/1/2/m = #2604 */
    { 0x0600, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/1/2/u = #2605 */
    { 0x077f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/1/3/m = #2606 */
    { 0x0700, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/1/3/u = #2607 */
    { 0x087f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/2/0/m = #2608 */
    { 0x0800, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/2/0/u = #2609 */
    { 0x097f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/2/1/m = #2610 */
    { 0x0900, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/2/1/u = #2611 */
    { 0x0a7f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/2/2/m = #2612 */
    { 0x0a00, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/2/2/u = #2613 */
    { 0x0b7f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/2/3/m = #2614 */
    { 0x0b00, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/2/3/u = #2615 */
    { 0x0c7f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/3/0/m = #2616 */
    { 0x0c00, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/3/0/u = #2617 */
    { 0x0d7f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/3/1/m = #2618 */
    { 0x0d00, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/3/1/u = #2619 */
    { 0x0e7f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/3/2/m = #2620 */
    { 0x0e00, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/3/2/u = #2621 */
    { 0x0f7f, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/3/3/m = #2622 */
    { 0x0f00, 0x3cc3, 0x3400, RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767), RTFLOAT80U_INIT_C(0,0x80d3d9463b5046d0,0), RTFLOAT80U_INIT_C(1,0xd207d1071eb2d83c,32767) }, /* #54/3/3/u = #2623 */
    { 0x007f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/0/0/m = #2624 */
    { 0x0000, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/0/0/u = #2625 */
    { 0x017f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/0/1/m = #2626 */
    { 0x0100, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/0/1/u = #2627 */
    { 0x027f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/0/2/m = #2628 */
    { 0x0200, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/0/2/u = #2629 */
    { 0x037f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/0/3/m = #2630 */
    { 0x0300, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/0/3/u = #2631 */
    { 0x047f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/1/0/m = #2632 */
    { 0x0400, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/1/0/u = #2633 */
    { 0x057f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/1/1/m = #2634 */
    { 0x0500, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/1/1/u = #2635 */
    { 0x067f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/1/2/m = #2636 */
    { 0x0600, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/1/2/u = #2637 */
    { 0x077f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/1/3/m = #2638 */
    { 0x0700, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/1/3/u = #2639 */
    { 0x087f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/2/0/m = #2640 */
    { 0x0800, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/2/0/u = #2641 */
    { 0x097f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/2/1/m = #2642 */
    { 0x0900, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/2/1/u = #2643 */
    { 0x0a7f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/2/2/m = #2644 */
    { 0x0a00, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/2/2/u = #2645 */
    { 0x0b7f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/2/3/m = #2646 */
    { 0x0b00, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/2/3/u = #2647 */
    { 0x0c7f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/3/0/m = #2648 */
    { 0x0c00, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/3/0/u = #2649 */
    { 0x0d7f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/3/1/m = #2650 */
    { 0x0d00, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/3/1/u = #2651 */
    { 0x0e7f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/3/2/m = #2652 */
    { 0x0e00, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/3/2/u = #2653 */
    { 0x0f7f, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/3/3/m = #2654 */
    { 0x0f00, 0x116e, 0x3100, RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767), RTFLOAT80U_INIT_C(1,0xe7eba3b1c24c5ba,0), RTFLOAT80U_INIT_C(0,0xe5e791896f3bfb79,32767) }, /* #55/3/3/u = #2655 */
    { 0x007f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/0/0/m = #2656 */
    { 0x0000, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/0/0/u = #2657 */
    { 0x017f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/0/1/m = #2658 */
    { 0x0100, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/0/1/u = #2659 */
    { 0x027f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/0/2/m = #2660 */
    { 0x0200, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/0/2/u = #2661 */
    { 0x037f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/0/3/m = #2662 */
    { 0x0300, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/0/3/u = #2663 */
    { 0x047f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/1/0/m = #2664 */
    { 0x0400, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/1/0/u = #2665 */
    { 0x057f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/1/1/m = #2666 */
    { 0x0500, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/1/1/u = #2667 */
    { 0x067f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/1/2/m = #2668 */
    { 0x0600, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/1/2/u = #2669 */
    { 0x077f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/1/3/m = #2670 */
    { 0x0700, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/1/3/u = #2671 */
    { 0x087f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/2/0/m = #2672 */
    { 0x0800, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/2/0/u = #2673 */
    { 0x097f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/2/1/m = #2674 */
    { 0x0900, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/2/1/u = #2675 */
    { 0x0a7f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/2/2/m = #2676 */
    { 0x0a00, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/2/2/u = #2677 */
    { 0x0b7f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/2/3/m = #2678 */
    { 0x0b00, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/2/3/u = #2679 */
    { 0x0c7f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/3/0/m = #2680 */
    { 0x0c00, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/3/0/u = #2681 */
    { 0x0d7f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/3/1/m = #2682 */
    { 0x0d00, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/3/1/u = #2683 */
    { 0x0e7f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/3/2/m = #2684 */
    { 0x0e00, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/3/2/u = #2685 */
    { 0x0f7f, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/3/3/m = #2686 */
    { 0x0f00, 0x5ef3, 0x7400, RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xe24bd375e9a770fd,32767) }, /* #56/3/3/u = #2687 */
    { 0x007f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/0/0/m = #2688 */
    { 0x0000, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/0/0/u = #2689 */
    { 0x017f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/0/1/m = #2690 */
    { 0x0100, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/0/1/u = #2691 */
    { 0x027f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/0/2/m = #2692 */
    { 0x0200, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/0/2/u = #2693 */
    { 0x037f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/0/3/m = #2694 */
    { 0x0300, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/0/3/u = #2695 */
    { 0x047f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/1/0/m = #2696 */
    { 0x0400, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/1/0/u = #2697 */
    { 0x057f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/1/1/m = #2698 */
    { 0x0500, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/1/1/u = #2699 */
    { 0x067f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/1/2/m = #2700 */
    { 0x0600, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/1/2/u = #2701 */
    { 0x077f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/1/3/m = #2702 */
    { 0x0700, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/1/3/u = #2703 */
    { 0x087f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/2/0/m = #2704 */
    { 0x0800, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/2/0/u = #2705 */
    { 0x097f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/2/1/m = #2706 */
    { 0x0900, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/2/1/u = #2707 */
    { 0x0a7f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/2/2/m = #2708 */
    { 0x0a00, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/2/2/u = #2709 */
    { 0x0b7f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/2/3/m = #2710 */
    { 0x0b00, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/2/3/u = #2711 */
    { 0x0c7f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/3/0/m = #2712 */
    { 0x0c00, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/3/0/u = #2713 */
    { 0x0d7f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/3/1/m = #2714 */
    { 0x0d00, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/3/1/u = #2715 */
    { 0x0e7f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/3/2/m = #2716 */
    { 0x0e00, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/3/2/u = #2717 */
    { 0x0f7f, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/3/3/m = #2718 */
    { 0x0f00, 0x6e26, 0x7400, RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xeada26901483852a,32767) }, /* #57/3/3/u = #2719 */
    { 0x007f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/0/m = #2720 */
    { 0x0000, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/0/0/u = #2721 */
    { 0x0001, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/0/0x1 = #2722 */
    { 0x017f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/1/m = #2723 */
    { 0x0100, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/0/1/u = #2724 */
    { 0x0101, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/1/0x1 = #2725 */
    { 0x027f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/2/m = #2726 */
    { 0x0200, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/0/2/u = #2727 */
    { 0x0201, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/2/0x1 = #2728 */
    { 0x037f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/3/m = #2729 */
    { 0x0300, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/0/3/u = #2730 */
    { 0x0301, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/0/3/0x1 = #2731 */
    { 0x047f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/0/m = #2732 */
    { 0x0400, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/1/0/u = #2733 */
    { 0x0401, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/0/0x1 = #2734 */
    { 0x057f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/1/m = #2735 */
    { 0x0500, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/1/1/u = #2736 */
    { 0x0501, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/1/0x1 = #2737 */
    { 0x067f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/2/m = #2738 */
    { 0x0600, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/1/2/u = #2739 */
    { 0x0601, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/2/0x1 = #2740 */
    { 0x077f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/3/m = #2741 */
    { 0x0700, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/1/3/u = #2742 */
    { 0x0701, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/1/3/0x1 = #2743 */
    { 0x087f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/0/m = #2744 */
    { 0x0800, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/2/0/u = #2745 */
    { 0x0801, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/0/0x1 = #2746 */
    { 0x097f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/1/m = #2747 */
    { 0x0900, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/2/1/u = #2748 */
    { 0x0901, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/1/0x1 = #2749 */
    { 0x0a7f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/2/m = #2750 */
    { 0x0a00, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/2/2/u = #2751 */
    { 0x0a01, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/2/0x1 = #2752 */
    { 0x0b7f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/3/m = #2753 */
    { 0x0b00, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/2/3/u = #2754 */
    { 0x0b01, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/2/3/0x1 = #2755 */
    { 0x0c7f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/0/m = #2756 */
    { 0x0c00, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/3/0/u = #2757 */
    { 0x0c01, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/0/0x1 = #2758 */
    { 0x0d7f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/1/m = #2759 */
    { 0x0d00, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/3/1/u = #2760 */
    { 0x0d01, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/1/0x1 = #2761 */
    { 0x0e7f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/2/m = #2762 */
    { 0x0e00, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/3/2/u = #2763 */
    { 0x0e01, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/2/0x1 = #2764 */
    { 0x0f7f, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/3/m = #2765 */
    { 0x0f00, 0x1b64, 0xb181, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767) }, /* #58/3/3/u = #2766 */
    { 0x0f01, 0x1b64, 0x3101, RTFLOAT80U_INIT_C(1,0xd6e3522eb5c29e8f,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #58/3/3/0x1 = #2767 */
    { 0x007f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/0/0/m = #2768 */
    { 0x0000, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/0/0/u = #2769 */
    { 0x017f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/0/1/m = #2770 */
    { 0x0100, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/0/1/u = #2771 */
    { 0x027f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/0/2/m = #2772 */
    { 0x0200, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/0/2/u = #2773 */
    { 0x037f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/0/3/m = #2774 */
    { 0x0300, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/0/3/u = #2775 */
    { 0x047f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/1/0/m = #2776 */
    { 0x0400, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/1/0/u = #2777 */
    { 0x057f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/1/1/m = #2778 */
    { 0x0500, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/1/1/u = #2779 */
    { 0x067f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/1/2/m = #2780 */
    { 0x0600, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/1/2/u = #2781 */
    { 0x077f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/1/3/m = #2782 */
    { 0x0700, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/1/3/u = #2783 */
    { 0x087f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/2/0/m = #2784 */
    { 0x0800, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/2/0/u = #2785 */
    { 0x097f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/2/1/m = #2786 */
    { 0x0900, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/2/1/u = #2787 */
    { 0x0a7f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/2/2/m = #2788 */
    { 0x0a00, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/2/2/u = #2789 */
    { 0x0b7f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/2/3/m = #2790 */
    { 0x0b00, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/2/3/u = #2791 */
    { 0x0c7f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/3/0/m = #2792 */
    { 0x0c00, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/3/0/u = #2793 */
    { 0x0d7f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/3/1/m = #2794 */
    { 0x0d00, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/3/1/u = #2795 */
    { 0x0e7f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/3/2/m = #2796 */
    { 0x0e00, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/3/2/u = #2797 */
    { 0x0f7f, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/3/3/m = #2798 */
    { 0x0f00, 0x47c6, 0x7500, RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xcc00c73a13ee1716,32767) }, /* #59/3/3/u = #2799 */
    { 0x007f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/0/0/m = #2800 */
    { 0x0000, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/0/0/u = #2801 */
    { 0x0001, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/0/0/0x1 = #2802 */
    { 0x017f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/0/1/m = #2803 */
    { 0x0100, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/0/1/u = #2804 */
    { 0x0101, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/0/1/0x1 = #2805 */
    { 0x027f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/0/2/m = #2806 */
    { 0x0200, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/0/2/u = #2807 */
    { 0x0201, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/0/2/0x1 = #2808 */
    { 0x037f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/0/3/m = #2809 */
    { 0x0300, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/0/3/u = #2810 */
    { 0x0301, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/0/3/0x1 = #2811 */
    { 0x047f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/1/0/m = #2812 */
    { 0x0400, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/1/0/u = #2813 */
    { 0x0401, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/1/0/0x1 = #2814 */
    { 0x057f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/1/1/m = #2815 */
    { 0x0500, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/1/1/u = #2816 */
    { 0x0501, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/1/1/0x1 = #2817 */
    { 0x067f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/1/2/m = #2818 */
    { 0x0600, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/1/2/u = #2819 */
    { 0x0601, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/1/2/0x1 = #2820 */
    { 0x077f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/1/3/m = #2821 */
    { 0x0700, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/1/3/u = #2822 */
    { 0x0701, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/1/3/0x1 = #2823 */
    { 0x087f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/2/0/m = #2824 */
    { 0x0800, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/2/0/u = #2825 */
    { 0x0801, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/2/0/0x1 = #2826 */
    { 0x097f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/2/1/m = #2827 */
    { 0x0900, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/2/1/u = #2828 */
    { 0x0901, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/2/1/0x1 = #2829 */
    { 0x0a7f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/2/2/m = #2830 */
    { 0x0a00, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/2/2/u = #2831 */
    { 0x0a01, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/2/2/0x1 = #2832 */
    { 0x0b7f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/2/3/m = #2833 */
    { 0x0b00, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/2/3/u = #2834 */
    { 0x0b01, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/2/3/0x1 = #2835 */
    { 0x0c7f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/3/0/m = #2836 */
    { 0x0c00, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/3/0/u = #2837 */
    { 0x0c01, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/3/0/0x1 = #2838 */
    { 0x0d7f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/3/1/m = #2839 */
    { 0x0d00, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/3/1/u = #2840 */
    { 0x0d01, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/3/1/0x1 = #2841 */
    { 0x0e7f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/3/2/m = #2842 */
    { 0x0e00, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/3/2/u = #2843 */
    { 0x0e01, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/3/2/0x1 = #2844 */
    { 0x0f7f, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/3/3/m = #2845 */
    { 0x0f00, 0x56fd, 0xf481, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767) }, /* #60/3/3/u = #2846 */
    { 0x0f01, 0x56fd, 0x7401, RTFLOAT80U_INIT_C(0,0xfcc23407c1bd6db,32767), RTFLOAT80U_INIT_C(0,0xd831f88f6bfe9c68,24723), RTFLOAT80U_INIT_IND(1) }, /* #60/3/3/0x1 = #2847 */
    { 0x007f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/0/0/m = #2848 */
    { 0x0000, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/0/0/u = #2849 */
    { 0x0001, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/0/0/0x1 = #2850 */
    { 0x017f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/0/1/m = #2851 */
    { 0x0100, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/0/1/u = #2852 */
    { 0x0101, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/0/1/0x1 = #2853 */
    { 0x027f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/0/2/m = #2854 */
    { 0x0200, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/0/2/u = #2855 */
    { 0x0201, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/0/2/0x1 = #2856 */
    { 0x037f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/0/3/m = #2857 */
    { 0x0300, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/0/3/u = #2858 */
    { 0x0301, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/0/3/0x1 = #2859 */
    { 0x047f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/1/0/m = #2860 */
    { 0x0400, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/1/0/u = #2861 */
    { 0x0401, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/1/0/0x1 = #2862 */
    { 0x057f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/1/1/m = #2863 */
    { 0x0500, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/1/1/u = #2864 */
    { 0x0501, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/1/1/0x1 = #2865 */
    { 0x067f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/1/2/m = #2866 */
    { 0x0600, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/1/2/u = #2867 */
    { 0x0601, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/1/2/0x1 = #2868 */
    { 0x077f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/1/3/m = #2869 */
    { 0x0700, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/1/3/u = #2870 */
    { 0x0701, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/1/3/0x1 = #2871 */
    { 0x087f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/2/0/m = #2872 */
    { 0x0800, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/2/0/u = #2873 */
    { 0x0801, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/2/0/0x1 = #2874 */
    { 0x097f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/2/1/m = #2875 */
    { 0x0900, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/2/1/u = #2876 */
    { 0x0901, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/2/1/0x1 = #2877 */
    { 0x0a7f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/2/2/m = #2878 */
    { 0x0a00, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/2/2/u = #2879 */
    { 0x0a01, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/2/2/0x1 = #2880 */
    { 0x0b7f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/2/3/m = #2881 */
    { 0x0b00, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/2/3/u = #2882 */
    { 0x0b01, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/2/3/0x1 = #2883 */
    { 0x0c7f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/3/0/m = #2884 */
    { 0x0c00, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/3/0/u = #2885 */
    { 0x0c01, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/3/0/0x1 = #2886 */
    { 0x0d7f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/3/1/m = #2887 */
    { 0x0d00, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/3/1/u = #2888 */
    { 0x0d01, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/3/1/0x1 = #2889 */
    { 0x0e7f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/3/2/m = #2890 */
    { 0x0e00, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/3/2/u = #2891 */
    { 0x0e01, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/3/2/0x1 = #2892 */
    { 0x0f7f, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/3/3/m = #2893 */
    { 0x0f00, 0xe5d3, 0xf581, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767) }, /* #61/3/3/u = #2894 */
    { 0x0f01, 0xe5d3, 0x7501, RTFLOAT80U_INIT_C(0,0x11d52477b1e6e2e7,32767), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_IND(1) }, /* #61/3/3/0x1 = #2895 */
    { 0x007f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/0/0/m = #2896 */
    { 0x0000, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/0/0/u = #2897 */
    { 0x0001, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/0/0/0x1 = #2898 */
    { 0x017f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/0/1/m = #2899 */
    { 0x0100, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/0/1/u = #2900 */
    { 0x0101, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/0/1/0x1 = #2901 */
    { 0x027f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/0/2/m = #2902 */
    { 0x0200, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/0/2/u = #2903 */
    { 0x0201, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/0/2/0x1 = #2904 */
    { 0x037f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/0/3/m = #2905 */
    { 0x0300, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/0/3/u = #2906 */
    { 0x0301, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/0/3/0x1 = #2907 */
    { 0x047f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/1/0/m = #2908 */
    { 0x0400, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/1/0/u = #2909 */
    { 0x0401, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/1/0/0x1 = #2910 */
    { 0x057f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/1/1/m = #2911 */
    { 0x0500, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/1/1/u = #2912 */
    { 0x0501, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/1/1/0x1 = #2913 */
    { 0x067f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/1/2/m = #2914 */
    { 0x0600, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/1/2/u = #2915 */
    { 0x0601, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/1/2/0x1 = #2916 */
    { 0x077f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/1/3/m = #2917 */
    { 0x0700, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/1/3/u = #2918 */
    { 0x0701, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/1/3/0x1 = #2919 */
    { 0x087f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/2/0/m = #2920 */
    { 0x0800, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/2/0/u = #2921 */
    { 0x0801, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/2/0/0x1 = #2922 */
    { 0x097f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/2/1/m = #2923 */
    { 0x0900, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/2/1/u = #2924 */
    { 0x0901, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/2/1/0x1 = #2925 */
    { 0x0a7f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/2/2/m = #2926 */
    { 0x0a00, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/2/2/u = #2927 */
    { 0x0a01, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/2/2/0x1 = #2928 */
    { 0x0b7f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/2/3/m = #2929 */
    { 0x0b00, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/2/3/u = #2930 */
    { 0x0b01, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/2/3/0x1 = #2931 */
    { 0x0c7f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/3/0/m = #2932 */
    { 0x0c00, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/3/0/u = #2933 */
    { 0x0c01, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/3/0/0x1 = #2934 */
    { 0x0d7f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/3/1/m = #2935 */
    { 0x0d00, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/3/1/u = #2936 */
    { 0x0d01, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/3/1/0x1 = #2937 */
    { 0x0e7f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/3/2/m = #2938 */
    { 0x0e00, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/3/2/u = #2939 */
    { 0x0e01, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/3/2/0x1 = #2940 */
    { 0x0f7f, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/3/3/m = #2941 */
    { 0x0f00, 0xbdcf, 0xb581, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767) }, /* #62/3/3/u = #2942 */
    { 0x0f01, 0xbdcf, 0x3501, RTFLOAT80U_INIT_C(0,0x6816318fafb4b1c,32767), RTFLOAT80U_INIT_C(1,0x56247ea1812ea37d,14483), RTFLOAT80U_INIT_IND(1) }, /* #62/3/3/0x1 = #2943 */
    { 0x007f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/0/m = #2944 */
    { 0x0000, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/0/0/u = #2945 */
    { 0x0001, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/0/0x1 = #2946 */
    { 0x017f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/1/m = #2947 */
    { 0x0100, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/0/1/u = #2948 */
    { 0x0101, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/1/0x1 = #2949 */
    { 0x027f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/2/m = #2950 */
    { 0x0200, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/0/2/u = #2951 */
    { 0x0201, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/2/0x1 = #2952 */
    { 0x037f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/3/m = #2953 */
    { 0x0300, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/0/3/u = #2954 */
    { 0x0301, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/0/3/0x1 = #2955 */
    { 0x047f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/0/m = #2956 */
    { 0x0400, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/1/0/u = #2957 */
    { 0x0401, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/0/0x1 = #2958 */
    { 0x057f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/1/m = #2959 */
    { 0x0500, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/1/1/u = #2960 */
    { 0x0501, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/1/0x1 = #2961 */
    { 0x067f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/2/m = #2962 */
    { 0x0600, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/1/2/u = #2963 */
    { 0x0601, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/2/0x1 = #2964 */
    { 0x077f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/3/m = #2965 */
    { 0x0700, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/1/3/u = #2966 */
    { 0x0701, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/1/3/0x1 = #2967 */
    { 0x087f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/0/m = #2968 */
    { 0x0800, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/2/0/u = #2969 */
    { 0x0801, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/0/0x1 = #2970 */
    { 0x097f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/1/m = #2971 */
    { 0x0900, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/2/1/u = #2972 */
    { 0x0901, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/1/0x1 = #2973 */
    { 0x0a7f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/2/m = #2974 */
    { 0x0a00, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/2/2/u = #2975 */
    { 0x0a01, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/2/0x1 = #2976 */
    { 0x0b7f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/3/m = #2977 */
    { 0x0b00, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/2/3/u = #2978 */
    { 0x0b01, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/2/3/0x1 = #2979 */
    { 0x0c7f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/0/m = #2980 */
    { 0x0c00, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/3/0/u = #2981 */
    { 0x0c01, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/0/0x1 = #2982 */
    { 0x0d7f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/1/m = #2983 */
    { 0x0d00, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/3/1/u = #2984 */
    { 0x0d01, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/1/0x1 = #2985 */
    { 0x0e7f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/2/m = #2986 */
    { 0x0e00, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/3/2/u = #2987 */
    { 0x0e01, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/2/0x1 = #2988 */
    { 0x0f7f, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/3/m = #2989 */
    { 0x0f00, 0xd5d9, 0xf581, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767) }, /* #63/3/3/u = #2990 */
    { 0x0f01, 0xd5d9, 0x7501, RTFLOAT80U_INIT_C(0,0x1f9b6abbf3509fb8,32767), RTFLOAT80U_INIT_C(0,0xadb50ebfb9eb02d5,32767), RTFLOAT80U_INIT_IND(1) }, /* #63/3/3/0x1 = #2991 */
    { 0x007f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/0/m = #2992 */
    { 0x0000, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/0/0/u = #2993 */
    { 0x0001, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/0/0x1 = #2994 */
    { 0x017f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/1/m = #2995 */
    { 0x0100, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/0/1/u = #2996 */
    { 0x0101, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/1/0x1 = #2997 */
    { 0x027f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/2/m = #2998 */
    { 0x0200, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/0/2/u = #2999 */
    { 0x0201, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/2/0x1 = #3000 */
    { 0x037f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/3/m = #3001 */
    { 0x0300, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/0/3/u = #3002 */
    { 0x0301, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/0/3/0x1 = #3003 */
    { 0x047f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/0/m = #3004 */
    { 0x0400, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/1/0/u = #3005 */
    { 0x0401, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/0/0x1 = #3006 */
    { 0x057f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/1/m = #3007 */
    { 0x0500, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/1/1/u = #3008 */
    { 0x0501, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/1/0x1 = #3009 */
    { 0x067f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/2/m = #3010 */
    { 0x0600, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/1/2/u = #3011 */
    { 0x0601, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/2/0x1 = #3012 */
    { 0x077f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/3/m = #3013 */
    { 0x0700, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/1/3/u = #3014 */
    { 0x0701, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/1/3/0x1 = #3015 */
    { 0x087f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/0/m = #3016 */
    { 0x0800, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/2/0/u = #3017 */
    { 0x0801, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/0/0x1 = #3018 */
    { 0x097f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/1/m = #3019 */
    { 0x0900, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/2/1/u = #3020 */
    { 0x0901, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/1/0x1 = #3021 */
    { 0x0a7f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/2/m = #3022 */
    { 0x0a00, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/2/2/u = #3023 */
    { 0x0a01, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/2/0x1 = #3024 */
    { 0x0b7f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/3/m = #3025 */
    { 0x0b00, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/2/3/u = #3026 */
    { 0x0b01, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/2/3/0x1 = #3027 */
    { 0x0c7f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/0/m = #3028 */
    { 0x0c00, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/3/0/u = #3029 */
    { 0x0c01, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/0/0x1 = #3030 */
    { 0x0d7f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/1/m = #3031 */
    { 0x0d00, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/3/1/u = #3032 */
    { 0x0d01, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/1/0x1 = #3033 */
    { 0x0e7f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/2/m = #3034 */
    { 0x0e00, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/3/2/u = #3035 */
    { 0x0e01, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/2/0x1 = #3036 */
    { 0x0f7f, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/3/m = #3037 */
    { 0x0f00, 0xe5aa, 0xf581, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767) }, /* #64/3/3/u = #3038 */
    { 0x0f01, 0xe5aa, 0x7501, RTFLOAT80U_INIT_C(0,0x2f448945cb1c2cf0,32767), RTFLOAT80U_INIT_C(1,0xef39be937764de0e,32767), RTFLOAT80U_INIT_IND(1) }, /* #64/3/3/0x1 = #3039 */
    { 0x007f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/0/m = #3040 */
    { 0x0000, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/0/0/u = #3041 */
    { 0x0001, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/0/0x1 = #3042 */
    { 0x017f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/1/m = #3043 */
    { 0x0100, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/0/1/u = #3044 */
    { 0x0101, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/1/0x1 = #3045 */
    { 0x027f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/2/m = #3046 */
    { 0x0200, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/0/2/u = #3047 */
    { 0x0201, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/2/0x1 = #3048 */
    { 0x037f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/3/m = #3049 */
    { 0x0300, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/0/3/u = #3050 */
    { 0x0301, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/0/3/0x1 = #3051 */
    { 0x047f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/0/m = #3052 */
    { 0x0400, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/1/0/u = #3053 */
    { 0x0401, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/0/0x1 = #3054 */
    { 0x057f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/1/m = #3055 */
    { 0x0500, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/1/1/u = #3056 */
    { 0x0501, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/1/0x1 = #3057 */
    { 0x067f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/2/m = #3058 */
    { 0x0600, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/1/2/u = #3059 */
    { 0x0601, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/2/0x1 = #3060 */
    { 0x077f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/3/m = #3061 */
    { 0x0700, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/1/3/u = #3062 */
    { 0x0701, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/1/3/0x1 = #3063 */
    { 0x087f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/0/m = #3064 */
    { 0x0800, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/2/0/u = #3065 */
    { 0x0801, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/0/0x1 = #3066 */
    { 0x097f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/1/m = #3067 */
    { 0x0900, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/2/1/u = #3068 */
    { 0x0901, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/1/0x1 = #3069 */
    { 0x0a7f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/2/m = #3070 */
    { 0x0a00, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/2/2/u = #3071 */
    { 0x0a01, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/2/0x1 = #3072 */
    { 0x0b7f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/3/m = #3073 */
    { 0x0b00, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/2/3/u = #3074 */
    { 0x0b01, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/2/3/0x1 = #3075 */
    { 0x0c7f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/0/m = #3076 */
    { 0x0c00, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/3/0/u = #3077 */
    { 0x0c01, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/0/0x1 = #3078 */
    { 0x0d7f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/1/m = #3079 */
    { 0x0d00, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/3/1/u = #3080 */
    { 0x0d01, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/1/0x1 = #3081 */
    { 0x0e7f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/2/m = #3082 */
    { 0x0e00, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/3/2/u = #3083 */
    { 0x0e01, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/2/0x1 = #3084 */
    { 0x0f7f, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/3/m = #3085 */
    { 0x0f00, 0x32f0, 0xb081, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767) }, /* #65/3/3/u = #3086 */
    { 0x0f01, 0x32f0, 0x3001, RTFLOAT80U_INIT_C(1,0x7793966e4881dbef,32767), RTFLOAT80U_INIT_C(0,0x62c0e105a90edfbb,32767), RTFLOAT80U_INIT_IND(1) }, /* #65/3/3/0x1 = #3087 */
    { 0x007f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/0/m = #3088 */
    { 0x0000, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/0/0/u = #3089 */
    { 0x0001, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/0/0x1 = #3090 */
    { 0x017f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/1/m = #3091 */
    { 0x0100, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/0/1/u = #3092 */
    { 0x0101, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/1/0x1 = #3093 */
    { 0x027f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/2/m = #3094 */
    { 0x0200, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/0/2/u = #3095 */
    { 0x0201, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/2/0x1 = #3096 */
    { 0x037f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/3/m = #3097 */
    { 0x0300, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/0/3/u = #3098 */
    { 0x0301, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/0/3/0x1 = #3099 */
    { 0x047f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/0/m = #3100 */
    { 0x0400, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/1/0/u = #3101 */
    { 0x0401, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/0/0x1 = #3102 */
    { 0x057f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/1/m = #3103 */
    { 0x0500, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/1/1/u = #3104 */
    { 0x0501, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/1/0x1 = #3105 */
    { 0x067f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/2/m = #3106 */
    { 0x0600, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/1/2/u = #3107 */
    { 0x0601, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/2/0x1 = #3108 */
    { 0x077f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/3/m = #3109 */
    { 0x0700, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/1/3/u = #3110 */
    { 0x0701, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/1/3/0x1 = #3111 */
    { 0x087f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/0/m = #3112 */
    { 0x0800, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/2/0/u = #3113 */
    { 0x0801, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/0/0x1 = #3114 */
    { 0x097f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/1/m = #3115 */
    { 0x0900, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/2/1/u = #3116 */
    { 0x0901, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/1/0x1 = #3117 */
    { 0x0a7f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/2/m = #3118 */
    { 0x0a00, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/2/2/u = #3119 */
    { 0x0a01, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/2/0x1 = #3120 */
    { 0x0b7f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/3/m = #3121 */
    { 0x0b00, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/2/3/u = #3122 */
    { 0x0b01, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/2/3/0x1 = #3123 */
    { 0x0c7f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/0/m = #3124 */
    { 0x0c00, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/3/0/u = #3125 */
    { 0x0c01, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/0/0x1 = #3126 */
    { 0x0d7f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/1/m = #3127 */
    { 0x0d00, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/3/1/u = #3128 */
    { 0x0d01, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/1/0x1 = #3129 */
    { 0x0e7f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/2/m = #3130 */
    { 0x0e00, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/3/2/u = #3131 */
    { 0x0e01, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/2/0x1 = #3132 */
    { 0x0f7f, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/3/m = #3133 */
    { 0x0f00, 0xb227, 0xb081, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767) }, /* #66/3/3/u = #3134 */
    { 0x0f01, 0xb227, 0x3001, RTFLOAT80U_INIT_C(1,0x4b8cc80466edc903,32767), RTFLOAT80U_INIT_C(0,0x9ac637f707335e88,0), RTFLOAT80U_INIT_IND(1) }, /* #66/3/3/0x1 = #3135 */
    { 0x007f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/0/m = #3136 */
    { 0x0000, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/0/0/u = #3137 */
    { 0x0001, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/0/0x1 = #3138 */
    { 0x017f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/1/m = #3139 */
    { 0x0100, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/0/1/u = #3140 */
    { 0x0101, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/1/0x1 = #3141 */
    { 0x027f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/2/m = #3142 */
    { 0x0200, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/0/2/u = #3143 */
    { 0x0201, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/2/0x1 = #3144 */
    { 0x037f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/3/m = #3145 */
    { 0x0300, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/0/3/u = #3146 */
    { 0x0301, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/0/3/0x1 = #3147 */
    { 0x047f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/0/m = #3148 */
    { 0x0400, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/1/0/u = #3149 */
    { 0x0401, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/0/0x1 = #3150 */
    { 0x057f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/1/m = #3151 */
    { 0x0500, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/1/1/u = #3152 */
    { 0x0501, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/1/0x1 = #3153 */
    { 0x067f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/2/m = #3154 */
    { 0x0600, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/1/2/u = #3155 */
    { 0x0601, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/2/0x1 = #3156 */
    { 0x077f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/3/m = #3157 */
    { 0x0700, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/1/3/u = #3158 */
    { 0x0701, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/1/3/0x1 = #3159 */
    { 0x087f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/0/m = #3160 */
    { 0x0800, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/2/0/u = #3161 */
    { 0x0801, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/0/0x1 = #3162 */
    { 0x097f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/1/m = #3163 */
    { 0x0900, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/2/1/u = #3164 */
    { 0x0901, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/1/0x1 = #3165 */
    { 0x0a7f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/2/m = #3166 */
    { 0x0a00, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/2/2/u = #3167 */
    { 0x0a01, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/2/0x1 = #3168 */
    { 0x0b7f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/3/m = #3169 */
    { 0x0b00, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/2/3/u = #3170 */
    { 0x0b01, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/2/3/0x1 = #3171 */
    { 0x0c7f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/0/m = #3172 */
    { 0x0c00, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/3/0/u = #3173 */
    { 0x0c01, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/0/0x1 = #3174 */
    { 0x0d7f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/1/m = #3175 */
    { 0x0d00, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/3/1/u = #3176 */
    { 0x0d01, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/1/0x1 = #3177 */
    { 0x0e7f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/2/m = #3178 */
    { 0x0e00, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/3/2/u = #3179 */
    { 0x0e01, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/2/0x1 = #3180 */
    { 0x0f7f, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/3/m = #3181 */
    { 0x0f00, 0x1c06, 0xb481, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767) }, /* #67/3/3/u = #3182 */
    { 0x0f01, 0x1c06, 0x3401, RTFLOAT80U_INIT_C(1,0x64f5ff7b33d7034f,32767), RTFLOAT80U_INIT_C(1,0x19f2ae5646a7ec98,0), RTFLOAT80U_INIT_IND(1) }, /* #67/3/3/0x1 = #3183 */
    { 0x007f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/0/m = #3184 */
    { 0x0000, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/0/0/u = #3185 */
    { 0x0001, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/0/0x1 = #3186 */
    { 0x017f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/1/m = #3187 */
    { 0x0100, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/0/1/u = #3188 */
    { 0x0101, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/1/0x1 = #3189 */
    { 0x027f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/2/m = #3190 */
    { 0x0200, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/0/2/u = #3191 */
    { 0x0201, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/2/0x1 = #3192 */
    { 0x037f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/3/m = #3193 */
    { 0x0300, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/0/3/u = #3194 */
    { 0x0301, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/0/3/0x1 = #3195 */
    { 0x047f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/0/m = #3196 */
    { 0x0400, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/1/0/u = #3197 */
    { 0x0401, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/0/0x1 = #3198 */
    { 0x057f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/1/m = #3199 */
    { 0x0500, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/1/1/u = #3200 */
    { 0x0501, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/1/0x1 = #3201 */
    { 0x067f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/2/m = #3202 */
    { 0x0600, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/1/2/u = #3203 */
    { 0x0601, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/2/0x1 = #3204 */
    { 0x077f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/3/m = #3205 */
    { 0x0700, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/1/3/u = #3206 */
    { 0x0701, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/1/3/0x1 = #3207 */
    { 0x087f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/0/m = #3208 */
    { 0x0800, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/2/0/u = #3209 */
    { 0x0801, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/0/0x1 = #3210 */
    { 0x097f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/1/m = #3211 */
    { 0x0900, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/2/1/u = #3212 */
    { 0x0901, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/1/0x1 = #3213 */
    { 0x0a7f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/2/m = #3214 */
    { 0x0a00, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/2/2/u = #3215 */
    { 0x0a01, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/2/0x1 = #3216 */
    { 0x0b7f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/3/m = #3217 */
    { 0x0b00, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/2/3/u = #3218 */
    { 0x0b01, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/2/3/0x1 = #3219 */
    { 0x0c7f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/0/m = #3220 */
    { 0x0c00, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/3/0/u = #3221 */
    { 0x0c01, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/0/0x1 = #3222 */
    { 0x0d7f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/1/m = #3223 */
    { 0x0d00, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/3/1/u = #3224 */
    { 0x0d01, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/1/0x1 = #3225 */
    { 0x0e7f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/2/m = #3226 */
    { 0x0e00, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/3/2/u = #3227 */
    { 0x0e01, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/2/0x1 = #3228 */
    { 0x0f7f, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/3/m = #3229 */
    { 0x0f00, 0x5a7a, 0xf081, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767) }, /* #68/3/3/u = #3230 */
    { 0x0f01, 0x5a7a, 0x7001, RTFLOAT80U_INIT_C(0,0x74836470e8abdb39,32767), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(1) }, /* #68/3/3/0x1 = #3231 */
    { 0x007f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/0/0/m = #3232 */
    { 0x0000, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/0/0/u = #3233 */
    { 0x0001, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/0/0/0x1 = #3234 */
    { 0x017f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/0/1/m = #3235 */
    { 0x0100, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/0/1/u = #3236 */
    { 0x0101, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/0/1/0x1 = #3237 */
    { 0x027f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/0/2/m = #3238 */
    { 0x0200, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/0/2/u = #3239 */
    { 0x0201, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/0/2/0x1 = #3240 */
    { 0x037f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/0/3/m = #3241 */
    { 0x0300, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/0/3/u = #3242 */
    { 0x0301, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/0/3/0x1 = #3243 */
    { 0x047f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/1/0/m = #3244 */
    { 0x0400, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/1/0/u = #3245 */
    { 0x0401, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/1/0/0x1 = #3246 */
    { 0x057f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/1/1/m = #3247 */
    { 0x0500, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/1/1/u = #3248 */
    { 0x0501, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/1/1/0x1 = #3249 */
    { 0x067f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/1/2/m = #3250 */
    { 0x0600, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/1/2/u = #3251 */
    { 0x0601, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/1/2/0x1 = #3252 */
    { 0x077f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/1/3/m = #3253 */
    { 0x0700, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/1/3/u = #3254 */
    { 0x0701, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/1/3/0x1 = #3255 */
    { 0x087f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/2/0/m = #3256 */
    { 0x0800, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/2/0/u = #3257 */
    { 0x0801, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/2/0/0x1 = #3258 */
    { 0x097f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/2/1/m = #3259 */
    { 0x0900, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/2/1/u = #3260 */
    { 0x0901, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/2/1/0x1 = #3261 */
    { 0x0a7f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/2/2/m = #3262 */
    { 0x0a00, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/2/2/u = #3263 */
    { 0x0a01, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/2/2/0x1 = #3264 */
    { 0x0b7f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/2/3/m = #3265 */
    { 0x0b00, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/2/3/u = #3266 */
    { 0x0b01, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/2/3/0x1 = #3267 */
    { 0x0c7f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/3/0/m = #3268 */
    { 0x0c00, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/3/0/u = #3269 */
    { 0x0c01, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/3/0/0x1 = #3270 */
    { 0x0d7f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/3/1/m = #3271 */
    { 0x0d00, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/3/1/u = #3272 */
    { 0x0d01, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/3/1/0x1 = #3273 */
    { 0x0e7f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/3/2/m = #3274 */
    { 0x0e00, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/3/2/u = #3275 */
    { 0x0e01, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/3/2/0x1 = #3276 */
    { 0x0f7f, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/3/3/m = #3277 */
    { 0x0f00, 0x5fb7, 0xf581, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767) }, /* #69/3/3/u = #3278 */
    { 0x0f01, 0x5fb7, 0x7501, RTFLOAT80U_INIT_C(1,0x1cdec25ec04abef6,32767), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #69/3/3/0x1 = #3279 */
    { 0x007f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/0/m = #3280 */
    { 0x0000, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/0/0/u = #3281 */
    { 0x0001, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/0/0x1 = #3282 */
    { 0x017f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/1/m = #3283 */
    { 0x0100, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/0/1/u = #3284 */
    { 0x0101, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/1/0x1 = #3285 */
    { 0x027f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/2/m = #3286 */
    { 0x0200, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/0/2/u = #3287 */
    { 0x0201, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/2/0x1 = #3288 */
    { 0x037f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/3/m = #3289 */
    { 0x0300, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/0/3/u = #3290 */
    { 0x0301, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/0/3/0x1 = #3291 */
    { 0x047f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/0/m = #3292 */
    { 0x0400, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/1/0/u = #3293 */
    { 0x0401, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/0/0x1 = #3294 */
    { 0x057f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/1/m = #3295 */
    { 0x0500, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/1/1/u = #3296 */
    { 0x0501, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/1/0x1 = #3297 */
    { 0x067f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/2/m = #3298 */
    { 0x0600, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/1/2/u = #3299 */
    { 0x0601, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/2/0x1 = #3300 */
    { 0x077f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/3/m = #3301 */
    { 0x0700, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/1/3/u = #3302 */
    { 0x0701, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/1/3/0x1 = #3303 */
    { 0x087f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/0/m = #3304 */
    { 0x0800, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/2/0/u = #3305 */
    { 0x0801, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/0/0x1 = #3306 */
    { 0x097f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/1/m = #3307 */
    { 0x0900, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/2/1/u = #3308 */
    { 0x0901, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/1/0x1 = #3309 */
    { 0x0a7f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/2/m = #3310 */
    { 0x0a00, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/2/2/u = #3311 */
    { 0x0a01, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/2/0x1 = #3312 */
    { 0x0b7f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/3/m = #3313 */
    { 0x0b00, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/2/3/u = #3314 */
    { 0x0b01, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/2/3/0x1 = #3315 */
    { 0x0c7f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/0/m = #3316 */
    { 0x0c00, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/3/0/u = #3317 */
    { 0x0c01, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/0/0x1 = #3318 */
    { 0x0d7f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/1/m = #3319 */
    { 0x0d00, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/3/1/u = #3320 */
    { 0x0d01, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/1/0x1 = #3321 */
    { 0x0e7f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/2/m = #3322 */
    { 0x0e00, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/3/2/u = #3323 */
    { 0x0e01, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/2/0x1 = #3324 */
    { 0x0f7f, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/3/m = #3325 */
    { 0x0f00, 0x6438, 0xf481, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767) }, /* #70/3/3/u = #3326 */
    { 0x0f01, 0x6438, 0x7401, RTFLOAT80U_INIT_C(0,0x5ec05b48fcb89efb,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #70/3/3/0x1 = #3327 */
    { 0x007f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/0/0/m = #3328 */
    { 0x0000, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/0/0/u = #3329 */
    { 0x0001, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/0/0/0x1 = #3330 */
    { 0x017f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/0/1/m = #3331 */
    { 0x0100, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/0/1/u = #3332 */
    { 0x0101, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/0/1/0x1 = #3333 */
    { 0x027f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/0/2/m = #3334 */
    { 0x0200, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/0/2/u = #3335 */
    { 0x0201, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/0/2/0x1 = #3336 */
    { 0x037f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/0/3/m = #3337 */
    { 0x0300, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/0/3/u = #3338 */
    { 0x0301, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/0/3/0x1 = #3339 */
    { 0x047f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/1/0/m = #3340 */
    { 0x0400, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/1/0/u = #3341 */
    { 0x0401, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/1/0/0x1 = #3342 */
    { 0x057f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/1/1/m = #3343 */
    { 0x0500, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/1/1/u = #3344 */
    { 0x0501, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/1/1/0x1 = #3345 */
    { 0x067f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/1/2/m = #3346 */
    { 0x0600, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/1/2/u = #3347 */
    { 0x0601, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/1/2/0x1 = #3348 */
    { 0x077f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/1/3/m = #3349 */
    { 0x0700, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/1/3/u = #3350 */
    { 0x0701, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/1/3/0x1 = #3351 */
    { 0x087f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/2/0/m = #3352 */
    { 0x0800, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/2/0/u = #3353 */
    { 0x0801, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/2/0/0x1 = #3354 */
    { 0x097f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/2/1/m = #3355 */
    { 0x0900, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/2/1/u = #3356 */
    { 0x0901, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/2/1/0x1 = #3357 */
    { 0x0a7f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/2/2/m = #3358 */
    { 0x0a00, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/2/2/u = #3359 */
    { 0x0a01, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/2/2/0x1 = #3360 */
    { 0x0b7f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/2/3/m = #3361 */
    { 0x0b00, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/2/3/u = #3362 */
    { 0x0b01, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/2/3/0x1 = #3363 */
    { 0x0c7f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/3/0/m = #3364 */
    { 0x0c00, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/3/0/u = #3365 */
    { 0x0c01, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/3/0/0x1 = #3366 */
    { 0x0d7f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/3/1/m = #3367 */
    { 0x0d00, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/3/1/u = #3368 */
    { 0x0d01, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/3/1/0x1 = #3369 */
    { 0x0e7f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/3/2/m = #3370 */
    { 0x0e00, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/3/2/u = #3371 */
    { 0x0e01, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/3/2/0x1 = #3372 */
    { 0x0f7f, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/3/3/m = #3373 */
    { 0x0f00, 0x8940, 0xb181, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767) }, /* #71/3/3/u = #3374 */
    { 0x0f01, 0x8940, 0x3101, RTFLOAT80U_INIT_C(0,0x7314357bbcff3c6d,32767), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_IND(1) }, /* #71/3/3/0x1 = #3375 */
    { 0x007f, 0x9532, 0x3722, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097120000000000,25578) }, /* #72/0/0/m = #3376 */
    { 0x0000, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/0/0/u = #3377 */
    { 0x0022, 0x9532, 0x3722, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097120000000000,25578) }, /* #72/0/0/0x22 = #3378 */
    { 0x0020, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/0/0/u0x2 = #3379 */
    { 0x0002, 0x9532, 0xb7a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097120000000000,25578) }, /* #72/0/0/u0x20 = #3380 */
    { 0x017f, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/0/1/m = #3381 */
    { 0x0100, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/0/1/u = #3382 */
    { 0x0122, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/0/1/0x22 = #3383 */
    { 0x0120, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/0/1/u0x2 = #3384 */
    { 0x0102, 0x9532, 0xb5a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/0/1/u0x20 = #3385 */
    { 0x027f, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8000,25578) }, /* #72/0/2/m = #3386 */
    { 0x0200, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/0/2/u = #3387 */
    { 0x0222, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8000,25578) }, /* #72/0/2/0x22 = #3388 */
    { 0x0220, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/0/2/u0x2 = #3389 */
    { 0x0202, 0x9532, 0xb5a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8000,25578) }, /* #72/0/2/u0x20 = #3390 */
    { 0x037f, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/0/3/m = #3391 */
    { 0x0300, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/0/3/u = #3392 */
    { 0x0322, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/0/3/0x22 = #3393 */
    { 0x0320, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/0/3/u0x2 = #3394 */
    { 0x0302, 0x9532, 0xb5a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/0/3/u0x20 = #3395 */
    { 0x047f, 0x9532, 0x3722, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097120000000000,25578) }, /* #72/1/0/m = #3396 */
    { 0x0400, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/1/0/u = #3397 */
    { 0x0422, 0x9532, 0x3722, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097120000000000,25578) }, /* #72/1/0/0x22 = #3398 */
    { 0x0420, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/1/0/u0x2 = #3399 */
    { 0x0402, 0x9532, 0xb7a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097120000000000,25578) }, /* #72/1/0/u0x20 = #3400 */
    { 0x057f, 0x9532, 0x3722, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8375,25578) }, /* #72/1/1/m = #3401 */
    { 0x0500, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/1/1/u = #3402 */
    { 0x0522, 0x9532, 0x3722, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8375,25578) }, /* #72/1/1/0x22 = #3403 */
    { 0x0520, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/1/1/u0x2 = #3404 */
    { 0x0502, 0x9532, 0xb7a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8375,25578) }, /* #72/1/1/u0x20 = #3405 */
    { 0x067f, 0x9532, 0x3722, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8800,25578) }, /* #72/1/2/m = #3406 */
    { 0x0600, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/1/2/u = #3407 */
    { 0x0622, 0x9532, 0x3722, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8800,25578) }, /* #72/1/2/0x22 = #3408 */
    { 0x0620, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/1/2/u0x2 = #3409 */
    { 0x0602, 0x9532, 0xb7a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8800,25578) }, /* #72/1/2/u0x20 = #3410 */
    { 0x077f, 0x9532, 0x3722, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8375,25578) }, /* #72/1/3/m = #3411 */
    { 0x0700, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/1/3/u = #3412 */
    { 0x0722, 0x9532, 0x3722, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8375,25578) }, /* #72/1/3/0x22 = #3413 */
    { 0x0720, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/1/3/u0x2 = #3414 */
    { 0x0702, 0x9532, 0xb7a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8375,25578) }, /* #72/1/3/u0x20 = #3415 */
    { 0x087f, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097110000000000,25578) }, /* #72/2/0/m = #3416 */
    { 0x0800, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/2/0/u = #3417 */
    { 0x0822, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097110000000000,25578) }, /* #72/2/0/0x22 = #3418 */
    { 0x0820, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/2/0/u0x2 = #3419 */
    { 0x0802, 0x9532, 0xb5a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097110000000000,25578) }, /* #72/2/0/u0x20 = #3420 */
    { 0x097f, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/2/1/m = #3421 */
    { 0x0900, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/2/1/u = #3422 */
    { 0x0922, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/2/1/0x22 = #3423 */
    { 0x0920, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/2/1/u0x2 = #3424 */
    { 0x0902, 0x9532, 0xb5a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/2/1/u0x20 = #3425 */
    { 0x0a7f, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8000,25578) }, /* #72/2/2/m = #3426 */
    { 0x0a00, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/2/2/u = #3427 */
    { 0x0a22, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8000,25578) }, /* #72/2/2/0x22 = #3428 */
    { 0x0a20, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/2/2/u0x2 = #3429 */
    { 0x0a02, 0x9532, 0xb5a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8000,25578) }, /* #72/2/2/u0x20 = #3430 */
    { 0x0b7f, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/2/3/m = #3431 */
    { 0x0b00, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/2/3/u = #3432 */
    { 0x0b22, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/2/3/0x22 = #3433 */
    { 0x0b20, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/2/3/u0x2 = #3434 */
    { 0x0b02, 0x9532, 0xb5a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/2/3/u0x20 = #3435 */
    { 0x0c7f, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097110000000000,25578) }, /* #72/3/0/m = #3436 */
    { 0x0c00, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/3/0/u = #3437 */
    { 0x0c22, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097110000000000,25578) }, /* #72/3/0/0x22 = #3438 */
    { 0x0c20, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/3/0/u0x2 = #3439 */
    { 0x0c02, 0x9532, 0xb5a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc097110000000000,25578) }, /* #72/3/0/u0x20 = #3440 */
    { 0x0d7f, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/3/1/m = #3441 */
    { 0x0d00, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/3/1/u = #3442 */
    { 0x0d22, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/3/1/0x22 = #3443 */
    { 0x0d20, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/3/1/u0x2 = #3444 */
    { 0x0d02, 0x9532, 0xb5a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/3/1/u0x20 = #3445 */
    { 0x0e7f, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8000,25578) }, /* #72/3/2/m = #3446 */
    { 0x0e00, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/3/2/u = #3447 */
    { 0x0e22, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8000,25578) }, /* #72/3/2/0x22 = #3448 */
    { 0x0e20, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/3/2/u0x2 = #3449 */
    { 0x0e02, 0x9532, 0xb5a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8000,25578) }, /* #72/3/2/u0x20 = #3450 */
    { 0x0f7f, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/3/3/m = #3451 */
    { 0x0f00, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/3/3/u = #3452 */
    { 0x0f22, 0x9532, 0x3522, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/3/3/0x22 = #3453 */
    { 0x0f20, 0x9532, 0xb582, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0) }, /* #72/3/3/u0x2 = #3454 */
    { 0x0f02, 0x9532, 0xb5a2, RTFLOAT80U_INIT_C(1,0x989b7a7c1034ec59,0), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578), RTFLOAT80U_INIT_C(1,0xc09711b9a20a8374,25578) }, /* #72/3/3/u0x20 = #3455 */
    { 0x007f, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/0/0/m = #3456 */
    { 0x0000, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/0/0/u = #3457 */
    { 0x0022, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/0/0/0x22 = #3458 */
    { 0x0020, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/0/0/u0x2 = #3459 */
    { 0x0002, 0xbf97, 0xb7a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/0/0/u0x20 = #3460 */
    { 0x017f, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/0/1/m = #3461 */
    { 0x0100, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/0/1/u = #3462 */
    { 0x0122, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/0/1/0x22 = #3463 */
    { 0x0120, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/0/1/u0x2 = #3464 */
    { 0x0102, 0xbf97, 0xb7a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/0/1/u0x20 = #3465 */
    { 0x027f, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/0/2/m = #3466 */
    { 0x0200, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/0/2/u = #3467 */
    { 0x0222, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/0/2/0x22 = #3468 */
    { 0x0220, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/0/2/u0x2 = #3469 */
    { 0x0202, 0xbf97, 0xb7a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/0/2/u0x20 = #3470 */
    { 0x037f, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/0/3/m = #3471 */
    { 0x0300, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/0/3/u = #3472 */
    { 0x0322, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/0/3/0x22 = #3473 */
    { 0x0320, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/0/3/u0x2 = #3474 */
    { 0x0302, 0xbf97, 0xb7a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/0/3/u0x20 = #3475 */
    { 0x047f, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/1/0/m = #3476 */
    { 0x0400, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/1/0/u = #3477 */
    { 0x0422, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/1/0/0x22 = #3478 */
    { 0x0420, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/1/0/u0x2 = #3479 */
    { 0x0402, 0xbf97, 0xb7a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/1/0/u0x20 = #3480 */
    { 0x057f, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/1/1/m = #3481 */
    { 0x0500, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/1/1/u = #3482 */
    { 0x0522, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/1/1/0x22 = #3483 */
    { 0x0520, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/1/1/u0x2 = #3484 */
    { 0x0502, 0xbf97, 0xb7a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/1/1/u0x20 = #3485 */
    { 0x067f, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/1/2/m = #3486 */
    { 0x0600, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/1/2/u = #3487 */
    { 0x0622, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/1/2/0x22 = #3488 */
    { 0x0620, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/1/2/u0x2 = #3489 */
    { 0x0602, 0xbf97, 0xb7a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0x8000000000000000,30316) }, /* #73/1/2/u0x20 = #3490 */
    { 0x077f, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/1/3/m = #3491 */
    { 0x0700, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/1/3/u = #3492 */
    { 0x0722, 0xbf97, 0x3722, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/1/3/0x22 = #3493 */
    { 0x0720, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/1/3/u0x2 = #3494 */
    { 0x0702, 0xbf97, 0xb7a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315) }, /* #73/1/3/u0x20 = #3495 */
    { 0x087f, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffff0000000000,30315) }, /* #73/2/0/m = #3496 */
    { 0x0800, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/2/0/u = #3497 */
    { 0x0822, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffff0000000000,30315) }, /* #73/2/0/0x22 = #3498 */
    { 0x0820, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/2/0/u0x2 = #3499 */
    { 0x0802, 0xbf97, 0xb5a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffff0000000000,30315) }, /* #73/2/0/u0x20 = #3500 */
    { 0x097f, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/2/1/m = #3501 */
    { 0x0900, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/2/1/u = #3502 */
    { 0x0922, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/2/1/0x22 = #3503 */
    { 0x0920, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/2/1/u0x2 = #3504 */
    { 0x0902, 0xbf97, 0xb5a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/2/1/u0x20 = #3505 */
    { 0x0a7f, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,30315) }, /* #73/2/2/m = #3506 */
    { 0x0a00, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/2/2/u = #3507 */
    { 0x0a22, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,30315) }, /* #73/2/2/0x22 = #3508 */
    { 0x0a20, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/2/2/u0x2 = #3509 */
    { 0x0a02, 0xbf97, 0xb5a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,30315) }, /* #73/2/2/u0x20 = #3510 */
    { 0x0b7f, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/2/3/m = #3511 */
    { 0x0b00, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/2/3/u = #3512 */
    { 0x0b22, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/2/3/0x22 = #3513 */
    { 0x0b20, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/2/3/u0x2 = #3514 */
    { 0x0b02, 0xbf97, 0xb5a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/2/3/u0x20 = #3515 */
    { 0x0c7f, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffff0000000000,30315) }, /* #73/3/0/m = #3516 */
    { 0x0c00, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/3/0/u = #3517 */
    { 0x0c22, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffff0000000000,30315) }, /* #73/3/0/0x22 = #3518 */
    { 0x0c20, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/3/0/u0x2 = #3519 */
    { 0x0c02, 0xbf97, 0xb5a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xffffff0000000000,30315) }, /* #73/3/0/u0x20 = #3520 */
    { 0x0d7f, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/3/1/m = #3521 */
    { 0x0d00, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/3/1/u = #3522 */
    { 0x0d22, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/3/1/0x22 = #3523 */
    { 0x0d20, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/3/1/u0x2 = #3524 */
    { 0x0d02, 0xbf97, 0xb5a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/3/1/u0x20 = #3525 */
    { 0x0e7f, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,30315) }, /* #73/3/2/m = #3526 */
    { 0x0e00, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/3/2/u = #3527 */
    { 0x0e22, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,30315) }, /* #73/3/2/0x22 = #3528 */
    { 0x0e20, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/3/2/u0x2 = #3529 */
    { 0x0e02, 0xbf97, 0xb5a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,30315) }, /* #73/3/2/u0x20 = #3530 */
    { 0x0f7f, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/3/3/m = #3531 */
    { 0x0f00, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/3/3/u = #3532 */
    { 0x0f22, 0xbf97, 0x3522, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/3/3/0x22 = #3533 */
    { 0x0f20, 0xbf97, 0xb582, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0) }, /* #73/3/3/u0x2 = #3534 */
    { 0x0f02, 0xbf97, 0xb5a2, RTFLOAT80U_INIT_C(0,0xbf2c6746ea96d15a,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,30315), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,30315) }, /* #73/3/3/u0x20 = #3535 */
    { 0x007f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/0/0/m = #3536 */
    { 0x0000, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/0/0/u = #3537 */
    { 0x0001, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/0/0/0x1 = #3538 */
    { 0x017f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/0/1/m = #3539 */
    { 0x0100, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/0/1/u = #3540 */
    { 0x0101, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/0/1/0x1 = #3541 */
    { 0x027f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/0/2/m = #3542 */
    { 0x0200, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/0/2/u = #3543 */
    { 0x0201, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/0/2/0x1 = #3544 */
    { 0x037f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/0/3/m = #3545 */
    { 0x0300, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/0/3/u = #3546 */
    { 0x0301, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/0/3/0x1 = #3547 */
    { 0x047f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/1/0/m = #3548 */
    { 0x0400, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/1/0/u = #3549 */
    { 0x0401, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/1/0/0x1 = #3550 */
    { 0x057f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/1/1/m = #3551 */
    { 0x0500, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/1/1/u = #3552 */
    { 0x0501, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/1/1/0x1 = #3553 */
    { 0x067f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/1/2/m = #3554 */
    { 0x0600, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/1/2/u = #3555 */
    { 0x0601, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/1/2/0x1 = #3556 */
    { 0x077f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/1/3/m = #3557 */
    { 0x0700, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/1/3/u = #3558 */
    { 0x0701, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/1/3/0x1 = #3559 */
    { 0x087f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/2/0/m = #3560 */
    { 0x0800, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/2/0/u = #3561 */
    { 0x0801, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/2/0/0x1 = #3562 */
    { 0x097f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/2/1/m = #3563 */
    { 0x0900, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/2/1/u = #3564 */
    { 0x0901, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/2/1/0x1 = #3565 */
    { 0x0a7f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/2/2/m = #3566 */
    { 0x0a00, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/2/2/u = #3567 */
    { 0x0a01, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/2/2/0x1 = #3568 */
    { 0x0b7f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/2/3/m = #3569 */
    { 0x0b00, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/2/3/u = #3570 */
    { 0x0b01, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/2/3/0x1 = #3571 */
    { 0x0c7f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/3/0/m = #3572 */
    { 0x0c00, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/3/0/u = #3573 */
    { 0x0c01, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/3/0/0x1 = #3574 */
    { 0x0d7f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/3/1/m = #3575 */
    { 0x0d00, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/3/1/u = #3576 */
    { 0x0d01, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/3/1/0x1 = #3577 */
    { 0x0e7f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/3/2/m = #3578 */
    { 0x0e00, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/3/2/u = #3579 */
    { 0x0e01, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/3/2/0x1 = #3580 */
    { 0x0f7f, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/3/3/m = #3581 */
    { 0x0f00, 0x422a, 0xf081, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0) }, /* #74/3/3/u = #3582 */
    { 0x0f01, 0x422a, 0x7001, RTFLOAT80U_INIT_C(1,0xda0740ca47cddcdb,0), RTFLOAT80U_INIT_C(1,0x79748869c95c3b6a,370), RTFLOAT80U_INIT_IND(1) }, /* #74/3/3/0x1 = #3583 */
    { 0x007f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/0/0/m = #3584 */
    { 0x0000, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/0/0/u = #3585 */
    { 0x0001, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/0/0/0x1 = #3586 */
    { 0x017f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/0/1/m = #3587 */
    { 0x0100, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/0/1/u = #3588 */
    { 0x0101, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/0/1/0x1 = #3589 */
    { 0x027f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/0/2/m = #3590 */
    { 0x0200, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/0/2/u = #3591 */
    { 0x0201, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/0/2/0x1 = #3592 */
    { 0x037f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/0/3/m = #3593 */
    { 0x0300, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/0/3/u = #3594 */
    { 0x0301, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/0/3/0x1 = #3595 */
    { 0x047f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/1/0/m = #3596 */
    { 0x0400, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/1/0/u = #3597 */
    { 0x0401, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/1/0/0x1 = #3598 */
    { 0x057f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/1/1/m = #3599 */
    { 0x0500, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/1/1/u = #3600 */
    { 0x0501, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/1/1/0x1 = #3601 */
    { 0x067f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/1/2/m = #3602 */
    { 0x0600, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/1/2/u = #3603 */
    { 0x0601, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/1/2/0x1 = #3604 */
    { 0x077f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/1/3/m = #3605 */
    { 0x0700, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/1/3/u = #3606 */
    { 0x0701, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/1/3/0x1 = #3607 */
    { 0x087f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/2/0/m = #3608 */
    { 0x0800, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/2/0/u = #3609 */
    { 0x0801, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/2/0/0x1 = #3610 */
    { 0x097f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/2/1/m = #3611 */
    { 0x0900, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/2/1/u = #3612 */
    { 0x0901, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/2/1/0x1 = #3613 */
    { 0x0a7f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/2/2/m = #3614 */
    { 0x0a00, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/2/2/u = #3615 */
    { 0x0a01, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/2/2/0x1 = #3616 */
    { 0x0b7f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/2/3/m = #3617 */
    { 0x0b00, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/2/3/u = #3618 */
    { 0x0b01, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/2/3/0x1 = #3619 */
    { 0x0c7f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/3/0/m = #3620 */
    { 0x0c00, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/3/0/u = #3621 */
    { 0x0c01, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/3/0/0x1 = #3622 */
    { 0x0d7f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/3/1/m = #3623 */
    { 0x0d00, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/3/1/u = #3624 */
    { 0x0d01, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/3/1/0x1 = #3625 */
    { 0x0e7f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/3/2/m = #3626 */
    { 0x0e00, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/3/2/u = #3627 */
    { 0x0e01, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/3/2/0x1 = #3628 */
    { 0x0f7f, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/3/3/m = #3629 */
    { 0x0f00, 0x839a, 0xb181, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0) }, /* #75/3/3/u = #3630 */
    { 0x0f01, 0x839a, 0x3101, RTFLOAT80U_INIT_C(0,0xb0a11ca6503f69df,0), RTFLOAT80U_INIT_C(0,0xbb758a0f1e2e39b6,32767), RTFLOAT80U_INIT_C(0,0xfb758a0f1e2e39b6,32767) }, /* #75/3/3/0x1 = #3631 */
    { 0x007f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/0/0/m = #3632 */
    { 0x0000, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/0/0/u = #3633 */
    { 0x017f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/0/1/m = #3634 */
    { 0x0100, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/0/1/u = #3635 */
    { 0x027f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/0/2/m = #3636 */
    { 0x0200, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/0/2/u = #3637 */
    { 0x037f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/0/3/m = #3638 */
    { 0x0300, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/0/3/u = #3639 */
    { 0x047f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/1/0/m = #3640 */
    { 0x0400, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/1/0/u = #3641 */
    { 0x057f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/1/1/m = #3642 */
    { 0x0500, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/1/1/u = #3643 */
    { 0x067f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/1/2/m = #3644 */
    { 0x0600, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/1/2/u = #3645 */
    { 0x077f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/1/3/m = #3646 */
    { 0x0700, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/1/3/u = #3647 */
    { 0x087f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/2/0/m = #3648 */
    { 0x0800, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/2/0/u = #3649 */
    { 0x097f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/2/1/m = #3650 */
    { 0x0900, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/2/1/u = #3651 */
    { 0x0a7f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/2/2/m = #3652 */
    { 0x0a00, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/2/2/u = #3653 */
    { 0x0b7f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/2/3/m = #3654 */
    { 0x0b00, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/2/3/u = #3655 */
    { 0x0c7f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/3/0/m = #3656 */
    { 0x0c00, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/3/0/u = #3657 */
    { 0x0d7f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/3/1/m = #3658 */
    { 0x0d00, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/3/1/u = #3659 */
    { 0x0e7f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/3/2/m = #3660 */
    { 0x0e00, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/3/2/u = #3661 */
    { 0x0f7f, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/3/3/m = #3662 */
    { 0x0f00, 0x67e5, 0x7500, RTFLOAT80U_INIT_C(0,0xbaaae3888ae53359,0), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767), RTFLOAT80U_INIT_C(0,0xd80563d0dc6174ad,32767) }, /* #76/3/3/u = #3663 */
    { 0x007f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/0/m = #3664 */
    { 0x0000, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/0/0/u = #3665 */
    { 0x0001, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/0/0x1 = #3666 */
    { 0x017f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/1/m = #3667 */
    { 0x0100, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/0/1/u = #3668 */
    { 0x0101, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/1/0x1 = #3669 */
    { 0x027f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/2/m = #3670 */
    { 0x0200, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/0/2/u = #3671 */
    { 0x0201, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/2/0x1 = #3672 */
    { 0x037f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/3/m = #3673 */
    { 0x0300, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/0/3/u = #3674 */
    { 0x0301, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/0/3/0x1 = #3675 */
    { 0x047f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/0/m = #3676 */
    { 0x0400, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/1/0/u = #3677 */
    { 0x0401, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/0/0x1 = #3678 */
    { 0x057f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/1/m = #3679 */
    { 0x0500, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/1/1/u = #3680 */
    { 0x0501, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/1/0x1 = #3681 */
    { 0x067f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/2/m = #3682 */
    { 0x0600, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/1/2/u = #3683 */
    { 0x0601, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/2/0x1 = #3684 */
    { 0x077f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/3/m = #3685 */
    { 0x0700, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/1/3/u = #3686 */
    { 0x0701, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/1/3/0x1 = #3687 */
    { 0x087f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/0/m = #3688 */
    { 0x0800, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/2/0/u = #3689 */
    { 0x0801, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/0/0x1 = #3690 */
    { 0x097f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/1/m = #3691 */
    { 0x0900, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/2/1/u = #3692 */
    { 0x0901, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/1/0x1 = #3693 */
    { 0x0a7f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/2/m = #3694 */
    { 0x0a00, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/2/2/u = #3695 */
    { 0x0a01, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/2/0x1 = #3696 */
    { 0x0b7f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/3/m = #3697 */
    { 0x0b00, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/2/3/u = #3698 */
    { 0x0b01, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/2/3/0x1 = #3699 */
    { 0x0c7f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/0/m = #3700 */
    { 0x0c00, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/3/0/u = #3701 */
    { 0x0c01, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/0/0x1 = #3702 */
    { 0x0d7f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/1/m = #3703 */
    { 0x0d00, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/3/1/u = #3704 */
    { 0x0d01, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/1/0x1 = #3705 */
    { 0x0e7f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/2/m = #3706 */
    { 0x0e00, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/3/2/u = #3707 */
    { 0x0e01, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/2/0x1 = #3708 */
    { 0x0f7f, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/3/m = #3709 */
    { 0x0f00, 0xaf90, 0xb581, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0) }, /* #77/3/3/u = #3710 */
    { 0x0f01, 0xaf90, 0x3501, RTFLOAT80U_INIT_C(0,0xa7068dfb04c81691,0), RTFLOAT80U_INIT_C(0,0x104abc1eb1e96301,32767), RTFLOAT80U_INIT_IND(1) }, /* #77/3/3/0x1 = #3711 */
    { 0x007f, 0x4a0c, 0x7032, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a0000000000,0) }, /* #78/0/0/m = #3712 */
    { 0x0000, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/0/0/u = #3713 */
    { 0x0032, 0x4a0c, 0x7032, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a0000000000,0) }, /* #78/0/0/0x32 = #3714 */
    { 0x0030, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/0/0/u0x2 = #3715 */
    { 0x0022, 0x4a0c, 0xf2b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c750000000000,24576) }, /* #78/0/0/u0x10 = #3716 */
    { 0x0012, 0x4a0c, 0xf0b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a0000000000,0) }, /* #78/0/0/u0x20 = #3717 */
    { 0x017f, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/0/1/m = #3718 */
    { 0x0100, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/0/1/u = #3719 */
    { 0x0102, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/0/1/0x2 = #3720 */
    { 0x0112, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/0/1/0x12[!] = #3721 */
    { 0x0110, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/0/1/u0x2 = #3722 */
    { 0x0102, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/0/1/u0x10 = #3723 */
    { 0x027f, 0x4a0c, 0x7232, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88800,0) }, /* #78/0/2/m = #3724 */
    { 0x0200, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/0/2/u = #3725 */
    { 0x0232, 0x4a0c, 0x7232, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88800,0) }, /* #78/0/2/0x32 = #3726 */
    { 0x0230, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/0/2/u0x2 = #3727 */
    { 0x0222, 0x4a0c, 0xf2b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f11000,24576) }, /* #78/0/2/u0x10 = #3728 */
    { 0x0212, 0x4a0c, 0xf2b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88800,0) }, /* #78/0/2/u0x20 = #3729 */
    { 0x037f, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/0/3/m = #3730 */
    { 0x0300, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/0/3/u = #3731 */
    { 0x0302, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/0/3/0x2 = #3732 */
    { 0x0312, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/0/3/0x12[!] = #3733 */
    { 0x0310, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/0/3/u0x2 = #3734 */
    { 0x0302, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/0/3/u0x10 = #3735 */
    { 0x047f, 0x4a0c, 0x7032, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a0000000000,0) }, /* #78/1/0/m = #3736 */
    { 0x0400, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/1/0/u = #3737 */
    { 0x0432, 0x4a0c, 0x7032, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a0000000000,0) }, /* #78/1/0/0x32 = #3738 */
    { 0x0430, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/1/0/u0x2 = #3739 */
    { 0x0422, 0x4a0c, 0xf0b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c740000000000,24576) }, /* #78/1/0/u0x10 = #3740 */
    { 0x0412, 0x4a0c, 0xf0b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a0000000000,0) }, /* #78/1/0/u0x20 = #3741 */
    { 0x057f, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/1/1/m = #3742 */
    { 0x0500, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/1/1/u = #3743 */
    { 0x0502, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/1/1/0x2 = #3744 */
    { 0x0512, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/1/1/0x12[!] = #3745 */
    { 0x0510, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/1/1/u0x2 = #3746 */
    { 0x0502, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/1/1/u0x10 = #3747 */
    { 0x067f, 0x4a0c, 0x7032, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88000,0) }, /* #78/1/2/m = #3748 */
    { 0x0600, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/1/2/u = #3749 */
    { 0x0632, 0x4a0c, 0x7032, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88000,0) }, /* #78/1/2/0x32 = #3750 */
    { 0x0630, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/1/2/u0x2 = #3751 */
    { 0x0622, 0x4a0c, 0xf0b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10800,24576) }, /* #78/1/2/u0x10 = #3752 */
    { 0x0612, 0x4a0c, 0xf0b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88000,0) }, /* #78/1/2/u0x20 = #3753 */
    { 0x077f, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/1/3/m = #3754 */
    { 0x0700, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/1/3/u = #3755 */
    { 0x0702, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/1/3/0x2 = #3756 */
    { 0x0712, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/1/3/0x12[!] = #3757 */
    { 0x0710, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/1/3/u0x2 = #3758 */
    { 0x0702, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/1/3/u0x10 = #3759 */
    { 0x087f, 0x4a0c, 0x7232, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3b0000000000,0) }, /* #78/2/0/m = #3760 */
    { 0x0800, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/2/0/u = #3761 */
    { 0x0832, 0x4a0c, 0x7232, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3b0000000000,0) }, /* #78/2/0/0x32 = #3762 */
    { 0x0830, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/2/0/u0x2 = #3763 */
    { 0x0822, 0x4a0c, 0xf2b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c750000000000,24576) }, /* #78/2/0/u0x10 = #3764 */
    { 0x0812, 0x4a0c, 0xf2b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3b0000000000,0) }, /* #78/2/0/u0x20 = #3765 */
    { 0x097f, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/2/1/m = #3766 */
    { 0x0900, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/2/1/u = #3767 */
    { 0x0902, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/2/1/0x2 = #3768 */
    { 0x0912, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/2/1/0x12[!] = #3769 */
    { 0x0910, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/2/1/u0x2 = #3770 */
    { 0x0902, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/2/1/u0x10 = #3771 */
    { 0x0a7f, 0x4a0c, 0x7232, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88800,0) }, /* #78/2/2/m = #3772 */
    { 0x0a00, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/2/2/u = #3773 */
    { 0x0a32, 0x4a0c, 0x7232, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88800,0) }, /* #78/2/2/0x32 = #3774 */
    { 0x0a30, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/2/2/u0x2 = #3775 */
    { 0x0a22, 0x4a0c, 0xf2b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f11000,24576) }, /* #78/2/2/u0x10 = #3776 */
    { 0x0a12, 0x4a0c, 0xf2b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88800,0) }, /* #78/2/2/u0x20 = #3777 */
    { 0x0b7f, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/2/3/m = #3778 */
    { 0x0b00, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/2/3/u = #3779 */
    { 0x0b02, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/2/3/0x2 = #3780 */
    { 0x0b12, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/2/3/0x12[!] = #3781 */
    { 0x0b10, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/2/3/u0x2 = #3782 */
    { 0x0b02, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/2/3/u0x10 = #3783 */
    { 0x0c7f, 0x4a0c, 0x7032, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a0000000000,0) }, /* #78/3/0/m = #3784 */
    { 0x0c00, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/3/0/u = #3785 */
    { 0x0c32, 0x4a0c, 0x7032, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a0000000000,0) }, /* #78/3/0/0x32 = #3786 */
    { 0x0c30, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/3/0/u0x2 = #3787 */
    { 0x0c22, 0x4a0c, 0xf0b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c740000000000,24576) }, /* #78/3/0/u0x10 = #3788 */
    { 0x0c12, 0x4a0c, 0xf0b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a0000000000,0) }, /* #78/3/0/u0x20 = #3789 */
    { 0x0d7f, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/3/1/m = #3790 */
    { 0x0d00, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/3/1/u = #3791 */
    { 0x0d02, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/3/1/0x2 = #3792 */
    { 0x0d12, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/3/1/0x12[!] = #3793 */
    { 0x0d10, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/3/1/u0x2 = #3794 */
    { 0x0d02, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/3/1/u0x10 = #3795 */
    { 0x0e7f, 0x4a0c, 0x7032, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88000,0) }, /* #78/3/2/m = #3796 */
    { 0x0e00, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/3/2/u = #3797 */
    { 0x0e32, 0x4a0c, 0x7032, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88000,0) }, /* #78/3/2/0x32 = #3798 */
    { 0x0e30, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/3/2/u0x2 = #3799 */
    { 0x0e22, 0x4a0c, 0xf0b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10800,24576) }, /* #78/3/2/u0x10 = #3800 */
    { 0x0e12, 0x4a0c, 0xf0b2, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88000,0) }, /* #78/3/2/u0x20 = #3801 */
    { 0x0f7f, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/3/3/m = #3802 */
    { 0x0f00, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/3/3/u = #3803 */
    { 0x0f02, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/3/3/0x2 = #3804 */
    { 0x0f12, 0x4a0c, 0x7002, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x439e3a59d0f88738,0) }, /* #78/3/3/0x12[!] = #3805 */
    { 0x0f10, 0x4a0c, 0xf082, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0) }, /* #78/3/3/u0x2 = #3806 */
    { 0x0f02, 0x4a0c, 0xf092, RTFLOAT80U_INIT_C(1,0x8cf2465b589f11cc,0), RTFLOAT80U_INIT_C(0,0xd09080b529979904,0), RTFLOAT80U_INIT_C(0,0x873c74b3a1f10e70,24576) }, /* #78/3/3/u0x10 = #3807 */
    { 0x007f, 0xfc47, 0x7622, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb50000000000,1) }, /* #79/0/0/m = #3808 */
    { 0x0000, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/0/0/u = #3809 */
    { 0x0022, 0xfc47, 0x7622, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb50000000000,1) }, /* #79/0/0/0x22 = #3810 */
    { 0x0020, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/0/0/u0x2 = #3811 */
    { 0x0002, 0xfc47, 0xf6a2, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb50000000000,1) }, /* #79/0/0/u0x20 = #3812 */
    { 0x017f, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/0/1/m = #3813 */
    { 0x0100, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/0/1/u = #3814 */
    { 0x0102, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/0/1/0x2 = #3815 */
    { 0x027f, 0xfc47, 0x7622, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd5000,1) }, /* #79/0/2/m = #3816 */
    { 0x0200, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/0/2/u = #3817 */
    { 0x0222, 0xfc47, 0x7622, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd5000,1) }, /* #79/0/2/0x22 = #3818 */
    { 0x0220, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/0/2/u0x2 = #3819 */
    { 0x0202, 0xfc47, 0xf6a2, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd5000,1) }, /* #79/0/2/u0x20 = #3820 */
    { 0x037f, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/0/3/m = #3821 */
    { 0x0300, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/0/3/u = #3822 */
    { 0x0302, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/0/3/0x2 = #3823 */
    { 0x047f, 0xfc47, 0x7622, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb50000000000,1) }, /* #79/1/0/m = #3824 */
    { 0x0400, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/1/0/u = #3825 */
    { 0x0422, 0xfc47, 0x7622, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb50000000000,1) }, /* #79/1/0/0x22 = #3826 */
    { 0x0420, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/1/0/u0x2 = #3827 */
    { 0x0402, 0xfc47, 0xf6a2, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb50000000000,1) }, /* #79/1/0/u0x20 = #3828 */
    { 0x057f, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/1/1/m = #3829 */
    { 0x0500, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/1/1/u = #3830 */
    { 0x0502, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/1/1/0x2 = #3831 */
    { 0x067f, 0xfc47, 0x7622, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd5000,1) }, /* #79/1/2/m = #3832 */
    { 0x0600, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/1/2/u = #3833 */
    { 0x0622, 0xfc47, 0x7622, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd5000,1) }, /* #79/1/2/0x22 = #3834 */
    { 0x0620, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/1/2/u0x2 = #3835 */
    { 0x0602, 0xfc47, 0xf6a2, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd5000,1) }, /* #79/1/2/u0x20 = #3836 */
    { 0x077f, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/1/3/m = #3837 */
    { 0x0700, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/1/3/u = #3838 */
    { 0x0702, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/1/3/0x2 = #3839 */
    { 0x087f, 0xfc47, 0x7422, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb40000000000,1) }, /* #79/2/0/m = #3840 */
    { 0x0800, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/2/0/u = #3841 */
    { 0x0822, 0xfc47, 0x7422, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb40000000000,1) }, /* #79/2/0/0x22 = #3842 */
    { 0x0820, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/2/0/u0x2 = #3843 */
    { 0x0802, 0xfc47, 0xf4a2, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb40000000000,1) }, /* #79/2/0/u0x20 = #3844 */
    { 0x097f, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/2/1/m = #3845 */
    { 0x0900, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/2/1/u = #3846 */
    { 0x0902, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/2/1/0x2 = #3847 */
    { 0x0a7f, 0xfc47, 0x7422, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4800,1) }, /* #79/2/2/m = #3848 */
    { 0x0a00, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/2/2/u = #3849 */
    { 0x0a22, 0xfc47, 0x7422, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4800,1) }, /* #79/2/2/0x22 = #3850 */
    { 0x0a20, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/2/2/u0x2 = #3851 */
    { 0x0a02, 0xfc47, 0xf4a2, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4800,1) }, /* #79/2/2/u0x20 = #3852 */
    { 0x0b7f, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/2/3/m = #3853 */
    { 0x0b00, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/2/3/u = #3854 */
    { 0x0b02, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/2/3/0x2 = #3855 */
    { 0x0c7f, 0xfc47, 0x7422, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb40000000000,1) }, /* #79/3/0/m = #3856 */
    { 0x0c00, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/3/0/u = #3857 */
    { 0x0c22, 0xfc47, 0x7422, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb40000000000,1) }, /* #79/3/0/0x22 = #3858 */
    { 0x0c20, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/3/0/u0x2 = #3859 */
    { 0x0c02, 0xfc47, 0xf4a2, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb40000000000,1) }, /* #79/3/0/u0x20 = #3860 */
    { 0x0d7f, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/3/1/m = #3861 */
    { 0x0d00, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/3/1/u = #3862 */
    { 0x0d02, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/3/1/0x2 = #3863 */
    { 0x0e7f, 0xfc47, 0x7422, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4800,1) }, /* #79/3/2/m = #3864 */
    { 0x0e00, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/3/2/u = #3865 */
    { 0x0e22, 0xfc47, 0x7422, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4800,1) }, /* #79/3/2/0x22 = #3866 */
    { 0x0e20, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/3/2/u0x2 = #3867 */
    { 0x0e02, 0xfc47, 0xf4a2, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4800,1) }, /* #79/3/2/u0x20 = #3868 */
    { 0x0f7f, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/3/3/m = #3869 */
    { 0x0f00, 0xfc47, 0xf482, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0) }, /* #79/3/3/u = #3870 */
    { 0x0f02, 0xfc47, 0x7402, RTFLOAT80U_INIT_C(1,0xc61cfb8c7ee07842,0), RTFLOAT80U_INIT_C(0,0x41b046cee1e32b9c,0), RTFLOAT80U_INIT_C(1,0x846cb4bd9cfd4ca6,1) }, /* #79/3/3/0x2 = #3871 */
    { 0x007f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/0/m = #3872 */
    { 0x0000, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/0/u = #3873 */
    { 0x017f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/1/m = #3874 */
    { 0x0100, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/1/u = #3875 */
    { 0x027f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/2/m = #3876 */
    { 0x0200, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/2/u = #3877 */
    { 0x037f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/3/m = #3878 */
    { 0x0300, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/0/3/u = #3879 */
    { 0x047f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/0/m = #3880 */
    { 0x0400, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/0/u = #3881 */
    { 0x057f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/1/m = #3882 */
    { 0x0500, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/1/u = #3883 */
    { 0x067f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/2/m = #3884 */
    { 0x0600, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/2/u = #3885 */
    { 0x077f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/3/m = #3886 */
    { 0x0700, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/1/3/u = #3887 */
    { 0x087f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/0/m = #3888 */
    { 0x0800, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/0/u = #3889 */
    { 0x097f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/1/m = #3890 */
    { 0x0900, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/1/u = #3891 */
    { 0x0a7f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/2/m = #3892 */
    { 0x0a00, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/2/u = #3893 */
    { 0x0b7f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/3/m = #3894 */
    { 0x0b00, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/2/3/u = #3895 */
    { 0x0c7f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/0/m = #3896 */
    { 0x0c00, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/0/u = #3897 */
    { 0x0d7f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/1/m = #3898 */
    { 0x0d00, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/1/u = #3899 */
    { 0x0e7f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/2/m = #3900 */
    { 0x0e00, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/2/u = #3901 */
    { 0x0f7f, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/3/m = #3902 */
    { 0x0f00, 0x1901, 0x3100, RTFLOAT80U_INIT_C(1,0x8cff2287047bc973,0), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #80/3/3/u = #3903 */
    { 0x007f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/0/m = #3904 */
    { 0x0000, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/0/0/u = #3905 */
    { 0x0002, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/0/0x2 = #3906 */
    { 0x017f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/1/m = #3907 */
    { 0x0100, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/0/1/u = #3908 */
    { 0x0102, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/1/0x2 = #3909 */
    { 0x027f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/2/m = #3910 */
    { 0x0200, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/0/2/u = #3911 */
    { 0x0202, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/2/0x2 = #3912 */
    { 0x037f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/3/m = #3913 */
    { 0x0300, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/0/3/u = #3914 */
    { 0x0302, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/0/3/0x2 = #3915 */
    { 0x047f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/0/m = #3916 */
    { 0x0400, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/1/0/u = #3917 */
    { 0x0402, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/0/0x2 = #3918 */
    { 0x057f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/1/m = #3919 */
    { 0x0500, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/1/1/u = #3920 */
    { 0x0502, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/1/0x2 = #3921 */
    { 0x067f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/2/m = #3922 */
    { 0x0600, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/1/2/u = #3923 */
    { 0x0602, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/2/0x2 = #3924 */
    { 0x077f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/3/m = #3925 */
    { 0x0700, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/1/3/u = #3926 */
    { 0x0702, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/1/3/0x2 = #3927 */
    { 0x087f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/0/m = #3928 */
    { 0x0800, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/2/0/u = #3929 */
    { 0x0802, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/0/0x2 = #3930 */
    { 0x097f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/1/m = #3931 */
    { 0x0900, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/2/1/u = #3932 */
    { 0x0902, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/1/0x2 = #3933 */
    { 0x0a7f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/2/m = #3934 */
    { 0x0a00, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/2/2/u = #3935 */
    { 0x0a02, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/2/0x2 = #3936 */
    { 0x0b7f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/3/m = #3937 */
    { 0x0b00, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/2/3/u = #3938 */
    { 0x0b02, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/2/3/0x2 = #3939 */
    { 0x0c7f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/0/m = #3940 */
    { 0x0c00, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/3/0/u = #3941 */
    { 0x0c02, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/0/0x2 = #3942 */
    { 0x0d7f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/1/m = #3943 */
    { 0x0d00, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/3/1/u = #3944 */
    { 0x0d02, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/1/0x2 = #3945 */
    { 0x0e7f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/2/m = #3946 */
    { 0x0e00, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/3/2/u = #3947 */
    { 0x0e02, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/2/0x2 = #3948 */
    { 0x0f7f, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/3/m = #3949 */
    { 0x0f00, 0xcded, 0xf582, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0) }, /* #81/3/3/u = #3950 */
    { 0x0f02, 0xcded, 0x7502, RTFLOAT80U_INIT_C(0,0xc40068844ce85031,0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #81/3/3/0x2 = #3951 */
    { 0x007f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/0/m = #3952 */
    { 0x0000, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/0/0/u = #3953 */
    { 0x0001, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/0/0x1 = #3954 */
    { 0x017f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/1/m = #3955 */
    { 0x0100, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/0/1/u = #3956 */
    { 0x0101, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/1/0x1 = #3957 */
    { 0x027f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/2/m = #3958 */
    { 0x0200, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/0/2/u = #3959 */
    { 0x0201, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/2/0x1 = #3960 */
    { 0x037f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/3/m = #3961 */
    { 0x0300, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/0/3/u = #3962 */
    { 0x0301, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/0/3/0x1 = #3963 */
    { 0x047f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/0/m = #3964 */
    { 0x0400, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/1/0/u = #3965 */
    { 0x0401, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/0/0x1 = #3966 */
    { 0x057f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/1/m = #3967 */
    { 0x0500, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/1/1/u = #3968 */
    { 0x0501, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/1/0x1 = #3969 */
    { 0x067f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/2/m = #3970 */
    { 0x0600, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/1/2/u = #3971 */
    { 0x0601, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/2/0x1 = #3972 */
    { 0x077f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/3/m = #3973 */
    { 0x0700, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/1/3/u = #3974 */
    { 0x0701, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/1/3/0x1 = #3975 */
    { 0x087f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/0/m = #3976 */
    { 0x0800, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/2/0/u = #3977 */
    { 0x0801, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/0/0x1 = #3978 */
    { 0x097f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/1/m = #3979 */
    { 0x0900, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/2/1/u = #3980 */
    { 0x0901, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/1/0x1 = #3981 */
    { 0x0a7f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/2/m = #3982 */
    { 0x0a00, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/2/2/u = #3983 */
    { 0x0a01, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/2/0x1 = #3984 */
    { 0x0b7f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/3/m = #3985 */
    { 0x0b00, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/2/3/u = #3986 */
    { 0x0b01, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/2/3/0x1 = #3987 */
    { 0x0c7f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/0/m = #3988 */
    { 0x0c00, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/3/0/u = #3989 */
    { 0x0c01, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/0/0x1 = #3990 */
    { 0x0d7f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/1/m = #3991 */
    { 0x0d00, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/3/1/u = #3992 */
    { 0x0d01, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/1/0x1 = #3993 */
    { 0x0e7f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/2/m = #3994 */
    { 0x0e00, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/3/2/u = #3995 */
    { 0x0e01, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/2/0x1 = #3996 */
    { 0x0f7f, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/3/m = #3997 */
    { 0x0f00, 0xced3, 0xf481, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0) }, /* #82/3/3/u = #3998 */
    { 0x0f01, 0xced3, 0x7401, RTFLOAT80U_INIT_C(0,0xec45b0a8037b6562,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #82/3/3/0x1 = #3999 */
    { 0x007f, 0xa3ec, 0x3122, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb90000000000,1) }, /* #83/0/0/m = #4000 */
    { 0x0000, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/0/0/u = #4001 */
    { 0x0022, 0xa3ec, 0x3122, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb90000000000,1) }, /* #83/0/0/0x22 = #4002 */
    { 0x0020, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/0/0/u0x2 = #4003 */
    { 0x0002, 0xa3ec, 0xb1a2, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb90000000000,1) }, /* #83/0/0/u0x20 = #4004 */
    { 0x017f, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/0/1/m = #4005 */
    { 0x0100, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/0/1/u = #4006 */
    { 0x0102, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/0/1/0x2 = #4007 */
    { 0x027f, 0xa3ec, 0x3322, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e800,1) }, /* #83/0/2/m = #4008 */
    { 0x0200, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/0/2/u = #4009 */
    { 0x0222, 0xa3ec, 0x3322, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e800,1) }, /* #83/0/2/0x22 = #4010 */
    { 0x0220, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/0/2/u0x2 = #4011 */
    { 0x0202, 0xa3ec, 0xb3a2, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e800,1) }, /* #83/0/2/u0x20 = #4012 */
    { 0x037f, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/0/3/m = #4013 */
    { 0x0300, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/0/3/u = #4014 */
    { 0x0302, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/0/3/0x2 = #4015 */
    { 0x047f, 0xa3ec, 0x3122, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb90000000000,1) }, /* #83/1/0/m = #4016 */
    { 0x0400, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/1/0/u = #4017 */
    { 0x0422, 0xa3ec, 0x3122, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb90000000000,1) }, /* #83/1/0/0x22 = #4018 */
    { 0x0420, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/1/0/u0x2 = #4019 */
    { 0x0402, 0xa3ec, 0xb1a2, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb90000000000,1) }, /* #83/1/0/u0x20 = #4020 */
    { 0x057f, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/1/1/m = #4021 */
    { 0x0500, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/1/1/u = #4022 */
    { 0x0502, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/1/1/0x2 = #4023 */
    { 0x067f, 0xa3ec, 0x3122, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e000,1) }, /* #83/1/2/m = #4024 */
    { 0x0600, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/1/2/u = #4025 */
    { 0x0622, 0xa3ec, 0x3122, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e000,1) }, /* #83/1/2/0x22 = #4026 */
    { 0x0620, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/1/2/u0x2 = #4027 */
    { 0x0602, 0xa3ec, 0xb1a2, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e000,1) }, /* #83/1/2/u0x20 = #4028 */
    { 0x077f, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/1/3/m = #4029 */
    { 0x0700, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/1/3/u = #4030 */
    { 0x0702, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/1/3/0x2 = #4031 */
    { 0x087f, 0xa3ec, 0x3322, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcba0000000000,1) }, /* #83/2/0/m = #4032 */
    { 0x0800, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/2/0/u = #4033 */
    { 0x0822, 0xa3ec, 0x3322, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcba0000000000,1) }, /* #83/2/0/0x22 = #4034 */
    { 0x0820, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/2/0/u0x2 = #4035 */
    { 0x0802, 0xa3ec, 0xb3a2, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcba0000000000,1) }, /* #83/2/0/u0x20 = #4036 */
    { 0x097f, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/2/1/m = #4037 */
    { 0x0900, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/2/1/u = #4038 */
    { 0x0902, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/2/1/0x2 = #4039 */
    { 0x0a7f, 0xa3ec, 0x3322, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e800,1) }, /* #83/2/2/m = #4040 */
    { 0x0a00, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/2/2/u = #4041 */
    { 0x0a22, 0xa3ec, 0x3322, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e800,1) }, /* #83/2/2/0x22 = #4042 */
    { 0x0a20, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/2/2/u0x2 = #4043 */
    { 0x0a02, 0xa3ec, 0xb3a2, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e800,1) }, /* #83/2/2/u0x20 = #4044 */
    { 0x0b7f, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/2/3/m = #4045 */
    { 0x0b00, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/2/3/u = #4046 */
    { 0x0b02, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/2/3/0x2 = #4047 */
    { 0x0c7f, 0xa3ec, 0x3122, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb90000000000,1) }, /* #83/3/0/m = #4048 */
    { 0x0c00, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/3/0/u = #4049 */
    { 0x0c22, 0xa3ec, 0x3122, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb90000000000,1) }, /* #83/3/0/0x22 = #4050 */
    { 0x0c20, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/3/0/u0x2 = #4051 */
    { 0x0c02, 0xa3ec, 0xb1a2, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb90000000000,1) }, /* #83/3/0/u0x20 = #4052 */
    { 0x0d7f, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/3/1/m = #4053 */
    { 0x0d00, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/3/1/u = #4054 */
    { 0x0d02, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/3/1/0x2 = #4055 */
    { 0x0e7f, 0xa3ec, 0x3122, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e000,1) }, /* #83/3/2/m = #4056 */
    { 0x0e00, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/3/2/u = #4057 */
    { 0x0e22, 0xa3ec, 0x3122, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e000,1) }, /* #83/3/2/0x22 = #4058 */
    { 0x0e20, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/3/2/u0x2 = #4059 */
    { 0x0e02, 0xa3ec, 0xb1a2, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e000,1) }, /* #83/3/2/u0x20 = #4060 */
    { 0x0f7f, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/3/3/m = #4061 */
    { 0x0f00, 0xa3ec, 0xb182, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0) }, /* #83/3/3/u = #4062 */
    { 0x0f02, 0xa3ec, 0x3102, RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,0), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_C(0,0xb7fcb93cccf3e658,1) }, /* #83/3/3/0x2 = #4063 */
    { 0x007f, 0xc9ae, 0x7322, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941d0000000000,2222) }, /* #84/0/0/m = #4064 */
    { 0x0000, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/0/0/u = #4065 */
    { 0x0022, 0xc9ae, 0x7322, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941d0000000000,2222) }, /* #84/0/0/0x22 = #4066 */
    { 0x0020, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/0/0/u0x2 = #4067 */
    { 0x0002, 0xc9ae, 0xf3a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941d0000000000,2222) }, /* #84/0/0/u0x20 = #4068 */
    { 0x017f, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/0/1/m = #4069 */
    { 0x0100, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/0/1/u = #4070 */
    { 0x0122, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/0/1/0x22 = #4071 */
    { 0x0120, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/0/1/u0x2 = #4072 */
    { 0x0102, 0xc9ae, 0xf1a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/0/1/u0x20 = #4073 */
    { 0x027f, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd800,2222) }, /* #84/0/2/m = #4074 */
    { 0x0200, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/0/2/u = #4075 */
    { 0x0222, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd800,2222) }, /* #84/0/2/0x22 = #4076 */
    { 0x0220, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/0/2/u0x2 = #4077 */
    { 0x0202, 0xc9ae, 0xf1a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd800,2222) }, /* #84/0/2/u0x20 = #4078 */
    { 0x037f, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/0/3/m = #4079 */
    { 0x0300, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/0/3/u = #4080 */
    { 0x0322, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/0/3/0x22 = #4081 */
    { 0x0320, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/0/3/u0x2 = #4082 */
    { 0x0302, 0xc9ae, 0xf1a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/0/3/u0x20 = #4083 */
    { 0x047f, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941c0000000000,2222) }, /* #84/1/0/m = #4084 */
    { 0x0400, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/1/0/u = #4085 */
    { 0x0422, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941c0000000000,2222) }, /* #84/1/0/0x22 = #4086 */
    { 0x0420, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/1/0/u0x2 = #4087 */
    { 0x0402, 0xc9ae, 0xf1a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941c0000000000,2222) }, /* #84/1/0/u0x20 = #4088 */
    { 0x057f, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/1/1/m = #4089 */
    { 0x0500, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/1/1/u = #4090 */
    { 0x0522, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/1/1/0x22 = #4091 */
    { 0x0520, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/1/1/u0x2 = #4092 */
    { 0x0502, 0xc9ae, 0xf1a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/1/1/u0x20 = #4093 */
    { 0x067f, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd800,2222) }, /* #84/1/2/m = #4094 */
    { 0x0600, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/1/2/u = #4095 */
    { 0x0622, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd800,2222) }, /* #84/1/2/0x22 = #4096 */
    { 0x0620, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/1/2/u0x2 = #4097 */
    { 0x0602, 0xc9ae, 0xf1a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd800,2222) }, /* #84/1/2/u0x20 = #4098 */
    { 0x077f, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/1/3/m = #4099 */
    { 0x0700, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/1/3/u = #4100 */
    { 0x0722, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/1/3/0x22 = #4101 */
    { 0x0720, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/1/3/u0x2 = #4102 */
    { 0x0702, 0xc9ae, 0xf1a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/1/3/u0x20 = #4103 */
    { 0x087f, 0xc9ae, 0x7322, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941d0000000000,2222) }, /* #84/2/0/m = #4104 */
    { 0x0800, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/2/0/u = #4105 */
    { 0x0822, 0xc9ae, 0x7322, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941d0000000000,2222) }, /* #84/2/0/0x22 = #4106 */
    { 0x0820, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/2/0/u0x2 = #4107 */
    { 0x0802, 0xc9ae, 0xf3a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941d0000000000,2222) }, /* #84/2/0/u0x20 = #4108 */
    { 0x097f, 0xc9ae, 0x7322, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c1,2222) }, /* #84/2/1/m = #4109 */
    { 0x0900, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/2/1/u = #4110 */
    { 0x0922, 0xc9ae, 0x7322, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c1,2222) }, /* #84/2/1/0x22 = #4111 */
    { 0x0920, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/2/1/u0x2 = #4112 */
    { 0x0902, 0xc9ae, 0xf3a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c1,2222) }, /* #84/2/1/u0x20 = #4113 */
    { 0x0a7f, 0xc9ae, 0x7322, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02be000,2222) }, /* #84/2/2/m = #4114 */
    { 0x0a00, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/2/2/u = #4115 */
    { 0x0a22, 0xc9ae, 0x7322, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02be000,2222) }, /* #84/2/2/0x22 = #4116 */
    { 0x0a20, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/2/2/u0x2 = #4117 */
    { 0x0a02, 0xc9ae, 0xf3a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02be000,2222) }, /* #84/2/2/u0x20 = #4118 */
    { 0x0b7f, 0xc9ae, 0x7322, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c1,2222) }, /* #84/2/3/m = #4119 */
    { 0x0b00, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/2/3/u = #4120 */
    { 0x0b22, 0xc9ae, 0x7322, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c1,2222) }, /* #84/2/3/0x22 = #4121 */
    { 0x0b20, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/2/3/u0x2 = #4122 */
    { 0x0b02, 0xc9ae, 0xf3a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c1,2222) }, /* #84/2/3/u0x20 = #4123 */
    { 0x0c7f, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941c0000000000,2222) }, /* #84/3/0/m = #4124 */
    { 0x0c00, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/3/0/u = #4125 */
    { 0x0c22, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941c0000000000,2222) }, /* #84/3/0/0x22 = #4126 */
    { 0x0c20, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/3/0/u0x2 = #4127 */
    { 0x0c02, 0xc9ae, 0xf1a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941c0000000000,2222) }, /* #84/3/0/u0x20 = #4128 */
    { 0x0d7f, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/3/1/m = #4129 */
    { 0x0d00, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/3/1/u = #4130 */
    { 0x0d22, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/3/1/0x22 = #4131 */
    { 0x0d20, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/3/1/u0x2 = #4132 */
    { 0x0d02, 0xc9ae, 0xf1a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/3/1/u0x20 = #4133 */
    { 0x0e7f, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd800,2222) }, /* #84/3/2/m = #4134 */
    { 0x0e00, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/3/2/u = #4135 */
    { 0x0e22, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd800,2222) }, /* #84/3/2/0x22 = #4136 */
    { 0x0e20, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/3/2/u0x2 = #4137 */
    { 0x0e02, 0xc9ae, 0xf1a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd800,2222) }, /* #84/3/2/u0x20 = #4138 */
    { 0x0f7f, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/3/3/m = #4139 */
    { 0x0f00, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/3/3/u = #4140 */
    { 0x0f22, 0xc9ae, 0x7122, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/3/3/0x22 = #4141 */
    { 0x0f20, 0xc9ae, 0xf182, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0) }, /* #84/3/3/u0x2 = #4142 */
    { 0x0f02, 0xc9ae, 0xf1a2, RTFLOAT80U_INIT_C(0,0x4ef23cad142b1116,0), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222), RTFLOAT80U_INIT_C(0,0x92941cb0e02bd8c0,2222) }, /* #84/3/3/u0x20 = #4143 */
    { 0x007f, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/0/0/m = #4144 */
    { 0x0000, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/0/0/u = #4145 */
    { 0x0022, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/0/0/0x22 = #4146 */
    { 0x0020, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/0/0/u0x2 = #4147 */
    { 0x0002, 0x85b1, 0xb7a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/0/0/u0x20 = #4148 */
    { 0x017f, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/0/1/m = #4149 */
    { 0x0100, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/0/1/u = #4150 */
    { 0x0122, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/0/1/0x22 = #4151 */
    { 0x0120, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/0/1/u0x2 = #4152 */
    { 0x0102, 0x85b1, 0xb7a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/0/1/u0x20 = #4153 */
    { 0x027f, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/0/2/m = #4154 */
    { 0x0200, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/0/2/u = #4155 */
    { 0x0222, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/0/2/0x22 = #4156 */
    { 0x0220, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/0/2/u0x2 = #4157 */
    { 0x0202, 0x85b1, 0xb7a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/0/2/u0x20 = #4158 */
    { 0x037f, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/0/3/m = #4159 */
    { 0x0300, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/0/3/u = #4160 */
    { 0x0322, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/0/3/0x22 = #4161 */
    { 0x0320, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/0/3/u0x2 = #4162 */
    { 0x0302, 0x85b1, 0xb7a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/0/3/u0x20 = #4163 */
    { 0x047f, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/1/0/m = #4164 */
    { 0x0400, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/1/0/u = #4165 */
    { 0x0422, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/1/0/0x22 = #4166 */
    { 0x0420, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/1/0/u0x2 = #4167 */
    { 0x0402, 0x85b1, 0xb7a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/1/0/u0x20 = #4168 */
    { 0x057f, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/1/1/m = #4169 */
    { 0x0500, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/1/1/u = #4170 */
    { 0x0522, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/1/1/0x22 = #4171 */
    { 0x0520, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/1/1/u0x2 = #4172 */
    { 0x0502, 0x85b1, 0xb7a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/1/1/u0x20 = #4173 */
    { 0x067f, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/1/2/m = #4174 */
    { 0x0600, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/1/2/u = #4175 */
    { 0x0622, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/1/2/0x22 = #4176 */
    { 0x0620, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/1/2/u0x2 = #4177 */
    { 0x0602, 0x85b1, 0xb7a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #85/1/2/u0x20 = #4178 */
    { 0x077f, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/1/3/m = #4179 */
    { 0x0700, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/1/3/u = #4180 */
    { 0x0722, 0x85b1, 0x3722, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/1/3/0x22 = #4181 */
    { 0x0720, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/1/3/u0x2 = #4182 */
    { 0x0702, 0x85b1, 0xb7a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #85/1/3/u0x20 = #4183 */
    { 0x087f, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32758) }, /* #85/2/0/m = #4184 */
    { 0x0800, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/2/0/u = #4185 */
    { 0x0822, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32758) }, /* #85/2/0/0x22 = #4186 */
    { 0x0820, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/2/0/u0x2 = #4187 */
    { 0x0802, 0x85b1, 0xb5a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32758) }, /* #85/2/0/u0x20 = #4188 */
    { 0x097f, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/2/1/m = #4189 */
    { 0x0900, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/2/1/u = #4190 */
    { 0x0922, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/2/1/0x22 = #4191 */
    { 0x0920, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/2/1/u0x2 = #4192 */
    { 0x0902, 0x85b1, 0xb5a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/2/1/u0x20 = #4193 */
    { 0x0a7f, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32758) }, /* #85/2/2/m = #4194 */
    { 0x0a00, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/2/2/u = #4195 */
    { 0x0a22, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32758) }, /* #85/2/2/0x22 = #4196 */
    { 0x0a20, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/2/2/u0x2 = #4197 */
    { 0x0a02, 0x85b1, 0xb5a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32758) }, /* #85/2/2/u0x20 = #4198 */
    { 0x0b7f, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/2/3/m = #4199 */
    { 0x0b00, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/2/3/u = #4200 */
    { 0x0b22, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/2/3/0x22 = #4201 */
    { 0x0b20, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/2/3/u0x2 = #4202 */
    { 0x0b02, 0x85b1, 0xb5a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/2/3/u0x20 = #4203 */
    { 0x0c7f, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32758) }, /* #85/3/0/m = #4204 */
    { 0x0c00, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/3/0/u = #4205 */
    { 0x0c22, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32758) }, /* #85/3/0/0x22 = #4206 */
    { 0x0c20, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/3/0/u0x2 = #4207 */
    { 0x0c02, 0x85b1, 0xb5a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32758) }, /* #85/3/0/u0x20 = #4208 */
    { 0x0d7f, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/3/1/m = #4209 */
    { 0x0d00, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/3/1/u = #4210 */
    { 0x0d22, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/3/1/0x22 = #4211 */
    { 0x0d20, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/3/1/u0x2 = #4212 */
    { 0x0d02, 0x85b1, 0xb5a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/3/1/u0x20 = #4213 */
    { 0x0e7f, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32758) }, /* #85/3/2/m = #4214 */
    { 0x0e00, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/3/2/u = #4215 */
    { 0x0e22, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32758) }, /* #85/3/2/0x22 = #4216 */
    { 0x0e20, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/3/2/u0x2 = #4217 */
    { 0x0e02, 0x85b1, 0xb5a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32758) }, /* #85/3/2/u0x20 = #4218 */
    { 0x0f7f, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/3/3/m = #4219 */
    { 0x0f00, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/3/3/u = #4220 */
    { 0x0f22, 0x85b1, 0x3522, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/3/3/0x22 = #4221 */
    { 0x0f20, 0x85b1, 0xb582, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0) }, /* #85/3/3/u0x2 = #4222 */
    { 0x0f02, 0x85b1, 0xb5a2, RTFLOAT80U_INIT_C(0,0x55f049efb9a9f670,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #85/3/3/u0x20 = #4223 */
    { 0x007f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/0/0/m = #4224 */
    { 0x0000, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/0/0/u = #4225 */
    { 0x0001, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/0/0/0x1 = #4226 */
    { 0x017f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/0/1/m = #4227 */
    { 0x0100, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/0/1/u = #4228 */
    { 0x0101, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/0/1/0x1 = #4229 */
    { 0x027f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/0/2/m = #4230 */
    { 0x0200, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/0/2/u = #4231 */
    { 0x0201, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/0/2/0x1 = #4232 */
    { 0x037f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/0/3/m = #4233 */
    { 0x0300, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/0/3/u = #4234 */
    { 0x0301, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/0/3/0x1 = #4235 */
    { 0x047f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/1/0/m = #4236 */
    { 0x0400, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/1/0/u = #4237 */
    { 0x0401, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/1/0/0x1 = #4238 */
    { 0x057f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/1/1/m = #4239 */
    { 0x0500, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/1/1/u = #4240 */
    { 0x0501, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/1/1/0x1 = #4241 */
    { 0x067f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/1/2/m = #4242 */
    { 0x0600, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/1/2/u = #4243 */
    { 0x0601, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/1/2/0x1 = #4244 */
    { 0x077f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/1/3/m = #4245 */
    { 0x0700, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/1/3/u = #4246 */
    { 0x0701, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/1/3/0x1 = #4247 */
    { 0x087f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/2/0/m = #4248 */
    { 0x0800, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/2/0/u = #4249 */
    { 0x0801, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/2/0/0x1 = #4250 */
    { 0x097f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/2/1/m = #4251 */
    { 0x0900, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/2/1/u = #4252 */
    { 0x0901, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/2/1/0x1 = #4253 */
    { 0x0a7f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/2/2/m = #4254 */
    { 0x0a00, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/2/2/u = #4255 */
    { 0x0a01, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/2/2/0x1 = #4256 */
    { 0x0b7f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/2/3/m = #4257 */
    { 0x0b00, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/2/3/u = #4258 */
    { 0x0b01, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/2/3/0x1 = #4259 */
    { 0x0c7f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/3/0/m = #4260 */
    { 0x0c00, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/3/0/u = #4261 */
    { 0x0c01, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/3/0/0x1 = #4262 */
    { 0x0d7f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/3/1/m = #4263 */
    { 0x0d00, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/3/1/u = #4264 */
    { 0x0d01, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/3/1/0x1 = #4265 */
    { 0x0e7f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/3/2/m = #4266 */
    { 0x0e00, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/3/2/u = #4267 */
    { 0x0e01, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/3/2/0x1 = #4268 */
    { 0x0f7f, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/3/3/m = #4269 */
    { 0x0f00, 0x2220, 0xb081, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0) }, /* #86/3/3/u = #4270 */
    { 0x0f01, 0x2220, 0x3001, RTFLOAT80U_INIT_C(0,0xa48ed140749b348,0), RTFLOAT80U_INIT_C(0,0x41afaff7a50af6d2,20545), RTFLOAT80U_INIT_IND(1) }, /* #86/3/3/0x1 = #4271 */
    { 0x007f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/0/0/m = #4272 */
    { 0x0000, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/0/0/u = #4273 */
    { 0x0001, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/0/0/0x1 = #4274 */
    { 0x017f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/0/1/m = #4275 */
    { 0x0100, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/0/1/u = #4276 */
    { 0x0101, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/0/1/0x1 = #4277 */
    { 0x027f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/0/2/m = #4278 */
    { 0x0200, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/0/2/u = #4279 */
    { 0x0201, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/0/2/0x1 = #4280 */
    { 0x037f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/0/3/m = #4281 */
    { 0x0300, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/0/3/u = #4282 */
    { 0x0301, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/0/3/0x1 = #4283 */
    { 0x047f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/1/0/m = #4284 */
    { 0x0400, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/1/0/u = #4285 */
    { 0x0401, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/1/0/0x1 = #4286 */
    { 0x057f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/1/1/m = #4287 */
    { 0x0500, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/1/1/u = #4288 */
    { 0x0501, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/1/1/0x1 = #4289 */
    { 0x067f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/1/2/m = #4290 */
    { 0x0600, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/1/2/u = #4291 */
    { 0x0601, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/1/2/0x1 = #4292 */
    { 0x077f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/1/3/m = #4293 */
    { 0x0700, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/1/3/u = #4294 */
    { 0x0701, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/1/3/0x1 = #4295 */
    { 0x087f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/2/0/m = #4296 */
    { 0x0800, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/2/0/u = #4297 */
    { 0x0801, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/2/0/0x1 = #4298 */
    { 0x097f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/2/1/m = #4299 */
    { 0x0900, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/2/1/u = #4300 */
    { 0x0901, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/2/1/0x1 = #4301 */
    { 0x0a7f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/2/2/m = #4302 */
    { 0x0a00, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/2/2/u = #4303 */
    { 0x0a01, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/2/2/0x1 = #4304 */
    { 0x0b7f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/2/3/m = #4305 */
    { 0x0b00, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/2/3/u = #4306 */
    { 0x0b01, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/2/3/0x1 = #4307 */
    { 0x0c7f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/3/0/m = #4308 */
    { 0x0c00, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/3/0/u = #4309 */
    { 0x0c01, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/3/0/0x1 = #4310 */
    { 0x0d7f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/3/1/m = #4311 */
    { 0x0d00, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/3/1/u = #4312 */
    { 0x0d01, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/3/1/0x1 = #4313 */
    { 0x0e7f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/3/2/m = #4314 */
    { 0x0e00, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/3/2/u = #4315 */
    { 0x0e01, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/3/2/0x1 = #4316 */
    { 0x0f7f, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/3/3/m = #4317 */
    { 0x0f00, 0x735e, 0xf181, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0) }, /* #87/3/3/u = #4318 */
    { 0x0f01, 0x735e, 0x7101, RTFLOAT80U_INIT_C(1,0x3e4bffb924f3116e,0), RTFLOAT80U_INIT_C(0,0x99e6f71fde30f091,32767), RTFLOAT80U_INIT_C(0,0xd9e6f71fde30f091,32767) }, /* #87/3/3/0x1 = #4319 */
    { 0x007f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/0/0/m = #4320 */
    { 0x0000, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/0/0/u = #4321 */
    { 0x017f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/0/1/m = #4322 */
    { 0x0100, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/0/1/u = #4323 */
    { 0x027f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/0/2/m = #4324 */
    { 0x0200, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/0/2/u = #4325 */
    { 0x037f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/0/3/m = #4326 */
    { 0x0300, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/0/3/u = #4327 */
    { 0x047f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/1/0/m = #4328 */
    { 0x0400, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/1/0/u = #4329 */
    { 0x057f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/1/1/m = #4330 */
    { 0x0500, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/1/1/u = #4331 */
    { 0x067f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/1/2/m = #4332 */
    { 0x0600, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/1/2/u = #4333 */
    { 0x077f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/1/3/m = #4334 */
    { 0x0700, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/1/3/u = #4335 */
    { 0x087f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/2/0/m = #4336 */
    { 0x0800, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/2/0/u = #4337 */
    { 0x097f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/2/1/m = #4338 */
    { 0x0900, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/2/1/u = #4339 */
    { 0x0a7f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/2/2/m = #4340 */
    { 0x0a00, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/2/2/u = #4341 */
    { 0x0b7f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/2/3/m = #4342 */
    { 0x0b00, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/2/3/u = #4343 */
    { 0x0c7f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/3/0/m = #4344 */
    { 0x0c00, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/3/0/u = #4345 */
    { 0x0d7f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/3/1/m = #4346 */
    { 0x0d00, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/3/1/u = #4347 */
    { 0x0e7f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/3/2/m = #4348 */
    { 0x0e00, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/3/2/u = #4349 */
    { 0x0f7f, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/3/3/m = #4350 */
    { 0x0f00, 0x1a17, 0x3000, RTFLOAT80U_INIT_C(1,0x3cd201154d0b2732,0), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767), RTFLOAT80U_INIT_C(1,0xd0951b7c9094abf2,32767) }, /* #88/3/3/u = #4351 */
    { 0x007f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/0/m = #4352 */
    { 0x0000, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/0/0/u = #4353 */
    { 0x0001, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/0/0x1 = #4354 */
    { 0x017f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/1/m = #4355 */
    { 0x0100, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/0/1/u = #4356 */
    { 0x0101, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/1/0x1 = #4357 */
    { 0x027f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/2/m = #4358 */
    { 0x0200, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/0/2/u = #4359 */
    { 0x0201, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/2/0x1 = #4360 */
    { 0x037f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/3/m = #4361 */
    { 0x0300, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/0/3/u = #4362 */
    { 0x0301, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/0/3/0x1 = #4363 */
    { 0x047f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/0/m = #4364 */
    { 0x0400, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/1/0/u = #4365 */
    { 0x0401, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/0/0x1 = #4366 */
    { 0x057f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/1/m = #4367 */
    { 0x0500, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/1/1/u = #4368 */
    { 0x0501, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/1/0x1 = #4369 */
    { 0x067f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/2/m = #4370 */
    { 0x0600, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/1/2/u = #4371 */
    { 0x0601, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/2/0x1 = #4372 */
    { 0x077f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/3/m = #4373 */
    { 0x0700, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/1/3/u = #4374 */
    { 0x0701, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/1/3/0x1 = #4375 */
    { 0x087f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/0/m = #4376 */
    { 0x0800, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/2/0/u = #4377 */
    { 0x0801, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/0/0x1 = #4378 */
    { 0x097f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/1/m = #4379 */
    { 0x0900, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/2/1/u = #4380 */
    { 0x0901, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/1/0x1 = #4381 */
    { 0x0a7f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/2/m = #4382 */
    { 0x0a00, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/2/2/u = #4383 */
    { 0x0a01, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/2/0x1 = #4384 */
    { 0x0b7f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/3/m = #4385 */
    { 0x0b00, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/2/3/u = #4386 */
    { 0x0b01, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/2/3/0x1 = #4387 */
    { 0x0c7f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/0/m = #4388 */
    { 0x0c00, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/3/0/u = #4389 */
    { 0x0c01, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/0/0x1 = #4390 */
    { 0x0d7f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/1/m = #4391 */
    { 0x0d00, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/3/1/u = #4392 */
    { 0x0d01, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/1/0x1 = #4393 */
    { 0x0e7f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/2/m = #4394 */
    { 0x0e00, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/3/2/u = #4395 */
    { 0x0e01, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/2/0x1 = #4396 */
    { 0x0f7f, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/3/m = #4397 */
    { 0x0f00, 0x9f34, 0xb581, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0) }, /* #89/3/3/u = #4398 */
    { 0x0f01, 0x9f34, 0x3501, RTFLOAT80U_INIT_C(1,0x55adc7305d949c04,0), RTFLOAT80U_INIT_C(0,0x7381035216912f87,32767), RTFLOAT80U_INIT_IND(1) }, /* #89/3/3/0x1 = #4399 */
    { 0x007f, 0x0af2, 0x3032, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924120000000000,0) }, /* #90/0/0/m = #4400 */
    { 0x0000, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/0/0/u = #4401 */
    { 0x0032, 0x0af2, 0x3032, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924120000000000,0) }, /* #90/0/0/0x32 = #4402 */
    { 0x0030, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/0/0/u0x2 = #4403 */
    { 0x0022, 0x0af2, 0xb0b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x9248240000000000,24576) }, /* #90/0/0/u0x10 = #4404 */
    { 0x0012, 0x0af2, 0xb0b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924120000000000,0) }, /* #90/0/0/u0x20 = #4405 */
    { 0x017f, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/0/1/m = #4406 */
    { 0x0100, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/0/1/u = #4407 */
    { 0x0102, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/0/1/0x2 = #4408 */
    { 0x0112, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/0/1/0x12[!] = #4409 */
    { 0x0110, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/0/1/u0x2 = #4410 */
    { 0x0102, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/0/1/u0x10 = #4411 */
    { 0x027f, 0x0af2, 0x3232, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af82a000,0) }, /* #90/0/2/m = #4412 */
    { 0x0200, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/0/2/u = #4413 */
    { 0x0232, 0x0af2, 0x3232, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af82a000,0) }, /* #90/0/2/0x32 = #4414 */
    { 0x0230, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/0/2/u0x2 = #4415 */
    { 0x0222, 0x0af2, 0xb2b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f054000,24576) }, /* #90/0/2/u0x10 = #4416 */
    { 0x0212, 0x0af2, 0xb2b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af82a000,0) }, /* #90/0/2/u0x20 = #4417 */
    { 0x037f, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/0/3/m = #4418 */
    { 0x0300, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/0/3/u = #4419 */
    { 0x0302, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/0/3/0x2 = #4420 */
    { 0x0312, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/0/3/0x12[!] = #4421 */
    { 0x0310, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/0/3/u0x2 = #4422 */
    { 0x0302, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/0/3/u0x10 = #4423 */
    { 0x047f, 0x0af2, 0x3232, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924130000000000,0) }, /* #90/1/0/m = #4424 */
    { 0x0400, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/1/0/u = #4425 */
    { 0x0432, 0x0af2, 0x3232, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924130000000000,0) }, /* #90/1/0/0x32 = #4426 */
    { 0x0430, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/1/0/u0x2 = #4427 */
    { 0x0422, 0x0af2, 0xb2b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x9248250000000000,24576) }, /* #90/1/0/u0x10 = #4428 */
    { 0x0412, 0x0af2, 0xb2b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924130000000000,0) }, /* #90/1/0/u0x20 = #4429 */
    { 0x057f, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/1/1/m = #4430 */
    { 0x0500, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/1/1/u = #4431 */
    { 0x0502, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/1/1/0x2 = #4432 */
    { 0x0512, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/1/1/0x12[!] = #4433 */
    { 0x0510, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/1/1/u0x2 = #4434 */
    { 0x0502, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/1/1/u0x10 = #4435 */
    { 0x067f, 0x0af2, 0x3232, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af82a000,0) }, /* #90/1/2/m = #4436 */
    { 0x0600, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/1/2/u = #4437 */
    { 0x0632, 0x0af2, 0x3232, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af82a000,0) }, /* #90/1/2/0x32 = #4438 */
    { 0x0630, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/1/2/u0x2 = #4439 */
    { 0x0622, 0x0af2, 0xb2b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f054000,24576) }, /* #90/1/2/u0x10 = #4440 */
    { 0x0612, 0x0af2, 0xb2b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af82a000,0) }, /* #90/1/2/u0x20 = #4441 */
    { 0x077f, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/1/3/m = #4442 */
    { 0x0700, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/1/3/u = #4443 */
    { 0x0702, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/1/3/0x2 = #4444 */
    { 0x0712, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/1/3/0x12[!] = #4445 */
    { 0x0710, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/1/3/u0x2 = #4446 */
    { 0x0702, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/1/3/u0x10 = #4447 */
    { 0x087f, 0x0af2, 0x3032, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924120000000000,0) }, /* #90/2/0/m = #4448 */
    { 0x0800, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/2/0/u = #4449 */
    { 0x0832, 0x0af2, 0x3032, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924120000000000,0) }, /* #90/2/0/0x32 = #4450 */
    { 0x0830, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/2/0/u0x2 = #4451 */
    { 0x0822, 0x0af2, 0xb0b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x9248240000000000,24576) }, /* #90/2/0/u0x10 = #4452 */
    { 0x0812, 0x0af2, 0xb0b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924120000000000,0) }, /* #90/2/0/u0x20 = #4453 */
    { 0x097f, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/2/1/m = #4454 */
    { 0x0900, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/2/1/u = #4455 */
    { 0x0902, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/2/1/0x2 = #4456 */
    { 0x0912, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/2/1/0x12[!] = #4457 */
    { 0x0910, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/2/1/u0x2 = #4458 */
    { 0x0902, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/2/1/u0x10 = #4459 */
    { 0x0a7f, 0x0af2, 0x3032, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829800,0) }, /* #90/2/2/m = #4460 */
    { 0x0a00, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/2/2/u = #4461 */
    { 0x0a32, 0x0af2, 0x3032, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829800,0) }, /* #90/2/2/0x32 = #4462 */
    { 0x0a30, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/2/2/u0x2 = #4463 */
    { 0x0a22, 0x0af2, 0xb0b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053800,24576) }, /* #90/2/2/u0x10 = #4464 */
    { 0x0a12, 0x0af2, 0xb0b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829800,0) }, /* #90/2/2/u0x20 = #4465 */
    { 0x0b7f, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/2/3/m = #4466 */
    { 0x0b00, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/2/3/u = #4467 */
    { 0x0b02, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/2/3/0x2 = #4468 */
    { 0x0b12, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/2/3/0x12[!] = #4469 */
    { 0x0b10, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/2/3/u0x2 = #4470 */
    { 0x0b02, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/2/3/u0x10 = #4471 */
    { 0x0c7f, 0x0af2, 0x3032, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924120000000000,0) }, /* #90/3/0/m = #4472 */
    { 0x0c00, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/3/0/u = #4473 */
    { 0x0c32, 0x0af2, 0x3032, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924120000000000,0) }, /* #90/3/0/0x32 = #4474 */
    { 0x0c30, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/3/0/u0x2 = #4475 */
    { 0x0c22, 0x0af2, 0xb0b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x9248240000000000,24576) }, /* #90/3/0/u0x10 = #4476 */
    { 0x0c12, 0x0af2, 0xb0b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x4924120000000000,0) }, /* #90/3/0/u0x20 = #4477 */
    { 0x0d7f, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/3/1/m = #4478 */
    { 0x0d00, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/3/1/u = #4479 */
    { 0x0d02, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/3/1/0x2 = #4480 */
    { 0x0d12, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/3/1/0x12[!] = #4481 */
    { 0x0d10, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/3/1/u0x2 = #4482 */
    { 0x0d02, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/3/1/u0x10 = #4483 */
    { 0x0e7f, 0x0af2, 0x3032, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829800,0) }, /* #90/3/2/m = #4484 */
    { 0x0e00, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/3/2/u = #4485 */
    { 0x0e32, 0x0af2, 0x3032, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829800,0) }, /* #90/3/2/0x32 = #4486 */
    { 0x0e30, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/3/2/u0x2 = #4487 */
    { 0x0e22, 0x0af2, 0xb0b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053800,24576) }, /* #90/3/2/u0x10 = #4488 */
    { 0x0e12, 0x0af2, 0xb0b2, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829800,0) }, /* #90/3/2/u0x20 = #4489 */
    { 0x0f7f, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/3/3/m = #4490 */
    { 0x0f00, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/3/3/u = #4491 */
    { 0x0f02, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/3/3/0x2 = #4492 */
    { 0x0f12, 0x0af2, 0x3002, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x49241231af829fac,0) }, /* #90/3/3/0x12[!] = #4493 */
    { 0x0f10, 0x0af2, 0xb082, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0) }, /* #90/3/3/u0x2 = #4494 */
    { 0x0f02, 0x0af2, 0xb092, RTFLOAT80U_INIT_C(0,0x59067569366ac13a,0), RTFLOAT80U_INIT_C(1,0xa22a879ae5ed60e6,0), RTFLOAT80U_INIT_C(1,0x924824635f053f58,24576) }, /* #90/3/3/u0x10 = #4495 */
    { 0x007f, 0x08a3, 0x3232, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562050000000000,0) }, /* #91/0/0/m = #4496 */
    { 0x0000, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/0/0/u = #4497 */
    { 0x0032, 0x08a3, 0x3232, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562050000000000,0) }, /* #91/0/0/0x32 = #4498 */
    { 0x0030, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/0/0/u0x2 = #4499 */
    { 0x0022, 0x08a3, 0xb2b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x9588130000000000,24575) }, /* #91/0/0/u0x10 = #4500 */
    { 0x0012, 0x08a3, 0xb2b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562050000000000,0) }, /* #91/0/0/u0x20 = #4501 */
    { 0x017f, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/0/1/m = #4502 */
    { 0x0100, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/0/1/u = #4503 */
    { 0x0102, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/0/1/0x2 = #4504 */
    { 0x0112, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/0/1/0x12[!] = #4505 */
    { 0x0110, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/0/1/u0x2 = #4506 */
    { 0x0102, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/0/1/u0x10 = #4507 */
    { 0x027f, 0x08a3, 0x3232, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e800,0) }, /* #91/0/2/m = #4508 */
    { 0x0200, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/0/2/u = #4509 */
    { 0x0232, 0x08a3, 0x3232, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e800,0) }, /* #91/0/2/0x32 = #4510 */
    { 0x0230, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/0/2/u0x2 = #4511 */
    { 0x0222, 0x08a3, 0xb2b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139800,24575) }, /* #91/0/2/u0x10 = #4512 */
    { 0x0212, 0x08a3, 0xb2b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e800,0) }, /* #91/0/2/u0x20 = #4513 */
    { 0x037f, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/0/3/m = #4514 */
    { 0x0300, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/0/3/u = #4515 */
    { 0x0302, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/0/3/0x2 = #4516 */
    { 0x0312, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/0/3/0x12[!] = #4517 */
    { 0x0310, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/0/3/u0x2 = #4518 */
    { 0x0302, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/0/3/u0x10 = #4519 */
    { 0x047f, 0x08a3, 0x3232, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562050000000000,0) }, /* #91/1/0/m = #4520 */
    { 0x0400, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/1/0/u = #4521 */
    { 0x0432, 0x08a3, 0x3232, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562050000000000,0) }, /* #91/1/0/0x32 = #4522 */
    { 0x0430, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/1/0/u0x2 = #4523 */
    { 0x0422, 0x08a3, 0xb2b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x9588130000000000,24575) }, /* #91/1/0/u0x10 = #4524 */
    { 0x0412, 0x08a3, 0xb2b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562050000000000,0) }, /* #91/1/0/u0x20 = #4525 */
    { 0x057f, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/1/1/m = #4526 */
    { 0x0500, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/1/1/u = #4527 */
    { 0x0502, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/1/1/0x2 = #4528 */
    { 0x0512, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/1/1/0x12[!] = #4529 */
    { 0x0510, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/1/1/u0x2 = #4530 */
    { 0x0502, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/1/1/u0x10 = #4531 */
    { 0x067f, 0x08a3, 0x3232, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e800,0) }, /* #91/1/2/m = #4532 */
    { 0x0600, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/1/2/u = #4533 */
    { 0x0632, 0x08a3, 0x3232, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e800,0) }, /* #91/1/2/0x32 = #4534 */
    { 0x0630, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/1/2/u0x2 = #4535 */
    { 0x0622, 0x08a3, 0xb2b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139800,24575) }, /* #91/1/2/u0x10 = #4536 */
    { 0x0612, 0x08a3, 0xb2b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e800,0) }, /* #91/1/2/u0x20 = #4537 */
    { 0x077f, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/1/3/m = #4538 */
    { 0x0700, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/1/3/u = #4539 */
    { 0x0702, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/1/3/0x2 = #4540 */
    { 0x0712, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/1/3/0x12[!] = #4541 */
    { 0x0710, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/1/3/u0x2 = #4542 */
    { 0x0702, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/1/3/u0x10 = #4543 */
    { 0x087f, 0x08a3, 0x3032, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562040000000000,0) }, /* #91/2/0/m = #4544 */
    { 0x0800, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/2/0/u = #4545 */
    { 0x0832, 0x08a3, 0x3032, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562040000000000,0) }, /* #91/2/0/0x32 = #4546 */
    { 0x0830, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/2/0/u0x2 = #4547 */
    { 0x0822, 0x08a3, 0xb0b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x9588120000000000,24575) }, /* #91/2/0/u0x10 = #4548 */
    { 0x0812, 0x08a3, 0xb0b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562040000000000,0) }, /* #91/2/0/u0x20 = #4549 */
    { 0x097f, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/2/1/m = #4550 */
    { 0x0900, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/2/1/u = #4551 */
    { 0x0902, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/2/1/0x2 = #4552 */
    { 0x0912, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/2/1/0x12[!] = #4553 */
    { 0x0910, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/2/1/u0x2 = #4554 */
    { 0x0902, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/2/1/u0x10 = #4555 */
    { 0x0a7f, 0x08a3, 0x3032, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e000,0) }, /* #91/2/2/m = #4556 */
    { 0x0a00, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/2/2/u = #4557 */
    { 0x0a32, 0x08a3, 0x3032, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e000,0) }, /* #91/2/2/0x32 = #4558 */
    { 0x0a30, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/2/2/u0x2 = #4559 */
    { 0x0a22, 0x08a3, 0xb0b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139000,24575) }, /* #91/2/2/u0x10 = #4560 */
    { 0x0a12, 0x08a3, 0xb0b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e000,0) }, /* #91/2/2/u0x20 = #4561 */
    { 0x0b7f, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/2/3/m = #4562 */
    { 0x0b00, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/2/3/u = #4563 */
    { 0x0b02, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/2/3/0x2 = #4564 */
    { 0x0b12, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/2/3/0x12[!] = #4565 */
    { 0x0b10, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/2/3/u0x2 = #4566 */
    { 0x0b02, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/2/3/u0x10 = #4567 */
    { 0x0c7f, 0x08a3, 0x3032, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562040000000000,0) }, /* #91/3/0/m = #4568 */
    { 0x0c00, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/3/0/u = #4569 */
    { 0x0c32, 0x08a3, 0x3032, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562040000000000,0) }, /* #91/3/0/0x32 = #4570 */
    { 0x0c30, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/3/0/u0x2 = #4571 */
    { 0x0c22, 0x08a3, 0xb0b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x9588120000000000,24575) }, /* #91/3/0/u0x10 = #4572 */
    { 0x0c12, 0x08a3, 0xb0b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x2562040000000000,0) }, /* #91/3/0/u0x20 = #4573 */
    { 0x0d7f, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/3/1/m = #4574 */
    { 0x0d00, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/3/1/u = #4575 */
    { 0x0d02, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/3/1/0x2 = #4576 */
    { 0x0d12, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/3/1/0x12[!] = #4577 */
    { 0x0d10, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/3/1/u0x2 = #4578 */
    { 0x0d02, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/3/1/u0x10 = #4579 */
    { 0x0e7f, 0x08a3, 0x3032, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e000,0) }, /* #91/3/2/m = #4580 */
    { 0x0e00, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/3/2/u = #4581 */
    { 0x0e32, 0x08a3, 0x3032, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e000,0) }, /* #91/3/2/0x32 = #4582 */
    { 0x0e30, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/3/2/u0x2 = #4583 */
    { 0x0e22, 0x08a3, 0xb0b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139000,24575) }, /* #91/3/2/u0x10 = #4584 */
    { 0x0e12, 0x08a3, 0xb0b2, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e000,0) }, /* #91/3/2/u0x20 = #4585 */
    { 0x0f7f, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/3/3/m = #4586 */
    { 0x0f00, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/3/3/u = #4587 */
    { 0x0f02, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/3/3/0x2 = #4588 */
    { 0x0f12, 0x08a3, 0x3002, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x256204bebbc4e555,0) }, /* #91/3/3/0x12[!] = #4589 */
    { 0x0f10, 0x08a3, 0xb082, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0) }, /* #91/3/3/u0x2 = #4590 */
    { 0x0f02, 0x08a3, 0xb092, RTFLOAT80U_INIT_C(1,0x7050ee57cefa5fe9,0), RTFLOAT80U_INIT_C(0,0x4aeee99913357a94,0), RTFLOAT80U_INIT_C(1,0x958812faef139554,24575) }, /* #91/3/3/u0x10 = #4591 */
    { 0x007f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/0/m = #4592 */
    { 0x0000, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/0/u = #4593 */
    { 0x017f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/1/m = #4594 */
    { 0x0100, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/1/u = #4595 */
    { 0x027f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/2/m = #4596 */
    { 0x0200, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/2/u = #4597 */
    { 0x037f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/3/m = #4598 */
    { 0x0300, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/0/3/u = #4599 */
    { 0x047f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/0/m = #4600 */
    { 0x0400, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/0/u = #4601 */
    { 0x057f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/1/m = #4602 */
    { 0x0500, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/1/u = #4603 */
    { 0x067f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/2/m = #4604 */
    { 0x0600, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/2/u = #4605 */
    { 0x077f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/3/m = #4606 */
    { 0x0700, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/1/3/u = #4607 */
    { 0x087f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/0/m = #4608 */
    { 0x0800, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/0/u = #4609 */
    { 0x097f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/1/m = #4610 */
    { 0x0900, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/1/u = #4611 */
    { 0x0a7f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/2/m = #4612 */
    { 0x0a00, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/2/u = #4613 */
    { 0x0b7f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/3/m = #4614 */
    { 0x0b00, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/2/3/u = #4615 */
    { 0x0c7f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/0/m = #4616 */
    { 0x0c00, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/0/u = #4617 */
    { 0x0d7f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/1/m = #4618 */
    { 0x0d00, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/1/u = #4619 */
    { 0x0e7f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/2/m = #4620 */
    { 0x0e00, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/2/u = #4621 */
    { 0x0f7f, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/3/m = #4622 */
    { 0x0f00, 0x67e1, 0x7500, RTFLOAT80U_INIT_C(0,0x125daa759315f079,0), RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #92/3/3/u = #4623 */
    { 0x007f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/0/m = #4624 */
    { 0x0000, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/0/0/u = #4625 */
    { 0x0002, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/0/0x2 = #4626 */
    { 0x017f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/1/m = #4627 */
    { 0x0100, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/0/1/u = #4628 */
    { 0x0102, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/1/0x2 = #4629 */
    { 0x027f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/2/m = #4630 */
    { 0x0200, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/0/2/u = #4631 */
    { 0x0202, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/2/0x2 = #4632 */
    { 0x037f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/3/m = #4633 */
    { 0x0300, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/0/3/u = #4634 */
    { 0x0302, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/0/3/0x2 = #4635 */
    { 0x047f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/0/m = #4636 */
    { 0x0400, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/1/0/u = #4637 */
    { 0x0402, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/0/0x2 = #4638 */
    { 0x057f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/1/m = #4639 */
    { 0x0500, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/1/1/u = #4640 */
    { 0x0502, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/1/0x2 = #4641 */
    { 0x067f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/2/m = #4642 */
    { 0x0600, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/1/2/u = #4643 */
    { 0x0602, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/2/0x2 = #4644 */
    { 0x077f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/3/m = #4645 */
    { 0x0700, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/1/3/u = #4646 */
    { 0x0702, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/1/3/0x2 = #4647 */
    { 0x087f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/0/m = #4648 */
    { 0x0800, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/2/0/u = #4649 */
    { 0x0802, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/0/0x2 = #4650 */
    { 0x097f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/1/m = #4651 */
    { 0x0900, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/2/1/u = #4652 */
    { 0x0902, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/1/0x2 = #4653 */
    { 0x0a7f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/2/m = #4654 */
    { 0x0a00, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/2/2/u = #4655 */
    { 0x0a02, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/2/0x2 = #4656 */
    { 0x0b7f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/3/m = #4657 */
    { 0x0b00, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/2/3/u = #4658 */
    { 0x0b02, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/2/3/0x2 = #4659 */
    { 0x0c7f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/0/m = #4660 */
    { 0x0c00, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/3/0/u = #4661 */
    { 0x0c02, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/0/0x2 = #4662 */
    { 0x0d7f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/1/m = #4663 */
    { 0x0d00, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/3/1/u = #4664 */
    { 0x0d02, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/1/0x2 = #4665 */
    { 0x0e7f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/2/m = #4666 */
    { 0x0e00, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/3/2/u = #4667 */
    { 0x0e02, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/2/0x2 = #4668 */
    { 0x0f7f, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/3/m = #4669 */
    { 0x0f00, 0xdf47, 0xf582, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0) }, /* #93/3/3/u = #4670 */
    { 0x0f02, 0xdf47, 0x7502, RTFLOAT80U_INIT_C(1,0x72001e6bba58e078,0), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #93/3/3/0x2 = #4671 */
    { 0x007f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/0/m = #4672 */
    { 0x0000, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/0/0/u = #4673 */
    { 0x0001, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/0/0x1 = #4674 */
    { 0x017f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/1/m = #4675 */
    { 0x0100, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/0/1/u = #4676 */
    { 0x0101, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/1/0x1 = #4677 */
    { 0x027f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/2/m = #4678 */
    { 0x0200, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/0/2/u = #4679 */
    { 0x0201, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/2/0x1 = #4680 */
    { 0x037f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/3/m = #4681 */
    { 0x0300, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/0/3/u = #4682 */
    { 0x0301, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/0/3/0x1 = #4683 */
    { 0x047f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/0/m = #4684 */
    { 0x0400, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/1/0/u = #4685 */
    { 0x0401, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/0/0x1 = #4686 */
    { 0x057f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/1/m = #4687 */
    { 0x0500, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/1/1/u = #4688 */
    { 0x0501, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/1/0x1 = #4689 */
    { 0x067f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/2/m = #4690 */
    { 0x0600, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/1/2/u = #4691 */
    { 0x0601, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/2/0x1 = #4692 */
    { 0x077f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/3/m = #4693 */
    { 0x0700, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/1/3/u = #4694 */
    { 0x0701, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/1/3/0x1 = #4695 */
    { 0x087f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/0/m = #4696 */
    { 0x0800, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/2/0/u = #4697 */
    { 0x0801, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/0/0x1 = #4698 */
    { 0x097f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/1/m = #4699 */
    { 0x0900, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/2/1/u = #4700 */
    { 0x0901, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/1/0x1 = #4701 */
    { 0x0a7f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/2/m = #4702 */
    { 0x0a00, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/2/2/u = #4703 */
    { 0x0a01, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/2/0x1 = #4704 */
    { 0x0b7f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/3/m = #4705 */
    { 0x0b00, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/2/3/u = #4706 */
    { 0x0b01, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/2/3/0x1 = #4707 */
    { 0x0c7f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/0/m = #4708 */
    { 0x0c00, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/3/0/u = #4709 */
    { 0x0c01, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/0/0x1 = #4710 */
    { 0x0d7f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/1/m = #4711 */
    { 0x0d00, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/3/1/u = #4712 */
    { 0x0d01, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/1/0x1 = #4713 */
    { 0x0e7f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/2/m = #4714 */
    { 0x0e00, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/3/2/u = #4715 */
    { 0x0e01, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/2/0x1 = #4716 */
    { 0x0f7f, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/3/m = #4717 */
    { 0x0f00, 0xbe65, 0xb481, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0) }, /* #94/3/3/u = #4718 */
    { 0x0f01, 0xbe65, 0x3401, RTFLOAT80U_INIT_C(1,0x63422dae2211536f,0), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #94/3/3/0x1 = #4719 */
    { 0x007f, 0x21c1, 0x3132, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b0000000000,0) }, /* #95/0/0/m = #4720 */
    { 0x0000, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/0/u = #4721 */
    { 0x0032, 0x21c1, 0x3132, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b0000000000,0) }, /* #95/0/0/0x32 = #4722 */
    { 0x0030, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/0/u0x2 = #4723 */
    { 0x0022, 0x21c1, 0xb3b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea18570000000000,24576) }, /* #95/0/0/u0x10 = #4724 */
    { 0x0012, 0x21c1, 0xb1b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b0000000000,0) }, /* #95/0/0/u0x20 = #4725 */
    { 0x017f, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/1/m = #4726 */
    { 0x0100, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/1/u = #4727 */
    { 0x0102, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/0/1/0x2 = #4728 */
    { 0x0112, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/1/0x12[!] = #4729 */
    { 0x0110, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/1/u0x2 = #4730 */
    { 0x0102, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/0/1/u0x10 = #4731 */
    { 0x027f, 0x21c1, 0x3332, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563800,0) }, /* #95/0/2/m = #4732 */
    { 0x0200, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/2/u = #4733 */
    { 0x0232, 0x21c1, 0x3332, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563800,0) }, /* #95/0/2/0x32 = #4734 */
    { 0x0230, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/2/u0x2 = #4735 */
    { 0x0222, 0x21c1, 0xb1b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6800,24576) }, /* #95/0/2/u0x10 = #4736 */
    { 0x0212, 0x21c1, 0xb3b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563800,0) }, /* #95/0/2/u0x20 = #4737 */
    { 0x037f, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/3/m = #4738 */
    { 0x0300, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/3/u = #4739 */
    { 0x0302, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/0/3/0x2 = #4740 */
    { 0x0312, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/3/0x12[!] = #4741 */
    { 0x0310, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/0/3/u0x2 = #4742 */
    { 0x0302, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/0/3/u0x10 = #4743 */
    { 0x047f, 0x21c1, 0x3132, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b0000000000,0) }, /* #95/1/0/m = #4744 */
    { 0x0400, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/0/u = #4745 */
    { 0x0432, 0x21c1, 0x3132, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b0000000000,0) }, /* #95/1/0/0x32 = #4746 */
    { 0x0430, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/0/u0x2 = #4747 */
    { 0x0422, 0x21c1, 0xb1b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea18560000000000,24576) }, /* #95/1/0/u0x10 = #4748 */
    { 0x0412, 0x21c1, 0xb1b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b0000000000,0) }, /* #95/1/0/u0x20 = #4749 */
    { 0x057f, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/1/m = #4750 */
    { 0x0500, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/1/u = #4751 */
    { 0x0502, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/1/1/0x2 = #4752 */
    { 0x0512, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/1/0x12[!] = #4753 */
    { 0x0510, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/1/u0x2 = #4754 */
    { 0x0502, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/1/1/u0x10 = #4755 */
    { 0x067f, 0x21c1, 0x3132, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563000,0) }, /* #95/1/2/m = #4756 */
    { 0x0600, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/2/u = #4757 */
    { 0x0632, 0x21c1, 0x3132, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563000,0) }, /* #95/1/2/0x32 = #4758 */
    { 0x0630, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/2/u0x2 = #4759 */
    { 0x0622, 0x21c1, 0xb1b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6800,24576) }, /* #95/1/2/u0x10 = #4760 */
    { 0x0612, 0x21c1, 0xb1b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563000,0) }, /* #95/1/2/u0x20 = #4761 */
    { 0x077f, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/3/m = #4762 */
    { 0x0700, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/3/u = #4763 */
    { 0x0702, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/1/3/0x2 = #4764 */
    { 0x0712, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/3/0x12[!] = #4765 */
    { 0x0710, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/1/3/u0x2 = #4766 */
    { 0x0702, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/1/3/u0x10 = #4767 */
    { 0x087f, 0x21c1, 0x3332, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2c0000000000,0) }, /* #95/2/0/m = #4768 */
    { 0x0800, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/0/u = #4769 */
    { 0x0832, 0x21c1, 0x3332, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2c0000000000,0) }, /* #95/2/0/0x32 = #4770 */
    { 0x0830, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/0/u0x2 = #4771 */
    { 0x0822, 0x21c1, 0xb3b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea18570000000000,24576) }, /* #95/2/0/u0x10 = #4772 */
    { 0x0812, 0x21c1, 0xb3b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2c0000000000,0) }, /* #95/2/0/u0x20 = #4773 */
    { 0x097f, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/1/m = #4774 */
    { 0x0900, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/1/u = #4775 */
    { 0x0902, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/2/1/0x2 = #4776 */
    { 0x0912, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/1/0x12[!] = #4777 */
    { 0x0910, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/1/u0x2 = #4778 */
    { 0x0902, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/2/1/u0x10 = #4779 */
    { 0x0a7f, 0x21c1, 0x3332, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563800,0) }, /* #95/2/2/m = #4780 */
    { 0x0a00, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/2/u = #4781 */
    { 0x0a32, 0x21c1, 0x3332, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563800,0) }, /* #95/2/2/0x32 = #4782 */
    { 0x0a30, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/2/u0x2 = #4783 */
    { 0x0a22, 0x21c1, 0xb3b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac7000,24576) }, /* #95/2/2/u0x10 = #4784 */
    { 0x0a12, 0x21c1, 0xb3b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563800,0) }, /* #95/2/2/u0x20 = #4785 */
    { 0x0b7f, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/3/m = #4786 */
    { 0x0b00, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/3/u = #4787 */
    { 0x0b02, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/2/3/0x2 = #4788 */
    { 0x0b12, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/3/0x12[!] = #4789 */
    { 0x0b10, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/2/3/u0x2 = #4790 */
    { 0x0b02, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/2/3/u0x10 = #4791 */
    { 0x0c7f, 0x21c1, 0x3132, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b0000000000,0) }, /* #95/3/0/m = #4792 */
    { 0x0c00, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/0/u = #4793 */
    { 0x0c32, 0x21c1, 0x3132, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b0000000000,0) }, /* #95/3/0/0x32 = #4794 */
    { 0x0c30, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/0/u0x2 = #4795 */
    { 0x0c22, 0x21c1, 0xb1b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea18560000000000,24576) }, /* #95/3/0/u0x10 = #4796 */
    { 0x0c12, 0x21c1, 0xb1b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b0000000000,0) }, /* #95/3/0/u0x20 = #4797 */
    { 0x0d7f, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/1/m = #4798 */
    { 0x0d00, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/1/u = #4799 */
    { 0x0d02, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/3/1/0x2 = #4800 */
    { 0x0d12, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/1/0x12[!] = #4801 */
    { 0x0d10, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/1/u0x2 = #4802 */
    { 0x0d02, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/3/1/u0x10 = #4803 */
    { 0x0e7f, 0x21c1, 0x3132, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563000,0) }, /* #95/3/2/m = #4804 */
    { 0x0e00, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/2/u = #4805 */
    { 0x0e32, 0x21c1, 0x3132, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563000,0) }, /* #95/3/2/0x32 = #4806 */
    { 0x0e30, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/2/u0x2 = #4807 */
    { 0x0e22, 0x21c1, 0xb1b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6800,24576) }, /* #95/3/2/u0x10 = #4808 */
    { 0x0e12, 0x21c1, 0xb1b2, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b563000,0) }, /* #95/3/2/u0x20 = #4809 */
    { 0x0f7f, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/3/m = #4810 */
    { 0x0f00, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/3/u = #4811 */
    { 0x0f02, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/3/3/0x2 = #4812 */
    { 0x0f12, 0x21c1, 0x3102, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/3/0x12[!] = #4813 */
    { 0x0f10, 0x21c1, 0xb182, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0) }, /* #95/3/3/u0x2 = #4814 */
    { 0x0f02, 0x21c1, 0xb192, RTFLOAT80U_INIT_C(0,0x750c2b599b5635de,0), RTFLOAT80U_INIT_ZERO(0), RTFLOAT80U_INIT_C(0,0xea1856b336ac6bbc,24576) }, /* #95/3/3/u0x10 = #4815 */
    { 0x007f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/0/0/m = #4816 */
    { 0x0000, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/0/0/u = #4817 */
    { 0x017f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/0/1/m = #4818 */
    { 0x0100, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/0/1/u = #4819 */
    { 0x027f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/0/2/m = #4820 */
    { 0x0200, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/0/2/u = #4821 */
    { 0x037f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/0/3/m = #4822 */
    { 0x0300, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/0/3/u = #4823 */
    { 0x047f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/1/0/m = #4824 */
    { 0x0400, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/1/0/u = #4825 */
    { 0x057f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/1/1/m = #4826 */
    { 0x0500, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/1/1/u = #4827 */
    { 0x067f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/1/2/m = #4828 */
    { 0x0600, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/1/2/u = #4829 */
    { 0x077f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/1/3/m = #4830 */
    { 0x0700, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/1/3/u = #4831 */
    { 0x087f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/2/0/m = #4832 */
    { 0x0800, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/2/0/u = #4833 */
    { 0x097f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/2/1/m = #4834 */
    { 0x0900, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/2/1/u = #4835 */
    { 0x0a7f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/2/2/m = #4836 */
    { 0x0a00, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/2/2/u = #4837 */
    { 0x0b7f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/2/3/m = #4838 */
    { 0x0b00, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/2/3/u = #4839 */
    { 0x0c7f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/3/0/m = #4840 */
    { 0x0c00, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/3/0/u = #4841 */
    { 0x0d7f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/3/1/m = #4842 */
    { 0x0d00, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/3/1/u = #4843 */
    { 0x0e7f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/3/2/m = #4844 */
    { 0x0e00, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/3/2/u = #4845 */
    { 0x0f7f, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/3/3/m = #4846 */
    { 0x0f00, 0x32a9, 0x3000, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xca4fcb516c903aed,18294), RTFLOAT80U_INIT_IND(1) }, /* #96/3/3/u = #4847 */
    { 0x007f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/0/0/m = #4848 */
    { 0x0000, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/0/0/u = #4849 */
    { 0x017f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/0/1/m = #4850 */
    { 0x0100, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/0/1/u = #4851 */
    { 0x027f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/0/2/m = #4852 */
    { 0x0200, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/0/2/u = #4853 */
    { 0x037f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/0/3/m = #4854 */
    { 0x0300, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/0/3/u = #4855 */
    { 0x047f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/1/0/m = #4856 */
    { 0x0400, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/1/0/u = #4857 */
    { 0x057f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/1/1/m = #4858 */
    { 0x0500, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/1/1/u = #4859 */
    { 0x067f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/1/2/m = #4860 */
    { 0x0600, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/1/2/u = #4861 */
    { 0x077f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/1/3/m = #4862 */
    { 0x0700, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/1/3/u = #4863 */
    { 0x087f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/2/0/m = #4864 */
    { 0x0800, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/2/0/u = #4865 */
    { 0x097f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/2/1/m = #4866 */
    { 0x0900, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/2/1/u = #4867 */
    { 0x0a7f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/2/2/m = #4868 */
    { 0x0a00, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/2/2/u = #4869 */
    { 0x0b7f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/2/3/m = #4870 */
    { 0x0b00, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/2/3/u = #4871 */
    { 0x0c7f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/3/0/m = #4872 */
    { 0x0c00, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/3/0/u = #4873 */
    { 0x0d7f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/3/1/m = #4874 */
    { 0x0d00, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/3/1/u = #4875 */
    { 0x0e7f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/3/2/m = #4876 */
    { 0x0e00, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/3/2/u = #4877 */
    { 0x0f7f, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/3/3/m = #4878 */
    { 0x0f00, 0x64f8, 0x7400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_IND(1) }, /* #97/3/3/u = #4879 */
    { 0x007f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/0/m = #4880 */
    { 0x0000, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/0/u = #4881 */
    { 0x0001, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/0/0x1 = #4882 */
    { 0x017f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/1/m = #4883 */
    { 0x0100, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/1/u = #4884 */
    { 0x0101, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/1/0x1 = #4885 */
    { 0x027f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/2/m = #4886 */
    { 0x0200, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/2/u = #4887 */
    { 0x0201, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/2/0x1 = #4888 */
    { 0x037f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/3/m = #4889 */
    { 0x0300, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/3/u = #4890 */
    { 0x0301, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/0/3/0x1 = #4891 */
    { 0x047f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/0/m = #4892 */
    { 0x0400, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/0/u = #4893 */
    { 0x0401, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/0/0x1 = #4894 */
    { 0x057f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/1/m = #4895 */
    { 0x0500, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/1/u = #4896 */
    { 0x0501, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/1/0x1 = #4897 */
    { 0x067f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/2/m = #4898 */
    { 0x0600, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/2/u = #4899 */
    { 0x0601, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/2/0x1 = #4900 */
    { 0x077f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/3/m = #4901 */
    { 0x0700, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/3/u = #4902 */
    { 0x0701, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/1/3/0x1 = #4903 */
    { 0x087f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/0/m = #4904 */
    { 0x0800, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/0/u = #4905 */
    { 0x0801, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/0/0x1 = #4906 */
    { 0x097f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/1/m = #4907 */
    { 0x0900, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/1/u = #4908 */
    { 0x0901, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/1/0x1 = #4909 */
    { 0x0a7f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/2/m = #4910 */
    { 0x0a00, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/2/u = #4911 */
    { 0x0a01, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/2/0x1 = #4912 */
    { 0x0b7f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/3/m = #4913 */
    { 0x0b00, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/3/u = #4914 */
    { 0x0b01, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/2/3/0x1 = #4915 */
    { 0x0c7f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/0/m = #4916 */
    { 0x0c00, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/0/u = #4917 */
    { 0x0c01, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/0/0x1 = #4918 */
    { 0x0d7f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/1/m = #4919 */
    { 0x0d00, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/1/u = #4920 */
    { 0x0d01, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/1/0x1 = #4921 */
    { 0x0e7f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/2/m = #4922 */
    { 0x0e00, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/2/u = #4923 */
    { 0x0e01, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/2/0x1 = #4924 */
    { 0x0f7f, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/3/m = #4925 */
    { 0x0f00, 0xece1, 0xf481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/3/u = #4926 */
    { 0x0f01, 0xece1, 0x7401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0x10b9f4bb1e464c14,14640), RTFLOAT80U_INIT_IND(1) }, /* #98/3/3/0x1 = #4927 */
    { 0x007f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/0/m = #4928 */
    { 0x0000, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/0/u = #4929 */
    { 0x0001, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/0/0x1 = #4930 */
    { 0x017f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/1/m = #4931 */
    { 0x0100, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/1/u = #4932 */
    { 0x0101, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/1/0x1 = #4933 */
    { 0x027f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/2/m = #4934 */
    { 0x0200, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/2/u = #4935 */
    { 0x0201, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/2/0x1 = #4936 */
    { 0x037f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/3/m = #4937 */
    { 0x0300, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/3/u = #4938 */
    { 0x0301, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/0/3/0x1 = #4939 */
    { 0x047f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/0/m = #4940 */
    { 0x0400, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/0/u = #4941 */
    { 0x0401, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/0/0x1 = #4942 */
    { 0x057f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/1/m = #4943 */
    { 0x0500, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/1/u = #4944 */
    { 0x0501, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/1/0x1 = #4945 */
    { 0x067f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/2/m = #4946 */
    { 0x0600, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/2/u = #4947 */
    { 0x0601, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/2/0x1 = #4948 */
    { 0x077f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/3/m = #4949 */
    { 0x0700, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/3/u = #4950 */
    { 0x0701, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/1/3/0x1 = #4951 */
    { 0x087f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/0/m = #4952 */
    { 0x0800, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/0/u = #4953 */
    { 0x0801, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/0/0x1 = #4954 */
    { 0x097f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/1/m = #4955 */
    { 0x0900, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/1/u = #4956 */
    { 0x0901, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/1/0x1 = #4957 */
    { 0x0a7f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/2/m = #4958 */
    { 0x0a00, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/2/u = #4959 */
    { 0x0a01, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/2/0x1 = #4960 */
    { 0x0b7f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/3/m = #4961 */
    { 0x0b00, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/3/u = #4962 */
    { 0x0b01, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/2/3/0x1 = #4963 */
    { 0x0c7f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/0/m = #4964 */
    { 0x0c00, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/0/u = #4965 */
    { 0x0c01, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/0/0x1 = #4966 */
    { 0x0d7f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/1/m = #4967 */
    { 0x0d00, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/1/u = #4968 */
    { 0x0d01, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/1/0x1 = #4969 */
    { 0x0e7f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/2/m = #4970 */
    { 0x0e00, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/2/u = #4971 */
    { 0x0e01, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/2/0x1 = #4972 */
    { 0x0f7f, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/3/m = #4973 */
    { 0x0f00, 0xeac5, 0xf081, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/3/u = #4974 */
    { 0x0f01, 0xeac5, 0x7001, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(1,0x87612aba271fcff6,32767), RTFLOAT80U_INIT_IND(0) }, /* #99/3/3/0x1 = #4975 */
    { 0x007f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/0/0/m = #4976 */
    { 0x0000, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/0/0/u = #4977 */
    { 0x017f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/0/1/m = #4978 */
    { 0x0100, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/0/1/u = #4979 */
    { 0x027f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/0/2/m = #4980 */
    { 0x0200, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/0/2/u = #4981 */
    { 0x037f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/0/3/m = #4982 */
    { 0x0300, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/0/3/u = #4983 */
    { 0x047f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/1/0/m = #4984 */
    { 0x0400, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/1/0/u = #4985 */
    { 0x057f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/1/1/m = #4986 */
    { 0x0500, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/1/1/u = #4987 */
    { 0x067f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/1/2/m = #4988 */
    { 0x0600, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/1/2/u = #4989 */
    { 0x077f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/1/3/m = #4990 */
    { 0x0700, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/1/3/u = #4991 */
    { 0x087f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/2/0/m = #4992 */
    { 0x0800, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/2/0/u = #4993 */
    { 0x097f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/2/1/m = #4994 */
    { 0x0900, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/2/1/u = #4995 */
    { 0x0a7f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/2/2/m = #4996 */
    { 0x0a00, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/2/2/u = #4997 */
    { 0x0b7f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/2/3/m = #4998 */
    { 0x0b00, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/2/3/u = #4999 */
    { 0x0c7f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/3/0/m = #5000 */
    { 0x0c00, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/3/0/u = #5001 */
    { 0x0d7f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/3/1/m = #5002 */
    { 0x0d00, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/3/1/u = #5003 */
    { 0x0e7f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/3/2/m = #5004 */
    { 0x0e00, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/3/2/u = #5005 */
    { 0x0f7f, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/3/3/m = #5006 */
    { 0x0f00, 0x04cd, 0x3400, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767), RTFLOAT80U_INIT_C(0,0xdf8dbd314b7228f1,32767) }, /* #100/3/3/u = #5007 */
    { 0x007f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/0/m = #5008 */
    { 0x0000, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/0/u = #5009 */
    { 0x0001, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/0/0x1 = #5010 */
    { 0x017f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/1/m = #5011 */
    { 0x0100, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/1/u = #5012 */
    { 0x0101, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/1/0x1 = #5013 */
    { 0x027f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/2/m = #5014 */
    { 0x0200, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/2/u = #5015 */
    { 0x0201, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/2/0x1 = #5016 */
    { 0x037f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/3/m = #5017 */
    { 0x0300, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/3/u = #5018 */
    { 0x0301, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/0/3/0x1 = #5019 */
    { 0x047f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/0/m = #5020 */
    { 0x0400, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/0/u = #5021 */
    { 0x0401, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/0/0x1 = #5022 */
    { 0x057f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/1/m = #5023 */
    { 0x0500, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/1/u = #5024 */
    { 0x0501, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/1/0x1 = #5025 */
    { 0x067f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/2/m = #5026 */
    { 0x0600, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/2/u = #5027 */
    { 0x0601, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/2/0x1 = #5028 */
    { 0x077f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/3/m = #5029 */
    { 0x0700, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/3/u = #5030 */
    { 0x0701, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/1/3/0x1 = #5031 */
    { 0x087f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/0/m = #5032 */
    { 0x0800, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/0/u = #5033 */
    { 0x0801, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/0/0x1 = #5034 */
    { 0x097f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/1/m = #5035 */
    { 0x0900, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/1/u = #5036 */
    { 0x0901, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/1/0x1 = #5037 */
    { 0x0a7f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/2/m = #5038 */
    { 0x0a00, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/2/u = #5039 */
    { 0x0a01, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/2/0x1 = #5040 */
    { 0x0b7f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/3/m = #5041 */
    { 0x0b00, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/3/u = #5042 */
    { 0x0b01, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/2/3/0x1 = #5043 */
    { 0x0c7f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/0/m = #5044 */
    { 0x0c00, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/0/u = #5045 */
    { 0x0c01, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/0/0x1 = #5046 */
    { 0x0d7f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/1/m = #5047 */
    { 0x0d00, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/1/u = #5048 */
    { 0x0d01, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/1/0x1 = #5049 */
    { 0x0e7f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/2/m = #5050 */
    { 0x0e00, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/2/u = #5051 */
    { 0x0e01, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/2/0x1 = #5052 */
    { 0x0f7f, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/3/m = #5053 */
    { 0x0f00, 0x3e34, 0xb481, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/3/u = #5054 */
    { 0x0f01, 0x3e34, 0x3401, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x4a1261803c6d3944,32767), RTFLOAT80U_INIT_IND(1) }, /* #101/3/3/0x1 = #5055 */
    { 0x007f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/0/m = #5056 */
    { 0x0000, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/0/u = #5057 */
    { 0x017f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/1/m = #5058 */
    { 0x0100, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/1/u = #5059 */
    { 0x027f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/2/m = #5060 */
    { 0x0200, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/2/u = #5061 */
    { 0x037f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/3/m = #5062 */
    { 0x0300, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/0/3/u = #5063 */
    { 0x047f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/0/m = #5064 */
    { 0x0400, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/0/u = #5065 */
    { 0x057f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/1/m = #5066 */
    { 0x0500, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/1/u = #5067 */
    { 0x067f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/2/m = #5068 */
    { 0x0600, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/2/u = #5069 */
    { 0x077f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/3/m = #5070 */
    { 0x0700, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/1/3/u = #5071 */
    { 0x087f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/0/m = #5072 */
    { 0x0800, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/0/u = #5073 */
    { 0x097f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/1/m = #5074 */
    { 0x0900, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/1/u = #5075 */
    { 0x0a7f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/2/m = #5076 */
    { 0x0a00, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/2/u = #5077 */
    { 0x0b7f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/3/m = #5078 */
    { 0x0b00, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/2/3/u = #5079 */
    { 0x0c7f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/0/m = #5080 */
    { 0x0c00, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/0/u = #5081 */
    { 0x0d7f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/1/m = #5082 */
    { 0x0d00, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/1/u = #5083 */
    { 0x0e7f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/2/m = #5084 */
    { 0x0e00, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/2/u = #5085 */
    { 0x0f7f, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/3/m = #5086 */
    { 0x0f00, 0x9354, 0x3100, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(1,0xbec15f17491d7470,0), RTFLOAT80U_INIT_IND(1) }, /* #102/3/3/u = #5087 */
    { 0x007f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/0/m = #5088 */
    { 0x0000, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/0/u = #5089 */
    { 0x017f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/1/m = #5090 */
    { 0x0100, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/1/u = #5091 */
    { 0x027f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/2/m = #5092 */
    { 0x0200, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/2/u = #5093 */
    { 0x037f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/3/m = #5094 */
    { 0x0300, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/0/3/u = #5095 */
    { 0x047f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/0/m = #5096 */
    { 0x0400, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/0/u = #5097 */
    { 0x057f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/1/m = #5098 */
    { 0x0500, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/1/u = #5099 */
    { 0x067f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/2/m = #5100 */
    { 0x0600, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/2/u = #5101 */
    { 0x077f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/3/m = #5102 */
    { 0x0700, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/1/3/u = #5103 */
    { 0x087f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/0/m = #5104 */
    { 0x0800, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/0/u = #5105 */
    { 0x097f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/1/m = #5106 */
    { 0x0900, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/1/u = #5107 */
    { 0x0a7f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/2/m = #5108 */
    { 0x0a00, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/2/u = #5109 */
    { 0x0b7f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/3/m = #5110 */
    { 0x0b00, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/2/3/u = #5111 */
    { 0x0c7f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/0/m = #5112 */
    { 0x0c00, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/0/u = #5113 */
    { 0x0d7f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/1/m = #5114 */
    { 0x0d00, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/1/u = #5115 */
    { 0x0e7f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/2/m = #5116 */
    { 0x0e00, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/2/u = #5117 */
    { 0x0f7f, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/3/m = #5118 */
    { 0x0f00, 0x13dd, 0x3100, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_C(0,0x4b6e6c2f92b66c56,0), RTFLOAT80U_INIT_IND(0) }, /* #103/3/3/u = #5119 */
    { 0x007f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/0/0/m = #5120 */
    { 0x0000, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/0/0/u = #5121 */
    { 0x017f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/0/1/m = #5122 */
    { 0x0100, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/0/1/u = #5123 */
    { 0x027f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/0/2/m = #5124 */
    { 0x0200, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/0/2/u = #5125 */
    { 0x037f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/0/3/m = #5126 */
    { 0x0300, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/0/3/u = #5127 */
    { 0x047f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/1/0/m = #5128 */
    { 0x0400, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/1/0/u = #5129 */
    { 0x057f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/1/1/m = #5130 */
    { 0x0500, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/1/1/u = #5131 */
    { 0x067f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/1/2/m = #5132 */
    { 0x0600, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/1/2/u = #5133 */
    { 0x077f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/1/3/m = #5134 */
    { 0x0700, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/1/3/u = #5135 */
    { 0x087f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/2/0/m = #5136 */
    { 0x0800, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/2/0/u = #5137 */
    { 0x097f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/2/1/m = #5138 */
    { 0x0900, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/2/1/u = #5139 */
    { 0x0a7f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/2/2/m = #5140 */
    { 0x0a00, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/2/2/u = #5141 */
    { 0x0b7f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/2/3/m = #5142 */
    { 0x0b00, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/2/3/u = #5143 */
    { 0x0c7f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/3/0/m = #5144 */
    { 0x0c00, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/3/0/u = #5145 */
    { 0x0d7f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/3/1/m = #5146 */
    { 0x0d00, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/3/1/u = #5147 */
    { 0x0e7f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/3/2/m = #5148 */
    { 0x0e00, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/3/2/u = #5149 */
    { 0x0f7f, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/3/3/m = #5150 */
    { 0x0f00, 0x1f19, 0x3500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #104/3/3/u = #5151 */
    { 0x007f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/0/m = #5152 */
    { 0x0000, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/0/u = #5153 */
    { 0x017f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/1/m = #5154 */
    { 0x0100, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/1/u = #5155 */
    { 0x027f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/2/m = #5156 */
    { 0x0200, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/2/u = #5157 */
    { 0x037f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/3/m = #5158 */
    { 0x0300, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/0/3/u = #5159 */
    { 0x047f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/0/m = #5160 */
    { 0x0400, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/0/u = #5161 */
    { 0x057f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/1/m = #5162 */
    { 0x0500, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/1/u = #5163 */
    { 0x067f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/2/m = #5164 */
    { 0x0600, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/2/u = #5165 */
    { 0x077f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/3/m = #5166 */
    { 0x0700, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/1/3/u = #5167 */
    { 0x087f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/0/m = #5168 */
    { 0x0800, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/0/u = #5169 */
    { 0x097f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/1/m = #5170 */
    { 0x0900, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/1/u = #5171 */
    { 0x0a7f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/2/m = #5172 */
    { 0x0a00, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/2/u = #5173 */
    { 0x0b7f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/3/m = #5174 */
    { 0x0b00, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/2/3/u = #5175 */
    { 0x0c7f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/0/m = #5176 */
    { 0x0c00, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/0/u = #5177 */
    { 0x0d7f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/1/m = #5178 */
    { 0x0d00, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/1/u = #5179 */
    { 0x0e7f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/2/m = #5180 */
    { 0x0e00, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/2/u = #5181 */
    { 0x0f7f, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/3/m = #5182 */
    { 0x0f00, 0x85e8, 0x3500, RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0) }, /* #105/3/3/u = #5183 */
    { 0x007f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/0/m = #5184 */
    { 0x0000, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/0/u = #5185 */
    { 0x0001, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/0/0x1 = #5186 */
    { 0x017f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/1/m = #5187 */
    { 0x0100, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/1/u = #5188 */
    { 0x0101, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/1/0x1 = #5189 */
    { 0x027f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/2/m = #5190 */
    { 0x0200, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/2/u = #5191 */
    { 0x0201, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/2/0x1 = #5192 */
    { 0x037f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/3/m = #5193 */
    { 0x0300, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/3/u = #5194 */
    { 0x0301, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/0/3/0x1 = #5195 */
    { 0x047f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/0/m = #5196 */
    { 0x0400, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/0/u = #5197 */
    { 0x0401, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/0/0x1 = #5198 */
    { 0x057f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/1/m = #5199 */
    { 0x0500, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/1/u = #5200 */
    { 0x0501, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/1/0x1 = #5201 */
    { 0x067f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/2/m = #5202 */
    { 0x0600, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/2/u = #5203 */
    { 0x0601, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/2/0x1 = #5204 */
    { 0x077f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/3/m = #5205 */
    { 0x0700, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/3/u = #5206 */
    { 0x0701, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/1/3/0x1 = #5207 */
    { 0x087f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/0/m = #5208 */
    { 0x0800, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/0/u = #5209 */
    { 0x0801, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/0/0x1 = #5210 */
    { 0x097f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/1/m = #5211 */
    { 0x0900, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/1/u = #5212 */
    { 0x0901, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/1/0x1 = #5213 */
    { 0x0a7f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/2/m = #5214 */
    { 0x0a00, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/2/u = #5215 */
    { 0x0a01, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/2/0x1 = #5216 */
    { 0x0b7f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/3/m = #5217 */
    { 0x0b00, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/3/u = #5218 */
    { 0x0b01, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/2/3/0x1 = #5219 */
    { 0x0c7f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/0/m = #5220 */
    { 0x0c00, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/0/u = #5221 */
    { 0x0c01, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/0/0x1 = #5222 */
    { 0x0d7f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/1/m = #5223 */
    { 0x0d00, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/1/u = #5224 */
    { 0x0d01, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/1/0x1 = #5225 */
    { 0x0e7f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/2/m = #5226 */
    { 0x0e00, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/2/u = #5227 */
    { 0x0e01, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/2/0x1 = #5228 */
    { 0x0f7f, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/3/m = #5229 */
    { 0x0f00, 0x5140, 0xf181, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/3/u = #5230 */
    { 0x0f01, 0x5140, 0x7101, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #106/3/3/0x1 = #5231 */
    { 0x007f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/0/0/m = #5232 */
    { 0x0000, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/0/0/u = #5233 */
    { 0x017f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/0/1/m = #5234 */
    { 0x0100, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/0/1/u = #5235 */
    { 0x027f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/0/2/m = #5236 */
    { 0x0200, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/0/2/u = #5237 */
    { 0x037f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/0/3/m = #5238 */
    { 0x0300, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/0/3/u = #5239 */
    { 0x047f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/1/0/m = #5240 */
    { 0x0400, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/1/0/u = #5241 */
    { 0x057f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/1/1/m = #5242 */
    { 0x0500, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/1/1/u = #5243 */
    { 0x067f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/1/2/m = #5244 */
    { 0x0600, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/1/2/u = #5245 */
    { 0x077f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/1/3/m = #5246 */
    { 0x0700, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/1/3/u = #5247 */
    { 0x087f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/2/0/m = #5248 */
    { 0x0800, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/2/0/u = #5249 */
    { 0x097f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/2/1/m = #5250 */
    { 0x0900, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/2/1/u = #5251 */
    { 0x0a7f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/2/2/m = #5252 */
    { 0x0a00, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/2/2/u = #5253 */
    { 0x0b7f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/2/3/m = #5254 */
    { 0x0b00, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/2/3/u = #5255 */
    { 0x0c7f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/3/0/m = #5256 */
    { 0x0c00, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/3/0/u = #5257 */
    { 0x0d7f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/3/1/m = #5258 */
    { 0x0d00, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/3/1/u = #5259 */
    { 0x0e7f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/3/2/m = #5260 */
    { 0x0e00, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/3/2/u = #5261 */
    { 0x0f7f, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/3/3/m = #5262 */
    { 0x0f00, 0x5f9d, 0x7500, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_IND(1) }, /* #107/3/3/u = #5263 */
    { 0x007f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/0/0/m = #5264 */
    { 0x0000, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/0/0/u = #5265 */
    { 0x017f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/0/1/m = #5266 */
    { 0x0100, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/0/1/u = #5267 */
    { 0x027f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/0/2/m = #5268 */
    { 0x0200, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/0/2/u = #5269 */
    { 0x037f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/0/3/m = #5270 */
    { 0x0300, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/0/3/u = #5271 */
    { 0x047f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/1/0/m = #5272 */
    { 0x0400, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/1/0/u = #5273 */
    { 0x057f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/1/1/m = #5274 */
    { 0x0500, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/1/1/u = #5275 */
    { 0x067f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/1/2/m = #5276 */
    { 0x0600, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/1/2/u = #5277 */
    { 0x077f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/1/3/m = #5278 */
    { 0x0700, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/1/3/u = #5279 */
    { 0x087f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/2/0/m = #5280 */
    { 0x0800, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/2/0/u = #5281 */
    { 0x097f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/2/1/m = #5282 */
    { 0x0900, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/2/1/u = #5283 */
    { 0x0a7f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/2/2/m = #5284 */
    { 0x0a00, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/2/2/u = #5285 */
    { 0x0b7f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/2/3/m = #5286 */
    { 0x0b00, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/2/3/u = #5287 */
    { 0x0c7f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/3/0/m = #5288 */
    { 0x0c00, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/3/0/u = #5289 */
    { 0x0d7f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/3/1/m = #5290 */
    { 0x0d00, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/3/1/u = #5291 */
    { 0x0e7f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/3/2/m = #5292 */
    { 0x0e00, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/3/2/u = #5293 */
    { 0x0f7f, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/3/3/m = #5294 */
    { 0x0f00, 0x7616, 0x7400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xe0db67c6e38910ab,17521), RTFLOAT80U_INIT_INF(0) }, /* #108/3/3/u = #5295 */
    { 0x007f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/0/0/m = #5296 */
    { 0x0000, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/0/0/u = #5297 */
    { 0x017f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/0/1/m = #5298 */
    { 0x0100, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/0/1/u = #5299 */
    { 0x027f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/0/2/m = #5300 */
    { 0x0200, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/0/2/u = #5301 */
    { 0x037f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/0/3/m = #5302 */
    { 0x0300, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/0/3/u = #5303 */
    { 0x047f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/1/0/m = #5304 */
    { 0x0400, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/1/0/u = #5305 */
    { 0x057f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/1/1/m = #5306 */
    { 0x0500, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/1/1/u = #5307 */
    { 0x067f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/1/2/m = #5308 */
    { 0x0600, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/1/2/u = #5309 */
    { 0x077f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/1/3/m = #5310 */
    { 0x0700, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/1/3/u = #5311 */
    { 0x087f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/2/0/m = #5312 */
    { 0x0800, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/2/0/u = #5313 */
    { 0x097f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/2/1/m = #5314 */
    { 0x0900, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/2/1/u = #5315 */
    { 0x0a7f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/2/2/m = #5316 */
    { 0x0a00, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/2/2/u = #5317 */
    { 0x0b7f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/2/3/m = #5318 */
    { 0x0b00, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/2/3/u = #5319 */
    { 0x0c7f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/3/0/m = #5320 */
    { 0x0c00, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/3/0/u = #5321 */
    { 0x0d7f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/3/1/m = #5322 */
    { 0x0d00, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/3/1/u = #5323 */
    { 0x0e7f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/3/2/m = #5324 */
    { 0x0e00, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/3/2/u = #5325 */
    { 0x0f7f, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/3/3/m = #5326 */
    { 0x0f00, 0x0b6d, 0x3100, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,16400), RTFLOAT80U_INIT_INF(0) }, /* #109/3/3/u = #5327 */
    { 0x007f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/0/0/m = #5328 */
    { 0x0000, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/0/0/u = #5329 */
    { 0x0001, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/0/0/0x1 = #5330 */
    { 0x017f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/0/1/m = #5331 */
    { 0x0100, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/0/1/u = #5332 */
    { 0x0101, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/0/1/0x1 = #5333 */
    { 0x027f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/0/2/m = #5334 */
    { 0x0200, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/0/2/u = #5335 */
    { 0x0201, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/0/2/0x1 = #5336 */
    { 0x037f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/0/3/m = #5337 */
    { 0x0300, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/0/3/u = #5338 */
    { 0x0301, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/0/3/0x1 = #5339 */
    { 0x047f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/1/0/m = #5340 */
    { 0x0400, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/1/0/u = #5341 */
    { 0x0401, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/1/0/0x1 = #5342 */
    { 0x057f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/1/1/m = #5343 */
    { 0x0500, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/1/1/u = #5344 */
    { 0x0501, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/1/1/0x1 = #5345 */
    { 0x067f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/1/2/m = #5346 */
    { 0x0600, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/1/2/u = #5347 */
    { 0x0601, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/1/2/0x1 = #5348 */
    { 0x077f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/1/3/m = #5349 */
    { 0x0700, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/1/3/u = #5350 */
    { 0x0701, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/1/3/0x1 = #5351 */
    { 0x087f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/2/0/m = #5352 */
    { 0x0800, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/2/0/u = #5353 */
    { 0x0801, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/2/0/0x1 = #5354 */
    { 0x097f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/2/1/m = #5355 */
    { 0x0900, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/2/1/u = #5356 */
    { 0x0901, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/2/1/0x1 = #5357 */
    { 0x0a7f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/2/2/m = #5358 */
    { 0x0a00, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/2/2/u = #5359 */
    { 0x0a01, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/2/2/0x1 = #5360 */
    { 0x0b7f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/2/3/m = #5361 */
    { 0x0b00, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/2/3/u = #5362 */
    { 0x0b01, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/2/3/0x1 = #5363 */
    { 0x0c7f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/3/0/m = #5364 */
    { 0x0c00, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/3/0/u = #5365 */
    { 0x0c01, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/3/0/0x1 = #5366 */
    { 0x0d7f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/3/1/m = #5367 */
    { 0x0d00, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/3/1/u = #5368 */
    { 0x0d01, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/3/1/0x1 = #5369 */
    { 0x0e7f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/3/2/m = #5370 */
    { 0x0e00, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/3/2/u = #5371 */
    { 0x0e01, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/3/2/0x1 = #5372 */
    { 0x0f7f, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/3/3/m = #5373 */
    { 0x0f00, 0x3e68, 0xb481, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_INF(0) }, /* #110/3/3/u = #5374 */
    { 0x0f01, 0x3e68, 0x3401, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0x1c07a9ae875782b3,27443), RTFLOAT80U_INIT_IND(1) }, /* #110/3/3/0x1 = #5375 */
    { 0x007f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/0/0/m = #5376 */
    { 0x0000, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/0/0/u = #5377 */
    { 0x0001, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/0/0/0x1 = #5378 */
    { 0x017f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/0/1/m = #5379 */
    { 0x0100, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/0/1/u = #5380 */
    { 0x0101, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/0/1/0x1 = #5381 */
    { 0x027f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/0/2/m = #5382 */
    { 0x0200, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/0/2/u = #5383 */
    { 0x0201, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/0/2/0x1 = #5384 */
    { 0x037f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/0/3/m = #5385 */
    { 0x0300, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/0/3/u = #5386 */
    { 0x0301, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/0/3/0x1 = #5387 */
    { 0x047f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/1/0/m = #5388 */
    { 0x0400, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/1/0/u = #5389 */
    { 0x0401, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/1/0/0x1 = #5390 */
    { 0x057f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/1/1/m = #5391 */
    { 0x0500, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/1/1/u = #5392 */
    { 0x0501, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/1/1/0x1 = #5393 */
    { 0x067f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/1/2/m = #5394 */
    { 0x0600, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/1/2/u = #5395 */
    { 0x0601, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/1/2/0x1 = #5396 */
    { 0x077f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/1/3/m = #5397 */
    { 0x0700, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/1/3/u = #5398 */
    { 0x0701, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/1/3/0x1 = #5399 */
    { 0x087f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/2/0/m = #5400 */
    { 0x0800, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/2/0/u = #5401 */
    { 0x0801, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/2/0/0x1 = #5402 */
    { 0x097f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/2/1/m = #5403 */
    { 0x0900, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/2/1/u = #5404 */
    { 0x0901, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/2/1/0x1 = #5405 */
    { 0x0a7f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/2/2/m = #5406 */
    { 0x0a00, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/2/2/u = #5407 */
    { 0x0a01, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/2/2/0x1 = #5408 */
    { 0x0b7f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/2/3/m = #5409 */
    { 0x0b00, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/2/3/u = #5410 */
    { 0x0b01, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/2/3/0x1 = #5411 */
    { 0x0c7f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/3/0/m = #5412 */
    { 0x0c00, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/3/0/u = #5413 */
    { 0x0c01, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/3/0/0x1 = #5414 */
    { 0x0d7f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/3/1/m = #5415 */
    { 0x0d00, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/3/1/u = #5416 */
    { 0x0d01, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/3/1/0x1 = #5417 */
    { 0x0e7f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/3/2/m = #5418 */
    { 0x0e00, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/3/2/u = #5419 */
    { 0x0e01, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/3/2/0x1 = #5420 */
    { 0x0f7f, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/3/3/m = #5421 */
    { 0x0f00, 0x031a, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_INF(1) }, /* #111/3/3/u = #5422 */
    { 0x0f01, 0x031a, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(0,0xa83e7657d8cdfa06,32767), RTFLOAT80U_INIT_C(0,0xe83e7657d8cdfa06,32767) }, /* #111/3/3/0x1 = #5423 */
    { 0x007f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/0/0/m = #5424 */
    { 0x0000, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/0/0/u = #5425 */
    { 0x017f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/0/1/m = #5426 */
    { 0x0100, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/0/1/u = #5427 */
    { 0x027f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/0/2/m = #5428 */
    { 0x0200, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/0/2/u = #5429 */
    { 0x037f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/0/3/m = #5430 */
    { 0x0300, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/0/3/u = #5431 */
    { 0x047f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/1/0/m = #5432 */
    { 0x0400, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/1/0/u = #5433 */
    { 0x057f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/1/1/m = #5434 */
    { 0x0500, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/1/1/u = #5435 */
    { 0x067f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/1/2/m = #5436 */
    { 0x0600, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/1/2/u = #5437 */
    { 0x077f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/1/3/m = #5438 */
    { 0x0700, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/1/3/u = #5439 */
    { 0x087f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/2/0/m = #5440 */
    { 0x0800, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/2/0/u = #5441 */
    { 0x097f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/2/1/m = #5442 */
    { 0x0900, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/2/1/u = #5443 */
    { 0x0a7f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/2/2/m = #5444 */
    { 0x0a00, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/2/2/u = #5445 */
    { 0x0b7f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/2/3/m = #5446 */
    { 0x0b00, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/2/3/u = #5447 */
    { 0x0c7f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/3/0/m = #5448 */
    { 0x0c00, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/3/0/u = #5449 */
    { 0x0d7f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/3/1/m = #5450 */
    { 0x0d00, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/3/1/u = #5451 */
    { 0x0e7f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/3/2/m = #5452 */
    { 0x0e00, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/3/2/u = #5453 */
    { 0x0f7f, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/3/3/m = #5454 */
    { 0x0f00, 0x3ee5, 0x3400, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767), RTFLOAT80U_INIT_C(0,0xe8d97360ebd2d549,32767) }, /* #112/3/3/u = #5455 */
    { 0x007f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/0/m = #5456 */
    { 0x0000, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/0/0/u = #5457 */
    { 0x0001, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/0/0x1 = #5458 */
    { 0x017f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/1/m = #5459 */
    { 0x0100, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/0/1/u = #5460 */
    { 0x0101, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/1/0x1 = #5461 */
    { 0x027f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/2/m = #5462 */
    { 0x0200, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/0/2/u = #5463 */
    { 0x0201, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/2/0x1 = #5464 */
    { 0x037f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/3/m = #5465 */
    { 0x0300, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/0/3/u = #5466 */
    { 0x0301, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/0/3/0x1 = #5467 */
    { 0x047f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/0/m = #5468 */
    { 0x0400, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/1/0/u = #5469 */
    { 0x0401, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/0/0x1 = #5470 */
    { 0x057f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/1/m = #5471 */
    { 0x0500, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/1/1/u = #5472 */
    { 0x0501, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/1/0x1 = #5473 */
    { 0x067f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/2/m = #5474 */
    { 0x0600, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/1/2/u = #5475 */
    { 0x0601, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/2/0x1 = #5476 */
    { 0x077f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/3/m = #5477 */
    { 0x0700, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/1/3/u = #5478 */
    { 0x0701, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/1/3/0x1 = #5479 */
    { 0x087f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/0/m = #5480 */
    { 0x0800, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/2/0/u = #5481 */
    { 0x0801, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/0/0x1 = #5482 */
    { 0x097f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/1/m = #5483 */
    { 0x0900, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/2/1/u = #5484 */
    { 0x0901, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/1/0x1 = #5485 */
    { 0x0a7f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/2/m = #5486 */
    { 0x0a00, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/2/2/u = #5487 */
    { 0x0a01, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/2/0x1 = #5488 */
    { 0x0b7f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/3/m = #5489 */
    { 0x0b00, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/2/3/u = #5490 */
    { 0x0b01, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/2/3/0x1 = #5491 */
    { 0x0c7f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/0/m = #5492 */
    { 0x0c00, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/3/0/u = #5493 */
    { 0x0c01, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/0/0x1 = #5494 */
    { 0x0d7f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/1/m = #5495 */
    { 0x0d00, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/3/1/u = #5496 */
    { 0x0d01, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/1/0x1 = #5497 */
    { 0x0e7f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/2/m = #5498 */
    { 0x0e00, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/3/2/u = #5499 */
    { 0x0e01, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/2/0x1 = #5500 */
    { 0x0f7f, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/3/m = #5501 */
    { 0x0f00, 0xcb18, 0xf181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_INF(1) }, /* #113/3/3/u = #5502 */
    { 0x0f01, 0xcb18, 0x7101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x22b543eec3726a3f,32767), RTFLOAT80U_INIT_IND(1) }, /* #113/3/3/0x1 = #5503 */
    { 0x007f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/0/m = #5504 */
    { 0x0000, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/0/u = #5505 */
    { 0x0002, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/0/0x2 = #5506 */
    { 0x017f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/1/m = #5507 */
    { 0x0100, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/1/u = #5508 */
    { 0x0102, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/1/0x2 = #5509 */
    { 0x027f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/2/m = #5510 */
    { 0x0200, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/2/u = #5511 */
    { 0x0202, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/2/0x2 = #5512 */
    { 0x037f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/3/m = #5513 */
    { 0x0300, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/3/u = #5514 */
    { 0x0302, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/0/3/0x2 = #5515 */
    { 0x047f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/0/m = #5516 */
    { 0x0400, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/0/u = #5517 */
    { 0x0402, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/0/0x2 = #5518 */
    { 0x057f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/1/m = #5519 */
    { 0x0500, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/1/u = #5520 */
    { 0x0502, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/1/0x2 = #5521 */
    { 0x067f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/2/m = #5522 */
    { 0x0600, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/2/u = #5523 */
    { 0x0602, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/2/0x2 = #5524 */
    { 0x077f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/3/m = #5525 */
    { 0x0700, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/3/u = #5526 */
    { 0x0702, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/1/3/0x2 = #5527 */
    { 0x087f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/0/m = #5528 */
    { 0x0800, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/0/u = #5529 */
    { 0x0802, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/0/0x2 = #5530 */
    { 0x097f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/1/m = #5531 */
    { 0x0900, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/1/u = #5532 */
    { 0x0902, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/1/0x2 = #5533 */
    { 0x0a7f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/2/m = #5534 */
    { 0x0a00, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/2/u = #5535 */
    { 0x0a02, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/2/0x2 = #5536 */
    { 0x0b7f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/3/m = #5537 */
    { 0x0b00, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/3/u = #5538 */
    { 0x0b02, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/2/3/0x2 = #5539 */
    { 0x0c7f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/0/m = #5540 */
    { 0x0c00, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/0/u = #5541 */
    { 0x0c02, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/0/0x2 = #5542 */
    { 0x0d7f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/1/m = #5543 */
    { 0x0d00, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/1/u = #5544 */
    { 0x0d02, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/1/0x2 = #5545 */
    { 0x0e7f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/2/m = #5546 */
    { 0x0e00, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/2/u = #5547 */
    { 0x0e02, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/2/0x2 = #5548 */
    { 0x0f7f, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/3/m = #5549 */
    { 0x0f00, 0x90ce, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/3/u = #5550 */
    { 0x0f02, 0x90ce, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(0,0xb3b77e378404abfc,0), RTFLOAT80U_INIT_INF(0) }, /* #114/3/3/0x2 = #5551 */
    { 0x007f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/0/m = #5552 */
    { 0x0000, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/0/u = #5553 */
    { 0x0002, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/0/0x2 = #5554 */
    { 0x017f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/1/m = #5555 */
    { 0x0100, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/1/u = #5556 */
    { 0x0102, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/1/0x2 = #5557 */
    { 0x027f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/2/m = #5558 */
    { 0x0200, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/2/u = #5559 */
    { 0x0202, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/2/0x2 = #5560 */
    { 0x037f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/3/m = #5561 */
    { 0x0300, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/3/u = #5562 */
    { 0x0302, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/0/3/0x2 = #5563 */
    { 0x047f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/0/m = #5564 */
    { 0x0400, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/0/u = #5565 */
    { 0x0402, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/0/0x2 = #5566 */
    { 0x057f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/1/m = #5567 */
    { 0x0500, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/1/u = #5568 */
    { 0x0502, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/1/0x2 = #5569 */
    { 0x067f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/2/m = #5570 */
    { 0x0600, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/2/u = #5571 */
    { 0x0602, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/2/0x2 = #5572 */
    { 0x077f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/3/m = #5573 */
    { 0x0700, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/3/u = #5574 */
    { 0x0702, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/1/3/0x2 = #5575 */
    { 0x087f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/0/m = #5576 */
    { 0x0800, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/0/u = #5577 */
    { 0x0802, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/0/0x2 = #5578 */
    { 0x097f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/1/m = #5579 */
    { 0x0900, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/1/u = #5580 */
    { 0x0902, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/1/0x2 = #5581 */
    { 0x0a7f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/2/m = #5582 */
    { 0x0a00, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/2/u = #5583 */
    { 0x0a02, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/2/0x2 = #5584 */
    { 0x0b7f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/3/m = #5585 */
    { 0x0b00, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/3/u = #5586 */
    { 0x0b02, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/2/3/0x2 = #5587 */
    { 0x0c7f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/0/m = #5588 */
    { 0x0c00, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/0/u = #5589 */
    { 0x0c02, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/0/0x2 = #5590 */
    { 0x0d7f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/1/m = #5591 */
    { 0x0d00, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/1/u = #5592 */
    { 0x0d02, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/1/0x2 = #5593 */
    { 0x0e7f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/2/m = #5594 */
    { 0x0e00, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/2/u = #5595 */
    { 0x0e02, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/2/0x2 = #5596 */
    { 0x0f7f, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/3/m = #5597 */
    { 0x0f00, 0xb089, 0xb082, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/3/u = #5598 */
    { 0x0f02, 0xb089, 0x3002, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x2c511b60f62bf848,0), RTFLOAT80U_INIT_INF(0) }, /* #115/3/3/0x2 = #5599 */
    { 0x007f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/0/0/m = #5600 */
    { 0x0000, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/0/0/u = #5601 */
    { 0x017f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/0/1/m = #5602 */
    { 0x0100, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/0/1/u = #5603 */
    { 0x027f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/0/2/m = #5604 */
    { 0x0200, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/0/2/u = #5605 */
    { 0x037f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/0/3/m = #5606 */
    { 0x0300, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/0/3/u = #5607 */
    { 0x047f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/1/0/m = #5608 */
    { 0x0400, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/1/0/u = #5609 */
    { 0x057f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/1/1/m = #5610 */
    { 0x0500, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/1/1/u = #5611 */
    { 0x067f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/1/2/m = #5612 */
    { 0x0600, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/1/2/u = #5613 */
    { 0x077f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/1/3/m = #5614 */
    { 0x0700, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/1/3/u = #5615 */
    { 0x087f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/2/0/m = #5616 */
    { 0x0800, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/2/0/u = #5617 */
    { 0x097f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/2/1/m = #5618 */
    { 0x0900, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/2/1/u = #5619 */
    { 0x0a7f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/2/2/m = #5620 */
    { 0x0a00, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/2/2/u = #5621 */
    { 0x0b7f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/2/3/m = #5622 */
    { 0x0b00, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/2/3/u = #5623 */
    { 0x0c7f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/3/0/m = #5624 */
    { 0x0c00, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/3/0/u = #5625 */
    { 0x0d7f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/3/1/m = #5626 */
    { 0x0d00, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/3/1/u = #5627 */
    { 0x0e7f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/3/2/m = #5628 */
    { 0x0e00, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/3/2/u = #5629 */
    { 0x0f7f, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/3/3/m = #5630 */
    { 0x0f00, 0x9a95, 0x3000, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(0), RTFLOAT80U_INIT_IND(0) }, /* #116/3/3/u = #5631 */
    { 0x007f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/0/0/m = #5632 */
    { 0x0000, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/0/0/u = #5633 */
    { 0x0001, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/0/0/0x1 = #5634 */
    { 0x017f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/0/1/m = #5635 */
    { 0x0100, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/0/1/u = #5636 */
    { 0x0101, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/0/1/0x1 = #5637 */
    { 0x027f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/0/2/m = #5638 */
    { 0x0200, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/0/2/u = #5639 */
    { 0x0201, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/0/2/0x1 = #5640 */
    { 0x037f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/0/3/m = #5641 */
    { 0x0300, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/0/3/u = #5642 */
    { 0x0301, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/0/3/0x1 = #5643 */
    { 0x047f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/1/0/m = #5644 */
    { 0x0400, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/1/0/u = #5645 */
    { 0x0401, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/1/0/0x1 = #5646 */
    { 0x057f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/1/1/m = #5647 */
    { 0x0500, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/1/1/u = #5648 */
    { 0x0501, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/1/1/0x1 = #5649 */
    { 0x067f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/1/2/m = #5650 */
    { 0x0600, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/1/2/u = #5651 */
    { 0x0601, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/1/2/0x1 = #5652 */
    { 0x077f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/1/3/m = #5653 */
    { 0x0700, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/1/3/u = #5654 */
    { 0x0701, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/1/3/0x1 = #5655 */
    { 0x087f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/2/0/m = #5656 */
    { 0x0800, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/2/0/u = #5657 */
    { 0x0801, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/2/0/0x1 = #5658 */
    { 0x097f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/2/1/m = #5659 */
    { 0x0900, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/2/1/u = #5660 */
    { 0x0901, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/2/1/0x1 = #5661 */
    { 0x0a7f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/2/2/m = #5662 */
    { 0x0a00, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/2/2/u = #5663 */
    { 0x0a01, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/2/2/0x1 = #5664 */
    { 0x0b7f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/2/3/m = #5665 */
    { 0x0b00, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/2/3/u = #5666 */
    { 0x0b01, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/2/3/0x1 = #5667 */
    { 0x0c7f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/3/0/m = #5668 */
    { 0x0c00, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/3/0/u = #5669 */
    { 0x0c01, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/3/0/0x1 = #5670 */
    { 0x0d7f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/3/1/m = #5671 */
    { 0x0d00, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/3/1/u = #5672 */
    { 0x0d01, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/3/1/0x1 = #5673 */
    { 0x0e7f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/3/2/m = #5674 */
    { 0x0e00, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/3/2/u = #5675 */
    { 0x0e01, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/3/2/0x1 = #5676 */
    { 0x0f7f, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/3/3/m = #5677 */
    { 0x0f00, 0xb9c2, 0xb181, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(1) }, /* #117/3/3/u = #5678 */
    { 0x0f01, 0xb9c2, 0x3101, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_IND(1) }, /* #117/3/3/0x1 = #5679 */
    { 0x007f, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/0/0/m = #5680 */
    { 0x0000, 0x97f7, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_INF(0) }, /* #118/0/0/u = #5681 */
    { 0x0001, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/0/0/0x1 = #5682 */
    { 0x017f, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/0/1/m = #5683 */
    { 0x0100, 0x97f7, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_INF(0) }, /* #118/0/1/u = #5684 */
    { 0x0101, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/0/1/0x1 = #5685 */
    { 0x027f, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/0/2/m = #5686 */
    { 0x0200, 0x97f7, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_INF(0) }, /* #118/0/2/u = #5687 */
    { 0x0201, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/0/2/0x1 = #5688 */
    { 0x037f, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/0/3/m = #5689 */
    { 0x0300, 0x97f7, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_INF(0) }, /* #118/0/3/u = #5690 */
    { 0x0301, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/0/3/0x1 = #5691 */
    { 0x047f, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/1/0/m = #5692 */
    { 0x0400, 0x97f7, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_INF(0) }, /* #118/1/0/u = #5693 */
    { 0x0401, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/1/0/0x1 = #5694 */
    { 0x057f, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/1/1/m = #5695 */
    { 0x0500, 0x97f7, 0xb581, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_INF(0) }, /* #118/1/1/u = #5696 */
    { 0x0501, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #118/1/1/0x1 = #5697 */
    { 0x067f, 0x97f7, 0x3501, RTFLOAT80U_INIT_INF(