//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_34.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot34(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[34] = {1.801053644969250e-02,1.621516966698450e-01,4.507380497098007e-01,8.843812021582210e-01,1.464007517495656e+00,
    2.190869145981500e+00,3.066559223223048e+00,4.093031692818531e+00,5.272626367745129e+00,6.608100040485690e+00,8.102664697177419e+00,9.760034205338282e+00,
    1.158448125449669e+01,1.358090687198238e+01,1.575492556667695e+01,1.811297015176490e+01,2.066242168346788e+01,2.341177190969444e+01,2.637082843649360e+01,
    2.955097694782022e+01,3.296552100347061e+01,3.663012945211139e+01,4.056343652613128e+01,4.478786419551375e+01,4.933077780921393e+01,5.422615918504088e+01,
    5.951711695224103e+01,6.525982111013776e+01,7.153001519315002e+01,7.843457727098679e+01,8.613406319080192e+01,9.489292108600368e+01,1.052170586202571e+02,
    1.184080812072897e+02};
  constexpr double aw[34] = {2.636273560096423e-01,2.283596414733269e-01,1.712956270459728e-01,1.112008383126223e-01,6.241746079469111e-02,
    3.025531101024893e-02,1.264471987172237e-02,4.547663268612475e-03,1.404211216213101e-03,3.712410471417878e-04,8.376792857109031e-05,1.607315423292878e-05,
    2.611496537603586e-06,3.575499301869167e-07,4.102331977604315e-08,3.919304831885386e-09,3.095298692877011e-10,2.003858788064466e-11,1.053163064708414e-12,
    4.443309388480383e-14,1.485249432153070e-15,3.873151690251420e-17,7.736213277543244e-19,1.157724753504370e-20,1.263594599711377e-22,9.728365817769475e-25,
    5.064526367985621e-27,1.687406073044250e-29,3.341517852475098e-32,3.543956863668978e-35,1.722545746682900e-38,2.972364265567055e-42,1.121792517702707e-46,
    2.717006711672789e-52};
  constexpr double x[13056] = {  1.036357832424877e-03, -7.506006823925807e-06,  4.075137210013641e-08, -1.965305650535716e-10,  8.877957084251273e-13,
 -3.846099201872822e-15,  1.617947681509891e-17, -6.658088754511806e-20,  2.692812222547824e-22, -1.073735003118264e-24,  4.230204806606288e-27, -1.649159424540855e-29,
  9.314700006537750e-03, -6.718799392343269e-05,  3.617880099191953e-07, -1.720879189691014e-09,  7.612931680772328e-12, -3.201453456975368e-14,  1.293270691041556e-16,
 -5.043603327830998e-19,  1.901948523203267e-21, -6.928325888548613e-24,  2.428773338187763e-26, -8.131338248020124e-29,  2.580470603795042e-02, -1.846123517631499e-04,
  9.777324344268708e-07, -4.521290734907437e-09,  1.914390109190406e-11, -7.545087247768194e-14,  2.774391468720584e-16, -9.433699932536667e-19,  2.891281378541899e-21,
 -7.466507454512621e-24,  1.255261186368075e-26,  1.694457500045149e-29,  5.037348752698272e-02, -3.559606343916849e-04,  1.838222387518125e-06, -8.134603691633327e-09,
  3.206671671095453e-11, -1.126936131201641e-13,  3.419839497071985e-16, -8.021156604872059e-19,  7.181409582332841e-22,  6.638669890322558e-24, -5.736706947495325e-26,
  3.052696887186805e-28,  8.282288121875434e-02, -5.756553998939238e-04,  2.872321775391435e-06, -1.194536015887167e-08,  4.223535850032605e-11, -1.210864356835787e-13,
  2.236650254826940e-16,  2.299861299520794e-19, -4.841058872670644e-21,  2.932758942200417e-23, -1.246910124781173e-25,  3.874436630713185e-28,  1.228908486910516e-01,
 -8.365356495740744e-04,  3.993690212757117e-06, -1.526958976849230e-08,  4.571620758763412e-11, -8.492230673405385e-14, -1.019932394670353e-16,  1.898112681355528e-18,
 -1.067304122240561e-20,  3.921864630130244e-23, -8.140153145253808e-26, -1.312987355243846e-28,  1.702533365703832e-01, -1.130082806882401e-03,  5.106902034784886e-06,
 -1.744908084549966e-08,  3.971899243337390e-11, -1.831305596288305e-15, -5.580929839185437e-16,  3.399960685416982e-18, -1.184834127496146e-20,  1.625148084303167e-23,
  1.063144310445249e-25, -9.815073876294279e-28,  2.245265917903591e-01, -1.446690660777363e-03,  6.114471483647234e-06, -1.794398593583621e-08,  2.331855200256505e-11,
  1.146663813199979e-13, -9.828482263254199e-16,  3.744428492931543e-18, -4.991352499838312e-21, -3.730336848585606e-23,  3.163381247644003e-25, -1.213571665930637e-27,
  2.852699246501935e-01, -1.775971341296031e-03,  6.924087279187167e-06, -1.641168075489628e-08, -2.189529085283543e-12,  2.374415219878706e-13, -1.185884514554914e-15,
  2.290420306424534e-18,  8.660440257370132e-21, -9.007303281208262e-23,  3.362046151326755e-25, -1.195846644095928e-28,  3.519889104294973e-01, -2.107088227397424e-03,
  7.455539589427816e-06, -1.276138747690891e-08, -3.338543257964090e-11,  3.324645342844953e-13, -1.024369055803496e-15, -8.110892611562188e-19,  2.276807206972160e-20,
 -9.872374671024086e-23,  5.110676637928307e-26,  1.750706446503427e-27,  4.241390180314859e-01, -2.429105743765220e-03,  7.646837532816937e-06, -7.177013768123981e-09,
 -6.527007546549007e-11,  3.682006832384992e-13, -4.694009696024451e-16, -4.526118209265519e-18,  2.879466320135592e-20, -4.003415760900916e-23, -4.051738646794469e-25,
  2.706880409542743e-27,  5.011296515304995e-01, -2.731345317040841e-03,  7.459065571361352e-06, -1.046084365858285e-10, -9.216371290551793e-11,  3.250747200162811e-13,
  3.651810784275776e-16, -7.293405178882574e-18,  2.095706274976493e-20,  6.524364454056503e-23, -6.967532624014451e-25,  1.394246947151698e-27,  5.823285875706018e-01,
 -3.003736362465652e-03,  6.879610000070001e-06,  7.794679386538160e-09, -1.087888777186822e-10,  2.022392731458406e-13,  1.246501095476447e-15, -7.699910176415576e-18,
  3.466391632491455e-22,  1.573951354170934e-22, -5.331387593543239e-25, -1.651061917398228e-27,  6.670667882903299e-01, -3.237151084235256e-03,  5.923497457626293e-06,
  1.572078061233698e-08, -1.113258458239428e-10,  1.952907322221601e-14,  1.894196989000025e-15, -5.173085493110523e-18, -2.450406786348371e-20,  1.729898437257269e-22,
  6.759791199106907e-26, -4.042220639684594e-27,  7.546435658377387e-01, -3.423712116258504e-03,  4.632719155613460e-06,  2.283078339694473e-08, -9.822770034378558e-11,
 -1.862298173301142e-13,  2.076234933985473e-15, -3.502803065368821e-19, -4.142451808180003e-20,  8.874095852510230e-23,  7.327998317368158e-25, -3.482802697820206e-27,
  8.443320706081185e-01, -3.557062616358775e-03,  3.073558778915838e-06,  2.834287684539243e-08, -7.062383424172216e-11, -3.698071099313923e-13,  1.694564195719553e-15,
  5.083340521761908e-18, -4.098687626157118e-20, -5.693815744629082e-23,  9.813325347349668e-25,  2.353013556592936e-29,  9.353850711194620e-01, -3.632589359208862e-03,
  1.332088897010332e-06,  3.163483411733856e-08, -3.221831705759841e-11, -4.888758546646609e-13,  8.280639033256837e-16,  9.053126298376773e-18, -2.194052192059402e-20,
 -1.826781779427449e-22,  5.912363778238118e-25,  3.853844609932568e-27,  1.027040988991749e+00, -3.647590643929216e-03, -4.918602879454539e-07,  3.232411766656322e-08,
  1.131159675660241e-11, -5.150077337891493e-13, -2.852985461114582e-16,  9.972388476965763e-18,  7.536505131629923e-21, -2.137370939538310e-22, -2.047517329175405e-25,
  4.876415380720445e-27,  1.118530147888927e+00, -3.601382421917097e-03, -2.291835453873986e-06,  3.031880792055266e-08,  5.331083701122211e-11, -4.413059284054385e-13,
 -1.323149189684533e-15,  7.442058105141308e-18,  3.374174367475445e-20, -1.302472549139845e-22, -8.698057345816684e-25,  2.195799532736313e-27,  1.209081190610757e+00,
 -3.495337926784958e-03, -3.962481075216223e-06,  2.583216135613452e-08,  8.734775759123451e-11, -2.844825307524452e-13, -1.984895829051558e-15,  2.443164244835509e-18,
  4.450965119576933e-20,  1.893549110525993e-23, -9.568443542731125e-25, -2.005276097383817e-27,  1.297927613899034e+00, -3.332858205380242e-03, -5.407273677891227e-06,
  1.935826486772628e-08,  1.083873570002829e-10, -8.069991545598843e-14, -2.091638418502344e-15, -3.077809055715897e-18,  3.552695382792521e-20,  1.470737341194961e-22,
 -4.382812284825924e-25, -4.363898680107348e-27,  1.384314366081072e+00, -3.119273247274420e-03, -6.545682200504825e-06,  1.161138035380661e-08,  1.137034835678070e-10,
  1.237566033064335e-13, -1.643610972800872e-15, -7.046505803711670e-18,  1.235524576536253e-20,  1.845772079994733e-22,  2.891887807344609e-25, -3.241775267088556e-27,
  1.467504448560855e+00, -2.861675817564197e-03, -7.319197935706204e-06,  3.436487698299355e-09,  1.033459611672387e-10,  2.844284001262756e-13, -8.143808585559671e-16,
 -8.136532207008506e-18, -1.292387345269160e-20,  1.210092175822620e-22,  7.214889192410814e-25,  2.587779495680138e-29,  1.546785458545420e+00, -2.568692530837583e-03,
 -7.695752529276442e-06, -4.297442828257995e-09,  8.006673758276076e-11,  3.699403131647720e-13,  1.154025143522106e-16, -6.282374699706767e-18, -2.841308241484280e-20,
  6.507440265799904e-24,  6.229730290630635e-25,  2.572565196548917e-27,  1.621476007429721e+00, -2.250199070582542e-03, -7.672157632672068e-06, -1.080736983109755e-08,
  4.871911733228604e-11,  3.694347644877505e-13,  8.592510364372484e-16, -2.606088015848059e-18, -2.854260581137682e-20, -8.597582007610808e-23,  1.633069536226733e-25,
  2.614109271873977e-27,  1.690931947130599e+00, -1.916988660826571e-03, -7.274347344268618e-06, -1.549454086358606e-08,  1.525318983396864e-11,  2.941573488789330e-13,
  1.222748566956406e-15,  1.180819925683249e-18, -1.622615004468505e-20, -1.092133842867663e-22, -2.692543904464994e-25,  7.542399433545261e-28,  1.754552335537545e+00,
 -1.580404837140374e-03, -6.555373751810791e-06, -1.801789828739921e-08, -1.448456351406049e-11,  1.728767728749511e-13,  1.161891490144845e-15,  3.589674129285587e-18,
 -1.205240370010787e-22, -6.717819756563006e-23, -3.931691812102379e-25, -1.017162449145015e-27,  1.811785072333626e+00, -1.251951147954642e-03, -5.591283566238299e-06,
 -1.833238797095552e-08, -3.589756884711863e-11,  4.263046905393098e-14,  7.818781776413941e-16,  3.981619664769138e-18,  1.096880455171516e-20, -2.788839399455046e-24,
 -2.197368164524141e-25, -1.347345088459056e-27,  1.862132138033354e+00, -9.428915586938160e-04, -4.475175537539453e-06, -1.668676726579499e-08, -4.649242208658588e-11,
 -6.235124402916627e-14,  2.802603345030167e-16,  2.723623952375003e-18,  1.295318591031351e-20,  3.842954895598195e-23,  2.695986146303277e-26, -5.149132846064838e-28,
  1.905154372934295e+00, -6.638559562247978e-04, -3.309889455847273e-06, -1.358109702224407e-08, -4.626266981405735e-11, -1.201943541363362e-13, -1.397965737984953e-16,
  8.412774439272239e-19,  7.787838341273676e-21,  3.940082939604836e-23,  1.417235937253417e-25,  3.124009165003109e-28,  1.940475741740990e+00, -4.244651887778474e-04,
 -2.199894570197553e-06, -9.689756844355719e-09, -3.752791350399920e-11, -1.265845627219596e-13, -3.495137114118381e-16, -6.058517222374813e-19,  9.309323823740839e-22,
  1.570168413700205e-23,  9.646130633509635e-26,  4.366886860863579e-28,  1.967787060267776e+00, -2.329893812916425e-04, -1.243016656906360e-06, -5.760725459470575e-09,
 -2.427136002009587e-11, -9.419958184865199e-14, -3.355621643544982e-16, -1.073556781962446e-18, -2.901797496945324e-21, -5.289751853321858e-24,  4.618014365054566e-27,
  1.129647044915970e-28,  1.986849347501718e+00, -9.605084928206970e-05, -5.226560021443438e-07, -2.505266663061539e-09, -1.112829470415714e-11, -4.677057519043997e-14,
 -1.876939490040662e-16, -7.213955783752096e-19, -2.651836094996742e-21, -9.267623296783514e-24, -3.039516816929557e-26, -9.104293922045350e-29,  1.997499537631815e+00,
 -1.836243353513015e-05, -1.010099015208097e-07, -4.930876228775762e-10, -2.251906562470189e-12, -9.848138781131726e-15, -4.174784876516467e-17, -1.727681776069603e-19,
 -7.010324221878663e-22, -2.796801507266497e-24, -1.099002358561898e-26, -4.257971509222878e-29,  1.006971224134714e-03, -7.189193545890138e-06,  3.847576193343311e-08,
 -1.829207283312127e-10,  8.146106782754900e-13, -3.479223798952704e-15,  1.443026376423557e-17, -5.855106989876489e-20,  2.335055028375374e-22, -9.181830836618314e-25,
  3.567576864760544e-27, -1.371826069781143e-29,  9.051608712744647e-03, -6.437426891754634e-05,  3.418477049411096e-07, -1.604030646495909e-09,  7.002570186233944e-12,
 -2.907349646679284e-14,  1.160208539300351e-16, -4.473079814488269e-19,  1.669185687116850e-21, -6.024885505358790e-24,  2.096743759635110e-26, -6.989282833495680e-29,
  2.508156393471464e-02, -1.770024194806097e-04,  9.252661103469105e-07, -4.226707472319475e-09,  1.769938246550000e-11, -6.909909526675013e-14,  2.522803705157074e-16,
 -8.550515767718856e-19,  2.631667957028856e-21, -6.953460682746971e-24,  1.300940666476815e-26,  4.524495369477826e-30,  4.897845040912059e-02, -3.416367625565089e-04,
  1.743612594032022e-06, -7.639128842030927e-09,  2.989311570024256e-11, -1.047527067655271e-13,  3.198793563281741e-16, -7.757289315519944e-19,  9.189063189466472e-22,
  4.595250162795908e-24, -4.521522691654016e-26,  2.487729843499157e-28,  8.056532489833201e-02, -5.532388971077649e-04,  2.732953080865370e-06, -1.128867470669242e-08,
  3.986774454866127e-11, -1.156577630484423e-13,  2.280878911060776e-16,  9.103511839290279e-20, -3.871018680938835e-21,  2.467162001451879e-23, -1.083442530143759e-25,
  3.549809525541017e-28,  1.196074620311941e-01, -8.053067632314846e-04,  3.814787459659970e-06, -1.455183362317993e-08,  4.399739399057128e-11, -8.676969048057558e-14,
 -5.341989204865369e-17,  1.578527459469449e-18, -9.320888503392572e-21,  3.587765657020451e-23, -8.494672101139445e-26, -3.491162711798394e-29,  1.658134048879254e-01,
 -1.090054350272922e-03,  4.901322608465928e-06, -1.681456612469698e-08,  3.955591608866065e-11, -1.412542611311854e-14, -4.681088083347066e-16,  3.030914541259119e-18,
 -1.119659660229513e-20,  1.970067964872628e-23,  6.759140642645898e-26, -7.830051425226074e-28,  2.188363061218975e-01, -1.398629691445146e-03,  5.901453858255609e-06,
 -1.755378880968364e-08,  2.538439018419388e-11,  9.231694701954962e-14, -8.804254280818940e-16,  3.565557367471131e-18, -6.119192137858846e-21, -2.569677459326954e-23,
  2.645714898436665e-25, -1.134199431630868e-27,  2.782755770162715e-01, -1.721366648315968e-03,  6.727088678417347e-06, -1.641024663939752e-08,  2.280033213059191e-12,
  2.097782872731482e-13, -1.118341923086967e-15,  2.518252648304566e-18,  5.657874367075083e-21, -7.680964490962048e-23,  3.251551769017151e-25, -3.682568642437641e-28,
  3.436788641231711e-01, -2.048065041483383e-03,  7.299413020211159e-06, -1.324370213220579e-08, -2.698341840057240e-11,  3.076862140349819e-13, -1.037410107885545e-15,
 -1.388390923406796e-19,  1.926809286144664e-20, -9.527940526187967e-23,  1.177168097098963e-25,  1.285012492483654e-27,  4.145443746728076e-01, -2.368292738142184e-03,
  7.554688356792742e-06, -8.163076198604976e-09, -5.802845119480455e-11,  3.555169679276559e-13, -5.834699041260434e-16, -3.630647226681091e-18,  2.708985871911201e-20,
 -5.392109727932147e-23, -2.908645868672400e-25,  2.475234660767230e-27,  4.903235726253043e-01, -2.671702385336515e-03,  7.449178459146359e-06, -1.526807735649636e-09,
 -8.559071632457988e-11,  3.314662435669186e-13,  1.706699797564747e-16, -6.590450121424962e-18,  2.282010564902150e-20,  3.872424778477434e-23, -6.264619551874511e-25,
  1.772694858176248e-27,  5.704242669195915e-01, -2.948354610828834e-03,  6.962840963495957e-06,  6.087967849156716e-09, -1.044623672403235e-10,  2.295744682602357e-13,
  1.031880632761990e-15, -7.602401351999629e-18,  5.613726908579055e-21,  1.348606186887084e-22, -5.876834051038337e-25, -8.411107525442406e-28,  6.542141120019583e-01,
 -3.189038742253808e-03,  6.101480295812885e-06,  1.394511099564220e-08, -1.104928231128518e-10,  6.316880205698751e-14,  1.739310741227062e-15, -5.857390993150147e-18,
 -1.826931254329682e-20,  1.722830451384112e-22, -9.905275501700740e-26, -3.509739084296890e-27,  7.410245379482158e-01, -3.385581468851860e-03,  4.897144539968211e-06,
  2.123204484117291e-08, -1.014555556447597e-10, -1.366645175812677e-13,  2.048387727002626e-15, -1.619400172053189e-18, -3.774028656396274e-20,  1.148678947862044e-22,
  5.710306579346682e-25, -3.828402108854777e-27,  8.301551232995049e-01, -3.531133445242890e-03,  3.406656623881358e-06,  2.715598177700822e-08, -7.760252503141649e-11,
 -3.275793988029341e-13,  1.818281390486864e-15,  3.746522874470373e-18, -4.233274483839255e-20, -1.798168250259466e-23,  9.588173124201862e-25, -1.029054862345351e-27,
  9.208784180101822e-01, -3.620423675031504e-03,  1.708295019546092e-06,  3.104228538524493e-08, -4.177700151422998e-11, -4.660457129443967e-13,  1.070767824751544e-15,
  8.250688774167086e-18, -2.805255801644310e-20, -1.558791634603493e-22,  7.424054810238586e-25,  2.988722226766462e-27,  1.012445216593477e+00, -3.649971676586263e-03,
 -1.032258124810493e-07,  3.242242528386766e-08,  9.656983066378377e-13, -5.184840801618116e-13, -3.860878699828110e-18,  1.008928696727748e-17, -2.531745142203153e-22,
 -2.175777691196295e-22,  1.362509108203544e-26,  5.000803425994829e-27,  1.104090272636702e+00, -3.618247983854509e-03, -1.923188570627933e-06,  3.109951996333709e-08,
  4.418465254765285e-11, -4.704435348815541e-13, -1.100406847129334e-15,  8.440264273718577e-18,  2.845270444136314e-20, -1.627970201724580e-22, -7.502077843247436e-25,
  3.220831041930446e-27,  1.195038435401085e+00, -3.525774522153758e-03, -3.644305826349662e-06,  2.718164612849810e-08,  8.118810656824234e-11, -3.311378187585611e-13,
 -1.896498010199916e-15,  3.870837194348681e-18,  4.448369114768701e-20, -2.081984385048722e-23, -1.023597196593684e-24, -1.000418040200357e-27,  1.284511177363331e+00,
 -3.375157857248717e-03, -5.164631484593331e-06,  2.107679616865152e-08,  1.062650692173368e-10, -1.318001538779231e-13, -2.161131329593234e-15, -1.859990579915209e-18,
  4.045988258115661e-20,  1.257182806126958e-22, -6.286125288896475e-25, -4.242795689576728e-27,  1.371733468533876e+00, -3.171050257418086e-03, -6.395355546276906e-06,
  1.344822767911672e-08,  1.157684247420020e-10,  8.199320300766610e-14, -1.834364820558434e-15, -6.542881779920473e-18,  1.917176510344941e-20,  1.930624960686558e-22,
  1.295524237153596e-25, -3.999015309462494e-27,  1.455940939542372e+00, -2.920035914494952e-03, -7.267854801810232e-06,  5.134391421297440e-09,  1.088204003931610e-10,
  2.621068761565264e-13, -1.047299099242536e-15, -8.474836845922706e-18, -8.049955406729573e-21,  1.496522293815415e-22,  7.044798543269175e-25, -8.224326034788412e-28,
  1.536387261263795e+00, -2.630442487192385e-03, -7.739390956197991e-06, -2.957095744093927e-09,  8.747846260230464e-11,  3.704967477495237e-13, -7.316226151690441e-17,
 -7.182816889075527e-18, -2.770340434839805e-20,  3.364262146522235e-23,  7.322759199476519e-25,  2.364709648205239e-27,  1.612351654722660e+00, -2.312081265106322e-03,
 -7.796921651298914e-06, -9.967660631075135e-09,  5.630757690547920e-11,  3.890751246189281e-13,  7.730385141831651e-16, -3.567479790896420e-18, -3.149122432259048e-20,
 -7.701075323404223e-23,  2.881518227003957e-25,  3.053561848297243e-27,  1.683146431804507e+00, -1.975922571144882e-03, -7.458618191596021e-06, -1.520182004773409e-08,
  2.143215565177277e-11,  3.238376907965982e-13,  1.247936745036135e-15,  5.966710673475281e-19, -2.034238330636149e-20, -1.191741847552796e-22, -2.250094400546996e-25,
  1.272659864250870e-27,  1.748124455645664e+00, -1.633716353288164e-03, -6.772859949566088e-06, -1.822044177730442e-08, -1.074004485506464e-11,  2.019655180620664e-13,
  1.261962664184512e-15,  3.544001704620698e-18, -2.832526913155003e-21, -8.376807599941361e-23, -4.353733727161132e-25, -8.861727154239126e-28,  1.806686400252604e+00,
 -1.297571063632416e-03, -5.814686844452236e-06, -1.889887001151808e-08, -3.484807402897878e-11,  6.277287636470150e-14,  8.982496751994664e-16,  4.329198975914387e-18,
  1.069533998143842e-20, -1.282643497867283e-23, -2.836886767400792e-25, -1.559363843849564e-27,  1.858287682820776e+00, -9.795066660290136e-04, -4.679919912339374e-06,
 -1.744022997073143e-08, -4.766575979068678e-11, -5.466173503280854e-14,  3.625340231903310e-16,  3.160421622651468e-18,  1.435006230393001e-20,  3.899504789088947e-23,
 -2.471823066272217e-28, -7.295071272094736e-28,  1.902444940707553e+00, -6.909997318127287e-04, -3.477383732050447e-06, -1.434070459788212e-08, -4.869804881187673e-11,
 -1.232372914565506e-13, -1.125306617807554e-16,  1.114303834458455e-18,  9.311573451426608e-21,  4.533906115764117e-23,  1.550091186766162e-25,  2.877159404050978e-28,
  1.938741931583076e+00, -4.425398566584104e-04, -2.319859369782003e-06, -1.031091845652271e-08, -4.014484240719880e-11, -1.351725418426912e-13, -3.659699908807898e-16,
 -5.662341001507812e-19,  1.570482213587478e-21,  1.996723526567589e-23,  1.173989647894933e-25,  5.166975276006755e-28,  1.966834767148342e+00, -2.432167772566356e-04,
 -1.314539030505231e-06, -6.164587137229046e-09, -2.623837637331426e-11, -1.026244562024030e-13, -3.669500739151670e-16, -1.169415157712514e-18, -3.087603257514504e-21,
 -4.994224934449966e-24,  1.045905032610384e-26,  1.542931801061197e-28,  1.986456586839250e+00, -1.003554497114391e-04, -5.538191989805734e-07, -2.691054467503714e-09,
 -1.211043977778124e-11, -5.152752478541863e-14, -2.091329234609763e-16, -8.118351707841710e-19, -3.008351000511499e-21, -1.056691410283030e-23, -3.465440103125318e-26,
 -1.027156737684044e-28,  1.997424433379667e+00, -1.919480880299365e-05, -1.071498167463412e-07, -5.307499608582407e-10, -2.459294167049586e-12, -1.091076835189913e-14,
 -4.691518336617827e-17, -1.969008228272621e-19, -8.101034193582092e-22, -3.276291229114862e-24, -1.304730725331163e-26, -5.121395624378686e-29,  9.788164661555685e-04,
 -6.889951240152050e-06,  3.635667899700368e-08, -1.704253588196452e-10,  7.483609094113725e-13, -3.151755858400477e-15,  1.289066479755062e-17, -5.158136349181441e-20,
  2.028805600461089e-22, -7.868489498531849e-25,  3.015714910386521e-27, -1.143965906140861e-29,  8.799461925960962e-03, -6.171461927945385e-05,  3.232528741059998e-07,
 -1.496494144049709e-09,  6.447961131239208e-12, -2.643345044897678e-14,  1.042125390600344e-16, -3.972083385758061e-19,  1.466672714618392e-21, -5.244695692394998e-24,
  1.811352277393977e-26, -6.007662389837502e-29,  2.438804394552201e-02, -1.697984612575086e-04,  8.762001997893191e-07, -3.954252206323090e-09,  1.637605680429945e-11,
 -6.332237529562462e-14,  2.294809989234850e-16, -7.747427453976741e-19,  2.390732254666033e-21, -6.431896281131570e-24,  1.300562857663791e-26, -4.165527225833886e-30,
  4.763923185900842e-02, -3.280465656117109e-04,  1.654744981388490e-06, -7.177189624548793e-09,  2.787309103461236e-11, -9.733278347896396e-14,  2.985931167941781e-16,
 -7.440055953637932e-19,  1.054285392811048e-21,  2.991086327244863e-24, -3.533515256900027e-26,  2.017686340850724e-28,  7.839525369979106e-02, -5.319064586843696e-04,
  2.601240918965501e-06, -1.066899798434782e-08,  3.760946788365343e-11, -1.101662719474791e-13,  2.290303915664188e-16, -1.943309874224445e-20, -3.057176310102877e-21,
  2.064007504074901e-23, -9.348672221375418e-26,  3.201781106414804e-28,  1.164461823588982e-01, -7.754751165472577e-04,  3.644331751997385e-06, -1.386181369309195e-08,
  4.225259029717424e-11, -8.755391705685491e-14, -1.320739751442598e-17,  1.300267120128456e-18, -8.090620574345977e-21,  3.247112658384943e-23, -8.487870630534157e-26,
  3.397824805347228e-29,  1.615303458978836e-01, -1.051640134666145e-03,  4.703333959946568e-06, -1.618451381487912e-08,  3.916772916818873e-11, -2.438146475100279e-14,
 -3.881493107828637e-16,  2.684428637786265e-18, -1.044652790682238e-20,  2.176778220430202e-23,  3.701444744809388e-26, -6.112710487943359e-28,  2.133348864533161e-01,
 -1.352253604858171e-03,  5.693302596031597e-06, -1.713398239420449e-08,  2.702739598149037e-11,  7.236185288323908e-14, -7.834562857299864e-16,  3.356888480381056e-18,
 -6.865547429606298e-21, -1.608271619334287e-23,  2.168906637340182e-25, -1.030150196931143e-27,  2.714964979472579e-01, -1.668336701049476e-03,  6.530518398047559e-06,
 -1.634163558989513e-08,  6.213003510333546e-12,  1.838022067837414e-13, -1.045694118847343e-15,  2.657537386367634e-18,  3.122424454874251e-21, -6.418238234306807e-23,
  3.049842803977099e-25, -5.364919402105550e-28,  3.356023782880961e-01, -1.990312315621348e-03,  7.138096876657359e-06, -1.362755992364242e-08, -2.107864067322632e-11,
  2.828082606488118e-13, -1.033174066707970e-15,  4.238707249156908e-19,  1.593526773708366e-20, -8.956528172401988e-23,  1.649924058155710e-25,  8.736448644090197e-28,
  4.051914367632596e-01, -2.308262307405989e-03,  7.451392797467188e-06, -9.035442372729526e-09, -5.106588055280544e-11,  3.403898809613433e-13, -6.732983902962037e-16,
 -2.796867692693559e-18,  2.496476693264784e-20, -6.346139229899056e-23, -1.883197387305925e-25,  2.177861778617833e-27,  4.797558017007888e-01, -2.612205020140299e-03,
  7.422859378357809e-06, -2.843063285889494e-09, -7.893494648797052e-11,  3.334315684234215e-13, -3.463214115907182e-18, -5.842580594980443e-18,  2.378262561884723e-20,
  1.530064815335845e-23, -5.431402611230142e-25,  1.989679554842365e-27,  5.587426769743430e-01, -2.892387717090354e-03,  7.026023871491243e-06,  4.454575506769594e-09,
 -9.964034541960683e-11,  2.518098180798838e-13,  8.222255100119644e-16, -7.349678462411823e-18,  1.003865997328884e-20,  1.108314781791846e-22, -6.085629781068042e-25,
 -1.260834008899032e-28,  6.415565982616769e-01, -3.139587478136798e-03,  6.258263199935631e-06,  1.218954401754781e-08, -1.088256142778025e-10,  1.028838108421339e-13,
  1.568044388947649e-15, -6.343829871645941e-18, -1.217400163440659e-20,  1.654155739430360e-22, -2.396314267209762e-25, -2.866801964431797e-27,  7.275621408098021e-01,
 -3.345412960753336e-03,  5.142107750604069e-06,  1.958954290413409e-08, -1.037015942701390e-10, -8.817982911111199e-14,  1.986788044301971e-15, -2.756849670725633e-18,
 -3.323494876517863e-20,  1.342938952374247e-22,  3.995573680094713e-25, -3.926552072198994e-27,  8.160871294428991e-01, -3.502598295363686e-03,  3.724870131633220e-06,
  2.586433261944752e-08, -8.371002105662186e-11, -2.828352249615299e-13,  1.904173820735538e-15,  2.388814055845812e-18, -4.230322825453542e-20,  1.918440946489716e-23,
  8.928224039168101e-25, -1.943367308771965e-27,  9.064263982796277e-01, -3.605279347456671e-03,  2.076488994859306e-06,  3.030075898541518e-08, -5.082276441664878e-11,
 -4.376814659713915e-13,  1.288418214538988e-15,  7.269192042017905e-18, -3.310058997043962e-20, -1.238407309195145e-22,  8.521971471767775e-25,  1.985035669996614e-27,
  9.978461417107801e-01, -3.649241731654586e-03,  2.855940443623771e-07,  3.235500991033668e-08, -9.382062800408329e-12, -5.151948794196626e-13,  2.773514399119712e-16,
  9.956394808044447e-18, -8.023366473870744e-21, -2.126616091544820e-22,  2.309199539200318e-25,  4.827635539215276e-27,  1.089588889260560e+00, -3.632129421226428e-03,
 -1.546067521426130e-06,  3.172985063899684e-08,  3.453133473934008e-11, -4.939201006128027e-13, -8.522532984638031e-16,  9.251481702849870e-18,  2.208849226215819e-20,
 -1.897015960514815e-22, -5.886897035025104e-25,  4.089025600298120e-27,  1.180879124716984e+00, -3.553602685787351e-03, -3.310558468715372e-06,  2.842524048182690e-08,
  7.411979706701171e-11, -3.751932935236164e-13, -1.768355293741580e-15,  5.274354360622786e-18,  4.298956263213125e-20, -6.231465870454407e-23, -1.042785041260933e-24,
  1.460326627655097e-28,  1.270929554185593e+00, -3.415434537532920e-03, -4.901604642577369e-06,  2.275311611308401e-08,  1.031069493614854e-10, -1.841419602412842e-13,
 -2.194441338685901e-15, -4.980732142874935e-19,  4.448899959413195e-20,  9.693758492518491e-23, -8.074944207276119e-25, -3.840711332934231e-27,  1.358948008480210e+00,
 -3.221535989063135e-03, -6.222816845206211e-06,  1.531118841727444e-08,  1.169535876253402e-10,  3.584581318218372e-14, -2.007926627444771e-15, -5.817537315002960e-18,
  2.617107565565037e-20,  1.945286638498088e-22, -6.083209966113497e-26, -4.627829062519974e-27,  1.444144942721939e+00, -2.977902313845025e-03, -7.195627001135240e-06,
  6.916008111247925e-09,  1.137918365908637e-10,  2.341002143733202e-13, -1.287352709454486e-15, -8.640884452046231e-18, -2.166493311434319e-21,  1.768290571298353e-22,
  6.472712281653612e-25, -1.795185399204866e-27,  1.525741470653451e+00, -2.692475199107384e-03, -7.766234145043826e-06, -1.498326432740304e-09,  9.485403576546905e-11,
  3.662285776212751e-13, -2.864687315980057e-16, -8.044096996807760e-18, -2.594088709852068e-20,  6.490932733663676e-23,  8.280691428352872e-25,  1.953771544867229e-27,
  1.602977843783456e+00, -2.374919172599760e-03, -7.910868094390941e-06, -9.003515381499947e-09,  6.426591852956448e-11,  4.063130279677631e-13,  6.586416462965596e-16,
 -4.617062747170935e-18, -3.402269131958191e-20, -6.268107863237763e-23,  4.310636519806616e-25,  3.427840084698800e-27,  1.675122257182802e+00, -2.036314871665146e-03,
 -7.638763528842680e-06, -1.480545991170347e-08,  2.820937033898883e-11,  3.539110726838086e-13,  1.254873476598160e-15, -1.245468202852036e-19, -2.477959846055120e-20,
 -1.268812541083731e-22, -1.558940963353861e-25,  1.883431012453535e-27,  1.741479836013976e+00, -1.688776417536641e-03, -6.992397575764925e-06, -1.835828889503760e-08,
 -6.389890860721863e-12,  2.334302557044867e-13,  1.359447999205380e-15,  3.401676553558721e-18, -6.170506115047621e-21, -1.019022593358314e-22, -4.696343913472863e-25,
 -6.521843469479106e-28,  1.801401631448418e+00, -1.345005079592560e-03, -6.044773361119634e-06, -1.944518231467623e-08, -3.336702018844181e-11,  8.582364542493115e-14,
  1.024172932569635e-15,  4.661733874935021e-18,  1.001223944889777e-20, -2.560725604661987e-23, -3.568354733947287e-25, -1.762695788977615e-27,  1.854293433571447e+00,
 -1.017796201314212e-03, -4.893813045837015e-06, -1.821112422325155e-08, -4.866454481667673e-11, -4.484583155712703e-14,  4.576652991660782e-16,  3.642015713544665e-18,
  1.574530313672587e-20,  3.826918605573359e-23, -3.797052585978129e-26, -9.938345492278409e-28,  1.899624194798887e+00, -7.195205895779549e-04, -3.654228981366302e-06,
 -1.513972685180268e-08, -5.118709418642116e-11, -1.255283990591262e-13, -7.690452294866453e-17,  1.439610181236485e-18,  1.105832282391915e-20,  5.177963225779245e-23,
  1.666427943873162e-25,  2.358434257534891e-28,  1.936933855086280e+00, -4.616047836887926e-04, -2.447535070329934e-06, -1.097534604614709e-08, -4.293737797149784e-11,
 -1.441396996954111e-13, -3.810061802739245e-16, -5.035252225490715e-19,  2.379542619299837e-21,  2.514368744010805e-23,  1.420800671924628e-25,  6.068155447806866e-28,
  1.965840388621024e+00, -2.540362856757068e-04, -1.391102273328975e-06, -6.601310910886750e-09, -2.838164414315553e-11, -1.118355091392586e-13, -4.011033165369798e-16,
 -1.271000248878075e-18, -3.258096258140967e-21, -4.425354815615869e-24,  1.837255946170145e-26,  2.076290848343498e-28,  1.986046094657131e+00, -1.049185480901366e-04,
 -5.873093679517173e-07, -2.893346546225356e-09, -1.319308116448581e-11, -5.683073104868121e-14, -2.332711972723331e-16, -9.144655339286455e-19, -3.414833279770323e-21,
 -1.204711648427956e-23, -3.944716113744774e-26, -1.152671800439391e-28,  1.997345898443644e+00, -2.007816925445767e-05, -1.137623130452956e-07, -5.719074964963103e-10,
 -2.689231364318498e-12, -1.210593345915379e-14, -5.280980852771878e-17, -2.248165825144499e-19, -9.380136188104569e-22, -3.846199805880362e-24, -1.552476766807242e-26,
 -6.174453028332972e-29,  9.518256969207717e-04, -6.607079355076673e-06,  3.438139031909588e-08, -1.589395339627085e-10,  6.883062485805978e-13, -2.859002990393643e-15,
  1.153317914025770e-17, -4.552007862063784e-20,  1.766093251093044e-22, -6.757084002637160e-25,  2.554974902038176e-27, -9.562641892752837e-30,  8.557664185408051e-03,
 -5.919871347444233e-05,  3.058969326552014e-07, -1.397423913064458e-09,  5.943428949785321e-12, -2.406067760997078e-14,  9.372035845333653e-17, -3.531609345317430e-19,
  1.290291964478094e-21, -4.570447770326447e-24,  1.566023088123827e-26, -5.164921339347108e-29,  2.372257494443381e-02, -1.629743038194894e-04,  8.302804315425899e-07,
 -3.702074857003291e-09,  1.516297140472386e-11, -5.806671036810597e-14,  2.088251538489781e-16, -7.018441584531142e-19,  2.168486147009679e-21, -5.917247661546326e-24,
  1.268395428523589e-26, -1.005989067225632e-29,  4.635298656120843e-02, -3.151456748328519e-04,  1.571231525068087e-06, -6.746411061091239e-09,  2.599643039889541e-11,
 -9.041263210082573e-14,  2.782476198745229e-16, -7.088017479388170e-19,  1.138552563337924e-21,  1.743244030061004e-24, -2.734011169130201e-26,  1.628724888316861e-28,
  7.630845109961484e-02, -5.115985789747144e-04,  2.476751708789463e-06, -1.008457482143644e-08,  3.546101135356337e-11, -1.046864653813668e-13,  2.272233649471840e-16,
 -1.060688387044678e-19, -2.378143105059484e-21,  1.717202025805896e-23, -8.017105571302013e-26,  2.851835368189833e-28,  1.134015537523686e-01, -7.469744700184678e-04,
  3.481988427560724e-06, -1.319978623170966e-08,  4.050114448740401e-11, -8.746220374642211e-14,  1.974656745486490e-17,  1.059419234513820e-18, -6.982270571893180e-21,
  2.912117321552775e-23, -8.227554661415040e-26,  8.120710602869629e-29,  1.573978236670849e-01, -1.014779706251431e-03,  4.512862233070510e-06, -1.556221244373481e-08,
  3.859284020382801e-11, -3.283212178489006e-14, -3.175458002493489e-16,  2.362913840953625e-18, -9.642309078631005e-21,  2.275512561462169e-23,  1.341227152352650e-26,
 -4.657673681517783e-28,  2.080156732081214e-01, -1.307522160283734e-03,  5.490333973049302e-06, -1.669095628438330e-08,  2.829408659118474e-11,  5.466151346538519e-14,
 -6.926147791860051e-16,  3.129515061921362e-18, -7.298981597814731e-21, -8.279884356147782e-24,  1.741006379225506e-25, -9.136282859792350e-28,  2.649264002162514e-01,
 -1.616874991789883e-03,  6.335132181309168e-06, -1.621415728941159e-08,  9.644157947186185e-12,  1.596077192118637e-13, -9.702150726544441e-16,  2.722792082399364e-18,
  1.025438002015422e-21, -5.248944251523614e-23,  2.789225619964514e-25, -6.383324119258747e-28,  3.277542953426360e-01, -1.933866975735069e-03,  6.972724910832766e-06,
 -1.392091107745291e-08, -1.566919057035460e-11,  2.582091935197887e-13, -1.014641929271698e-15,  8.835520977103671e-19,  1.283798915633448e-20, -8.230429447803662e-23,
  1.955100794642840e-25,  5.239826233422981e-28,  3.960769041902791e-01, -2.249098244616908e-03,  7.338286908867996e-06, -9.798937091302881e-09, -4.442556043422150e-11,
  3.233790862251181e-13, -7.407792306885908e-16, -2.035821016921539e-18,  2.256678973140798e-20, -6.917364996884150e-23, -9.970825074309713e-26,  1.846679858619340e-27,
  4.694255016542829e-01, -2.552979575939801e-03,  7.381384766029495e-06, -4.052731963865105e-09, -7.227995118637887e-11,  3.314717055091253e-13, -1.563469394324817e-16,
 -5.076743099892651e-18,  2.396379574286551e-20, -4.641934849997887e-24, -4.534264545950408e-25,  2.067322293905204e-27,  5.472858432867528e-01, -2.835992419295799e-03,
  7.070082782464691e-06,  2.901622462714209e-09, -9.442328137133772e-11,  2.691135568211653e-13,  6.214981498899551e-16, -6.969300153247434e-18,  1.359078665705145e-20,
  8.656246898921268e-23, -6.005504113387780e-25,  4.692141348221105e-28,  6.290992653991823e-01, -3.088965705626499e-03,  6.394164829140329e-06,  1.046677921323942e-08,
 -1.064061996320137e-10,  1.383467585072481e-13,  1.385843869930594e-15, -6.640203139547203e-18, -6.420131827867679e-21,  1.535104698671029e-22, -3.505453977054527e-25,
 -2.170357968061830e-27,  7.142642115189685e-01, -3.303364124862898e-03,  5.367177029120111e-06,  1.791877104564787e-08, -1.049952160203935e-10, -4.153882603031685e-14,
  1.895453833921544e-15, -3.740267094932200e-18, -2.815415373410636e-20,  1.468425702272069e-22,  2.287918764159458e-25, -3.801458208783429e-27,  8.021382671818255e-01,
 -3.471581029146232e-03,  4.027027388562359e-06,  2.448222168919833e-08, -8.890509297997017e-11, -2.364845000399805e-13,  1.952260697201378e-15,  1.052872323436409e-18,
 -4.099247548163172e-20,  5.295816918193021e-23,  7.905625222512485e-25, -2.671009368304241e-27,  8.920407871925048e-01, -3.587227476884117e-03,  2.434935873603278e-06,
  2.941931281644577e-08, -5.925132203246642e-11, -4.044405523677289e-13,  1.476504104340131e-15,  6.145372079129802e-18, -3.692706171965505e-20, -8.831808054344252e-23,
  9.161554513423347e-25,  9.180731636308381e-28,  9.832561986379929e-01, -3.645407271023422e-03,  6.726148857025659e-07,  3.212292156412374e-08, -1.959699463400447e-11,
 -5.052291087681381e-13,  5.514001866723471e-16,  9.579345698948201e-18, -1.546273894528005e-20, -1.992911966436338e-22,  4.342742941964575e-25,  4.371528004860212e-27,
  1.075038058225621e+00, -3.642966293580146e-03, -1.162323648878203e-06,  3.220230286918433e-08,  2.446975974519937e-11, -5.111922737003168e-13, -5.843731312711387e-16,
  9.844865341720604e-18,  1.488066099718815e-20, -2.094431445047409e-22, -3.936952694857413e-25,  4.732475259636809e-27,  1.166613933048172e+00, -3.578703166423911e-03,
 -2.962595035656114e-06,  2.954887335184804e-08,  6.620428170852348e-11, -4.157085471993137e-13, -1.601808512442219e-15,  6.606110602801938e-18,  4.000020914184318e-20,
 -1.035421264144459e-22, -1.009728497341037e-24,  1.361128212341519e-27,  1.257191158798619e+00, -3.453527478508620e-03, -4.618799790998593e-06,  2.437050122938654e-08,
  9.889715886156199e-11, -2.368120390842884e-13, -2.187977998541399e-15,  9.748569247518632e-19,  4.735825192033771e-20,  6.144015818955389e-23, -9.623599323428716e-25,
 -3.152180707363227e-27,  1.345963508065011e+00, -3.270551738198197e-03, -6.027840010079070e-06,  1.718550921532220e-08,  1.171759237743084e-10, -1.419803982205594e-14,
 -2.158045940393964e-15, -4.868891186877864e-18,  3.307990080758233e-20,  1.878795058341016e-22, -2.747675405753973e-25, -5.058140502078072e-27,  1.432118773202123e+00,
 -3.035104065568049e-03, -7.101562044062001e-06,  8.772372497955589e-09,  1.181452638125155e-10,  2.002986346636535e-13, -1.529276422647694e-15, -8.603534470287985e-18,
  4.643577727708517e-21,  2.008346386031408e-22,  5.453498833227965e-25, -2.845586283215259e-27,  1.514847233392235e+00, -2.754650637785250e-03, -7.774867787226584e-06,
  7.748291921392382e-11,  1.020911360346323e-10,  3.565591009054853e-13, -5.229271729891881e-16, -8.830266657084848e-18, -2.298874741234512e-20,  9.958078761803897e-23,
  9.008630185306468e-25,  1.316425211258470e-27,  1.593350934435494e+00, -2.438620182814845e-03, -8.012469927572398e-06, -7.909437925138345e-09,  7.253913737898768e-11,
  4.204441097029588e-13,  5.138079547125317e-16, -5.738264980233045e-18, -3.593169012901299e-20, -4.233545655288315e-23,  5.881152638873336e-25,  3.687515185165934e-27,
  1.666853663819740e+00, -2.098127420459421e-03, -7.813482073576189e-06, -1.429585071182466e-08,  3.558799782052825e-11,  3.838923259861239e-13,  1.239590640219379e-15,
 -9.916072296012922e-19, -2.943780171451604e-20, -1.312615675137807e-22, -5.809290797678429e-26,  2.573465152270737e-27,  1.734611454781439e+00, -1.745598167569813e-03,
 -7.213150578330159e-06, -1.842137364986645e-08, -1.387433399193268e-12,  2.671741378691854e-13,  1.451352914301814e-15,  3.141848521477482e-18, -1.018318113648068e-20,
 -1.211653226441451e-22, -4.908918157854553e-25, -2.911296389553785e-28,  1.795923404292670e+00, -1.394305571710442e-03, -6.281257690318188e-06, -1.996394231376232e-08,
 -3.139398984055739e-11,  1.120053885393737e-13,  1.159027842649345e-15,  4.964465971798091e-18,  8.814264110601733e-21, -4.148637248231808e-23, -4.384041678365616e-25,
 -1.938560805863158e-27,  1.850142544940059e+00, -1.057834140511785e-03, -5.117045900651747e-06, -1.899629976531902e-08, -4.944306207950422e-11, -3.257995179018234e-14,
  5.669001365642544e-16,  4.167524504220111e-18,  1.708430627853694e-20,  3.578602466059920e-23, -8.850951560064738e-26, -1.312684615861246e-27,  1.896686474249496e+00,
 -7.494952425910506e-04, -3.840902798989895e-06, -1.597889073912011e-08, -5.371264008121875e-11, -1.268486428226982e-13, -3.135179475061005e-17,  1.824607031698750e-18,
  1.304466786892138e-20,  5.862974642489963e-23,  1.752151722318947e-25,  1.467094159149963e-28,  1.935047424483197e+00, -4.817237821718147e-04, -2.583457965441736e-06,
 -1.168590790535132e-08, -4.591270727872559e-11, -1.534435511513268e-13, -3.938946428504798e-16, -4.117463081721472e-19,  3.393707604026909e-21,  3.138956303307069e-23,
  1.709395867782636e-25,  7.064521382133290e-28,  1.964801473015294e+00, -2.654898600423291e-04, -1.473118181369309e-06, -7.073846251077139e-09, -3.071756324248972e-11,
 -1.219009677670935e-13, -4.381737804970772e-16, -1.377647517393679e-18, -3.401808800444157e-21, -3.488806511989570e-24,  2.895301196794335e-26,  2.760864479404012e-28,
  1.985616798437971e+00, -1.097595805891724e-04, -6.233345802515290e-07, -3.113841880574378e-09, -1.438782043801882e-11, -6.274926011263897e-14, -2.604735062830838e-16,
 -1.030994020008235e-18, -3.878188696083635e-21, -1.373028673166886e-23, -4.480751736287489e-26, -1.284643473904082e-28,  1.997263721047146e+00, -2.101646964888591e-05,
 -1.208915881974322e-07, -6.169432146280891e-10, -2.944552360110754e-12, -1.345243145320485e-14, -5.954660487195759e-17, -2.571738066981209e-19, -1.088341857660741e-21,
 -4.525127707272384e-24, -1.851533442190187e-26, -7.461935287609808e-29,  9.259356610416601e-04, -6.339474360935730e-06,  3.253835392855776e-08, -1.483694573410214e-10,
  6.337941198270313e-13, -2.596884609533727e-15,  1.033421698493720e-17, -4.023885782735907e-20,  1.540263917051205e-22, -5.814467640687559e-25,  2.169390249297656e-27,
 -8.012490717758956e-30,  8.325659713254722e-03, -5.681703354294207e-05,  2.896829217166615e-07, -1.306059826994358e-09,  5.483930797839610e-12, -2.192553320195660e-14,
  8.438600467609114e-17, -3.143875839453745e-19,  1.136503780928850e-21, -3.987281036142891e-24,  1.355074081719201e-26, -4.441978250986412e-29,  2.308368656677554e-02,
 -1.565057221569035e-04,  7.872737186398106e-07, -3.468492223155897e-09,  1.405020315382482e-11, -5.328307842041007e-14,  1.901136677869853e-16, -6.357639597010437e-19,
  1.964479350824134e-21, -5.419995571936090e-24,  1.215092026995444e-26, -1.387586089935481e-29,  4.511704064340880e-02, -3.028927144372556e-04,  1.492711734376477e-06,
 -6.344578034000481e-09,  2.425337112022743e-11, -8.396867882798288e-14,  2.589192503407249e-16, -6.715616063639427e-19,  1.183260712075903e-21,  7.830804021037604e-25,
 -2.090124168439892e-26,  1.308406019873600e-28,  7.430093179302497e-02, -4.922591367047472e-04,  2.359072931630546e-06, -9.533653332357605e-09,  3.342153299192992e-11,
 -9.927679343912998e-14,  2.232766908939520e-16, -1.728733155258722e-19, -1.814741296527582e-21,  1.420607508690726e-23, -6.837226253354842e-26,  2.514133025220879e-28,
  1.104683798808169e-01, -7.197412687527903e-04,  3.327421487496787e-06, -1.256572647937003e-08,  3.875891589533279e-11, -8.665662299237720e-14,  4.643536771436161e-17,
  8.521328158948282e-19, -5.992192252650002e-21,  2.591165142724964e-23, -7.797902727594475e-26,  1.116853603477097e-28,  1.534097426602620e-01, -9.794133498175373e-04,
  4.329797645866688e-06, -1.495037234231053e-08,  3.786516889161937e-11, -3.969338885197447e-14, -2.555802992088654e-16,  2.067532626279459e-18, -8.818063909321145e-21,
  2.291905395023185e-23, -4.335029978561859e-27, -3.447920852730335e-28,  2.028721723651350e-01, -1.264392881045796e-03,  5.292791961198609e-06, -1.623037891137172e-08,
  2.922804965037177e-11,  3.906365343138838e-14, -6.082939744882160e-16,  2.892445975664326e-18, -7.481071731934344e-21, -2.084546843703697e-24,  1.365405812616020e-25,
 -7.936818846003337e-28,  2.585590341010523e-01, -1.566969356165383e-03,  6.141589446843936e-06, -1.603555272156153e-08,  1.260964803654219e-11,  1.372394531858741e-13,
 -8.937865429492536e-16,  2.727469389407406e-18, -6.702951413999901e-22, -4.191210498239684e-23,  2.495882687029947e-25, -6.874167587148760e-28,  3.201293275387357e-01,
 -1.878757258273000e-03,  6.804335892746846e-06, -1.413161853661065e-08, -1.074628836839943e-11,  2.341984000992614e-13, -9.845854868474711e-16,  1.248509506151133e-18,
  1.002054118312976e-20, -7.411161566104144e-23,  2.120388502295253e-25,  2.376688133754425e-28,  3.871971626637549e-01, -2.190873896908817e-03,  7.216645061629680e-06,
 -1.045898932318995e-08, -3.813997109113016e-11,  3.049956256508417e-13, -7.880512619792407e-16, -1.354144566948224e-18,  2.002342017432236e-20, -7.163689078321544e-23,
 -2.592605447953398e-26,  1.507550089253095e-27,  4.593313504059653e-01, -2.494142186813758e-03,  7.326031089755336e-06, -5.156426361151583e-09, -6.569910765642167e-11,
  3.260999712138466e-13, -2.878090139944125e-16, -4.315897965616419e-18,  2.349212534521422e-20, -2.096293000924402e-23, -3.628855606914803e-25,  2.031751005398954e-27,
  5.360551797443951e-01, -2.779317748298148e-03,  7.096017678081501e-06,  1.434653135133681e-09, -8.890739144822077e-11,  2.817396866753330e-13,  4.328821178766025e-16,
 -6.489121926252116e-18,  1.628096347439433e-20,  6.309959717364086e-23, -5.692140200980762e-25,  9.331698516998491e-28,  6.168464641208343e-01, -3.037338702364813e-03,
  6.509648173609977e-06,  8.788159072903185e-09, -1.033218205909063e-10,  1.693576931571930e-13,  1.197852446766145e-15, -6.760105913736655e-18, -1.167274582708785e-21,
  1.377858428970526e-22, -4.305903641031105e-25, -1.471406427581537e-27,  7.011379512971796e-01, -3.259595213583234e-03,  5.572103230138399e-06,  1.623463567312804e-08,
 -1.053800717596271e-10,  2.598470520063337e-15,  1.778918726035941e-15, -4.555175070583367e-18, -2.274269983633400e-20,  1.527284704776297e-22,  6.777331883047875e-26,
 -3.490493708325545e-27,  7.883182015597177e-01, -3.438214188459813e-03,  4.312131347506857e-06,  2.302445581065565e-08, -9.316461031525822e-11, -1.894227330803658e-13,
  1.963705232963666e-15, -2.225200189329022e-19, -3.854664773229617e-20,  8.206332230036710e-23,  6.609673949339736e-25, -3.182674174337497e-27,  8.777330485798130e-01,
 -3.566352581199817e-03,  2.782018960467556e-06,  2.840856260338708e-08, -6.697253602425183e-11, -3.670758204381391e-13,  1.631604011686816e-15,  4.919967793475003e-18,
 -3.944000698907794e-20, -5.117769493489673e-23,  9.331763737066224e-25, -1.362968747218035e-28,  9.686877642028155e-01, -3.638490544913666e-03,  1.055877757463371e-06,
  3.172934212419854e-08, -2.954783144137426e-11, -4.888392576422920e-13,  8.116420228035592e-16,  8.973464078248450e-18, -2.227989278659997e-20, -1.782636573770231e-22,
  6.119863743717975e-25,  3.669967860306391e-27,  1.060450051614230e+00, -3.650713297952940e-03, -7.738865145868519e-07,  3.251136083973796e-08,  1.412824103711863e-11,
 -5.218626109667440e-13, -3.032031412259964e-16,  1.019778336595679e-17,  7.108646955400695e-21, -2.208968627724406e-22, -1.763100634019390e-25,  5.100052298456808e-27,
  1.152253989148944e+00, -3.600968218348522e-03, -2.601933900069463e-06,  3.053960517893936e-08,  5.752139128423441e-11, -4.517913772007737e-13, -1.399532483397847e-15,
  7.818820507032680e-18,  3.556337899549336e-20, -1.423763641711325e-22, -9.232395809678784e-25,  2.560223561505654e-27,  1.243305037724680e+00, -3.489281571182565e-03,
 -4.317025154133686e-06,  2.591212510669864e-08,  9.363890705120123e-11, -2.888229399934774e-13, -2.139187458064444e-15,  2.518025200723351e-18,  4.884613571426184e-20,
  2.043498716437150e-23, -1.080930822960811e-24, -2.196219015621183e-27,  1.332786206714558e+00, -3.317917722070320e-03, -5.810383618401218e-06,  1.905519409684135e-08,
  1.163636337132843e-10, -6.750130999023685e-14, -2.278555961852148e-15, -3.704676891286191e-18,  3.959141811459924e-20,  1.723674424443833e-22, -5.020560979827451e-25,
 -5.224864288400141e-27,  1.419865444399821e+00, -3.091463061436100e-03, -6.984826114203578e-06,  1.069266880747431e-08,  1.217648130040053e-10,  1.607288287876058e-13,
 -1.766979642943223e-15, -8.335312874837664e-18,  1.223323635624124e-20,  2.198299620544486e-22,  3.966632930854205e-25, -3.908781919588021e-27,  1.503704278756644e+00,
 -2.816817554997618e-03, -7.763904356170046e-06,  1.767223140067926e-09,  1.090763738430017e-10,  3.409623154961016e-13, -7.798844958215788e-16, -9.501494112520417e-18,
 -1.874341253190762e-20,  1.365338347026186e-22,  9.404289656775038e-25,  4.432966120513719e-28,  1.583467681770851e+00, -2.503079221463201e-03, -8.100139916975433e-06,
 -6.680927646182375e-09,  8.105764224651692e-11,  4.307162765791469e-13,  3.368442401853437e-16, -6.907603980432251e-18, -3.699282684616349e-20, -1.552521354518776e-23,
  7.530538249009017e-25,  3.776772722485216e-27,  1.658335066388344e+00, -2.161311203983484e-03, -7.981357259887447e-06, -1.366341495957985e-08,  4.356052842667392e-11,
  4.131984976336599e-13,  1.197925263608098e-15, -2.009437662838156e-18, -3.417579305943235e-20, -1.311044445337747e-22,  7.137134175184867e-26,  3.317305675736925e-27,
  1.727512251695818e+00, -1.804187556967359e-03, -7.434157710273519e-06, -1.839890296302392e-08,  4.311291868553262e-12,  3.030212801264507e-13,  1.534079736703253e-15,
  2.742388850734119e-18, -1.490041791502721e-20, -1.409183269651880e-22, -4.930365809359370e-25,  2.201910927644510e-28,  1.790244152804992e+00, -1.445522261324906e-03,
 -6.523759871342943e-06, -2.044676610049554e-08, -2.886429756792513e-11,  1.415204845240023e-13,  1.301732047231258e-15,  5.219072409001110e-18,  6.984165404116569e-21,
 -6.076951787305732e-23, -5.266524874941926e-25, -2.061523463043243e-27,  1.845827872879688e+00, -1.099695823135829e-03, -5.349767028863284e-06, -1.979182151184746e-08,
 -4.994882891234688e-11, -1.751112038358871e-14,  6.914327091291202e-16,  4.734032493177182e-18,  1.829399436173776e-20,  3.098398903336092e-23, -1.543306831548379e-25,
 -1.688654444567626e-27,  1.893625803558568e+00, -7.810042545623259e-04, -4.037889704281329e-06, -1.685861140166545e-08, -5.625274692794985e-11, -1.269388495203770e-13,
  2.590822414849156e-17,  2.277170297887705e-18,  1.528272130010042e-20,  6.573065664560174e-23,  1.788200930422702e-25,  7.759877299659991e-30,  1.933078287955855e+00,
 -5.029650943209746e-04, -2.728199426908164e-06, -1.244557951380591e-08, -4.907697882745232e-11, -1.630220048298601e-13, -4.037235083917061e-16, -2.836849681873276e-19,
  4.654582331977046e-21,  3.887997603250000e-23,  2.043642334392954e-25,  8.139300846907651e-28,  1.963715394027318e+00, -2.776228943582334e-04, -1.561035564309483e-06,
 -7.585416134324857e-09, -3.326393284411464e-11, -1.328924364515555e-13, -4.782890646070590e-16, -1.488266252736287e-18, -3.503414275623442e-21, -2.063525307787688e-24,
  4.294709863357036e-26,  3.634898693836023e-28,  1.985167544456834e+00, -1.148997327639926e-04, -6.621244557708223e-07, -3.354436619988129e-09, -1.570773203585483e-11,
 -6.936153115409762e-14, -2.911556070958135e-16, -1.163361910248707e-18, -4.406138669828108e-21, -1.563959093164932e-23, -5.075558810460101e-26, -1.418948543649599e-28,
  1.997177672857137e+00, -2.201403751163360e-05, -1.285867207935169e-07, -6.662886112721036e-10, -3.228496441357017e-12, -1.497205161134203e-14, -6.726059615378231e-17,
 -2.947568398721297e-19, -1.265408530975617e-21, -5.335818088698874e-24, -2.213403426657066e-26, -9.039931195576194e-29,  9.010873394628168e-04, -6.086120733034159e-06,
  3.081709336075879e-08, -1.386311504379016e-10,  5.842481764806621e-13, -2.361845457797364e-15,  9.273501527032303e-18, -3.562884451457071e-20,  1.345749361785381e-22,
 -5.013268288393291e-25,  1.845948290757892e-27, -6.729099445565615e-30,  8.102929308057026e-03, -5.456080203818445e-05,  2.745225387403938e-07, -1.221717900887147e-09,
  5.064980433358826e-12, -2.000192270559672e-14,  7.607145111078941e-17, -2.802152333239487e-19,  1.002264541608380e-21, -3.482446732688184e-24,  1.173610558648725e-26,
 -3.822095963159716e-29,  2.247000174272879e-02, -1.503702777884124e-04,  7.469662514382704e-07, -3.251972283967131e-09,  1.302876291226630e-11, -4.892704049410124e-14,
  1.731636922804051e-16, -5.759299749235962e-19,  1.777953863079930e-21, -4.946937663206973e-24,  1.148537383632766e-26, -1.616180874910397e-29,  4.392888013322536e-02,
 -2.912490888611861e-04,  1.418850778660165e-06, -5.969627769996056e-09,  2.263463726520057e-11, -7.797596229968178e-14,  2.406487765748520e-16, -6.333967994555471e-19,
  1.197715562347329e-21,  5.405580675236300e-26, -1.574116543024744e-26,  1.045768807056943e-28,  7.236892849274909e-02, -4.738352269724378e-04,  2.247812974478410e-06,
 -9.014503696575147e-09,  3.148915947663707e-11, -9.398234619144449e-14,  2.176964765378796e-16, -2.232691055134238e-19, -1.349971386048006e-21,  1.168293377339661e-23,
 -5.801550857715677e-26,  2.197450961067935e-28,  1.076417132646999e-01, -6.937146405846392e-04,  3.180296649693038e-06, -1.195938059969864e-08,  3.703875215886245e-11,
 -8.527668466083592e-14,  6.774658386964004e-17,  6.747157661635089e-19, -5.114276984598304e-21,  2.289680622731911e-23, -7.263414574052310e-26,  1.294609196687860e-28,
  1.495602442530959e-01, -9.454823496008998e-04,  4.154001009185683e-06, -1.435119473998229e-08,  3.701448944332614e-11, -4.516375070687942e-14, -2.015162416668875e-16,
  1.798494677116624e-18, -7.999473968632665e-21,  2.247283936073081e-23, -1.725632408807036e-26, -2.459791325970055e-28,  1.978980632990610e-01, -1.222821599156431e-03,
  5.100856593671594e-06, -1.575724609889356e-08,  2.986975226399457e-11,  2.540937502934076e-14, -5.306611590290627e-16,  2.652838857500773e-18, -7.465904780199091e-21,
  2.713452282586853e-24,  1.042118688653269e-25, -6.767012535883607e-28,  2.523882085132845e-01, -1.518602716136518e-03,  5.950460213885789e-06, -1.581297963340714e-08,
  1.514609603405216e-11,  1.167012553348710e-13, -8.179311277289413e-16,  2.683745874559625e-18, -2.006768050708619e-21, -3.253862445057251e-23,  2.190228130411745e-25,
 -6.962330681971088e-28,  3.127220902092453e-01, -1.825003464109509e-03,  6.633875272656912e-06, -1.426735879925067e-08, -6.295612246584544e-12,  2.110216755877305e-13,
 -9.455273424930642e-16,  1.528131617666807e-18,  7.507060484704121e-21, -6.549154167254750e-23,  2.173232958438433e-25,  1.219840752367627e-29,  3.785483244708976e-01,
 -2.133652685117267e-03,  7.087673688756174e-06, -1.102146879876500e-08, -3.223189801119447e-11,  2.856974204947953e-13, -8.173852208681079e-16, -7.547342494661947e-19,
  1.744091896408667e-20, -7.144505678506193e-23,  3.313127515474738e-26,  1.180104867731970e-27,  4.494715816894771e-01, -2.435798823682508e-03,  7.258060760754734e-06,
 -6.155850960138735e-09, -5.925553514120670e-11,  3.178265675155052e-13, -3.982621049807648e-16, -3.578852933360739e-18,  2.249745952670794e-20, -3.372086692179440e-23,
 -2.758998168496932e-25,  1.910172635307173e-27,  5.250515204961090e-01, -2.722504494724094e-03,  7.104886016621619e-06,  5.771700820009047e-11, -8.318311073482709e-11,
  2.900093284503580e-13,  2.587912388772088e-16, -5.936093151476000e-18,  1.815360267747894e-20,  4.125938294728766e-23, -5.203781011008327e-25,  1.265378419693670e-27,
  6.048018922584498e-01, -2.984867521623353e-03,  6.605303847613327e-06,  7.163604799304481e-09, -9.966251686776725e-11,  1.958349969748874e-13,  1.008767864736106e-15,
 -6.721532914240512e-18,  3.469199050969155e-21,  1.194655636986499e-22, -4.806171729790922e-25, -8.119870359180411e-28,  6.881899174848151e-01, -3.214267769809739e-03,
  5.756811478561602e-06,  1.455124521064813e-08, -1.049118964045249e-10,  4.368483527878792e-14,  1.642013686807084e-15, -5.194739795894938e-18, -1.723157538897830e-20,
  1.524920803309761e-22, -7.629929754778950e-26, -3.039070590760460e-27,  7.746360526321985e-01, -3.402637575881471e-03,  4.579364278586432e-06,  2.150607049055666e-08,
 -9.648298853017622e-11, -1.425050536089866e-13,  1.940684662585408e-15, -1.403921847229538e-18, -3.515116465021811e-20,  1.056007869583464e-22,  5.138245031317321e-25,
 -3.468576579580298e-27,  8.635142831737489e-01, -3.542751578951162e-03,  3.116257091862826e-06,  2.728044176036702e-08, -7.391205232600964e-11, -3.264082754744693e-13,
  1.751468219722261e-15,  3.635583852101220e-18, -4.061465511563858e-20, -1.426484877601324e-23,  9.053780205232228e-25, -1.108544743927511e-27,  9.541530951804523e-01,
 -3.628529287183613e-03,  1.433474295367509e-06,  3.117950482482707e-08, -3.910991158226075e-11, -4.664310825560682e-13,  1.051988302971414e-15,  8.162853261338432e-18,
 -2.822009872373133e-20, -1.508052915709022e-22,  7.544365105306721e-25,  2.779263115015081e-27,  1.045837291478395e+00, -3.655340797184132e-03, -3.827393172518959e-07,
  3.265361675254549e-08,  3.641450159996777e-12, -5.256947119287686e-13, -1.568317403938950e-17,  1.029710418323532e-17, -9.160885490687905e-22, -2.234201600210256e-22,
  5.060257581663448e-26,  5.162789342032316e-27,  1.137810827511492e+00, -3.620302840883064e-03, -2.230240469477728e-06,  3.138591251445063e-08,  4.816805263088512e-11,
 -4.826294209339910e-13, -1.165493096180662e-15,  8.867952880193962e-18,  2.980329242874448e-20, -1.767202807892276e-22, -7.859764130920364e-25,  3.654495282461007e-27,
  1.229280843714862e+00, -3.522548977629921e-03, -3.997289903683018e-06,  2.736137360374920e-08,  8.735566876307356e-11, -3.391403778091252e-13, -2.046749582578944e-15,
  4.084357928581531e-18,  4.878324033537242e-20, -2.440213043270909e-23, -1.152332884127927e-24, -1.017621457404844e-27,  1.319423062406979e+00, -3.363454612862815e-03,
 -5.570604645896009e-06,  2.090320816879637e-08,  1.144591155500519e-10, -1.232826780081018e-13, -2.363647341635797e-15, -2.342792698296576e-18,  4.537989699264728e-20,
  1.477069102869786e-22, -7.298874184679817e-25, -5.075636551005733e-27,  1.407388694639534e+00, -3.146795073270264e-03, -6.844726263856432e-06,  1.266423982501106e-08,
  1.245366699918008e-10,  1.155723008541029e-13, -1.993678399222283e-15, -7.814519562282759e-18,  2.038851140275544e-20,  2.319558513413604e-22,  2.023700655046104e-25,
 -4.904266437575632e-27,  1.492312962935654e+00, -2.878813783160853e-03, -7.732004855660329e-06,  3.565890509774459e-09,  1.156865684283538e-10,  3.189896112349553e-13,
 -1.053532565149919e-15, -1.001535968403311e-17, -1.314916021188133e-20,  1.742331989338411e-22,  9.365306297074645e-25, -6.557541262333818e-28,  1.573325286888301e+00,
 -2.568178320441117e-03, -8.172244004985505e-06, -5.314719692600907e-09,  8.973645121934744e-11,  4.363455167951686e-13,  1.268178460852342e-16, -8.094179345695613e-18,
 -3.696965996573024e-20,  1.789797396000591e-23,  9.170948543055516e-25,  3.637105541771752e-27,  1.649561099004666e+00, -2.225805419410570e-03, -8.140858715371776e-06,
 -1.289879405937431e-08,  5.210678594983122e-11,  4.411456191950110e-13,  1.125646364175413e-15, -3.177729325427446e-18, -3.880695235436063e-20, -1.251067259798364e-22,
  2.340371609973400e-25,  4.074650182123850e-27,  1.720175158907275e+00, -1.864542319605848e-03, -7.654324118944938e-06, -1.827941337151210e-08,  1.074581750182148e-11,
  3.407019336306987e-13,  1.603401614003678e-15,  2.180630213894949e-18, -2.032444350576261e-20, -1.602584195859892e-22, -4.690093780971269e-25,  9.012110261311416e-28,
  1.784356118861439e+00, -1.498701409769576e-03, -6.771792998286613e-06, -2.088420401288763e-08, -2.570951393140021e-11,  1.745387455144051e-13,  1.450636075312483e-15,
  5.403318039780459e-18,  4.395232024063402e-21, -8.366819860307113e-23, -6.185568278326730e-25, -2.098670331704196e-27,  1.841341969928463e+00, -1.143457573411225e-03,
 -5.592072485274182e-06, -2.059285665457868e-08, -5.012202459950716e-11,  7.410349591045081e-16,  8.323396418772415e-16,  5.335943026475623e-18,  1.927927846496216e-20,
  2.320152337036239e-23, -2.379396034327903e-25, -2.120633089499199e-27,  1.890435877195556e+00, -8.141320789068126e-04, -4.245676913321505e-06, -1.777890908273209e-08,
 -5.877984626091858e-11, -1.254944248215061e-13,  9.688121657418535e-17,  2.805456217369422e-18,  1.777736820661390e-20,  7.283553087109000e-23,  1.749394999510740e-25,
 -1.962979879374839e-28,  1.931021811347118e+00, -5.254016777170554e-04, -2.882367077505535e-06, -1.325742353201461e-08, -5.243486327947477e-11, -1.727885047305637e-13,
 -4.093593526344336e-16, -1.106937667987836e-19,  6.210332865676521e-21,  4.780360168089607e-23,  2.426336232929253e-25,  9.259577932889183e-28,  1.962579336344372e+00,
 -2.904845327567286e-04, -1.655343664038599e-06, -8.139539935572359e-09, -3.604001205383558e-11, -1.448841557887547e-13, -5.215386632423733e-16, -1.601199457826712e-18,
 -3.542647800116388e-21,  5.012620032361621e-27,  6.128763896916555e-26,  4.744952745557201e-28,  1.984697090423357e+00, -1.203621218234029e-04, -7.039326769041968e-07,
 -3.617249213111686e-09, -1.716756311100006e-11, -7.675662247466987e-14, -3.257911976406144e-16, -1.313771030762085e-18, -5.007248088418764e-21, -1.779856712586727e-23,
 -5.728795466201826e-26, -1.548852615369619e-28,  1.997087507411142e+00, -2.307561462397889e-05, -1.369022933204467e-07, -7.204306811511506e-10, -3.544772949197704e-12,
 -1.669010373278538e-14, -7.611083301890960e-17, -3.385023178388819e-19, -1.474441911499072e-21, -6.306148445130911e-24, -2.652359917363758e-26, -1.097884606551369e-28,
  8.772256137721356e-04, -5.846082878954227e-06,  2.920808682755623e-08, -1.296493128818343e-10,  5.391585474533899e-13, -2.150782270545135e-15,  8.333568616167400e-18,
 -3.159751931236544e-20,  1.177879095154617e-22, -4.330826087395781e-25,  1.574015796916649e-27, -5.663982321389102e-30,  7.888987515628295e-03, -5.242191628425552e-05,
  2.603352749730036e-07, -1.143781928312105e-09,  4.682581849655861e-12, -1.826684868922444e-14,  6.865621947863394e-17, -2.500612456641024e-19,  8.849560529480711e-22,
 -3.045013195111834e-24,  1.017426033481475e-26, -3.290695768369296e-29,  2.188022984851510e-02, -1.445471715518415e-04,  7.091617701597669e-07, -3.051119967658536e-09,
  1.209050771889300e-11, -4.495835668959252e-14,  1.578080274547613e-16, -5.217976374383543e-19,  1.607958298168800e-21, -4.502159269199997e-24,  1.074503629599795e-26,
 -1.733516084889670e-29,  4.278614023649761e-02, -2.801787846578352e-04,  1.349337706674608e-06, -5.619641873753002e-09,  2.113145955705552e-11, -7.240888437825002e-14,
  2.234497190568339e-16, -5.951516901101066e-19,  1.189375892201135e-21, -4.901957821924657e-25, -1.162752470350640e-26,  8.312996188093019e-29,  7.050887939597665e-02,
 -4.562769953224027e-04,  2.142600774622155e-06, -8.525432652656438e-09,  2.966122969685985e-11, -8.883715760365435e-14,  2.109002962048659e-16, -2.601683154806970e-19,
 -9.689068392889757e-22,  9.546932530892040e-24, -4.899634994360282e-26,  1.906688067452215e-28,  1.049168445885775e-01, -6.688363721313330e-04,  3.040283823024263e-06,
 -1.138031039301810e-08,  3.535091548543318e-11, -8.344181350478581e-14,  8.446741446779942e-17,  5.236980634129343e-19, -4.340886933588101e-21,  2.010841080273055e-23,
 -6.672511055472421e-26,  1.378109315515319e-28,  1.458437023010453e-01, -9.129292012070280e-04,  3.985309449562837e-06, -1.376643527540305e-08,  3.606678317616960e-11,
 -4.942403011582289e-14, -1.546215970232751e-16,  1.555302979228430e-18, -7.205257669601392e-21,  2.159079269164076e-23, -2.626861477651939e-26, -1.666594048850105e-28,
  1.930872045726230e-01, -1.182762935397285e-03,  4.914651733216493e-06, -1.527593177406517e-08,  3.025645868534968e-11,  1.353798197531815e-14, -4.597063028932623e-16,
  2.416241112226165e-18, -7.300062686771296e-21,  6.319370301060007e-24,  7.688387546006717e-26, -5.669228286609415e-28,  2.464078092671037e-01, -1.471753767127050e-03,
  5.762232120857856e-06, -1.555301107277054e-08,  1.728986252562703e-11,  9.796436701723238e-14, -7.438496653811979e-16,  2.602418202731076e-18, -3.027809610151750e-21,
 -2.438614847025616e-23,  1.887515718967403e-25, -6.757037941131594e-28,  3.055271320332730e-01, -1.772618694740596e-03,  6.462197909554351e-06, -1.433554308587497e-08,
 -2.298508228739645e-12,  1.888674985589795e-13, -8.997189830675576e-16,  1.732309915005634e-18,  5.305470205247441e-21, -5.684169240291812e-23,  2.139326938593612e-25,
 -1.576794297666354e-28,  3.701262670645474e-01, -2.077488665881794e-03,  6.952506891657309e-06, -1.149253953075315e-08, -2.671551789948066e-11,  2.658872858583147e-13,
 -8.310885240519300e-16, -2.374253498666998e-19,  1.490443211798031e-20, -6.917240170818293e-23,  7.830102516235365e-26,  8.781188335309620e-28,  4.398440254005956e-01,
 -2.378045456389068e-03,  7.178710011532303e-06, -7.053639227546471e-09, -5.300228812629860e-11,  3.071459393999297e-13, -4.885878701602158e-16, -2.880325912889775e-18,
  2.110466801504435e-20, -4.312582647230408e-23, -1.956731074687066e-25,  1.728630440317224e-27,  5.142751537212610e-01, -2.665684819249899e-03,  7.097785389849346e-06,
 -1.226529121647323e-09, -7.733393276337773e-11,  2.942926659137588e-13,  1.009087511935216e-16, -5.335316521227497e-18,  1.927833886896276e-20,  2.162777235749721e-23,
 -4.596835985724485e-25,  1.474146515378449e-27,  5.929686135999094e-01, -2.931708040117787e-03,  6.681832841530345e-06,  5.601589848508252e-09, -9.551887586981421e-11,
  2.178033750120842e-13,  8.227388874156160e-16, -6.545475791731542e-18,  7.416946463645842e-21,  9.970550964704744e-23, -5.030976665086000e-25, -2.235912438132630e-28,
  6.754260211024643e-01, -3.167543274184720e-03,  5.921390509208728e-06,  1.288173511743237e-08, -1.036561986795525e-10,  8.129046694348088e-14,  1.489660844373082e-15,
 -5.659156188903853e-18, -1.182762139349760e-20,  1.469206492159109e-22, -1.983084570387643e-25, -2.495594495451031e-27,  7.611003693040588e-01, -3.364996813883797e-03,
  4.828088859767955e-06,  1.994205691248566e-08, -9.887115088432128e-11, -9.652379897328492e-14,  1.886225180226926e-15, -2.464267265504298e-18, -3.101671207997324e-20,
  1.230661305838817e-22,  3.589477724095550e-25, -3.536900962406124e-27,  8.493951812675260e-01, -3.516532646231047e-03,  3.436318892903758e-06,  2.604793947852066e-08,
 -8.001238007720280e-11, -2.832985718860425e-13,  1.835041203245159e-15,  2.334576857389499e-18, -4.049043134249771e-20,  2.071790696091933e-23,  8.376904874227748e-25,
 -1.941192468780844e-27,  9.396642673215646e-01, -3.615576214169697e-03,  1.803570608614295e-06,  3.048056487137145e-08, -4.816809057723429e-11, -4.385474910182076e-13,
  1.267132256564475e-15,  7.178992398351041e-18, -3.307906362879560e-20, -1.184733620111651e-22,  8.547902970024865e-25,  1.768615818182915e-27,  1.031212286480705e+00,
 -3.656835146346302e-03,  9.106905735944389e-09,  3.262784622421970e-08, -6.852902778834335e-12, -5.226220006000525e-13,  2.710215320493752e-16,  1.013993173067058e-17,
 -8.868453632465037e-21, -2.169031832327338e-22,  2.734529642656869e-25,  4.916919651255190e-27,  1.123296335147224e+00, -3.636625882171913e-03, -1.849308609540260e-06,
  3.207794713064352e-08,  3.825638964101705e-11, -5.075199416201210e-13, -9.048363041103862e-16,  9.714131362941241e-18,  2.291681405144425e-20, -2.046606211557017e-22,
 -6.044407710027492e-25,  4.559500825067882e-27,  1.215128803473625e+00, -3.553190722812051e-03, -3.660799640503215e-06,  2.870217492525089e-08,  8.009181168345058e-11,
 -3.867147548448968e-13, -1.910728553135614e-15,  5.622405192617991e-18,  4.706777105057562e-20, -7.100719578293951e-23, -1.168207110731374e-24,  3.145853064463724e-28,
  1.305881746604911e+00, -3.406985170671469e-03, -5.308869477092201e-06,  2.271172730269087e-08,  1.114217413151054e-10, -1.806285976749236e-13, -2.408158624255096e-15,
 -8.116216558343575e-19,  5.011905640662185e-20,  1.141653643716152e-22, -9.435698645855787e-25, -4.578524241358381e-27,  1.394693009240426e+00, -3.200910967479437e-03,
 -6.680732209077765e-06,  1.467264538782950e-08,  1.263523237940535e-10,  6.517982644581195e-14, -2.202086933408094e-15, -7.027356295613263e-18,  2.883022274932486e-20,
  2.354739178616912e-22, -3.257077342952460e-26, -5.740830225623215e-27,  1.480674311784072e+00, -2.940466717052947e-03, -7.677902438363774e-06,  5.466444011052232e-09,
  1.217905777999450e-10,  2.902981738401272e-13, -1.338859396882082e-15, -1.032862267571095e-17, -6.212742879497513e-21,  2.107495544212286e-22,  8.798752799125123e-25,
 -1.947039320477705e-27,  1.562921449117869e+00, -2.633786306784225e-03, -8.227117634573760e-06, -3.809035271447960e-09,  9.847475282349630e-11,  4.365366746830706e-13,
 -1.162324570469769e-16, -9.259511949894699e-18, -3.562735108319887e-20,  5.767992299428364e-23,  1.068917501881814e-24,  3.212779607216816e-27,  1.640526664184108e+00,
 -2.291536578285427e-03, -8.290346170645646e-06, -1.199306717144606e-08,  6.119190375106266e-11,  4.669490009118472e-13,  1.018622327294183e-15, -4.489442834607671e-18,
 -4.309710879887403e-20, -1.119439676781614e-22,  4.293094618528725e-25,  4.788628127060522e-27,  1.712593136033923e+00, -1.926650869988468e-03, -7.872413791490237e-06,
 -1.805085777854882e-08,  1.794921532197494e-11,  3.798373128238964e-13,  1.654461294844231e-15,  1.434410121015860e-18, -2.641971062100553e-20, -1.779852154649132e-22,
 -4.110487105476705e-25,  1.763684310214703e-27,  1.778251367827999e+00, -1.553884910691180e-03, -7.024750095561657e-06, -2.126568671889575e-08, -2.185826194604319e-11,
  2.111824610163763e-13,  1.603410143945134e-15,  5.490817440437958e-18,  9.156853969924215e-22, -1.102417096885928e-22, -7.094730297368436e-25, -2.009247589794314e-27,
  1.836677082181772e+00, -1.189196235168251e-03, -5.843994332766920e-06, -2.139355305007171e-08, -4.989497715547636e-11,  2.258047852389518e-14,  9.904945364128430e-16,
  5.964216388977021e-18,  1.991947496914307e-20,  1.167934489270273e-23, -3.416754987614525e-25, -2.601796027831316e-27,  1.887110044030475e+00, -8.489670597608833e-04,
 -4.464749028821192e-06, -1.873931150180603e-08, -6.125977781177910e-11, -1.221598887864492e-13,  1.838019462058857e-16,  3.417614369681868e-18,  2.052262493795538e-20,
  7.958251965337853e-23,  1.603198132661083e-25, -4.836039647705202e-28,  1.928873058713193e+00, -5.491114990595862e-04, -3.046605678172546e-06, -1.412456193858648e-08,
 -5.598900761535663e-11, -1.826262066181719e-13, -4.094040100348665e-16,  1.175265617016585e-19,  8.116078397784887e-21,  5.835677739962448e-23,  2.858343332191181e-25,
  1.036917477890410e-27,  1.961390279974313e+00, -3.041280075882305e-04, -1.756575853149621e-06, -8.740057153489629e-09, -3.906656210846813e-11, -1.579518788032111e-13,
 -5.679557061674080e-16, -1.714045035433108e-18, -3.492958174947067e-21,  2.913012500766672e-24,  8.513280726545623e-26,  6.147089170950204e-28,  1.984204097352574e+00,
 -1.261720002716452e-04, -7.490398240078979e-07, -3.904648954797172e-09, -1.878396122711261e-11, -8.503575269098103e-14, -3.649195908837029e-16, -1.484710751753117e-18,
 -5.690918703426535e-21, -2.022992303623161e-23, -6.436378785794070e-26, -1.663863312861629e-28,  1.996992958367749e+00, -2.420640385164667e-05, -1.458991057000490e-07,
 -7.799200346853695e-10, -3.897637818992106e-12, -1.863604941558264e-14, -8.628509327609508e-17, -3.895314040073818e-19, -1.721784547916997e-21, -7.470375495951034e-24,
 -3.186158147660491e-26, -1.336726841043592e-28,  8.542989611116463e-04, -5.618497900277187e-06,  2.770266917436267e-08, -1.213563276382870e-10,  4.980734369690236e-13,
 -1.960981452546627e-15,  7.499347107931265e-18, -2.806608130249856e-20,  1.032726699087520e-22, -3.748336595871592e-25,  1.344881472950519e-27, -4.777921166489653e-30,
  7.683380049687518e-03, -5.039288915031137e-05,  2.470476472057832e-07, -1.071696111079196e-09,  4.333171347883725e-12, -1.670001854889428e-14,  6.203502930404336e-17,
 -2.234207820669207e-19,  7.823248666353529e-22, -2.665608950432155e-24,  8.829118427455190e-27, -2.835147121013963e-29,  2.131316041982572e-02, -1.390171095549080e-04,
  6.736800000292625e-07, -2.864664264354052e-09,  1.122806049934776e-11, -4.134062049090594e-14,  1.438942759505748e-16, -4.728547664357884e-19,  1.453431623599398e-21,
 -4.087772502565022e-24,  9.971583748385112e-27, -1.771213987477255e-29,  4.168659538011446e-02, -2.696481862536330e-04,  1.283883762999637e-06, -5.292838152614004e-09,
  1.973558214475849e-11, -6.724178064965751e-14,  2.073150590319508e-16, -5.574569527814494e-19,  1.164188884035752e-21, -8.875426020368695e-25, -8.366802179453997e-27,
  6.568382475429839e-29,  6.871741630831738e-02, -4.395374752965465e-04,  2.043085312249386e-06, -8.064794444635196e-09,  2.793449574684422e-11, -8.386616617265290e-14,
  2.032305770311140e-16, -2.860366224024088e-19, -6.585454346195051e-22,  7.746928859311403e-24, -4.119514944085858e-26,  1.644015740831960e-28,  1.022892921460952e-01,
 -6.450508670893060e-04,  2.907059084349044e-06, -1.082793157831093e-08,  3.370346079182296e-11, -8.125367889102452e-14,  9.729146607051077e-17,  3.958689293741987e-19,
 -3.663556182331505e-21,  1.756154973828755e-23, -6.060700716664632e-26,  1.393447282895358e-28,  1.422547179473656e-01, -8.816977807015629e-04,  3.823541403809475e-06,
 -1.319746186910244e-08,  3.504458918605444e-11, -5.263771024227907e-14, -1.141857426857555e-16,  1.336955084789390e-18, -6.448489867509237e-21,  2.041292411160279e-23,
 -3.216954988457970e-26, -1.041099727989430e-28,  1.884336379287918e-01, -1.144170719704562e-03,  4.734252226944479e-06, -1.479023928440894e-08,  3.042223338893968e-11,
  3.290720946660723e-15, -3.952838213359518e-16,  2.186825637820140e-18, -7.022944241125642e-21,  8.926039417967063e-24,  5.417822977586132e-26, -4.668992431831202e-28,
  2.406118147115261e-01, -1.426397609122964e-03,  5.577317396446576e-06, -1.526164438544565e-08,  1.907646838993350e-11,  8.097467849208238e-14, -6.724603371601368e-16,
  2.492881503464332e-18, -3.776878982631604e-21, -1.741991653478934e-23,  1.598572130012050e-25, -6.350184201382441e-28,  2.985389624059518e-01, -1.721609563187147e-03,
  6.290071633710000e-06, -1.434325683821403e-08,  1.266929404303932e-12,  1.678736515613506e-13, -8.491333976365532e-16,  1.870979741443072e-18,  3.411168299442223e-21,
 -4.846207938868223e-23,  2.041666715087795e-25, -2.788003631115706e-28,  3.619266693434832e-01, -2.022427122166574e-03,  6.812203698755052e-06, -1.187853091075052e-08,
 -2.159750305438228e-11,  2.459130032308278e-13, -8.314288861830930e-16,  2.003483029151190e-19,  1.247916699990221e-20, -6.534913979295738e-23,  1.109104020430108e-25,
  6.102231894860338e-28,  4.304461471159108e-01, -2.320968305010216e-03,  7.089178702007474e-06, -7.853195672436451e-09, -4.698277487476182e-11,  2.945268705600931e-13,
 -5.600254276510397e-16, -2.231182522385058e-18,  1.942902071720919e-20, -4.949383452207750e-23, -1.243185887651496e-25,  1.510460495502452e-27,  5.037258566885935e-01,
 -2.608981996425950e-03,  7.075837506496892e-06, -2.416703164352303e-09, -7.143559896802237e-11,  2.949921158003540e-13, -3.975092054737138e-17, -4.709371626705587e-18,
  1.974194566617854e-20,  4.574362032646647e-24, -3.922627842380480e-25,  1.573859508351837e-27,  5.813490802513663e-01, -2.878010144482942e-03,  6.740029164096088e-06,
  4.109147436798310e-09, -9.098004400050574e-11,  2.353798255641381e-13,  6.433002074779142e-16, -6.254596975523945e-18,  1.064315223512116e-20,  7.953818489528766e-23,
 -5.016494267160193e-25,  2.731524360634200e-28,  6.628515296402356e-01, -3.119581885399921e-03,  6.066080130657428e-06,  1.123813034839682e-08, -1.016859062160521e-10,
  1.151029093539355e-13,  1.326688722533880e-15, -5.954749280665769e-18, -6.706165880989998e-21,  1.369636630426252e-22, -2.952491900970766e-25, -1.907022735470965e-27,
  7.477191089266279e-01, -3.325441908087450e-03,  5.057846105099006e-06,  1.834710890382747e-08, -1.003550837108962e-10, -5.219035965325783e-14,  1.804014242569751e-15,
 -3.383448101760953e-18, -2.636519894430575e-20,  1.343356307364716e-22,  2.054503012683335e-25, -3.410710831759000e-27,  8.353859801555098e-01, -3.487813972327909e-03,
  3.741033806724857e-06,  2.472482612160031e-08, -8.523339973852279e-11, -2.386186625855529e-13,  1.882426843917715e-15,  1.057103877479238e-18, -3.916393405994147e-20,
  5.231131367034350e-23,  7.372314517833496e-25, -2.592772265586132e-27,  9.252331167560838e-01, -3.599698339434236e-03,  2.164429342852005e-06,  2.964142630792568e-08,
 -5.661928073564802e-11, -4.058474908506340e-13,  1.452731283647141e-15,  6.058954375587205e-18, -3.671272129426511e-20, -8.303535172425849e-23,  9.094139725286714e-25,
  7.131076360988928e-28,  1.016587567646749e+00, -3.655198810083962e-03,  3.996396582053975e-07,  3.243502953536644e-08, -1.721749630060235e-11, -5.127496643532208e-13,
  5.498101371092718e-16,  9.733731378930975e-18, -1.642915712567328e-20, -2.017754029809043e-22,  4.790506000191615e-25,  4.384168551275820e-27,  1.108722694269060e+00,
 -3.649870982479190e-03, -1.461039159677506e-06,  3.260776014836213e-08,  2.791126055033608e-11, -5.258961622830420e-13, -6.237124477651793e-16,  1.032532401775396e-17,
  1.516413711801596e-20, -2.246152983843685e-22, -3.885948446580378e-25,  5.203747252642595e-27,  1.200859679113650e+00, -3.581078234282948e-03, -3.308947876585395e-06,
  2.991933451530961e-08,  7.191256175738337e-11, -4.305155982112725e-13, -1.732663158309452e-15,  7.078706719863746e-18,  4.367746626724794e-20, -1.170488119534441e-22,
 -1.123686119563038e-24,  1.711714485783414e-27,  1.292170632500105e+00, -3.448335951846385e-03, -5.025761662392177e-06,  2.446242992916750e-08,  1.072303222946949e-10,
 -2.385123513829669e-13, -2.407866983619274e-15,  8.502819739077077e-19,  5.350309239968257e-20,  7.261848332693100e-23, -1.127581212994802e-24, -3.728651222356993e-27,
  1.381783637402229e+00, -3.253618090248290e-03, -6.492497102331327e-06,  1.670177489467674e-08,  1.271120533598235e-10,  1.008060977095831e-14, -2.384667298694887e-15,
 -5.969913674265061e-18,  3.722116135758654e-20,  2.289259707355954e-22, -2.990846161347363e-25, -6.324037459780099e-27,  1.468790061261045e+00, -3.001593990789252e-03,
 -7.600427542750130e-06,  7.459696450475891e-09,  1.272517042198632e-10,  2.546799144432616e-13, -1.629656226458588e-15, -1.039943814075728e-17,  1.983368074071576e-21,
  2.438192658776532e-22,  7.632359532404540e-25, -3.370031684800008e-27,  1.552254419209238e+00, -2.699758634317013e-03, -8.263085104699069e-06, -2.163835366252324e-09,
  1.071559333882343e-10,  4.305092915336859e-13, -3.910873014276873e-16, -1.035784631080579e-17, -3.274893395261878e-20,  1.030669249822369e-22,  1.194938613425780e-24,
  2.458006118504554e-27,  1.631226985303186e+00, -2.358417652508490e-03, -8.428076188571895e-06, -1.093800217743217e-08,  7.076435033620611e-11,  4.897280500343320e-13,
  8.730306548860904e-16, -5.929292251187229e-18, -4.676548881458304e-20, -9.037059024961218e-23,  6.537166228718923e-25,  5.385449547819935e-27,  1.704759209739537e+00,
 -1.990491147877332e-03, -8.087043246084262e-06, -1.770072708589693e-08,  2.594576627598500e-11,  4.199247821511889e-13,  1.681803831937517e-15,  4.834557561832139e-19,
 -3.310177473109974e-20, -1.925808440811541e-22, -3.111334047660416e-25,  2.806774676502929e-27,  1.771921808038580e+00, -1.611109275024408e-03, -7.281890433242395e-06,
 -2.157948658620828e-08, -1.723734029293960e-11,  2.515086631300684e-13,  1.756926597208852e-15,  5.450973614861805e-18, -3.584591166349672e-21, -1.403254695800564e-22,
 -7.927973351806174e-25, -1.745094283734444e-27,  1.831825148318244e+00, -1.236988608809609e-03, -6.105487641940308e-06, -2.218691012389414e-08, -4.919174851152518e-11,
  4.842864141350487e-14,  1.166459582098950e-15,  6.605496300869833e-18,  2.006497412261343e-20, -4.427166262777691e-24, -4.674059641505814e-25, -3.117067278432443e-27,
  1.883641291852898e+00, -8.856013855618934e-04, -4.695581462472133e-06, -1.973873994612612e-08, -6.365071705316078e-11, -1.165234234995590e-13,  2.891285375844145e-16,
  4.121367704353262e-18,  2.349693888536909e-20,  8.546285351990305e-23,  1.308490289072728e-25, -8.749794916322421e-28,  1.926626771689275e+00, -5.741778335206069e-04,
 -3.221597624401570e-06, -1.505013844381543e-08, -5.973936195466373e-11, -1.923810438781367e-13, -4.021451779194466e-16,  4.131523209040597e-19,  1.043400111010613e-20,
  7.073347544861851e-23,  3.337377650612341e-25,  1.137924278675217e-27,  1.960144983161710e+00, -3.186110082421954e-04, -1.865313621368393e-06, -9.391151605538735e-09,
 -4.236586128341722e-11, -1.721712436614696e-13, -6.174930409953307e-16, -1.823428794121624e-18, -3.319834729501364e-21,  6.908243266188443e-24,  1.159102778285762e-25,
  7.907885577200325e-28,  1.983687120573548e+00, -1.323569836686428e-04, -7.977565762910993e-07, -4.219288423477999e-09, -2.057573358004319e-11, -9.431395509765989e-14,
 -4.091541342247735e-16, -1.678983965236548e-18, -6.467327931106251e-21, -2.295366568523071e-23, -7.188498804566655e-26, -1.748132262942347e-28,  1.996893737557745e+00,
 -2.541212209307823e-05, -1.556449940170049e-07, -8.453803470797847e-10, -4.291983951083030e-12, -2.084425776123114e-14, -9.800558440118451e-17, -4.491894059231165e-19,
 -2.015150039046065e-21, -8.870701721403903e-24, -3.836940091967324e-26, -1.631693083539613e-28,  8.322591765452672e-04, -5.402569093091180e-06,  2.629294500791289e-08,
 -1.136913911572622e-10,  4.605918757210559e-13, -1.790065998493866e-15,  6.757806096445454e-18, -2.496727498478635e-20,  9.069839410095461e-23, -3.250157787945345e-25,
  1.151390594375821e-27, -4.039109819569588e-30,  7.485681437657487e-03, -4.846679563221463e-05,  2.345925126544174e-07, -1.004958555985680e-09,  4.013566918109792e-12,
 -1.528350463263801e-14,  5.611577484936070e-17, -1.998559840471041e-19,  6.924302162171528e-22, -2.336200098333809e-24,  7.669761640738570e-27, -2.444552667311176e-29,
  2.076765737735994e-02, -1.337621810475488e-04,  6.403552335888233e-07, -2.691446566244791e-09,  1.043473687576591e-11, -3.804091472203294e-14,  1.312838968413238e-16,
 -4.286240547059556e-19,  1.313263649713360e-21, -3.704476262104678e-24,  9.194568133148922e-27, -1.753099059700466e-29,  4.062814996550004e-02, -2.596259047797928e-04,
  1.222220802858628e-06, -4.987562416017243e-09,  1.843925945667017e-11, -6.244934675952651e-14,  1.922225885110458e-16, -5.207733382284682e-19,  1.126869482620305e-21,
 -1.168793195404361e-24, -5.798636508513952e-27,  5.154516752644999e-29,  6.699135340868016e-02, -4.235724305175360e-04,  1.948934989745208e-06, -7.630998849320557e-09,
  2.630528777714357e-11, -7.908687526328476e-14,  1.949662620842789e-16, -3.029521516694323e-19, -4.076381977078844e-22,  6.236696578638448e-24, -3.448708190168660e-26,
  1.409743270764947e-28,  9.975479148064413e-02, -6.223050904525080e-04,  2.780306230916013e-06, -1.030154638853734e-08,  3.210256895100426e-11, -7.879835142847888e-14,
  1.068262995214843e-16,  2.882946566332399e-19, -3.073505353895551e-21,  1.525922687302158e-23, -5.453289957142596e-26,  1.361069370513013e-28,  1.387881138304110e-01,
 -8.517334764277306e-04,  3.668500952518559e-06, -1.264530705706626e-08,  3.396734495612354e-11, -5.495159896572981e-14, -7.953126695199244e-17,  1.142104871801410e-18,
 -5.737750673041510e-21,  1.904971136382822e-23, -3.563890272348551e-26, -5.571670627418301e-29,  1.839315907120566e-01, -1.106998356772609e-03,  4.559690447926312e-06,
 -1.430345211930043e-08,  3.039800947782367e-11, -5.486401412760245e-15, -3.371479174950334e-16,  1.967612526220931e-18, -6.667302061406632e-21,  1.070931228062638e-23,
  3.563356496729447e-26, -3.779134578257511e-28,  2.349943089490072e-01, -1.382506322581262e-03,  5.396059671840006e-06, -1.494431835140269e-08,  2.054015244924223e-11,
  6.565904471972423e-14, -6.044374871130943e-16,  2.363167833242278e-18, -4.295497197460956e-21, -1.156943497395076e-23,  1.330563150470689e-25, -5.816398261190717e-28,
  2.917520760257895e-01, -1.671976873777550e-03,  6.118181435902997e-06, -1.429721543989828e-08,  4.424910912576780e-12,  1.481338776802060e-13, -7.954689479514296e-16,
  1.953773516439742e-18,  1.810333106307474e-21, -4.056700157874058e-23,  1.900063117985596e-25, -3.586793268140564e-28,  3.539450455361586e-01, -1.968505169824510e-03,
  6.667746765265010e-06, -1.218582637073916e-08, -1.687810743080362e-11,  2.260690097195843e-13, -8.205757487889332e-16,  5.629450207828627e-19,  1.021227824026973e-20,
 -6.044612119628177e-23,  1.325694161067560e-25,  3.807952404087894e-28,  4.212750864549781e-01, -2.264644165265286e-03,  6.990621974695996e-06, -8.558546042580168e-09,
 -4.123134789978384e-11,  2.804051607755050e-13, -6.140683072628571e-16, -1.638796138964670e-18,  1.757312742042429e-20, -5.320592469864259e-23, -6.299986595662371e-26,
  1.275386347702694e-27,  4.934029315927580e-01, -2.552510280774900e-03,  7.040173658506004e-06, -3.512569392486478e-09, -6.555560852807650e-11,  2.925271789765865e-13,
 -1.627649803617023e-16, -4.077886721912555e-18,  1.964097096305396e-20, -9.722655028174374e-24, -3.225274480040862e-25,  1.582494546069979e-27,  5.699451579771380e-01,
 -2.823917055730492e-03,  6.780762756142007e-06,  2.691907549518184e-09, -8.613203124081979e-11,  2.487584796199580e-13,  4.733426476966621e-16, -5.872043783976006e-18,
  1.314937577109141e-20,  5.983630700350843e-23, -4.805701209224352e-25,  6.677753839646175e-28,  6.504710746757245e-01, -3.070541286751318e-03,  6.191257263875270e-06,
  9.631245248556861e-09, -9.907905440783111e-11,  1.449228640388256e-13,  1.157675478202598e-15, -6.092888468645257e-18, -2.006678883541976e-21,  1.236507213646463e-22,
 -3.660846801700388e-25, -1.315373634722517e-27,  7.344996225903441e-01, -3.284125838814463e-03,  5.268350406414134e-06,  1.673539567356722e-08, -1.009740747132739e-10,
 -1.012167489881048e-14,  1.698202739349845e-15, -4.148460380891240e-18, -2.141670372255797e-20,  1.396262938169182e-22,  6.117660523822086e-26, -3.123886828714847e-27,
  8.214964267062116e-01, -3.456722440417751e-03,  4.029399798279426e-06,  2.332537496439219e-08, -8.955231682487651e-11, -1.932249103442704e-13,  1.894802658629357e-15,
 -1.605514937722672e-19, -3.677877781403917e-20,  7.937209949634409e-23,  6.125516186997910e-25, -3.039764206041570e-27,  9.108711844769508e-01, -3.580976120977092e-03,
  2.514429436373281e-06,  2.867253183917699e-08, -6.437453022628947e-11, -3.690813944766234e-13,  1.605535638664741e-15,  4.843382554103146e-18, -3.904245303131291e-20,
 -4.633790203735935e-23,  9.179736337805384e-25, -3.135074853036581e-28,  1.001975624070544e+00, -3.650450268825694e-03,  7.868712910405329e-07,  3.207831811240091e-08,
 -2.731879405090606e-11, -4.963496656702229e-13,  8.139308366615217e-16,  9.095838906266176e-18, -2.330357103524964e-20, -1.789677502724937e-22,  6.556808176517604e-25,
  3.609268690438499e-27,  1.094102321560331e+00, -3.659987335561190e-03, -1.067416012166443e-06,  3.296948279712282e-08,  1.726731547922222e-11, -5.373486862623187e-13,
 -3.290442155324469e-16,  1.067865363343050e-17,  6.854528571536188e-21, -2.354580982615089e-22, -1.511210560172922e-25,  5.536168586874574e-27,  1.186484723613517e+00,
 -3.606094797739004e-03, -2.943303524680316e-06,  3.099886379284888e-08,  6.290326374789151e-11, -4.695673303931285e-13, -1.515586207617738e-15,  8.400462429232102e-18,
  3.867651908752920e-20, -1.600831726863075e-22, -1.018106823113001e-24,  3.072756429842201e-27,  1.278298776323630e+00, -3.487339064745059e-03, -4.722085950726149e-06,
  2.613682485431555e-08,  1.018851245887712e-10, -2.958199003041563e-13, -2.359760519833885e-15,  2.595202307937594e-18,  5.526887126445991e-20,  2.455808255544907e-23,
 -1.266866575828836e-24, -2.552631970552987e-27,  1.368666603227939e+00, -3.304721812545848e-03, -6.279876615354153e-06,  1.873401672432584e-08,  1.267285331982620e-10,
 -4.901518582839765e-14, -2.533930500140042e-15, -4.649834774193856e-18,  4.517914954986943e-20,  2.112987873076785e-22, -5.840438240091692e-25, -6.565811192127219e-27,
  1.456662694751177e+00, -3.062004360421688e-03, -7.498534086632515e-06,  9.534248664839362e-09,  1.319306713130890e-10,  2.120894390567020e-13, -1.918592193997906e-15,
 -1.018995416759739e-17,  1.127072273020466e-20,  2.709509949048758e-22,  5.826538411836589e-25, -4.836882843765237e-27,  1.541323052864645e+00, -2.765937382275516e-03,
 -8.278481949763788e-06, -3.810696132638154e-10,  1.156481704246715e-10,  4.175283029435800e-13, -6.951538130757593e-16, -1.133702669141256e-17, -2.815479886808452e-20,
  1.527264310741764e-22,  1.279933592400253e-24,  1.345440233854894e-27,  1.621657662349855e+00, -2.426347286728065e-03, -8.552212090511165e-06, -9.726337177945719e-09,
  8.075410504398001e-11,  5.085166255238201e-13,  6.856091535491677e-16, -7.472322863135880e-18, -4.948980297568645e-20, -5.934949811905468e-23,  9.001950462568655e-25,
  5.776124422144101e-27,  1.696666518023501e+00, -2.056029418949975e-03, -8.296676916045926e-06, -1.721621142194306e-08,  3.474834523402824e-11,  4.603243337054160e-13,
  1.679453124677980e-15, -6.888676148865104e-19, -4.022582593030053e-20, -2.022122774996000e-22, -1.616600581788559e-25,  4.011338238326116e-27,  1.765359214554517e+00,
 -1.670404504968721e-03, -7.542325498874904e-06, -2.181270001439767e-08, -1.177322944399400e-11,  2.954885765230046e-13,  1.907144049775455e-15,  5.249175872369591e-18,
 -9.224506757112605e-21, -1.734464996659806e-22, -8.596715315141253e-25, -1.252293850056050e-27,  1.826777801095820e+00, -1.286910777975399e-03, -6.376415906297805e-06,
 -2.296464426769190e-08, -4.792787026035985e-11,  7.871539000100442e-14,  1.360351301816174e-15,  7.241139529402569e-18,  1.953460277983233e-20, -2.602097654568555e-23,
 -6.160984257116974e-25, -3.640063255998986e-27,  1.880022232190957e+00, -9.241309842391012e-04, -4.938632383878351e-06, -2.077537734234024e-08, -6.590199611271030e-11,
 -1.081117171831971e-13,  4.155227118998654e-16,  4.923422858194814e-18,  2.665725407596603e-20,  8.978428709093225e-23,  8.145021626506276e-26, -1.393313841036221e-27,
  1.924277347652969e+00, -6.006895660713432e-04, -3.408062922176605e-06, -1.603726895636186e-08, -6.368235532702635e-11, -2.018535321740045e-13, -3.855007270775405e-16,
  7.904587715342327e-19,  1.323299643108618e-20,  8.510948438433479e-23,  3.856307136669005e-25,  1.215609807279302e-27,  1.958839963763059e+00, -3.339960830232175e-04,
 -1.982190852573348e-06, -1.009737556773120e-08, -4.596168096678833e-11, -1.876154897035049e-13, -6.699921542802792e-16, -1.924717872097229e-18, -2.978745639175024e-21,
  1.230176392389429e-23,  1.553649587153008e-25,  1.010499778299288e-27,  1.983144599773181e+00, -1.389473056274968e-04, -8.504273279822518e-07, -4.564140345207199e-09,
 -2.256414178477964e-11, -1.047219625350254e-13, -4.591913175530367e-16, -1.899729858978972e-18, -7.347284174722069e-21, -2.598427916763740e-23, -7.966800249712372e-26,
 -1.778238059160835e-28,  1.996789532809596e+00, -2.669906025686031e-05, -1.662157718353429e-07, -9.175193820874349e-10, -4.733448159134314e-12, -2.335491223376283e-14,
 -1.115358793407299e-16, -5.190945852384348e-19, -2.363943278340374e-21, -1.055925133845800e-23, -4.632387248277535e-26, -1.996908528765693e-28,  8.110611200979977e-04,
 -5.197560103617974e-06,  2.497171159996825e-08, -1.065997514497212e-10,  4.263574536585937e-13, -1.635950193106235e-15,  6.097657707985803e-18, -2.224358283201068e-20,
  7.978573902713674e-23, -2.823248081530260e-25,  9.876524070762669e-28, -3.421686455453302e-30,  7.295492869649961e-03, -4.663722461624551e-05,  2.229084572343586e-07,
 -9.431155296238122e-10,  3.720923955961452e-12, -1.400144946461858e-14,  5.081778278181491e-17, -1.789866997096225e-19,  6.135994076057071e-22, -2.049898207375418e-24,
  6.669723664058422e-27, -2.109540553318949e-29,  2.024265371904986e-02, -1.287657470954579e-04,  6.090350461263274e-07, -2.530410125005388e-09,  9.704478625695567e-12,
 -3.502949084400264e-14,  1.198512141684093e-16, -3.886639148891812e-19,  1.186337950767157e-21, -3.351978233706124e-24,  8.434433921436901e-27, -1.697006342623432e-29,
  3.960882978203187e-02, -2.500826191931356e-04,  1.164099804782618e-06, -4.702280386901960e-09,  1.723524571725930e-11, -5.800695009022846e-14,  1.781391525336769e-16,
 -4.854272843786488e-19,  1.081131936372339e-21, -1.358918701899157e-24, -3.790726213723160e-27,  4.012952309869058e-29,  6.532767663533691e-02, -4.083402020807800e-04,
  1.859836929441168e-06, -7.222516816980709e-09,  2.476964830798352e-11, -7.451075268380634e-14,  1.863329031590261e-16, -3.126587239328185e-19, -2.065104657143503e-22,
  4.974989786314357e-24, -2.874884621730821e-26,  1.202958521475609e-28,  9.730928527163353e-02, -6.005485017887008e-04,  2.659717972226885e-06, -9.800371169085143e-09,
  3.055283874897726e-11, -7.614827421102489e-14,  1.136012683217215e-16,  1.983224215863561e-19, -2.562008785431535e-21,  1.319597829609877e-23, -4.867651876607248e-26,
  1.296741752465398e-28,  1.354389278291568e-01, -8.229832885762203e-04,  3.519981557781531e-06, -1.211071499479388e-08,  3.285171119231798e-11, -5.649672611465134e-14,
 -5.002173164691241e-17,  9.691902638250751e-19, -5.078105210061312e-21,  1.758668617165602e-23, -3.724571122041061e-26, -1.907209300589907e-29,  1.795754769281261e-01,
 -1.071199141736742e-03,  4.390962236414367e-06, -1.381838313018994e-08,  3.021170544102373e-11, -1.294057729713434e-14, -2.849819793363572e-16,  1.760671422595898e-18,
 -6.259901140129019e-21,  1.182575185389833e-23,  2.075345975402401e-26, -3.003280265843308e-28,  2.295494928579204e-01, -1.340049490774448e-03,  5.218740548871836e-06,
 -1.460593643821067e-08,  2.171354623383892e-11,  5.193068756158180e-14, -5.402487457510154e-16,  2.220026098878958e-18, -4.622206279577990e-21, -6.741629649062270e-24,
  1.087730426874659e-25, -5.214227442236696e-28,  2.851609748329302e-01, -1.623716266538629e-03,  5.947134101438640e-06, -1.420373403545228e-08,  7.201135370714531e-12,
  1.297043392349555e-13, -7.401615346343058e-16,  1.989772573787441e-18,  4.827744084550214e-22, -3.329817280457583e-23,  1.730996995178179e-25, -4.048467290393916e-28,
  3.461767766454280e-01, -1.915752369511212e-03,  6.520042306124425e-06, -1.242076908063156e-08, -1.255220620641176e-11,  2.065992955292763e-13, -8.005578531484167e-16,
  8.559735963361424e-19,  8.135165861284566e-21, -5.486698772791808e-23,  1.450043092924075e-25,  1.908936502487522e-28,  4.123276940184648e-01, -2.209140793663825e-03,
  6.884143646442194e-06, -9.174198009242582e-09, -3.577401702618698e-11,  2.651786457374116e-13, -6.523726408867722e-16, -1.107483456689800e-18,  1.562524150473895e-20,
 -5.467347969809131e-23, -1.209986359078084e-26,  1.039145842681870e-27,  4.833052417038255e-01, -2.496374882888409e-03,  6.991921764787509e-06, -4.514904574541621e-09,
 -5.975301182623990e-11,  2.873212621850839e-13, -2.682162392202784e-16, -3.457330364189832e-18,  1.907539715936774e-20, -2.124517103631482e-23, -2.540596030700094e-25,
  1.519471726561725e-27,  5.587581539718174e-01, -2.769564788182406e-03,  6.804963001101718e-06,  1.354158623005831e-09, -8.105632350466005e-11,  2.581951038794779e-13,
  3.151140867371366e-16, -5.420444864616757e-18,  1.496541371937877e-20,  4.129416881696211e-23, -4.444195764941325e-25,  9.585542330183202e-28,  6.382886638756519e-01,
 -3.020575648568928e-03,  6.297420998056726e-06,  8.070619561918852e-09, -9.591659410657950e-11,  1.706566182989379e-13,  9.868240514793599e-16, -6.088808635986771e-18,
  2.168754223255214e-21,  1.080179390720901e-22, -4.114725955423465e-25, -7.553543418963166e-28,  7.214486459552092e-01, -3.241203202718438e-03,  5.459482025093672e-06,
  1.512036463950985e-08, -1.007787287478228e-10,  2.916852023452082e-14,  1.573208665073430e-15, -4.753160137605392e-18, -1.637822449084449e-20,  1.394368918801843e-22,
 -6.767596106830072e-26, -2.716684673328740e-27,  8.077357453146987e-01, -3.423392259929680e-03,  4.300587740783475e-06,  2.186408884649594e-08, -9.296310204786089e-11,
 -1.479337811763092e-13,  1.874292058974115e-15, -1.287292137038931e-18, -3.351337767186366e-20,  1.011143857000679e-22,  4.728394679625455e-25, -3.276534148351966e-27,
  8.965896645343865e-01, -3.559502461013127e-03,  2.852083171437496e-06,  2.758562350270918e-08, -7.136058001747498e-11, -3.290636291217804e-13,  1.723458835209593e-15,
  3.574376093559964e-18, -4.005559388230098e-20, -1.017798669615915e-23,  8.832290965624692e-25, -1.245343542909722e-27,  9.873888394121751e-01, -3.642623717072337e-03,
  1.168864584213716e-06,  3.156294782883497e-08, -3.703027467736091e-11, -4.738491542421200e-13,  1.057243562424933e-15,  8.252395735329525e-18, -2.923848797914623e-20,
 -1.498346238223133e-22,  7.940169564791837e-25,  2.655056389050569e-27,  1.079447804793492e+00, -3.666940250825938e-03, -6.704803177036054e-07,  3.315945698742125e-08,
  6.465685076012685e-12, -5.416407959915056e-13, -2.825093244113312e-17,  1.076168636737776e-17, -1.671807935241094e-21, -2.366077458567950e-22,  9.360440964620269e-26,
  5.531514720249866e-27,  1.172015630677976e+00, -3.628136896962025e-03, -2.565594537704946e-06,  3.192829133317984e-08,  5.316792788799438e-11, -5.029845887523378e-13,
 -1.263966942867965e-15,  9.538330367932027e-18,  3.221649018085208e-20, -1.977304285091182e-22, -8.553515384112752e-25,  4.293780732307947e-27,  1.264275891594175e+00,
 -3.523833941504824e-03, -4.398868213098700e-06,  2.771660684485563e-08,  9.540930501825381e-11, -3.513818503295014e-13, -2.262272375413969e-15,  4.367975824656416e-18,
  5.521743387368276e-20, -2.795492137694637e-23, -1.348264825869075e-24, -1.109840106013345e-27,  1.355348710275416e+00, -3.354027218682951e-03, -6.042945642503334e-06,
  2.075048534146079e-08,  1.251304138382806e-10, -1.112216410566745e-13, -2.642777482794081e-15, -3.087467286871394e-18,  5.229588218996605e-20,  1.821775041131579e-22,
 -8.707832244557524e-25, -6.395257187012474e-27,  1.444295476432350e+00, -3.121498798392838e-03, -7.371326146353109e-06,  1.167647571366055e-08,  1.356891365763458e-10,
  1.626693196884632e-13, -2.197365706634409e-15, -9.669166798135870e-18,  2.138933326511736e-20,  2.895798846641746e-22,  3.385901564881117e-25, -6.235323825090442e-27,
  1.530126863900600e+00, -2.832151444702066e-03, -8.271680227570927e-06,  1.535089469846609e-09,  1.238056838877966e-10,  3.969389987027926e-13, -1.024306353462576e-15,
 -1.214003684685424e-17, -2.172449297468950e-20,  2.047002860486248e-22,  1.308047123252200e-24, -1.247560806248863e-28,  1.611814730643383e+00, -2.495209104132701e-03,
 -8.660837427747012e-06, -8.352089181689806e-09,  9.107110422481388e-11,  5.222798762363586e-13,  4.539439260003347e-16, -9.082731741837634e-18, -5.091648922225040e-20,
 -1.820803717322318e-23,  1.157507817188544e-24,  5.860946247455043e-27,  1.688308359368701e+00, -2.123219046998866e-03, -8.499624728303790e-06, -1.658440525939217e-08,
  4.435555788885631e-11,  5.002475305512127e-13,  1.641042502104696e-15, -2.093448329505765e-18, -4.757585442356355e-20, -2.047659361064208e-22,  4.361785651641610e-26,
  5.333845008224106e-27,  1.758555257653351e+00, -1.731792855333464e-03, -7.805004915906389e-06, -2.195125730160966e-08, -5.394035953416868e-12,  3.429843917417563e-13,
  2.049001820230971e-15,  4.847353959185376e-18, -1.609898380799631e-20, -2.087290285490165e-22, -8.987964814023350e-25, -4.745333767845342e-28,  1.821526371784838e+00,
 -1.339037313011690e-03, -6.656534823385686e-06, -2.371705163768550e-08, -4.601029449858718e-11,  1.138664377176127e-13,  1.571678116579992e-15,  7.846180234254826e-18,
  1.811430097625711e-20, -5.401644551635705e-23, -7.872475634950213e-25, -4.129631290385563e-27,  1.876245085688885e+00, -9.646553473351270e-04, -5.194332969851975e-06,
 -2.184651666963269e-08, -6.795282776639007e-11, -9.638550348893739e-14,  5.658106497048987e-16,  5.828668756603940e-18,  2.993169220974944e-20,  9.163100567405972e-23,
  6.016133922852925e-27, -2.062264080822164e-27,  1.921818816686885e+00, -6.287414900016554e-04, -3.606758484735566e-06, -1.708897747631464e-08, -6.780989367652623e-11,
 -2.107891648344615e-13, -3.569570508678446e-16,  1.266020329388060e-18,  1.658761811514313e-20,  1.016186521288308e-22,  4.400855707269174e-25,  1.250588981939992e-27,
  1.957471478944253e+00, -3.503510763917335e-04, -2.107898387548934e-06, -1.086367312274180e-08, -4.987920790500195e-11, -2.043523234323664e-13, -7.251430787310190e-16,
 -2.011661060723662e-18, -2.412619323373275e-21,  1.948158668568291e-23,  2.056074548984262e-25,  1.282683927204244e-27,  1.982574847959252e+00, -1.459761035939114e-04,
 -9.074342764464910e-07, -4.942539487948729e-09, -2.477323659419793e-11, -1.164083178768541e-13, -5.158204372158913e-16, -2.150440197158198e-18, -8.341957697880548e-21,
 -2.932655700328831e-23, -8.740412183918309e-26, -1.720123283588671e-28,  1.996680005519078e+00, -2.807415132935622e-05, -1.776963146962752e-07, -9.971418815740234e-10,
 -5.228538037219603e-12, -2.621510160532199e-14, -1.271893738260124e-16, -6.011984484465937e-19, -2.779660854957904e-21, -1.260056853768643e-23, -5.607192470502525e-26,
 -2.450270766496646e-28,  7.906624859946500e-04, -5.002789665676006e-06,  2.373239036113936e-08, -1.000320395624476e-10,  3.950528913543923e-13, -1.496800872478819e-15,
  5.509106160220278e-18, -1.984571844099172e-20,  7.029833057629286e-23, -2.456709437935338e-25,  8.488051601506073e-28, -2.904569402334042e-30,  7.112440231028574e-03,
 -4.489823527245197e-05,  2.119392487147356e-07, -8.857563767446114e-10,  3.452696476854530e-12, -1.283980982438355e-14,  4.607031052373695e-17, -1.604825321332002e-19,
  5.443896311292431e-22, -1.800795081163271e-24,  5.806362074273949e-27, -1.822070756828676e-29,  1.973714663781427e-02, -1.240123390417692e-04,  5.795791314346946e-07,
 -2.380590523853464e-09,  9.031793315951228e-12, -3.227947218949051e-14,  1.094824188832818e-16, -3.525681735152164e-19,  1.071561585857195e-21, -3.029310875647575e-24,
  7.704831624233431e-27, -1.616185527770480e-29,  3.862677403278834e-02, -2.409909289106397e-04,  1.109289479142469e-06, -4.435569825507487e-09,  1.611677917181159e-11,
 -5.389085079094353e-14,  1.650239917160774e-16, -4.516397837697511e-19,  1.029880857273587e-21, -1.478083600058309e-24, -2.234348396473382e-27,  3.094735472493346e-29,
  6.372353367080262e-02, -3.938015618006827e-04,  1.775496215687629e-06, -6.837884174279027e-09,  2.332344085597127e-11, -7.014440527775526e-14,  1.775113428311957e-16,
 -3.166133857990686e-19, -4.688485265809278e-23,  3.925389249441056e-24, -2.386295843105924e-26,  1.021994274610086e-28,  9.494891350473744e-02, -5.797329802290931e-04,
  2.544996817478081e-06, -9.323559610074214e-09,  2.905754130023067e-11, -7.336404587172501e-14,  1.180753176258695e-16,  1.235742619286669e-19, -2.120646969020699e-21,
  1.136066015336609e-23, -4.315090611195844e-26,  1.212418446782592e-28,  1.322024064667949e-01, -7.953959010225898e-04,  3.377769267418888e-06, -1.159418341651236e-08,
  3.171187712324255e-11, -5.738938748137064e-14, -2.506627315456439e-17,  8.165321766175913e-19, -4.471924301884268e-21,  1.608866395700889e-23, -3.745863247143120e-26,
  7.973774325139029e-30,  1.753598971322640e-01, -1.036726530654262e-03,  4.228032262858861e-06, -1.333742159256525e-08,  2.988837612593639e-11, -1.921079652290931e-14,
 -2.384226155998878e-16,  1.567301821729013e-18, -5.822229563356449e-21,  1.241195099792093e-23,  9.040458797872606e-27, -2.338690260213459e-28,  2.242716931288670e-01,
 -1.298994670786577e-03,  5.045585861312600e-06, -1.425089444146349e-08,  2.262744807968802e-11,  3.969373721264538e-14, -4.801895167469580e-16,  2.069028270029601e-18,
 -4.791950290586399e-21, -2.831177753385602e-24,  8.720605212927527e-26, -4.587961439573315e-28,  2.787601874459912e-01, -1.576818823277929e-03,  5.777463132233921e-06,
 -1.406870938556500e-08,  9.622100684343440e-12,  1.126097109753724e-13, -6.844025061502751e-16,  1.987342613842851e-18, -5.956920605926137e-22, -2.673790814064622e-23,
  1.547718871677612e-25, -4.243964714349347e-28,  3.386171394513171e-01, -1.864191334887046e-03,  6.369921062829114e-06, -1.258958376495752e-08, -8.610268400378247e-12,
  1.877011462217755e-13, -7.732349163431178e-16,  1.085828495221845e-18,  6.265945719002246e-21, -4.894617638186985e-23,  1.499314049169906e-25,  3.914857267100417e-29,
  4.036005666902782e-01, -2.154517339033019e-03,  6.770791200569235e-06, -9.705013942300742e-09, -3.062924103595528e-11,  2.492042689289985e-13, -6.766781303151304e-16,
 -6.389756902483362e-19,  1.365868701700933e-20, -5.431052668415230e-23,  2.860330509012073e-26,  8.135250832885214e-28,  4.734312474153404e-01, -2.440672042711313e-03,
  6.932195032879528e-06, -5.425362798317265e-09, -5.407844646812076e-11,  2.797906124614146e-13, -3.566039250361476e-16, -2.860987221802365e-18,  1.814348588941655e-20,
 -3.010123898070835e-23, -1.895872558089446e-25,  1.403946788007446e-27,  5.477888465380107e-01, -2.715081737005657e-03,  6.813603098714888e-06,  9.892895967964414e-11,
 -7.582880255256926e-11,  2.639919404849218e-13,  1.702456563702852e-16, -4.921110676715710e-18,  1.614277599978131e-20,  2.442433180851893e-23, -3.976740797312304e-25,
  1.150691027470959e-27,  6.263076969046368e-01, -2.969834712687718e-03,  6.385177083534098e-06,  6.564488154225817e-09, -9.228037802747181e-11,  1.923058761485404e-13,
  8.178706261602838e-16, -5.960422513610901e-18,  5.754528977302756e-21,  9.104704721946813e-23, -4.334119969233242e-25, -2.531119620386230e-28,  7.085722953803818e-01,
 -3.196828923393612e-03,  5.631277413189772e-06,  1.351457715046703e-08, -9.982885491085311e-11,  6.527385664136789e-14,  1.433532330222840e-15, -5.197695733647473e-18,
 -1.143477713392942e-20,  1.344777555660454e-22, -1.767419498413913e-25, -2.231446309178571e-27,  7.941126113752123e-01, -3.387963576752427e-03,  4.553942591221893e-06,
  2.035543949461987e-08, -9.547547872819937e-11, -1.035009993332043e-13,  1.823805499837544e-15, -2.298111758839999e-18, -2.956780995517881e-20,  1.171198737306495e-22,
  3.271681760409311e-25, -3.313539850156509e-27,  8.823993564851431e-01, -3.535381581208487e-03,  3.176050222382197e-06,  2.639348285232960e-08, -7.752086491163185e-11,
 -2.866445654474752e-13,  1.805589295771503e-15,  2.293431147343956e-18, -3.980151568191302e-20,  2.381227255853339e-23,  8.105679624317816e-25, -2.029553575416142e-27,
  9.728394300037980e-01, -3.631768562049202e-03,  1.543756987093176e-06,  3.089610281395687e-08, -4.623536961721682e-11, -4.458129897712926e-13,  1.274445832044684e-15,
  7.236799440576798e-18, -3.403547141299657e-20, -1.160442960361474e-22,  8.877755587940811e-25,  1.595827871555316e-27,  1.064771837621528e+00, -3.670711503791332e-03,
 -2.723034508926651e-07,  3.317631082410769e-08, -4.349568072409913e-12, -5.387167699766949e-13,  2.710546845516368e-16,  1.057309704401626e-17, -1.006428631423135e-20,
 -2.280719594545985e-22,  3.307152051027684e-25,  5.192923240520604e-27,  1.157464479523239e+00, -3.647115408389157e-03, -2.177687976486440e-06,  3.269694524659882e-08,
  4.282709030157432e-11, -5.300052254354321e-13, -9.835756667788384e-16,  1.044915047308305e-17,  2.453072918253953e-20, -2.278560442483319e-22, -6.437492264192194e-25,
  5.278326139381477e-27,  1.250112316307997e+00, -3.557669091795494e-03, -4.057350983304525e-06,  2.918402978569498e-08,  8.784965580672605e-11, -4.040103850997785e-13,
 -2.115457559439358e-15,  6.108355335411163e-18,  5.323277610195012e-20, -8.239463075221084e-23, -1.361908607480997e-24,  5.101297644922496e-28,  1.341837539106116e+00,
 -3.401340916632374e-03, -5.782011940009355e-06,  2.273130440307993e-08,  1.222657141475751e-10, -1.754907816123013e-13, -2.704863142529521e-15, -1.316329305993447e-18,
  5.816080297763624e-20,  1.418687699941029e-22, -1.140096254487407e-24, -5.769448605376015e-27,  1.431692479839208e+00, -3.179871801093896e-03, -7.218084448493360e-06,
  1.387057309035778e-08,  1.383936664263387e-10,  1.067707588451534e-13, -2.456937333098097e-15, -8.815855460204974e-18,  3.198845353846018e-20,  2.972641329209278e-22,
  3.686491349489153e-26, -7.435507999064898e-27,  1.518666076230161e+00, -2.898216932991921e-03, -8.241116474201848e-06,  3.578038060640625e-09,  1.314707209532016e-10,
  3.682052074406935e-13, -1.372780333578413e-15, -1.270725573877976e-17, -1.341938089190547e-20,  2.564062869879747e-22,  1.264194342454059e-24, -1.916453368282192e-27,
  1.601694722091489e+00, -2.564871135226581e-03, -8.751973293988605e-06, -6.810884575566131e-09,  1.016040957622834e-10,  5.299383448167972e-13,  1.767849244518625e-16,
 -1.071310995903342e-17, -5.067693303822790e-20,  3.318768325776845e-23,  1.409931994775958e-24,  5.537288490784624e-27,  1.679678246822661e+00, -2.191999257398661e-03,
 -8.694042424820967e-06, -1.579255992060148e-08,  5.474869283982297e-11,  5.387503301885187e-13,  1.560008950558540e-15, -3.733001012349112e-18, -5.485580208067081e-20,
 -1.979251566540027e-22,  3.083888618533670e-25,  6.700701832011154e-27,  1.751501536495979e+00, -1.795287483269018e-03, -8.068702682925836e-06, -2.197996746769789e-08,
  1.968074890091620e-12,  3.937237405042332e-13,  2.176336124379725e-15,  4.204996606058264e-18, -2.426268769335443e-20, -2.447962095401230e-22, -8.964403844729064e-25,
  6.413235093975252e-28,  1.816061898057158e+00, -1.393440338109704e-03, -6.945474433815492e-06, -2.443287240249925e-08, -4.333763778428504e-11,  1.542865073532083e-13,
  1.799148606308720e-15,  8.388283731156162e-18,  1.555793843907099e-20, -8.926635648134512e-23, -9.781460587071625e-25, -4.526249456802882e-27,  1.872301668356101e+00,
 -1.007277268492125e-03, -5.463075709413231e-06, -2.294838830218860e-08, -6.973095157061390e-11, -8.073633716764199e-14,  7.429179157088034e-16,  6.839117536939838e-18,
  3.321075943888651e-20,  8.982232835315847e-23, -1.025783287381947e-25, -2.903960878778242e-27,  1.919244817363683e+00, -6.584345964487795e-04, -3.818476557253267e-06,
 -1.820811433736608e-08, -7.210815054687078e-11, -2.188672660240718e-13, -3.135024234009155e-16,  1.858861409910492e-18,  2.057598545888466e-20,  1.203184886641819e-22,
  4.946556219697812e-25,  1.215586923542278e-27,  1.956035503054335e+00, -3.677496038011965e-04, -2.243188857204431e-06, -1.169540170663570e-08, -5.414489328114131e-11,
 -2.224396918506327e-13, -7.824330245642824e-16, -2.075940293727889e-18, -1.548799771612453e-21,  2.892821040969059e-23,  2.691579880109640e-25,  1.617069986001137e-27,
  1.981976039211615e+00, -1.534797394358191e-04, -9.692020466016604e-07, -5.358230261784236e-09, -2.723023717818568e-11, -1.295417208002581e-13, -5.799335703751052e-16,
 -2.434964253701663e-18, -9.462429346858375e-21, -3.296954545348076e-23, -9.460389470595658e-26, -1.524880592190387e-28,  1.996564787928255e+00, -2.954504777325955e-05,
 -1.901818122274318e-07, -1.085164671136739e-09, -5.784782820168160e-12, -2.948013567016209e-14, -1.453396255806186e-16, -6.978604105036554e-19, -3.276392917249842e-21,
 -1.507478318133059e-23, -6.804942660615980e-26, -3.014506900681021e-28,  7.710235919011101e-04, -4.817626855683390e-06,  2.256896584040720e-08, -9.394368202625615e-11,
  3.663953291848347e-13, -1.371004231027060e-15,  4.983635435081735e-18, -1.773136744411570e-20,  6.203573967864878e-23, -2.141414946479411e-25,  7.308269150038412e-28,
 -2.470531133622272e-30,  6.936172301020620e-03, -4.324431758902322e-05,  2.016333472912270e-07, -8.325090201315181e-10,  3.206603105584008e-12, -1.178613432673058e-14,
  4.181125100046689e-17, -1.440560192781048e-19,  4.835552899103965e-22, -1.583820990829236e-24,  5.060311778859701e-27, -1.575258784499765e-29,  1.925019302753931e-02,
 -1.194875658413024e-04,  5.518582463029137e-07, -2.241107069281719e-09,  8.411699633448189e-12, -2.976658095044333e-14,  1.000745910819677e-16, -3.199649792681364e-19,
  9.678849703191340e-22, -2.735066230577809e-24,  7.014385994308013e-27, -1.520388362070808e-29,  3.768022792808669e-02, -2.323252172022759e-04,  1.057574969548540e-06,
 -4.186112936845880e-09,  1.507756263070702e-11, -5.007835162823598e-14,  1.528313567669802e-16, -4.195496973732314e-19,  9.753682546448871e-22, -1.542509262468361e-24,
 -1.040475428475634e-27,  2.359086862714543e-29,  6.217622450136170e-02, -3.799195716702253e-04,  1.695635102179315e-06, -6.475703766237207e-09,  2.196243704814367e-11,
 -6.599056048287636e-14,  1.686451439183757e-16, -3.160283932806261e-19,  7.828762015760752e-23,  3.056013919239421e-24, -1.972029954115353e-26,  8.647612471322786e-29,
  9.267000395471124e-02, -5.598127434070372e-04,  2.435855707494512e-06, -8.870222183204912e-09,  2.761884065587555e-11, -7.049601930977388e-14,  1.206445156185378e-16,
  6.193444515990984e-20, -1.741471164122123e-21,  9.738563815227003e-24, -3.802348454093276e-26,  1.116996003765819e-28,  1.290739980751742e-01, -7.689217294634498e-04,
  3.241645444302944e-06, -1.109600088174443e-08,  3.055984402514682e-11, -5.773226884547482e-14, -4.121778312459353e-18,  6.824095554491139e-19, -3.919560786361632e-21,
  1.460352500636273e-23, -3.665777912566554e-26,  2.729476063075711e-29,  1.712796373179937e-01, -1.003534370297298e-03,  4.070838841501763e-06, -1.286257765783413e-08,
  2.945038636199967e-11, -2.442696417989894e-14, -1.970789637952708e-16,  1.388190468776980e-18, -5.371212073681188e-21,  1.258498131621259e-23,  1.895796061410478e-29,
 -1.778493238538363e-28,  2.191553695150036e-01, -1.259307815800553e-03,  4.876771585643666e-06, -1.388311105693767e-08,  2.331068002900223e-11,  2.884698355310020e-14,
 -4.244142647182149e-16,  1.914689947409844e-18, -4.835782176596219e-21,  2.716655745335354e-25,  6.838663941289888e-26, -3.969740031655001e-28,  2.725442862544489e-01,
 -1.531271633596942e-03,  5.609633824343336e-06, -1.389761181195725e-08,  1.171453084157102e-11,  9.684879632576635e-14, -6.291601819448406e-16,  1.954037657192448e-18,
 -1.451333347913087e-21, -2.092156804409733e-23,  1.360507696182721e-25, -4.237083853711915e-28,  3.312613331020305e-01, -1.813838329590335e-03,  6.218140117676591e-06,
 -1.269831345001876e-08, -5.039248857033321e-12,  1.695294175418556e-13, -7.402812108665196e-16,  1.259304353783362e-18,  4.611910190474167e-21, -4.295121240948203e-23,
  1.489680376461246e-25, -7.744981419479609e-29,  3.950900811428183e-01, -2.100824808220257e-03,  6.651552228118958e-06, -1.015609672164385e-08, -2.580875998409640e-11,
  2.327968907549818e-13, -6.887423251328095e-16, -2.328935035409754e-19,  1.173215769683814e-20, -5.251294571199477e-23,  5.976861194343557e-26,  6.066748499408483e-28,
  4.637790418280606e-01, -2.385489187069927e-03,  6.862082232340464e-06, -6.246342524900817e-09, -4.857437324449331e-11,  2.703353827299962e-13, -4.287559407038704e-16,
 -2.299079261325910e-18,  1.693784463326492e-20, -3.649154275661082e-23, -1.310249254831875e-25,  1.253575030543890e-27,  5.370375161704866e-01, -2.660588386578390e-03,
  6.807685509525096e-06, -1.071916959790304e-09, -7.051896113223218e-11,  2.664834205138584e-13,  3.979740264166594e-17, -4.393442137141177e-18,  1.674827184490154e-20,
  9.566488466372397e-24, -3.444645996395360e-25,  1.254358587760333e-27,  6.145309847464249e-01, -2.918463001896996e-03,  6.455222247598918e-06,  5.119781218019151e-09,
 -8.825136983697936e-11,  2.099557861613879e-13,  6.540256296096245e-16, -5.727194225256337e-18,  8.718690369150061e-21,  7.361940936901637e-23, -4.348579645176568e-25,
  1.740128772468116e-28,  6.958760690448061e-01, -3.151157046720747e-03,  5.783917768040630e-06,  1.192957844592238e-08, -9.819131329596261e-11,  9.789527854418920e-14,
  1.283591067551668e-15, -5.487696822175786e-18, -6.743109796560739e-21,  1.255968092188573e-22, -2.634951290674659e-25, -1.708880422748205e-27,  7.806351303123860e-01,
 -3.350581086243617e-03,  4.788981547995827e-06,  1.881362616658361e-08, -9.711353323723656e-11, -6.060477094754933e-14,  1.746862207241908e-15, -3.174578552387379e-18,
 -2.515082558454240e-20,  1.273199036019145e-22,  1.838516619574984e-25, -3.174247488834854e-27,  8.683106225455052e-01, -3.508727798232639e-03,  3.485148508424625e-06,
  2.510965962815547e-08, -8.281595293702220e-11, -2.426827404926298e-13,  1.852146705043610e-15,  1.039569734146536e-18, -3.838394915387159e-20,  5.425811632051574e-23,
  7.073511825369433e-25, -2.629674444602817e-27,  9.583393853374245e-01, -3.617948735743679e-03,  1.909782954873766e-06,  3.008673533219746e-08, -5.483000088474170e-11,
 -4.129214094722608e-13,  1.461249857897838e-15,  6.087794640464325e-18, -3.755986221380051e-20, -7.944927763515998e-23,  9.340570027228473e-25,  5.098401617794139e-28,
  1.050087153404447e+00, -3.671299467617814e-03,  1.250405855696654e-07,  3.302097641202723e-08, -1.503509047108449e-11, -5.287027738146678e-13,  5.613790201541277e-16,
  1.012266079975752e-17, -1.798319273640334e-20, -2.104420162075174e-22,  5.461026031595696e-25,  4.551336404900734e-27,  1.142843675223483e+00, -3.662956623301438e-03,
 -1.781566915500883e-06,  3.329619624574825e-08,  3.201505196302706e-11, -5.500191693397072e-13, -6.812755763682832e-16,  1.109838701495704e-17,  1.592244872153690e-20,
 -2.487390582934049e-22, -3.955216647029998e-25,  5.947470793076934e-27,  1.235818973213769e+00, -3.588703802841142e-03, -3.698984474322446e-06,  3.052228563620503e-08,
  7.927657386009130e-11, -4.525395844546495e-13, -1.921095805821478e-15,  7.753904436965264e-18,  4.929591050950136e-20, -1.359268817790324e-22, -1.302425237197365e-24,
  2.193950541841170e-27,  1.328141437397108e+00, -3.446472942975089e-03, -5.497626052878438e-06,  2.465594147235072e-08,  1.181048516762050e-10, -2.406350817638285e-13,
 -2.714962075927360e-15,  6.172512637875730e-19,  6.238858565930936e-20,  9.147491402584418e-23, -1.371676470917846e-24, -4.682616214602989e-27,  1.418858610777630e+00,
 -3.236912905027638e-03, -7.038291912866653e-06,  1.609866950901557e-08,  1.399200620290010e-10,  4.496768786068248e-14, -2.687843429387214e-15, -7.621373640403302e-18,
  4.263502776390101e-20,  2.919118984976355e-22, -3.107944676251756e-25, -8.300864331189055e-27,  1.506941673772752e+00, -2.963937811484557e-03, -8.185321943847363e-06,
  5.738570590059698e-09,  1.384763244335908e-10,  3.309491903295241e-13, -1.733139250320717e-15, -1.297942597455150e-17, -3.304155042236396e-21,  3.047027305914688e-22,
  1.135793715130822e-24, -3.951209450100658e-27,  1.591294728429874e+00, -2.635185401239737e-03, -8.823599696222209e-06, -5.100303648252039e-09,  1.122200527959031e-10,
  5.303998349696807e-13, -1.456255011771005e-16, -1.230430593995278e-17, -4.841009624421399e-20,  9.425386024836572e-23,  1.637366706664838e-24,  4.710934003303568e-27,
  1.670769966999284e+00, -2.262293916103289e-03, -8.877935210535615e-06, -1.482838572089570e-08,  6.588858241915023e-11,  5.747314141337307e-13,  1.429858782178140e-15,
 -5.599410472948811e-18, -6.168442478806218e-20, -1.793003471538903e-22,  6.323612974942522e-25,  8.004095917798072e-27,  1.744189618410672e+00, -1.860890990764534e-03,
 -8.332004201488062e-06, -2.188260618223390e-08,  1.037391843134804e-11,  4.472725639513359e-13,  2.281832605475289e-15,  3.280746751519250e-18, -3.371029000129580e-20,
 -2.796778249086244e-22, -8.367491351866345e-25,  2.137019753316048e-27,  1.810375135902702e+00, -1.450188449134713e-03, -7.242719666630160e-06, -2.509916184824545e-08,
 -3.980081021252585e-11,  2.003375456685121e-13,  2.040451278600280e-15,  8.826774351191269e-18,  1.159132077776771e-20, -1.324566669784849e-22, -1.183002337288541e-24,
 -4.748774046317242e-27,  1.868183379063123e+00, -1.052102479717844e-03, -5.745200505104482e-06, -2.407596526940981e-08, -7.115123369794700e-11, -6.048532055549061e-14,
  9.497705684992773e-16,  7.952540617145998e-18,  3.633710309833247e-20,  8.287430168322996e-23, -2.523340847983773e-25, -3.935343477758486e-27,  1.916548571404910e+00,
 -6.898763470527086e-04, -4.044042036694300e-06, -1.939725322827163e-08, -7.655611853811515e-11, -2.256882026265185e-13, -2.515572755326277e-16,  2.590517971392317e-18,
  2.527621206468532e-20,  1.411418337714833e-22,  5.454806314188172e-25,  1.073241455852026e-27,  1.954527703521007e+00, -3.862715661873085e-04, -2.388881756846260e-06,
 -1.259835049312350e-08, -5.878620385519736e-11, -2.419201607118223e-13, -8.410810021701516e-16, -2.106615440571384e-18, -2.954136356684850e-22,  4.123167803981586e-23,
  3.489767981779399e-25,  2.023827772631142e-27,  1.981346195073281e+00, -1.614981594199593e-04, -1.036202924538663e-06, -5.815420776090409e-09, -2.996595973385022e-11,
 -1.443136137481380e-13, -6.525354492637154e-16, -2.757495348222333e-18, -1.071897636123356e-20, -3.687785010338631e-23, -1.005197433394479e-25, -1.122981060013315e-28,
  1.996443480073625e+00, -3.112020971121645e-05, -2.037792169161810e-07, -1.182634404230027e-09, -6.410913218782871e-12, -3.321513611207425e-14, -1.664330271683788e-16,
 -8.119404964608415e-19, -3.871453753638756e-21, -1.808163104758884e-23, -8.280531074433578e-26, -3.718536706041015e-28,  7.521071862124857e-04, -4.641486808694901e-06,
  2.147593134406926e-08, -8.829438363176154e-11,  3.401322321419305e-13, -1.257137325438725e-15,  4.513829250987155e-18, -1.586413311936288e-20,  5.482767215226805e-23,
 -1.869704520932628e-25,  6.303828131365032e-28, -2.105459711406023e-30,  6.766359101689893e-03, -4.167035661499745e-05,  1.919434670369515e-07, -7.830359706795333e-10,
  2.980597218333808e-12, -1.082936990964433e-14,  3.798601445198286e-17, -1.294567817986595e-19,  4.300200565564615e-22, -1.394623272564922e-24,  4.415011968600348e-27,
 -1.363217902032522e-29,  1.878090534346797e-02, -1.151780294401465e-04,  5.257532532341341e-07, -2.111155015078112e-09,  7.839677944436773e-12, -2.746888820074277e-14,
  9.153476053189782e-17, -2.905151978563557e-19,  8.743144588119698e-22, -2.467568805742844e-24,  6.368042407356365e-27, -1.416708743410245e-29,  3.676753580524134e-02,
 -2.240615246137020e-04,  1.008756643404498e-06, -3.952689110244967e-09,  1.411174159411027e-11, -4.654789238154157e-14,  1.415125361012089e-16, -3.892325118824195e-19,
  9.193221398468133e-22, -1.565193475244182e-24, -1.364483290962065e-28,  1.772194196785526e-29,  6.068319252594177e-02, -3.666594497424951e-04,  1.619992201322726e-06,
 -6.134646352123870e-09,  2.068238579580161e-11, -6.204888308903271e-14,  1.598469173715572e-16, -3.119079745846827e-19,  1.749844976831254e-22,  2.339156666779773e-24,
 -1.622142979811366e-26,  7.289805439404373e-29,  9.046906300116843e-02, -5.407442622165844e-04,  2.332018433575867e-06, -8.439442294981873e-09,  2.623798421333001e-11,
 -6.758572443747660e-14,  1.216491681167915e-16,  1.153267777076743e-20, -1.417101945880421e-21,  8.312991217790068e-24, -3.332806209254256e-26,  1.016953797433485e-28,
  1.260493458076410e-01, -7.435129494305044e-04,  3.111389075190976e-06, -1.061627966748600e-08,  2.940568590229074e-11, -5.761559932922321e-14,  1.330675755495427e-17,
  5.651148557598339e-19, -3.419898361283441e-21,  1.316551299996416e-23, -3.514685805889030e-26,  4.049182133852595e-29,  1.673296669603384e-01, -9.715770915221968e-04,
  3.919298227720735e-06, -1.239552390977766e-08,  2.891759794115372e-11, -2.870943134708479e-14, -1.605479070701116e-16,  1.223546342990201e-18, -4.919893215662747e-21,
  1.244357720682683e-23, -6.750532693258735e-27, -1.313385759229670e-28,  2.141951204854213e-01, -1.220953651600172e-03,  4.712429373574695e-06, -1.350606018176021e-08,
  2.379001252665637e-11,  1.928691791939617e-14, -3.729643350292833e-16,  1.760596234336645e-18, -4.780812768438922e-21,  2.675378531185275e-24,  5.222746068438873e-26,
 -3.381698068962833e-28,  2.665079023286154e-01, -1.487058320044913e-03,  5.444048390776023e-06, -1.369548543648774e-08,  1.350491013996304e-11,  8.239960130717853e-14,
 -5.752032744285337e-16,  1.896558212114979e-18, -2.111014822567804e-21, -1.584876596983173e-23,  1.177020470130926e-25, -4.083064588393291e-28,  3.241045033505689e-01,
 -1.764703846896484e-03,  6.065385384294001e-06, -1.275276978090875e-08, -1.823391620853868e-12,  1.522010836021275e-13, -7.031788528414710e-16,  1.383287275943772e-18,
  3.171850206794130e-21, -3.708790832403917e-23,  1.435753764522819e-25, -1.628929459384054e-28,  3.867924254308374e-01, -2.048106555012395e-03,  6.527352158931923e-06,
 -1.053268897495819e-08, -2.131843662738682e-11,  2.162295171531425e-13, -6.902879611772897e-16,  1.127983425031631e-19,  9.890647631479173e-21, -4.964405096096069e-23,
  8.234244255689914e-26,  4.235979947265331e-28,  4.543463855579564e-01, -2.330905158708803e-03,  6.782639535312040e-06, -6.980858734528369e-09, -4.327547006724264e-11,
  2.593327493666348e-13, -4.857460988865572e-16, -1.778993901350637e-18,  1.554265935259274e-20, -4.067844122875234e-23, -7.955856712857124e-26,  1.083721471881248e-27,
  5.265039775815650e-01, -2.606197130484939e-03,  6.788228621248433e-06, -2.157571827641134e-09, -6.518939166760920e-11,  2.660231492053148e-13, -7.568230709909805e-17,
 -3.854537555172527e-18,  1.685808270303789e-20, -3.094914597040502e-24, -2.883999509391882e-25,  1.282824060011345e-27,  6.029607719370490e-01, -2.866599154384916e-03,
  6.508328676589637e-06,  3.742151150335651e-09, -8.390810434801045e-11,  2.237619201409677e-13,  4.979447772704297e-16, -5.409126944964038e-18,  1.105872372725874e-20,
  5.648541762070462e-23, -4.193438216661708e-25,  5.169318822858350e-28,  6.833648526942718e-01, -3.104339633433795e-03,  5.917716232401073e-06,  1.037580185171515e-08,
 -9.593790052784885e-11,  1.268373166038167e-13,  1.127579064390459e-15, -5.633304528277490e-18, -2.428047980418213e-21,  1.137083543198817e-22, -3.271098822366635e-25,
 -1.185181409082335e-27,  7.673108221131713e-01, -3.311392672161029e-03,  5.005389456004510e-06,  1.725235897623791e-08, -9.791403355402887e-11, -1.983340252631122e-14,
  1.647404050785415e-15, -3.904918309248105e-18, -2.046793780372565e-20,  1.319547309108367e-22,  4.995501212095262e-26, -2.891287727997125e-27,  8.543333497949930e-01,
 -3.479664225589589e-03,  3.778361766423774e-06,  2.374819776657065e-08, -8.722344376136418e-11, -1.980187261818653e-13,  1.864389874483173e-15, -1.522377167638753e-19,
 -3.595047697382344e-20,  8.010612278433244e-23,  5.821553401937404e-25, -3.026971506614681e-27,  9.439004116473315e-01, -3.601241837552118e-03,  2.265293895369144e-06,
  2.914534884334332e-08, -6.272463418209023e-11, -3.759441145990535e-13,  1.614502882507627e-15,  4.847352329465773e-18, -3.974495314848157e-20, -4.194969705476780e-23,
  9.333548036677047e-25, -5.280969888101532e-28,  1.035406458951126e+00, -3.668719024008922e-03,  5.195026215648533e-07,  3.269664966864469e-08, -2.545182198348158e-11,
 -5.119003305061657e-13,  8.356503958151208e-16,  9.430577235241957e-18, -2.511986087691434e-20, -1.848388392651044e-22,  7.275694038973655e-25,  3.661871844286805e-27,
  1.128165885355459e+00, -3.675603074384029e-03, -1.379304714971650e-06,  3.371965221227273e-08,  2.087659567103954e-11, -5.625915199670702e-13, -3.647524259874850e-16,
  1.146209761224122e-17,  6.747243234618264e-21, -2.592097211611406e-22, -1.258183301356097e-25,  6.248245525626333e-27,  1.221407323459799e+00, -3.616809749453492e-03,
 -3.325413077150562e-06,  3.171587633829443e-08,  6.978320579538599e-11, -4.958671936264872e-13, -1.682707997947568e-15,  9.243243023193128e-18,  4.349250038898342e-20,
 -1.856072023686051e-22, -1.169772384647477e-24,  3.814549991755397e-27,  1.314269502301025e+00, -3.489238730408488e-03, -5.190586950699197e-06,  2.650358714569984e-08,
  1.126431364890270e-10, -3.053585233420626e-13, -2.669311604320262e-15,  2.655407545682162e-18,  6.464815730120544e-20,  3.290319614175421e-23, -1.545898524320717e-24,
 -3.172131960341018e-27,  1.405799623776106e+00, -3.292408400706312e-03, -6.831657418881102e-06,  1.834101072526350e-08,  1.401578856862990e-10, -2.193756123196502e-14,
 -2.880582865796155e-15, -6.092035265643403e-18,  5.283057783169430e-20,  2.720195269409863e-22, -6.867607968060083e-25, -8.702370116209362e-27,  1.494955447325963e+00,
 -3.029106782341026e-03, -8.102954601784525e-06,  8.004759991586876e-09,  1.446498998571160e-10,  2.849912533755718e-13, -2.096334028215502e-15, -1.290125953116818e-17,
  8.435283809342269e-21,  3.460268607157896e-22,  9.147013530639141e-25, -6.105742382620757e-27,  1.580612465759841e+00, -2.705987685150449e-03, -8.873681093708150e-06,
 -3.220228967269645e-09,  1.227643035028689e-10,  5.225991220780109e-13, -5.112313231125558e-16, -1.378611413192648e-17, -4.379138020797887e-20,  1.635253529477432e-22,
  1.816012856284777e-24,  3.310620713904025e-27,  1.661577643882082e+00, -2.334010353183454e-03, -9.049165328292417e-06, -1.368040423393620e-08,  7.771249997048146e-11,
  6.069377998428568e-13,  1.244509191395723e-15, -7.670997461245589e-18, -6.759590169511146e-20, -1.466189259324832e-22,  1.009717944337895e-24,  9.100815287565139e-27,
  1.736611084206769e+00, -1.928593868435656e-03, -8.593294661357360e-06, -2.164205544910045e-08,  1.987377998844400e-11,  5.030074519532067e-13,  2.357032850838322e-15,
  2.034678349741173e-18, -4.435372735013225e-20, -3.107384717463768e-22, -7.024808971725793e-25,  4.031831568515424e-27,  1.804456576195449e+00, -1.509345469837030e-03,
 -7.547589413655585e-06, -2.570117533060739e-08, -3.528413516833217e-11,  2.523113440562273e-13,  2.292009532064171e-15,  9.111859198341812e-18,  5.920652089169039e-21,
 -1.839633699729301e-22, -1.391936504142404e-24, -4.692310565377134e-27,  1.863881188730129e+00, -1.099239166732818e-03, -6.040978302625382e-06, -2.522274605235953e-08,
 -7.211426832626772e-11, -3.488469997728488e-14,  1.189153293134752e-15,  9.160756299049271e-18,  3.909403143186284e-20,  6.897069844378648e-23, -4.517865721211989e-25,
 -5.162697101706229e-27,  1.913722857300511e+00, -7.231809198133932e-04, -4.284308408127638e-06, -2.065856290026648e-08, -8.112388820168101e-11, -2.307589167081254e-13,
 -1.669046319646557e-16,  3.484953700285173e-18,  3.076078662240155e-20,  1.638307348645741e-22,  5.867900203412402e-25,  7.736683798813901e-28,  1.952943414605703e+00,
 -4.060037058570607e-04, -2.545868713169300e-06, -1.357875380579929e-08, -6.383124364924631e-11, -2.628135234550262e-13, -8.999551777138896e-16, -2.089442831649319e-18,
  1.462892938358534e-21,  5.710934917149469e-23,  4.484665169995652e-25,  2.512710715818409e-27,  1.980683169413570e+00, -1.700752987727597e-04, -1.108962782722493e-06,
 -6.318844180931120e-09, -3.301530013960502e-11, -1.609409974555395e-13, -7.347525868802422e-16, -3.122528870059912e-18, -1.211998287066744e-20, -4.097928190680892e-23,
 -1.040387971121867e-25, -4.164074921913832e-29,  1.996315646356916e+00, -3.280900560279791e-05, -2.186089241826575e-07, -1.290748455644348e-09, -7.117076336514634e-12,
 -3.749696508878489e-14, -1.910043801436148e-16, -9.469147359471462e-19, -4.586176014476479e-21, -2.174556986485141e-23, -1.010325272795431e-25, -4.599231087132584e-28,
  7.338782716448033e-04, -4.473826845732689e-06,  2.044824038631189e-08, -8.304767139387186e-11,  3.160378236465304e-13, -1.153943565055481e-15,  4.093218111664360e-18,
 -1.421265151569792e-20,  4.852915148261827e-23, -1.635135650441074e-25,  5.447014593528942e-28, -1.797768181640059e-30,  6.602690383214057e-03, -4.017160002768287e-05,
  1.828261824891838e-07, -7.370307856444397e-10,  2.772840699329857e-12, -9.959693289551084e-15,  3.454656221894075e-17, -1.164664986332568e-19,  3.828529759774360e-22,
 -1.229462513164203e-24,  3.856298426404693e-27, -1.180919723902467e-29,  1.832844778632705e-02, -1.110712474533274e-04,  5.011542518902624e-07, -1.989998538610956e-09,
  7.311625631662196e-12, -2.536658588679713e-14,  8.377901691406728e-17, -2.639104940951701e-19,  7.899195905730756e-22, -2.225001388544513e-24,  5.768087728973349e-27,
 -1.310230209009066e-29,  3.588713473582350e-02, -2.161774317221025e-04,  9.626489674323756e-07, -3.734168021526119e-09,  1.321388093514219e-11, -4.327910143638427e-14,
  1.310174121472552e-16, -3.607153714287708e-19,  8.630514988175749e-22, -1.556507142917689e-24,  5.368467651747936e-28,  1.306134249484784e-29,  5.924201618844835e-02,
 -3.539884425226504e-04,  1.548321668980318e-06, -5.813450517331436e-09,  1.947906757138306e-11, -5.831665192383072e-14,  1.512036890999813e-16, -3.050802878558121e-19,
  2.482550294824521e-22,  1.750885534851619e-24, -1.327705302860721e-26,  6.123412885615278e-29,  8.834276679086750e-02, -5.224861729459373e-04,  2.233219879874130e-06,
 -8.030289611910540e-09,  2.491546633885640e-11, -6.466712612560961e-14,  1.213804267762468e-16, -2.927501907185083e-20, -1.140779034328210e-21,  7.066403170061869e-24,
 -2.907425861514398e-26,  9.168865443291684e-29,  1.231242805743626e-01, -7.191235073436015e-04,  2.986778709116184e-06, -1.015498467400768e-08,  2.825778713030076e-11,
 -5.711829658250310e-14,  2.766719736493537e-17,  4.629937675526776e-19, -2.970790347891474e-21,  1.179805520124935e-23, -3.316485144490502e-26,  4.890952311588082e-29,
  1.635051363512555e-01, -9.408098702034096e-04,  3.773308434894626e-06, -1.193763387283240e-08,  2.830756262549381e-11, -3.216884808600388e-14, -1.284258104707028e-16,
  1.073214559112074e-18, -4.478069261769786e-21,  1.206975465655320e-23, -1.166358815036174e-26, -9.328838021108870e-29,  2.093856874585595e-01, -1.183896010378576e-03,
  4.552651691611286e-06, -1.312280396882823e-08,  2.409014356094404e-11,  1.091014950106215e-14, -3.257922545558264e-16,  1.609526321361092e-18, -4.650331749097416e-21,
  4.483246653668657e-24,  3.856203725371294e-26, -2.837989241681750e-28,  2.606457383107794e-01, -1.444159522420768e-03,  5.281051039978404e-06, -1.346695509164851e-08,
  1.501911320200750e-11,  6.922383728112128e-14, -5.231248759053803e-16,  1.820750769293441e-18, -2.601092809006928e-21, -1.149308456860340e-23,  1.002681057494947e-25,
 -3.828169553052908e-28,  3.171417645160332e-01, -1.716793167279657e-03,  5.912274620260302e-06, -1.275849545886071e-08,  1.055058605543662e-12,  1.357998506356146e-13,
 -6.632187246218941e-16,  1.464517053347058e-18,  1.938155566318149e-21, -3.150731123075000e-23,  1.350271790466265e-25, -2.216334570534699e-28,  3.787036286006557e-01,
 -1.996398782597883e-03,  6.399053121458544e-06, -1.084008567738550e-08, -1.715908165397768e-11,  1.997346431257895e-13, -6.829625421554001e-16,  4.013733166332158e-19,
  8.166798668901895e-21, -4.602570061360126e-23,  9.743241232393529e-26,  2.667164222527739e-28,  4.451307405070630e-01, -2.276990504582921e-03,  6.694883849315001e-06,
 -7.632422371023915e-09, -3.820914425529766e-11,  2.471319304644721e-13, -5.288188223845456e-16, -1.305583607592983e-18,  1.403197311093413e-20, -4.295898546899105e-23,
 -3.575649393357670e-26,  9.070570118472554e-28,  5.161876122414658e-01, -2.552012192940939e-03,  6.756254735684525e-06, -3.158172680734886e-09, -5.989552020250164e-11,
  2.629724282232006e-13, -1.760889224931596e-16, -3.318977876529493e-18,  1.655257750934454e-20, -1.350757337990860e-23, -2.324679720679800e-25,  1.250798156925262e-27,
  5.915987612145349e-01, -2.814375380637313e-03,  6.545328959642201e-06,  2.436021955463218e-09, -7.932541287757473e-11,  2.339368808707935e-13,  3.517264319141400e-16,
 -5.025900016679537e-18,  1.279650828429564e-20,  4.024832892362013e-23, -3.906409895228955e-25,  7.736930392466152e-28,  6.710429296069323e-01, -3.056525758115805e-03,
  6.033104144884029e-06,  8.862506037542386e-09, -9.314334121619795e-11,  1.520013337559576e-13,  9.693556108540388e-16, -5.648124391920613e-18,  1.418724382776598e-21,
  9.972965422774269e-23, -3.682167326322372e-25, -6.901058658907548e-28,  7.541466112137203e-01, -3.270548092278999e-03,  5.203011780429904e-06,  1.568467085976702e-08,
 -9.792454483501017e-11,  1.832262716225768e-14,  1.529612180266777e-15, -4.483743236336505e-18, -1.571128664534532e-20,  1.315167081139278e-22, -6.901906665404734e-26,
 -2.502382058715463e-27,  8.404769176731726e-01, -3.448321427952031e-03,  4.054843862332502e-06,  2.232336708214979e-08, -9.073736996117379e-11, -1.534516991991792e-13,
  1.844485449277626e-15, -1.252282679156392e-18, -3.268027827717421e-20,  1.006572661586664e-22,  4.439983977641441e-25, -3.219882217291924e-27,  9.295338792238063e-01,
 -3.581738128283619e-03,  2.608775332983358e-06,  2.808375249564693e-08, -6.984578972866399e-11, -3.357121920304093e-13,  1.732247001360899e-15,  3.558493767052965e-18,
 -4.059131492655821e-20, -5.362603175470510e-24,  8.892571184926493e-25, -1.453075191543774e-27,  1.020742369052515e+00, -3.663001257317938e-03,  9.090849594537644e-07,
  3.220869422033162e-08, -3.546837872497599e-11, -4.887728206626801e-13,  1.087494295791777e-15,  8.526188561069912e-18, -3.121412126048086e-20, -1.528169138107565e-22,
  8.657662326059392e-25,  2.597679208616941e-27,  1.113443973762000e+00, -3.685014148049740e-03, -9.730372873901030e-07,  3.396329691011042e-08,  9.563310146797973e-12,
 -5.674785591084342e-13, -4.219757729712645e-17,  1.152827170072899e-17, -2.608569830288893e-21, -2.587418786980055e-22,  1.485607779754152e-25,  6.159242307687886e-27,
  1.206889314044973e+00, -3.641872478500438e-03, -2.938457506373366e-06,  3.275096537176191e-08,  5.948376111857526e-11, -5.329956753223088e-13, -1.405479411058486e-15,
  1.051941752129263e-17,  3.601287914545105e-20, -2.286025912925197e-22, -9.695755145431289e-25,  5.243554410827468e-27,  1.300231554875516e+00, -3.529461101514704e-03,
 -4.861942896426554e-06,  2.825356867846574e-08,  1.059025649166438e-10, -3.682953555544910e-13, -2.565906262504423e-15,  4.730924412554536e-18,  6.469072019215796e-20,
 -3.120018148021168e-23, -1.645765629855685e-24, -1.319898993377935e-27,  1.392522131316983e+00, -3.346143226620611e-03, -6.598136929467961e-06,  2.057621616103276e-08,
  1.390150027827808e-10, -9.291859814632379e-14, -3.026061725594054e-15, -4.250824805994341e-18,  6.203650299757205e-20,  2.368961740104039e-22, -1.068194896334783e-24,
 -8.534914519507894e-27,  1.482710037378302e+00, -3.093506431083399e-03, -7.992832186126937e-06,  1.036190124882145e-08,  1.498175520590884e-10,  2.303866644727617e-13,
 -2.451870475313564e-15, -1.242552084750339e-17,  2.148033622822874e-20,  3.766114183273071e-22,  5.991421082200863e-25, -8.214848706227411e-27,  1.569646339566856e+00,
 -2.777097523643377e-03, -8.900196077500070e-06, -1.173184915400261e-09,  1.330615300758012e-10,  5.055450335595435e-13, -9.158746097688282e-16, -1.507897500940930e-17,
 -3.656672968877214e-20,  2.385327691888146e-22,  1.919745860480847e-24,  1.304756305357472e-27,  1.652095807184095e+00, -2.407038264704724e-03, -9.205464153602305e-06,
 -1.233834883143079e-08,  9.013125750096874e-11,  6.339795597477991e-13,  9.987049840909509e-16, -9.909925283591463e-18, -7.204839632596411e-20, -9.797686809215361e-23,
  1.427614966842679e-24,  9.815728867633717e-27,  1.728757579887046e+00, -1.998372854095824e-03, -8.850749457155317e-06, -2.124050385567901e-08,  3.050335814072513e-11,
  5.600889882154363e-13,  2.392415189609216e-15,  4.313355879982165e-19, -5.599752867990815e-20, -3.346456902965499e-22, -4.762880708724181e-25,  6.308839237911326e-27,
  1.798296466577669e+00, -1.570969035483819e-03, -7.859214349897582e-06, -2.622227584996728e-08, -2.966707705635166e-11,  3.103960531479160e-13,  2.548719506947766e-15,
  9.184213060732252e-18, -1.753108942430936e-21, -2.436678862518959e-22, -1.589927295268517e-24, -4.228332354520396e-27,  1.859385631733099e+00, -1.148797342552154e-03,
 -6.350591981457981e-06, -2.638051545991348e-08, -7.250504910614346e-11, -3.123484703684749e-15,  1.463514308198899e-15,  1.044753643983514e-17,  4.119329856172604e-20,
  4.595310026842916e-23, -7.093766117614945e-25, -6.573963950803888e-27,  1.910759983020363e+00, -7.584694157896993e-04, -4.540151966464844e-06, -2.199364893247968e-08,
 -8.577062119450339e-11, -2.334768392944615e-13, -5.462579898853614e-17,  4.568254248065141e-18,  3.708818946587688e-20,  1.878482803241281e-22,  6.102972285786874e-25,
  2.519975126182498e-28,  1.951277608849974e+00, -4.270402050426225e-04, -2.715118870631227e-06, -1.464329718023012e-08, -6.930820634890462e-11, -2.851071816929969e-13,
 -9.574691417026154e-16, -2.006047190213642e-18,  3.869848422393422e-21,  7.742284644995312e-23,  5.714239089240768e-25,  3.091568738039435e-27,  1.979984631573372e+00,
 -1.792595367228495e-04, -1.188067789520292e-06, -6.873828192823023e-09, -3.641777499253062e-11, -1.796694470068270e-13, -8.278406660865637e-16, -3.534777422834142e-18,
 -1.367031946016170e-20, -4.514744772874710e-23, -1.035352500595875e-25,  7.320078607586826e-29,  1.996180811684640e+00, -3.462182742646949e-05, -2.348067251483179e-07,
 -1.410879583686424e-09, -7.915093172932380e-12, -4.241656941952485e-14, -2.196960855416706e-16, -1.107019174511588e-18, -5.446913389266843e-21, -2.622230232451790e-23,
 -1.236078095810609e-25, -5.703680053212638e-28,  7.163039435739277e-04, -4.314142968556705e-06,  1.948126328540733e-08, -7.817049184505909e-11,  2.939099747658979e-13,
 -1.060311592387644e-15,  3.716149101726205e-18, -1.274984727848081e-20,  4.301651582191023e-23, -1.432278764407943e-25,  4.714746166224444e-28, -1.537921074699054e-30,
  6.444874232857134e-03, -3.874362868427074e-05,  1.742415753250028e-07, -6.942149210320376e-10,  2.581680847459732e-12, -9.168364000575269e-15,  3.145057104634016e-17,
 -1.048945905375960e-19,  3.412480262941162e-22, -1.085123868498194e-24,  3.372053303957948e-27, -1.024072205081737e-29,  1.789203278236378e-02, -1.071555824655895e-04,
  4.779597906802830e-07, -1.876964396379526e-09,  6.823816782639171e-12, -2.344177950561880e-14,  7.673167638494761e-17, -2.398712472584885e-19,  7.138364759909845e-22,
 -2.005495257177633e-24,  5.214920580903440e-27, -1.204523796177429e-29,  3.503754858442103e-02, -2.086519505631402e-04,  9.190794637052254e-07, -3.529503114613289e-09,
  1.237894089248903e-11, -4.025281471637903e-14,  1.212956407152788e-16, -3.339890729856302e-19,  8.075317054273503e-22, -1.524687147280529e-24,  1.027357047693493e-27,
  9.379275262485063e-30,  5.785040110751364e-02, -3.418757038639249e-04,  1.480392395057994e-06, -5.510921818389484e-09,  1.834833636979987e-11, -5.478931796802243e-14,
  1.427814339289246e-16, -2.962250305048027e-19,  3.023487698975456e-22,  1.270638545695715e-24, -1.080791443566447e-26,  5.126033732090224e-29,  8.628795275439073e-02,
 -5.049991880688434e-04,  2.139206120773670e-06, -7.641830960572091e-09,  2.365116837300858e-11, -6.176773012208158e-14,  1.200863452143355e-16, -6.192643531785487e-20,
 -9.063760340121678e-22,  5.981234512466528e-24, -2.525480718978675e-26,  8.199397888685435e-29,  1.202948139623451e-01, -6.957091173812241e-04,  2.867594070972031e-06,
 -9.711958709980832e-09,  2.712305751012348e-11, -5.630907691484603e-14,  3.936215935101073e-17,  3.744724351873983e-19, -2.569405138748322e-21,  1.051613250486339e-23,
 -3.089678849053001e-26,  5.366004327389279e-29,  1.598013733495534e-01, -9.111887594282280e-04,  3.632752607748635e-06, -1.149001742298918e-08,  2.763571552510756e-11,
 -3.490626206282126e-14, -1.003173419351093e-16,  9.367710297132202e-19, -4.052857468185374e-21,  1.153064325020304e-23, -1.506874304959223e-26, -6.262098166810092e-29,
  2.047219577801029e-01, -1.148098125018975e-03,  4.397496563462475e-06, -1.273602585886463e-08,  2.423372057986879e-11,  3.615279822087858e-15, -2.827826174446911e-16,
  1.463572226468039e-18, -4.464043607619273e-21,  5.790844712322007e-24,  2.717580005841059e-26, -2.346597573941603e-28,  2.549525794497343e-01, -1.402553341872877e-03,
  5.120932938743013e-06, -1.321623846158971e-08,  1.628211930680680e-11,  5.727085152909063e-14, -4.733660139791995e-16,  1.731637438116104e-18, -2.946628772300739e-21,
 -7.810222124624549e-24,  8.410712450664706e-26, -3.509954148670115e-28,  3.103682192654764e-01, -1.670106890256989e-03,  5.759360825215619e-06, -1.272073732705628e-08,
  3.615236555994772e-12,  1.203806760679345e-13, -6.215071533612248e-16,  1.509412395052629e-18,  8.986478043013086e-22, -2.631348155834345e-23,  1.243985081639315e-25,
 -2.581963309442577e-28,  3.708195882776139e-01, -1.945731051177279e-03,  6.267453773199080e-06, -1.108355969106949e-08, -1.332724326292988e-11,  1.835064311085526e-13,
 -6.683089710177198e-16,  6.369727570948225e-19,  6.582483110042889e-21, -4.193394777908757e-23,  1.062065728851714e-25,  1.364486767640174e-28,  4.361293023834468e-01,
 -2.223807811847129e-03,  6.599787544554178e-06, -8.204928684653136e-09, -3.339612709128941e-11,  2.340509052688058e-13, -5.593228645919828e-16, -8.815059152704823e-19,
  1.246885281692559e-20, -4.364263168037132e-23,  3.090034738990296e-28,  7.334624522107000e-28,  5.060874010494010e-01, -2.498129640851884e-03,  6.712779427824510e-06,
 -4.074685561602214e-09, -5.468555321851558e-11,  2.576904608030424e-13, -2.616900283823995e-16, -2.798763905284065e-18,  1.591201410686897e-20, -2.172563587867324e-23,
 -1.790027147832903e-25,  1.173094525729464e-27,  5.804461401043276e-01, -2.761917038088838e-03,  6.567101738810968e-06,  1.204656903650787e-09, -7.457341522246459e-11,
  2.407371177203020e-13,  2.169307933914571e-16, -4.596174347173198e-18,  1.397292087151086e-20,  2.536061314165659e-23, -3.524758996075384e-25,  9.480407665589601e-28,
  6.589139943388339e-01, -3.007860620667767e-03,  6.130616725410018e-06,  7.397743194829439e-09, -8.988343892446236e-11,  1.733764431852969e-13,  8.123628828531629e-16,
 -5.548174796543738e-18,  4.737794745163516e-21,  8.452870769578134e-23, -3.885942751529488e-25, -2.459941700895858e-28,  7.411488215178307e-01, -3.228197728717096e-03,
  5.381845509488897e-06,  1.412276072548459e-08, -9.720142963245753e-11,  5.347432028037486e-14,  1.397735473415916e-15, -4.911491235074570e-18, -1.105173172151686e-20,
  1.266844703542682e-22, -1.692681815030770e-25, -2.046501900418146e-27,  8.267501709079949e-01, -3.414836053685829e-03,  4.313919955190628e-06,  2.084940809617432e-08,
 -9.336716371097550e-11, -1.097195233562526e-13,  1.795348353713271e-15, -2.236923525276340e-18, -2.877123007436631e-20,  1.155699890619847e-22,  3.016261766685379e-25,
 -3.221879287136586e-27,  9.152507740063175e-01, -3.559539399004239e-03,  2.938861000288206e-06,  2.691479599560420e-08, -7.613698206941883e-11, -2.930893245918366e-13,
  1.813719044355787e-15,  2.263208380051021e-18, -4.016169661176847e-20,  2.869154847733533e-23,  8.078978573952326e-25, -2.214927321310237e-27,  1.006107342656084e+00,
 -3.654192941045665e-03,  1.291866546011989e-06,  3.156449367792439e-08, -4.496410312507794e-11, -4.599258676466616e-13,  1.311465452296972e-15,  7.446201373653822e-18,
 -3.606768779217750e-20, -1.162367148203055e-22,  9.548175905905572e-25,  1.442143177175654e-27,  1.098690932319065e+00, -3.691166469257923e-03, -5.649340615609271e-07,
  3.402556774708635e-08, -1.770327414320300e-12, -5.646357870299388e-13,  2.780362975603429e-16,  1.129743299061434e-17, -1.175196469641379e-20, -2.474903440240114e-22,
  4.106124700319522e-25,  5.692653833870292e-27,  1.192277319643497e+00, -3.663792734184846e-03, -2.540092915682253e-06,  3.361569588424339e-08,  4.851103039503947e-11,
 -5.630702945967104e-13, -1.096089791837471e-15,  1.153314249543162e-17,  2.714397846599982e-20, -2.624154455957865e-22, -7.128909727941147e-25,  6.364673434154997e-27,
  1.286038106555764e+00, -3.566972249198556e-03, -4.512987206221837e-06,  2.988578574762799e-08,  9.793277291372711e-11, -4.280550878528857e-13, -2.404718857985553e-15,
  6.770272838968126e-18,  6.237399542836621e-20, -9.759361743560590e-23, -1.658799951971654e-24,  7.517193994820644e-28,  1.379033605175090e+00, -3.397903018657110e-03,
 -6.337951104270839e-06,  2.278160691123849e-08,  1.364219267807205e-10, -1.667404654203285e-13, -3.116073382747173e-15, -2.138175136739190e-18,  6.970679528785503e-20,
  1.868463289157611e-22, -1.428463462620340e-24, -7.733741112193347e-27,  1.470208971808245e+00, -3.156910638103869e-03, -7.853965507141257e-06,  1.279252997736598e-08,
  1.538091104826460e-10,  1.674571457747682e-13, -2.788094937082388e-15, -1.151733832914526e-17,  3.537735193198972e-20,  3.927739760519125e-22,  1.953692276787073e-25,
 -1.008096508576731e-26,  1.558395509271074e+00, -2.848318452455960e-03, -8.901170996258443e-06,  1.035346646797681e-09,  1.429177739730453e-10,  4.783737484511275e-13,
 -1.353070759683060e-15, -1.609682514625069e-17, -2.658999341982274e-20,  3.157494173390489e-22,  1.922238234302660e-24, -1.281597833783882e-27,  1.642319464875270e+00,
 -2.481248731353003e-03, -9.344449362963393e-06, -1.079360873792855e-08,  1.030267034139007e-10,  6.543553734399156e-13,  6.885026443662942e-16, -1.226003645126325e-17,
 -7.444270149561784e-20, -3.214548161345929e-23,  1.864967675578042e-24,  9.951602246236263e-27,  1.720620875062302e+00, -2.070189225415830e-03, -9.102327414611247e-06,
 -2.065971585830391e-08,  4.227920166749741e-11,  6.174381456012764e-13,  2.377571736857338e-15, -1.556431128173268e-18, -6.831406955874621e-20, -3.474020733232272e-22,
 -1.426476435422331e-25,  8.899390788776625e-27,  1.791884839370775e+00, -1.635108995140760e-03, -8.176513833918490e-06, -2.664387497265071e-08, -2.282670230026525e-11,
  3.746363247079041e-13,  2.803683801532823e-15,  8.975137113928441e-18, -1.171249885619406e-20, -3.107314199929865e-22, -1.755840494617688e-24, -3.208540389808374e-27,
  1.854686800140048e+00, -1.200888056363316e-03, -6.674114253055454e-06, -2.753908542254886e-08, -7.219180480631413e-11,  3.566150419387373e-14,  1.774706172324756e-15,
  1.178612209251676e-17,  4.226307361418075e-20,  1.134364830993199e-23, -1.032427445446545e-24, -8.128490187778714e-27,  1.907651758004308e+00, -7.958700114007308e-04,
 -4.812463933926859e-06, -2.340336041365113e-08, -9.044218713697944e-11, -2.331123968088764e-13,  9.095111891617240e-17,  5.867997529942449e-18,  4.429087353220848e-20,
  2.122641105847830e-22,  6.044919004483345e-25, -5.737216195585146e-28,  1.949524866041250e+00, -4.494833276727168e-04, -2.897684291193099e-06, -1.579911298187249e-08,
 -7.524460844714963e-11, -3.087437396709009e-13, -1.011452710837765e-15, -1.832927706637659e-18,  7.103007336570347e-21,  1.031915124185778e-22,  7.219068204993949e-25,
  3.763921269332574e-27,  1.979248047577380e+00, -1.891042087088383e-04, -1.274172006997498e-06, -7.486373768382361e-09, -4.021812451491409e-11, -2.007762702380436e-13,
 -9.331887238917955e-16, -3.999022849737127e-18, -1.536897747466250e-20, -4.917739545058371e-23, -9.666804412527304e-26,  2.512938932609656e-28,  1.996038457113675e+00,
 -3.657022274126801e-05, -2.525260817031252e-07, -1.544605113948511e-09, -8.818767962980318e-12, -4.808183758632299e-14, -2.532818534959069e-16, -1.297430055462868e-18,
 -6.486309311289776e-21, -3.170710739418678e-23, -1.516427998828304e-25, -7.092115162470167e-28,  6.993532417303904e-04, -4.161966683150729e-06,  1.857074830716405e-08,
 -7.363285488498468e-11,  2.735674861876945e-13, -9.752570523133365e-16,  3.377674831244024e-18, -1.145230651928236e-20,  3.818408420999799e-23, -1.256548841812221e-25,
  4.087756126260413e-28, -1.318053858159976e-30,  6.292635796312998e-03, -3.738232985502294e-05,  1.661529166848796e-07, -6.543349310176949e-10,  2.405630030960011e-12,
 -8.447596111227097e-15,  2.866070955280838e-17, -9.457450918993022e-20,  3.045066326167340e-22, -9.588413655105812e-25,  2.951905001444152e-27, -8.890136613282993e-30,
  1.747091773403178e-02, -1.034201773455942e-04,  4.560761507454147e-07, -1.771436192447532e-09,  6.372865829119102e-12, -2.167830007552658e-14,  7.032450757753766e-17,
 -2.181444044814280e-19,  6.452684407387015e-22, -1.807193598792971e-24,  4.707629135443537e-27, -1.102029947807037e-29,  3.421738248547317e-02, -2.014654241033133e-04,
  8.778877415879491e-07, -3.337725468860366e-09,  1.160225294174346e-11, -3.745107004776132e-14,  1.122975302179444e-16, -3.090175948603907e-19,  7.534738076370690e-22,
 -1.476242005665387e-24,  1.373853930277684e-27,  6.487206532202914e-30,  5.650617267779083e-02, -3.302921802872891e-04,  1.415987208030808e-06, -5.225931340237564e-09,
  1.728615153534451e-11, -5.146096248106706e-14,  1.346288919266140e-16, -2.858971651272394e-19,  3.408297621498437e-22,  8.808303753558667e-25, -8.744338292916187e-27,
  4.276605723819256e-29,  8.430161148043858e-02, -4.882460067437000e-04,  2.049734400206104e-06, -7.273139156853256e-09,  2.244447792536279e-11, -5.890955041401093e-14,
  1.179773690387155e-16, -8.767335273911062e-20, -7.083906468251821e-22,  5.040452958833080e-24, -2.185113014566246e-26,  7.281607963734331e-29,  1.175571311919453e-01,
 -6.732272465991693e-04,  2.753617391596227e-06, -9.286944511650015e-09,  2.600712563023947e-11, -5.524751192502652e-14,  4.875153377730647e-17,  2.980749069771907e-19,
 -2.212493813326476e-21,  9.328240970179792e-24, -2.848337514181997e-26,  5.565052485998797e-29,  1.562138796533851e-01, -8.826707963521048e-04,  3.497501989232975e-06,
 -1.105355313106366e-08,  2.691556459074933e-11, -3.701339906449737e-14, -7.584188772215056e-17,  8.135999836191624e-19, -3.649197985863157e-21,  1.088037411903282e-23,
 -1.726761106265353e-26, -3.828925700355978e-29,  2.001989665971359e-01, -1.113522887013008e-03,  4.246991919319534e-06, -1.234806298801689e-08,  2.424139514904832e-11,
 -2.695685068008725e-15, -2.437697638631722e-16,  1.324248758827230e-18, -4.238373747558440e-21,  6.684608284145148e-24,  1.782971488719203e-26, -1.910894552012505e-28,
  2.494233029372913e-01, -1.362215745950246e-03,  4.963937004496432e-06, -1.294716219533094e-08,  1.731779976085231e-11,  4.648100504136720e-14, -4.262380670525024e-16,
  1.633466335377967e-18, -3.170869039877145e-21, -4.744612985812868e-24,  6.942995155905350e-26, -3.157972751332033e-28,  3.037789763245632e-01, -1.624641437917860e-03,
  5.607135905380087e-06, -1.264442866212591e-08,  5.877124910732427e-12,  1.059740749475925e-13, -5.789767045601500e-16,  1.523950272709639e-18,  3.812870087615847e-23,
 -2.157141655924625e-23,  1.125689267616582e-25, -2.769067028392593e-28,  3.631360962257315e-01, -1.896126783567379e-03,  6.133289950421847e-06, -1.126829955456054e-08,
 -9.815946937786308e-12,  1.677034755862545e-13, -6.477458240965233e-16,  8.242879338245228e-19,  5.150476452750343e-21, -3.759822297127334e-23,  1.098173571626778e-25,
  3.175064763203715e-29,  4.273390318011002e-01, -2.171412080833769e-03,  6.498274462137714e-06, -8.702555529627711e-09, -2.885111886614210e-11,  2.203746077680453e-13,
 -5.786548099810733e-16, -5.075782210590271e-19,  1.090527038709399e-20, -4.303383109956879e-23,  2.894106868318156e-26,  5.701579566325410e-28,  4.962019567949461e-01,
 -2.444637475462368e-03,  6.658802287971117e-06, -4.908790801947963e-09, -4.960060308076203e-11,  2.505262836723349e-13, -3.330536907919020e-16, -2.303376138646751e-18,
  1.501317584257852e-20, -2.788377916483770e-23, -1.297031523160509e-25,  1.063629886331478e-27,  5.695036089820182e-01, -2.709342317071166e-03,  6.574558259261053e-06,
  5.024023998850460e-11, -6.971676924299659e-11,  2.444504166332366e-13,  9.461611492001994e-17, -4.137070525845934e-18,  1.464249624220180e-20,  1.213031025269035e-23,
 -3.083134452075515e-25,  1.047862680666529e-27,  6.469811697928094e-01, -2.958484773332846e-03,  6.210878549983852e-06,  5.988355248697779e-09, -8.623342614958837e-11,
  1.910288016228443e-13,  6.595725139798533e-16, -5.350890879073773e-18,  7.499501439162431e-21,  6.888495019366838e-23, -3.908369285327848e-25,  1.323749408056228e-28,
  7.283231762573732e-01, -3.184491418027510e-03,  5.542028368664310e-06,  1.257786896676482e-08, -9.580781481158444e-11,  8.533391063340819e-14,  1.255937864332870e-15,
 -5.193650801666871e-18, -6.633374236580810e-21,  1.182548337622989e-22, -2.486709406876943e-25, -1.560608380033791e-27,  8.131613979137033e-01, -3.379349470000856e-03,
  4.555084710710831e-06,  1.934029637005783e-08, -9.513626499793899e-11, -6.748288519885299e-14,  1.720465453770231e-15, -3.088981298788721e-18, -2.442738574572508e-20,
  1.248369797245662e-22,  1.629192486929331e-25, -3.058218366294203e-27,  9.010616539063226e-01, -3.534757740086807e-03,  3.254343676763758e-06,  2.565209402755014e-08,
 -8.155908872952250e-11, -2.489436817528948e-13,  1.859295025009451e-15,  1.000595615542818e-18, -3.857228090291462e-20,  5.887676509943544e-23,  6.972379297169586e-25,
 -2.781070522694008e-27,  9.915136214846640e-01, -3.642355830851419e-03,  1.666026092743798e-06,  3.077325853455939e-08, -5.383167025663044e-11, -4.260827941577848e-13,
  1.503224864111498e-15,  6.232557688797159e-18, -3.955258610242885e-20, -7.711921264551488e-23,  9.925874500843833e-25,  2.804738520879260e-28,  1.083919811632475e+00,
 -3.694054051387985e-03, -1.571683934210761e-07,  3.390737002466716e-08, -1.297094596976384e-11, -5.542175807873029e-13,  5.877855011056936e-16,  1.078246320942682e-17,
 -2.030751385741155e-20, -2.262697061823114e-22,  6.445833172098849e-25,  4.892493938293991e-27,  1.177584079501812e+00, -3.682487593708633e-03, -2.132423458427716e-06,
  3.430046327012384e-08,  3.701318967333253e-11, -5.854120729987096e-13, -7.624574814774112e-16,  1.224565794637848e-17,  1.725350682646190e-20, -2.850863447800820e-22,
 -4.153917568145722e-25,  7.086259115538303e-27,  1.271700317806496e+00, -3.601615662098411e-03, -4.145248719164191e-06,  3.138115401154784e-08,  8.881104381861464e-11,
 -4.832716863017830e-13, -2.187826585624124e-15,  8.697323223376134e-18,  5.767999618318219e-20, -1.626540266791606e-22, -1.578630197803481e-24,  2.889537714776496e-27,
  1.365342369303435e+00, -3.447476283522711e-03, -6.051598571902087e-06,  2.493360016058732e-08,  1.323357380464735e-10, -2.419867887767308e-13, -3.143784801567214e-15,
  1.883942922803328e-19,  7.532613490239559e-20,  1.232816710960484e-22, -1.739237059297840e-24, -6.288490311221281e-27,  1.457456697407870e+00, -3.219086254264339e-03,
 -7.685591021686060e-06,  1.527652603673983e-08,  1.564637059899144e-10,  9.681406326245575e-14, -3.092600074359415e-15, -1.015841260073367e-17,  4.954676832671470e-20,
  3.912621696038711e-22, -2.812517438852688e-25, -1.149075286218158e-26,  1.546859951235366e+00, -2.919438535254921e-03, -8.874717141463179e-06,  3.396651593924164e-09,
  1.521235539371167e-10,  4.404063975154756e-13, -1.813880436939349e-15, -1.675115556014168e-17, -1.386049024703216e-20,  3.906376058198032e-22,  1.799786522449870e-24,
 -4.352205891937064e-27,  1.632244179325986e+00, -2.556493396358800e-03, -9.463647652094922e-06, -9.039708383071825e-09,  1.162498519746229e-10,  6.664903464058121e-13,
  3.118049006607358e-16, -1.464547106981664e-17, -7.415267866667294e-20,  5.108406001006441e-23,  2.291832638233836e-24,  9.306547309784140e-27,  1.712192928281420e+00,
 -2.143987052594424e-03, -9.345767701019581e-06, -1.988137758447099e-08,  5.519372603964561e-11,  6.737183072496538e-13,  2.301503643507616e-15, -3.942872075741095e-18,
 -8.082153894176301e-20, -3.444684425281284e-22,  3.095151805962431e-25,  1.166749678592775e-26,  1.785211546250122e+00, -1.701805627053167e-03, -8.498172362948029e-06,
 -2.694541984966813e-08, -1.464100061317900e-11,  4.448872024578906e-13,  3.047960648625560e-15,  8.407550683119727e-18, -2.419303077612193e-20, -3.833353417613166e-22,
 -1.861742285261224e-24, -1.474271917995855e-27,  1.849774341485498e+00, -1.255622412849918e-03, -7.011482345231829e-06, -2.868601928668734e-08, -7.102512399775605e-11,
  8.236748715823836e-14,  2.123651823593231e-15,  1.313637608963284e-17,  4.183758129584964e-20, -3.758147778948599e-23, -1.425611907914424e-24, -9.744120381395992e-27,
  1.904389464684737e+00, -8.355180377178404e-04, -5.102140019084908e-06, -2.488755595429901e-08, -9.506843991333198e-11, -2.287905409578137e-13,  2.762790267675768e-16,
  7.412167837857189e-18,  5.235859404624003e-20,  2.356100222075225e-22,  5.538599771932163e-25, -1.803560222066741e-27,  1.947679339525764e+00, -4.734441039029965e-04,
 -3.094705219096648e-06, -1.705376159110674e-08, -8.166624091191198e-11, -3.336051438927663e-13, -1.058992393514504e-15, -1.540283173094986e-18,  1.137956131514622e-20,
  1.355980418745200e-22,  9.039660709734249e-25,  4.525163839864465e-27,  1.978470659169716e+00, -1.996681833146186e-04, -1.368005992774772e-06, -8.163243933703540e-09,
 -4.446697924959569e-11, -2.245737074190453e-13, -1.052317988914990e-15, -4.519876834935766e-18, -1.720566446287604e-20, -5.275177029918233e-23, -8.010524194813554e-26,
  5.189737836665740e-28,  1.995888014929871e+00, -3.866704643852928e-05, -2.719407834651988e-07, -1.693741562344904e-09, -9.844260780160575e-12, -5.462109118673318e-14,
 -2.926960743812205e-16, -1.524489820294150e-18, -7.744905707277908e-21, -3.844549698994759e-23, -1.865498001812893e-25, -8.841668247274599e-28,  6.829970140046288e-04,
 -4.016862117678086e-06,  1.771278683283012e-08, -6.940751834066915e-11,  2.548477095190052e-13, -8.979068274086878e-16,  3.073458533258121e-18, -1.029974726587881e-20,
  3.394137407807356e-23, -1.104066539129278e-25,  3.549928017497577e-28, -1.131666382593454e-30,  6.145716101238567e-03, -3.608387286878780e-05,  1.585263812317836e-07,
 -6.171599732748329e-10,  2.243347742222424e-12, -7.790446119759561e-15,  2.614401116478464e-17, -8.536054448170703e-20,  2.720227007027268e-22, -8.482333201671395e-25,
  2.586971435553728e-27, -7.726212682914234e-30,  1.706440201838600e-02, -9.985489602273228e-05,  4.354166953533371e-07, -1.672849199549268e-09,  5.955694766255610e-12,
 -2.006153396119468e-14,  6.449601768247751e-17, -1.985013459304721e-19,  5.834847649553605e-22, -1.628294895884706e-24,  4.244421431297137e-27, -1.004350786816450e-29,
  3.342531770718375e-02, -1.945994331689652e-04,  8.389246009610378e-07, -3.157938050475271e-09,  1.087949597009669e-11, -3.485708338661245e-14,  1.039746830438620e-16,
 -2.857456270013314e-19,  7.013805599484931e-22, -1.416284733374495e-24,  1.607590539401740e-27,  4.230867017942962e-30,  5.520726911736312e-02, -3.192105025876648e-04,
  1.354902099549944e-06, -4.957413812809697e-09,  1.628860129027268e-11, -4.832467110680902e-14,  1.267807694595375e-16, -2.745472140295824e-19,  3.666769541711300e-22,
  5.664821737285369e-25, -7.025553420097874e-27,  3.555755258865896e-29,  8.238087894716972e-02, -4.721912258709205e-04,  1.964573015850903e-06, -6.923300074270616e-09,
  2.129439009410046e-11, -5.610995155732542e-14,  1.152312679349682e-16, -1.076011307130571e-19, -5.419184294398721e-22,  4.227923567982471e-24, -1.883753397473613e-26,
  6.427774750555172e-29,  1.149075841525883e-01, -6.516370904144652e-04,  2.644634491501087e-06, -8.879603833839436e-09,  2.491451173513848e-11, -5.398501977150102e-14,
  5.615537844935694e-17,  2.324330789661888e-19, -1.896593778335393e-21,  8.237992575849094e-24, -2.602939911427151e-26,  5.561102599319419e-29,  1.527383266904048e-01,
 -8.552140868203567e-04,  3.367418517263296e-06, -1.062891762662632e-08,  2.615887312318650e-11, -3.857307319132196e-14, -5.463801199736357e-17,  7.029565049814629e-19,
 -3.270288463641408e-21,  1.016191724743780e-23, -1.851713770205634e-26, -1.931472801510479e-29,  1.958118977677730e-01, -1.080133071123576e-03,  4.101139562350914e-06,
 -1.196093751700572e-08,  2.413190185403844e-11, -8.116310893481814e-15, -2.085525234054745e-16,  1.192593033750746e-18, -3.986810589095645e-21,  7.241221071182791e-24,
  1.027763614124938e-26, -1.530933333176759e-28,  2.440528856999628e-01, -1.323120936141717e-03,  4.810262485952335e-06, -1.266318091031299e-08,  1.814876756796167e-11,
  3.678853093556938e-14, -3.819435696949358e-16,  1.529775087610918e-18, -3.294937133991890e-21, -2.234643370085002e-24,  5.633328378816916e-26, -2.794725853110704e-28,
  2.973691662338965e-01, -1.580389528425116e-03,  5.456034502345389e-06, -1.253417929558730e-08,  7.861106098666899e-12,  9.259013212837522e-14, -5.363997027973734e-16,
  1.513590300309989e-18, -6.603515473772894e-22, -1.731463664470203e-23,  1.002354501684250e-25, -2.817152558397029e-28,  3.556488618997930e-01, -1.847603762818345e-03,
  5.997235995290248e-06, -1.139935864345433e-08, -6.615375883399740e-12,  1.524519403583480e-13, -6.225557776101388e-16,  9.682955677004404e-19,  3.876110381380693e-21,
 -3.320310077530678e-23,  1.093479444676274e-25, -4.940945105380566e-29,  4.187566838315389e-01, -2.119851125260553e-03,  6.391217079839137e-06, -9.129672201051399e-09,
 -2.458345729651277e-11,  2.063543571794114e-13, -5.882124743343602e-16, -1.831272663922832e-19,  9.382525676469084e-21, -4.141928057054871e-23,  5.070691352128960e-26,
  4.219808720678004e-28,  4.865295561133439e-01, -2.391615792607753e-03,  6.595299023389587e-06, -5.662771511521311e-09, -4.467495784311260e-11,  2.418123872558734e-13,
 -3.909798462953317e-16, -1.839927523593114e-18,  1.392691822147971e-20, -3.217281555771947e-23, -8.568851652141720e-26,  9.347545566198704e-28,  5.587714101835553e-01,
 -2.656762030252221e-03,  6.568629963916313e-06, -1.026031049803572e-09, -6.481416087013558e-11,  2.453844156183354e-13, -1.461281460759675e-17, -3.663812614256372e-18,
  1.486845572725067e-20,  7.346878858753216e-25, -2.612081197903131e-25,  1.083689550711887e-27,  6.352470271471958e-01, -2.908533463672098e-03,  6.274589131150253e-06,
  4.639994696817501e-09, -8.226653905172822e-11,  2.050899447251678e-13,  5.134587343388183e-16, -5.074229167332617e-18,  9.700237265010611e-21,  5.346316526459941e-23,
 -3.780314808818966e-25,  4.372712219070468e-28,  7.156748023511137e-01, -3.139577372992623e-03,  5.683826735478583e-06,  1.106018527303690e-08, -9.381159824382820e-11,
  1.137112282537031e-13,  1.108169462914959e-15, -5.339849441778261e-18, -2.570484191460961e-21,  1.070781124919041e-22, -3.066411244451886e-25, -1.077185597398557e-27,
  7.997183146022093e-01, -3.342006423303954e-03,  4.777997830194317e-06,  1.780953141273166e-08, -9.608045553708357e-11, -2.731375034190675e-14,  1.623713591071130e-15,
 -3.797752461321805e-18, -1.984768010452136e-20,  1.287412994044023e-22,  3.445786588323128e-26, -2.762093530686817e-27,  8.869766102062645e-01, -3.507514236836765e-03,
  3.554182703453780e-06,  2.430974918274485e-08, -8.609017405434086e-11, -2.041217335408823e-13,  1.870386913934227e-15, -1.946685190291250e-19, -3.598131815591732e-20,
  8.419875004172113e-23,  5.662673832017711e-25, -3.137269164946584e-27,  9.769731718375486e-01, -3.627565782540627e-03,  2.029862645652330e-06,  2.984579549926625e-08,
 -6.197916577752312e-11, -3.880565712869990e-13,  1.659654226087597e-15,  4.930121401567114e-18, -4.161424166168726e-20, -3.749709915507235e-23,  9.805808503394702e-25,
 -8.082633091586164e-28,  1.069143651608143e+00, -3.693688209798551e-03,  2.481118123508981e-07,  3.361202778187885e-08, -2.389018520423319e-11, -5.365685917107978e-13,
  8.794099645641344e-16,  1.000767123860464e-17, -2.793991438762976e-20, -1.964776620914405e-22,  8.372648583387565e-25,  3.829300543476399e-27,  1.162822630219324e+00,
 -3.697891387254476e-03, -1.717653904597167e-06,  3.479813170731752e-08,  2.515001339342953e-11, -5.995437053245994e-13, -4.134116689519639e-16,  1.263097085074433e-17,
  6.767541625555151e-21, -2.953538484833706e-22, -9.605109048761732e-26,  7.351306906219936e-27,  1.257229949258436e+00, -3.633247952537425e-03, -3.760476976403319e-06,
  3.272204079440160e-08,  7.864131064026444e-11, -5.326544922856939e-13, -1.919426446673256e-15,  1.043749290383408e-17,  5.072407290617007e-20, -2.226442830306255e-22,
 -1.406045427277724e-24,  4.923969851850161e-27,  1.351457583844272e+00, -3.494656658394559e-03, -5.739864112948076e-06,  2.700816132937883e-08,  1.267433445038533e-10,
 -3.170983362338590e-13, -3.104195155109720e-15,  2.655905437961375e-18,  7.845036436369301e-20,  4.873793376110682e-23, -1.973105500179026e-24, -4.252265784531543e-27,
  1.444458604192949e+00, -3.279795030569625e-03, -7.487201615450473e-06,  1.779130951314937e-08,  1.576357047539750e-10,  1.937050845801852e-14, -3.352742459103503e-15,
 -8.350726649136595e-18,  6.330526411353197e-20,  3.696257523319396e-22, -8.060313317640652e-25, -1.223792441269238e-26,  1.535040519043297e+00, -2.990231202247714e-03,
 -8.819070892295587e-06,  5.898567978929818e-09,  1.604581568538918e-10,  3.912082398046942e-13, -2.286911556859169e-15, -1.695622251346684e-17,  1.443268102385259e-21,
  4.578193451563486e-22,  1.534662256816674e-24, -7.730938652722807e-27,  1.621866146338331e+00, -2.632603848622973e-03, -9.560523358720268e-06, -7.072809923296964e-09,
  1.296198999625578e-10,  6.687870009110654e-13, -1.310815490911375e-16, -1.697046086445941e-17, -7.056833863671593e-20,  1.505492078040306e-22,  2.669735576018653e-24,
  7.699532530388928e-27,  1.703465959371961e+00, -2.219691444291204e-03, -9.578591374236716e-06, -1.888752481769556e-08,  6.920995200237053e-11,  7.273259917907321e-13,
  2.153054005262112e-15, -6.724132568946310e-18, -9.286839004240881e-20, -3.210051381407859e-22,  8.835647897362315e-25,  1.439696683566055e-26,  1.778266300434608e+00,
 -1.771087666020432e-03, -8.822616222521731e-06, -2.710444106878507e-08, -4.993185792251391e-12,  5.207624455279713e-13,  3.270355971297833e-15,  7.398113511433776e-18,
 -3.934295349350485e-20, -4.584044499407047e-22, -1.872784372833859e-24,  1.126604217450778e-27,  1.844637460893960e+00, -1.313110375549238e-03, -7.362469307516573e-06,
 -2.980634547068292e-08, -6.883752946152228e-11,  1.378985731112024e-13,  2.509926738936866e-15,  1.444165943702129e-17,  3.935063478556697e-20, -1.036451962965288e-22,
 -1.888799534044428e-24, -1.128204099551633e-26,  1.900963829877923e+00, -8.775559642284523e-04, -5.410066894295502e-06, -2.644482313969921e-08, -9.956012069133296e-11,
 -2.194720413896825e-13,  5.085809488608544e-16,  9.227447251193919e-18,  6.121597209674363e-20,  2.557039951034069e-22,  4.381003002064065e-25, -3.554608728146409e-27,
  1.945734719700998e+00, -4.990430555508578e-04, -3.307415008048871e-06, -1.841519305769589e-08, -8.859576258422707e-11, -3.594925780476379e-13, -1.096236342048489e-15,
 -1.090650346618929e-18,  1.696211499034823e-20,  1.759795285755681e-22,  1.121170201470424e-24,  5.356839204903801e-27,  1.977649460397172e+00, -2.110165124695161e-04,
 -1.470386533940302e-06, -8.912063788780666e-09, -4.922158985830085e-11, -2.514120090798149e-13, -1.186872291108703e-15, -5.101410762337207e-18, -1.915596092803698e-20,
 -5.539408786862276e-23, -4.915099537077096e-26,  9.123779438913833e-28,  1.995728863074352e+00, -4.092663551811377e-05, -2.932480584213700e-07, -1.860385818992680e-09,
 -1.101053756205111e-11, -6.218736342085130e-14, -3.390703001779683e-16, -1.795991269015194e-18, -9.273186978610525e-21, -4.674686288515728e-23, -2.301263049619301e-25,
 -1.105119054628400e-27,  6.672077912461799e-04, -3.878423404576845e-06,  1.690378209393640e-08, -6.546970818241705e-11,  2.376044622530801e-13, -8.274853826262789e-16,
  2.799692813772668e-18, -9.274571441504385e-21,  3.021077386630803e-23, -9.715434193103070e-26,  3.087751678716770e-28, -9.733754059481615e-31,  6.003870973812808e-03,
 -3.484468693101472e-05,  1.513307894950309e-07, -5.824795842780169e-10,  2.093624751167288e-12, -7.190714878393645e-15,  2.387133007747702e-17, -7.712507543748330e-20,
  2.432698000659042e-22, -7.512472585894906e-25,  2.269640672396607e-27, -6.722324661825991e-30,  1.667182421234208e-02, -9.645026922885907e-05,  4.159012784015412e-07,
 -1.580685678371859e-09,  5.569503608741066e-12, -1.857826912134171e-14,  5.919079752703712e-17, -1.807358122266558e-19,  5.278181413485475e-22, -1.467081455507245e-24,
  3.822942942212615e-27, -9.124733130337988e-30,  3.266010687379765e-02, -1.880367102800113e-04,  8.020512021582085e-07, -2.989310340577162e-09,  1.020667306433892e-11,
 -3.245521199132156e-14,  9.628044947135851e-17, -2.641044877817421e-19,  6.515915949464346e-22, -1.348805242751967e-24,  1.753675094795723e-27,  2.484313182183659e-30,
  5.395173493647305e-02, -3.086048835470211e-04,  1.296945473675525e-06, -4.704365407031121e-09,  1.535191950532254e-11, -4.537283762180633e-14,  1.192604150225810e-16,
 -2.625385482026496e-19,  3.823718048803333e-22,  3.148808147382895e-25, -5.598910420303186e-27,  2.945951631461416e-29,  8.052302910695885e-02, -4.568012523896825e-04,
  1.883501127697578e-06, -6.591418221307485e-09,  2.019959297881718e-11, -5.338237911116381e-14,  1.119975328640061e-16, -1.226472724051778e-19, -4.026161713351857e-22,
  3.528628113094940e-24, -1.618431326470760e-26,  5.644172281823755e-29,  1.123426845525017e-01, -6.308995402902740e-04,  2.540435651465402e-06, -8.489533929809269e-09,
  2.384878148227302e-11, -5.256578429485451e-14,  6.185700963436154e-17,  1.762909817572967e-19, -1.618180538145905e-21,  7.245404126710293e-24, -2.361092576785624e-26,
  5.412131036202244e-29,  1.493705512088232e-01, -8.287778705764281e-04,  3.242357086326834e-06, -1.021661211266104e-08,  2.537583314236794e-11, -3.965968457748877e-14,
 -3.636635022504034e-17,  6.040162029917191e-19, -2.917954485636204e-21,  9.408800389985534e-24, -1.903314832801703e-26, -4.809264777594402e-30,  1.915560839332520e-01,
 -1.047891529796606e-03,  3.959918767437932e-06, -1.157638655234475e-08,  2.392215435749034e-11, -1.273503310928677e-14, -1.769063277650880e-16,  1.069252810762340e-18,
 -3.720258536786329e-21,  7.527589984961335e-24,  4.278523658945415e-27, -1.204492871014925e-28,  2.388364107922839e-01, -1.285241679718844e-03,  4.660069303090601e-06,
 -1.236739817039134e-08,  1.879627942336830e-11,  2.812391583112527e-14, -3.405951285616262e-16,  1.423461422218447e-18, -3.337691024498704e-21, -2.166271138480199e-25,
  4.482841988989672e-26, -2.436704938335336e-28,  2.911339552731850e-01, -1.537340618527720e-03,  5.306437899971210e-06, -1.239427228276988e-08,  9.587590949474242e-12,
  8.022216888307738e-14, -4.944033419510696e-16,  1.483235439240180e-18, -1.214488310362051e-21, -1.355212424417831e-23,  8.793140314067572e-26, -2.761011522369134e-28,
  3.483535340318097e-01, -1.800174616953751e-03,  5.859906629853083e-06, -1.148161470337655e-08, -3.713486509064470e-12,  1.378488906073437e-13, -5.938807113720855e-16,
  1.074044853322472e-18,  2.758828369008935e-21, -2.889181679085994e-23,  1.057777999985334e-25, -1.096557750784475e-28,  4.103788359158883e-01, -2.069165990918825e-03,
  6.279434707459956e-06, -9.490759000195795e-09, -2.059778693160740e-11,  1.922082913259749e-13, -5.893578380187270e-16,  9.368142265054226e-20,  7.932051419311185e-21,
 -3.905935468322070e-23,  6.634070434998706e-26,  2.917459561267105e-28,  4.770681706817861e-01, -2.339137000882605e-03,  6.523214868265632e-06, -6.339407316772501e-09,
 -3.993646257171312e-11,  2.318599231336276e-13, -4.364369389981699e-16, -1.413381149114739e-18,  1.271654761743703e-20, -3.481801191658898e-23, -4.757648477571362e-26,
  7.968754519884453e-28,  5.482493577663594e-01, -2.604279496791765e-03,  6.550257230889631e-06, -2.023849084927428e-09, -5.991801145000279e-11,  2.438563860179872e-13,
 -1.105483602129307e-16, -3.189522129370759e-18,  1.471831921658634e-20, -8.761423499781718e-24, -2.137177542313380e-25,  1.067365042499062e-27,  6.237136081840424e-01,
 -2.858136091526521e-03,  6.322508877552248e-06,  3.357166359491277e-09, -7.805282996480566e-11,  2.157447644813819e-13,  3.759947998483485e-16, -4.735903086029927e-18,
  1.135803994528189e-20,  3.879973297983854e-23, -3.534670219124963e-25,  6.670421366379457e-28,  7.032082388767332e-01, -3.093601204993838e-03,  5.807622636437196e-06,
  9.578787592810935e-09, -9.128355702386594e-11,  1.385072861481709e-13,  9.580642344024578e-16, -5.362879690279964e-18,  1.053372657595078e-21,  9.400118411149760e-23,
 -3.438924738843783e-25, -6.226477131802997e-28,  7.864280534661356e-01, -3.302953744983844e-03,  4.982477213130870e-06,  1.626995385568358e-08, -9.624600530946915e-11,
  1.031184799866867e-14,  1.509182060612119e-15, -4.358688495189097e-18, -1.521648574046856e-20,  1.277985509717252e-22, -7.874026550023313e-26, -2.370702802275837e-27,
  8.730052342753623e-01, -3.477937618213401e-03,  3.837508206490284e-06,  2.290208174834936e-08, -8.972481736026993e-11, -1.594250143516264e-13,  1.849301833020008e-15,
 -1.293474428159187e-18, -3.257627725029012e-20,  1.040301288644008e-22,  4.242166954995279e-25, -3.286506410731934e-27,  9.624976302304923e-01, -3.609911717087958e-03,
  2.381813206466951e-06,  2.879424819869800e-08, -6.933158067437823e-11, -3.467198048735884e-13,  1.778904991920711e-15,  3.584350193681719e-18, -4.226936443249706e-20,
  7.233741502759499e-25,  9.235215261710522e-25, -1.757773161683681e-27,  1.054375412832896e+00, -3.690097243765150e-03,  6.488125230769607e-07,  3.314517396853374e-08,
 -3.438835025692158e-11, -5.122075025229962e-13,  1.146092229253734e-15,  9.007195058458763e-18, -3.437288589856795e-20, -1.599720751460077e-22,  9.789921791145211e-25,
  2.592114494764463e-27,  1.148006235318279e+00, -3.709956381576174e-03, -1.298059038578208e-06,  3.510418640109889e-08,  1.308865226301709e-11, -6.052069432509681e-13,
 -5.831270760246419e-17,  1.267729856564703e-17, -3.856587200507235e-21, -2.927539169400864e-22,  2.245311021345550e-25,  7.143496678396931e-27,  1.242639305802720e+00,
 -3.661740545343856e-03, -3.360622301441909e-06,  3.389267668006205e-08,  6.755214580739046e-11, -5.750380941555866e-13, -1.605731983007867e-15,  1.192202224568880e-17,
  4.175373476934453e-20, -2.740090524212583e-22, -1.149337787744000e-24,  6.686597062822090e-27,  1.337389220006177e+00, -3.539245213506528e-03, -5.403821131539648e-06,
  2.898130164039638e-08,  1.196638654852169e-10, -3.904218908798314e-13, -2.994530784318371e-15,  5.178833675793319e-18,  7.874560826626683e-20, -3.321885118869497e-23,
 -2.106441053284323e-24, -1.743528053022158e-27,  1.431221041519035e+00, -3.338795783063588e-03, -7.258574458051013e-06,  2.031213286893833e-08,  1.572007516141048e-10,
 -6.366019627544367e-14, -3.556252115947831e-15, -6.119333166561540e-18,  7.590120400273713e-20,  3.265756170851163e-22, -1.345849478727949e-24, -1.215017852000995e-26,
  1.522938999765727e+00, -3.060456419042963e-03, -8.732635996372067e-06,  8.525348543997262e-09,  1.676950992457116e-10,  3.306459254157122e-13, -2.758481169995128e-15,
 -1.663521264262749e-17,  1.893848247213592e-20,  5.113862747610958e-22,  1.118654631606301e-24, -1.116232769761788e-26,  1.611182276148437e+00, -2.709391259131038e-03,
 -9.632513174003680e-06, -4.892222612278017e-09,  1.429243966078893e-10,  6.596895541702097e-13, -6.369037161032035e-16, -1.912069939581666e-17, -6.315104965584083e-20,
  2.634023030700666e-22,  2.953283922918071e-24,  5.002956614583444e-27,  1.694432528737665e+00, -2.297206827936037e-03, -9.798108576747340e-06, -1.766105603404152e-08,
  8.425617461994207e-11,  7.763937647456327e-13,  1.921492004220815e-15, -9.872714923733304e-18, -1.036289484293431e-19, -2.722534762161082e-22,  1.571457318557574e-24,
  1.678519860958140e-26,  1.771038727134983e+00, -1.842970147514495e-03, -9.147991158143601e-06, -2.709667783577383e-08,  6.222925653459102e-12,  6.015787290370822e-13,
  3.457294384931193e-15,  5.860794418390121e-18, -5.717316787559778e-20, -5.313431040789633e-22, -1.748029444214475e-24,  4.713608055132590e-27,  1.839264928470954e+00,
 -1.373459326837248e-03, -7.726651859292261e-06, -3.088226923077384e-08, -6.544370312122861e-11,  2.031275108394152e-13,  2.931251656319848e-15,  1.562560330602637e-17,
  3.413617060537651e-20, -1.895227796726395e-22, -2.414207845888963e-24, -1.253060011521977e-26,  1.897364996479212e+00, -9.221332600824723e-04, -5.737104997008380e-06,
 -2.807214547000903e-08, -1.038053937288465e-10, -2.039357010015616e-13,  7.957802518656430e-16,  1.133668182411489e-17,  7.069317942398014e-20,  2.694448232226110e-22,
  2.314655479494305e-25, -5.956107178441383e-27,  1.943684194531041e+00, -5.264109586922706e-04, -3.537144439096807e-06, -1.989168276512737e-08, -9.605084146909508e-11,
 -3.861011988355436e-13, -1.118158669147801e-15, -4.373668453189013e-19,  2.416373011961162e-20,  2.257937345995796e-22,  1.375822466166777e-24,  6.218243355746733e-27,
  1.976781171428017e+00, -2.232211645230342e-04, -1.582227653056228e-06, -9.741432664789107e-09, -5.454661523785229e-11, -2.816821401265788e-13, -1.338595663008881e-15,
 -5.746600565030164e-18, -2.117449750703367e-20, -5.640463997213222e-23,  2.755405201278725e-27,  1.480752838787726e-27,  1.995560318817627e+00, -4.336501085581635e-05,
 -3.166722239623803e-07, -2.046964267474572e-09, -1.233991514577962e-11, -7.096365647832320e-14, -3.937786767893849e-16, -2.121535684746979e-18, -1.113418157849703e-20,
 -5.700196604117304e-23, -2.846635574401893e-25, -1.384740139315774e-27,  6.519596720547396e-04, -3.746272299893674e-06,  1.614042107306603e-08, -6.179687001725399e-11,
  2.217061973166878e-13, -7.633029174872798e-16,  2.553029962903235e-18, -8.361485109070564e-21,  2.692559214025451e-23, -8.561869087654638e-26,  2.689877371419285e-28,
 -8.387144452787108e-31,  5.866870040064362e-03, -3.366144090039826e-05,  1.445373754517195e-07, -5.501016931440129e-10,  1.955369095566041e-12, -6.642861695362307e-15,
  2.181686873448904e-17, -6.975620117788394e-20,  2.177901799976514e-22, -6.661129558514295e-25,  1.993383580986703e-27, -5.855777689647977e-30,  1.629255952584948e-02,
 -9.319744475513662e-05,  3.974557063518439e-07, -1.494470645773406e-09,  5.211743769457676e-12, -1.721655638819561e-14,  5.435892340950226e-17, -1.646619273726002e-19,
  4.776613127606806e-22, -1.321937033456917e-24,  3.440508118407426e-27, -8.269395704428044e-30,  3.192056951966096e-02, -1.817610598725665e-04,  7.671382981650777e-07,
 -2.831073328214821e-09,  9.580089131737554e-12, -3.023090853451057e-14,  8.917023474763636e-17, -2.440167420880811e-19,  6.043197169246294e-22, -1.276892750377149e-24,
  1.832203888988098e-27,  1.144917279667358e-30,  5.273771480356049e-02, -2.984510215436950e-04,  1.241937423977818e-06, -4.465841307756205e-09,  1.447249699984515e-11,
 -4.259740896716251e-14,  1.120820484251021e-16, -2.501620630169584e-19,  3.899741994287357e-22,  1.152703848573786e-25, -4.419062165854391e-27,  2.431528636798252e-29,
  7.872546681851192e-02, -4.420442173517056e-04,  1.806308507425060e-06, -6.276621061855697e-09,  1.915853959857550e-11, -5.073699063886683e-14,  1.084012708398533e-16,
 -1.336187148631756e-19, -2.866593923141684e-22,  2.928778026643487e-24, -1.386000392834977e-26,  4.932764371886970e-29,  1.098590972104454e-01, -6.109771452066428e-04,
  2.440816299535233e-06, -8.116281713998250e-09,  2.281268206544498e-11, -5.102759902564427e-14,  6.610615161216250e-17,  1.285048998162755e-19, -1.373777966764961e-21,
  6.347921312531223e-24, -2.128136062769321e-26,  5.163545060860056e-29,  1.461065506418659e-01, -8.033225696036316e-04,  3.122167507216622e-06, -9.816986189275921e-09,
  2.457522821373405e-11, -4.033977114739990e-14, -2.071126866640835e-17,  5.159139886668977e-19, -2.592960877667067e-21,  8.646670715878001e-24, -1.899457857928391e-26,
  6.014923258341428e-30,  1.874270058677254e-01, -1.016761360192065e-03,  3.823289530491733e-06, -1.119589043329580e-08,  2.362735278389049e-11, -1.663471715455785e-14,
 -1.485930075832150e-16,  9.545636080879351e-19, -3.447384092790836e-21,  7.601223851308863e-24, -3.954291822125925e-28, -9.278970850432306e-29,  2.337690725305748e-01,
 -1.248549607889068e-03,  4.513482127485579e-06, -1.206258867489104e-08,  1.928018095771520e-11,  2.041585135196283e-14, -3.022323177954895e-16,  1.316856249427885e-18,
 -3.315703920340113e-21,  1.372276209637978e-24,  3.486538999879088e-26, -2.095436105407514e-28,  2.850685576779891e-01, -1.495481314753910e-03,  5.158677937960462e-06,
 -1.222866594666285e-08,  1.107671698022576e-11,  6.885003708114585e-14, -4.534854814556819e-16,  1.437221051891367e-18, -1.641951871153382e-21, -1.027444150642027e-23,
  7.604819457890973e-26, -2.630335115533410e-28,  3.412457203113501e-01, -1.753847286938612e-03,  5.721859258767194e-06, -1.151973869310992e-08, -1.096556549659227e-12,
  1.239656764172477e-13, -5.627220996931061e-16,  1.146492001829809e-18,  1.793593827732750e-21, -2.477083952825037e-23,  9.996378506370917e-26, -1.518921692120763e-28,
  4.022019140792017e-01, -2.019391385119171e-03,  6.163692583580062e-06, -9.790337395690297e-09, -1.689471172745460e-11,  1.781225820929626e-13, -5.833888017551172e-16,
  3.255440707293108e-19,  6.576460627948426e-21, -3.618309326669182e-23,  7.666312640094670e-26,  1.806358116167875e-28,  4.678154974455024e-01, -2.287266087539410e-03,
  6.443459229291152e-06, -6.941874887036042e-09, -3.540698183326077e-11,  2.209553539027278e-13, -4.705052663744422e-16, -1.026807963141984e-18,  1.143692088366406e-20,
 -3.606079357594788e-23, -1.557248153810742e-26,  6.583184157923576e-28,  5.379368675611690e-01, -2.551990511821573e-03,  6.520379310359676e-06, -2.943693812455576e-09,
 -5.507437556060368e-11,  2.401844192122500e-13, -1.933198244500600e-16, -2.725141326967628e-18,  1.426022581022317e-20, -1.638494891307634e-23, -1.678707147332827e-25,
  1.010953515666212e-27,  6.123824495684296e-01, -2.807415775993911e-03,  6.355445660558724e-06,  2.143286208284202e-09, -7.365821956609928e-11,  2.232196414688817e-13,
  2.486687929268639e-16, -4.352765338999009e-18,  1.250788523175313e-20,  2.529953655293183e-23, -3.203939935439580e-25,  8.248820570980001e-28,  6.909274492413965e-01,
 -3.046705052830657e-03,  5.913900188500053e-06,  8.141610214991040e-09, -8.829560629107552e-11,  1.597057399434152e-13,  8.088650470287488e-16, -5.277728050339136e-18,
  4.184342122678337e-21,  7.982111189729589e-23, -3.621521968665663e-25, -2.165877277343963e-28,  7.732971577161526e-01, -3.262339120157210e-03,  5.168490107851148e-06,
  1.473359320937044e-08, -9.568771658162449e-11,  4.501689975366485e-14,  1.381007964903180e-15, -4.772808309441187e-18, -1.069639896717113e-20,  1.226919504050401e-22,
 -1.733150313868660e-25, -1.921643722433995e-27,  8.591565897378589e-01, -3.446162884516202e-03,  4.103622157296731e-06,  2.144337377013101e-08, -9.247301250453911e-11,
 -1.155906030517456e-13,  1.799075096622966e-15, -2.273002160785520e-18, -2.856063984408667e-20,  1.181055944803768e-22,  2.798523505063322e-25, -3.246359289360136e-27,
  9.480982534373313e-01, -3.589494457497598e-03,  2.720467118752117e-06,  2.763181880715493e-08, -7.583169917986098e-11, -3.029743144800254e-13,  1.860383919342491e-15,
  2.239110914384890e-18, -4.159922913888030e-20,  3.587838054355318e-23,  8.286798834674574e-25, -2.519174069548376e-27,  1.039627909672575e+00, -3.683325897290620e-03,
  1.042920341985407e-06,  3.251458511516650e-08, -4.433767379483060e-11, -4.818042098373150e-13,  1.382083932296203e-15,  7.822876756437205e-18, -3.940301391266656e-20,
 -1.189157061126808e-22,  1.064250164161385e-24,  1.278874429763577e-27,  1.133148312578838e+00, -3.718653212634981e-03, -8.759516451559950e-07,  3.521681599961934e-08,
  9.991573397188393e-13, -6.023704824685217e-13,  2.933553921255227e-16,  1.238760060112040e-17, -1.415973611864613e-20, -2.776484464273433e-22,  5.259639739747525e-25,
  6.488447131426534e-27,  1.227941174279160e+00, -3.686981188178653e-03, -2.947811166643895e-06,  3.487952713766619e-08,  5.569378790261468e-11, -6.094282978902401e-13,
 -1.254752419897768e-15,  1.309204151111990e-17,  3.113676491772635e-20, -3.136684403664690e-22, -8.238441564640540e-25,  8.028600897048817e-27,  1.323148025729855e+00,
 -3.581052750054121e-03, -5.044827961112758e-06,  3.082960552296439e-08,  1.111499506562650e-10, -4.602674866835456e-13, -2.814541760416556e-15,  7.663195518774262e-18,
  7.602195838594932e-20, -1.181998589048491e-22, -2.122160728289074e-24,  1.060509683364460e-27,  1.417751325116782e+00, -3.395846764906612e-03, -6.999794775800766e-06,
  2.281246872764820e-08,  1.550616316373261e-10, -1.507814181729672e-13, -3.691902349874727e-15, -3.513810115553151e-18,  8.656207444539153e-20,  2.622828929698917e-22,
 -1.861263542332189e-24, -1.111681932299002e-26,  1.510558164867245e+00, -3.129862198785356e-03, -8.614026939098248e-06,  1.125761950607326e-08,  1.736086807632507e-10,
  2.589387220868834e-13, -3.212959341046924e-15, -1.572700549373277e-17,  3.802664323393890e-20,  5.453474000258010e-22,  5.563295191009576e-25, -1.432429262548483e-26,
  1.600190275289278e+00, -2.786646319360297e-03, -9.677066905448613e-06, -2.500898477453954e-09,  1.559208250669587e-10,  6.377605422844499e-13, -1.198984691123313e-15,
 -2.096664429887289e-17, -5.149851934523472e-20,  3.848915162011453e-22,  3.093318419833643e-24,  1.179374689911053e-27,  1.685085623378602e+00, -2.376415313657144e-03,
 -1.000143239340753e-05, -1.618632945355445e-08,  1.002208433271805e-10,  8.188090322665834e-13,  1.597251812836676e-15, -1.333204851022203e-17, -1.121154542601959e-19,
 -1.940675897065770e-22,  2.350002414831206e-24,  1.844838186972371e-26,  1.763518422971262e+00, -1.917452080729021e-03, -9.472142102743682e-06, -2.689629827248959e-08,
  1.909639799315363e-11,  6.862981373846340e-13,  3.592813927899996e-15,  3.712185828296623e-18, -7.749854163571525e-20, -5.958302633580718e-22, -1.442644247423159e-24,
  9.337534065656662e-27,  1.833645092990274e+00, -1.436772356987285e-03, -8.103374828187650e-06, -3.189289483780551e-08, -6.064160496782064e-11,  2.788441920644115e-13,
  3.382896652525563e-15,  1.658906364296649e-17,  2.543988751761379e-20, -2.973671190589409e-22, -2.982861835455062e-24, -1.319057676502574e-26,  1.893582496015085e+00,
 -9.694061007937128e-04, -6.084066990420882e-06, -2.976451114485200e-08, -1.076660495571058e-10, -1.807632102576997e-13,  1.146345643094025e-15,  1.375528681630187e-17,
  8.048882119721629e-20,  2.725862603599419e-22, -9.755890782787662e-26, -9.138517423083164e-27,  1.941520406948136e+00, -5.556896371674543e-04, -3.785325070327725e-06,
 -2.149173299106471e-08, -1.040417306040063e-10, -4.129886820394161e-13, -1.118278695820248e-15,  4.771011142485930e-19,  3.335109386537070e-20,  2.865456764625077e-22,
  1.667733832104897e-24,  7.034480991429185e-27,  1.975862209253578e+00, -2.363618509694596e-04, -1.704553037386139e-06, -1.066104928891943e-08, -6.051495794684372e-11,
 -3.158177329083868e-13, -1.509290963971146e-15, -6.456512158768142e-18, -2.318542663504230e-20, -5.477318932678428e-23,  8.470593617180157e-26,  2.290693566425094e-27,
  1.995381631564269e+00, -4.600011069342563e-05, -3.424689833441616e-07, -2.256291528681448e-09, -1.385872321842082e-11, -8.116941965122507e-14, -4.584946703011413e-16,
 -2.512985176315136e-18, -1.340677829937452e-20, -6.970535516779337e-23, -3.530856486927662e-25, -1.739267650915591e-27,  6.372282166625057e-04, -3.620056015963675e-06,
  1.541964921851406e-08, -5.836844806133880e-11,  2.070343936744292e-13, -7.047450699582421e-16,  2.330522074269759e-18, -7.547175996888860e-21,  2.402841877312370e-23,
 -7.556214459565108e-26,  2.346749301527226e-28, -7.239716919967044e-31,  5.734495804519632e-03, -3.253102483321907e-05,  1.381195766519011e-07, -5.198508464783213e-10,
  1.827593681092139e-12, -6.141929019653231e-15,  1.995776696382923e-17, -6.315569771055945e-20,  1.951853481476888e-22, -5.913024078339060e-25,  1.752593796116520e-27,
 -5.107236088859222e-30,  1.592601742573989e-02, -9.008814181730891e-05,  3.800112484797164e-07, -1.413768047508843e-09,  4.880094073398429e-12, -1.596558445132107e-14,
  4.995541270178527e-17, -1.501123377801285e-19,  4.324632251034205e-22, -1.191356567039063e-24,  3.094266360503922e-27, -7.479763425223493e-30,  3.120558795047762e-02,
 -1.757572844296625e-04,  7.340655247846861e-07, -2.682514853750167e-09,  8.996329502550043e-12, -2.817066927259503e-14,  8.260169197727435e-17, -2.253997777883946e-19,
  5.596799537174668e-22, -1.202917029056391e-24,  1.859191898137549e-27,  1.291579987208128e-31,  5.156344778548546e-02, -2.887260098256838e-04,  1.189709040695325e-06,
 -4.240953142337429e-09,  1.364688844439447e-11, -3.999008144645267e-14,  1.052526114430272e-16, -2.376485960051900e-19,  3.911878477297158e-22, -4.142364231028353e-26,
 -3.447155345918239e-27,  1.998618960951781e-29,  7.698572111837455e-02, -4.278898921887405e-04,  1.732795242439467e-06, -5.978062281011691e-09,  1.816950808627856e-11,
 -4.818119888691411e-14,  1.045466351212159e-16, -1.412077099872978e-19, -1.906972280321514e-22,  2.415850888581483e-24, -1.183298198427694e-26,  4.292498673274214e-29,
  1.074536335115242e-01, -5.918340682792903e-04,  2.345577540595876e-06, -7.759355877731973e-09,  2.180826221227602e-11, -4.940263592923477e-14,  6.912204538545709e-17,
  8.804050719952990e-20, -1.160035824809278e-21,  5.541221143461236e-24, -1.907648781771840e-26,  4.850371980632430e-29,  1.429424783084710e-01, -7.788098218891161e-04,
  3.006696196142285e-06, -9.430259162288461e-09,  2.376458492346531e-11, -4.067258824585021e-14, -7.381569378506374e-18,  4.377737559784172e-19, -2.295269922131946e-21,
  7.894681055451622e-24, -1.854795509413174e-26,  1.384337525131562e-29,  1.834202912098077e-01, -9.867060465484055e-04,  3.691195488886534e-06, -1.082069924237210e-08,
  2.326109771647584e-11, -1.989242915685207e-14, -1.233685826923269e-16,  8.486150157158340e-19, -3.174943298606121e-21,  7.510871096761674e-24, -3.953833172973499e-27,
 -6.966400256759740e-29,  2.288461804976713e-01, -1.213015482383409e-03,  4.370594192327668e-06, -1.175122103285303e-08,  1.961888712192644e-11,  1.359280467390927e-14,
 -2.668365340458408e-16,  1.211795855462780e-18, -3.243333833223439e-21,  2.592018064626012e-24,  2.635261811479326e-26, -1.778459021290604e-28,  2.791682462740464e-01,
 -1.454795753471040e-03,  5.013040874051116e-06, -1.204100024276372e-08,  1.234810876320283e-11,  5.844303316743297e-14, -4.140304357003603e-16,  1.379325262969626e-18,
 -1.959821047982921e-21, -7.458956544588038e-24,  6.485781131879376e-26, -2.449747128469668e-28,  3.343210052330060e-01, -1.708625474874052e-03,  5.583596595510347e-06,
 -1.151817185829195e-08,  1.250334040158506e-12,  1.108512562519542e-13, -5.299454298668745e-16,  1.190377090781266e-18,  9.721231708202977e-22, -2.091494624926789e-23,
  9.263327993484428e-26, -1.790676351092208e-28,  3.942222174176034e-01, -1.970556110186187e-03,  6.044701748640590e-06, -1.003291039737783e-08, -1.347141719242059e-11,
  1.642532320582413e-13, -5.715188352673903e-16,  5.157550052785990e-19,  5.330720672404520e-21, -3.298606275421921e-23,  8.251806653822246e-26,  8.858338202238869e-29,
  4.587689877019587e-01, -2.236060922578262e-03,  6.356901478558252e-06, -7.473656325175886e-09, -3.110291618787888e-11,  2.093583734744009e-13, -4.943278504998346e-16,
 -6.816634611302035e-19,  1.013413839575514e-20, -3.614408398561102e-23,  1.043915565562440e-26,  5.253715047318075e-28,  5.278329871926724e-01, -2.499983391554393e-03,
  6.479925481020904e-06, -3.786731426452516e-09, -5.032300053436519e-11,  2.346800716830459e-13, -2.633326180947486e-16, -2.279462147714422e-18,  1.356001174766767e-20,
 -2.223345896391902e-23, -1.251753644328654e-25,  9.259126086056456e-28,  6.012546086497575e-01, -2.756489026808977e-03,  6.374242170076638e-06,  1.000753487278145e-09,
 -6.914378129595473e-11,  2.277711467859323e-13,  1.325146036833519e-16, -3.940340942043572e-18,  1.319702872466766e-20,  1.324138681169954e-23, -2.818398756243772e-25,
  9.175144717051134e-28,  6.788358366183332e-01, -2.999026821080045e-03,  6.003231818753587e-06,  6.755438254011199e-09, -8.491924466909677e-11,  1.773628698991249e-13,
  6.633752297367025e-16, -5.100660148947425e-18,  6.795831490687657e-21,  6.525066350020824e-23, -3.638579460271082e-25,  1.282464694739135e-28,  7.603315801909238e-01,
 -3.220309933981902e-03,  5.336142624390866e-06,  1.321154720117691e-08, -9.446694416678481e-11,  7.652277858671977e-14,  1.243230897759565e-15, -5.045917628313326e-18,
 -6.423394907121461e-21,  1.142066000369641e-22, -2.475133854406705e-25, -1.449939666465310e-27,  8.454391901284970e-01, -3.412329938547016e-03,  4.351996479346134e-06,
  1.994763362149136e-08, -9.435871852205100e-11, -7.327580569647181e-14,  1.723288854781698e-15, -3.117030047176697e-18, -2.414134569326586e-20,  1.264915137944492e-22,
  1.409114909551279e-25, -3.045391970577556e-27,  9.337858733929073e-01, -3.566425464131902e-03,  3.044577048297614e-06,  2.637248029813347e-08, -8.144038655211198e-11,
 -2.577217653522197e-13,  1.904681045015886e-15,  9.347712515141956e-19, -3.973930717471302e-20,  6.663219895382171e-23,  7.050465696823917e-25, -3.063350532351829e-27,
  1.024913745941338e+00, -3.673434614590703e-03,  1.428526991040282e-06,  3.172996776095177e-08, -5.362506763521248e-11, -4.461518497428812e-13,  1.582887459559607e-15,
  6.501787823390562e-18, -4.290767071636889e-20, -7.560532741895647e-23,  1.091845935935424e-24, -1.348310612186043e-29,  1.118262360160357e+00, -3.723971059393938e-03,
 -4.536499396875134e-07,  3.513692266732777e-08, -1.095005517388611e-11, -5.912279978587204e-13,  6.323941177301807e-16,  1.177916610267332e-17, -2.371009245474995e-20,
 -2.511807284283610e-22,  7.898480419839569e-25,  5.450073508014473e-27,  1.213148755544335e+00, -3.708875247833624e-03, -2.524317414973491e-06,  3.567160954544119e-08,
  4.323431094982098e-11, -6.350414832935873e-13, -8.759648156748292e-16,  1.390209338552366e-17,  1.933928736771642e-20, -3.392773979823456e-22, -4.507048383955044e-25,
  8.837494314358222e-27,  1.308745482261914e+00, -3.619902042960633e-03, -4.664517753620554e-06,  3.253076961636592e-08,  1.012878929180898e-10, -5.249712741721193e-13,
 -2.566670171248584e-15,  1.001157413396970e-17,  7.025779315314153e-20, -2.013030946255999e-22, -2.012007370828265e-24,  3.939040953127577e-27,  1.404057734290292e+00,
 -3.450708208458670e-03, -6.711274422374923e-06,  2.526448785268819e-08,  1.511536301377022e-10, -2.402465186040712e-13, -3.750197589403453e-15, -6.080446834356007e-19,
  9.455088240156371e-20,  1.785701611547872e-22, -2.309767701675436e-24, -9.112712894578055e-27,  1.497901814369625e+00, -3.198186461366478e-03, -8.462112146281783e-06,
  1.407245188118498e-08,  1.779814641938496e-10,  1.766991909444506e-13, -3.633304901276774e-15, -1.419301987168202e-17,  5.790040120424752e-20,  5.541920123758041e-22,
 -1.325701204443526e-25, -1.685452422254515e-26,  1.588888728010715e+00, -2.864139529032139e-03, -9.691693983599720e-06,  9.411015396054379e-11,  1.683398222761619e-10,
  6.017675564249029e-13, -1.806868583096933e-15, -2.236899761320902e-17, -3.541500192943636e-20,  5.083003383339522e-22,  3.041682687464571e-24, -3.682696907798159e-27,
  1.675418749186580e+00, -2.457175199087160e-03, -1.018550034965622e-05, -1.444983798966881e-08,  1.169480072039850e-10,  8.522523307825482e-13,  1.172815061272049e-15,
 -1.701177964741895e-17, -1.172118470262073e-19, -8.358674482048404e-23,  3.177697127225633e-24,  1.894308487190552e-26,  1.755695025002923e+00, -1.994513971882225e-03,
 -9.792596211126537e-06, -2.647623313255559e-08,  3.369152154217895e-11,  7.734725350982471e-13,  3.658736859725538e-15,  8.787940727717180e-19, -9.987383355839056e-20,
 -6.437368724546455e-22, -9.118910893686836e-25,  1.493515258846643e-26,  1.827765903014559e+00, -1.503146255788158e-03, -8.491712398590388e-06, -3.281397470140660e-08,
 -5.421477157715640e-11,  3.656888846871383e-13,  3.857007394179856e-15,  1.720769260124605e-17,  1.244707018918022e-20, -4.282806910055622e-22, -3.560510318206281e-24,
 -1.286607512634257e-26,  1.889605222744256e+00, -1.019536882793952e-03, -6.451691155811064e-06, -3.151445891438207e-08, -1.109734513294798e-10, -1.483290711835335e-13,
  1.569017652848338e-15,  1.648633268263765e-17,  9.012459438764170e-20,  2.595103651875071e-22, -5.859078509821766e-25, -1.321351644476727e-26,  1.939235409035084e+00,
 -5.870327774494250e-04, -4.053491150588691e-06, -2.322393026687504e-08, -1.125681436281846e-10, -4.395364600175584e-13, -1.088332427704451e-15,  1.722879503660106e-18,
  4.494402270810867e-20,  3.596533574393593e-22,  1.992374243389578e-24,  7.679984287937235e-27,  1.974888654874227e+00, -2.505269588440125e-04, -1.838510051393021e-06,
 -1.168185056616115e-08, -6.720862672493593e-11, -3.542957360191273e-13, -1.700750916472604e-15, -7.229126153157806e-18, -2.506922367533615e-20, -4.906097076754685e-23,
  2.091998927520617e-25,  3.431450872534469e-27,  1.995191974650151e+00, -4.885206151057811e-05, -3.709304951499369e-07, -2.491640910862227e-09, -1.559811053515132e-11,
 -9.306855364182295e-14, -5.352620739198365e-16, -2.985035199287987e-18, -1.618995854073061e-20, -8.548409024332950e-23, -4.391271029298360e-25, -2.189480818933223e-27,
  6.229903490974365e-04, -3.499445246186222e-06,  1.473864766332672e-08, -5.516568829044464e-11,  1.934821391859912e-13, -6.512639547845564e-16,  2.129569500214141e-18,
 -6.820039194270947e-21,  2.146974523781784e-23, -6.678229580562722e-26,  2.050303454936123e-28, -6.260586991607050e-31,  5.606542799445812e-03, -3.145053312473775e-05,
  1.320528445032221e-07, -4.915666200873654e-10,  1.709405293533180e-12, -5.683476332748465e-15,  1.827374431107880e-17, -5.723725433826474e-20,  1.751079807064606e-22,
 -5.254957284127913e-25,  1.542450845422320e-27, -4.460240183883505e-30,  1.557163943456042e-02, -8.711460916161212e-05,  3.635041908284960e-07, -1.338177295422902e-09,
  4.572439145403688e-12, -1.481556729588925e-14,  4.593972979162136e-17, -1.369364788344577e-19,  3.917249365505656e-22, -1.073950313764048e-24,  2.781317974308914e-27,
 -6.755942646816463e-30,  3.051410338903186e-02, -1.700111160728633e-04,  7.027207446631991e-07, -2.542975286089393e-09,  8.452239607845628e-12, -2.626197868844405e-14,
  7.653482695308320e-17, -2.081685501085933e-19,  5.177127107756610e-22, -1.128675931335425e-24,  1.847333534919406e-27, -6.309105485802465e-31,  5.042726193976976e-02,
 -2.794082512016492e-04,  1.140101749290705e-06, -4.028866327845405e-09,  1.287181575653577e-11, -3.754245645284679e-14,  9.877329862292737e-17, -2.251794045936359e-19,
  3.874163267096539e-22, -1.628386526210728e-25, -2.650063988432172e-27,  1.635033340115707e-29,  7.530143882240878e-02, -4.143096074889380e-04,  1.662771406156554e-06,
 -5.694924170346541e-09,  1.723065180753970e-11, -4.572013781133678e-14,  1.005198310627946e-16, -1.460062521101737e-19, -1.118070250586176e-22,  1.978573350101530e-24,
 -1.007256646168008e-26,  3.720278347733521e-29,  1.051232450441221e-01, -5.734360396918747e-04,  2.254526551580765e-06, -7.418237203949035e-09,  2.083697754503538e-11,
 -4.771814075893706e-14,  7.109644653891277e-17,  5.396794787825215e-20, -9.737817920544124e-22,  4.819831263737134e-24, -1.701860887515281e-26,  4.499158081206990e-29,
  1.398746385043950e-01, -7.552025026574433e-04,  2.895787622294636e-06, -9.056539021600626e-09,  2.295031265460986e-11, -4.071069610415685e-14,  3.889527433615705e-18,
  3.687305639346799e-19, -2.024252898311183e-21,  7.166696966545810e-24, -1.781183544209812e-26,  1.926274381327148e-29,  1.795317126694223e-01, -9.576895804247579e-04,
  3.563566534830625e-06, -1.045185746475179e-08,  2.283550705477921e-11, -2.257937248262545e-14, -1.009893385933137e-16,  7.513069308605321e-19, -2.908083264313513e-21,
  7.297305901606677e-24, -6.585524573986983e-27, -5.058494723376389e-29,  2.240631625405302e-01, -1.178609432660223e-03,  4.231470828246552e-06, -1.143548061852389e-08,
  1.982939057998707e-11,  7.584256494262993e-15, -2.343438712664275e-16,  1.109690836310814e-18, -3.132853553595855e-21,  3.498320857222759e-24,  1.917248979567303e-26,
 -1.490205112126882e-28,  2.734283616525826e-01, -1.415265950414292e-03,  4.869771148682046e-06, -1.183460651226131e-08,  1.342069281719996e-11,  4.896243855715562e-14,
 -3.763242466241858e-16,  1.312794607389094e-18, -2.184188885292612e-21, -5.074181961838677e-24,  5.453450733286708e-26, -2.239116136941021e-28,  3.275749661946642e-01,
 -1.664509070207608e-03,  5.445569519715717e-06, -1.148110997451911e-08,  3.342887343906605e-12,  9.853537730002942e-14, -4.962875441855729e-16,  1.210137414154987e-18,
  2.839334863912537e-22, -1.737238862997313e-23,  8.438606535878756e-26, -1.940110395345853e-28,  3.864359408537181e-01, -1.922683495272871e-03,  5.923119575079621e-06,
 -1.022291257293255e-08, -1.032225229156165e-11,  1.507282752694566e-13, -5.548634738087964e-16,  6.679813545853526e-19,  4.203362745164449e-21, -2.963042199197216e-23,
  8.472546472096645e-26,  1.462117396052497e-29,  4.499258749081446e-01, -2.185572592239419e-03,  6.264367795009885e-06, -7.938456093453234e-09, -2.703574911643679e-11,
  1.973009128466279e-13, -5.090691197238619e-16, -3.780664504720873e-19,  8.845700063759444e-21, -3.530121231188613e-23,  3.080885100345154e-26,  4.024528976005136e-28,
  5.179364257858919e-01, -2.448339084292273e-03,  6.429807415191418e-06, -4.554714837381819e-09, -4.569751859764693e-11,  2.276424503876362e-13, -3.212094370750209e-16,
 -1.859236649807637e-18,  1.267903341502488e-20, -2.645508895127585e-23, -8.666015716644322e-26,  8.225252964368243e-28,  5.903306903809405e-01, -2.705465513237413e-03,
  6.379764197199540e-06, -6.896747953532899e-11, -6.456524333038799e-11,  2.296756278183166e-13,  2.815393816882007e-17, -3.512504883395005e-18,  1.348066174395239e-20,
  2.789665546159533e-24, -2.404821941120380e-25,  9.539232680238661e-28,  6.669362622096535e-01, -2.950699528555885e-03,  6.076264560349181e-06,  5.425925350427704e-09,
 -8.122420966675632e-11,  1.915966977713605e-13,  5.239344779215405e-16, -4.848401826246100e-18,  8.885034880805511e-21,  5.089579273538021e-23, -3.518667942072074e-25,
  4.054120776965221e-28,  7.475366867055940e-01, -3.177012207122677e-03,  5.485667988450573e-06,  1.171389250511454e-08, -9.264966149853500e-11,  1.046453925298450e-13,
  1.099671304222810e-15, -5.187710568468493e-18, -2.504282884839857e-21,  1.031681721148988e-22, -3.010251957192248e-25, -9.858657165577339e-28,  8.318609819757450e-01,
 -3.376582242802888e-03,  4.582268478223637e-06,  1.842838597444473e-08, -9.541814791240543e-11, -3.304725027370811e-14,  1.625887525343695e-15, -3.815863135911250e-18,
 -1.951769934253913e-20,  1.295362617619619e-22,  1.370681135321954e-26, -2.719112389606379e-27,  9.195708573084406e-01, -3.540825496043194e-03,  3.353066501931295e-06,
  2.503068867891122e-08, -8.613631090249114e-11, -2.118366300720587e-13,  1.913449288371613e-15, -2.933340079860377e-19, -3.686642777438489e-20,  9.202844667046489e-23,
  5.624530325031372e-25, -3.381039695241347e-27,  1.010245253923521e+00, -3.660498610672980e-03,  1.803850985915017e-06,  3.080270554444334e-08, -6.215427701942895e-11,
 -4.061353181500212e-13,  1.745365687790147e-15,  5.093599901751479e-18, -4.484676355460830e-20, -3.230245996271666e-23,  1.064662119937959e-24, -1.197989719120430e-27,
  1.103361882547647e+00, -3.725917557797226e-03, -3.344530976466185e-08,  3.486806043722195e-08, -2.259660311375771e-11, -5.721866009772040e-13,  9.502753394355724e-16,
  1.088230773193281e-17, -3.212948295404081e-20, -2.151641502187274e-22,  1.001299573765465e-24,  4.122663725216752e-27,  1.198275591837497e+00, -3.727346762185208e-03,
 -2.092530069699035e-06,  3.626074308565413e-08,  3.035509280558895e-11, -6.513349957769936e-13, -4.798987342239088e-16,  1.432281518990990e-17,  6.895557173553854e-21,
 -3.494218028800418e-22, -5.496864187884605e-26,  9.049739259522480e-27,  1.294193751960220e+00, -3.655629976950868e-03, -4.264781931933802e-06,  3.406413335102659e-08,
  9.019645541341870e-11, -5.829606593617734e-13, -2.256068591027714e-15,  1.212872857171058e-17,  6.161148985885329e-20, -2.774986627134665e-22, -1.777998577882002e-24,
  6.649982738950293e-27,  1.390149498688289e+00, -3.503144991583237e-03, -6.393764224042272e-06,  2.763961666643857e-08,  1.454490630900705e-10, -3.301083839042743e-13,
 -3.724029069754270e-15,  2.501870559348364e-18,  9.922685564853983e-20,  7.895331720854149e-23, -2.649941069034178e-24, -6.213994887435548e-27,  1.484974812895576e+00,
 -3.265159232741466e-03, -8.276055588366040e-06,  1.694355823390343e-08,  1.806124250867593e-10,  8.495874798984948e-14, -4.001786656211320e-15, -1.202350005565890e-17,
  7.757211609603936e-20,  5.335214650815471e-22, -9.121762116292533e-25, -1.838977695631170e-26,  1.577277175771072e+00, -2.941621876868820e-03, -9.674015091358912e-06,
  2.881258930663543e-09,  1.798902049993046e-10,  5.507764046059077e-13, -2.446150407480772e-15, -2.318642779073040e-17, -1.497988521569627e-20,  6.251075854908365e-22,
  2.757421411331914e-24, -9.340940557514843e-27,  1.665426028824397e+00, -2.539319679725434e-03, -1.034710441725798e-05, -1.244094975479420e-08,  1.342337477881723e-10,
  8.742582331056009e-13,  6.437062517284891e-16, -2.078455210747722e-17, -1.177337521968080e-19,  5.999047538447637e-23,  3.992947757717800e-24,  1.780827341066938e-26,
  1.747558289908945e+00, -2.074115229978482e-03, -1.010655066965631e-05, -2.580864059711000e-08,  5.003910407761049e-11,  8.611947196242897e-13,  3.635073497848602e-15,
 -2.693607136635177e-18, -1.235300168585535e-19, -6.652447924032250e-22, -1.172547684978759e-25,  2.127831778449703e-26,  1.821614936687477e+00, -1.572669182840818e-03,
 -8.890426617277788e-06, -3.361770685276961e-08, -4.593611657178265e-11,  4.640685993766005e-13,  4.341878940081507e-15,  1.733073661944188e-17, -5.667567276722721e-21,
 -5.816191321258924e-22, -4.093376217556043e-24, -1.106729505776796e-26,  1.885421410162376e+00, -1.072693502211162e-03, -6.840608940573354e-06, -3.331155786626053e-08,
 -1.135243573181736e-10, -1.047989082434610e-13,  2.072376014841509e-15,  1.951405418168631e-17,  9.889227975154144e-20,  2.230358071082528e-22, -1.274442530529934e-24,
 -1.824124311128872e-26,  1.936820612929677e+00, -6.206067510639280e-04, -4.343279494559635e-06, -2.509674609958137e-08, -1.216152723834556e-10, -4.649025032509626e-13,
 -1.017896908698358e-15,  3.384298274040504e-18,  5.940861286932797e-20,  4.462234972807855e-22,  2.338181331089396e-24,  7.956559445169848e-27,  1.973856216520689e+00,
 -2.658146021154541e-04, -1.985385497524616e-06, -1.281616416317478e-08, -7.471959250711564e-11, -3.976349611680487e-13, -1.914649631663627e-15, -8.057664992154878e-18,
 -2.664455006526899e-20, -3.724265136952986e-23,  3.932780020428144e-25,  5.021348487178463e-27,  1.994990435969403e+00, -5.194349306599919e-05, -4.023913711482227e-07,
 -2.756829138185041e-09, -1.759502964703511e-11, -1.069793277144304e-13, -6.265841072879434e-16, -3.555940513147036e-18, -1.960820142380146e-20, -1.051344934419034e-22,
 -5.475583239119251e-25, -2.761904464060905e-27,  6.092242668973436e-04, -3.384132362971956e-06,  1.409481267619314e-08, -5.217146289554746e-11,  1.809528809232184e-13,
 -6.023703515115461e-16,  1.947876403293132e-18, -6.169943446079775e-21,  1.920680034840349e-23, -5.910643460783413e-26,  1.793717514287841e-28, -5.424041350935855e-31,
  5.482816798609506e-03, -3.041724909496495e-05,  1.263144726023568e-07, -4.651021963680846e-10,  1.599994851181508e-12, -5.263522059956298e-15,  1.674678830615960e-17,
 -5.192495031438950e-20,  1.572549666466539e-22, -4.675521200939680e-25,  1.358802779037600e-27, -3.900801544513685e-30,  1.522889709010151e-02, -8.426958657854804e-05,
  3.478754297147554e-07, -1.267330133057437e-09,  4.286849934413024e-12, -1.375764293080040e-14,  4.227533871179724e-17, -1.249989739338271e-19,  3.549954513799710e-22,
 -9.684441520948041e-25,  2.498791763950408e-27, -6.096642532374204e-30,  2.984511238436922e-02, -1.645091531996249e-04,  6.729994412748126e-07, -2.411843516099767e-09,
  7.944905783821614e-12, -2.449325246118943e-14,  7.093203575921758e-17, -1.922376644721630e-19,  4.784021262930748e-22, -1.055515416231684e-24,  1.806620838335792e-27,
 -1.190626293844404e-30,  4.932756923769431e-02, -2.704773778954415e-04,  1.092966681069482e-06, -3.828797386972340e-09,  1.214416872675470e-11, -3.524616278271973e-14,
  9.264081853622978e-17, -2.128949853613807e-19,  3.798108676919001e-22, -2.553896538482622e-25, -1.999684169500309e-27,  1.330106116512187e-29,  7.367037844672603e-02,
 -4.012761745125035e-04,  1.596056704177091e-06, -5.426419282053057e-09,  1.634004084855149e-11, -4.335706114803361e-14,  9.639173818725496e-17, -1.485190701815272e-19,
 -4.745024911506039e-23,  1.606867690275349e-24, -8.549753632325739e-27,  3.211675666199018e-29,  1.028650174306862e-01, -5.557503069340703e-04,  2.167476862571891e-06,
 -7.092387303551214e-09,  1.989978274184405e-11, -4.599705828219215e-14,  7.219646516991524e-17,  2.545557737705728e-20, -8.120539910702292e-22,  4.177599568182969e-24,
 -1.511990981978287e-26,  4.129579085210197e-29,  1.368994815301543e-01, -7.324647348974836e-04,  2.789285540701178e-06, -8.695839276929507e-09,  2.213783166464563e-11,
 -4.050054015555689e-14,  1.334493368322793e-17,  3.079467107237382e-19, -1.778861319424870e-21,  6.472330227979144e-24, -1.688102388910100e-26,  2.276731915496445e-29,
  1.757571857936635e-01, -9.296765611879779e-04,  3.440321144060371e-06, -1.009022677522636e-08,  2.236133280483080e-11, -2.476095229160662e-14, -8.121645905004890e-17,
  6.623966134793476e-19, -2.650613993939836e-21,  6.994180759090369e-24, -8.457728618982707e-27, -3.506202087550410e-29,  2.194155668738611e-01, -1.145301165915367e-03,
  4.096152726438719e-06, -1.111729211062752e-08,  1.992729192490149e-11,  2.321652657502031e-15, -2.046561300357409e-16,  1.011590213190585e-18, -2.994618561947317e-21,
  4.141886643004632e-24,  1.319330985709707e-26, -1.232758957092712e-28,  2.678443200069349e-01, -1.376872120612826e-03,  4.729075016463117e-06, -1.161251981014205e-08,
  1.431255970625155e-11,  4.036370339367872e-14, -3.405690838236259e-16,  1.240379961460291e-18, -2.329909299564520e-21, -3.083278964609781e-24,  4.517471216931671e-26,
 -2.014036974969906e-28,  3.210031879376982e-01, -1.621494552436831e-03,  5.308180085743799e-06, -1.141249374380172e-08,  5.197233408374883e-12,  8.703155411413094e-14,
 -4.623659665736680e-16,  1.209851410143626e-18, -2.827928104139475e-22, -1.416985567651582e-23,  7.570215426143787e-26, -1.993240503383847e-28,  3.788391961769052e-01,
 -1.875791821689544e-03,  5.799550842909532e-06, -1.036466900728067e-08, -7.439264583036861e-12,  1.376502307620407e-13, -5.344325840830231e-16,  7.860760761190173e-19,
  3.197658592948568e-21, -2.624658002225221e-23,  8.404851409253838e-26, -4.281740554875567e-29,  4.412832011094555e-01, -2.135845753926616e-03,  6.166638949786189e-06,
 -8.340126798067909e-09, -2.321260454385980e-11,  1.849870447615053e-13, -5.158812704798734e-16, -1.150670836968241e-19,  7.601000534109223e-21, -3.374810090596924e-23,
  4.604466722264040e-26,  2.923537733046663e-28,  5.082455831138554e-01, -2.397131337797321e-03,  6.370912716184186e-06, -5.249888086564850e-09, -4.122574347360061e-11,
  2.193536655641648e-13, -3.677354005993138e-16, -1.469345892895682e-18,  1.167267902454292e-20, -2.923049061887950e-23, -5.293348431246977e-26,  7.095641692368766e-28,
  5.796108749809364e-01, -2.654447922661997e-03,  6.372889939667204e-06, -1.065259121130932e-09, -5.997268810472999e-11,  2.292198952214234e-13, -6.415452465361917e-17,
 -3.081291216444127e-18,  1.341806466672979e-20, -5.990031095290593e-24, -1.985744587132763e-25,  9.442277849855270e-28,  6.552310658979004e-01, -2.901850765202281e-03,
  6.133706682666315e-06,  4.157631119937145e-09, -7.727735473488315e-11,  2.025757873333314e-13,  3.924160258743747e-16, -4.537442191456535e-18,  1.046885058808403e-20,
  3.724416126242785e-23, -3.291970521050804e-25,  6.138484942772359e-28,  7.349172634644244e-01, -3.132589628951046e-03,  5.617413906738068e-06,  1.024962564851846e-08,
 -9.030463080866119e-11,  1.292887243384378e-13,  9.538348145037738e-16, -5.210823667614676e-18,  9.837697650563944e-22,  9.038982255892344e-23, -3.347420531523641e-25,
 -5.536193755854383e-28,  8.184293331678493e-01, -3.339065522829178e-03,  4.794233922086668e-06,  1.689849066354950e-08, -9.569788075585762e-11,  4.625651329040050e-15,
  1.510999911144228e-15, -4.365937953220297e-18, -1.487230619303341e-20,  1.278083244357003e-22, -9.709034740410879e-26, -2.305990618769425e-27,  9.054630732401663e-01,
 -3.512823225852121e-03,  3.645033937150281e-06,  2.362110383128056e-08, -8.991515638369164e-11, -1.661425071671590e-13,  1.889247091540235e-15, -1.416003124842271e-18,
 -3.318472334486102e-20,  1.115066651678408e-22,  4.107329096389955e-25, -3.480958660713732e-27,  9.956344374399936e-01, -3.644606781192967e-03,  2.167256090416266e-06,
  2.974557698070697e-08, -6.984738492783725e-11, -3.626980415309855e-13,  1.867778222645340e-15,  3.647994439623732e-18, -4.525865759190135e-20,  8.918635409546919e-24,
  9.890548763278326e-25, -2.204690800711157e-27,  1.088460317351095e+00, -3.724518460817763e-03,  3.824287902338883e-07,  3.441630551076194e-08, -3.378821775195834e-11,
 -5.458465901853481e-13,  1.239478519393429e-15,  9.738288805940351e-18, -3.911467137411549e-20, -1.719178996964486e-22,  1.150053619120541e-24,  2.619889199850962e-27,
  1.183335490470901e+00, -3.742339223906083e-03, -1.654918598631217e-06,  3.664172183621761e-08,  1.724578088658887e-11, -6.580267842709984e-13, -7.766030060525968e-17,
  1.434255705461504e-17, -5.627824936517302e-21, -3.437292827666143e-22,  3.367317020238467e-25,  8.657425837346420e-27,  1.279505617859467e+00, -3.688089525194126e-03,
 -3.847747430796855e-06,  3.541118036947903e-08,  7.802440420642979e-11, -6.328179720764513e-13, -1.890458397819445e-15,  1.392734670173644e-17,  5.041847498842604e-20,
 -3.420508185711358e-22, -1.432784762785401e-24,  8.956692479684790e-27,  1.376036774256574e+00, -3.552929374800582e-03, -6.048359235143428e-06,  2.990915850001376e-08,
  1.379606654707074e-10, -4.182837660017555e-13, -3.609244423339061e-15,  5.701674843228184e-18,  1.001045269020718e-19, -3.149297168358553e-23, -2.846030926660481e-24,
 -2.601596734011754e-27,  1.471783116267676e+00, -3.330505165386384e-03, -8.055355227640466e-06,  1.984162291247743e-08,  1.813254258845127e-10, -1.482607114532638e-14,
 -4.300864366862850e-15, -9.242520817033098e-18,  9.592538585227700e-20,  4.806811749513473e-22, -1.731501010982164e-24, -1.861455004058738e-26,  1.565356193151964e+00,
 -3.018825951677804e-03, -9.621817949498707e-06,  5.844215219531269e-09,  1.902658811709561e-10,  4.842455206218799e-13, -3.098551697919256e-15, -2.328534431503972e-17,
  9.394203775351056e-21,  7.254156789277677e-22,  2.213878188728350e-24, -1.538756392130287e-26,  1.655102304226046e+00, -2.622655835759682e-03, -1.048293020408643e-05,
 -1.015269457148565e-08,  1.518240749799087e-10,  8.823009831735350e-13,  9.547179737269196e-18, -2.448516284598907e-17, -1.125171141972871e-19,  2.346043212085944e-22,
  4.714625434498302e-24,  1.462933041066596e-26,  1.739098183701080e+00, -2.156191499796703e-03, -1.041086694979509e-05, -2.486551760373426e-08,  6.812690461083908e-11,
  9.470626334663403e-13,  3.500715472399555e-15, -7.028705789090465e-18, -1.473198376880991e-19, -6.492557534648765e-22,  9.651956097350960e-25,  2.792484361422376e-26,
  1.815179441522373e+00, -1.645417997346284e-03, -9.297923891973609e-06, -3.427260757101911e-08, -3.557357973032029e-11,  5.740558281303231e-13,  4.821222219720452e-15,
  1.678186289863492e-17, -2.966198309849193e-20, -7.541325558363132e-22, -4.504440920114473e-24, -7.233586700186859e-27,  1.881018610951987e+00, -1.129048347926930e-03,
 -7.251305863547499e-06, -3.514182073177534e-08, -1.150768291944571e-10, -4.814054059454321e-14,  2.664200616481539e-15,  2.279556743356798e-17,  1.057952972420534e-19,
  1.543193718017768e-22, -2.204662818875349e-24, -2.418086511160760e-26,  1.934266738458227e+00, -6.565914252863676e-04, -4.656426551387986e-06, -2.711826591583807e-08,
 -1.311487664979122e-10, -4.879645778355226e-13, -8.939738863751560e-16,  5.561132010450227e-18,  7.724013051709856e-20,  5.466985328609287e-22,  2.682771180179675e-24,
  7.565397203361165e-27,  1.972760188405701e+00, -2.823338067186273e-04, -2.146623288718848e-06, -1.407787439726447e-08, -8.315058518501706e-11, -4.463913934157868e-13,
 -2.152378248520178e-15, -8.928239358293363e-18, -2.764353965089805e-20, -1.649697895506781e-23,  6.599607788772565e-25,  7.215139566343769e-27,  1.994776007238410e+00,
 -5.529990577228981e-05, -4.372357923688740e-07, -3.056318545151793e-09, -1.989344310858621e-11, -1.232866999846810e-13, -7.355354760166634e-16, -4.248437119007519e-18,
 -2.381838768034576e-20, -1.296690492318495e-22, -6.844694024563854e-25, -3.490258945307254e-27,  5.959093577162890e-04, -3.273829771984939e-06,  1.348573710387452e-08,
 -4.937011353923420e-11,  1.693593215681516e-13, -5.576268847800043e-16,  1.783412358114007e-18, -5.588031747803696e-21,  1.720256531731696e-23, -5.238701019910619e-26,
  1.571202838973485e-28, -4.708682047931726e-31,  5.363134090050062e-03, -2.942863088206029e-05,  1.208834412390557e-07, -4.403230887575300e-10,  1.498628747511148e-12,
 -4.878492475714912e-15,  1.536088241840976e-17, -4.715193823439520e-20,  1.413614166122890e-22, -4.164852045934274e-25,  1.198065026839815e-27, -3.417069101829427e-30,
  1.489729005259677e-02, -8.154626952331074e-05,  3.330701010417011e-07, -1.200887797235612e-09,  4.021566159338775e-12, -1.278378233083723e-14,  3.892929873210928e-17,
 -1.141781664829778e-19,  3.218675912323558e-22, -8.736773990513922e-25,  2.243892773735916e-27, -5.499777490740631e-30,  2.919766346502930e-02, -1.592388017815946e-04,
  6.448041591806209e-07, -2.288553248002194e-09,  7.471637221351025e-12, -2.285378017085030e-14,  6.575809166087689e-17, -1.775229365855534e-19,  4.416905203044716e-22,
 -9.844273180771455e-25,  1.744841492990458e-27, -1.595231533764499e-30,  4.826286079811224e-02, -2.619141763068434e-04,  1.048164075992373e-06, -3.640011271927410e-09,
  1.146100348165657e-11, -3.309295147658483e-14,  8.684842837865466e-17, -2.009024824985921e-19,  3.693109031437027e-22, -3.244572522285462e-25, -1.472301467449722e-27,
  1.074520656108872e-29,  7.209040443678566e-02, -3.887638096066465e-04,  1.532480104342999e-06, -5.171791479759904e-09,  1.549569613319517e-11, -4.109368226126415e-14,
  9.222018790285304e-17, -1.491752448930796e-19,  4.569223842832266e-24,  1.291774640999674e-24, -7.237684429281694e-27,  2.761438552157784e-29,  1.006761643614261e-01,
 -5.387455831860453e-04,  2.084248541510675e-06, -6.781255973568791e-09,  1.899721186020018e-11, -4.425859155410598e-14,  7.256721837863501e-17,  1.762909498189979e-21,
 -6.721188656886147e-22,  3.608042485434567e-24, -1.338518082001407e-26,  3.755775087569376e-29,  1.340135986953544e-01, -7.105618908006227e-04,  2.687034034967979e-06,
 -8.348093836287599e-09,  2.133168972219618e-11, -4.008301332926516e-14,  2.120462239470586e-17,  2.546228916139357e-19, -1.557763924770617e-21,  5.817810008286558e-24,
 -1.583046039401002e-26,  2.476713517644460e-29,  1.720927663662831e-01, -9.026322789322788e-04,  3.321368442241691e-06, -9.736506972444873e-09,  2.184807556821267e-11,
 -2.649693641718388e-14, -6.381945826280862e-17,  5.815375382358895e-19, -2.405249240406409e-21,  6.628886357060739e-24, -9.716455848787302e-27, -2.262455887087902e-29,
  2.148990633942282e-01, -1.113060152059672e-03,  3.964658934807662e-06, -1.079834140967838e-08,  1.992684642710504e-11, -2.260887530244936e-15, -1.776501105297622e-16,
  9.182398050436651e-19, -2.837255592419367e-21,  4.568020657880595e-24,  8.278172408500143e-27, -1.006500966468076e-28,  2.624116197465894e-01, -1.339592969890235e-03,
  4.591124017850898e-06, -1.137749310873610e-08,  1.504086644324025e-11,  3.259829758155541e-14, -3.068965429775179e-16,  1.164378712398103e-18, -2.410456078587215e-21,
 -1.446810575931333e-24,  3.681460450750221e-26, -1.786399101213103e-28,  3.146012754250824e-01, -1.579575369375211e-03,  5.171784614430856e-06, -1.131600439227641e-08,
  6.829633391412819e-12,  7.633980753482328e-14, -4.286894382585162e-16,  1.193207467965356e-18, -7.405153504211824e-22, -1.131704374791817e-23,  6.695326392744160e-26,
 -1.973208720558871e-28,  3.714280314023053e-01, -1.829894737799986e-03,  5.674549258055507e-06, -1.046236242325997e-08, -4.812684830307636e-12,  1.250986830641252e-13,
 -5.111273488277720e-16,  8.739274571786630e-19,  2.312717005057466e-21, -2.293591641088936e-23,  8.117293830254711e-26, -8.565090367746410e-29,  4.328378419188730e-01,
 -2.086919005436787e-03,  6.064448928706357e-06, -8.682603867979678e-09, -1.963679879374434e-11,  1.725936076497854e-13, -5.158778740124721e-16,  1.091048811367218e-19,
  6.422052810170542e-21, -3.167831123758701e-23,  5.674675461173755e-26,  1.965155472366729e-28,  4.987585779795242e-01, -2.346426913862517e-03,  6.304099571456849e-06,
 -5.874896163993564e-09, -3.693004517042639e-11,  2.100755386785515e-13, -4.038084905683045e-16, -1.113006539742250e-18,  1.058948393089381e-20, -3.075741345794075e-23,
 -2.425390398322673e-26,  5.941480343038719e-28,  5.690949459986163e-01, -2.603531900425013e-03,  6.354500388241918e-06, -1.988259069112075e-09, -5.541042593659003e-11,
  2.266931404433955e-13, -1.444622656462253e-16, -2.656815756854449e-18,  1.306936532535686e-20, -1.311322090608168e-23, -1.579173583678382e-25,  8.987566382071604e-28,
  6.437220888593664e-01, -2.852602253859575e-03,  6.176314871280351e-06,  2.954074780246650e-09, -7.314174948831703e-11,  2.105081961325309e-13,  2.702414562361883e-16,
 -4.183472026220951e-18,  1.157956062177879e-20,  2.466310193324614e-23, -2.988158867602346e-25,  7.567453893125997e-28,  7.224775281346731e-01, -3.087182694171737e-03,
  5.731829394211288e-06,  8.826632046621458e-09, -8.750172331063593e-11,  1.504363937324954e-13,  8.088430050223490e-16, -5.129903290688048e-18,  3.991988349655368e-21,
  7.662968293558435e-23, -3.504753112020413e-25, -1.707808682329117e-28,  8.051510263817293e-01, -3.299926534102111e-03,  4.987838133112522e-06,  1.536999254243577e-08,
 -9.525288970362754e-11,  3.937313563563591e-14,  1.382776099595943e-15, -4.769174207080673e-18, -1.036435176985710e-20,  1.220291192976013e-22, -1.885005813404090e-25,
 -1.843935468920000e-27,  8.914718612433440e-01, -3.482553834899989e-03,  3.919753612313533e-06,  2.215832651554312e-08, -9.278840274743175e-11, -1.213925348651096e-13,
  1.835356596347504e-15, -2.410814535441127e-18, -2.891155730197081e-20,  1.248874791179128e-22,  2.589999128291915e-25, -3.386475949379502e-27,  9.810929195484052e-01,
 -3.625860478579987e-03,  2.517266261836869e-06,  2.857245450901915e-08, -7.664564889026982e-11, -3.168087286855064e-13,  1.949747719787451e-15,  2.212285155689233e-18,
 -4.425112822868278e-20,  4.629340464534741e-23,  8.739963477925575e-25, -2.985148402389375e-27,  1.073570963952911e+00, -3.719817056962868e-03,  7.918260112998202e-07,
  3.379006494607588e-08, -4.438634234167367e-11, -5.129738755088056e-13,  1.493761283683784e-15,  8.396671081475611e-18, -4.445206908175737e-20, -1.240687760169971e-22,
  1.231044934381587e-24,  1.062340655922692e-27,  1.168342444952248e+00, -3.753816079377350e-03, -1.213996595466439e-06,  3.681240480553544e-08,  4.098982353386472e-12,
 -6.551032051982731e-13,  3.195725512622503e-16,  1.396780952956967e-17, -1.766996105223835e-20, -3.228831631853846e-22,  6.986487536528766e-25,  7.708104125029515e-27,
  1.264694415723353e+00, -3.717151522573037e-03, -3.415748198868599e-06,  3.655599052242310e-08,  6.494681453278477e-11, -6.733388256458245e-13, -1.479830620619716e-15,
  1.533346022810060e-17,  3.717311116364717e-20, -3.909303415722614e-22, -9.988021592356924e-25,  1.065536356628748e-26,  1.361730608206152e+00, -3.599843749845700e-03,
 -5.676496258047856e-06,  3.204495806143776e-08,  1.287435663206302e-10, -5.026297288171922e-13, -3.405078740364871e-15,  8.864754140300303e-18,  9.690467489396164e-20,
 -1.464520649959708e-22, -2.872376178414252e-24,  1.449756027673856e-27,  1.458333787438681e+00, -3.393946348175215e-03, -7.799876688820807e-06,  2.273476767960104e-08,
  1.799775936133604e-10, -1.207899647098287e-13, -4.514183446011192e-15, -5.910991513971706e-18,  1.117880738000208e-19,  3.953081199199973e-22, -2.527679427974159e-24,
 -1.731283096062540e-26,  1.553127458416538e+00, -3.095467511918301e-03, -9.533115932051839e-06,  8.961687339576776e-09,  1.991546080846724e-10,  4.021150801451546e-13,
 -3.742293126111052e-15, -2.255122959333486e-17,  3.692388678593599e-20,  7.986665575555767e-22,  1.405803955644428e-24, -2.126166180139982e-26,  1.644443242462186e+00,
 -2.706963970591642e-03, -1.058960572305480e-05, -7.582569070686386e-09,  1.694147888483673e-10,  8.739053737051074e-13, -7.249089878737635e-16, -2.791300568570759e-17,
 -1.005345613896244e-19,  4.346166424244033e-22,  5.245882509523766e-24,  9.121363989430037e-27,  1.730304982146910e+00, -2.240651980900807e-03, -1.070207333633659e-05,
 -2.361946894643046e-08,  8.788954429745869e-11,  1.028164182314257e-12,  3.234466259287546e-15, -1.210694270517148e-17, -1.696846119214511e-19, -5.841750267369381e-22,
  2.334530817804685e-24,  3.418294688197222e-26,  1.808446385575103e+00, -1.721455235464729e-03, -9.712210573632175e-06, -3.474349154036121e-08, -2.289797391582345e-11,
  6.952702672267040e-13,  5.273493389473638e-15,  1.536299945157121e-17, -6.011563916940690e-20, -9.389866942579743e-22, -4.691371907435130e-24, -7.868142421361242e-28,
  1.876383681631890e+00, -1.188776952624918e-03, -7.684074997447552e-06, -3.698705441201343e-08, -1.153465350140649e-10,  2.384661180510711e-14,  3.350574017801826e-15,
  2.625068999138773e-17,  1.094896585141944e-19,  4.293817396394397e-23, -3.412813876101424e-24, -3.082115991519869e-26,  1.931563757595848e+00, -6.951809359217421e-04,
 -4.994761699453147e-06, -2.929582804700655e-08, -1.411084757589038e-10, -5.072531688029965e-13, -7.005485377262505e-16,  8.369057978326888e-18,  9.893015301920079e-20,
  6.603256817519792e-22,  2.987789493303570e-24,  6.073455239187019e-27,  1.971595404439866e+00, -3.002058451377906e-04, -2.323844184211208e-06, -1.548259988473591e-08,
 -9.261575129550821e-11, -5.011486692005036e-13, -2.414802384693230e-15, -9.816571405051925e-18, -2.767843315287233e-20,  1.706674074849222e-23,  1.040021260553753e-24,
  1.021169705182074e-26,  1.994547571668183e+00, -5.895010025246352e-05, -4.759059759378682e-07, -3.395340696952403e-09, -2.254580521229493e-11, -1.424576635147128e-13,
 -8.659036086050949e-16, -5.090914456303757e-18, -2.901861231120595e-20, -1.603760036458930e-22, -8.576229610838759e-25, -4.417141563171464e-27,  5.830261222285934e-04,
 -3.168268407611798e-06,  1.290919359295441e-08, -4.674731122682465e-11,  1.586224434240607e-13, -5.166420625937756e-16,  1.634379118711141e-18, -5.066550998294586e-21,
  1.542493807216387e-23, -4.649785467582315e-26,  1.377830172909911e-28, -4.096744684525683e-31,  5.247320802885098e-03, -2.848229852075190e-05,  1.157402764083011e-07,
 -4.171059968670690e-10,  1.404641153335374e-12, -4.525176716464227e-15,  1.410176832078587e-17, -4.285930568648735e-20,  1.271954904445975e-22, -3.714421250351445e-25,
  1.057132477977830e-27, -2.999061550573268e-30,  1.457634434771928e-02, -7.893827657010197e-05,  3.190372420467942e-07, -1.138538446456503e-09,  3.774980482291223e-12,
 -1.188670760620616e-14,  3.587189921997743e-17, -1.043647824304037e-19,  2.919739732473503e-22, -7.885992133517279e-25,  2.013926036325923e-27, -4.962964284563299e-30,
  2.857085401840435e-02, -1.541882209676481e-04,  6.180439870956506e-07, -2.172579570434791e-09,  7.029949055009729e-12, -2.133366879266564e-14,  6.098009428187828e-17,
 -1.639425428320382e-19,  4.074896570585528e-22, -9.161292948548493e-25,  1.667974381907079e-27, -1.882035632541993e-30,  4.723170241286653e-02, -2.537005164219147e-04,
  1.005562717394922e-06, -3.461818726814328e-09,  1.081953928258016e-11, -3.107476817834790e-14,  8.138677831436574e-17, -1.892819023129959e-19,  3.566782827964416e-22,
 -3.745519058453519e-25, -1.048038325054046e-27,  8.601212882869556e-30,  7.055948169284726e-02, -3.767480616217379e-04,  1.471879457243979e-06, -4.930316494985494e-09,
  1.469561726425287e-11, -3.893046308213928e-14,  8.805193418612860e-17, -1.483385387750457e-19,  4.614375063339313e-23,  1.025361452624949e-24, -6.111927266983632e-27,
  2.363828418985902e-29,  9.855402183690161e-02, -5.223919945574240e-04,  2.004668297963813e-06, -6.484287356242565e-09,  1.812944809534671e-11, -4.251869995490969e-14,
  7.233427899846196e-17, -1.776682834756818e-20, -5.514783449449276e-22,  3.104595448241843e-24, -1.181400601502696e-26,  3.387426750361686e-29,  1.312137173328628e-01,
 -6.894605855403195e-04,  2.588878392310002e-06, -8.013170106933592e-09,  2.053566774368876e-11, -3.949399276709139e-14,  2.766681224987838e-17,  2.080054455870254e-19,
 -1.359455022002974e-21,  5.206705802131644e-24, -1.471874029337490e-26,  2.559648283004033e-29,  1.685346475070128e-01, -8.765227818416298e-04,  3.206610031031856e-06,
 -9.391255111195109e-09,  2.130409507351975e-11, -2.784168640717901e-14, -4.857862846867655e-17,  5.083110294924794e-19, -2.173816913319876e-21,  6.223377646617639e-24,
 -1.048774093295162e-26, -1.283728608126581e-29,  2.105094443005337e-01, -1.081855785765591e-03,  3.836989596013893e-06, -1.048009670556447e-08,  1.984102284767167e-11,
 -6.226067096969990e-15, -1.531853571217129e-16,  8.301344132924293e-19, -2.667859013738577e-21,  4.816556444644968e-24,  4.291251579386189e-27, -8.106389764672955e-29,
  2.571258469996487e-01, -1.303405959297195e-03,  4.456058272179195e-06, -1.113201278357209e-08,  1.562177282044818e-11,  2.561525724932601e-14, -2.753797143193688e-16,
  1.086679984700009e-18, -2.437868957671673e-21, -1.248431185050833e-25,  2.944510431071940e-26, -1.564983860068532e-28,  3.083648652561363e-01, -1.538742290549476e-03,
  5.036696810929481e-06, -1.119506359331854e-08,  8.256234901197134e-12,  6.644914263319240e-14, -3.956690406282833e-16,  1.163492359463692e-18, -1.101798909973285e-21,
 -8.810726018140195e-24,  5.841610913712158e-26, -1.900040761264150e-28,  3.641984484969131e-01, -1.785001660320522e-03,  5.548619320435487e-06, -1.052000764062425e-08,
 -2.431359601783567e-12,  1.131328883728663e-13, -4.857409898980044e-16,  9.353419965790618e-19,  1.544469922746268e-21, -1.977412918478539e-23,  7.669593572992570e-26,
 -1.159572550921830e-28,  4.245865300019409e-01, -2.038825262223497e-03,  5.958484286133957e-06, -8.969848933069855e-09, -1.630837427859307e-11,  1.602713823623710e-13,
 -5.101140868711520e-16,  2.968173474674837e-19,  5.324345992530774e-21, -2.926046497200590e-23,  6.355416852859197e-26,  1.153105076842183e-28,  4.894732756605927e-01,
 -2.296285841435120e-03,  6.230192449999192e-06, -6.432701286874905e-09, -3.282777919915078e-11,  2.000474277015777e-13, -4.303960926483935e-16, -7.919974382518434e-19,
  9.470749365919801e-21, -3.123817467988986e-23, -6.032718222617662e-28,  4.817459238969508e-28,  5.587823184704377e-01, -2.552806062162700e-03,  6.325470818711391e-06,
 -2.838767809065465e-09, -5.091701749295237e-11,  2.223801369085925e-13, -2.130772492092184e-16, -2.247292185553606e-18,  1.249294508760684e-20, -1.865846261281578e-23,
 -1.198658967284810e-25,  8.273412981201435e-28,  6.324106977296251e-01, -2.803069511788432e-03,  6.204882130616088e-06,  1.817801431049677e-09, -6.887599614562676e-11,
  2.156309557368795e-13,  1.584092986850671e-16, -3.800960075492607e-18,  1.226057756898541e-20,  1.340505394577505e-23, -2.634785447131931e-25,  8.403509173327717e-28,
  7.102211441614796e-01, -3.040927945874007e-03,  5.829451385161095e-06,  7.451680482642891e-09, -8.431042266956856e-11,  1.681418654014160e-13,  6.673894980387966e-16,
 -4.960735289169500e-18,  6.497418017592966e-21,  6.255989942289270e-23, -3.506655406430525e-25,  1.515620723912385e-28,  7.920322572911570e-01, -3.259311906847098e-03,
  5.163165467759430e-06,  1.385400312355508e-08, -9.414455387966629e-11,  7.092384537069736e-14,  1.245245160791408e-15, -5.032150222193209e-18, -6.125300294210093e-21,
  1.130066944211007e-22, -2.591471853931069e-25, -1.367494784615846e-27,  8.776060101397780e-01, -3.450157613863190e-03,  4.176673410189077e-06,  2.065665779302993e-08,
 -9.478175802225530e-11, -7.825433583542271e-14,  1.755589887742540e-15, -3.262337488628551e-18, -2.426446802723664e-20,  1.323320968091823e-22,  1.150932587172433e-25,
 -3.131425517106034e-27,  9.666318953549249e-01, -3.604372183223417e-03,  2.852576926288670e-06,  2.729799540540262e-08, -8.250968612153537e-11, -2.694296931078078e-13,
  1.992164301831380e-15,  8.293935997901915e-19, -4.198856316418577e-20,  7.845199155240574e-23,  7.300795240661236e-25, -3.514191161715250e-27,  1.058706914930232e+00,
 -3.711873365520378e-03,  1.192713660021829e-06,  3.299983250817371e-08, -5.426912048378751e-11, -4.744668473797952e-13,  1.708350240259535e-15,  6.912309363578750e-18,
 -4.802502547930944e-20, -7.434078962683068e-23,  1.244439135002754e-24, -4.347266537955270e-28,  1.153310554697368e+00, -3.761760934181635e-03, -7.722848934677812e-07,
  3.677372042144691e-08, -8.895080385380108e-12, -6.428147060823138e-13,  7.010498180200690e-16,  1.322242453538429e-17, -2.871244906863934e-20, -2.885398109914178e-22,
  1.008232544016990e-24,  6.297929539966596e-27,  1.249773959492466e+00, -3.742706190363540e-03, -2.971291668526833e-06,  3.748562386753008e-08,  5.116029353798915e-11,
 -7.035815564106260e-13, -1.036005452324978e-15,  1.629105141954097e-17,  2.249663311475846e-20, -4.211696235378393e-22, -5.062802340197029e-25,  1.159904443697874e-26,
  1.347242893077915e+00, -3.643683336073762e-03, -5.279943252003212e-06,  3.402008476983094e-08,  1.178956455175550e-10, -5.810283138256234e-13, -3.114401940695271e-15,
  1.185937080426633e-17,  8.959083238483839e-20, -2.588450342201374e-22, -2.717021983572891e-24,  5.597092869592521e-27,  1.444635000682155e+00, -3.455205361025883e-03,
 -7.509880552862951e-06,  2.558914744895770e-08,  1.764671264015057e-10, -2.306998191561473e-13, -4.627618293967984e-15, -2.127037399446192e-18,  1.240221698534958e-19,
  2.797040383171393e-22, -3.231402313044790e-24, -1.441442890734886e-26,  1.540593816842174e+00, -3.171247529873715e-03, -9.406207833164560e-06,  1.220740758960352e-08,
  2.062484171807414e-10,  3.048832565284950e-13, -4.352796962869644e-15, -2.090070555218530e-17,  6.644820601970987e-20,  8.346226294104702e-22,  3.552849237811007e-25,
 -2.629110440266975e-26,  1.633445443410211e+00, -2.791997378019323e-03, -1.066375975802712e-05, -4.733324943329545e-09,  1.866537993564784e-10,  8.467811772506171e-13,
 -1.548867818489575e-15, -3.083861491989378e-17, -8.103392249222952e-20,  6.503236177255400e-22,  5.481913072658603e-24,  1.223219261259981e-27,  1.721169381814078e+00,
 -2.327376806550825e-03, -1.097637765872438e-05, -2.204463876353850e-08,  1.091983903607228e-10,  1.101091147237829e-12,  2.816437614169009e-15, -1.785227352863302e-17,
 -1.886569443714110e-19, -4.591299936129255e-22,  3.953707540525689e-24,  3.910526792069730e-26,  1.801402521416352e+00, -1.800825733699983e-03, -1.013084913469085e-05,
 -3.499159731272282e-08, -7.693347572999678e-12,  8.267461699754075e-13,  5.671385895563088e-15,  1.286230711978539e-17, -9.728226804443327e-20, -1.124759308762798e-21,
 -4.527652910234210e-24,  8.774910665268990e-27,  1.871502773397320e+00, -1.252056239571209e-03, -8.138962326164474e-06, -3.882415732779423e-08, -1.140038798937541e-10,
  1.134769530866746e-13,  4.134673284855310e-15,  2.974997059149456e-17,  1.082329151734532e-19, -1.227250754919635e-22, -4.920473313917085e-24, -3.769010518021433e-26,
  1.928700835972887e+00, -7.365843873061962e-04, -5.360195562078894e-06, -3.163555128252634e-08, -1.514007447021923e-10, -5.208737969287191e-13, -4.181532642865200e-16,
  1.193871415084779e-17,  1.249105213121323e-19,  7.843892492459167e-22,  3.192198737841266e-24,  2.876620912388747e-27,  1.970356186279681e+00, -3.195657375657322e-04,
 -2.518867712860778e-06, -1.704787983898477e-08, -1.032410549623159e-10, -5.625015019367057e-13, -2.701911308431927e-15, -1.068347840378519e-17, -2.619700928102630e-20,
  6.875966629729203e-23,  1.574079507693839e-24,  1.426062015815907e-26,  1.994303889773047e+00, -6.292668099255103e-05, -5.189122783597906e-07, -3.780046368878640e-09,
 -2.561488737393076e-11, -1.650604099026162e-13, -1.022367005764111e-15, -6.118906805718667e-18, -3.545941519233428e-20, -1.988946097876775e-22, -1.076884702851841e-24,
 -5.595854337433329e-27,  5.705561027928026e-04, -3.067196356187372e-06,  1.236311940323937e-08, -4.428993088120614e-11,  1.486706440565426e-13, -4.790650578345114e-16,
  1.499181800769920e-18, -4.598706348242685e-21,  1.384602164746865e-23, -4.133104860014209e-26,  1.209381951295741e-28, -3.573568406044515e-31,  5.135212283630674e-03,
 -2.757602209573247e-05,  1.108669218505769e-07, -3.953377778836269e-10,  1.317427164138222e-12, -4.200687134723749e-15,  1.295673781896559e-17, -3.899509104118987e-20,
  1.145539163888720e-22, -3.316859486893348e-25,  9.333018967217372e-28, -2.638465415997834e-30,  1.426561073453813e-02, -7.643961945321187e-05,  3.057294824417648e-07,
 -1.079994829888893e-09,  3.545624233738243e-12, -1.105981850045420e-14,  3.307633016875268e-17, -9.546071929168905e-20,  2.649831296944272e-22, -7.122644670134134e-25,
  1.806299775313418e-27, -4.483967892247531e-30,  2.796382737966916e-02, -1.493462726623162e-04,  5.926340805167292e-07, -2.063435789127663e-09,  6.617546567609999e-12,
 -1.992378775952736e-14,  5.656739120478143e-17, -1.514178534474603e-19,  3.756893918491791e-22, -8.511307786204498e-25,  1.580495681024038e-27, -2.082337467316244e-30,
  4.623273034572096e-02, -2.458192856199489e-04,  9.650393980069356e-07, -3.293573711764564e-09,  1.021715406619145e-11, -2.918380719996550e-14,  7.624459628329097e-17,
 -1.780913233281179e-19,  3.425259542690209e-22, -4.094577641909717e-25, -7.103869467774197e-28,  6.797120860121187e-30,  6.907567037965413e-02, -3.652057423829748e-04,
  1.414101112536822e-06, -4.701302081888740e-09,  1.393780503609425e-11, -3.686685908503593e-14,  8.392435182240379e-17, -1.463165445895228e-19,  7.889708242447809e-23,
  8.006211846524536e-25, -5.150644366469143e-27,  2.012815016518541e-29,  9.649604262287161e-02, -5.066610267735201e-04,  1.928569519358386e-06, -6.200925058536062e-09,
  1.729638414860011e-11, -4.079054097745380e-14,  7.160591390642639e-17, -3.371424080816611e-20, -4.478694592827736e-22,  2.660784513710407e-24, -1.040253398710884e-26,
  3.030587082839644e-29,  1.284966958509077e-01, -6.691286646523422e-04,  2.494665831162078e-06, -7.690880490404391e-09,  1.975287499448048e-11, -3.876484604474771e-14,
  3.290931022579534e-17,  1.673905249863995e-19, -1.182339248285274e-21,  4.640516983974584e-24, -1.359126738947553e-26,  2.552192649154908e-29,  1.650791565292423e-01,
 -8.513149298323143e-04,  3.095941595002895e-06, -9.054902906051757e-09,  2.073671556751266e-11, -2.884443741140251e-14, -3.528669162956543e-17,  4.422516282752335e-19,
 -1.957440788865848e-21,  5.794938425196767e-24, -1.087943902517147e-26, -5.310477237817406e-30,  2.062426241085459e-01, -1.051657527604003e-03,  3.713128438661410e-06,
 -1.016382853306139e-08,  1.968157059158284e-11, -9.633076247850482e-15, -1.311105298718275e-16,  7.475637234504982e-19, -2.492185912673031e-21,  4.921988804341985e-24,
  1.101972795353968e-27, -6.436427582619125e-29,  2.519826801090600e-01, -1.268287543958275e-03,  4.323989579717934e-06, -1.087831488581304e-08,  1.607040587623001e-11,
  1.936245689414003e-14, -2.460439711910568e-16,  1.008810492228162e-18, -2.422765188306481e-21,  9.214994656080241e-25,  2.302424501824865e-26, -1.356053546138994e-28,
  3.022896357174826e-01, -1.498983735713350e-03,  4.903190861572619e-06, -1.105283692333668e-08,  9.492874208101300e-12,  5.733975762766345e-14, -3.636294227564752e-16,
  1.123594611693226e-18, -1.378913262359104e-21, -6.638277452540760e-24,  5.028613815252015e-26, -1.790672559731545e-28,  3.571464195321241e-01, -1.741118159562220e-03,
  5.422218458716633e-06, -1.054143254164907e-08, -2.831321681601418e-13,  1.017943274767668e-13, -4.589623475211021e-16,  9.739568437192920e-19,  8.865319638639361e-22,
 -1.681487094405678e-23,  7.112245343183185e-26, -1.358324113243739e-28,  4.165258770464490e-01, -1.991592137254809e-03,  5.849384127924625e-06, -9.205801529327792e-09,
 -1.322460539475502e-11,  1.481466721849750e-13, -4.995727024907140e-16,  4.508416937708206e-19,  4.317760509683676e-21, -2.663754953203421e-23,  6.710369180016190e-26,
  4.830392014918669e-29,  4.803873142791464e-01, -2.246761700262041e-03,  6.149978761915489e-06, -6.926506339121617e-09, -2.893174937503825e-11,  1.894850182866544e-13,
 -4.484979886491335e-16, -5.068917488501234e-19,  8.350559952800516e-21, -3.087001744962355e-23,  1.824272680192939e-26,  3.762841507827483e-28,  5.486720668996482e-01,
 -2.502352069786928e-03,  6.286663385657297e-06, -3.618157709520394e-09, -4.652541943375186e-11,  2.165557152395111e-13, -2.705117628679572e-16, -1.859120859128296e-18,
  1.174348352307139e-20, -2.275012572490791e-23, -8.536283624176013e-26,  7.388240253918778e-28,  6.212978099346873e-01, -2.753361605621060e-03,  6.220226540770948e-06,
  7.504576288581301e-10, -6.453374861781027e-11,  2.182003655589183e-13,  5.753362474532791e-17, -3.402861169111789e-18,  1.256249031524671e-20,  3.618389412367684e-24,
 -2.256191532805657e-25,  8.728349096676111e-28,  6.981512378964555e-01, -2.993957325567416e-03,  5.910891415096088e-06,  6.130439916498988e-09, -8.079853292637550e-11,
  1.825178855810305e-13,  5.317191265294534e-16, -4.719472601113983e-18,  8.499442751101700e-21,  4.874702365860723e-23, -3.381091348996528e-25,  4.081878196607077e-28,
  7.790786372191104e-01, -3.217367080159078e-03,  5.320427565971187e-06,  1.236061361928829e-08, -9.243872983784224e-11,  9.910046243615165e-14,  1.102197507881420e-15,
 -5.165178003296346e-18, -2.256888377334535e-21,  1.015752146530262e-22, -3.090622729261897e-25, -9.059095274016129e-28,  8.638737398304041e-01, -3.415778591879433e-03,
  4.415409934148962e-06,  1.912988568078486e-08, -9.593333682772629e-11, -3.729963714369134e-14,  1.654094940922226e-15, -3.961952130006589e-18, -1.944992455955800e-20,
  1.342834297306868e-22, -1.478491249656282e-26, -2.755659786469351e-27,  9.522620902981411e-01, -3.580264099295563e-03,  3.172062547665651e-06,  2.593733465836827e-08,
 -8.741905238546619e-11, -2.214881007315467e-13,  1.997039429024566e-15, -4.637245834367206e-19, -3.867683266868252e-20,  1.044636663068705e-22,  5.685040479690362e-25,
 -3.789088103404854e-27,  1.043880991102422e+00, -3.700763131883133e-03,  1.583196054725174e-06,  3.205790222612735e-08, -6.333368299481947e-11, -4.313196949408156e-13,
  1.880045514216407e-15,  5.342233218970979e-18, -4.981364803242701e-20, -2.535389402966419e-23,  1.195157485322421e-24, -1.771933972508938e-27,  1.138253944509421e+00,
 -3.766177464733132e-03, -3.322751334164365e-07,  3.652958684075182e-08, -2.155371034406806e-11, -6.216599068428724e-13,  1.056911440319692e-15,  1.214572370302975e-17,
 -3.831162396821284e-20, -2.431612601507163e-22,  1.248014066127452e-24,  4.559299467371514e-27,  1.234758461197194e+00, -3.764664375611978e-03, -2.517021106959062e-06,
  3.819042093775949e-08,  3.687732974342409e-11, -7.229046708337882e-13, -5.720789395393413e-16,  1.676544660506958e-17,  7.093973588188640e-21, -4.311187484087721e-22,
  9.664886474151958e-27,  1.171463482338640e-26,  1.332586310243052e+00, -3.684258759369717e-03, -4.860780564455196e-06,  3.580950799987296e-08,  1.055561548753000e-10,
 -6.514745982661557e-13, -2.743750141330694e-15,  1.455675969342116e-17,  7.838622882497189e-20, -3.614286637317549e-22, -2.383933849990989e-24,  9.466659547224638e-27,
  1.430696033175997e+00, -3.514008517249139e-03, -7.186041783944941e-06,  2.836966301521409e-08,  1.707400313717167e-10, -3.420204958842022e-13, -4.630284354541699e-15,
  1.976663865209609e-18,  1.316227156828330e-19,  1.389541767477958e-22, -3.774098869375574e-24, -1.002665274420583e-26,  1.527759334923068e+00, -3.245854711828659e-03,
 -9.239736789790826e-06,  1.555029324249699e-08,  2.112553680087870e-10,  1.936615726420186e-13, -4.903724851322250e-15, -1.829321209746045e-17,  9.646085115385388e-20,
  8.245388919159582e-22, -8.848492184217227e-25, -2.976484384559355e-26,  1.622106547362987e+00, -2.877482613339973e-03, -1.070208937367955e-05, -1.613697452364668e-09,
  2.031463355915498e-10,  7.989767013185399e-13, -2.444831158423925e-15, -3.301485408256385e-17, -5.368769802244312e-20,  8.678616351946830e-22,  5.321817960848455e-24,
 -8.813002672597946e-27,  1.711682621320526e+00, -2.416214571893951e-03, -1.122969215594505e-05, -2.011779971067771e-08,  1.318520831926894e-10,  1.161991005793740e-12,
  2.229808238737554e-15, -2.411980628547474e-17, -2.019153687961092e-19, -2.656313522616921e-22,  5.739040606009256e-24,  4.153094480002456e-26,  1.794034464297789e+00,
 -1.883552910756384e-03, -1.055091693713530e-05, -3.497490037036154e-08,  1.022989889655305e-11,  9.667907528279483e-13,  5.981617032420088e-15,  9.067423514483106e-18,
 -1.409084418064576e-19, -1.294577924723194e-21, -3.868866100310022e-24,  2.173609290607233e-26,  1.866361330901651e+00, -1.319062297839194e-03, -8.615703436254675e-06,
 -4.062438128498165e-08, -1.106725461881365e-10,  2.230909493679465e-13,  5.015206434825825e-15,  3.310138794921316e-17,  9.985476374328984e-20, -3.546351991038678e-22,
 -6.720759318559047e-24, -4.394750849411468e-26,  1.925666271807320e+00, -7.810264339392495e-04, -5.754701861087384e-06, -3.414172615155040e-08, -1.618890521472707e-10,
 -5.264194132612304e-13, -2.348751442277342e-17,  1.641246653038780e-17,  1.554644325207543e-19,  9.131422300324789e-22,  3.203975643385342e-24, -2.834297198359075e-27,
  1.969036285005868e+00, -3.405639374724653e-04, -2.733736357997915e-06, -1.879336362821660e-08, -1.151642520231997e-10, -6.310289968167712e-13, -3.012318667684689e-15,
 -1.146871130768294e-17, -2.242380857903614e-20,  1.457531498807814e-22,  2.314915006688782e-24,  1.966489585387570e-26,  1.994043582990926e+00, -6.726664854669451e-05,
 -5.668452872322174e-07, -4.217688045606663e-09, -2.917603319691795e-11, -1.917883176026173e-13, -1.210720812173396e-15, -7.376990894456623e-18, -4.345804993309137e-20,
 -2.473092037459268e-22, -1.354733838353317e-24, -7.092152953302214e-27,  5.584818173889775e-04, -2.970377594920147e-06,  1.184560264660915e-08, -4.198593894868967e-11,
  1.394389697055249e-13, -4.445811349370164e-16,  1.376403839468710e-18, -4.178536624390650e-21,  1.244151530597509e-23, -3.679433488090164e-26,  1.062224812541954e-28,
 -3.127206699546830e-31,  5.026652517936150e-03, -2.670771087116586e-05,  1.062466228027787e-07, -3.749145215325153e-10,  1.236436692538297e-12, -3.902424331815465e-15,
  1.191445042200770e-17, -3.551343307304779e-20,  1.032580899003027e-22, -2.965810155965247e-25,  8.242016974304691e-28, -2.328503956961016e-30,  1.396466318854068e-02,
 -7.404467547086518e-05,  2.931027622014671e-07, -1.024992173420523e-09,  3.332154531307959e-12, -1.029712640271250e-14,  3.051838491726385e-17, -8.737795698012320e-20,
  2.405957738331280e-22, -6.438298789083143e-25,  1.618509047791953e-27, -4.061155481934008e-30,  2.737577011499388e-02, -1.447024747753712e-04,  5.684952208777989e-07,
 -1.960670503624746e-09,  6.232310472932386e-12, -1.861571615680386e-14,  5.249147977485264e-17, -1.398740247844127e-19,  3.461641440505914e-22, -7.897883299996531e-25,
  1.485603405297929e-27, -2.223232485597768e-30,  4.526464738771352e-02, -2.382543266299222e-04,  9.264784164212844e-07, -3.134670906226215e-09,  9.651379056837483e-12,
 -2.741255080227161e-14,  7.140923902084424e-17, -1.673712680232248e-19,  3.273417799926253e-22, -4.323596452041522e-25, -4.458347110313725e-28,  5.268357883164594e-30,
  6.763712100808777e-02, -3.541148602331533e-04,  1.358999535414175e-06, -4.484087848883397e-09,  1.322027943530662e-11, -3.490152645634781e-14,  7.986689369031532e-17,
 -1.433687677017611e-19,  1.042157981277127e-22,  6.113666687442895e-25, -4.334701345255245e-27,  1.702140150822842e-29,  9.449979091861219e-02, -4.915254718016592e-04,
  1.855792251295857e-06, -5.930616373593477e-09,  1.649767428003981e-11, -3.908486082397154e-14,  7.047511206217807e-17, -4.659121211711585e-20, -3.592589713693216e-22,
  2.270333781483232e-24, -9.144934780066232e-27,  2.688274219495391e-29,  1.258595188464594e-01, -6.495351861207390e-04,  2.404246099660472e-06, -7.380992433539333e-09,
  1.898583449574409e-11, -3.792290405658676e-14,  3.709093603067692e-17,  1.321258687214270e-19, -1.024797295531867e-21,  4.119142974035504e-24, -1.248307947462471e-26,
  2.474905312200631e-29,  1.617227516075551e-01, -8.269764361472470e-04,  2.989254309647705e-06, -8.727772495471943e-09,  2.015232526635679e-11, -2.954960981856718e-14,
 -2.374981821691306e-17,  3.828670702501618e-19, -1.756696085335511e-21,  5.356866248590135e-24, -1.098338869759728e-26,  2.932151204917703e-31,  2.020946391392414e-01,
 -1.022435026195460e-03,  3.593045034460175e-06, -9.850628707152977e-09,  1.945909213545930e-11, -1.253739540106475e-14, -1.112685772412212e-16,  6.706520692552677e-19,
 -2.314843826019199e-21,  4.913737821829100e-24, -1.412547540324670e-27, -5.035999904236019e-29,  2.469778932218409e-01, -1.234213387891160e-03,  4.195004325846844e-06,
 -1.061840179331555e-08,  1.640084731889449e-11,  1.378763791714396e-14, -2.188764876811672e-16,  9.319792152913492e-19, -2.374398772572888e-21,  1.728925069005008e-24,
  1.748701020615244e-26, -1.163913029169135e-28,  2.963713155691644e-01, -1.460286078802810e-03,  4.771504471691000e-06, -1.089224014333443e-08,  1.055491995493870e-11,
  4.898498580687965e-14, -3.328197735518515e-16,  1.076018759307012e-18, -1.583550123800930e-21, -4.780658864070903e-24,  4.269070159002860e-26, -1.659170966955123e-28,
  3.502679013307729e-01, -1.698246326781144e-03,  5.295759358586035e-06, -1.053026472807387e-08,  1.644826616627294e-12,  9.110914634174716e-14, -4.313815460084639e-16,
  9.931776305997763e-19,  3.309277362920476e-22, -1.409342353236294e-23,  6.486665106571824e-26, -1.472948528198753e-28,  4.086523942158937e-01, -1.945242318824515e-03,
  5.737740626442436e-06, -9.394338629154242e-09, -1.038046989270456e-11,  1.363231556899564e-13, -4.851552283492142e-16,  5.741879786291287e-19,  3.407481400911841e-21,
 -2.392764896442884e-23,  6.799950713385479e-26, -5.516723148598797e-30,  4.714981299889303e-01, -2.197901927711069e-03,  6.064206391656499e-06, -7.359685863024038e-09,
 -2.525068643846472e-11,  1.785799255005721e-13, -4.591157922618694e-16, -2.572834917245111e-19,  7.256098873993192e-21, -2.983817498140289e-23,  3.265027242674158e-26,
  2.803161448706261e-28,  5.387629528199114e-01, -2.452244762397702e-03,  6.238920790465860e-06, -4.328285198117996e-09, -4.226322826807999e-11,  2.094804539807626e-13,
 -3.174335283597046e-16, -1.497030563336608e-18,  1.087059459180396e-20, -2.554287287822248e-23, -5.498948949848163e-26,  6.407563759826242e-28,  6.103839198283711e-01,
 -2.703580992513860e-03,  6.223180961167555e-06, -2.471268437188978e-10, -6.016341586804370e-11,  2.184832971157859e-13, -3.211089227802340e-17, -3.000443897062242e-18,
  1.253956639685257e-20, -4.638357897710500e-24, -1.872888418883319e-25,  8.632844951672186e-28,  6.862704181147955e-01, -2.946397628620447e-03,  5.976822621330861e-06,
  4.867515256528906e-09, -7.703110100658747e-11,  1.937256649484356e-13,  4.036270753470895e-16, -4.421983488388405e-18,  1.001578761339236e-20,  3.564267885975622e-23,
 -3.157203402497534e-25,  5.987848456636059e-28,  7.662951998597543e-01, -3.174235333786154e-03,  5.459950738708355e-06,  1.089883800452335e-08, -9.020393596618936e-11,
  1.238128336148411e-13,  9.570937385701899e-16, -5.181347303837329e-18,  1.168860672231674e-21,  8.854365833582076e-23, -3.394264318414218e-25, -4.820317404573374e-28,
  8.502826889974129e-01, -3.379563214635335e-03,  4.635741225139798e-06,  1.759110236340172e-08, -9.629167705085971e-11,  1.001551587108917e-15,  1.535171307136766e-15,
 -4.507346101714720e-18, -1.465441620315610e-20,  1.313965804888310e-22, -1.262404187054341e-25, -2.300858647901728e-27,  9.379937241476510e-01, -3.553666704607858e-03,
  3.474780569865733e-06,  2.450578897865895e-08, -9.137128416613119e-11, -1.738511976443044e-13,  1.967322668663267e-15, -1.637151367024069e-18, -3.454727580933037e-20,
  1.238420728410240e-22,  4.001466332951347e-25, -3.826627513361170e-27,  1.029105680948192e+00, -3.686576650339138e-03,  1.961534249328648e-06,  3.097805133615917e-08,
 -7.149768309352030e-11, -3.845842560532190e-13,  2.007239109737124e-15,  3.742645847827350e-18, -4.988782370988253e-20,  2.054976469261376e-23,  1.091996831518170e-24,
 -2.873498732475179e-27,  1.123186684986489e+00, -3.767089043646643e-03,  1.036052310505172e-07,  3.608675313742682e-08, -3.370645224115890e-11, -5.923593388913045e-13,
  1.378582908648762e-15,  1.078968480124495e-17, -4.612355989530157e-20, -1.897845855301522e-22,  1.406858422080741e-24,  2.644931701227654e-27,  1.219662446536082e+00,
 -3.782958476497061e-03, -2.055674928781386e-06,  3.866420736050750e-08,  2.232003322109539e-11, -7.309900367526127e-13, -1.017952147220596e-16,  1.674520434066505e-17,
 -8.296380801784891e-21, -4.205730338823010e-22,  5.124808312005354e-25,  1.101030845875727e-26,  1.317774263438739e+00, -3.721398449005512e-03, -4.421374249846541e-06,
  3.739073621155655e-08,  9.190258914305996e-11, -7.121627450294638e-13, -2.303126080932366e-15,  1.683940829641811e-17,  6.376803115861632e-20, -4.474465962921871e-22,
 -1.893390671582709e-24,  1.269823164958134e-26,  1.416527243362351e+00, -3.570089225377981e-03, -6.829460004460687e-06,  3.104076977651846e-08,  1.627953118044783e-10,
 -4.520036527766595e-13, -4.515431041596605e-15,  6.238721886772872e-18,  1.338155530108289e-19, -1.926294029073783e-23, -4.096036931658810e-24, -4.443217650596767e-27,
  1.514629343566207e+00, -3.318968478627925e-03, -9.032746112223565e-06,  1.895480299738056e-08,  2.139121344454094e-10,  7.020157849060817e-14, -5.368321646638235e-15,
 -1.474095956832253e-17,  1.251861962332928e-19,  7.623997772732522e-22, -2.231379549065085e-24, -3.103013495073643e-26,  1.610425340419975e+00, -2.963120337845136e-03,
 -1.070143556358976e-05,  1.760974719320073e-09,  2.184633569174739e-10,  7.290439428426637e-13, -3.388314739627143e-15, -3.419284303253088e-17, -1.873647807239871e-20,
  1.069660728675890e-21,  4.683932553466528e-24, -2.035787229443641e-26,  1.701836611987849e+00, -2.506980115837425e-03, -1.145767227895306e-05, -1.781958300199178e-08,
  1.555685487295911e-10,  1.206664859270331e-12,  1.462894572896878e-15, -3.068622087035913e-17, -2.069057624110775e-19,  3.996906985130069e-25,  7.552907115913896e-24,
  4.019287633623312e-26,  1.786328785821383e+00, -1.969634738351156e-03, -1.096897011046790e-05, -3.464865884559613e-08,  3.101904719755524e-11,  1.112842611540030e-12,
  6.165170858795550e-15,  3.784947919672846e-18, -1.900272487000744e-19, -1.425647217547433e-21, -2.566233507094858e-24,  3.797611672451812e-26,  1.860944101006613e+00,
 -1.389967615386096e-03, -9.113651275546479e-06, -4.235258619157730e-08, -1.049301947440539e-10,  3.549252980453742e-13,  5.984468675214939e-15,  3.603671259817077e-17,
  8.176923168576510e-20, -6.636090116934603e-22, -8.759658593179276e-24, -4.827368518887283e-26,  1.922447432851004e+00, -8.287476850437268e-04, -6.180291007801738e-06,
 -3.681604196155568e-08, -1.723828165332203e-10, -5.208751149560804e-13,  5.108257936094997e-16,  2.193764918850204e-17,  1.905927595213698e-19,  1.036379132508453e-21,
  2.890582573828322e-24, -1.209263817456838e-26,  1.967628815658144e+00, -3.633682196993382e-04, -2.970741994589739e-06, -2.074099493584637e-08, -1.285341954911873e-10,
 -7.072536850649755e-13, -3.342561859458488e-15, -1.208264123850915e-17, -1.528385334089100e-20,  2.576110754849306e-22,  3.329717677356303e-24,  2.677429410723212e-26,
  1.993765114726552e+00, -7.201209788776694e-05, -6.203903362744608e-07, -4.716842652821334e-09, -3.331995202456587e-11, -2.234900464328338e-13, -1.438162451709291e-15,
 -8.921198377424463e-18, -5.341652451303649e-20, -3.082651174004277e-22, -1.706840408792363e-24, -8.985426032644107e-27,  5.467866983883584e-04, -2.877590835713743e-06,
  1.135486980392007e-08, -3.982429257004971e-11,  1.308684344251559e-13, -4.129076378380465e-16,  1.264785175977728e-18, -3.800807843579927e-21,  1.119018995610960e-23,
 -3.280901250849252e-26,  9.331961149754189e-29, -2.748181898605336e-31,  4.921493594009063e-03, -2.587540330739424e-05,  1.018638202855761e-07, -3.557407173961161e-10,
  1.161169018172821e-12, -3.628046296802259e-15,  1.096477305135611e-17, -3.237383751359395e-20,  9.315065051474242e-23, -2.655810044494544e-25,  7.277256876605540e-28,
 -2.063891303632039e-30,  1.367309749067990e-02, -7.174816204869269e-05,  2.811160735258724e-07, -9.732862616260029e-10,  3.133342649400204e-12, -9.593195142089332e-15,
  2.817619171300644e-17, -8.003758606904912e-20,  2.185411882173733e-22, -5.825512205108224e-25,  1.448097881283617e-27, -3.694034812652465e-30,  2.680590948492173e-02,
 -1.402469578617756e-04,  5.455534084061333e-07, -1.863864911166414e-09,  5.872283229764181e-12, -1.740169245124583e-14,  4.872589493243261e-17, -1.292404147452573e-19,
  3.187775199257727e-22, -7.323536009393562e-25,  1.385362125954944e-27, -2.329465365799228e-30,  4.432621915281504e-02, -2.309903793968703e-04,  8.897711029823211e-07,
 -2.984543304061727e-09,  9.119892716040907e-12, -2.575379663823862e-14,  6.686713067120180e-17, -1.571483828740199e-19,  3.115080284269274e-22, -4.459570644432037e-25,
 -2.435939696451982e-28,  3.955167283863340e-30,  6.624206977653403e-02, -3.434545566310156e-04,  1.306436926691220e-06, -4.278044833563962e-09,  1.254109382993999e-11,
 -3.303249689397769e-14,  7.590233524241122e-17, -1.397137644745605e-19,  1.232768447681757e-22,  4.521202577918273e-25, -3.647778250498593e-27,  1.425244729682977e-29,
  9.256293723811207e-02, -4.769593748240377e-04,  1.786183131956217e-06, -5.672815729276009e-09,  1.573277901921472e-11, -3.741033880967799e-14,  6.902140692550584e-17,
 -5.684813071449406e-20, -2.838351325983930e-22,  1.927219025805698e-24, -8.034650433554561e-27,  2.360813189219993e-29,  1.232992922991121e-01, -6.306503981358820e-04,
  2.317471961405156e-06, -7.083237186785496e-09,  1.823655931838071e-11, -3.699189934086934e-14,  4.035296913690842e-17,  1.016107218159962e-19, -8.852366773384228e-22,
  3.641245777705881e-24, -1.142141914383072e-26,  2.342715682108994e-29,  1.584620183002543e-01, -8.034758984163515e-04,  2.886436069554845e-06, -8.410090665680996e-09,
  1.955646937211189e-11, -2.999713917182348e-14, -1.378815272641390e-17,  3.296536625415694e-19, -1.571742006327796e-21,  4.919065360749027e-24, -1.087783826724646e-26,
  4.253282060943424e-30,  1.980616465532461e-01, -9.941582231930764e-04,  3.476696835226946e-06, -9.541428074372701e-09,  1.918311823984145e-11, -1.499070967744881e-14,
 -9.350087796797729e-17,  5.993923573387330e-19, -2.139467571664723e-21,  4.816480975376432e-24, -3.366496864844178e-27, -3.885164923382978e-29,  2.421073590642264e-01,
 -1.201158556393681e-03,  4.069166184848906e-06, -1.035405891033121e-08,  1.662613933713399e-11,  8.839223498511861e-15, -1.938345373386364e-16,  8.571196137127315e-19,
 -2.300753181844675e-21,  2.331207849473611e-24,  1.275276829923868e-26, -9.914406749972711e-29,  2.906056916630141e-01, -1.422633927929973e-03,  4.641841814283757e-06,
 -1.071594768455552e-08,  1.145715310955340e-11,  4.135297983762960e-14, -3.034242834705492e-16,  1.022907035346499e-18, -1.726638319169254e-21, -3.214898104491756e-24,
  3.570092400235477e-26, -1.517095974446663e-28,  3.435588486829161e-01, -1.656385122348317e-03,  5.169612420958890e-06, -1.048992308957980e-08,  3.365734758478642e-12,
  8.109044234002199e-14, -4.034970940969948e-16,  9.961374800391477e-19, -1.313111822232826e-22, -1.163024234847727e-23,  5.825666223768893e-26, -1.522303008200651e-28,
  4.009625111028306e-01, -1.899793942426021e-03,  5.624099977217498e-06, -9.539241407007329e-09, -7.769081405621042e-12,  1.248839016354937e-13, -4.676771737469966e-16,
  6.699687347845984e-19,  2.594865777179761e-21, -2.122569789937478e-23,  6.679206766942750e-26, -4.755391483397821e-29,  4.628029809009252e-01, -2.149748142144383e-03,
  5.973582013264194e-06, -7.735724734856611e-09, -2.178972781275705e-11,  1.674999543296401e-13, -4.632285528400114e-16, -4.200049474198146e-20,  6.208168334374713e-21,
 -2.831134673583547e-23,  4.307131593334209e-26,  1.952205467915403e-28,  5.290534517405415e-01, -2.402552333708502e-03,  6.183060977172748e-06, -4.971407466644567e-09,
 -3.815299900741881e-11,  2.013974915978197e-13, -3.546213117558999e-16, -1.164255385510977e-18,  9.917982148893677e-21, -2.720839057798972e-23, -2.902621471620820e-26,
  5.392531945730205e-28,  5.996691253066314e-01, -2.653823439678074e-03,  6.214583738370224e-06, -1.174853793593415e-09, -5.580802804431425e-11,  2.167496254695383e-13,
 -1.105405792928333e-16, -2.603221619523648e-18,  1.224680093574278e-20, -1.138062314901814e-23, -1.501343149097055e-25,  8.208739364309030e-28,  6.745807975057538e-01,
 -2.898370061700725e-03,  6.027967269147556e-06,  3.666498645164459e-09, -7.306955437497873e-11,  2.019642451941790e-13,  2.844744428325056e-16, -4.083331327324146e-18,
  1.107834560185232e-20,  2.358284240497836e-23, -2.863396452352516e-25,  7.268246112648243e-28,  7.536864116678429e-01, -3.130056923063302e-03,  5.582162841630314e-06,
  9.476583919085385e-09, -8.750969409431336e-11,  1.450492279785483e-13,  8.129999734223450e-16, -5.095597614612773e-18,  4.107972358714158e-21,  7.465564139686199e-23,
 -3.522784037339633e-25, -1.120247026765463e-28,  8.368399079643758e-01, -3.341659088945315e-03,  4.837597478672696e-06,  1.605255383452887e-08, -9.591368302291140e-11,
  3.628253548644796e-14,  1.403103502995447e-15, -4.901767016618262e-18, -1.003812463500222e-20,  1.244660171879901e-22, -2.166865386810177e-25, -1.806982411228971e-27,
  9.238364808442192e-01, -3.524717282840232e-03,  3.759971914631441e-06,  2.301857984972574e-08, -9.438049150022922e-11, -1.273062376009180e-13,  1.906695609566467e-15,
 -2.668569486600056e-18, -2.984113170467887e-20,  1.365163354682138e-22,  2.347939976224168e-25, -3.658770438000292e-27,  1.014393085022530e+00, -3.669417444649163e-03,
  2.326161830320438e-06,  2.977520476164239e-08, -7.870007083332412e-11, -3.353324042423885e-13,  2.089853255175238e-15,  2.166238949286143e-18, -4.839469204950618e-20,
  6.143858152137521e-23,  9.464837072167058e-25, -3.691546979904537e-27,  1.108122714973791e+00, -3.764538094011985e-03,  5.330255885243162e-07,  3.545456971964806e-08,
 -4.519919543161495e-11, -5.558207174711623e-13,  1.659082197203704e-15,  9.215469207113087e-18, -5.192004140244465e-20, -1.317556931665389e-22,  1.480482038341078e-24,
  7.107322823915593e-28,  1.204500667416857e+00, -3.797543034103601e-03, -1.590044166784195e-06,  3.890439544222858e-08,  7.713565938397799e-12, -7.278505583774979e-13,
  3.611111782032429e-16,  1.624235259067545e-17, -2.295459033171971e-20, -3.907591184315977e-22,  9.677242305385775e-25,  9.572382160149322e-27,  1.302820803190503e+00,
 -3.754950791349270e-03, -3.964342074979071e-06,  3.874439258636856e-08,  7.714590248474010e-11, -7.615645231097223e-13, -1.805573804259650e-15,  1.860877832723772e-17,
  4.643833636920226e-20, -5.112566378166671e-22, -1.280398377111899e-24,  1.498959692958589e-26,  1.402140035759067e+00, -3.623191393109705e-03, -6.441659629602996e-06,
  3.356735413763732e-08,  1.526881786041395e-10, -5.577956889564289e-13, -4.281128840934100e-15,  1.047782875924683e-17,  1.301423688648366e-19, -1.851896433986299e-22,
 -4.154215331813069e-24,  1.874571538682848e-27,  1.501210468503772e+00, -3.390262372317823e-03, -8.784729617238142e-06,  2.238149723802894e-08,  2.139967809649983e-10,
 -6.311375156564969e-14, -5.720997235626771e-15, -1.031574699624184e-17,  1.506985315905589e-19,  6.460514960356500e-22, -3.575659461386405e-24, -2.960211068964030e-26,
  1.598401855246454e+00, -3.048586795712674e-03, -1.065886541927216e-05,  5.368290831646227e-09,  2.321532962676649e-10,  6.362046694263774e-13, -4.348072669873273e-15,
 -3.414209011145070e-17,  2.289556609780357e-20,  1.235554765650129e-21,  3.522978512980032e-24, -3.238967949886744e-26,  1.691624076649986e+00, -2.599452674388619e-03,
 -1.165577094679526e-05, -1.513581780228927e-08,  1.799794855291553e-10,  1.230717769768333e-12,  5.114241346982439e-16, -3.724528725898949e-17, -2.010396575776029e-19,
  3.364285445215840e-22,  9.202805972435460e-24,  3.389996925527460e-26,  1.778272124255540e+00, -2.059039453800001e-03, -1.138101560292266e-05, -3.396623683309700e-08,
  5.476036992667324e-11,  1.261343271883762e-12,  6.178180839491931e-15, -3.133320616890564e-18, -2.427467993073068e-19, -1.489494287803870e-21, -4.892030129929223e-25,
  5.674985779207333e-26,  1.855235153812153e+00, -1.464937698829976e-03, -9.631695129922172e-06, -4.396652943081389e-08, -9.631225974469375e-11,  5.109319636043522e-13,
  7.026031409971770e-15,  3.819927363495424e-17,  5.105529293985348e-20, -1.056979160437758e-21, -1.091283258842709e-23, -4.878110927860688e-26,  1.919030692203457e+00,
 -8.800048575600729e-04, -6.638973280105936e-06, -3.965661923292224e-08, -1.826242551537252e-10, -5.005198201334585e-13,  1.216226425417383e-15,  2.865462976588532e-17,
  2.298220058502775e-19,  1.137619633909589e-21,  2.069301101512519e-24, -2.613858261642335e-26,  1.966126183780978e+00, -3.881657886326377e-04, -3.232454439429125e-06,
 -2.291517725579611e-08, -1.435091331916217e-10, -7.915806555766864e-13, -3.686131446977681e-15, -1.239518183602049e-17, -3.305693341592325e-21,  4.169018016498650e-22,
  4.701682144503589e-24,  3.596013440800214e-26,  1.993466768350964e+00, -7.721104437746811e-05, -6.803449824514083e-07, -5.287684197457229e-09, -3.815618876050912e-11,
 -2.612073671743459e-13, -1.713653553938561e-15, -1.082207692298851e-17, -6.584423981764223e-20, -3.851083602242617e-22, -2.152665226117194e-24, -1.136832493516812e-26,
  5.354550357554249e-04, -2.788628464192663e-06,  1.088927438905176e-08, -3.779484903086183e-11,  1.229054144614717e-13, -3.837904674997656e-16,  1.163203201337041e-18,
 -3.460922386000154e-21,  1.007343144253420e-23, -2.930826727478145e-26,  8.194977149668307e-29, -2.429406705746387e-31,  4.819595204343011e-03, -2.507725788481440e-05,
  9.770405487944964e-08, -3.377285046989046e-10,  1.091167917934191e-12, -3.375441157971316e-15,  1.009863881375357e-17, -2.954054677976244e-20,  8.409244085118802e-23,
 -2.382196394363624e-25,  6.419664391662058e-28, -1.840902067246618e-30,  1.339052991418062e-02, -6.954511327851705e-05,  2.697312247398966e-07, -9.246516966890485e-10,
  2.948063510622041e-12, -8.943087911021304e-15,  2.602997087870318e-17, -7.336895036032589e-20,  1.985736802008211e-22, -5.277825580837926e-25,  1.292593882350302e-27,
 -3.383990461971572e-30,  2.625351107487230e-02, -1.359704248930160e-04,  5.237394860508042e-07, -1.772630321654021e-09,  5.535656333577076e-12, -1.627456703634428e-14,
  4.524608723164951e-17, -1.194508769573817e-19,  2.933852927978614e-22, -6.790172009732935e-25,  1.280761048932704e-27, -2.425563435322343e-30,  4.341627059871701e-02,
 -2.240130266274063e-04,  8.548153739359240e-07, -2.842659909306508e-09,  8.620514240398536e-12, -2.420067583925742e-14,  6.260410648792228e-17, -1.474385585000607e-19,
  2.953169260290309e-22, -4.525698864731560e-25, -9.545821688881859e-29,  2.799366610789632e-30,  6.488883415981461e-02, -3.332050457648960e-04,  1.256282849245113e-06,
 -4.082574877014989e-09,  1.189834594574660e-11, -3.125732484190978e-14,  7.204783084550553e-17, -1.355354638222860e-19,  1.370710170079252e-22,  3.179980319125249e-25,
 -3.076547847138405e-27,  1.175028096795324e-29,  9.068325350208185e-02, -4.629379818892247e-04,  1.719595289192122e-06, -5.426987474123260e-09,  1.500100340893302e-11,
 -3.577389042456756e-14,  6.731250050045026e-17, -6.488082859225908e-20, -2.199983803761522e-22,  1.625673493751099e-24, -7.065557514945600e-27,  2.045883346637753e-29,
  1.208132388610681e-01, -6.124457133667145e-04,  2.234199583163458e-06, -6.797317410049462e-09,  1.750662045663242e-11, -3.599236987548601e-14,  4.282057264047757e-17,
  7.529431974667942e-20, -7.621312531730405e-22,  3.204512988732647e-24, -1.042816243192670e-26,  2.165080547688465e-29,  1.552936659662525e-01, -7.807828205494883e-04,
  2.787372554606703e-06, -8.102001639628110e-09,  1.895393639726637e-11, -3.022281399027177e-14, -5.235964948531644e-18,  2.821077414915568e-19, -1.402434743910644e-21,
  4.488537674504816e-24, -1.063012302888115e-26,  6.785030891316225e-30,  1.941399229966159e-01, -9.667974428009161e-04,  3.364031004130197e-06, -9.237013052156396e-09,
  1.886218395131058e-11, -1.704091202464894e-14, -7.765051043470166e-17,  5.336745298415392e-19, -1.968883708554098e-21,  4.650500063825448e-24, -4.865610974901745e-27,
 -2.965894564542966e-29,  2.373670509892634e-01, -1.169097687599326e-03,  3.946518624369032e-06, -1.008687115428706e-08,  1.675830481016885e-11,  4.466948128142392e-15,
 -1.708526552187830e-16,  7.849284848008291e-19, -2.208656839593235e-21,  2.758674003203934e-24,  8.730418085341074e-27, -8.406016071239565e-29,  2.849886154875372e-01,
 -1.386010382225111e-03,  4.514376366404781e-06, -1.052640279882283e-08,  1.221367814506882e-11,  3.440815286881102e-14, -2.755719288742113e-16,  9.660656358841269e-19,
 -1.818240138848587e-21, -1.916131723704606e-24,  2.934172636722738e-26, -1.373976732563636e-28,  3.370152262088020e-01, -1.615530703923016e-03,  5.044108295621430e-06,
 -1.042361355299340e-08,  4.892959504391548e-12,  7.174036833974181e-14, -3.757238845089420e-16,  9.856731165896353e-19, -5.096729433284360e-22, -9.434272291359853e-24,
  5.154099264011140e-26, -1.523720091631187e-28,  3.934525932124034e-01, -1.855260953492270e-03,  5.508963714239402e-06, -9.644168598218244e-09, -5.382080842023567e-12,
  1.138934542658118e-13, -4.478667732954597e-16,  7.412893639059955e-19,  1.878233796076656e-21, -1.860592884076619e-23,  6.396422047947124e-26, -7.945893063024231e-29,
  4.542989696929504e-01, -2.102336476956435e-03,  5.878770095721992e-06, -8.058164445107786e-09, -1.855088676947290e-11,  1.563898761620166e-13, -4.617740670586977e-16,
  1.407015032981431e-19,  5.221834612547756e-21, -2.643924235977717e-23,  4.999628244677137e-26,  1.213987489633559e-28,  5.195417793033752e-01, -2.353336547997861e-03,
  6.119872795335521e-06, -5.550104728445713e-09, -3.421261734044629e-11,  1.925303417744287e-13, -3.829257959237052e-16, -8.627314450526096e-19,  8.923028377750962e-21,
 -2.792463145433868e-23, -7.516661826080740e-27,  4.389610822725752e-28,  5.891531546016023e-01, -2.604178014133723e-03,  6.195270444175823e-06, -2.033270438325895e-09,
 -5.150524226414930e-11,  2.132658352612812e-13, -1.780136691051578e-16, -2.218968672992118e-18,  1.173754399448323e-20, -1.668175991060523e-23, -1.154088737937510e-25,
  7.542192743205410e-28,  6.630840157379859e-01, -2.849989897325681e-03,  6.065084969231132e-06,  2.530032865750777e-09, -6.897104652203534e-11,  2.074603987999572e-13,
  1.752165048127966e-16, -3.717386972457231e-18,  1.172910448082235e-20,  1.279378055804314e-23, -2.525930825564173e-25,  7.983928729370139e-28,  7.412561854967737e-01,
 -3.084968319816020e-03,  5.687579952792773e-06,  8.100648630024765e-09, -8.442505940319754e-11,  1.628663469525406e-13,  6.725482314328786e-16, -4.923864302546221e-18,
  6.541620541065005e-21,  6.056091757483075e-23, -3.502262829007379e-25,  1.942940247242177e-28,  8.235518564188891e-01, -3.302213808251259e-03,  5.021050155337121e-06,
  1.452552249335170e-08, -9.486257493314968e-11,  6.827780472469806e-14,  1.262017772983039e-15, -5.153114092940392e-18, -5.731181994989059e-21,  1.143556413745667e-22,
 -2.852062838133156e-25, -1.309608443669120e-27,  9.097994841985159e-01, -3.493558464669846e-03,  4.027058303449464e-06,  2.149058203138563e-08, -9.647559981135816e-11,
 -8.254548967280183e-14,  1.819356786947964e-15, -3.543349559349085e-18, -2.479551470923695e-20,  1.427755641343928e-22,  8.058488441423510e-26, -3.327613731330305e-27,
  9.997548658783599e-01, -3.649400838507629e-03,  2.675696637644884e-06,  2.846509311517880e-08, -8.490113590910784e-11, -2.846207681777713e-13,  2.129209829878457e-15,
  6.599757477900044e-19, -4.554220119215786e-20,  9.587562516790836e-23,  7.716153567479423e-25, -4.206976599727145e-27,  1.093075767102323e+00, -3.758585194508492e-03,
  9.537817001556378e-07,  3.464469902258046e-08, -5.589751675810597e-11, -5.130980631462081e-13,  1.893223772504532e-15,  7.489594158909064e-18, -5.559475918123868e-20,
 -7.245733035044131e-23,  1.471232600480067e-24, -1.100225632574566e-27,  1.189288012816006e+00, -3.808394980879184e-03, -1.122929356638773e-06,  3.891198026705842e-08,
 -6.720423987345275e-12, -7.138221747389953e-13,  8.035564813524659e-16,  1.529099041741651e-17, -3.622867015109001e-20, -3.441849916583440e-22,  1.346246673530482e-24,
  7.552374893465279e-27,  1.287740543205411e+00, -3.784785985403349e-03, -3.492513125790790e-06,  3.985470218983982e-08,  6.152427350882130e-11, -7.984951512535424e-13,
 -1.266553423165986e-15,  1.979175374687408e-17,  2.727418183519646e-20, -5.488569990762827e-22, -5.912735686748913e-25,  1.613412820059150e-26,  1.387546812220864e+00,
 -3.673072789553210e-03, -6.024579250712472e-06,  3.591564321843152e-08,  1.405309594219917e-10, -6.565589365031253e-13, -3.930675250791991e-15,  1.450392078452516e-17,
  1.205218255790195e-19, -3.477940082062500e-22, -3.928805696148912e-24,  8.344512819576660e-27,  1.487510646321098e+00, -3.459407835111891e-03, -8.495674024129981e-06,
  2.578779921579110e-08,  2.113409741367424e-10, -2.033184089908310e-13, -5.939040051227837e-15, -5.151360455149346e-18,  1.710773262114708e-19,  4.780398143193987e-22,
 -4.793336777509854e-24, -2.526717692114802e-26,  1.586037464580457e+00, -3.133535966821907e-03, -1.057175856737938e-05,  9.178543424392262e-09,  2.437570235411876e-10,
  5.205039724742780e-13, -5.286930409309610e-15, -3.267354799800928e-17,  6.953749125495510e-20,  1.344571506300412e-21,  1.846393271320309e-24, -4.354967350757409e-26,
  1.681038694876860e+00, -2.693374533586536e-03, -1.181930929577302e-05, -1.205893177875126e-08,  2.046284103391953e-10,  1.229764373102300e-12, -6.191663697350101e-16,
 -4.341098881750577e-17, -1.819704033538217e-19,  7.312487296657182e-22,  1.045002874320271e-23,  2.178930433014067e-26,  1.769851312378082e+00, -2.151701093801870e-03,
 -1.178249498711715e-05, -3.288024589915151e-08,  8.145814560794950e-11,  1.407639489657351e-12,  5.973639221928066e-15, -1.175771210700096e-17, -2.960661767154683e-19,
 -1.453312649636091e-21,  2.442228882358188e-24,  7.647240205649835e-26,  1.849217918555714e+00, -1.544127012258277e-03, -1.016817156638350e-05, -4.541624802971764e-08,
 -8.431994336087089e-11,  6.925380149926258e-13,  8.112138789847521e-15,  3.913583655264992e-17,  4.639080947927557e-21, -1.535268660211009e-21, -1.295984427064857e-23,
 -4.299482509656037e-26,  1.915401364181623e+00, -9.350705843910016e-04, -7.132709062712375e-06, -4.265681629421483e-08, -1.922733111346574e-10, -4.608330425046243e-13,
  2.127772433458164e-15,  3.667761119290829e-17,  2.719402533126153e-19,  1.191938658241546e-21,  4.997344357555472e-25, -4.633088900033090e-26,  1.964520003068058e+00,
 -4.151656221581403e-04, -3.521751779263658e-06, -2.534290103337642e-08, -1.602535280683323e-10, -8.842092991591514e-13, -4.032143582510624e-15, -1.222124695090004e-17,
  1.549838183355792e-20,  6.398429710205734e-22,  6.529807472510355e-24,  4.755566635236147e-26,  1.993146621595366e+00, -8.291840364465211e-05, -7.476401144626322e-07,
 -5.942318480430116e-09, -4.381744452941396e-11, -3.062227926022191e-13, -2.048378521647222e-15, -1.316856074184319e-17, -8.138607750571470e-20, -4.820481455554327e-22,
 -2.715977484582391e-24, -1.434298199442477e-26,  5.244719243191332e-04, -2.703295565228808e-06,  1.044728664365675e-08, -3.588828436221496e-11,  1.155011087038097e-13,
 -3.570009878611975e-16,  1.070656047329438e-18, -3.154841903314478e-21,  9.074836312036589e-24, -2.623592650630350e-26,  7.185885527662913e-29, -2.166330392052395e-31,
  4.720824182665660e-03, -2.431154466281990e-05,  9.375387905321338e-08, -3.207969958272800e-10,  1.026017308656226e-12, -3.142703122702052e-15,  9.307922105972830e-18,
 -2.698200218436770e-20,  7.595975104995779e-23, -2.141041692090175e-25,  5.651420445414531e-28, -1.657615629191665e-30,  1.311659600154151e-02, -6.743085826514778e-05,
  2.589126241113648e-07, -8.788803172782208e-10,  2.775286182354688e-12, -8.342319741341551e-15,  2.406181439912270e-17, -6.730890301375747e-20,  1.804690089869289e-22,
 -4.789788546578047e-25,  1.149402841606187e-27, -3.135406312509844e-30,  2.571787658072647e-02, -1.318641139211125e-04,  5.029887920423738e-07, -1.686605868516559e-09,
  5.220758527404518e-12, -1.522775779475370e-14,  4.202929372202721e-17, -1.104439845941532e-19,  2.698368218290352e-22, -6.299522779432110e-25,  1.171665411858010e-27,
 -2.538633837309519e-30,  4.253368275847627e-02, -2.173086427932287e-04,  8.215153125956722e-07, -2.708523538435500e-09,  8.151196773441806e-12, -2.274666384821802e-14,
  5.860567557215037e-17, -1.382496121907455e-19,  2.789824721984369e-22, -4.542413883363176e-25,  4.174441482663294e-30,  1.739857893000735e-30,  6.357580873373858e-02,
 -3.233475571220485e-04,  1.208413862923563e-06, -3.897109844739326e-09,  1.129018613733575e-11, -2.957321141566072e-14,  6.831580299847774e-17, -1.309888057378389e-19,
  1.464221085171779e-22,  2.045841181723412e-25, -2.611009139167753e-27,  9.433659617019523e-30,  8.885860833751298e-02, -4.494376885106827e-04,  1.655888207669562e-06,
 -5.192608097851583e-09,  1.430152956202159e-11, -3.418093371626233e-14,  6.540569721269253e-17, -7.103722860867504e-20, -1.663526681694564e-22,  1.360146557839742e-24,
 -6.233190513435254e-27,  1.738170848977947e-29,  1.183986932556833e-01, -5.948936804785894e-04,  2.154288837558805e-06, -6.522913755338759e-09,  1.679720696336530e-11,
 -3.494202934515382e-14,  4.460415826517128e-17,  5.267324080971275e-20, -6.540530276734057e-22,  2.805823765721956e-24, -9.522276407829730e-27,  1.945659540227486e-29,
  1.522145241105087e-01, -7.588676266907037e-04,  2.691948150774022e-06, -7.803578538896249e-09,  1.834883772047732e-11, -3.025861376420046e-14,  2.058471459292977e-18,
  2.397337758637891e-19, -1.248424808544788e-21,  4.069760239997849e-24, -1.029969080318871e-26,  8.029502995488774e-30,  1.903258629166164e-01, -9.403234674156745e-04,
  3.254986055743849e-06, -8.938040956663707e-09,  1.850390381900706e-11, -1.873217582592974e-14, -6.356479691042678e-17,  4.733089599033189e-19, -1.805262972763604e-21,
  4.431994278841979e-24, -6.008631205987196e-27, -2.264933030042839e-29,  2.327530443770103e-01, -1.138005144782055e-03,  3.827087214357789e-06, -9.818239027455998e-09,
  1.680837847551873e-11,  6.223278701490641e-16, -1.498487661678238e-16,  7.159008649795705e-19, -2.103913956581015e-21,  3.037848051950369e-24,  5.321257572155298e-27,
 -7.129770160684774e-29,  2.795160087300071e-01, -1.350397266496837e-03,  4.389253616128823e-06, -1.032582891191960e-08,  1.283786075519646e-11,  2.811239394524044e-14,
 -2.493454850685102e-16,  9.069931983315847e-19, -1.867514513801766e-21, -8.592909241503891e-25,  2.359950365432677e-26, -1.237905250193331e-28,  3.306330189499209e-01,
 -1.575676734214937e-03,  4.919540444234363e-06, -1.033432833936530e-08,  6.239817839825451e-12,  6.305203838141762e-14, -3.484016679542071e-16,  9.643142635873989e-19,
 -8.138067760210129e-22, -7.506000346092469e-24,  4.489504542965380e-26, -1.493146957100376e-28,  3.861189580178358e-01, -1.811653458437829e-03,  5.392790308750128e-06,
 -9.712635785769541e-09, -3.209986000199909e-12,  1.033999151955336e-13, -4.263664389379569e-16,  7.911623370705141e-19,  1.253562907854180e-21, -1.612476489524287e-23,
  5.992244044554895e-26, -1.030415660671378e-28,  4.459830648711048e-01, -2.055697920116773e-03,  5.780392508488842e-06, -8.330556738552621e-09, -1.553350200670327e-11,
  1.453725909730775e-13, -4.556353256965415e-16,  2.929664573092073e-19,  4.307129522712961e-21, -2.435184936662042e-23,  5.391499589675123e-26,  5.844711222283567e-29,
  5.102259165122021e-01, -2.304652987130546e-03,  6.050112558806557e-06, -6.067208731062713e-09, -3.045570656370656e-11,  1.830815805213463e-13, -4.032360911467413e-16,
 -5.933010947936180e-19,  7.916723135094476e-21, -2.786763009234160e-23,  9.668308441683348e-27,  3.430973297467418e-28,  5.788353929909686e-01, -2.554727134433116e-03,
  6.166066643282351e-06, -2.823484279125694e-09, -4.728746457487258e-11,  2.082897915136571e-13, -2.349826368684293e-16, -1.853803393439750e-18,  1.106169144520240e-20,
 -2.065794668198790e-23, -8.400801250037277e-26,  6.709022083657719e-28,  6.517812637232169e-01, -2.801366219467272e-03,  6.088961712282491e-06,  1.459883645832367e-09,
 -6.478799686749889e-11,  2.104593229032468e-13,  7.644004691823945e-17, -3.336567057157820e-18,  1.201637624988672e-20,  3.402592061739541e-24, -2.168021179946167e-25,
  8.210704924220657e-28,  7.290078970601075e-01, -3.039101559651825e-03,  5.776793136282389e-06,  6.776736873217064e-09, -8.101735776496297e-11,  1.773786589338974e-13,
  5.379192757434128e-16, -4.682331789380765e-18,  8.472403864663615e-21,  4.679797545646823e-23, -3.361849768655775e-25,  4.326288397004638e-28,  8.104244056508486e-01,
 -3.261373870320090e-03,  5.186299877342315e-06,  1.302024203178087e-08, -9.320591309346773e-11,  9.681778356064945e-14,  1.115765592934245e-15, -5.272949053226424e-18,
 -1.832321724434065e-21,  1.019364224362659e-22, -3.323189776457087e-25, -8.382510187592923e-28,  8.958912793640790e-01, -3.460336801897259e-03,  4.275636739264374e-06,
  1.993610231250708e-08, -9.769834345915056e-11, -4.015638824775062e-14,  1.709810122556411e-15, -4.254224244246734e-18, -1.963173523479083e-20,  1.431955192948697e-22,
 -5.632401471308357e-26, -2.880356266885040e-27,  9.852022038679391e-01, -3.626652448611502e-03,  3.008948400183315e-06,  2.706391547038065e-08, -9.008188090129749e-11,
 -2.334592679006062e-13,  2.127845468527225e-15, -7.365610502144416e-19, -4.158054218967634e-20,  1.229525847259822e-22,  5.806314109094684e-25, -4.427305553936655e-27,
  1.078059297356341e+00, -3.749307963009182e-03,  1.363821465126743e-06,  3.367077948540818e-08, -6.568916562898076e-11, -4.653472266551002e-13,  2.077714101524700e-15,
  5.680060377778646e-18, -5.716003568630568e-20, -1.505922523986722e-23,  1.387224748119546e-24, -2.670698844403096e-27,  1.174039419331586e+00, -3.815513546124132e-03,
 -6.570980907864579e-07,  3.869143284343859e-08, -2.077005818257451e-11, -6.895411113255491e-13,  1.213688702320305e-15,  1.394442473063541e-17, -4.757616514747995e-20,
 -2.843764019134305e-22,  1.626634832185456e-24,  5.146524404527570e-27,  1.272548570023919e+00, -3.810797553603212e-03, -3.008882207395887e-06,  4.070986971281941e-08,
  4.529571710191336e-11, -8.221621665855668e-13, -7.031603705672565e-16,  2.034521541074655e-17,  7.261438533264457e-21, -5.582462636872473e-22,  1.211588690140353e-25,
  1.604535764163979e-26,  1.372760909990593e+00, -3.719508278816916e-03, -5.580550096251004e-06,  3.805410929815753e-08,  1.264915128567320e-10, -7.455986518014037e-13,
 -3.472665493090247e-15,  1.813078746532115e-17,  1.052776382836574e-19, -4.957841277906288e-22, -3.427015221566466e-24,  1.433271077335884e-26,  1.473539124752865e+00,
 -3.526078287754741e-03, -8.166091083466146e-06,  2.912894162721113e-08,  2.058408126444514e-10, -3.469530850467183e-13, -6.004324234119943e-15,  5.593959532317873e-19,
  1.845846107611572e-19,  2.659745272978404e-22, -5.758095294771471e-24, -1.815876406083282e-26,  1.573334964732898e+00, -3.217602418514909e-03, -1.043789500915443e-05,
  1.315473632808150e-08,  2.528256269441984e-10,  3.829359175296097e-13, -6.163281068270151e-15, -2.966354069244819e-17,  1.187837901222343e-19,  1.377303532677185e-21,
 -2.735533884252989e-25, -5.227906710009693e-26,  1.670075252347558e+00, -2.788450315852906e-03, -1.194356427756500e-05, -8.589347077290941e-09,  2.289733549459714e-10,
  1.199687532782938e-12, -1.911654642164890e-15, -4.873057886648249e-17, -1.479343711946184e-19,  1.163507537746133e-21,  1.103051162017161e-23,  3.621070148488361e-27,
  1.761053523348207e+00, -2.247514959301737e-03, -1.216828403475657e-05, -3.134403543099456e-08,  1.110122072929098e-10,  1.545938164698115e-12,  5.504094503431442e-15,
 -2.204316631455898e-17, -3.457652082312871e-19, -1.282774708502108e-21,  6.216887167349422e-24,  9.456893973403589e-26,  1.842875237224584e+00, -1.627674176486984e-03,
 -1.072076889931026e-05, -4.664361062699202e-08, -6.843365300328290e-11,  9.003410277748999e-13,  9.200977889771398e-15,  3.829642605540735e-17, -6.038572126491238e-20,
 -2.087851718020352e-21, -1.456023490177032e-23, -2.796896824117783e-26,  1.911543641849465e+00, -9.942327630480378e-04, -7.663343260453832e-06, -4.580378057342871e-08,
 -2.008908713489147e-10, -3.964198109907520e-13,  3.283027809251221e-15,  4.606568538662928e-17,  3.146508105950313e-19,  1.163605836985874e-21, -2.117338967827841e-24,
 -7.393657595482772e-26,  1.962801003137439e+00, -4.446010633324674e-04, -3.841851855110434e-06, -2.805380393247588e-08, -1.789327594451958e-10, -9.850078503019949e-13,
 -4.363548136018883e-15, -1.130201127745127e-17,  4.377443118481078e-20,  9.468704903134718e-22,  8.924871736381711e-24,  6.173661211297524e-26,  1.992802516660537e+00,
 -8.919715764947341e-05, -8.233655260464081e-07, -6.695195197622043e-09, -5.046496934120863e-11, -3.601196217400085e-13, -2.456324962276183e-15, -1.607283711767939e-17,
 -1.008566565280364e-19, -6.043351018491680e-22, -3.425071866563174e-24, -1.801038555904591e-26,  5.138232147831477e-04, -2.621409027145027e-06,  1.002748415887833e-08,
 -3.409602010023383e-11,  1.086110571744576e-13, -3.323333083291528e-16,  9.862478609672915e-19, -2.879022529702145e-21,  8.179844440252492e-24, -2.354566530847218e-26,
  6.280638056609183e-29, -1.957430874373133e-31,  4.625054073298020e-03, -2.357663750879350e-05,  9.000077720736306e-08, -3.048716658747144e-10,  9.653373421972542e-13,
 -2.928111243891218e-15,  8.585327574280632e-18, -2.467039115915539e-20,  6.864174198535439e-23, -1.929120646929998e-25,  4.955063213347317e-28, -1.514450034873164e-30,
  1.285094942480744e-02, -6.540100112925323e-05,  2.486270817605916e-07, -8.357797621543317e-10,  2.614065272519761e-12, -7.786815033361735e-15,  2.225548471510045e-17,
 -6.180117943020567e-20,  1.640206296220271e-22, -4.357039569099887e-25,  1.015639634334550e-27, -2.957513370090183e-30,  2.519834173836580e-02, -1.279197634154122e-04,
  4.832408388192083e-07, -1.605456401263691e-09,  4.926044869994851e-12, -1.425520883109973e-14,  3.905440295870099e-17, -1.021632345320886e-19,  2.479748343282604e-22,
 -5.853628354125794e-25,  1.056618538491228e-27, -2.702503442929521e-30,  4.167738966960877e-02, -2.108643463816688e-04,  7.897807762240500e-07, -2.581668732655492e-09,
  7.710020458015019e-12, -2.138558580892417e-14,  5.485721323171868e-17, -1.295836523182722e-19,  2.626484742938033e-22, -4.528467953977524e-25,  5.803426144989621e-29,
  7.058055051282505e-31,  6.230146122359729e-02, -3.138642809392400e-04,  1.162713169518120e-06, -3.721110733968912e-09,  1.071482338178345e-11, -2.797710881608099e-14,
  6.471468154990846e-17, -1.262048424151269e-19,  1.520012386482225e-22,  1.077864174825298e-25, -2.245111997248551e-27,  7.202346064202757e-30,  8.708696258056015e-02,
 -4.364359894262838e-04,  1.594927572318068e-06, -4.969167971758511e-09,  1.363344421963791e-11, -3.263562346367230e-14,  6.334915525299688e-17, -7.562374801470745e-20,
 -1.216992157519215e-22,  1.125208800923052e-24, -5.536240642449889e-27,  1.428416377042036e-29,  1.160530977943070e-01, -5.779679535297585e-04,  2.077603532302084e-06,
 -6.259690544728782e-09,  1.610917900103135e-11, -3.385610564826955e-14,  4.580066374777922e-17,  3.328781714482907e-20, -5.596997966419323e-22,  2.441311623202394e-24,
 -8.722577894988536e-27,  1.681203153708394e-29,  1.492215386875401e-01, -7.377016683351652e-04,  2.600046740782502e-06, -7.514833626570134e-09,  1.774468042815778e-11,
 -3.013304165362803e-14,  8.233185557089756e-18,  2.020495485724107e-19, -1.109243073250881e-21,  3.664930788455015e-24, -9.941732813668445e-27,  8.035073813229518e-30,
  1.866159766000411e-01, -9.147076008633330e-04,  3.149493319329843e-06, -8.645054141857426e-09,  1.811504509860917e-11, -2.010508125116276e-14, -5.109725941067073e-17,
  4.180451357312116e-19, -1.650262809147637e-21,  4.173308208848563e-24, -6.890154230127472e-27, -1.777397556821504e-29,  2.282615174612516e-01, -1.107855150951860e-03,
  3.710881746432548e-06, -9.549394122368186e-09,  1.678644610793974e-11, -2.741005208718837e-15, -1.307293962591510e-16,  6.503605584494837e-19, -1.991446610705457e-21,
  3.191165512669128e-24,  2.419374808115898e-27, -6.103759983501916e-29,  2.741838679423469e-01, -1.315775344796695e-03,  4.266593628062527e-06, -1.011624179053969e-08,
  1.334228777973782e-11,  2.242607675631518e-14, -2.247897341841021e-16,  8.469095409451565e-19, -1.882736025645588e-21, -2.053703393789969e-26,  1.842684962426996e-26,
 -1.116298398123033e-28,  3.244082417699987e-01, -1.536814668258108e-03,  4.796167694320846e-06, -1.022484811931171e-08,  7.419413048064098e-12,  5.501122761280349e-14,
 -3.218036795105197e-16,  9.342828073430669e-19, -1.053269770760679e-21, -5.840269770467454e-24,  3.842624887211382e-26, -1.445652696284464e-28,  3.789578896387794e-01,
 -1.768978062008341e-03,  5.275996984398432e-06, -9.747999950469145e-09, -1.242500075469207e-12,  9.343696402881763e-14, -4.037363194326737e-16,  8.224418840310362e-19,
  7.150724605007971e-22, -1.382400012535014e-23,  5.499079190358713e-26, -1.202381241245424e-28,  4.378521206700790e-01, -2.009858654763713e-03,  5.679028641012825e-06,
 -8.556424245550522e-09, -1.273466110871384e-11,  1.345505594136007e-13, -4.456314713374896e-16,  4.171882015879583e-19,  3.469751818847360e-21, -2.216012505792431e-23,
  5.528418039535988e-26,  5.279382442340409e-30,  5.011036339243262e-01, -2.256551321789575e-03,  5.974501422558613e-06, -6.525737948097356e-09, -2.689205319601223e-11,
  1.732322684177264e-13, -4.164519542398909e-16, -3.559151586506748e-19,  6.923842418324262e-21, -2.720583094540212e-23,  2.276910861954162e-26,  2.535119490719927e-28,
  5.687149091911387e-01, -2.505546676197636e-03,  6.127781667520968e-06, -3.547080700635649e-09, -4.318206527857231e-11,  2.020666204122316e-13, -2.820495921696741e-16,
 -1.512320651020884e-18,  1.026438891480574e-20, -2.345489418412422e-23, -5.652290553140626e-26,  5.771246928929535e-28,  6.406733087276983e-01, -2.752601753297911e-03,
  6.100399809462156e-06,  4.570178839329460e-10, -6.056780730221997e-11,  2.112163038075221e-13, -1.159360324536097e-17, -2.951686277282700e-18,  1.199145943159767e-20,
 -4.549602137991405e-24, -1.809407472391986e-25,  8.029106263204725e-28,  7.169444037939581e-01, -2.992583693959150e-03,  5.850455534073190e-06,  5.509497175557393e-09,
 -7.735113888528428e-11,  1.887475591662547e-13,  4.108446220185398e-16, -4.386813959342538e-18,  9.920174989703082e-21,  3.378630550726054e-23, -3.131576308380539e-25,
  6.030542892680312e-28,  7.974628449205555e-01, -3.219283695325946e-03,  5.333663489443748e-06,  1.154584295082097e-08, -9.101375292127568e-11,  1.218211186820841e-13,
  9.678351488382497e-16, -5.275497843526529e-18,  1.590408668043647e-21,  8.803455747642570e-23, -3.596944926368252e-25, -4.156535927709042e-28,  8.821198199094527e-01,
 -3.425201395779811e-03,  4.505471531461458e-06,  1.836869167086496e-08, -9.810111211616012e-11, -6.166112733393108e-16,  1.582667307797912e-15, -4.800633062743691e-18,
 -1.454644894671561e-20,  1.385562092852169e-22, -1.718816142649216e-25, -2.364847211403017e-27,  9.707457590688302e-01, -3.601306632615656e-03,  3.324922404609874e-06,
  2.558801694033813e-08, -9.424281301579233e-11, -1.827845757049406e-13,  2.089288843095985e-15, -1.992216897162527e-18, -3.678321611658415e-20,  1.422771995732879e-22,
  3.859326585639568e-25, -4.382287337603068e-27,  1.063086419492274e+00, -3.736799750797961e-03,  1.761266444937539e-06,  3.254805697113536e-08, -7.448564535842882e-11,
 -4.137804028035538e-13,  2.211141498684146e-15,  3.852720667863117e-18, -5.673530519720103e-20,  3.768695364947329e-23,  1.240994466643476e-24, -3.918017061979567e-27,
  1.158769782782731e+00, -3.818919828703792e-03, -1.952444377468846e-07,  3.825049752392649e-08, -3.423889674203426e-11, -6.559082915670099e-13,  1.581371302445624e-15,
  1.227114225000028e-17, -5.659481001843057e-20, -2.155351956029984e-22,  1.796642755008306e-24,  2.571053349390398e-27,  1.257260347383898e+00, -3.832903471762090e-03,
 -2.516560449340509e-06,  4.130233224030851e-08,  2.872991536291010e-11, -8.321942678912290e-13, -1.332478530813922e-16,  2.025833186441144e-17, -1.258057946731498e-20,
 -5.395744183512699e-22,  8.030868714131847e-25,  1.476465668926357e-26,  1.357796527228670e+00, -3.762292838495500e-03, -5.112263875461928e-06,  3.995432859757587e-08,
  1.107891148326066e-10, -8.224874004614302e-13, -2.920703260095677e-15,  2.118897117614058e-17,  8.512813345237996e-20, -6.187115265148458e-22, -2.683592005506743e-24,
  1.923494273942212e-26,  1.459306446227665e+00, -3.589953416685093e-03, -7.797037373553766e-06,  3.235906992831333e-08,  1.974654629939347e-10, -4.901942294560207e-13,
 -5.904853012316530e-15,  6.573443436725661e-18,  1.898448975788744e-19,  2.229028998046148e-23, -6.357749514599544e-24, -8.785704962950807e-27,  1.560298646283653e+00,
 -3.300404854195188e-03, -1.025554096075271e-05,  1.725290510326442e-08,  2.589402945342314e-10,  2.255253700335946e-13, -6.933232768490717e-15, -2.507585387602462e-17,
  1.675990068057334e-19,  1.318619593292507e-21, -2.695418609411711e-24, -5.703306794998235e-26,  1.658729791572016e+00, -2.884347032991555e-03, -1.202387257108071e-05,
 -4.736789204133808e-09,  2.523951982653146e-10,  1.136941164236667e-12, -3.335481515534129e-15, -5.270921850059427e-17, -9.812707275311389e-20,  1.601326986578678e-21,
  1.068867520444279e-23, -1.993691180891735e-26,  1.751866434603857e+00, -2.346333154638446e-03, -1.253271234823645e-05, -2.931354554175354e-08,  1.431953235480558e-10,
  1.669338894132826e-12,  4.725431299381351e-15, -3.379013060356798e-17, -3.864260032505038e-19, -9.465641754101199e-22,  1.068814219178500e-23,  1.074746324759811e-25,
  1.836189438927977e+00, -1.715696386685259e-03, -1.128642778282531e-05, -4.758213671121425e-08, -4.813317946794005e-11,  1.133740220172331e-12,  1.023411218560169e-14,
  3.504707199745445e-17, -1.462658135652631e-19, -2.687818770403150e-21, -1.523927059523417e-23, -6.247813100299837e-28,  1.907440538319054e+00, -1.057793305398413e-03,
 -8.232520671945082e-06, -4.907672111261914e-08, -2.079208221426942e-10, -3.009733423892201e-13,  4.719971754414626e-15,  5.678145620555710e-17,  3.541427378858424e-19,
  1.003914722840187e-21, -6.127947446075948e-24, -1.097304061141887e-25,  1.960958926433990e+00, -4.767326651737239e-04, -4.196343870216752e-06, -3.108012372514666e-08,
 -1.997048398423772e-10, -1.093338096282131e-12, -4.654745674903925e-15, -9.281339263088811e-18,  8.498504002629016e-20,  1.362915596603952e-21,  1.199814138227352e-23,
  7.830250482909543e-26,  1.992432025219286e+00, -9.611974667804092e-05, -9.088009944043893e-07, -7.563616736091691e-09, -5.829530664671698e-11, -4.248576794565652e-13,
 -2.955016699372911e-15, -1.967641237289525e-17, -1.252810201783908e-19, -7.584355594724318e-22, -4.312260806269488e-24, -2.244671872314778e-26,  5.034954681745939e-04,
 -2.542796717556344e-06,  9.628543331462084e-09, -3.241015733357452e-11,  1.021947104745359e-13, -3.096018992178557e-16,  9.091757320889681e-19, -2.630361490027846e-21,
  7.375390878111992e-24, -2.120075450082765e-26,  5.455006110238585e-29, -1.805297925001446e-31,  4.532164730363384e-03, -2.287100693848186e-05,  8.643309268156708e-08,
 -2.898838014088538e-10,  9.087808995240831e-13, -2.730110708451700e-15,  7.924290609882832e-18, -2.258127577954469e-20,  6.203791589706331e-23, -1.743919082749635e-25,
  4.312253116198410e-28, -1.415211011116086e-30,  1.259326092276696e-02, -6.345140252828645e-05,  2.388436280078620e-07, -7.951721649068943e-10,  2.463533127825237e-12,
 -7.272869717084650e-15,  2.059622934059436e-17, -5.679589641117106e-20,  1.490355051117874e-22, -3.976473129661276e-25,  8.878508719291504e-28, -2.867606359577722e-30,
  2.469427438688353e-02, -1.241295800697270e-04,  4.644390162203594e-07, -1.528870546523580e-09,  4.650086596436607e-12, -1.335135251559680e-14,  3.630181392407645e-17,
 -9.455728822611756e-20,  2.276332765076216e-22, -5.455442593679949e-25,  9.324103707329964e-28, -2.964478699229858e-30,  4.084637548804719e-02, -2.046679551928753e-04,
  7.595270272963707e-07, -2.461659781992883e-09,  7.295185421803514e-12, -2.011161810797736e-14,  5.134409013057863e-17, -1.214392508576112e-19,  2.463924010725724e-22,
 -4.502196014234544e-25,  6.532568545263422e-29, -3.946086674334639e-31,  6.106432876524630e-02, -3.047383164492330e-04,  1.119070268959193e-06, -3.554066700867765e-09,
  1.017052935005559e-11, -2.646580866909701e-14,  6.124950568259901e-17, -1.212954696953403e-19,  1.543354271315911e-22,  2.365787922789701e-26, -1.977905742893243e-27,
  4.921357751577252e-30,  8.536636497775871e-02, -4.239114296866144e-04,  1.536585093392229e-06, -4.756172684090816e-09,  1.299576191200975e-11, -3.114105745099257e-14,
  6.118296082015731e-17, -7.891156919905499e-20, -8.503487964981481e-23,  9.153861539682135e-25, -4.978678917623996e-27,  1.101433143989821e-29,  1.137739980187910e-01,
 -5.616432597926289e-04,  2.004011576162165e-06, -6.007300652045647e-09,  1.544311442041536e-11, -3.274765005108208e-14,  4.649471752803885e-17,  1.671767480217399e-20,
 -4.779226675140203e-22,  2.106303609171838e-24, -8.051254974368801e-27,  1.359065354462777e-29,  1.463117683883662e-01, -7.172572255931139e-04,  2.511552378639598e-06,
 -7.235727437426986e-09,  1.714443358584848e-11, -2.987144839177103e-14,  1.341292336618374e-17,  1.685886965869405e-19, -9.843808233136535e-22,  3.274047782941484e-24,
 -9.611946326783535e-27,  6.722622073912467e-30,  1.830068879809472e-01, -8.899217205885274e-04,  3.047478239388158e-06, -8.358492989917076e-09,  1.770159799962663e-11,
 -2.119678277928714e-14, -4.010911519976299e-17,  3.675858896452748e-19, -1.505164166262796e-21,  3.883009839187250e-24, -7.605413341306099e-27, -1.512190330942835e-29,
  2.238887516505779e-01, -1.078621907228582e-03,  3.597898171134365e-06, -9.281413953365321e-09,  1.670168920272865e-11, -5.667083950841682e-15, -1.133940946442099e-16,
  5.884859512682593e-19, -1.875447581175840e-21,  3.236642414549070e-24, -9.105170081962558e-29, -5.356566786795878e-29,  2.689882683928627e-01, -1.282124514053116e-03,
  4.146493459636766e-06, -9.899462199461373e-09,  1.373874539979564e-11,  1.730888093665034e-14, -2.019188844167138e-16,  7.867829966692689e-19, -1.871363065793447e-21,
  6.214174887061793e-25,  1.374333943862109e-26, -1.016958775513567e-28,  3.183369476475346e-01, -1.498934020398303e-03,  4.674216752785592e-06, -1.009774652265817e-08,
  8.444503200388493e-12,  4.759786573313375e-14, -2.961451899427289e-16,  8.974984777233492e-19, -1.237371938108054e-21, -4.428946991983911e-24,  3.217593495036057e-26,
 -1.396430179433677e-28,  3.719656522003667e-01, -1.727238189448025e-03,  5.158961689492392e-06, -9.753448639168162e-09,  5.312192530076976e-13,  8.402577361301966e-14,
 -3.804594441672041e-16,  8.377755129158808e-19,  2.556896219434464e-22, -1.173421354704870e-23,  4.940474369681008e-26, -1.331539959792101e-28,  4.299028955958364e-01,
 -1.964840397065156e-03,  5.575215954996651e-06, -8.739227649152957e-09, -1.014959352047161e-11,  1.240074040800199e-13, -4.325126421231299e-16,  5.158824403014242e-19,
  2.711721400798899e-21, -1.995790180742803e-23,  5.449870240508626e-26, -3.983197146016185e-29,  4.921725147199911e-01, -2.209075600699250e-03,  5.893723496079832e-06,
 -6.928839639033750e-09, -2.352803793520707e-11,  1.631419724590627e-13, -4.234615630235931e-16, -1.498266609882249e-19,  5.963287355425700e-21, -2.609682742378289e-23,
  3.207814414758382e-26,  1.707167623365189e-28,  5.587904812348297e-01, -2.456706123569917e-03,  6.081203355685495e-06, -4.206044618162967e-09, -3.921166625853138e-11,
  1.948256118853154e-13, -3.199258938879530e-16, -1.197758642961770e-18,  9.385172334775570e-21, -2.523697067047307e-23, -3.330732473046778e-26,  4.774311165378393e-28,
  6.297605200097667e-01, -2.703792771593159e-03,  6.100208793450973e-06, -4.783148647039479e-10, -5.635273483754235e-11,  2.099894522765734e-13, -8.890282991851714e-17,
 -2.571908639360494e-18,  1.170579650490733e-20, -1.109362363864794e-23, -1.466354399796509e-25,  7.515086508240844e-28,  7.050680657079997e-01, -2.945536343159619e-03,
  5.909269987117117e-06,  4.302573200699405e-09, -7.348734443988807e-11,  1.971707707176618e-13,  2.926239964860106e-16, -4.052270901710909e-18,  1.091773594742885e-20,
  2.182632692594225e-23, -2.840727740456619e-25,  7.086476409509877e-28,  7.846718915440208e-01, -3.176084749570745e-03,  5.463560637749844e-06,  1.011032625735177e-08,
 -8.835697315691369e-11,  1.432851742383200e-13,  8.212901836290579e-16, -5.176702770322036e-18,  4.497279374131894e-21,  7.339141379095524e-23, -3.698564252471763e-25,
 -5.797924255472561e-29,  8.684924602359503e-01, -3.388302597589841e-03,  4.716484275947598e-06,  1.680099242753190e-08, -9.774474449804217e-11,  3.570634807343308e-14,
  1.442472046418383e-15, -5.187832044121428e-18, -9.705816639436023e-21,  1.297581905601958e-22, -2.640911550668680e-25, -1.826150691270422e-27,  9.563956394527591e-01,
 -3.573504922846546e-03,  3.622819427732678e-06,  2.405358953533258e-08, -9.740226051889962e-11, -1.334392065042794e-13,  2.017816967588323e-15, -3.084722374976145e-18,
 -3.142928152715071e-20,  1.539217418929005e-22,  1.982240263420922e-25, -4.118275273470365e-27,  1.048169844996629e+00, -3.721168182645636e-03,  2.144428842806056e-06,
  3.129299811574407e-08, -8.222289521440285e-11, -3.596220600909817e-13,  2.293870486239262e-15,  2.068124199169434e-18, -5.452926149097270e-20,  8.359249216836537e-23,
  1.047871498917539e-24, -4.798158096268109e-27,  1.143493872150112e+00, -3.818656056323033e-03,  2.600486888362121e-07,  3.759990501011226e-08, -4.695078875686771e-11,
 -6.140435923802081e-13,  1.898542279724667e-15,  1.035000603895975e-17, -6.304012507325570e-20, -1.421625721629593e-22,  1.853509345305150e-24,  3.681896524865168e-29,
  1.241891616871222e+00, -3.851046893983089e-03, -2.018723677144984e-06,  4.162887786149184e-08,  1.209968605374917e-11, -8.286486041570585e-13,  4.254805524421615e-16,
  1.955239361661040e-17, -3.127593418789801e-20, -4.950715755736434e-22,  1.405174918291418e-24,  1.245103991031084e-26,  1.342668637046487e+00, -3.801244280989293e-03,
 -4.622730792091960e-06,  4.159175484036436e-08,  9.368795560556991e-11, -8.851782402949584e-13, -2.292760906690499e-15,  2.353770030063848e-17,  6.113659111314131e-20,
 -7.080225523566559e-22, -1.757728664737013e-24,  2.255663971855436e-26,  1.444824414034073e+00, -3.650723564471344e-03, -7.390120119551799e-06,  3.543246125304798e-08,
  1.862628667781655e-10, -6.290165742638026e-13, -5.635978852595986e-15,  1.261166584516754e-17,  1.860047559968198e-19, -2.366442066966396e-22, -6.510293548968368e-24,
  1.999489341566935e-27,  1.546934349241932e+00, -3.381550327754900e-03, -1.002352889528566e-05,  2.142276567414066e-08,  2.617332691526540e-10,  5.135133125550522e-14,
 -7.553312866164154e-15, -1.897890186123227e-17,  2.125206503159555e-19,  1.160343455471939e-21, -5.214930487008995e-24, -5.654657507438563e-26,  1.646999760642457e+00,
 -2.980695030570418e-03, -1.205574919529558e-05, -5.214123782858762e-10,  2.742123642994988e-10,  1.038880648636194e-12, -4.846058088993468e-15, -5.484658382240149e-17,
 -3.306570738504172e-20,  2.003509365589598e-21,  9.222184458358465e-24, -4.711131307351737e-26,  1.742278409138990e+00, -2.447960378753830e-03, -1.286960736006933e-05,
 -2.674951137332441e-08,  1.776322252728146e-10,  1.769970139987325e-12,  3.601708474625832e-15, -4.660909570445911e-17, -4.116489540243433e-19, -4.226141111410439e-22,
  1.553469835180070e-23,  1.108805818490167e-25,  1.829142438194382e+00, -1.808283032132570e-03, -1.186124182499766e-05, -4.815720091876543e-08, -2.292582948626328e-11,
  1.390512228427975e-12,  1.113452074554423e-14,  2.870133518787275e-17, -2.539054389942067e-19, -3.286654013993075e-21, -1.439507790847258e-23,  4.160186946114543e-26,
  1.903073834544915e+00, -1.126066122564160e-03, -8.841578896110512e-06, -5.244489115082282e-08, -2.126719624505792e-10, -1.673034151656445e-13,  6.473546123161679e-15,
  6.863480034569997e-17,  3.845967805958514e-19,  6.499185022245384e-22, -1.188966233068656e-23, -1.533258399183500e-25,  1.958982413254079e+00, -5.118512835137105e-04,
 -4.589218511114227e-06, -3.445648726147779e-08, -2.227079976084176e-10, -1.207814396334717e-12, -4.868472832143513e-15, -5.677101105815937e-18,  1.435666563449832e-19,
  1.916996565852695e-21,  1.583725297993621e-23,  9.630101971984427e-26,  1.992032407312269e+00, -1.037697363428387e-04, -1.005454164906840e-06, -8.568368017824646e-09,
 -6.754874314985723e-11, -5.028688392272416e-13, -3.566435760712332e-15, -2.415757390868528e-17, -1.559409275506083e-19, -9.521586518162951e-22, -5.411848764228102e-24,
 -2.765565522381151e-26,  4.934759134575947e-04, -2.467296724510164e-06,  9.249231571484217e-09, -3.082341727481684e-11,  9.621504389831680e-14, -2.886395042416568e-16,
  8.387179604073030e-19, -2.406154833697107e-21,  6.649554277325469e-24, -1.917454804931680e-26,  4.682347675432784e-29, -1.718798300826289e-31,  4.442041944507465e-03,
 -2.219321351477712e-05,  8.303996105232277e-08, -2.757700024658184e-10,  8.560304359398770e-13, -2.547296398317277e-15,  7.318887100321041e-18, -2.069330379863196e-20,
  5.605545285558954e-23, -1.583703857025066e-25,  3.701886951442981e-28, -1.369101962174107e-30,  1.234321730925587e-02, -6.157816257004462e-05,  2.295333466593103e-07,
 -7.568929677016842e-10,  2.322892745350242e-12, -6.797117710108648e-15,  1.907060751957669e-17, -5.224919741490267e-20,  1.353290771695117e-22, -3.646552654021675e-25,
  7.615445183175628e-28, -2.896883314564147e-30,  2.420507265596179e-02, -1.204862088935597e-04,  4.465303169970589e-07, -1.456558925424133e-09,  4.391561703457149e-12,
 -1.251107500440001e-14,  3.375328688708653e-17, -8.758032020805271e-20,  2.086325918458992e-22, -5.109683132990931e-25,  7.932486456379621e-28, -3.397203648191266e-30,
  4.003967177515754e-02, -1.987079444939529e-04,  7.306743878017256e-07, -2.348088861711762e-09,  6.905004758146174e-12, -1.891928753751574e-14,  4.805174160817943e-17,
 -1.138135714942206e-19,  2.302240797883304e-22, -4.483160615668141e-25,  2.041126408571252e-29, -1.693948210842478e-30,  5.986301436777595e-02, -2.959536228300334e-04,
  1.077380627519619e-06, -3.395494035986151e-09,  9.655640845515448e-12, -2.503601748288359e-14,  5.792239621983246e-17, -1.163579974762057e-19,  1.538087119441597e-22,
 -5.184528679943317e-26, -1.815638326779439e-27,  2.392133748838004e-30,  8.369494807999681e-02, -4.118435572008890e-04,  1.480738317600460e-06, -4.553144036503436e-09,
  1.238744423729596e-11, -2.969945906709818e-14,  5.894002648744723e-17, -8.114297218747816e-20, -5.555827494290392e-23,  7.248869607214189e-25, -4.573122864077828e-27,
  7.322432401329539e-30,  1.115590384750162e-01, -5.458953664693653e-04,  1.933385090628558e-06, -5.765389687279301e-09,  1.479934942518217e-11, -3.162781999041210e-14,
  4.675966569414877e-17,  2.576328434336820e-21, -4.077586244974604e-22,  1.795090403532400e-24, -7.538982612906962e-27,  9.521842927596698e-30,  1.434823809325194e-01,
 -6.975075034783127e-04,  2.426349860749124e-06, -6.966176899050704e-09,  1.655058813520956e-11, -2.949634568144574e-14,  1.770959751966548e-17,  1.389006951442955e-19,
 -8.733707920131451e-22,  2.894761425278583e-24, -9.373454467909894e-27,  3.818865500329098e-30,  1.794953322594841e-01, -8.659383200442150e-04,  2.948861526949071e-06,
 -8.078707806322947e-09,  1.726884225304515e-11, -2.204120832536701e-14, -3.047043503455322e-17,  3.215972525225818e-19, -1.371009581140235e-21,  3.565720390355473e-24,
 -8.258180196037658e-27, -1.501212764081899e-29,  2.196311314058562e-01, -1.050279696417125e-03,  3.488120361622372e-06, -9.015236043698406e-09,  1.656243303518772e-11,
 -8.197485034957648e-15, -9.773920305990136e-17,  5.303307158546864e-19, -1.759547990767522e-21,  3.187353581465492e-24, -2.342942799134279e-27, -4.940006643654406e-29,
  2.639253671811324e-01, -1.249423978987312e-03,  4.029029423931039e-06, -9.677128785609060e-09,  1.403821203891320e-11,  1.272044419869510e-14, -1.807232616178924e-16,
  7.273548010940111e-19, -1.840154237681695e-21,  1.083911732333021e-24,  9.430513112070670e-27, -9.497137856535503e-29,  3.124152349402164e-01, -1.462022611422335e-03,
  4.553884653643034e-06, -9.955396524377187e-09,  9.327397478221731e-12,  4.078732758621268e-14, -2.715918429375668e-16,  8.555879554307997e-19, -1.375117167016461e-21,
 -3.263622014604738e-24,  2.611520505828141e-26, -1.362599761960269e-28,  3.651385019358738e-01, -1.686434392439558e-03,  5.042025174642171e-06, -9.731993139067294e-09,
  2.122327704241004e-12,  7.517678712080816e-14, -3.569480345347289e-16,  8.395684198912061e-19, -1.326127644741910e-22, -9.878496986588872e-24,  4.330085808811832e-26,
 -1.442171080659242e-28,  4.221320696280361e-01, -1.920660728189702e-03,  5.469450894007695e-06, -8.882338878053597e-09, -7.772030537664568e-12,  1.138095938177747e-13,
 -4.169581185701848e-16,  5.915783547122480e-19,  2.031944359730446e-21, -1.782494043393614e-23,  5.186196504135734e-26, -7.934676872154877e-29,  4.834299765889628e-01,
 -2.162264552276916e-03,  5.808424610782353e-06, -7.279738773711596e-09, -2.036706127648596e-11,  1.529492575426165e-13, -4.251245489599062e-16,  2.622771341571772e-20,
  5.048497990472025e-21, -2.468647243457520e-23,  3.787971737876067e-26,  9.380339060307942e-29,  5.490606216645203e-01, -2.408268759068978e-03,  6.027093704133654e-06,
 -4.802687166697322e-09, -3.539448095450903e-11,  1.867780326196787e-13, -3.493967652543139e-16, -9.121874654096206e-19,  8.457448864803652e-21, -2.617924877861239e-23,
 -1.455702017455748e-26,  3.743992287238465e-28,  6.190428946924349e-01, -2.655029069990633e-03,  6.089197304964712e-06, -1.346499967179231e-09, -5.217989851029584e-11,
  2.070335433039122e-13, -1.557398159254803e-16, -2.204781665193034e-18,  1.120862693362471e-20, -1.631900258923302e-23, -1.152050641886626e-25,  6.730973872070044e-28,
  6.933807678296011e-01, -2.898075346316666e-03,  5.953977345532610e-06,  3.158666735853032e-09, -6.948268298583814e-11,  2.028723112998513e-13,  1.841544045752523e-16,
 -3.692462307678814e-18,  1.150663314667659e-20,  1.110457369090917e-23, -2.516854916626380e-25,  7.539441307134345e-28,  7.720557042672712e-01, -3.131914777397035e-03,
  5.576500186873861e-06,  8.720562317745564e-09, -8.530580675704665e-11,  1.612753678629614e-13,  6.787341225518245e-16, -4.993371233746256e-18,  6.873277427758074e-21,
  5.863493062661462e-23, -3.659119398162229e-25,  2.241761968541160e-28,  8.550159530220964e-01, -3.349790796069543e-03,  4.908742212451061e-06,  1.524462054975251e-08,
 -9.669635359215953e-11,  6.855170905481311e-14,  1.293551394936815e-15, -5.425864028199118e-18, -5.242607294971057e-21,  1.177435713626298e-22, -3.328359752482901e-25,
 -1.304436223623778e-27,  9.421613752964878e-01, -3.543394474428370e-03,  3.902032253511612e-06,  2.247640298213396e-08, -9.959433017921008e-11, -8.615654817154023e-14,
  1.918206337609631e-15, -4.000617879965749e-18, -2.578801246928908e-20,  1.583423127981130e-22,  2.591371039710089e-26, -3.692390257672950e-27,  1.033321829125696e+00,
 -3.702533579729518e-03,  2.511823806343295e-06,  2.992289964926737e-08, -8.886112321732948e-11, -3.040683970913777e-13,  2.327856485383495e-15,  3.790026879317999e-19,
 -5.081799236199185e-20,  1.211091461067094e-22,  8.242691124187276e-25, -5.305559736051603e-27,  1.128226247057813e+00, -3.814784558775879e-03,  7.063432831382474e-07,
  3.675301548973020e-08, -5.875373294348950e-11, -5.652331467494902e-13,  2.159432915675086e-15,  8.265106276988934e-18, -6.682948466740951e-20, -6.869138095844845e-23,
  1.803208120379336e-24, -2.273399171559546e-27,  1.226458296502497e+00, -3.865196461174358e-03, -1.518560180548207e-06,  4.169062778553851e-08, -4.327478739799660e-12,
 -8.119966150383797e-13,  9.563399269675064e-16,  1.827827125847665e-17, -4.796253629715872e-20, -4.287720336293658e-22,  1.887217400031418e-24,  9.355073364021926e-27,
  1.327392891382408e+00, -3.836205603737384e-03, -4.115228971360109e-06,  4.294637160159781e-08,  7.548855265536970e-11, -9.320987528861433e-13, -1.610233242257223e-15,
  2.507465831063986e-17,  3.462678367958848e-20, -7.579191048950838e-22, -7.267384675501220e-25,  2.397739457350291e-26,  1.430106040926359e+00, -3.708094106996234e-03,
 -6.947487949689227e-06,  3.830480719858273e-08,  1.723619397596883e-10, -7.593796145390983e-13, -5.201159160092319e-15,  1.837762023827572e-17,  1.728492673833750e-19,
 -4.920126713393682e-22, -6.177184071855268e-24,  1.309374103680072e-26,  1.533249500125629e+00, -3.460639061492454e-03, -9.741327786020537e-06,  2.560869829943313e-08,
  2.609085862895056e-10, -1.354995747066682e-13, -7.983547930142291e-15, -1.155493054740994e-17,  2.499511028434228e-19,  9.034394544106168e-22, -7.583357003164010e-24,
 -5.010622393514102e-26,  1.634884156230290e+00, -3.077089930719033e-03, -1.203501799531973e-05,  4.025363681568077e-09,  2.937022050742106e-10,  9.040963173189749e-13,
 -6.385251212530376e-15, -5.468402028309514e-17,  4.512561903934332e-20,  2.322662547725484e-21,  6.531914375802102e-24, -7.499860327700502e-26,  1.732278692736765e+00,
 -2.552150179658934e-03, -1.317236668618178e-05, -2.361997455361111e-08,  2.137825924995027e-10,  1.839252429171637e-12,  2.110857735548153e-15, -5.989591277653059e-17,
 -4.145181048670038e-19,  2.943946221909280e-22,  2.023917016228081e-23,  1.003063828074920e-25,  1.821715860352846e+00, -1.905488539007557e-03, -1.244036364168442e-05,
 -4.828675753861347e-08,  7.616571638845660e-12,  1.666353058167037e-12,  1.180585411522228e-14,  1.857663271719958e-17, -3.820048974816654e-19, -3.809873992771817e-21,
 -1.134224127103779e-23,  9.974632098698156e-26,  1.898424037052446e+00, -1.199374151392947e-03, -9.491415328217345e-06, -5.586529092673170e-08, -2.143014499217895e-10,
  1.253168169774194e-14,  8.570402287727252e-15,  8.121042530845822e-17,  3.976791308739969e-19,  2.526002526353325e-23, -1.969969738347222e-23, -2.021706799292026e-25,
  1.956858873938248e+00, -5.502813969175231e-04, -5.024894171270268e-06, -3.821945786010788e-08, -2.480426245131213e-10, -1.325977764011486e-12, -4.951817777868714e-15,
  1.520886585581352e-19,  2.250503171059233e-19,  2.640452067719723e-21,  2.046069643875805e-23,  1.134162067029186e-25,  1.991600562918319e+00, -1.122438203450082e-04,
 -1.115106872245798e-06, -9.734498100491093e-09, -7.851990815676024e-11, -5.971773518012028e-13, -4.318174591675345e-15, -2.974038641233144e-17, -1.944236592524935e-19,
 -1.194649430638739e-21, -6.755144427771475e-24, -3.347729099773644e-26,  };
  constexpr double w[13056] = {  9.099105119343424e-02, -3.524116160728746e-04,  1.443987155499555e-06, -6.160241104054297e-09,  2.694442244445778e-11,
 -1.194174656852010e-13,  5.320435643709383e-16, -2.371478988332509e-18,  1.054594370468437e-20, -4.672301372866182e-23,  2.060931073595905e-25, -9.048687685878135e-28,
  9.043718742017449e-02, -5.307343094226954e-04,  3.612865491589515e-06, -2.437159737600917e-08,  1.584676264509986e-10, -9.953043635737092e-13,  6.073055767047627e-15,
 -3.617117384550536e-17,  2.110383216162722e-19, -1.209364523399848e-21,  6.820889999660501e-24, -3.792360490359957e-26,  8.934369705140911e-02, -8.795091313932533e-04,
  8.884524790133165e-06, -8.137171640232790e-08,  6.914467850987947e-10, -5.554173657003233e-12,  4.266565275150475e-14, -3.158485141887529e-16,  2.265773933921263e-18,
 -1.581592324663091e-20,  1.077744199857843e-22, -7.187556910924400e-25,  8.773826331593329e-02, -1.383508736436217e-03,  1.900123355935989e-05, -2.249564985840595e-07,
  2.409794298627418e-09, -2.396203309327350e-11,  2.246200397829473e-13, -2.005745927661549e-15,  1.718873267698850e-17, -1.421586427330355e-19,  1.139554396114744e-21,
 -8.883602260255393e-24,  8.566050341104491e-02, -2.021126810935572e-03,  3.627936162095036e-05, -5.412401571218811e-07,  7.140239847840816e-09, -8.597708484791040e-11,
  9.633612085468979e-13, -1.017534057775450e-14,  1.022489319420706e-16, -9.842206884635760e-19,  9.123051863860905e-21, -8.176770426058244e-23,  8.315986699702042e-02,
 -2.765727005185174e-03,  6.329731367674434e-05, -1.166383046957345e-06,  1.860947694833610e-08, -2.668928388717569e-10,  3.520023275820451e-12, -4.334651682357738e-14,
  5.037790668102959e-16, -5.570264772391292e-18,  5.895641257747964e-20, -6.001706457268515e-22,  8.029312200082145e-02, -3.587238988553908e-03,  1.025458441464516e-04,
 -2.294402058606623e-06,  4.361625818256566e-08, -7.350948903232292e-10,  1.127118043435459e-11, -1.599509260049721e-13,  2.126580156375093e-15, -2.672861858938302e-17,
  3.198046820053485e-19, -3.662153697529930e-21,  7.712162875331928e-02, -4.453862056827944e-03,  1.560840912689231e-04, -4.176905384024850e-06,  9.339319539168986e-08,
 -1.828525428551057e-09,  3.225257760366842e-11, -5.223073768453148e-13,  7.870705527659400e-15, -1.114685054496085e-16,  1.495086473953761e-18, -1.910383405502210e-20,
  7.370860535937390e-02, -5.333737605930404e-03,  2.252415947556088e-04, -7.111985764646165e-06,  1.848971071461347e-07, -4.162656225942989e-09,  8.368193891500084e-11,
 -1.533182749045119e-12,  2.597532519813068e-14, -4.113552335560506e-16,  6.139963213687138e-18, -8.693227853269044e-20,  7.011656838532819e-02, -6.196467610632192e-03,
  3.103981966939440e-04, -1.142157699767882e-05,  3.416541092620103e-07, -8.763037192611317e-09,  1.990947902512555e-10, -4.094944709761399e-12,  7.743516786296133e-14,
 -1.361856678151447e-15,  2.247399154156364e-17, -3.503835078842273e-19,  6.640509783413477e-02, -7.014383496340872e-03,  4.108618060304766e-04, -1.741886217779647e-05,
  5.937436512802194e-07, -1.720212614062969e-08,  4.382971981107870e-10, -1.004809025545457e-11,  2.106707394047530e-13, -4.088923808934949e-15,  7.416021747307775e-17,
 -1.265934016079585e-18,  6.262903003806337e-02, -7.763503746672063e-03,  5.248506676418110e-04, -2.536933323609195e-05,  9.765652765860942e-07, -3.170603363420485e-08,
  8.994500685738839e-10, -2.283144018468661e-11,  5.274663224314837e-13, -1.123260160623967e-14,  2.226675236326520e-16, -4.139854713139856e-18,  5.883713314258728e-02,
 -8.424154228014211e-03,  6.495741198043858e-04, -3.545044605905574e-05,  1.528196325884602e-06, -5.518669100955363e-08,  1.731308568276996e-09, -4.835702779047560e-11,
  1.223865017995864e-12, -2.843954078705111e-14,  6.130026987248142e-16, -1.235187389792869e-17,  5.507127335622659e-02, -8.981258039865332e-03,  7.813955518493118e-04,
 -4.771527023729179e-05,  2.285391599423334e-06, -9.115358925345018e-08,  3.142215056402507e-09, -9.600222325207152e-11,  2.647109975431637e-12, -6.677462930445234e-14,
  1.557333701274470e-15, -3.385028019952131e-17,  5.136604082912165e-02, -9.424328351128370e-03,  9.160544574384743e-04, -6.206507297654809e-05,  3.278547813061704e-06,
 -1.434699072725132e-07,  5.401342516215195e-09, -1.794989256271485e-10,  5.363955866961771e-12, -1.461589860373297e-13,  3.671052009301954e-15, -8.569232603598927e-17,
  4.774877484191581e-02, -9.747216225424106e-03,  1.048921481625286e-03, -7.823455773925449e-05,  4.526197801431304e-06, -2.159408515366155e-07,  8.827443064867677e-09,
 -3.173742752833091e-10,  1.022679621442426e-11, -2.995842020933458e-13,  8.067237827838910e-15, -2.013654409878729e-16,  4.423991002985683e-02, -9.947675377653212e-03,
  1.175260908167854e-03, -9.579177711622718e-05,  6.029759035761536e-06, -3.117541491892691e-07,  1.376140518382272e-08, -5.325168104333323e-10,  1.841372483407515e-11,
 -5.772633160420694e-13,  1.659345251994526e-14, -4.410712206698923e-16,  4.085355812163723e-02, -1.002680784882285e-02,  1.290478388770109e-03, -1.141528824690339e-04,
  7.769303899136299e-06, -4.328276822145643e-07,  2.052140698177940e-08, -8.504596315342416e-10,  3.141035671035658e-11, -1.049152765701815e-12,  3.205788031985080e-14,
 -9.038117678086663e-16,  3.759824145704091e-02, -9.988450275954150e-03,  1.390336891640753e-03, -1.326101644889564e-04,  9.701036420076391e-06, -5.791495338850405e-07,
  2.934310462547469e-08, -1.296127636459191e-09,  5.089965082398842e-11, -1.803656081885311e-12,  5.834620730653930e-14, -1.737941780096810e-15,  3.447770302379981e-02,
 -9.838551722646046e-03,  1.471129819480340e-03, -1.503705091536806e-04,  1.175696818796584e-05, -7.482140031155769e-07,  4.031143975678918e-08, -1.889095047081118e-09,
  7.853544948836669e-11, -2.940153033874432e-12,  1.002924559708974e-13, -3.144281248136769e-15,  3.149173040580688e-02, -9.584582918123218e-03,  1.529806121775870e-03,
 -1.666005715345820e-04,  1.384702064947860e-05, -9.346584578400304e-07,  5.329433783733417e-08, -2.637801397729142e-09,  1.155979533545820e-10, -4.553644931086054e-12,
  1.631606721169018e-13, -5.363994210432580e-15,  2.863694554267001e-02, -9.235004983722180e-03,  1.564047338358070e-03, -1.804746815867237e-04,  1.586348750988215e-05,
 -1.130188725479567e-06,  6.789081147860089e-08, -3.533592812597332e-09,  1.625627256308570e-10, -6.711459804184112e-12,  2.516444988465341e-13, -8.643766373394059e-15,
  2.590752668267898e-02, -8.798814656583229e-03,  1.572300462746186e-03, -1.912216826712999e-04,  1.768751502140068e-05, -1.323847265169617e-06,  8.340601371898281e-08,
 -4.545777183690187e-09,  2.186521262266503e-10, -9.424479371548642e-12,  3.684103231406994e-13, -1.317478410035859e-14,  2.329584203060284e-02, -8.285173539305172e-03,
  1.553773157743983e-03, -1.981674505137386e-04,  1.919703665874384e-05, -1.502633959503893e-06,  9.886328077477135e-08, -5.618995781566720e-09,  2.814686958924685e-10,
 -1.261817903870453e-11,  5.123835635075043e-13, -1.901006204462740e-14,  2.079298555513865e-02, -7.703121463729598e-03,  1.508399244974382e-03, -2.007706086235714e-04,
  2.027545578708515e-05, -1.652441205744892e-06,  1.130583830906472e-07, -6.674045139889267e-09,  3.468224192351091e-10, -1.611102096311313e-11,  6.771624267365605e-13,
 -2.597541911043780e-14,  1.838921390482069e-02, -7.061368752052541e-03,  1.436782711674853e-03, -1.986498098931383e-04,  2.082031426966271e-05, -1.759220654880289e-06,
  1.246548051364859e-07, -7.612819883332961e-09,  4.088493054425929e-10, -1.960842405357771e-11,  8.500708832071259e-13, -3.359948059283181e-14,  1.607428942150579e-02,
 -6.368158830354750e-03,  1.340127988321914e-03, -1.916017795161478e-04,  2.075121206108825e-05, -1.810265006094556e-06,  1.323120005110910e-07, -8.327351417023826e-09,
  4.604749510439288e-10, -2.271893007464039e-11,  1.012361887745273e-12, -4.109286446675133e-14,  1.383773811822490e-02, -5.631190990848059e-03,  1.220163221131655e-03,
 -1.796100307176774e-04,  2.001633841377675e-05, -1.795469266648104e-06,  1.348324565256527e-07, -8.712115907844204e-09,  4.942095307034948e-10, -2.499516786050212e-11,
  1.140909131468664e-12, -4.740205941159310e-14,  1.166903364781037e-02, -4.857592752185893e-03,  1.079061945577104e-03, -1.628447268566753e-04,  1.859711968916298e-05,
 -1.708433892555924e-06,  1.313091749929771e-07, -8.678042936215174e-09,  5.031835972128864e-10, -2.599644739748826e-11,  1.211390171488537e-12, -5.134789598100042e-14,
  9.557719376285620e-03, -4.053931943889033e-03,  9.193671827502273e-04, -1.416545601623976e-04,  1.651066114093960e-05, -1.547286841626133e-06,  1.212536333837481e-07,
 -8.166139702595294e-09,  4.822655674744919e-10, -2.536366369120688e-11,  1.202538437880725e-12, -5.183456111504082e-14,  7.493482175081891e-03, -3.226260471054760e-03,
  7.439207869854626e-04, -1.165517765084321e-04,  1.380984321793174e-05, -1.315130496906523e-06,  1.046857852521074e-07, -7.158483868534306e-09,  4.290603842399329e-10,
 -2.289240363906424e-11,  1.100648928488973e-12, -4.808957319094739e-14,  5.466200968517154e-03, -2.380187572091784e-03,  5.558007116144786e-04, -8.819174377530084e-05,
  1.058112600484080e-05, -1.020060124552413e-06,  8.217213988101327e-08, -5.684598750438684e-09,  3.445885134085950e-10, -1.858835151313802e-11,  9.032991161734358e-13,
 -3.987709562065095e-14,  3.466084614214690e-03, -1.521022662786991e-03,  3.582775096355098e-04, -5.735001846059607e-05,  6.940459072514128e-06, -6.747631263833524e-07,
  5.480601727506552e-08, -3.821968769732658e-09,  2.334947126234184e-10, -1.269148346530926e-11,  6.213072418027786e-13, -2.762503287466191e-14,  1.485942214839315e-03,
 -6.548806131049341e-04,  1.550023488912293e-04, -2.493230103707668e-05,  3.031780097607743e-06, -2.961399172154910e-07,  2.416349743816910e-08, -1.692593135331674e-09,
  1.038542019920300e-10, -5.668774959345381e-12,  2.786520200680855e-13, -1.243892197645239e-14,  8.960405045819698e-02, -3.411482586354093e-04,  1.372574298552563e-06,
 -5.747565264408135e-09,  2.467857576034674e-11, -1.074086021273386e-13,  4.701247787206471e-16, -2.059404866626944e-18,  9.003193058806008e-21, -3.922275388728792e-23,
  1.701568862651554e-25, -7.348828484044641e-28,  8.837026270871869e-02, -5.029595820369057e-04,  3.334987058001799e-06, -2.198777590383631e-08,  1.399408161215625e-10,
 -8.609798483749753e-13,  5.148620333576064e-15, -3.006498037619553e-17,  1.720353984909630e-19, -9.671590367714177e-22,  5.352759048411314e-24, -2.921075725966746e-26,
  8.596188349484520e-02, -8.121587971666470e-04,  7.970949674628284e-06, -7.114446554755109e-08,  5.899269380650445e-10, -4.628627868977969e-12,  3.475695750668083e-14,
 -2.516798048250503e-16,  1.766942267866555e-18, -1.207627323988108e-20,  8.060417657368410e-23, -5.267183751489327e-25,  8.249203104106842e-02, -1.241675925612774e-03,
  1.651818007445099e-05, -1.899588446550505e-07,  1.980215658454023e-09, -1.918736048189641e-11,  1.754489012491798e-13, -1.529503568672743e-15,  1.280534339660701e-17,
 -1.035260208378872e-19,  8.116392168420035e-22, -6.191085955128250e-24,  7.811791098045223e-02, -1.755052279139717e-03,  3.041701758704132e-05, -4.395870433191048e-07,
  5.630607707624364e-09, -6.593598300449630e-11,  7.193967330247948e-13, -7.406334962146868e-15,  7.260234191915427e-17, -6.822305299962120e-19,  6.177247742572400e-21,
 -5.411188094876055e-23,  7.302771728643163e-02, -2.310650883176073e-03,  5.092489269679085e-05, -9.071262673715287e-07,  1.402679959873609e-08, -1.953252544167092e-10,
  2.504836128280098e-12, -3.002597886335897e-14,  3.400221168094750e-16, -3.666250186723736e-18,  3.786747837233509e-20, -3.764224645755897e-22,  6.742591220307034e-02,
 -2.866168801865918e-03,  7.875877625253952e-05, -1.700854454576229e-06,  3.129294164319156e-08, -5.114484087076503e-10,  7.616538114427423e-12, -1.051112569472539e-13,
  1.360427679555854e-15, -1.666073314636329e-17,  1.943882088334650e-19, -2.172184109183552e-21,  6.151859619416519e-02, -3.382806710927996e-03,  1.138439318530646e-04,
 -2.937625028975816e-06,  6.351144717378104e-08, -1.204830952926277e-09,  2.062443401876589e-11, -3.245743125070795e-13,  4.758391737067978e-15, -6.562642554481654e-17,
  8.579128209674080e-19, -1.069252530926652e-20,  5.550048026836413e-02, -3.828572598342921e-03,  1.552178426254869e-04, -4.723601801828851e-06,  1.186833753273895e-07,
 -2.587669452355783e-09,  5.046254326522693e-11, -8.981066906609830e-13,  1.479790048522523e-14, -2.281407090055166e-16,  3.318086704401522e-18, -4.581323023255619e-20,
  4.954457423273640e-02, -4.180395828570760e-03,  2.010998947988324e-04, -7.132048518635959e-06,  2.061640557260693e-07, -5.120429017383767e-09,  1.128386109456528e-10,
 -2.254219396262249e-12,  4.145292023946373e-14, -7.096922613659395e-16,  1.141148893551892e-17, -1.734977382582928e-19,  4.379520198595978e-02, -4.424954877692853e-03,
  2.491010034398173e-04, -1.018327718186405e-05,  3.355299248410270e-07, -9.415321636912382e-09,  2.327283473026666e-10, -5.183117643754217e-12,  1.056957568227326e-13,
 -1.997397950856449e-15,  3.530495659188271e-17, -5.878363908360547e-19,  3.836445011707434e-02, -4.558328367355781e-03,  2.965215989886583e-04, -1.383165655655441e-05,
  5.150010333977143e-07, -1.620327050256397e-08,  4.461421395570217e-10, -1.100651192676474e-11,  2.474241814734413e-13, -5.132291390677550e-15,  9.919208322944396e-17,
 -1.799564275520752e-18,  3.333173217250731e-02, -4.584729108172495e-03,  3.406758063558896e-04, -1.796292905996101e-05,  7.497009051824099e-07, -2.625765500910287e-08,
  8.001218101331824e-10, -2.173518876349981e-11,  5.356178213524562e-13, -1.213120414097987e-14,  2.550951368333533e-16, -5.018803528499879e-18,  2.874585940668066e-02,
 -4.514658046905742e-03,  3.791840681575605e-04, -2.240259494552209e-05,  1.040122804715145e-06, -4.027925259725247e-08,  1.350000676738727e-09, -4.015161116201408e-11,
  1.078925619024073e-12, -2.654942287938168e-14,  6.045551143657701e-16, -1.284066931162530e-17,  2.462886551490821e-02, -4.362821271071321e-03,  4.101919788618257e-04,
 -2.693360579001177e-05,  1.381155406314399e-06, -5.875902224893179e-08,  2.153427005954671e-09, -6.974361251941417e-11,  2.033247144820319e-12, -5.410017448987021e-14,
  1.328011972679916e-15, -3.032072779361141e-17,  2.098082344048353e-02, -4.146104357164789e-03,  4.324939225152076e-04, -3.131976689439830e-05,  1.761905487261189e-06,
 -8.184449262520063e-08,  3.261442799379476e-09, -1.144271928811625e-10,  3.601625133881035e-12, -1.031480233696840e-13,  2.717691515672117e-15, -6.642404851041663e-17,
  1.778498303678124e-02, -3.881816979165632e-03,  4.455605439652861e-04, -3.533046980636940e-05,  2.166378412052864e-06, -1.092381576214859e-07,  4.707809352934333e-09,
 -1.780356176326922e-10,  6.021703886367546e-12, -1.848037663057736e-13,  5.204274655406819e-15, -1.356224490605276e-16,  1.501270783196615e-02, -3.586329530798844e-03,
  4.494849518872468e-04, -3.876268052006323e-05,  2.574893412553720e-06, -1.401512959854896e-07,  6.498484113330133e-09, -2.636119592219901e-10,  9.537704991836133e-12,
 -3.123170183277455e-13,  9.362252086055123e-15, -2.591216340457572e-16,  1.262785860791645e-02, -3.274140534836283e-03,  4.448718177202098e-04, -4.145721931808775e-05,
  2.965970521581139e-06, -1.733254747193609e-07,  8.603425094591566e-09, -3.726065109034327e-10,  1.435733062717340e-11, -4.995343733425775e-13,  1.587645606763571e-14,
 -4.649155000719146e-16,  1.059043108429008e-02, -2.957349804451700e-03,  4.326961852420081e-04, -4.330786167821567e-05,  3.318360121029491e-06, -2.071200373896346e-07,
  1.095261574963913e-08, -5.041283326604897e-10,  2.059849148296943e-11, -7.583824742393189e-13,  2.545569092228681e-14, -7.857433829909106e-16,  8.859386157454152e-03,
 -2.645471724459010e-03,  4.141562396021777e-04, -4.426325062461397e-05,  3.612899260742485e-06, -2.396510594299804e-07,  1.343743391501752e-08, -6.544143172211378e-10,
  2.823496491587565e-11, -1.095617214657855e-12,  3.869012966923265e-14, -1.254231471917691e-15,  7.394706038455153e-03, -2.345504268980972e-03,  3.905385432338264e-04,
 -4.432273948094664e-05,  3.833954107060473e-06, -2.689587261908664e-07,  1.591745274876415e-08, -8.166526513303532e-10,  3.705259068550515e-11, -1.509377950860784e-12,
  5.586597667076213e-14, -1.895119681824308e-15,  6.158768623000580e-03, -2.062167851244448e-03,  3.631073454247525e-04, -4.352793925769900e-05,  3.970315942799262e-06,
 -2.931773644029762e-07,  1.823174322404102e-08, -9.812363121607799e-10,  4.662739884723644e-11, -1.986301094804496e-12,  7.676956555666343e-14, -2.715441085742724e-15,
  5.117160965024686e-03, -1.798237986654296e-03,  3.330230767233687e-04, -4.195193133531380e-05,  4.015528799401152e-06, -3.106851530929278e-07,  2.021299656336212e-08,
 -1.136442555916296e-09,  5.633394223934074e-11, -2.499995058745692e-12,  1.005273644735153e-13, -3.694581191079895e-15,  4.239058526580086e-03, -1.554911522273719e-03,
  3.012899941625696e-04, -3.968792618787564e-05,  3.967716889318975e-06, -3.202172386295661e-07,  2.170244554762806e-08, -1.269456798980963e-09,  6.538676758286091e-11,
 -3.011518220263631e-12,  1.255323023755920e-13, -4.776923223834623e-15,  3.497287801325567e-03, -1.332163490209222e-03,  2.687295103643598e-04, -3.683874715751339e-05,
  3.829037237682709e-06, -3.209343739863076e-07,  2.256365112175726e-08, -1.367601903215814e-09,  7.291173017400438e-11, -3.472156000455567e-12,  1.494970022697397e-13,
 -5.869914639321413e-15,  2.868172696891208e-03, -1.129067581376763e-03,  2.359739468531521e-04, -3.350803489294473e-05,  3.604905556365497e-06, -3.124472191386345e-07,
  2.269364220072590e-08, -1.419607196964345e-09,  7.803824071208665e-11, -3.828341154327240e-12,  1.696516391682206e-13, -6.849661448828384e-15,  2.331244788511695e-03,
 -9.440662664151651e-04,  2.034749758873013e-04, -2.979361049797292e-05,  3.303137330961925e-06, -2.948026132638205e-07,  2.203049941865881e-08, -1.416756922727397e-09,
  7.999974947481360e-11, -4.028112171106850e-12,  1.830731497075967e-13, -7.574631206255923e-15,  1.868877601888948e-03, -7.751862187256145e-04,  1.715214415066869e-04,
 -2.578306847946433e-05,  2.933120942778757e-06, -2.684417789882165e-07,  2.055709871447805e-08, -1.353788759159307e-09,  7.822845946782023e-11, -4.028163941084120e-12,
  1.871010621102243e-13, -7.906063257916921e-15,  1.465887400906338e-03, -6.202011244050787e-04,  1.402621877689894e-04, -2.155141986974909e-05,  2.505105493349195e-06,
 -2.341415668449206e-07,  1.830125352101903e-08, -1.229458799630655e-09,  7.243140037729057e-11, -3.800385813757517e-12,  1.797713471049961e-13, -7.731773680356076e-15,
  1.109128537181271e-03, -4.767478175895686e-04,  1.097306720745743e-04, -1.716046990325826e-05,  2.029651309916941e-06, -1.929490126244605e-07,  1.533284643006958e-08,
 -1.046738578589908e-09,  6.263806214862622e-11, -3.336830966602743e-12,  1.601895635094660e-13, -6.988754794097569e-15,  7.871013859255195e-04, -3.424040800216288e-04,
  7.986939406803157e-05, -1.265958902023456e-05,  1.517263279388207e-06, -1.461175623024733e-07,  1.175872266074205e-08, -8.126544279172919e-10,  4.921404238720974e-11,
 -2.652300286745426e-12,  1.287710177373008e-13, -5.679717622437994e-15,  4.895952562545651e-04, -2.147425907034772e-04,  5.055447993515055e-05, -8.087766330772508e-06,
  9.782298409963768e-07, -9.505308479313143e-08,  7.716323210397227e-09, -5.378261831935643e-10,  3.284050883344154e-11, -1.784138467993052e-12,  8.729937783449306e-14,
 -3.879732695586251e-15,  2.076514354519569e-04, -9.149381538153436e-05,  2.164963290274273e-05, -3.481409169240475e-06,  4.232250015803409e-07, -4.132880353575311e-08,
  3.371317461067072e-09, -2.360903639137041e-10,  1.448229883699121e-11, -7.903006132602113e-13,  3.883800220169246e-14, -1.733289955785965e-15,  8.826099106369961e-02,
 -3.304369941802652e-04,  1.305903702587495e-06, -5.369299421954005e-09,  2.263872581573636e-11, -9.678627118633723e-14,  4.162916112129799e-16, -1.792642058986297e-18,
  7.706282791573574e-21, -3.302093615513782e-23,  1.409240745412378e-25, -5.988328163517810e-28,  8.641016516766613e-02, -4.772983013614727e-04,  3.084020810596845e-06,
 -1.988004124537696e-08,  1.238917843228156e-10, -7.469234678302947e-13,  4.378919159300136e-15, -2.507799498388698e-17,  1.407810597540533e-19, -7.766776684113777e-22,
  4.219349188074863e-24, -2.260648274106266e-26,  8.283559413472280e-02, -7.516524264879258e-04,  7.170934712326373e-06, -6.240317790113305e-08,  5.051566342229825e-10,
 -3.873016569761245e-12,  2.844034357612372e-14, -2.015139523160340e-16,  1.385052942166523e-18, -9.271607042651095e-21,  6.063504737934435e-23, -3.883615472036265e-25,
  7.777590508705974e-02, -1.118137638340138e-03,  1.441681420801601e-05, -1.611303562419000e-07,  1.635332739314455e-09, -1.544742810963035e-11,  1.378410798249956e-13,
 -1.173594004239342e-15,  9.602632941227991e-18, -7.591532925618954e-20,  5.822916589927619e-22, -4.347449275677879e-24,  7.155300281993429e-02, -1.531379251022171e-03,
  2.564185050454783e-05, -3.591750437883898e-07,  4.469012045101707e-09, -5.091755717044132e-11,  5.411677875513481e-13, -5.432631749173915e-15,  5.197020100254694e-17,
 -4.769065942839055e-19,  4.219472032772292e-21, -3.613683464633228e-23,  6.453599040196463e-02, -1.943255520795701e-03,  4.126688501130294e-05, -7.109484002388623e-07,
  1.065922871615557e-08, -1.441806479429661e-10,  1.798507455223279e-12, -2.099427295979993e-14,  2.317327138073234e-16, -2.437394755953636e-18,  2.457516349593866e-20,
 -2.386171024966115e-22,  5.710317965105246e-02, -2.309945431476764e-03,  6.104472591069232e-05, -1.272985928287887e-06,  2.267680367519225e-08, -3.595544094854967e-10,
  5.202432581210762e-12, -6.984238801146862e-14,  8.802677050630502e-16, -1.050722026586958e-17,  1.195789339537917e-19, -1.304287525240233e-21,  4.960778946190991e-02,
 -2.597456930606887e-03,  8.397370534884261e-05, -2.090126750526077e-06,  4.370901335964254e-08, -8.036623125218604e-10,  1.335531804164738e-11, -2.043060497532744e-13,
  2.914761793317546e-15, -3.915724672310443e-17,  4.990349925321696e-19, -6.068050207694997e-21,  4.235156141391955e-02, -2.784825454982244e-03,  1.084122775808093e-04,
 -3.180567948266939e-06,  7.725147656395605e-08, -1.631585098141832e-09,  3.087238689755351e-11, -5.338525809453381e-13,  8.556357556765828e-15, -1.284467763674952e-16,
  1.820640178203050e-18, -2.451826958198712e-20,  3.556854541844578e-02, -2.864782013265601e-03,  1.323514616605410e-04, -4.524588225141992e-06,  1.264090514347940e-07,
 -3.040617965948446e-09,  6.500151092185172e-11, -1.261461099365632e-12,  2.256108662830534e-14, -3.760552205760517e-16,  5.892485041332374e-18, -8.737462032288422e-20,
  2.941925971928525e-02, -2.842239366220383e-03,  1.537615307305034e-04, -6.061003488206135e-06,  1.930481185179981e-07, -5.246992010491015e-09,  1.258273985435261e-10,
 -2.722498645714851e-12,  5.400114075998783e-14, -9.936505697840876e-16,  1.711722449205562e-17, -2.780045045927489e-19,  2.399376209470298e-02, -2.731305751223575e-03,
  1.709203312660043e-04, -7.693024571374490e-06,  2.770349957809059e-07, -8.446108078470429e-09,  2.257057328173547e-10, -5.411564082267134e-12,  1.183672478692269e-13,
 -2.391498913203930e-15,  4.506204354103091e-17, -7.977159940875020e-19,  1.932114679628262e-02, -2.551659431317580e-03,  1.826500849470987e-04, -9.302207083540862e-06,
  3.758046171575080e-07, -1.276349163002265e-08,  3.777166442210863e-10, -9.977881635727321e-12,  2.393836878031920e-13, -5.283880172310295e-15,  1.083829924194562e-16,
 -2.081799781469720e-18,  1.538265443889229e-02, -2.325031383934478e-03,  1.884256143775451e-04, -1.076682727349942e-05,  4.844193048364502e-07, -1.820890466390829e-08,
  5.932271619705226e-10, -1.717182838074106e-11,  4.495854229328586e-13, -1.078981415522344e-14,  2.398408042515378e-16, -4.976982913399508e-18,  1.212582777955753e-02,
 -2.072323580558303e-03,  1.883551052844469e-04, -1.198007865550868e-05,  5.961324402151773e-07, -2.464723052963337e-08,  8.790088991116047e-10, -2.773622182279482e-11,
  7.886228139845618e-13, -2.048455213770084e-14,  4.913080034051716e-16, -1.096901093363651e-17,  9.477750556408983e-03, -1.811625706382735e-03,  1.830632712498854e-04,
 -1.286407578687478e-05,  7.033243878032946e-07, -3.179598928618092e-08,  1.234618244259262e-09, -4.225391715908546e-11,  1.298612616246441e-12, -3.634755323658827e-14,
  9.367085905866871e-16, -2.241078172230598e-17,  7.356143110429060e-03, -1.557157208814731e-03,  1.735206735909161e-04, -1.337730334590422e-05,  7.985824723956869e-07,
 -3.925197096084502e-08,  1.650783991024173e-09, -6.098168375702883e-11,  2.016651035582564e-12, -6.056269897681967e-14,  1.670217511932391e-15, -4.265621087430981e-17,
  5.677777528465554e-03, -1.318996796828626e-03,  1.608625409829435e-04, -1.351512299168905e-05,  8.756803055404471e-07, -4.654133193245190e-08,  2.109326127319774e-09,
 -8.371134391105146e-11,  2.965620253539558e-12, -9.516037671765632e-14,  2.797313663139202e-15, -7.597382068067267e-17,  4.364208981490011e-03, -1.103378806275578e-03,
  1.462302280120716e-04, -1.330458430039518e-05,  9.302676782130158e-07, -5.318153731252556e-08,  2.584725523769573e-09, -1.096972741346078e-10,  4.145266624839940e-12,
 -1.415417759664576e-13,  4.417730482406504e-15, -1.271226383893933e-16,  3.345161655829796e-03, -9.133229535035854e-04,  1.306541719118483e-04, -1.279570471053764e-05,
  9.601796854891760e-07, -5.874153295648537e-08,  3.047026692180390e-09, -1.376743673900928e-10,  5.525832930238370e-12, -1.999760650156748e-13,  6.601782842196830e-15,
 -2.005380556305630e-16,  2.560071794929164e-03, -7.493973927432732e-04,  1.149836686697462e-04, -1.205154061823341e-05,  9.653748498614302e-07, -6.288856895145105e-08,
  3.465436112918884e-09, -1.659676218639674e-10,  7.046113747219520e-12, -2.691905669241093e-13,  9.364224007599243e-15, -2.991908975685016e-16,  1.958319478055141e-03,
 -6.104701156667499e-04,  9.985885687552257e-05, -1.113895853781132e-05,  9.475873146018823e-07, -6.541483998431862e-08,  3.811867672357743e-09, -1.926717449363619e-10,
  8.616785272243621e-12, -3.461685203432900e-13,  1.264167663966360e-14, -4.233163008810069e-16,  1.498624938542585e-03, -4.943613241838488e-04,  8.571484090439759e-05,
 -1.012131868089120e-05,  9.098143317025843e-07, -6.624262707592334e-08,  4.063788645896708e-09, -2.158639014997351e-10,  1.012858619655872e-11, -4.262276961825669e-13,
  1.627993675433800e-14, -5.693106773002214e-16,  1.147988618483259e-03, -3.983577688390848e-04,  7.280634934979804e-05, -9.053565578129980e-06,  8.557593815671056e-07,
 -6.541122311527182e-08,  4.205967177337047e-09, -2.338088161220824e-10,  1.146381717227794e-11, -5.033890604075741e-13,  2.003579965722527e-14, -7.291199279749706e-16,
  8.804488443617813e-04, -3.195843969576952e-04,  6.124246660421496e-05, -7.979652387670655e-06,  7.893251106848318e-07, -6.305164183834172e-08,  4.231016820747201e-09,
 -2.451222992311472e-10,  1.250900616179311e-11, -5.709787275310091e-13,  2.359494954209502e-14, -8.903704119133078e-16,  6.758362585873642e-04, -2.552490955885168e-04,
  5.102347109682591e-05, -6.931875432990929e-06,  7.142133615568654e-07, -5.935580646458591e-08,  4.138887025054978e-09, -2.488730483636875e-10,  1.316657229935236e-11,
 -6.223585597342106e-13,  2.660385748467639e-14, -1.037341450937473e-15,  5.186287262581280e-04, -2.027855601435839e-04,  4.207461581555946e-05, -5.931552430391728e-06,
  6.336539396469201e-07, -5.454604445563928e-08,  3.935607935193756e-09, -2.446181929714189e-10,  1.336381745686350e-11, -6.516625665390730e-13,  2.871062482151348e-14,
 -1.152688963939147e-15,  3.969559793897754e-04, -1.599209102793860e-04,  3.427414637758723e-05, -4.990488096343565e-06,  5.502566248396009e-07, -4.884898756194487e-08,
  3.631652182782118e-09, -2.323811616282956e-10,  1.305835348497222e-11, -6.544282991732491e-13,  2.960807124312533e-14, -1.219659526500351e-15,  3.017673786639476e-04,
 -1.246918643959488e-04,  2.747468212708509e-05, -4.112769750692453e-06,  4.659646994339869e-07, -4.247606252787277e-08,  3.240245093471314e-09, -2.125885786884459e-10,
  1.223987656890557e-11, -6.280461361707903e-13,  2.907235290086110e-14, -1.224427983583851e-15,  2.261548312322943e-04, -9.542854363112560e-05,  2.151825481385637e-05,
 -3.296567969295390e-06,  3.820819295346727e-07, -3.561112502642469e-08,  2.775872299975925e-09, -1.859855894746552e-10,  1.092882908459132e-11, -5.719918261924155e-13,
  2.699174381824380e-14, -1.158170786053020e-15,  1.648119097857260e-04, -7.071991567622613e-05,  1.624591738875244e-05, -2.535746215352024e-06,  2.993458273741902e-07,
 -2.840466450366886e-08,  2.253134700614025e-09, -1.535473104453795e-10,  9.172845339102287e-12, -4.878467806472733e-13,  2.338234436924852e-14, -1.018545904065638e-15,
  1.136060797160236e-04, -4.937044138589150e-05,  1.150307506265121e-05, -1.821191472393824e-06,  2.180253860108597e-07, -2.097344157536248e-08,  1.686012554998671e-09,
 -1.163998626452873e-10,  7.041967098478735e-12, -3.791388646615835e-13,  1.838977321285347e-14, -8.103645276531167e-16,  6.924230452035949e-05, -3.035464213323451e-05,
  7.141855056832277e-06, -1.141883439253180e-06,  1.380317221739493e-07, -1.340460101562599e-08,  1.087560146008438e-09, -7.576101003408314e-11,  4.623601568541286e-12,
 -2.510565141536286e-13,  1.227812605322464e-14, -5.453895766104475e-16,  2.903528098646502e-05, -1.279013864538189e-05,  3.025603637238636e-06, -4.863985949547140e-07,
  5.911324966784089e-08, -5.770907113207440e-09,  4.706200821225241e-10, -3.294811665776786e-11,  2.020567654587700e-12, -1.102335537115067e-13,  5.415842099837139e-15,
 -2.416408087410984e-16,  8.695973798311663e-02, -3.202414768694458e-04,  1.243583261225853e-06, -5.022039346338383e-09,  2.079898415807821e-11, -8.737079508044487e-14,
  3.693788070899949e-16, -1.564022609561457e-18,  6.612956225932602e-21, -2.787704758471813e-23,  1.170656001664182e-25, -4.895577096041824e-28,  8.454885153499526e-02,
 -4.535477776658127e-04,  2.856878823032004e-06, -1.801180024414150e-08,  1.099499040468931e-10, -6.497712672163262e-13,  3.735823276360039e-15, -2.098964308572152e-17,
  1.156334443605709e-19, -6.262174544100437e-22,  3.340257414425656e-24, -1.757568450443239e-26,  7.993916325359263e-02, -6.971485539342880e-04,  6.468150522302658e-06,
 -5.490510029523610e-08,  4.340895851593064e-10, -3.253441126564451e-12,  2.337143212448445e-14, -1.620960708967742e-16,  1.091108595812565e-18, -7.156099175731450e-21,
  4.586972634580969e-23, -2.880467952089966e-25,  7.352237607138006e-02, -1.010114936610881e-03,  1.263059972305074e-05, -1.372674548806574e-07,  1.356973620026426e-09,
 -1.250121998287483e-11,  1.089015803075297e-13, -9.058906912489111e-16,  7.246615633295117e-18, -5.604073458003451e-20,  4.206832308555435e-22, -3.075223664755298e-24,
  6.581207766025417e-02, -1.342342331433536e-03,  2.172932184434462e-05, -2.951605074087930e-07,  3.569127869076222e-09, -3.958174207685840e-11,  4.099711297634016e-13,
 -4.014582585152799e-15,  3.749194899139668e-17, -3.360968450418886e-19,  2.906648563282666e-21, -2.434530540913301e-23,  5.737302865902635e-02, -1.644551505794696e-03,
  3.367071588232179e-05, -5.613101561510154e-07,  8.163652264332344e-09, -1.073073694739666e-10,  1.302535236961703e-12, -1.481183282401025e-14,  1.594126779510045e-16,
 -1.636168852310202e-18,  1.610871956912692e-20, -1.528240906056071e-22,  4.875140570987079e-02, -1.877028388906030e-03,  4.772884905188003e-05, -9.615136084860369e-07,
  1.659097588432993e-08, -2.552991095290926e-10,  3.590324682228612e-12, -4.690448508319312e-14,  5.758615132540571e-16, -6.701568219212266e-18,  7.441462489693167e-20,
 -7.924765981462870e-22,  4.041799672118546e-02, -2.015221880932266e-03,  6.260935357121068e-05, -1.503723967220187e-06,  3.042708407028528e-08, -5.424184319066287e-10,
  8.753354778876358e-12, -1.302036851323153e-13,  1.808174826689096e-15, -2.366751708417300e-17,  2.941252750376684e-19, -3.490051785667356e-21,  3.273182893097670e-02,
 -2.051423700036546e-03,  7.670250598045636e-05, -2.169916149051078e-06,  5.096181501268570e-08, -1.042900360696722e-09,  1.915178784349753e-11, -3.218496705167384e-13,
  5.018924250976138e-15, -7.337794971962816e-17,  1.013832452700213e-18, -1.331903880681372e-20,  2.592624721941128e-02, -1.992892511398130e-03,  8.842983056684017e-05,
 -2.914467271797919e-06,  7.870997481586152e-08, -1.833903125840130e-09,  3.803814840154812e-11, -7.172160389936726e-13,  1.247751259160694e-14, -2.025149552823349e-16,
  3.092683276003257e-18, -4.473117385489140e-20,  2.011466733330504e-02, -1.857591366316854e-03,  9.656738948830666e-05, -3.670459673732832e-06,  1.130166156398029e-07,
 -2.975486146339870e-09,  6.923178605539506e-11, -1.455394621750457e-12,  2.808120091519180e-14, -5.031518585231015e-16,  8.448000860512205e-18, -1.338424883614304e-19,
  1.531018030408958e-02, -1.669008363922170e-03,  1.004541171644995e-04, -4.362248127840471e-06,  1.519236242000977e-07, -4.488066367357864e-09,  1.163994489950603e-10,
 -2.712240124887404e-12,  5.772283660063175e-14, -1.135926964867768e-15,  2.086700876377281e-17, -3.604438035593612e-19,  1.145219667240425e-02, -1.451361681863652e-03,
  1.000459786690394e-04, -4.920354317228705e-06,  1.923808870634499e-07, -6.335010204103820e-09,  1.820488270260236e-10, -4.676040154537336e-12,  1.092083605001520e-13,
 -2.348999489930455e-15,  4.699606002187500e-17, -8.812110416580663e-19,  8.434052312389966e-03, -1.226030850504947e-03,  9.583072738757852e-05, -5.294224063979397e-06,
  2.307596797382855e-07, -8.417469333283016e-09,  2.665070400237612e-10, -7.506616662702528e-12,  1.914548996154591e-13, -4.480537238810838e-15,  9.720628361932564e-17,
 -1.970414706770055e-18,  6.127250060676423e-03, -1.009524571648990e-03,  8.865399704944906e-05, -5.459592201758993e-06,  2.635182629710038e-07, -1.058475927064207e-08,
  3.672324480359246e-10, -1.128627179872143e-11,  3.128905161510484e-13, -7.932094320266718e-15,  1.858376989397636e-16, -4.056221218388527e-18,  4.400041870206074e-03,
 -8.128620809849407e-04,  7.951813851146042e-05, -5.419354715630595e-06,  2.878266101428083e-07, -1.265817506643053e-08,  4.787409456861967e-10, -1.597683440486480e-11,
  4.792888788163330e-13, -1.310642982146781e-14,  3.302695209331835e-16, -7.732467499554133e-18,  3.129810900016582e-03, -6.419924320568870e-04,  6.940476161743037e-05,
 -5.198928867494687e-06,  3.019894099957064e-07, -1.446160045929992e-08,  5.932354964748859e-10, -2.139776071681936e-11,  6.915765019349555e-13, -2.031554525325522e-14,
  5.484702732197939e-16, -1.372286958154105e-17,  2.209911705771631e-03, -4.988036311872050e-04,  5.915054067207662e-05, -4.838358269679767e-06,  3.055893658978359e-07,
 -1.585047308183240e-08,  7.017936052599177e-10, -2.723477097626103e-11,  9.442898347560514e-13, -2.967854997052866e-14,  8.551544348822865e-16, -2.278194117996080e-17,
  1.552233413630817e-03, -3.823298124362944e-04,  4.938376995380683e-05, -4.383676668850214e-06,  2.993653185863233e-07, -1.673202571834473e-08,  7.957930881041739e-10,
 -3.307894737304888e-11,  1.225241401076289e-12, -4.103787940938097e-14,  1.257261938570775e-15, -3.553536067274334e-17,  1.086883409760749e-03, -2.898835128320753e-04,
  4.051308085175119e-05, -3.879507629789137e-06,  2.849067742626697e-07, -1.707321502706186e-08,  8.682074865956613e-10, -3.848664436389307e-11,  1.516608567545016e-12,
 -5.392131787876189e-14,  1.749924627127193e-15, -5.228682942880540e-17,  7.602235558672527e-04, -2.179667100179998e-04,  3.275183368738050e-05, -3.363975394005948e-06,
  2.642721891484090e-07, -1.689669258940427e-08,  9.144814689094618e-10, -4.304481952355138e-11,  1.797225557180504e-12, -6.756562428473967e-14,  2.314155585892883e-15,
 -7.283854772972354e-17,  5.321912796953208e-04, -1.629158759201350e-04,  2.616079817128430e-05, -2.866131411560720e-06,  2.396267773099604e-07, -1.626811495653214e-08,
  9.328532197952608e-10, -4.642626726566160e-11,  2.045514016217604e-12, -8.099972384737372e-14,  2.917116646691583e-15, -9.637834204000080e-17,  3.735217838176485e-04,
 -1.213013597625406e-04,  2.069513170936147e-05, -2.405496782507574e-06,  2.129622347743575e-07, -1.527934196662649e-08,  9.241553253153258e-10, -4.842394629131864e-11,
  2.242352154114790e-12, -9.316849526486470e-14,  3.515116523311926e-15, -1.214738320366279e-16,  2.632206000679832e-04, -9.013276965420598e-05,  1.624664618843434e-05,
 -1.993042298017299e-06,  1.859228628633388e-07, -1.403174940310519e-08,  8.912426830132832e-10, -4.896062834468904e-11,  2.373278209773631e-12, -1.030683520397774e-13,
  4.058738096393791e-15, -1.461866467324220e-16,  1.864415903540184e-04, -6.692913499564961e-05,  1.267702328176846e-05, -1.632913539779673e-06,  1.597323205184501e-07,
 -1.262258581137032e-08,  8.382424398137353e-10, -4.807667369256187e-11,  2.429679432114631e-12, -1.098657181569161e-13,  4.498964636643218e-15, -1.682877650119623e-16,
  1.328019088066014e-04, -4.970586388639510e-05,  9.841070160286185e-06, -1.324349400857180e-06,  1.351976892997163e-07, -1.113573332765204e-08,  7.698045715651331e-10,
 -4.590296429025540e-11,  2.408918701311138e-12, -1.129776558803750e-13,  4.793029513140309e-15, -1.855300847865809e-16,  9.509777962456247e-05, -3.691808653152744e-05,
  7.601130722926695e-06, -1.063436497297268e-06,  1.127619874386939e-07, -9.636908075648375e-09,  6.904776296719787e-10, -4.262734284061789e-11,  2.313595748967598e-12,
 -1.121061753357035e-13,  4.908943987727603e-15, -1.959240128165498e-16,  6.835578183446847e-05, -2.738711546765139e-05,  5.834633325445594e-06, -8.445208239122760e-07,
  9.257900943718538e-08, -8.172499336570810e-09,  6.042699881330524e-10, -3.846185807388520e-11,  2.150273804685326e-12, -1.072295706315934e-13,  4.828123899857347e-15,
 -1.979674601213217e-16,  4.914845258611093e-05, -2.022604045259076e-05,  4.436856761165902e-06, -6.612296291490031e-07,  7.459115477551613e-08, -6.770905036924647e-09,
  5.144026846216193e-10, -3.361577385174221e-11,  1.928022021856740e-12, -9.856227425322853e-14,  4.546051019268883e-15, -1.907986243674853e-16,  3.510922272674149e-05,
 -1.477269223771643e-05,  3.320693657412990e-06, -5.071357145202704e-07,  5.859843378231335e-08, -5.445247191146957e-09,  4.232249946635552e-10, -2.827671409697127e-11,
  1.657060951498939e-12, -8.649805405962552e-14,  4.071312943946179e-15, -1.742610358690176e-16,  2.459273931034470e-05, -1.053314656840034e-05,  2.414744895217478e-06,
 -3.761326911224265e-07,  4.431318407755888e-08, -4.196582042313009e-09,  3.322486364295407e-10, -2.260020331169203e-11,  1.347696620619362e-12, -7.155051835451532e-14,
  3.423586892499761e-15, -1.488887378094005e-16,  1.643839310349869e-05, -7.135994737332988e-06,  1.660644812985653e-06, -2.625976223788308e-07,  3.139952362049301e-08,
 -3.017022075280144e-09,  2.422565724446050e-10, -1.670654762208821e-11,  1.009627466724011e-12, -5.430146957525018e-14,  2.631168282733404e-15, -1.158311492691927e-16,
  9.805534075602763e-06, -4.296202453353534e-06,  1.010185189113205e-06, -1.614133433774423e-07,  1.949968513058486e-08, -1.892513019111320e-09,  1.534548116649970e-10,
 -1.068369298500109e-11,  6.516443843935835e-13, -3.536408905958318e-14,  1.728581195599035e-15, -7.674281912181292e-17,  4.062427032844921e-06, -1.789051247666878e-06,
  4.230898325159982e-07, -6.799604039724479e-08,  8.261283187612545e-09, -8.062684919568179e-10,  6.573261859794943e-11, -4.600637841301098e-12,  2.820590106856246e-13,
 -1.538373117766918e-14,  7.556093170228369e-16, -3.370446842274039e-17,  8.569829554840089e-02, -3.105283410910185e-04,  1.185259347407289e-06, -4.702767727906780e-09,
  1.913679172920938e-11, -7.900819886079890e-14,  3.284041152890587e-16, -1.367601915332097e-18,  5.688729553609371e-21, -2.359793543522471e-23,  9.753095925263195e-26,
 -4.014864194472371e-28,  8.277904254599792e-02, -4.315283640842076e-04,  2.650878813534018e-06, -1.635188622535110e-08,  9.780554758281060e-11, -5.667658427639696e-13,
  3.196703415556914e-15, -1.762572617318294e-17,  9.531936477288798e-20, -5.068657971818846e-22,  2.655337155906377e-24, -1.372510877228912e-26,  7.725004706950428e-02,
 -6.479254768138528e-04,  5.848909316743155e-06, -4.845121626576869e-08,  3.742816971685099e-10, -2.743271554053132e-12,  1.928521810603079e-14, -1.309717620981027e-16,
  8.636752281702554e-19, -5.551579084246915e-21,  3.488838912590462e-23, -2.148679763944338e-25,  6.967407073153778e-02, -9.153080000571867e-04,  1.110584644804639e-05,
 -1.174222399234644e-07,  1.131158956533966e-09, -1.016751181972260e-11,  8.650154018384404e-14, -7.032779949240842e-16,  5.502057606911135e-18, -4.163594312835777e-20,
  3.059846604129438e-22, -2.190701427077330e-24,  6.076924066384855e-02, -1.181761529540062e-03,  1.850554094605225e-05, -2.438888533250074e-07,  2.867436996016913e-09,
 -3.096619044461424e-11,  3.126888751497723e-13, -2.987931681693169e-15,  2.725057267000765e-17, -2.387239838230228e-19,  2.018679994010846e-21, -1.654074419094450e-23,
  5.129382741111080e-02, -1.400060885179720e-03,  2.765302191308986e-05, -4.462936867853970e-07,  6.299283447448137e-09, -8.049714785171393e-11,  9.511817375516307e-13,
 -1.054075695512294e-14,  1.106529193032300e-16, -1.108604492195690e-18,  1.066121660551090e-20, -9.885344123158597e-23,  4.193977380321098e-02, -1.537197215749327e-03,
  3.762895181176793e-05, -7.326358017355641e-07,  1.225017768640944e-08, -1.830128611716299e-10,  2.502448221369686e-12, -3.182443972245740e-14,  3.807246569085580e-16,
 -4.321014513343486e-18,  4.682812553836582e-20, -4.870373290055343e-22,  3.325525926942209e-02, -1.579005662450462e-03,  4.716151985740761e-05, -1.093394443453729e-06,
  2.141494235835435e-08, -3.702609530915612e-10,  5.804226056115263e-12, -8.397376591259045e-14,  1.135474661171771e-15, -1.448463116518100e-17,  1.755723251927300e-19,
 -2.033476301476758e-21,  2.560612726416047e-02, -1.529534954843124e-03,  5.494078032508093e-05, -1.499183453459126e-06,  3.405465245149046e-08, -6.754375107178849e-10,
  1.204114962581598e-11, -1.967019265336067e-13,  2.985070420638156e-15, -4.251310877989911e-17,  5.726779472807825e-19, -7.340744744785100e-21,  1.917497264997494e-02,
 -1.406435334027207e-03,  5.994580312934955e-05, -1.905025176176220e-06,  4.974184292236210e-08, -1.122822857987222e-09,  2.260025395902248e-11, -4.140935698344482e-13,
  7.008721013716451e-15, -1.107826061183158e-16,  1.649086667316296e-18, -2.326827290627483e-20,  1.398852367339377e-02, -1.234492051081267e-03,  6.166619721443496e-05,
 -2.260215383107172e-06,  6.728310154530477e-08, -1.716056123440508e-09,  3.874381918260200e-11, -7.914079675387671e-13,  1.485502116484178e-14, -2.592061644564435e-16,
  4.242176771266948e-18, -6.556630672628421e-20,  9.960328730891324e-03, -1.039390299040767e-03,  6.015889161689853e-05, -2.520274076754239e-06,  8.488392917351888e-08,
 -2.429777929396194e-09,  6.115953375082577e-11, -1.384971780918967e-12,  2.867969254744572e-14, -5.497235048400872e-16,  9.845215826585031e-18, -1.659369313674575e-19,
  6.936421608491337e-03, -8.431254338191109e-04,  5.595167688717983e-05, -2.656768072076481e-06,  1.005182810489489e-07, -3.208917074386444e-09,  8.953674924405589e-11,
 -2.236007292729187e-12,  5.083219257660958e-14, -1.065375759091846e-15,  2.078839159889071e-17, -3.804952707852986e-19,  4.735067478296644e-03, -6.615879738787107e-04,
  4.985419446795138e-05, -2.662021875733188e-06,  1.123781399411688e-07, -3.977113597315722e-09,  1.223492992700586e-10, -3.352749757182888e-12,  8.328741432044430e-14,
 -1.900369647578418e-15,  4.023401914845958e-17, -7.965527515986481e-19,  3.176020811350952e-03, -5.041148244031953e-04,  4.275084128351104e-05, -2.548016572418964e-06,
  1.192515387301005e-07, -4.652022359071221e-09,  1.569686137583590e-10, -4.697465628875874e-12,  1.269459031517438e-13, -3.140158061692647e-15,  7.184879554049916e-17,
 -1.532809497403350e-18,  2.098490462569190e-03, -3.743871645245474e-04,  3.543391573801195e-05, -2.340881015493138e-06,  1.207180483009716e-07, -5.162491969651128e-09,
  1.901063773666861e-10, -6.184335871359468e-12,  1.810310968683031e-13, -4.835023713810222e-15,  1.190996126389628e-16, -2.727939119997835e-18,  1.369466445704959e-03,
 -2.719722450196731e-04,  2.850520295764593e-05, -2.073461473809104e-06,  1.171301453881226e-07, -5.462174874313880e-09,  2.184560228192280e-10, -7.690523836223401e-12,
  2.428273662519052e-13, -6.974894924087364e-15,  1.842741563652803e-16, -4.515338172270401e-18,  8.851453013618692e-04, -1.939428048042538e-04,  2.234578548870438e-05,
 -1.778367873536976e-06,  1.094249433760114e-07, -5.535950445598290e-09,  2.393314153578505e-10, -9.077782205405436e-12,  3.079039789622435e-13, -9.474642681593160e-15,
  2.674874681289416e-16, -6.987181519969171e-18,  5.682314139935845e-04, -1.362309448136159e-04,  1.713618469212022e-05, -1.483035192696347e-06,  9.885297307903655e-08,
 -5.398469105475241e-09,  2.511176466554433e-10, -1.021809890034705e-11,  3.707975958916135e-13, -1.217657882940671e-14,  3.660123243469700e-16, -1.015671527184178e-17,
  3.633510584233567e-04, -9.458212992207934e-05,  1.290342573624883e-05, -1.207281660654355e-06,  8.671188440302017e-08, -5.086708412868067e-09,  2.534340700353796e-10,
 -1.101585737205171e-11,  4.259613087316972e-13, -1.487114587441516e-14,  4.742083459869878e-16, -1.393087803095091e-17,  2.320892465343834e-04, -6.511962917034565e-05,
  9.574840701384210e-06, -9.630277247655047e-07,  7.414534857503236e-08, -4.649738505206997e-09,  2.470157835617908e-10, -1.142092241364598e-11,  4.687061694002863e-13,
 -1.733046877447598e-14,  5.841376309481343e-16, -1.810374106359323e-17,  1.484964646871968e-04, -4.460304903511963e-05,  7.025546189989313e-06, -7.554354571096708e-07,
  6.203057367051310e-08, -4.138797437988841e-09,  2.334003394792559e-10, -1.143068374363963e-11,  4.958888554676085e-13, -1.934536724614043e-14,  6.867251321825136e-16,
 -2.237512647807589e-17,  9.542243523022527e-05, -3.048333390431499e-05,  5.113711170398984e-06, -5.846917863845769e-07,  5.094747040179818e-08, -3.599754679664568e-09,
  2.145382072614897e-10, -1.108263969046724e-11,  5.062091419986043e-13, -2.075612209879032e-14,  7.731511179149033e-16, -2.639067456294629e-17,  6.172944289211883e-05,
 -2.084386895672176e-05,  3.702960766271937e-06, -4.478408471466387e-07,  4.120577041847948e-08, -3.068757758168266e-09,  1.924317237140613e-10, -1.044129193085397e-11,
  5.001152005839167e-13, -2.147035425469742e-14,  8.361164342642112e-16, -2.979306551601985e-17,  4.028215446432567e-05, -1.429250653717740e-05,  2.674116353994932e-06,
 -3.403195126435404e-07,  3.290273785617176e-08, -2.570821288797793e-09,  1.688674898467316e-10, -9.583568650534760e-12,  4.794190643462501e-13, -2.146604420847174e-14,
  8.707008500164238e-16, -3.227157434379878e-17,  2.655461767186002e-05, -9.844535349460015e-06,  1.929425279165583e-06, -2.570662042330246e-07,  2.598890060245025e-08,
 -2.120547179990411e-09,  1.452633385667940e-10, -8.586096341259862e-12,  4.467711819474856e-13, -2.078197764826834e-14,  8.746892184223029e-16, -3.359909980514753e-17,
  1.769470568369948e-05, -6.817287613389250e-06,  1.392234585231671e-06, -1.932157051355570e-07,  2.032730605736577e-08, -1.724030990848633e-09,  1.226179280552567e-10,
 -7.516142010817376e-12,  4.051341343204944e-13, -1.950042726404210e-14,  8.483998912066583e-16, -3.365079471182437e-17,  1.191093924862654e-05, -4.744335006596532e-06,
  1.004365845332010e-06, -1.444628521730436e-07,  1.573949374976438e-08, -1.381158430332417e-09,  1.015339082172017e-10, -6.426617351591483e-12,  3.573524320655465e-13,
 -1.772737721468452e-14,  7.941611578259086e-16, -3.240411713286651e-17,  8.078043123446918e-06, -3.310009620604761e-06,  7.226761847203002e-07, -1.071958380637936e-07,
  1.203691863855863e-08, -1.087760051890414e-09,  8.228241094000282e-11, -5.354554960581212e-12,  3.058628172278038e-13, -1.557457132205120e-14,  7.156237696676150e-16,
 -2.992452904538235e-17,  5.486657568881368e-06, -2.301612292618837e-06,  5.156506503580006e-07, -7.848855045545814e-08,  9.039678788143905e-09, -8.373508247597419e-10,
  6.488204658818897e-11, -4.322016214993907e-12,  2.525459324088060e-13, -1.314594658567010e-14,  6.170802033874089e-16, -2.634321520784847e-17,  3.685931750087850e-06,
 -1.575595019437977e-06,  3.604224163040390e-07, -5.601880700588760e-08,  6.585605456565363e-09, -6.223750189898221e-10,  4.917438434438911e-11, -3.338361314785174e-12,
  1.986937005175027e-13, -1.052933204822223e-14,  5.029095279601440e-16, -2.183315746245512e-17,  2.384897250864893e-06, -1.034105709489934e-06,  2.403421421131669e-07,
 -3.795631101418508e-08,  4.532789631984793e-09, -4.349940214432363e-10,  3.488646105025493e-11, -2.403029910892188e-12,  1.450571748509961e-13, -7.793085360766291e-15,
  3.772073069821572e-16, -1.658842570204048e-17,  1.390489540662353e-06, -6.088739430718050e-07,  1.430733730999524e-07, -2.284598029788737e-08,  2.758126586816357e-09,
 -2.675145470070789e-10,  2.167790900931232e-11, -1.508319255292426e-12,  9.194416811861861e-14, -4.986826126057181e-15,  2.436162073592470e-16, -1.080975224691726e-17,
  5.687541353331251e-07, -2.504061855662596e-07,  5.920012429920231e-08, -9.511283140529435e-09,  1.155231826793182e-09, -1.127117413756653e-10,  9.186293520716776e-12,
 -6.427610929445123e-13,  3.939543966438774e-14, -2.148050024282704e-15,  1.054773044979084e-16, -4.703604554821410e-18,  8.447479611687127e-02, -3.012669113287413e-04,
  1.130612473741568e-06, -4.408804792370109e-09,  1.763244609386113e-11, -7.156620276435388e-14,  2.925372750705124e-16, -1.198435252945033e-18,  4.905371652333318e-21,
 -2.002794705389650e-23,  8.148677630151055e-26, -3.302677862547145e-28,  8.109413686198463e-02, -4.110804562160252e-04,  2.463684504807005e-06, -1.487367330238518e-08,
  8.719917675944427e-11, -4.956386856438118e-13,  2.743282588548340e-15, -1.484808657108294e-17,  7.884704989835324e-20, -4.118025331752919e-22,  2.119366566491835e-24,
 -1.076420152739550e-26,  7.474838384406252e-02, -6.033620683974138e-04,  5.301693389461546e-06, -4.287767757316105e-08,  3.237630648519156e-10, -2.321485258631196e-12,
  1.597670842955756e-14, -1.062799759976094e-16,  6.868166734896309e-19, -4.328116790203017e-21,  2.667522159374786e-23, -1.611680411361827e-25,  6.618202305786566e-02,
 -8.318045743750381e-04,  9.799008184392966e-06, -1.008440547095549e-07,  9.470712937825674e-10, -8.309185785546749e-12,  6.906515416305283e-14, -5.490085992095720e-16,
  4.202077945744553e-18, -3.112605016599910e-20,  2.240121752317130e-22, -1.571262593165607e-24,  5.632078986053298e-02, -1.044688477936411e-03,  1.583495810405642e-05,
 -2.025834743555306e-07,  2.316859370801213e-09, -2.437448145847288e-11,  2.400464489719370e-13, -2.239153677791278e-15,  1.995020073703071e-17, -1.708463155277577e-19,
  1.413051602550279e-21, -1.133032613219219e-23,  4.610438108590062e-02, -1.198660169514381e-03,  2.285286072429076e-05, -3.572379486245108e-07,  4.895639142348282e-09,
 -6.084449119588480e-11,  7.001542470282286e-13, -7.563927971957316e-15,  7.747529963207591e-17, -7.579241648266804e-19,  7.121748613981150e-21, -6.455847696319082e-23,
  3.634173014351929e-02, -1.268258459799040e-03,  2.990234913308521e-05, -5.629317459074625e-07,  9.124879188559924e-09, -1.324021911744010e-10,  1.760896697406570e-12,
 -2.180676585539077e-14,  2.542883104892588e-16, -2.815453310961468e-18,  2.978740854928768e-20, -3.026449537944508e-22,  2.761826173151213e-02, -1.248888884793015e-03,
  3.587474675575181e-05, -8.031596950791458e-07,  1.523162369120329e-08, -2.555061997983687e-10,  3.891998838326012e-12, -5.478390169895149e-14,  7.214833810507319e-16,
 -8.972016055353970e-18,  1.061004713898755e-19, -1.199741283451123e-21,  2.026494343495170e-02, -1.153639871635131e-03,  3.982021284163207e-05, -1.048372436452479e-06,
  2.303997124761960e-08, -4.430181928295221e-10,  7.668929083982192e-12, -1.218092228669854e-13,  1.799352743350754e-15, -2.496858250709043e-17,  3.279887035711700e-19,
 -4.102953312714651e-21,  1.438065233421512e-02, -1.006313428736658e-03,  4.120534987615966e-05, -1.262865914570118e-06,  3.188713486781521e-08, -6.974836936312316e-10,
  1.362633139830232e-11, -2.426602004506027e-13,  3.996471572692676e-15, -6.152965588794621e-17,  8.929287674079684e-19, -1.229265595570413e-20,  9.888208115979798e-03,
 -8.336658071975146e-04,  4.001536781204120e-05, -1.414400535356120e-06,  4.071045867862982e-08, -1.005979216863119e-09,  2.204102439193187e-11, -4.375220006382201e-13,
  7.990168685268096e-15, -1.357873267573106e-16,  2.166361402248389e-18, -3.266714551461798e-20,  6.602076157906624e-03, -6.592376325564136e-04,  3.668714782711415e-05,
 -1.482672847048542e-06,  4.829277857234232e-08, -1.339478867483616e-09,  3.272269793918333e-11, -7.201730190969404e-13,  1.451095801528119e-14, -2.709217586729360e-16,
  4.730484200352503e-18, -7.779857195949950e-20,  4.290241678629138e-03, -4.999085846641473e-04,  3.192944282593228e-05, -1.463529561430393e-06,  5.357561647242093e-08,
 -1.657944296403945e-09,  4.491422325529483e-11, -1.090462385836050e-12,  2.412904888563802e-14, -4.927405761743991e-16,  9.376778482809211e-18, -1.675210129354438e-19,
  2.720387846066126e-03, -3.651122541850295e-04,  2.651440389821100e-05, -1.367978754333116e-06,  5.591946871607737e-08, -1.919687925742111e-09,  5.737172113297116e-11,
 -1.529312076857830e-12,  3.699726985733498e-14, -8.229361386381963e-16,  1.700033472151356e-17, -3.286870547416281e-19,  1.687835210575693e-03, -2.579103021170994e-04,
  2.111061071615785e-05, -1.217255788059783e-06,  5.522175869726900e-08, -2.091555854136042e-09,  6.861803965117714e-11, -1.999063726374190e-12,  5.264996148471438e-14,
 -1.270505713193170e-15,  2.838435583884781e-17, -5.917576240609846e-19,  1.027709583303959e-03, -1.769299706833088e-04,  1.619160350859916e-05, -1.036367625929294e-06,
  5.187161796783013e-08, -2.156243364388111e-09,  7.728434359035439e-11, -2.449932068634304e-12,  6.995783392396533e-14, -1.824382178297360e-15,  4.391738811624821e-17,
 -9.838325765027973e-19,  6.160634229504615e-04, -1.183574247951241e-04,  1.201826073167203e-05, -8.484156495820615e-07,  4.658573863428294e-08, -2.114560312602466e-09,
  8.241765886714570e-11, -2.830673533544363e-12,  8.728477689960550e-14, -2.450620122601899e-15,  6.333701860780005e-17, -1.519413297189509e-18,  3.647894862062989e-04,
 -7.752141103906490e-05,  8.671921850840414e-06, -6.710360929378232e-07,  4.020139390539515e-08, -1.982697022051263e-09,  8.365439394318533e-11, -3.099794654106527e-12,
  1.028092688506425e-13, -3.096060763087753e-15,  8.560842707963507e-17, -2.191806267437640e-18,  2.141065534109909e-04, -4.991772650418885e-05,  6.110054782624208e-06,
 -5.151822754225118e-07,  3.349629913367236e-08, -1.786303158069381e-09,  8.122275335897680e-11, -3.233607701347682e-12,  1.149049138823229e-13, -3.697858147413268e-15,
  1.090077841486718e-16, -2.968608031223421e-18,  1.250094690388907e-04, -3.173005837257583e-05,  4.222212728399372e-06, -3.856978377893975e-07,  2.707494139982084e-08,
 -1.553811791925879e-09,  7.580374662382776e-11, -3.229011211152758e-12,  1.224563208484850e-13, -4.195900874523652e-15,  1.314038431491467e-16, -3.793625618576967e-18,
  7.287194927298728e-05, -1.999107002390051e-05,  2.873937784762351e-06, -2.828462101286604e-07,  2.132753821364767e-08, -1.310985460153192e-09,  6.832061367873187e-11,
 -3.101043610267679e-12,  1.250221446889309e-13, -4.544185099816152e-15,  1.506544683874735e-16, -4.595276222580727e-18,  4.256562924615284e-05, -1.253393038706007e-05,
  1.935019950774289e-06, -2.040580245789046e-07,  1.644488118232035e-08, -1.077662862593471e-09,  5.973026082940904e-11, -2.876949130619269e-12,  1.228221958042173e-13,
 -4.717926697508011e-15,  1.649958439617410e-16, -5.299095849555272e-18,  2.500216730670734e-05, -7.850604929324075e-06,  1.293952141776011e-06, -1.454297985963911e-07,
  1.246393291392750e-08, -8.667182910120523e-10,  5.086743903651312e-11, -2.589127696405894e-12,  1.165860857330996e-13, -4.715067142280176e-15,  1.733154279116165e-16,
 -5.840621830620996e-18,  1.481735071613591e-05, -4.930170149067800e-06,  8.626122432911555e-07, -1.027829840203491e-07,  9.321767110812550e-09, -6.846477280979967e-10,
  4.236067404687869e-11, -2.268979099186187e-12,  1.073333623054780e-13, -4.552820508215157e-15,  1.752520904814852e-16, -6.175118250879071e-18,  8.886803835670623e-06,
 -3.114461534436964e-06,  5.752375608721181e-07, -7.228519132962010e-08,  6.903316794911459e-09, -5.330179369234742e-10,  3.461305794277141e-11, -1.942760222520899e-12,
  9.615501922145514e-14, -4.261204356128452e-15,  1.711293008953190e-16, -6.282076771043920e-18,  5.407266966663565e-06, -1.984461890332523e-06,  3.847958469820316e-07,
 -5.073060977284118e-08,  5.076512590310976e-09, -4.101307350239136e-10,  2.782740657580060e-11, -1.629659433306882e-12,  8.404415596836192e-14, -3.875802809867647e-15,
  1.617731305722028e-16, -6.164324089717894e-18,  3.343366160582962e-06, -1.277764166885147e-06,  2.587066776348726e-07, -3.559876723107831e-08,  3.714217130716929e-09,
 -3.124925062564641e-10,  2.205312846506880e-11, -1.341670004313313e-12,  7.179486654921432e-14, -3.431529371164788e-15,  1.482839593201306e-16, -5.843084777776662e-18,
  2.101488867592326e-06, -8.318682728003175e-07,  1.749257318862504e-07, -2.499325117560394e-08,  2.705409885753030e-09, -2.359097155631186e-10,  1.723696258587092e-11,
 -1.084590911833479e-12,  5.996509069576647e-14, -2.958325652232205e-15,  1.318221308741906e-16, -5.351049153618715e-18,  1.340560674530233e-06, -5.467769782414415e-07,
  1.187807960690859e-07, -1.753120357056928e-08,  1.958979095217611e-09, -1.761931049960894e-10,  1.326684928171223e-11, -8.595135809616002e-13,  4.888626802056662e-14,
 -2.478948606913444e-15,  1.134450870447543e-16, -4.725396646855604e-18,  8.634510575548553e-07, -3.610452609277293e-07,  8.060217136694666e-08, -1.222535881205708e-08,
  1.403152259681687e-09, -1.295379284976492e-10,  1.000450281724207e-11, -6.643284835795548e-13,  3.869952910599303e-14, -2.008482866260442e-15,  9.400904530613632e-17,
 -4.002129923892975e-18,  5.550449684360548e-07, -2.367638956340933e-07,  5.403508389007357e-08, -8.378954626877329e-09,  9.827953913102716e-10, -9.267374506899605e-11,
  7.306482555521313e-12, -4.949891350619264e-13,  2.940133406060712e-14, -1.555003660857500e-15,  7.413006131725921e-17, -3.212347729299516e-18,  3.469789180307440e-07,
 -1.502679888659994e-07,  3.487700230875861e-08, -5.500452275764628e-09,  6.559871585475089e-10, -6.286986822247563e-11,  5.035714352882362e-12, -3.464367760804841e-13,
  2.088720266469152e-14, -1.120835937666415e-15,  5.418999904644413e-17, -2.380490466964581e-18,  1.974670257680755e-07, -8.641430798329364e-08,  2.029158261813213e-08,
 -3.237897932156906e-09,  3.906320504423067e-10, -3.786235206068323e-11,  3.066133190495741e-12, -2.132001497918488e-13,  1.298811674150696e-14, -7.040135902891981e-16,
  3.437199280734159e-17, -1.524275389892415e-18,  7.968098983751045e-08, -3.507142941175906e-08,  8.288829117277086e-09, -1.331280286054068e-09,  1.616442064459503e-10,
 -1.576603854783994e-11,  1.284571820129825e-12, -8.985343515414262e-14,  5.505547650812701e-15, -3.001033710111574e-16,  1.473193615094346e-17, -6.567629893117978e-19,
  8.328748983246699e-02, -2.924289445011331e-04,  1.079353502618101e-06, -4.137765877000220e-09,  1.626870185765997e-11, -6.493088898595868e-14,  2.610746290090940e-16,
 -1.052397716190382e-18,  4.239698291138649e-21, -1.704123021916541e-23,  6.826956715136111e-26, -2.724905779179149e-28,  7.948813610969516e-02, -3.920619291312564e-04,
  2.293255637988473e-06, -1.355434781761326e-08,  7.791253283161104e-11, -4.345168850357258e-13,  2.360742467799194e-15, -1.254670042636375e-17,  6.544055659187786e-20,
 -3.357844143595022e-22,  1.698178049605264e-24, -8.477177795837844e-27,  7.241662379855654e-02, -5.629219844024498e-04,  4.816775157278407e-06, -3.804904142706447e-08,
  2.809389767564783e-10, -1.971407736187933e-12,  1.328653086708378e-14, -8.660200779259104e-17,  5.486173746149275e-19, -3.390397991671550e-21,  2.049893091266903e-23,
 -1.215361034936074e-25,  6.300427247362070e-02, -7.580074898587981e-04,  8.674592390180379e-06, -8.693528864330615e-08,  7.962924132301363e-10, -6.821870996885378e-12,
  5.541857899438431e-14, -4.308679830871981e-16,  3.227459257846582e-18, -2.340863255860213e-20,  1.650340219756504e-22, -1.134417663001546e-24,  5.238084220066588e-02,
 -9.271377504642189e-04,  1.361124643786576e-05, -1.691207088833962e-07,  1.882252548649288e-09, -1.929889824849744e-11,  1.854356882992288e-13, -1.689151235603814e-15,
  1.470748906794121e-17, -1.231618291557572e-19,  9.966547646622618e-22, -7.822682255991496e-24,  4.165000114766933e-02, -1.031739981423650e-03,  1.899860149851119e-05,
 -2.877971127729662e-07,  3.830978961880758e-09, -4.632549355162843e-11,  5.193333174380198e-13, -5.471414365376588e-15,  5.469986684682596e-17, -5.226802567541125e-19,
  4.800205026333098e-21, -4.255338497852467e-23,  3.170760730833377e-02, -1.053765723832590e-03,  2.394267928798313e-05, -4.360140011013807e-07,  6.854375540676528e-09,
 -9.663427051393722e-11,  1.250491275720407e-12, -1.508502139677384e-14,  1.715156928110567e-16, -1.853119989727279e-18,  1.914587336546525e-20, -1.900810932045150e-22,
  2.314103750326326e-02, -9.966573820040395e-04,  2.754555215448587e-05, -5.957377009837171e-07,  1.094364512441636e-08, -1.781682627905135e-10,  2.638009292954406e-12,
 -3.613841649402442e-14,  4.636669118092180e-16, -5.622386688469734e-18,  6.488398450626371e-20, -7.164732587272521e-22,  1.621586593783396e-02, -8.797469063382522e-04,
  2.918867414247581e-05, -7.416679012957577e-07,  1.577429249344023e-08, -2.941333968533910e-10,  4.945445108701880e-12, -7.639529877391574e-14,  1.098746933070704e-15,
 -1.485878627982088e-17,  1.903789522752875e-19, -2.324622505008603e-21,  1.092968590438289e-02, -7.295701232167013e-04,  2.870360335099408e-05, -8.485745262254400e-07,
  2.072424792789188e-08, -4.393584786853383e-10,  8.332895127398995e-12, -1.442563465957005e-13,  2.312231943023532e-15, -3.468086234802180e-17,  4.907427385629895e-19,
 -6.592614884597971e-21,  7.100125469848080e-03, -5.717219547808401e-04,  2.636967556892748e-05, -8.989462583509802e-07,  2.502054624462553e-08, -5.990914308390737e-10,
  1.273982927145144e-11, -2.457854294902371e-13,  4.367642853004942e-15, -7.229868517932422e-17,  1.124542466276796e-18, -1.654575315057682e-20,  4.455608817331232e-03,
 -4.255624612586182e-04,  2.276865613459374e-05, -8.876504256032071e-07,  2.796050601786475e-08, -7.514956090437173e-10,  1.781862192921492e-11, -3.811472018268935e-13,
  7.473038957819054e-15, -1.359068978626740e-16,  2.313666830015014e-18, -3.713040996623583e-20,  2.707923993606570e-03, -3.023352782322536e-04,  1.858082371111760e-05,
 -8.220211614810196e-07,  2.911273743887679e-08, -8.732675401481084e-10,  2.296738235789414e-11, -5.420959616859321e-13,  1.167493762798511e-14, -2.322911637988503e-16,
  4.310932103813144e-18, -7.517255361657927e-20,  1.598363422717565e-03, -2.059453769999090e-04,  1.440760395372618e-05, -7.180662488566866e-07,  2.841676246283927e-08,
 -9.461325949303384e-10,  2.746573732958179e-11, -7.120866437722973e-13,  1.677454618333528e-14, -3.636946342004349e-16,  7.330236331144475e-18, -1.383890472879156e-19,
  9.190976994263936e-04, -1.351134510906631e-04,  1.066944865151661e-05, -5.949577882169381e-07,  2.615461615512680e-08, -9.615552781167484e-10,  3.066469146814954e-11,
 -8.695028894484732e-13,  2.231371052577472e-14, -5.251869027011443e-16,  1.145439367433237e-17, -2.333226297377946e-19,  5.165918130669125e-04, -8.575613171377480e-05,
  7.583940122094531e-06, -4.700869573215090e-07,  2.282661795086956e-08, -9.220079351268435e-10,  3.215464246107160e-11, -9.929835679291013e-13,  2.765187970091164e-14,
 -7.039192073880821e-16,  1.655550049626873e-17, -3.626446170078398e-19,  2.848378239952559e-04, -5.289374950516542e-05,  5.200089333282733e-06, -3.560653390816511e-07,
  1.899465477389713e-08, -8.388332922946807e-10,  3.184935771709568e-11, -1.066800895668330e-12,  3.211328059644204e-14, -8.809947160056057e-16,  2.226743473279791e-17,
 -5.228134593929868e-19,  1.546616684798393e-04, -3.184927551690520e-05,  3.456595851966193e-06, -2.599008642118114e-07,  1.515152266986634e-08, -7.280906938696629e-10,
  2.996638881906326e-11, -1.084296524108434e-12,  3.515020491760693e-14, -1.035525501632461e-15,  2.803291965084220e-17, -7.032046853033301e-19,  8.303659662547141e-05,
 -1.880926840018590e-05,  2.238595037403576e-06, -1.837674535871807e-07,  1.164739077140357e-08, -6.061954280074764e-10,  2.692879289389499e-11, -1.048391564122519e-12,
  3.646294120562372e-14, -1.149448352688086e-15,  3.321585265024029e-17, -8.873564027692972e-19,  4.426976389431578e-05, -1.094658723262629e-05,  1.419609756489003e-06,
 -1.265205683605060e-07,  8.674400313186170e-09, -4.867117830375132e-10,  2.323670809616157e-11, -9.694831494181932e-13,  3.604007212133463e-14, -1.211391087444130e-15,
  3.724088499663690e-17, -1.056104051744662e-18,  2.354001098886161e-05, -6.308175646928603e-06,  8.859510553340272e-07, -8.525530613678236e-08,  6.291498326323434e-09,
 -3.788269969127753e-10,  1.935471405955178e-11, -8.619290094105429e-13,  3.411866318805274e-14, -1.218410731023650e-15,  3.971222026767367e-17, -1.191578364900548e-18,
  1.254045697991359e-05, -3.616910145101463e-06,  5.468469110388393e-07, -5.651426158245500e-08,  4.466821970581702e-09, -2.873083208029754e-10,  1.564133077794736e-11,
 -7.404958130662145e-13,  3.109256591163705e-14, -1.175386401143678e-15,  4.047590726890091e-17, -1.280734572646261e-18,  6.723109623655359e-06, -2.073231114775385e-06,
  3.354783650627561e-07, -3.703617228110158e-08,  3.119859780000259e-09, -2.133775353571842e-10,  1.232463361355536e-11, -6.177451552675764e-13,  2.740740337641786e-14,
 -1.092707062678980e-15,  3.961539681050482e-17, -1.317378668278697e-18,  3.643071624375027e-06, -1.193528212174933e-06,  2.055185060236753e-07, -2.410941500036339e-08,
  2.153882606748001e-09, -1.559143111698457e-10,  9.512783112695035e-12, -5.027151278795568e-13,  2.347375365713371e-14, -9.832935968479199e-16,  3.739458541356295e-17,
 -1.302330010230895e-18,  2.003441925812693e-06, -6.930423634931353e-07,  1.262776211398137e-07, -1.565840953986268e-08,  1.476239481181011e-09, -1.125733000343201e-10,
  7.223038145282685e-12, -4.007472848325925e-13,  1.961424803459439e-14, -8.599016039547174e-16,  3.417571110308838e-17, -1.242035870219622e-18,  1.122160704745456e-06,
 -4.074494489672639e-07,  7.811965381770643e-08, -1.018537240423146e-08,  1.008300911877011e-09, -8.061578649984869e-11,  5.415011186061465e-12, -3.140537176075393e-13,
  1.604504198480566e-14, -7.332646203905655e-16,  3.033921246068358e-17, -1.146349682942518e-18,  6.419666008491400e-07, -2.432561892563743e-07,  4.880442313023795e-08,
 -6.655384460389345e-09,  6.883328374401631e-10, -5.742285329233031e-11,  4.019318314246592e-12, -2.425971740112097e-13,  1.288273574340331e-14, -6.112084988384833e-16,
  2.622348298568280e-17, -1.026225350002746e-18,  3.756681886226187e-07, -1.477266290530131e-07,  3.084344545284187e-08, -4.375864157798563e-09,  4.704175853127046e-10,
 -4.074711088154992e-11,  2.958054984746974e-12, -1.849690053839959e-13,  1.016504787805574e-14, -4.985653708784727e-16,  2.209090702157699e-17, -8.918657854337872e-19,
  2.247445836685011e-07, -9.121857761157546e-08,  1.971076112054335e-08, -2.893780701362601e-09,  3.216876873406979e-10, -2.878790305611321e-11,  2.157119013479971e-12,
 -1.390953848358018e-13,  7.875306434116396e-15, -3.975882409754596e-16,  1.811755754019426e-17, -7.515621366395444e-19,  1.368970848530443e-07, -5.704594879143655e-08,
  1.268738593025819e-08, -1.917137515126053e-09,  2.192290944909373e-10, -2.016679094883058e-11,  1.552133813544560e-12, -1.027206690655720e-13,  5.964425587104928e-15,
 -3.085776060298653e-16,  1.439935708643374e-17, -6.112058887923326e-19,  8.399947482581100e-08, -3.575142097395280e-08,  8.139189861116003e-09, -1.258989847868448e-09,
  1.473139697851412e-10, -1.385842703583568e-11,  1.090114143098536e-12, -7.368786809389421e-14,  4.367510505434425e-15, -2.305122885628374e-16,  1.096682798711295e-17,
 -4.743106581789203e-19,  5.063322332588154e-08, -2.189941512318336e-08,  5.075455441672599e-09, -7.992853827686455e-10,  9.518699566139117e-11, -9.110012957214118e-12,
  7.286993762213688e-13, -5.006557057689741e-14,  3.014672827641927e-15, -1.615709092257258e-16,  7.802207828207860e-18, -3.423410996046989e-19,  2.808588035510101e-08,
 -1.228272110456989e-08,  2.882080391439876e-09, -4.595492188141441e-10,  5.540129991994034e-11, -5.365986731805959e-12,  4.342406155987357e-13, -3.017394378197562e-14,
  1.836976566075468e-15, -9.950821308671921e-17,  4.855237310305935e-18, -2.151815499696865e-19,  1.117090848395938e-08, -4.915414575178044e-09,  1.161331096598268e-09,
 -1.864602210329731e-10,  2.263244900530771e-11, -2.206737456612362e-12,  1.797403272102331e-13, -1.256849918095252e-14,  7.698630167947636e-16, -4.195179956015188e-17,
  2.058775086127361e-18, -9.175505573854213e-20,  8.213473536008455e-02, -2.839884006871510e-04,  1.031220329138459e-06, -3.887524898286692e-09,  1.503043204369423e-11,
 -5.900392135412917e-14,  2.334182767437920e-16, -9.260386457724750e-19,  3.672612286475240e-21, -1.453569773106954e-23,  5.734927532679355e-26, -2.254706112171433e-28,
  7.795557942507539e-02, -3.743459415553186e-04,  2.137805941541597e-06, -1.237430691160378e-08,  6.976149461238928e-11, -3.818488423553458e-13,  2.037024369309458e-15,
 -1.063360022148806e-17,  5.449022591276586e-20, -2.747623527208189e-22,  1.365833254045254e-24, -6.702978223256405e-27,  7.023921660315066e-02, -5.261406096603677e-04,
  4.385909625305490e-06, -3.385290755150555e-08,  2.445129698757649e-10, -1.679752838278742e-12,  1.109017689067223e-14, -7.085076020396124e-17,  4.401192950790633e-19,
 -2.668099754886479e-21,  1.582988073601815e-23, -9.212446508476002e-26,  6.010472158332139e-02, -6.925769723386590e-04,  7.703533928163117e-06, -7.521774500499280e-08,
  6.722354125911434e-10, -5.625661668538598e-12,  4.468203778469017e-14, -3.398901481202678e-16,  2.492459289802447e-18, -1.770656378474745e-20,  1.223241064875735e-22,
 -8.242516636928191e-25,  4.887790396397341e-02, -8.258814397330393e-04,  1.175049843925471e-05, -1.418658574889681e-07,  1.537206573113167e-09, -1.536665181941109e-11,
  1.441130477726241e-13, -1.282384571211173e-15,  1.091541688201961e-17, -8.941201500117945e-20,  7.081308643681527e-22, -5.442250255071441e-24,  3.780652976836722e-02,
 -8.925896644131403e-04,  1.588429474679102e-05, -2.332850573522048e-07,  3.017652919674740e-09, -3.551824128192645e-11,  3.880549252856279e-13, -3.988400013634721e-15,
  3.893141921509335e-17, -3.634747776689793e-19,  3.263557482868445e-21, -2.830075052767744e-23,  2.784494116946999e-02, -8.814255316164748e-04,  1.930966762853720e-05,
 -3.403080269671527e-07,  5.190556932745045e-09, -7.112758252699211e-11,  8.958867044650216e-13, -1.053104979286212e-14,  1.167856935824592e-16, -1.231677651407149e-18,
  1.243023749099923e-20, -1.206212038051202e-22,  1.955373226185302e-02, -8.021617628370405e-04,  2.133996926002636e-05, -4.460224410042411e-07,  7.939372170210383e-09,
 -1.254924589650247e-10,  1.806671331498484e-12, -2.409444787669525e-14,  3.012607203310054e-16, -3.563084160089845e-18,  4.013693532889627e-20, -4.329171489912735e-22,
  1.311304691996880e-02, -6.779554908056691e-04,  2.162792495991059e-05, -5.305533582163395e-07,  1.092387938034852e-08, -1.975847434741087e-10,  3.227622954093220e-12,
 -4.850355425924420e-14,  6.793707007033098e-16, -8.955747091296662e-18,  1.119447236782421e-19, -1.334514007828054e-21,  8.413330324721578e-03, -5.356393615714994e-04,
  2.025203835323948e-05, -5.776542640057366e-07,  1.364856695654013e-08, -2.805091093369109e-10,  5.165948536347670e-12, -8.695570304433444e-14,  1.356742907906175e-15,
 -1.982835515472711e-17,  2.736261253356863e-19, -3.587623236967037e-21,  5.175362908087679e-03, -3.979216303714161e-04,  1.763693468463355e-05, -5.799431551245386e-07,
  1.561127888309376e-08, -3.622525585750302e-10,  7.477777175129176e-12, -1.402329725931898e-13,  2.425123307870658e-15, -3.910673614554092e-17,  5.930917086664408e-19,
 -8.515502864475332e-21,  3.059597205494616e-03, -2.794227125043686e-04,  1.437147950879622e-05, -5.404806991827419e-07,  1.646518754305284e-08, -4.288449890684738e-10,
  9.869832953496358e-12, -2.052046583293556e-13,  3.915291857902957e-15, -6.936341501025465e-17,  1.151359781258791e-18, -1.803117803525342e-20,  1.743048889121911e-03,
 -1.863826748343231e-04,  1.101958302457665e-05, -4.704803577932461e-07,  1.611934500261024e-08, -4.686579240982829e-10,  1.196628511876287e-11, -2.745706651042308e-13,
  5.755395344942542e-15, -1.115699960457628e-16,  2.019216527997258e-18, -3.436657837550677e-20,  9.598033165479145e-04, -1.186575049841733e-04,  7.994188108635852e-06,
 -3.847888995628534e-07,  1.473953902005250e-08, -4.758946159323148e-10,  1.341748067882275e-11, -3.383067897594622e-13,  7.759462327376697e-15, -1.639714971130123e-16,
  3.224048450871245e-18, -5.943014352406464e-20,  5.125380486291081e-04, -7.243944543634848e-05,  5.516144179623208e-06, -2.973682578053389e-07,  1.266396278956933e-08,
 -4.518131086787421e-10,  1.400319764742935e-11, -3.863853231858991e-13,  9.659920567493305e-15, -2.217207328924490e-16,  4.720093449679447e-18, -9.392638757759420e-20,
  2.663949847609470e-04, -4.260952838019468e-05,  3.639474700200392e-06, -2.183674114946349e-07,  1.028333456759193e-08, -4.034662999189702e-10,  1.368676506638822e-11,
 -4.116373249570734e-13,  1.117597088091953e-14, -2.776488463494586e-16,  6.378415002431970e-18, -1.365866004005828e-19,  1.353033947025484e-04, -2.426590103623281e-05,
  2.308261310491228e-06, -1.532221479947508e-07,  7.937358570807547e-09, -3.408897605501087e-10,  1.260364569753086e-11, -4.115633295429855e-13,  1.209051550244059e-14,
 -3.240012037950755e-16,  8.006213506505268e-18, -1.839227512175176e-19,  6.744353614529221e-05, -1.344664843522000e-05,  1.414840711773006e-06, -1.033061575516060e-07,
  5.857177946300807e-09, -2.741030442535658e-10,  1.099964406189138e-11, -3.884853707508393e-13,  1.230435540547606e-14, -3.544709542533946e-16,  9.391382033920181e-18,
 -2.307373573284056e-19,  3.314521929357425e-05, -7.287910756877766e-06,  8.427212179332636e-07, -6.730652260361383e-08,  4.155973806883194e-09, -2.109774591308969e-10,
  9.151520301266762e-12, -3.482432132982308e-13,  1.184910726256086e-14, -3.657275382021851e-16,  1.035569500134833e-17, -2.712774842678289e-19,  1.613886328417574e-05,
 -3.884026002944563e-06,  4.905015934844553e-07, -4.261870981938664e-08,  2.851979637228885e-09, -1.563550216604459e-10,  7.300866723563884e-12, -2.981887219059419e-13,
  1.086044100855669e-14, -3.579225523425401e-16,  1.079630814276139e-17, -3.006135386471142e-19,  7.825715260466466e-06, -2.046623407178794e-06,  2.805741392501776e-07,
 -2.637964174950736e-08,  1.903881804171732e-09, -1.122208223819855e-10,  5.617534318206126e-12, -2.453062632254689e-13,  9.528689862821534e-15, -3.341501199050139e-16,
  1.070189715535549e-17, -3.157340023179190e-19,  3.799099440950675e-06, -1.072277613330631e-06,  1.586373900627507e-07, -1.605424730534902e-08,  1.243612430323366e-09,
 -7.845895113454251e-11,  4.192850016619770e-12, -1.949895794623536e-13,  8.048031184312698e-15, -2.992471891131225e-16,  1.014184709108608e-17, -3.160091873056997e-19,
  1.856483069837483e-06, -5.617545053284034e-07,  8.916942065092015e-08, -9.662247171528184e-09,  7.994458135019762e-10, -5.374101819447799e-11,  3.052972153222279e-12,
 -1.505990095559471e-13,  6.579618150253459e-15, -2.584623464358057e-16,  9.237293575323336e-18, -3.029715536299551e-19,  9.181067725032383e-07, -2.959279155546678e-07,
  5.011166341953671e-08, -5.783541882715223e-09,  5.086211683910592e-10, -3.626404151977313e-11,  2.180524044311451e-12, -1.136245199991383e-13,  5.234206545191514e-15,
 -2.164108243024695e-16,  8.126990064823678e-18, -2.796172210383876e-19,  4.618954515891899e-07, -1.576019282538450e-07,  2.830920697820615e-08, -3.461627546253684e-09,
  3.219714047693075e-10, -2.423435060652950e-11,  1.535521582997284e-12, -8.416729679425914e-14,  4.071634765624752e-15, -1.765015466164307e-16,  6.938876149794322e-18,
 -2.495439988720390e-19,  2.375291307622833e-07, -8.527439372156533e-08,  1.615604674485054e-08, -2.081952304760120e-09,  2.037774843677609e-10, -1.611481061802425e-11,
  1.071051226462722e-12, -6.148687020968197e-14,  3.110585309812178e-15, -1.408098552837973e-16,  5.772833131118512e-18, -2.162006318039128e-19,  1.253604927242805e-07,
 -4.707274568970500e-08,  9.353468009191550e-09, -1.263428780890889e-09,  1.294661269893214e-10, -1.070416888057852e-11,  7.427852360072691e-13, -4.445991626713314e-14,
  2.342005584339146e-15, -1.102518660581046e-16,  4.694813184721923e-18, -1.823974490347631e-19,  6.808910813867298e-08, -2.658739992854456e-08,  5.509292600801542e-09,
 -7.757912964231689e-10,  8.279372997028421e-11, -7.121018504951797e-12,  5.134334559228498e-13, -3.189403096062707e-14,  1.741603898975885e-15, -8.489556871703265e-17,
  3.739289869037671e-18, -1.500996799597376e-19,  3.808612370012822e-08, -1.537769288273763e-08,  3.304062625671989e-09, -4.823512103554442e-10,  5.332664638915880e-11,
 -4.746824910611700e-12,  3.538545839306628e-13, -2.270360113229050e-14,  1.279242225789231e-15, -6.428235611590225e-17,  2.916069742793501e-18, -1.204404614446027e-19,
  2.187624894133279e-08, -9.082595849252088e-09,  2.011929162165339e-09, -3.027993576329007e-10,  3.449053938643106e-11, -3.160729165990993e-12,  2.423703942750919e-13,
 -1.598304327984196e-14,  9.248510467744458e-16, -4.768896953633339e-17,  2.218166652430774e-18, -9.386099979296539e-20,  1.277993933431166e-08, -5.426371267232504e-09,
  1.232123102764857e-09, -1.900869335778772e-10,  2.218475334045289e-11, -2.081784029501338e-12,  1.633568204208948e-13, -1.101634756442283e-14,  6.514546935781487e-16,
 -3.430713133888787e-17,  1.628702908056223e-18, -7.029527289624520e-20,  7.412231338870762e-09, -3.201415609166716e-09,  7.408213464710145e-10, -1.164842949502137e-10,
  1.385104398630149e-11, -1.323670762039870e-12,  1.057264335496641e-13, -7.253823063623246e-15,  4.361930966584909e-16, -2.334696236926156e-17,  1.125979881814196e-18,
 -4.934422322863257e-20,  4.001170961031485e-09, -1.748605849360734e-09,  4.099828328571090e-10, -6.532078686179987e-11,  7.868720049040620e-12, -7.615629458033339e-13,
  6.158385044670515e-14, -4.276190112877262e-15,  2.601509371667154e-16, -1.408269367293992e-17,  6.866734724704033e-19, -3.041350009989212e-20,  1.567253215442093e-09,
 -6.894107187011823e-10,  1.628259976839760e-10, -2.613372516847084e-11,  3.170991737813657e-12, -3.090756430295305e-13,  2.516591630981406e-14, -1.759164549486948e-15,
  1.077196895516992e-16, -5.868047039531709e-18,  2.878829737338240e-19, -1.282638401976257e-20,  8.101499148659073e-02, -2.759212387229050e-04,  9.859749716797561e-07,
 -3.656182818574334e-09,  1.390434038549769e-11, -5.370021968488974e-14,  2.090589054420416e-16, -8.164635618389253e-19,  3.188336790090179e-21, -1.242827909271913e-23,
  4.830101472288378e-26, -1.870882500900640e-28,  7.649148615092534e-02, -3.578190492693628e-04,  1.995767677924334e-06, -1.131666033322035e-08,  6.259026746595117e-11,
 -3.363448870168287e-13,  1.762280134803727e-15, -9.038182413995207e-18,  4.551508062428549e-20, -2.255958094944466e-22,  1.102550274874246e-24, -5.320806320859709e-27,
  6.820234653870119e-02, -4.926142271971486e-04,  4.002084411388835e-06, -3.019564585900640e-08,  2.134267296737243e-10, -1.435887547868884e-12,  9.289916743666731e-15,
 -5.818906630993260e-17,  3.545522422283558e-19, -2.109049195736000e-21,  1.228224684166722e-23, -7.018033984724229e-26,  5.745220101078303e-02, -6.343844925321178e-04,
  6.861922921236647e-06, -6.530689972290836e-08,  5.697191946624086e-10, -4.659040022851807e-12,  3.619225078904617e-14, -2.694526905055585e-16,  1.935009233215070e-18,
 -1.346829662237421e-20,  9.120073610753325e-23, -6.025839994815770e-25,  4.575216533481060e-02, -7.382910874288589e-04,  1.018611499635262e-05, -1.195528276422178e-07,
  1.261744262466648e-09, -1.230213948644361e-11,  1.126489112815391e-13, -9.795618843349551e-16,  8.153584329787487e-18, -6.535189486583278e-20,  5.067050563425059e-22,
 -3.814165194718465e-24,  3.447368168558918e-02, -7.759430664563991e-04,  1.335266787338485e-05, -1.902150889167890e-07,  2.392054925081767e-09, -2.741549612658726e-11,
  2.920203221559239e-13, -2.929009886166602e-15,  2.792410945945567e-17, -2.548077695949876e-19,  2.237442041242146e-21, -1.898514972479883e-23,  2.460418993791527e-02,
 -7.419721369777518e-04,  1.568084806658424e-05, -2.675644439061784e-07,  3.961154017920831e-09, -5.278021744792984e-11,  6.472998735619342e-13, -7.416891181929118e-15,
  8.024839563295103e-17, -8.263818935980953e-19,  8.148858141911421e-21, -7.731049813974221e-23,  1.665544222636680e-02, -6.508680832734041e-04,  1.667410338201284e-05,
 -3.369265766087042e-07,  5.813642477291274e-09, -8.924702420113283e-11,  1.249718800291834e-12, -1.623036337186510e-14,  1.978189289675561e-16, -2.282648650678291e-18,
  2.510562228414366e-20, -2.645674005627098e-22,  1.071078035986352e-02, -5.277024668713573e-04,  1.619204159696778e-05, -3.835971163082320e-07,  7.648343891964967e-09,
 -1.342320119893429e-10,  2.130967458817178e-12, -3.116112727264715e-14,  4.251656036193004e-16, -5.464694290781511e-18,  6.665482519456509e-20, -7.759421940537880e-22,
  6.555633192083739e-03, -3.980244357655359e-04,  1.446506810758336e-05, -3.981695689893614e-07,  9.103805114585926e-09, -1.814285254947204e-10,  3.245140980097238e-12,
 -5.312320564031084e-14,  8.070035022756051e-16, -1.149420169218003e-17,  1.547160473675759e-19, -1.980177395927885e-21,  3.827132860265500e-03, -2.809104691799235e-04,
  1.196549772547745e-05, -3.795645149642302e-07,  9.883188988808053e-09, -2.222885736984260e-10,  4.454900383393700e-12, -8.122081564358052e-14,  1.367121404167998e-15,
 -2.147924763410826e-17,  3.176656587644653e-19, -4.451319215153960e-21,  2.136331347546135e-03, -1.864924043243823e-04,  9.220238265684677e-06, -3.345081775258938e-07,
  9.856066109940754e-09, -2.487842170036714e-10,  5.558141295813573e-12, -1.123314252237033e-13,  2.085858638846127e-15, -3.600025993266712e-17,  5.826900263594741e-19,
 -8.905579053291957e-21,  1.143439164337930e-03, -1.170471941163877e-04,  6.656172730230409e-06, -2.742341446774454e-07,  9.088993351577615e-09, -2.561307146259453e-10,
  6.348961944909827e-12, -1.416213658650242e-13,  2.889312867036012e-15, -5.457114424007704e-17,  9.631566239347506e-19, -1.599984057705001e-20,  5.886685194456277e-04,
 -6.978855759531160e-05,  4.526580671730104e-06, -2.103809218369268e-07,  7.799300693285928e-09, -2.441646566755604e-10,  6.685336340009959e-12, -1.639176823415658e-13,
  3.660307637191088e-15, -7.538322768084375e-17,  1.445875233560729e-18, -2.602126557970051e-20,  2.925259840952372e-04, -3.972349406739125e-05,  2.915697507160420e-06,
 -1.519078178318155e-07,  6.265544860458340e-09, -2.168799119330128e-10,  6.531472680862972e-12, -1.753446894696746e-13,  4.270023650697512e-15, -9.556306789284637e-17,
  1.985452747312096e-18, -3.859131777916489e-20,  1.408582284617693e-04, -2.169248048335784e-05,  1.788606598853069e-06, -1.038358944505295e-07,  4.740488171229125e-09,
 -1.806103652711244e-10,  5.958000656166748e-12, -1.744696321656319e-13,  4.617166707299183e-15, -1.119184256618768e-16,  2.510864428676865e-18, -5.255155392995056e-20,
  6.600598814213470e-05, -1.142356481273472e-05,  1.050757737690332e-06, -6.758221209700224e-08,  3.398169183772080e-09, -1.418741103551979e-10,  5.106045460263936e-12,
 -1.624938491326426e-13,  4.657095772338182e-15, -1.218711188782867e-16,  2.943348172106284e-18, -6.613981388113763e-20,  3.024131459813192e-05, -5.832480103079568e-06,
  5.945473740144332e-07, -4.213113887692872e-08,  2.321921565033385e-09, -1.057693429444725e-10,  4.136642215167011e-12, -1.425434613354865e-13,  4.409279453120951e-15,
 -1.241706244532720e-16,  3.218526237858716e-18, -7.742380805985811e-20,  1.361569082825070e-05, -2.903378365380232e-06,  3.259335205250630e-07, -2.530989115248667e-08,
  1.521593791473497e-09, -7.530102649036913e-11,  3.187781297184755e-12, -1.185093599373526e-13,  3.943068620013060e-15, -1.191117620023692e-16,  3.303425485019912e-18,
 -8.482243648768219e-20,  6.057203211587704e-06, -1.417455988472141e-06,  1.741739507328553e-07, -1.474332361453988e-08,  9.623255737425347e-10, -5.151757572056093e-11,
  2.351424056658188e-12, -9.396521258628642e-14,  3.351314837793101e-15, -1.082409826892396e-16,  3.202064629640524e-18, -8.750235828735222e-20,  2.678074759245520e-06,
 -6.828761329404393e-07,  9.130434404878576e-08, -8.380924105805006e-09,  5.911496206874025e-10, -3.408748961648529e-11,  1.670818466865269e-12, -7.150249060665732e-14,
  2.724042229602441e-15, -9.375719533305614e-17,  2.949159596385610e-18, -8.550979052965487e-20,  1.183984464518361e-06, -3.267165054912314e-07,  4.725783571806363e-08,
 -4.679656416855554e-09,  3.550188348883140e-10, -2.195456551420997e-11,  1.150955526223870e-12, -5.254778743217369e-14,  2.130742131146577e-15, -7.788491266728446e-17,
  2.596495436692477e-18, -7.962987054429549e-20,  5.267340581749096e-07, -1.562566916124405e-07,  2.431097514717620e-08, -2.583640865145803e-09,  2.098135422283560e-10,
 -1.385354531375011e-11,  7.735586475980100e-13, -3.753139495767855e-14,  1.613780617327160e-15, -6.242587299261270e-17,  2.198227306924273e-18, -7.107602715274236e-20,
  2.373290601328708e-07, -7.519887392193222e-08,  1.251288915149304e-08, -1.419748721488664e-09,  1.228218368549844e-10, -8.619665426400730e-12,  5.104679256915299e-13,
 -2.621321763530839e-14,  1.190620779538267e-15, -4.856196970843388e-17,  1.799905518145531e-18, -6.114946536055216e-20,  1.089895330796238e-07, -3.665316100651207e-08,
  6.485769290720284e-09, -7.815311686268061e-10,  7.166842546297129e-11, -5.321192995297066e-12,  3.327504226674206e-13, -1.800943911999886e-14,  8.606341760347966e-16,
 -3.687056910310283e-17,  1.433114063683055e-18, -5.097739780225779e-20,  5.132336761925850e-08, -1.820598367919545e-08,  3.406260440660266e-09, -4.335732161666593e-10,
  4.193368577766609e-11, -3.278133615330203e-12,  2.154689384034619e-13, -1.223777340316536e-14,  6.127354241133920e-16, -2.746200945283092e-17,  1.115081457858556e-18,
 -4.137556313554296e-20,  2.491563224077676e-08, -9.266089846720002e-09,  1.822483817031720e-09, -2.437087237954730e-10,  2.473045391927610e-11, -2.025467370223506e-12,
  1.392752213449901e-13, -8.263348462358526e-15,  4.316041861085200e-16, -2.015216914229416e-17,  8.513623544232924e-19, -3.282457875636128e-20,  1.252161690555267e-08,
 -4.852961338859717e-09,  9.975654515889169e-10, -1.393616690795105e-10,  1.475847112837294e-11, -1.259906086079845e-12,  9.018647899731371e-14, -5.563335309243443e-15,
  3.017503534029154e-16, -1.461356132674151e-17,  6.396299425301994e-19, -2.552032321924098e-20,  6.528086832983012e-09, -2.621140685537110e-09,  5.597923401189342e-10,
 -8.123463226607102e-11,  8.928657647545841e-12, -7.902899911209467e-13,  5.859082617509879e-14, -3.739388447386935e-15,  2.096221219113457e-16, -1.048164445584522e-17,
  4.732175441605705e-19, -1.945515850180589e-20,  3.525187887444171e-09, -1.457867017141490e-09,  3.215592429434153e-10, -4.818940276217500e-11,  5.466226993607821e-12,
 -4.989061460260830e-13,  3.810750457889559e-14, -2.503486315776745e-15,  1.443333232130611e-16, -7.416080619841588e-18,  3.437661653570022e-19, -1.449837187006788e-20,
  1.955379918624878e-09, -8.281424384209337e-10,  1.875123834492236e-10, -2.884761078876155e-11,  3.357529223543054e-12, -3.142256327232290e-13,  2.459343573808017e-14,
 -1.654363860642837e-15,  9.759419467596681e-17, -5.127485931351241e-18,  2.428706818341491e-19, -1.045940035210052e-20,  1.088758296647474e-09, -4.695482304651009e-10,
  1.084766666210772e-10, -1.702838373144052e-11,  2.021554166688287e-12, -1.928847429542892e-13,  1.538282741117823e-14, -1.053838735021549e-15,  6.327910068273099e-17,
 -3.382247891308093e-18,  1.628987996410161e-19, -7.129440144540711e-21,  5.709970458953290e-10, -2.493551474473830e-10,  5.841626870058205e-11, -9.299485658752338e-12,
  1.119325743394557e-12, -1.082457952295289e-13,  8.746487855943807e-15, -6.068683855289867e-16,  3.689287801397279e-17, -1.995681919770378e-18,  9.724178049181524e-20,
 -4.304029822504666e-21,  2.200497714111374e-10, -9.676557528595632e-11,  2.284597052275433e-11, -3.665454168209376e-12,  4.445937204836914e-13, -4.331886084780079e-14,
  3.525914390912318e-15, -2.463855065524913e-16,  1.508191259384017e-17, -8.213163965499309e-19,  4.028017726288396e-20, -1.794078243800886e-21,  7.992680949518825e-02,
 -2.682052336351254e-04,  9.434010147038691e-07, -3.442040365222575e-09,  1.287871626635925e-11, -4.894600915575337e-14,  1.875616068860835e-16, -7.212381011579722e-19,
  2.773800784009977e-21, -1.065117143545325e-23,  4.078308863049457e-26, -1.556638632211541e-28,  7.509130554943703e-02, -3.423795797188825e-04,  1.865761647671231e-06,
 -1.036681639806296e-08,  5.626663817475034e-11, -2.969296214027860e-13,  1.528438992555783e-15, -7.703568679368651e-18,  3.813415391073126e-20, -1.858386360810075e-22,
  8.931750006663249e-25, -4.239636746187442e-27,  6.629370728565168e-02, -4.619909973412876e-04,  3.659315721972106e-06, -2.699897790093086e-08,  1.868129259813769e-10,
 -1.231265920443239e-12,  7.808690717928763e-15, -4.796911058431786e-17,  2.867733613202366e-19, -1.674330687081670e-21,  9.573381177449932e-24, -5.372265902853670e-26,
  5.501970028977150e-02, -5.824756640914082e-04,  6.130004358894844e-06, -5.689208912273629e-08,  4.846477637222755e-10, -3.874389177784772e-12,  2.944630389078924e-14,
 -2.146348114370336e-16,  1.509894300366076e-18, -1.029980597376363e-20,  6.838287421035985e-23, -4.431579715060060e-25,  4.295335381463918e-02, -6.622152978722749e-04,
  8.864940669232258e-06, -1.011951890983018e-07,  1.040659198831259e-09, -9.900256771586655e-12,  8.854639752948697e-14, -7.526841824885553e-16,  6.128637487076575e-18,
 -4.807962986299842e-20,  3.650610922890138e-22, -2.692229420185960e-24,  3.156996232342345e-02, -6.776407377736631e-04,  1.128279130408435e-05, -1.559740653291650e-07,
  1.907674889038420e-09, -2.129807866205596e-11,  2.212533220982792e-13, -2.166445431375401e-15,  2.017916894568483e-17, -1.800234596561556e-19,  1.546384561883252e-21,
 -1.284271690849148e-23,  2.186828187735680e-02, -6.283660843733061e-04,  1.281806368987881e-05, -2.118524547332898e-07,  3.045470853556840e-09, -3.947231169157623e-11,
  4.715185478204807e-13, -5.268128775306042e-15,  5.562919176147059e-17, -5.595161352832099e-19,  5.392427388752146e-21, -5.003107821027402e-23,  1.429521517538313e-02,
 -5.321922070258308e-04,  1.313507671971512e-05, -2.567007398624719e-07,  4.295222206164554e-09, -6.406138717917443e-11,  8.727980851822014e-13, -1.104183501971543e-14,
  1.312262735373485e-16, -1.477742420848233e-18,  1.587293922224270e-20, -1.634686985867580e-22,  8.832578810936187e-03, -4.146857932731985e-04,  1.224277657532533e-05,
 -2.801931083473389e-07,  5.411698567968848e-09, -9.218644126769594e-11,  1.422670201912633e-12, -2.024902755386279e-14,  2.691982402937665e-16, -3.374410453893458e-18,
  4.017233056838554e-20, -4.567695189315467e-22,  5.167879735870413e-03, -2.991903871535270e-04,  1.045369786261892e-05, -2.777633282752472e-07,  6.147186763035506e-09,
 -1.188199257798747e-10,  2.064642688400868e-12, -3.287727154869925e-14,  4.863743947148930e-16, -6.752666915508454e-18,  8.867466882409334e-20, -1.108064279676355e-21,
  2.869484979863453e-03, -2.010210003541014e-04,  8.229699751655375e-06, -2.518831143639160e-07,  6.345192885168076e-09, -1.383530913216980e-10,  2.692431716286101e-12,
 -4.773070995076089e-14,  7.820998033893655e-16, -1.197382899591930e-17,  1.727133684665000e-19, -2.362279222688141e-21,  1.515802528512466e-03, -1.264419111154219e-04,
  6.008976639322393e-06, -2.103163709791136e-07,  5.993996844239654e-09, -1.466435485275803e-10,  3.180608232716086e-12, -6.249118281596725e-14,  1.129405713364815e-15,
 -1.899170213017418e-17,  2.997666686126828e-19, -4.471494245776726e-21,  7.639446612401174e-04, -7.483037895105160e-05,  4.092400797965408e-06, -1.626932709578230e-07,
  5.216093830988950e-09, -1.424726167555036e-10,  3.428607277254648e-12, -7.435064371973975e-14,  1.476404830701124e-15, -2.716938938370624e-17,  4.676498048696814e-19,
 -7.582489703258770e-21,  3.685191878669731e-04, -4.187415975419503e-05,  2.614079136772917e-06, -1.172917415888363e-07,  4.207778919435785e-09, -1.277149959550747e-10,
  3.395722095492469e-12, -8.096022429511367e-14,  1.759994373863309e-15, -3.532378114191742e-17,  6.608837983461682e-19, -1.161164588081086e-20,  1.707703090990138e-04,
 -2.226686975946086e-05,  1.574772750659262e-06, -7.927025169378361e-08,  3.165886843803020e-09, -1.063032242463887e-10,  3.110224007171113e-12, -8.122664913552675e-14,
  1.926473801943483e-15, -4.203349477841414e-17,  8.521930146755166e-19, -1.617745279235413e-20,  7.632769741409073e-05, -1.130956262412636e-05,  8.997194384872015e-07,
 -5.051875059274835e-08,  2.235196496217467e-09, -8.267207458348591e-11,  2.651377171893265e-12, -7.557813292245468e-14,  1.949144525216452e-15, -4.608904620553465e-17,
  1.009579116655918e-18, -2.064850586310864e-20,  3.305459175293155e-05, -5.516145629858026e-06,  4.903299158650215e-07, -3.054197865108039e-08,  1.489991314371021e-09,
 -6.045036006779139e-11,  2.117053359029886e-12, -6.563861615518105e-14,  1.834764120110027e-15, -4.687369282431603e-17,  1.106153469404670e-18, -2.430743614196120e-20,
  1.393897213214749e-05, -2.598289313879159e-06,  2.564262483064536e-07, -1.762479411710107e-08,  9.436865640798647e-10, -4.182406887914594e-11,  1.593507357345330e-12,
 -5.355328600016939e-14,  1.617269857146030e-15, -4.450529326269317e-17,  1.128222513878185e-18, -2.656455918659475e-20,  5.755202591838077e-06, -1.189073897901406e-06,
  1.294941408680896e-07, -9.770414523724080e-09,  5.715548747059166e-10, -2.755912852641671e-11,  1.138067090382093e-12, -4.131477918521444e-14,  1.343619726744996e-15,
 -3.970684603798525e-17,  1.078182657718211e-18, -2.712602329142886e-20,  2.340534059319425e-06, -5.320696984058288e-07,  6.356320194146263e-08, -5.237905864053850e-09,
  3.332585443883477e-10, -1.741092675421465e-11,  7.763686606368196e-13, -3.033865346904867e-14,  1.059063262676833e-15, -3.350655642908843e-17,  9.716866920925154e-19,
 -2.604871869598156e-20,  9.436086122320904e-07, -2.343683521020333e-07,  3.053669724175683e-08, -2.734456379830559e-09,  1.883682204100619e-10, -1.061911400631828e-11,
  5.093564519617046e-13, -2.134988795755437e-14,  7.973015704852258e-16, -2.691990847120916e-17,  8.312464440789237e-19, -2.367561970459198e-20,  3.797313851678423e-07,
 -1.023498086773996e-07,  1.446181571897846e-08, -1.400163368102347e-09,  1.039546267417146e-10, -6.297088371328033e-12,  3.236419598395507e-13, -1.449754634417830e-14,
  5.771951696563126e-16, -2.072968026921201e-17,  6.794385238300204e-19, -2.049887546354119e-20,  1.536418541498288e-07, -4.464264455220818e-08,  6.802071968992381e-09,
 -7.084329825672286e-10,  5.642528075958018e-11, -3.656911555940403e-12,  2.005773949056842e-13, -9.565782656753491e-15,  4.045663082762262e-16, -1.540258092409838e-17,
  5.341126230556165e-19, -1.701600049203636e-20,  6.297057038016753e-08, -1.959708041087112e-08,  3.201684863960388e-09, -3.568628968110892e-10,  3.034724598256412e-11,
 -2.094957437691676e-12,  1.221154215205515e-13, -6.175912357931915e-15,  2.764263035780094e-16, -1.111627388366248e-17,  4.064322337426529e-19, -1.362769616648494e-20,
  2.634134388768811e-08, -8.724325105775675e-09,  1.519627372929676e-09, -1.803198240751524e-10,  1.629206834931599e-11, -1.192468026800124e-12,  7.354920589858574e-14,
 -3.928287012385150e-15,  1.853428884487687e-16, -7.843156778380996e-18,  3.012549648911932e-19, -1.059403729177879e-20,  1.132941490344751e-08, -3.968278125902349e-09,
  7.326835949414843e-10, -9.205921089724490e-11,  8.792543203789695e-12, -6.790748977569311e-13,  4.411701102873432e-14, -2.477640510608771e-15,  1.227154403374904e-16,
 -5.442722605396186e-18,  2.187797744747065e-19, -8.039349267787994e-21,  5.044291907552234e-09, -1.856880173690038e-09,  3.612912038276281e-10, -4.780203874427240e-11,
  4.800945198406522e-12, -3.893059792650573e-13,  2.651326795596401e-14, -1.558538019749784e-15,  8.067918967556935e-17, -3.734638704279089e-18,  1.564668245075784e-19,
 -5.984387888299868e-21,  2.338193920276978e-09, -8.990131177411610e-10,  1.832318731729003e-10, -2.538332385434217e-11,  2.666203708245288e-12, -2.258147881034837e-13,
  1.604114721123106e-14, -9.822553243814267e-16,  5.289853968411559e-17, -2.544285720386377e-18,  1.106254783641483e-19, -4.385648272860328e-21,  1.132475002709267e-09,
 -4.520135996490906e-10,  9.591777692058264e-11, -1.383083092433019e-11,  1.510773248855728e-12, -1.329197709366666e-13,  9.797366542610543e-15, -6.217884947584292e-16,
  3.466769337779647e-17, -1.724421418210117e-18,  7.746013440331723e-20, -3.169093042717565e-21,  5.731190400152797e-10, -2.360274047851099e-10,  5.182296101511520e-11,
 -7.731073410261697e-12,  8.730718571511570e-13, -7.934374802402966e-14,  6.035260472038868e-15, -3.948956181437815e-16,  2.267847600503639e-17, -1.160883339464199e-18,
  5.361654378588088e-20, -2.253372656190734e-21,  3.009821734023673e-10, -1.271250688771516e-10,  2.869815012377538e-11, -4.401839542631967e-12,  5.108260889092556e-13,
 -4.767161787786036e-14,  3.720838130679538e-15, -2.496285942262569e-16,  1.468813807367751e-17, -7.697742443611856e-19,  3.637354037388172e-20, -1.562808550607793e-21,
  1.605012048262863e-10, -6.910965626917371e-11,  1.593792076232163e-11, -2.497494684941110e-12,  2.959834014538109e-13, -2.819360033625592e-14,  2.244816668167067e-15,
 -1.535438858591036e-16,  9.205632917557264e-18, -4.913088315898038e-19,  2.362887054609406e-20, -1.032708211423487e-21,  8.163449956266849e-11, -3.562195195148474e-11,
  8.337824121183898e-12, -1.326157680624592e-12,  1.594836367784224e-13, -1.541000389110052e-14,  1.244133630725117e-15, -8.625399769746924e-17,  5.239481975318114e-18,
 -2.832094572875170e-19,  1.378952202532726e-20, -6.099038172156770e-22,  3.092067013539620e-11, -1.359262778790281e-11,  3.207952229910311e-12, -5.144929089342439e-13,
  6.238059532079408e-14, -6.075755525247791e-15,  4.943505710700795e-16, -3.453198648579015e-17,  2.113046789181187e-18, -1.150303977848876e-19,  5.639570567700593e-21,
 -2.511030802232787e-22,  7.886882623111545e-02, -2.608198132864839e-04,  9.033013566408230e-07, -3.243574376254161e-09,  1.194322547414843e-11, -4.467717989567353e-14,
  1.685541281596214e-16, -6.383096185162232e-19,  2.418144953225250e-21, -9.148869120847366e-24,  3.451982794661734e-26, -1.298620033133151e-28,  7.375087256609933e-02,
 -3.279362279374190e-04,  1.746571736154294e-06, -9.512136776179941e-09,  5.067808669956331e-11, -2.627035355042005e-13,  1.328864538524864e-15, -6.583772233148268e-18,
  3.204453007422272e-20, -1.535777337106635e-22,  7.260481731942707e-25, -3.390564812251717e-27,  6.450230977488161e-02, -4.339634169517013e-04,  3.352481172089811e-06,
 -2.419722979760896e-08,  1.639580315481073e-10, -1.058991154530559e-12,  6.585469929943241e-15, -3.968725572949772e-17,  2.328566446146769e-19, -1.334765905543596e-21,
  7.495088713744688e-24, -4.131757598182588e-26,  5.278373254717968e-02, -5.360402746691228e-04,  5.491387403235034e-06, -4.972117849668981e-08,  4.137671301920163e-10,
 -3.234660044164384e-12,  2.406077328327616e-14, -1.717588572994490e-16,  1.183976537090631e-18, -7.917807748620768e-21,  5.155583588361031e-23, -3.277923850147758e-25,
  4.043902151594247e-02, -5.958844145420706e-04,  7.744322871841253e-06, -8.602000488307691e-08,  8.623062056463128e-10, -8.007387973784303e-12,  6.997549012444428e-14,
 -5.816597095239182e-16,  4.634379716183710e-18, -3.559649871701617e-20,  2.647552941030493e-22, -1.913436951899804e-24,  2.902876211245110e-02, -5.943768708457066e-04,
  9.581063798935228e-06, -1.285898298492056e-07,  1.530253782507965e-09, -1.664854404631949e-11,  1.687379466590158e-13, -1.613491080404652e-15,  1.468781126974939e-17,
 -1.281464792484751e-19,  1.077133961091969e-21, -8.758027481748532e-24,  1.954490087566131e-02, -5.352183628980199e-04,  1.054401058884886e-05, -1.688723888761590e-07,
  2.358206670685692e-09, -2.974202607207353e-11,  3.461783218626144e-13, -3.772600796663922e-15,  3.889138920393057e-17, -3.821696222741202e-19,  3.600848293988928e-21,
 -3.268058516335870e-23,  1.235862802189814e-02, -4.383553965759277e-04,  1.042814739561034e-05, -1.971860481300960e-07,  3.200681788092264e-09, -4.639487474084305e-11,
  6.152169520471828e-13, -7.584043077095328e-15,  8.791161320649101e-17, -9.663849147116653e-19,  1.014024772092099e-20, -1.020810613524720e-22,  7.350332832417948e-03,
 -3.288498289932001e-04,  9.344661155045871e-06, -2.066771935695297e-07,  3.868077712161363e-09, -6.397466839889582e-11,  9.600384342194321e-13, -1.330368033491813e-14,
  1.723756217882768e-16, -2.107784399257924e-18,  2.449738228024572e-20, -2.721182256389935e-22,  4.119410025932891e-03, -2.273859585533565e-04,  7.640182892671536e-06,
 -1.960112379547915e-07,  4.199955113987812e-09, -7.875885082843904e-11,  1.329808094358942e-12, -2.060348881256124e-14,  2.968894309558809e-16, -4.018745769041295e-18,
  5.149527457120334e-20, -6.283612422077580e-22,  2.180118561967696e-03, -1.457374514728381e-04,  5.735171341695417e-06, -1.693937776908362e-07,  4.129145810644370e-09,
 -8.729939581730125e-11,  1.649995166659708e-12, -2.844702601139556e-14,  4.538359725638502e-16, -6.771701762870391e-18,  9.527906806627576e-20, -1.272185719478730e-21,
  1.092232954283027e-03, -8.703354973434742e-05,  3.975789235822043e-06, -1.342566651509651e-07,  3.701440659760769e-09, -8.777968640862300e-11,  1.848553679555312e-12,
 -3.531236454935855e-14,  6.212306720684726e-16, -1.017898772152285e-17,  1.566943567409498e-19, -2.281424604682806e-21,  5.194870612130847e-04, -4.867234393988610e-05,
  2.559551347806711e-06, -9.818267749105969e-08,  3.045058766614188e-09, -8.061837913366121e-11,  1.883570981556127e-12, -3.971071569892043e-14,  7.675402840466164e-16,
 -1.376253608439224e-17,  2.310265609398861e-19, -3.656275576853086e-21,  2.353255604908542e-04, -2.561578139932574e-05,  1.538716773885523e-06, -6.664333472067664e-08,
  2.313331662259301e-09, -6.807080468046045e-11,  1.757439123875535e-12, -4.074181247391906e-14,  8.622106477274597e-16, -1.686377100471460e-17,  3.077522754483763e-19,
 -5.278703643218625e-21,  1.019063755518803e-04, -1.275115560866389e-05,  8.685862727741218e-07, -4.223263804352802e-08,  1.632880129885482e-09, -5.317731163620195e-11,
  1.511352148331311e-12, -3.839239010302689e-14,  8.867235836974626e-16, -1.886026361585770e-17,  3.730951459594055e-19, -6.916575920070209e-21,  4.236265534008132e-05,
 -6.035050613585798e-06,  4.630105348617345e-07, -2.513565294770402e-08,  1.077483360790307e-09, -3.867814658808115e-11,  1.205686268276890e-12, -3.344833378377849e-14,
  8.404874366651934e-16, -1.938358049719006e-17,  4.144981636857944e-19, -8.282935366591705e-21,  1.698442742057144e-05, -2.730871288464768e-06,  2.344522582452577e-07,
 -1.413638978656159e-08,  6.688452985564598e-10, -2.635999004603557e-11,  8.980321496463727e-13, -2.711866478284773e-14,  7.391177050135650e-16, -1.842953240695147e-17,
  4.248538775200667e-19, -9.127742903258264e-21,  6.602071473747233e-06, -1.188420529103544e-06,  1.134740090038240e-07, -7.560637594754071e-09,  3.931045416691197e-10,
 -1.694344014035907e-11,  6.286290600480644e-13, -2.059669394307043e-14,  6.070415435484699e-16, -1.631857485617890e-17,  4.044582305624096e-19, -9.318387102503193e-21,
  2.502637691959160e-06, -5.005345430334551e-07,  5.284056504262133e-08, -3.871257290336317e-09,  2.202340052570001e-10, -1.034120718486184e-11,  4.163707395337320e-13,
 -1.475357554724154e-14,  4.687865801261585e-16, -1.354753357586481e-17,  3.600308603483205e-19, -8.872035561767396e-21,  9.310855867246504e-07, -2.054211475169714e-07,
  2.383944637315896e-08, -1.911080059452926e-09,  1.184460323090990e-10, -6.035490935647163e-12,  2.627799054517387e-13, -1.003669500115850e-14,  3.427556559232027e-16,
 -1.061757983708357e-17,  3.017108807930464e-19, -7.931226159898467e-21,  3.423728394367108e-07, -8.275063355089914e-08,  1.049784987163497e-08, -9.163628955260124e-10,
  6.160749455989842e-11, -3.393269696167087e-12,  1.591809593984257e-13, -6.531343012342435e-15,  2.389642922134081e-16, -7.910882233400474e-18,  2.396815511225123e-19,
 -6.702856677013314e-21,  1.253776185453384e-07, -3.297571936474823e-08,  4.547648242029042e-09, -4.301457573198776e-10,  3.123145206101896e-11, -1.851894887539941e-12,
  9.325172867233476e-14, -4.096004389415224e-15,  1.600273227184116e-16, -5.643875692020781e-18,  1.817753427352285e-19, -5.392528581554344e-21,  4.609657565067348e-08,
 -1.310665628288234e-08,  1.954050940451918e-09, -1.992853267963205e-10,  1.555615134638877e-11, -9.889061312443497e-13,  5.324446156374944e-14, -2.494492301678949e-15,
  1.037090430911932e-16, -3.883846964354153e-18,  1.325567369552211e-19, -4.158909594741813e-21,  1.716094047495448e-08, -5.240824350663566e-09,  8.399712934593058e-10,
 -9.190037209081887e-11,  7.676645283875526e-12, -5.209185484058875e-13,  2.986759926418018e-14, -1.486765076240201e-15,  6.553776397060568e-17, -2.597086192206845e-18,
  9.361801223018695e-20, -3.096447393710956e-21,  6.525875327529211e-09, -2.126878246997300e-09,  3.643857637076325e-10, -4.254684881334096e-11,  3.784843085420029e-12,
 -2.729109921768553e-13,  1.659213387663381e-14, -8.740033100011514e-16,  4.069063283764055e-17, -1.699921063920590e-18,  6.448971271523137e-20, -2.240958329305070e-21,
  2.557149449343431e-09, -8.837478529589554e-10,  1.609098248463758e-10, -1.994362061709097e-11,  1.879826717465405e-12, -1.433490498902691e-13,  9.199435000443697e-15,
 -5.105844393579966e-16,  2.500286386920750e-17, -1.096846021729285e-18,  4.362587123041668e-20, -1.586843566090875e-21,  1.041142207109467e-09, -3.791231260057763e-10,
  7.292693288103404e-11, -9.541083153339259e-12,  9.478699601439261e-13, -7.605848307940310e-14,  5.127646754077907e-15, -2.984896868064694e-16,  1.530674743964324e-17,
 -7.021418898842531e-19,  2.916030279410198e-20, -1.105917771145636e-21,  4.436904024917530e-10, -1.691535720140879e-10,  3.416557881756085e-11, -4.690959666768050e-12,
  4.884754729914363e-13, -4.102636387728679e-14,  2.890906060585185e-15, -1.756446288916760e-16,  9.388274724329781e-18, -4.482852042894043e-19,  1.935529932618992e-20,
 -7.621604415049860e-22,  1.989722585509980e-10, -7.891513387331916e-11,  1.663176965471998e-11, -2.382028804101959e-12,  2.584850814393355e-13, -2.259718735172915e-14,
  1.655375277649852e-15, -1.044346407494258e-16,  5.789371160932586e-18, -2.863788004038109e-19,  1.279527696644583e-20, -5.207933619958031e-22,  9.405841284348575e-11,
 -3.856304849581403e-11,  8.425869650566571e-12, -1.250918540112578e-12,  1.406007680106818e-13, -1.271924830135995e-14,  9.632099883427144e-16, -6.275500124604656e-17,
  3.589089028369415e-18, -1.829887784259096e-19,  8.418972856863740e-21, -3.525157303248957e-22,  4.662581723938248e-11, -1.963588072588188e-11,  4.418569312688810e-12,
 -6.755765947812139e-13,  7.815513052254467e-14, -7.271562371847979e-15,  5.658921031167286e-16, -3.785766943741410e-17,  2.221436158965099e-18, -1.161121496580025e-19,
  5.472494707938040e-21, -2.345475092539508e-22,  2.375156372732774e-11, -1.020978639620542e-11,  2.350144142701966e-12, -3.675800324596208e-13,  4.348262790571002e-14,
 -4.134488020221782e-15,  3.286230981711079e-16, -2.243981132497116e-17,  1.343175950017425e-18, -7.157295028795475e-20,  3.436957878820025e-21, -1.499921822168281e-22,
  1.169380496220226e-11, -5.098441850643221e-12,  1.192251824982856e-12, -1.894540440863722e-13,  2.276276592189105e-14, -2.197461635868836e-15,  1.772579020425966e-16,
 -1.227858771376190e-17,  7.452442799801020e-19, -4.025033115551294e-20,  1.958268920113602e-21, -8.654789842694039e-23,  4.348498311808938e-12, -1.910915110698478e-12,
  4.508102804678762e-13, -7.227212603076183e-14,  8.759269712231808e-15, -8.528021978531792e-16,  6.936108241404450e-17, -4.843268273231740e-18,  2.962549409119872e-19,
 -1.612174312622208e-20,  7.901173653266365e-22, -3.516798554725570e-23,  7.783975778645146e-02, -2.537459119569548e-04,  8.654962225718677e-07, -3.059417246066724e-09,
  1.108873111348296e-11, -4.083790390908334e-14,  1.517171113032056e-16, -5.659430139027166e-19,  2.112323089055533e-21, -7.875802349774802e-24,  2.928814388571095e-26,
 -1.086174064911646e-28,  7.246636882747258e-02, -3.144068405280225e-04,  1.637123253576101e-06, -8.741647771644424e-09,  4.572858936029692e-11, -2.329119762324619e-13,
  1.158082037137891e-15, -5.641482046496288e-18,  2.700445287940278e-20, -1.273109487257279e-22,  5.921616881043360e-25, -2.721199723774730e-27,  6.281831772209348e-02,
 -4.082619937113086e-04,  3.077182271331210e-06, -2.173511564770351e-08,  1.442728810196842e-10, -9.134752001389251e-13,  5.571715620009023e-15, -3.295018148689385e-17,
  1.897906571337456e-19, -1.068367001129175e-21,  5.893203332708266e-24, -3.192155877712876e-26,  5.072380748894591e-02, -4.943879680085521e-04,  4.932417373389841e-06,
 -4.358863613047822e-08,  3.544800239784526e-10, -2.710881018414810e-12,  1.974177791236571e-14, -1.380608312970804e-16,  9.328259970827134e-19, -6.117379972655701e-21,
  3.907618138193254e-23, -2.438137643960612e-25,  3.817317129678637e-02, -5.378358492287992e-04,  6.789860473337601e-06, -7.341829001329444e-08,  7.177151957895651e-10,
 -6.507770840575466e-12,  5.558624353933826e-14, -4.519731852718491e-16,  3.524853561284025e-18, -2.651573020438578e-20,  1.932400150002612e-22, -1.369014487088350e-24,
  2.679533478874777e-02, -5.235083920575506e-04,  8.174575130465545e-06, -1.065639588115245e-07,  1.234378033779897e-09, -1.309183821175891e-11,  1.295019975364491e-13,
 -1.209677147022838e-15,  1.076541587560859e-17, -9.188264335350733e-20,  7.559528537014802e-22, -6.019311498622696e-24,  1.756074672888360e-02, -4.583731642652662e-04,
  8.725669903950680e-06, -1.354819283967092e-07,  1.838568952181096e-09, -2.257249300273673e-11,  2.560835561059669e-13, -2.722995075050703e-15,  2.741313919860862e-17,
 -2.632574128341401e-19,  2.425640787917947e-21, -2.154049372361486e-23,  1.075821289534423e-02, -3.635902069414105e-04,  8.340973974233670e-06, -1.526629433146909e-07,
  2.404751767797626e-09, -3.388956806643792e-11,  4.375291355022856e-13, -5.257240736664734e-15,  5.945592156927342e-17, -6.381813961773999e-19,  6.543280186729528e-21,
 -6.440491993164399e-23,  6.170107294453334e-03, -2.630506221252783e-04,  7.197381320023364e-06, -1.538882798145940e-07,  2.791767530707946e-09, -4.484436188743022e-11,
  6.545761710616939e-13, -8.833800500381836e-15,  1.115839678250115e-16, -1.331326948166485e-18,  1.510931560346781e-20, -1.640013442544707e-22,  3.318680305166403e-03,
 -1.746399952694146e-04,  5.644387079889259e-06, -1.398577156272731e-07,  2.902232086668722e-09, -5.281337612640380e-11,  8.667164803236293e-13, -1.306873264735668e-14,
  1.834697543819695e-16, -2.421832020888515e-18,  3.028732432471186e-20, -3.609624638812027e-22,  1.677484315660019e-03, -1.069838046258476e-04,  4.047521283423400e-06,
 -1.153876917688220e-07,  2.722252021702328e-09, -5.581807627939069e-11,  1.024819862025621e-12, -1.718638326011950e-14,  2.670065009632129e-16, -3.883488365026926e-18,
  5.330862304698722e-20, -6.949650473141588e-22,  7.987711911612687e-04, -6.078404681872013e-05,  2.669091325560104e-06, -8.696755648972862e-08,  2.319727272297364e-09,
 -5.333273888403377e-11,  1.090636068326089e-12, -2.025891962545276e-14,  3.469687012120605e-16, -5.540257836785888e-18,  8.318694121093950e-20, -1.182320216306853e-21,
  3.593143994178799e-04, -3.218872071355916e-05,  1.627508541838915e-06, -6.023790756543325e-08,  1.807294849474547e-09, -4.638109714295952e-11,  1.052143882968731e-12,
 -2.156677017406699e-14,  4.057666762828650e-16, -7.089577416669237e-18,  1.160722590625593e-19, -1.793127862197740e-21,  1.531855674146580e-04, -1.596600010150777e-05,
  9.226343922535543e-07, -3.856785739914369e-08,  1.295307741667958e-09, -3.694982139162582e-11,  9.262960796324351e-13, -2.087962955543870e-14,  4.301534166268559e-16,
 -8.198694921498986e-18,  1.459400144563118e-19, -2.443718866097132e-21,  6.212407769456059e-05, -7.455119396384300e-06,  4.889625450094721e-07, -2.295906038980824e-08,
  8.592258262762535e-10, -2.713575433494030e-11,  7.490766086184359e-13, -1.850697198602579e-14,  4.162151731581406e-16, -8.629146042418216e-18,  1.665458315056572e-19,
 -3.014879430243515e-21,  2.406772823372318e-05, -3.294362838826358e-06,  2.436319204385092e-07, -1.278321666794375e-08,  5.307613522389657e-10, -1.848698119077795e-11,
  5.600186972970824e-13, -1.511745121380352e-14,  3.700586063244868e-16, -8.322485163401669e-18,  1.737086210204492e-19, -3.391034448646167e-21,  8.950049083175508e-06,
 -1.385443648791378e-06,  1.148156932978756e-07, -6.698351945118215e-09,  3.072510993479010e-10, -1.175914283120267e-11,  3.895909240117526e-13, -1.145559107529006e-14,
  3.043538095323663e-16, -7.405064236767601e-18,  1.667230077819817e-19, -3.501267686443759e-21,  3.212050373131166e-06, -5.578771837379703e-07,  5.150313483068074e-08,
 -3.324766473651948e-09,  1.677849763977897e-10, -7.030078808069605e-12,  2.538944015708244e-13, -8.107272118268627e-15,  2.331189383788759e-16, -6.119856498956462e-18,
  1.482561259636245e-19, -3.341300769737272e-21,  1.119299356383480e-06, -2.165087454966149e-07,  2.214026483373537e-08, -1.574042385716576e-09,  8.703520684059606e-11,
 -3.977802237844169e-12,  1.560840813507499e-13, -5.395965726111377e-15,  1.674477724958557e-16, -4.730371020804663e-18,  1.229899959996075e-19, -2.967509177392309e-21,
  3.812961140352478e-07, -8.156512097786026e-08,  9.188023877394301e-09, -7.160299573476963e-10,  4.320334041099063e-11, -2.145907608644179e-12,  9.117859038229898e-14,
 -3.402090070467677e-15,  1.136069026402703e-16, -3.444181051886931e-18,  9.585986286828095e-20, -2.470014590666154e-21,  1.279353103977274e-07, -3.006075434530164e-08,
  3.709937437662433e-09, -3.154445437376324e-10,  2.068327156151065e-11, -1.112326967596682e-12,  5.100206602398695e-14, -2.047368490463311e-15,  7.335045458750379e-17,
 -2.379688084893723e-18,  7.070947799566898e-20, -1.940706752907852e-21,  4.262889627589446e-08, -1.092979994094430e-08,  1.469878036726801e-09, -1.357182000074316e-10,
  9.629616632990364e-12, -5.585564027053541e-13,  2.753897837823336e-14, -1.185403162954604e-15,  4.542136919253559e-17, -1.572258610440362e-18,  4.973468001180872e-20,
 -1.450046130221088e-21,  1.423231484601703e-08, -3.956034011524274e-09,  5.765995376548360e-10, -5.753661587941621e-11,  4.398425499947282e-12, -2.740678133764866e-13,
  1.447582635040471e-14, -6.658101472024364e-16,  2.719532645473922e-17, -1.001239680123898e-18,  3.361598393029938e-20, -1.038136133779888e-21,  4.806603225972916e-09,
 -1.439126289389312e-09,  2.260828015865660e-10, -2.426067589153285e-11,  1.989155579786184e-12, -1.325881387863311e-13,  7.472791408113233e-15, -3.659014917032438e-16,
  1.587544940388128e-17, -6.195687343414426e-19,  2.200754832185496e-20, -7.176639631374397e-22,  1.658513839132217e-09, -5.314465112566872e-10,  8.948230418779520e-11,
 -1.027329384552928e-11,  8.991344652241823e-13, -6.382706899788106e-14,  3.822578994434918e-15, -1.984666799291599e-16,  9.112242131703244e-18, -3.756109927729940e-19,
  1.406657884388815e-20, -4.827564056902087e-22,  5.906449742075506e-10, -2.012526227484947e-10,  3.610856203739757e-11, -4.411576717204787e-12,  4.100930261852957e-13,
 -3.085722193170833e-14,  1.954964206511218e-15, -1.071692165669953e-16,  5.185802068657270e-18, -2.248972028608785e-19,  8.846536673911084e-21, -3.183701545494141e-22,
  2.192681443334994e-10, -7.893019659339389e-11,  1.500022670855643e-11, -1.939338442402242e-12,  1.904645932719770e-13, -1.511469770783750e-14,  1.008165819669879e-15,
 -5.808651313592345e-17,  2.949332591210830e-18, -1.340033473672663e-19,  5.514171166508127e-21, -2.072797973941411e-22,  8.562788007125246e-11, -3.235141452426443e-11,
  6.471892726492336e-12, -8.802300801460692e-13,  9.082187143032188e-14, -7.560651956582286e-15,  5.282205761751183e-16, -3.182985421834534e-17,  1.687844443611257e-18,
 -7.997805445652820e-20,  3.427705846524484e-21, -1.340159167035637e-22,  3.543166391438118e-11, -1.395782227361179e-11,  2.920339021177919e-12, -4.152538620034240e-13,
  4.474656770753809e-14, -3.885395583091722e-15,  2.827712854313445e-16, -1.772724301405171e-17,  9.767478770370011e-19, -4.803296436524487e-20,  2.133952648556517e-21,
 -8.638297534371769e-23,  1.559169611096013e-11, -6.361906329048179e-12,  1.382836741942484e-12, -2.042404935891968e-13,  2.284094831854770e-14, -2.056220400459391e-15,
  1.549821651899706e-16, -1.005152171218956e-17,  5.723462011764235e-19, -2.905736015781545e-20,  1.331408800248303e-21, -5.552860601306992e-23,  7.272263109960825e-12,
 -3.053071472361184e-12,  6.846685116008961e-13, -1.043256415986857e-13,  1.202891369566083e-14, -1.115557859093275e-15,  8.654434443754082e-17, -5.772246282051374e-18,
  3.377186197679941e-19, -1.760240201014582e-20,  8.273592137802063e-22, -3.536689782778474e-23,  3.529265159566446e-12, -1.514331361360329e-12,  3.478783309458751e-13,
 -5.430173322195208e-14,  6.410985552866054e-15, -6.084174978596242e-16,  4.826966569273024e-17, -3.290160958280559e-18,  1.965973539614526e-19, -1.045839154586638e-20,
  5.014007825244157e-22, -2.184735734890506e-23,  1.678546435841799e-12, -7.311877314036370e-13,  1.708161263826799e-13, -2.711641934720239e-14,  3.254831798036107e-15,
 -3.139136630445182e-16,  2.529829210445923e-17, -1.750822773697082e-18,  1.061724842987081e-19, -5.729457194388872e-21,  2.785209477265609e-22, -1.229971491009265e-23,
  6.120818683790649e-13, -2.688757571372502e-13,  6.340502194774524e-14, -1.016056446009848e-14,  1.230930879705606e-15, -1.197941911295931e-16,  9.739314748219494e-18,
 -6.797977822507721e-19,  4.156608531298590e-20, -2.261108604054141e-21,  1.107746720608241e-22, -4.928783278139617e-24,  7.683839374029484e-02, -2.469658388837968e-04,
  8.298214072447912e-07, -2.888339027399032e-09,  1.030713997534821e-11, -3.737946605247529e-14,  1.367759633121896e-16, -5.026680523877297e-19,  1.848779557059556e-21,
 -6.794453768162317e-24,  2.490695436788750e-26, -9.107763412681125e-29,  7.123428817725200e-02, -3.017173598907670e-04,  1.536464452096843e-06, -8.045798121882365e-09,
  4.133598190889528e-11, -2.069199742490501e-13,  1.011560813620050e-15, -4.846323322050916e-18,  2.282027731706493e-20, -1.058542516228302e-22,  4.845273622087996e-25,
 -2.191535513001179e-27,  6.123290642260269e-02, -3.846499216555852e-04,  2.829630893091937e-06, -1.956594184462599e-08,  1.272692594676506e-10, -7.901729802769329e-13,
  4.728663878830340e-15, -2.744937434042814e-17,  1.552547681559912e-19, -8.584836220683481e-22,  4.652980702895106e-24, -2.477106058170557e-26,  4.882199244927480e-02,
 -4.569284245635554e-04,  4.441674579292295e-06, -3.832620958864121e-08,  3.047039151617177e-10, -2.280286889493880e-12,  1.626290854751512e-14, -1.114521313872660e-16,
  7.383297698230899e-19, -4.749402031944748e-21,  2.976979974565976e-23, -1.823307101444180e-25,  3.612514900670011e-02, -4.868552661829280e-04,  5.973670091168606e-06,
 -6.290769001966610e-08,  5.999377171097589e-10, -5.313649575463984e-12,  4.437661641138673e-14, -3.530694093752284e-16,  2.696037016880765e-18, -1.986831467577248e-20,
  1.419160098531214e-22, -9.858256594818707e-25,  2.482444464242300e-02, -4.629099671244750e-04,  7.006184457542960e-06, -8.875058674225024e-08,  1.001067136063780e-09,
 -1.035417392163735e-11,  9.999546447784881e-14, -9.127535032622332e-16,  7.943635824882798e-18, -6.634410998629891e-20,  5.344209730359562e-22, -4.168384404445652e-24,
  1.585723152311714e-02, -3.946031093181871e-04,  7.262506464586803e-06, -1.093667365291964e-07,  1.442880827486723e-09, -1.725041876582798e-11,  1.908195221367987e-13,
 -1.980393377928860e-15,  1.947575998851593e-17, -1.828354671775954e-19,  1.647868996682992e-21, -1.432220089505355e-23,  9.426565161452884e-03, -3.035841830043182e-04,
  6.719227832752732e-06, -1.190851440572313e-07,  1.821071167459072e-09, -2.495985985587921e-11,  3.138392139870809e-13, -3.676795730436421e-15,  4.058112950188729e-17,
 -4.254389491760594e-19,  4.263385220414652e-21, -4.104048718636037e-23,  5.222356077913614e-03, -2.121618559789436e-04,  5.591685826172521e-06, -1.156188972770836e-07,
  2.033855005732006e-09, -3.173964268076545e-11,  4.507706778013423e-13, -5.926103985437761e-15,  7.299427507025800e-17, -8.499888075658554e-19,  9.421998596722002e-21,
 -9.995582880840866e-23,  2.700818500331076e-03, -1.354821679157778e-04,  4.213199647046419e-06, -1.008553779806774e-07,  2.027451601696041e-09, -3.581275802129831e-11,
  5.713822837821246e-13, -8.386757338509407e-15,  1.147367450822725e-16, -1.477272731804528e-18,  1.803463290178582e-20, -2.099675888225753e-22,  1.306483482630712e-03,
 -7.947869930022397e-05,  2.891285508525045e-06, -7.957395133170733e-08,  1.817359364607343e-09, -3.614735224348652e-11,  6.448230989787751e-13, -1.052073918617544e-14,
  1.591990048004218e-16, -2.257453159712842e-18,  3.023726895016406e-20, -3.849361998049875e-22,  5.925253992905928e-04, -4.304749240470503e-05,  1.817104337087655e-06,
 -5.713541460195167e-08,  1.474656203918936e-09, -3.287345341665084e-11,  6.528939036278200e-13, -1.179456866013331e-14,  1.966810514741053e-16, -3.060874391484468e-18,
  4.483313590214798e-20, -6.220922241780140e-22,  2.526327277200763e-04, -2.163099497527168e-05,  1.051483230514672e-06, -3.755182138999931e-08,  1.089961694173497e-09,
 -2.711606558317944e-11,  5.972820315334546e-13, -1.190437253296663e-14,  2.180356481696706e-16, -3.712346091524821e-18,  5.928290238960163e-20, -8.940131426753094e-22,
  1.015847153661670e-04, -1.013305878937343e-05,  5.632127880003278e-07, -2.272093965377728e-08,  7.382803076302518e-10, -2.041593931587178e-11,  4.969618363930692e-13,
 -1.089205746509221e-14,  2.184440641336510e-16, -4.057363538927367e-18,  7.044633136472416e-20, -1.151560032981391e-21,  3.866471990791385e-05, -4.447420939381963e-06,
  2.807705812968134e-07, -1.272875181801400e-08,  4.610243146637546e-10, -1.411800093696692e-11,  3.784981277443200e-13, -9.094296561215409e-15,  1.991411477143531e-16,
 -4.024141053500124e-18,  7.577154423101634e-20, -1.339306548472384e-21,  1.398883636682191e-05, -1.838518274973592e-06,  1.310083552787449e-07, -6.641657344778854e-09,
  2.670345940615533e-10, -9.023120287400646e-12,  2.655728504928838e-13, -6.974708124804327e-15,  1.662987871682810e-16, -3.646624905550348e-18,  7.428166026433689e-20,
 -1.416399136508865e-21,  4.834251791679247e-06, -7.199107239775587e-07,  5.755978160242237e-08, -3.247783315059574e-09,  1.443776247184217e-10, -5.364312163364064e-12,
  1.727894050352321e-13, -4.945971321890504e-15,  1.280648271949628e-16, -3.039737781997388e-18,  6.682753077456226e-20, -1.371530443525043e-21,  1.604557018415602e-06,
 -2.686676630644428e-07,  2.396654080651475e-08, -1.498211840811885e-09,  7.335235621594378e-11, -2.986507032308507e-12,  1.049545957182997e-13, -3.265117077923686e-15,
  9.156932634427230e-17, -2.346862087634589e-18,  5.555445968862111e-20, -1.224453647280808e-21,  5.147316652883031e-07, -9.620789555858371e-08,  9.523140502217644e-09,
 -6.565957508106333e-10,  3.526875805112986e-11, -1.568160443726747e-12,  5.994057126384314e-14, -2.020911544355647e-15,  6.122422210137276e-17, -1.690099994457777e-18,
  4.297660529142111e-20, -1.014960799029255e-21,  1.607229840961712e-07, -3.330355665427861e-08,  3.638573940680217e-09, -2.754657122484955e-10,  1.617077581681287e-11,
 -7.824973288107039e-13,  3.242967349886012e-14, -1.181518695124833e-15,  3.856272556937106e-17, -1.143675868480162e-18,  3.116460776789455e-20, -7.868059831200700e-22,
  4.923662002978575e-08, -1.123579115746926e-08,  1.347845351110858e-09, -1.115473223497663e-10,  7.128359867548071e-12, -3.740756174540375e-13,  1.675501616525090e-14,
 -6.576784388185692e-16,  2.306077035054932e-17, -7.328329915171805e-19,  2.134563775620721e-20, -5.747190410158669e-22,  1.492914148231803e-08, -3.727687654378411e-09,
  4.884291396808405e-10, -4.398862075170820e-11,  3.047815554807826e-12, -1.728172796259744e-13,  8.337469385017301e-15, -3.514874213331380e-16,  1.320143136443261e-17,
 -4.482643536943329e-19,  1.391961145310193e-20, -3.986610998767773e-22,  4.523961539117957e-09, -1.228095302230095e-09,  1.748346438211527e-10, -1.705580139254018e-11,
  1.275915911229213e-12, -7.787248908286177e-14,  4.032252567497202e-15, -1.819629254444379e-16,  7.297588383000336e-18, -2.639838020914396e-19,  8.714054151085043e-21,
 -2.647505010656335e-22,  1.384501811063357e-09, -4.060127819696132e-10,  6.246376417248216e-11, -6.568868694040212e-12,  5.282467381334544e-13, -3.456208118029271e-14,
  1.913521990662263e-15, -9.210383149472051e-17,  3.930881052331755e-18, -1.509984603902777e-19,  5.282331293170181e-21, -1.697432626362382e-22,  4.327179720754374e-10,
 -1.362048244553857e-10,  2.251963684896545e-11, -2.540133266937430e-12,  2.185662571129784e-13, -1.526393570240233e-14,  8.999145040746660e-16, -4.602358935461384e-17,
  2.082647212986210e-18, -8.465663584963104e-20,  3.127982797490609e-21, -1.059680986316171e-22,  1.397287996988167e-10, -4.690201394284649e-11,  8.285800399320864e-12,
 -9.971461695101819e-13,  9.135211206113641e-14, -6.778029354874915e-15,  4.236713057951689e-16, -2.292591804722338e-17,  1.095595845575186e-18, -4.694573732023857e-20,
  1.825375064323031e-21, -6.496300068449121e-23,  4.716062228973853e-11, -1.677019290718039e-11,  3.146566475215638e-12, -4.017445387257053e-13,  3.898038174679327e-14,
 -3.057436362997140e-15,  2.016530263259356e-16, -1.149330389152409e-17,  5.775158790297201e-19, -2.597716230894214e-20,  1.058642129649675e-21, -3.942541865264557e-23,
  1.682117426727508e-11, -6.294430554258942e-12,  1.246429083954802e-12, -1.678328435382120e-13,  1.714937492288753e-14, -1.414297617565486e-15,  9.791919913663423e-17,
 -5.849267674319709e-18,  3.075752124042700e-19, -1.445684384715181e-20,  6.147740289313396e-22, -2.385638685218080e-23,  6.399651874732290e-12, -2.502881717243877e-12,
  5.196210065875679e-13, -7.332273928073246e-14,  7.842426103359951e-15, -6.760819080605749e-16,  4.886326305031984e-17, -3.042840357437082e-18,  1.665771452334154e-19,
 -8.140804298523134e-21,  3.595037503551932e-22, -1.446888587939886e-23,  2.612168192359629e-12, -1.060396673956372e-12,  2.292122931408713e-13, -3.366781217421306e-14,
  3.745035838875335e-15, -3.353934977488620e-16,  2.515281830223361e-17, -1.623426909185667e-18,  9.200886220688171e-20, -4.650163614626163e-21,  2.121451921186498e-22,
 -8.810864407442409e-24,  1.142523418393447e-12, -4.780554118495632e-13,  1.068142708320539e-13, -1.621643072742782e-14,  1.863134344188631e-15, -1.721909886716955e-16,
  1.331394700591149e-17, -8.851399067766384e-19,  5.162606480237704e-20, -2.682744860322005e-21,  1.257302372477667e-22, -5.359534532389515e-24,  5.267137813612030e-13,
 -2.255625989339390e-13,  5.170601079448843e-14, -8.053709090682545e-15,  9.488464182021169e-16, -8.986439329588976e-17,  7.115454693494398e-18, -4.840783486741910e-19,
  2.887178068933586e-20, -1.533150029518255e-21,  7.337602845401341e-23, -3.191862740607400e-24,  2.414703957997995e-13, -1.050866459843126e-13,  2.452385003107176e-14,
 -3.888943712223550e-15,  4.663110264536827e-16, -4.492793826558417e-17,  3.617169824138444e-18, -2.500943020529844e-19,  1.515199636409164e-20, -8.169203061551716e-22,
  3.967748366306761e-23, -1.750708055477406e-24,  8.623392682588094e-14, -3.786624608044120e-14,  8.925547890014642e-15, -1.429674763301206e-15,  1.731263088331796e-16,
 -1.684140501881622e-17,  1.368635495176190e-18, -9.549042720742100e-20,  5.836383282210373e-21, -3.173617238503018e-22,  1.554196145466817e-23, -6.912601014163629e-25,
  7.586359189797406e-02, -2.404631600383822e-04,  7.961267188556594e-07, -2.729231814459803e-09,  9.591270449691181e-12, -3.425927353693685e-14,  1.234940663220466e-16,
 -4.472359971293854e-19,  1.621187525511878e-21, -5.873851539504099e-24,  2.122884159534328e-26, -7.655845698568238e-29,  7.005140615713773e-02, -2.898009053683608e-04,
  1.443750711962825e-06, -7.416255228137952e-09,  3.742977755370265e-11, -1.841917531598149e-13,  8.855399769503672e-16, -4.173486587133985e-18,  1.933634906873296e-20,
 -8.827087278614393e-23,  3.977025237141990e-25, -1.770895794051613e-27,  5.973814115550843e-02, -3.629185847400849e-04,  2.606555209102120e-06, -1.765014676359008e-08,
  1.125412087458374e-10, -6.853739588950885e-13,  4.025233690284727e-15, -2.294181440788351e-17,  1.274526466447911e-19, -6.924474998912808e-22,  3.688592674987657e-24,
 -1.930448723388893e-26,  4.706254535632819e-02, -4.231551398606404e-04,  4.009572557539925e-06, -3.379560095268083e-08,  2.627616582100899e-10, -1.924905339625207e-12,
  1.344886882542451e-14, -9.034622577162179e-17,  5.869844362996514e-19, -3.704732901941920e-21,  2.279282403079376e-23, -1.370661176199978e-25,  3.426874586057031e-02,
 -4.419300083075260e-04,  5.273043490336769e-06, -5.410419729289778e-08,  5.035620673034612e-10, -4.358116964229796e-12,  3.559831622235650e-14, -2.772243003102068e-16,
  2.073305505852269e-18, -1.497250483917024e-20,  1.048480016559613e-22, -7.143329608735388e-25,  2.307852335760798e-02, -4.108631616849905e-04,  6.030845930359429e-06,
 -7.426798582087031e-08,  8.160520399088136e-10, -8.234311544761311e-12,  7.766552156000053e-14, -6.929793570954075e-16,  5.899593229082054e-18, -4.822927889054683e-20,
  3.804798006319124e-22, -2.907789326418572e-24,  1.438722874182153e-02, -3.413848900963433e-04,  6.077994305611715e-06, -8.880954161748099e-08,  1.139517323288210e-09,
 -1.327139381953053e-11,  1.431881719648504e-13, -1.450898544399116e-15,  1.394252084500497e-17, -1.279897748995368e-19,  1.128682579706170e-21, -9.603498813994191e-24,
  8.311338025046976e-03, -2.550865596944984e-04,  5.449791426536206e-06, -9.356487000890210e-08,  1.389558756016362e-09, -1.852943766413173e-11,  2.269824805011914e-13,
 -2.593573389142112e-15,  2.794445664367717e-17, -2.862143792998861e-19,  2.804060723494437e-21, -2.640505164737971e-23,  4.455110475780047e-03, -1.724695551941059e-04,
  4.380321570517958e-06, -8.761976099672523e-08,  1.495059675209243e-09, -2.267424167948990e-11,  3.134137507596591e-13, -4.014954553789701e-15,  4.823711936275490e-17,
 -5.483487901235238e-19,  5.938276410507732e-21, -6.158664887942826e-23,  2.219348435100143e-03, -1.061161248103282e-04,  3.176146094778084e-06, -7.347407252115671e-08,
  1.431259484449078e-09, -2.454722139879300e-11,  3.808570679766749e-13, -5.443129933294591e-15,  7.258336283518388e-17, -9.117394324963664e-19,  1.086772737158229e-20,
 -1.236272289164077e-22,  1.029413381645522e-03, -5.972358247871360e-05,  2.089480393321145e-06, -5.552961490865401e-08,  1.227993234291565e-09, -2.369840170884545e-11,
  4.108363915208163e-13, -6.522784396698709e-15,  9.615433541678606e-17, -1.329553524679575e-18,  1.738016186548975e-20, -2.160986536797070e-22,  4.455735420613833e-04,
 -3.089699713032617e-05,  1.253829084562470e-06, -3.804997540574987e-08,  9.504162456952551e-10, -2.054642678298466e-11,  3.963821854473395e-13, -6.965035189626120e-15,
  1.131029051594015e-16, -1.715774302473821e-18,  2.451877511576932e-20, -3.321872915568949e-22,  1.804484965955453e-04, -1.476181330362740e-05,  6.898453485384363e-07,
 -2.377272879562950e-08,  6.675935706553822e-10, -1.610159719064993e-11,  3.444136041919355e-13, -6.675198286045461e-15,  1.190291381663290e-16, -1.975093409609123e-18,
  3.076632671884710e-20, -4.529529778354533e-22,  6.858441766462033e-05, -6.544433867290447e-06,  3.498085337835466e-07, -1.361800337296648e-08,  4.281023823314730e-10,
 -1.147641558552980e-11,  2.712583240525753e-13, -5.780869093368897e-15,  1.128659981520124e-16, -2.042954736741371e-18,  3.459925097621654e-20, -5.521453462795726e-22,
  2.455229272980683e-05, -2.705473088267833e-06,  1.643560495334369e-07, -7.192833217517596e-09,  2.520993906823923e-10, -7.485121404035226e-12,  1.948797068157995e-13,
 -4.553487333057860e-15,  9.707872697324055e-17, -1.911959637502468e-18,  3.512040000989109e-20, -6.061101786058475e-22,  8.313068817545361e-06, -1.048373339504421e-06,
  7.195190109294418e-08, -3.523450284415204e-09,  1.371500663974732e-10, -4.495000959697152e-12,  1.285228050571842e-13, -3.283441516248108e-15,  7.624454929531043e-17,
 -1.629967786079779e-18,  3.239982507788084e-20, -6.033817184996998e-22,  2.675019356886133e-06, -3.829491703949089e-07,  2.952495159562498e-08, -1.610602681360873e-09,
  6.936640574654512e-11, -2.501357097478205e-12,  7.831459644842630e-14, -2.181758816614782e-15,  5.504435958329006e-17, -1.274357402819096e-18,  2.735162041116136e-20,
 -5.484992450087870e-22,  8.226263803100020e-07, -1.326811712170195e-07,  1.142955375613539e-08, -6.915488152609134e-10,  3.283446237474929e-11, -1.298557013570215e-12,
  4.439142130448455e-14, -1.345051580219331e-15,  3.678024252835473e-17, -9.200448086157769e-19,  2.127594449822878e-20, -4.584854894820672e-22,  2.433095770805091e-07,
 -4.390357940640004e-08,  4.203650602922054e-09, -2.809134704093836e-10,  1.465057695499918e-11, -6.334424384695556e-13,  2.357599865124686e-14, -7.748963178654825e-16,
  2.291011911979796e-17, -6.177894415723208e-19,  1.535900893846910e-20, -3.549268596259370e-22,  6.972040785779290e-08, -1.398064080480996e-08,  1.480305191637922e-09,
 -1.087982536127198e-10,  6.210149628098030e-12, -2.926014043144134e-13,  1.182216175241558e-14, -4.203760844048915e-16,  1.340428387723049e-17, -3.887347019281220e-19,
  1.036690131517976e-20, -2.563506634674234e-22,  1.951609631335941e-08, -4.320954766116877e-09,  5.034066769599481e-10, -4.052072689266645e-11,  2.522030107146203e-12,
 -1.290653121722735e-13,  5.643879723963033e-15, -2.165088993848222e-16,  7.426284353989402e-18, -2.310523398405168e-19,  6.594235478134666e-21, -1.740952383870629e-22,
  5.386369235281790e-09, -1.308438455081706e-09,  1.668869537639178e-10, -1.464862629829697e-11,  9.903911238911505e-13, -5.485977259151191e-14,  2.588187089098436e-15,
 -1.068005498455686e-16,  3.929715277493774e-18, -1.308263652702465e-19,  3.985915555895806e-21, -1.120858706047277e-22,  1.481044051212609e-09, -3.922536031398926e-10,
  5.449395221432149e-11, -5.192873502471472e-12,  3.798596066029058e-13, -2.269227870830117e-14,  1.151149103205829e-15, -5.093581060321228e-17,  2.004542284722222e-18,
 -7.120706579475086e-20,  2.309768580540094e-21, -6.900339216039058e-23,  4.103521156136827e-10, -1.177492600534853e-10,  1.772445613452267e-11, -1.825154040309253e-12,
  1.438430728622692e-13, -9.231320382929785e-15,  5.017141420907418e-16, -2.372376278497728e-17,  9.953613691154045e-19, -3.761232466354056e-20,  1.295130452675499e-21,
 -4.098903887244982e-23,  1.159884114420980e-10, -3.582972725705672e-11,  5.811971875329218e-12, -6.435564275103751e-13,  5.439926607238023e-14, -3.734802697534455e-15,
  2.166163419294770e-16, -1.090535748244920e-17,  4.860804082932325e-19, -1.947304006936065e-20,  7.094958570082419e-22, -2.371385276667273e-23,  3.388454716183928e-11,
 -1.119509283103673e-11,  1.945763168087975e-12, -2.304732534228853e-13,  2.079392040581177e-14, -1.520316850980020e-15,  9.369614301778578e-17, -5.001711298209643e-18,
  2.359206175244877e-19, -9.982680606060214e-21,  3.834763807378420e-22, -1.348921096708501e-23,  1.036841889641197e-11, -3.639462591683251e-12,  6.736922079483834e-13,
 -8.488454926870879e-14,  8.131542018040174e-15, -6.299963970082386e-16,  4.106215456851446e-17, -2.313838051591155e-18,  1.149975500990364e-19, -5.118339035249062e-21,
  2.064743864409137e-22, -7.614476776276265e-24,  3.366568445681500e-12, -1.246917080595788e-12,  2.442578619681152e-13, -3.254170087835190e-14,  3.291084561878316e-15,
 -2.687310413165116e-16,  1.842849803778638e-17, -1.090743765072633e-18,  5.684856505239220e-20, -2.649290568325759e-21,  1.117361771125387e-22, -4.301704427793583e-24,
  1.173369516515069e-12, -4.553665856689512e-13,  9.375990497263464e-14, -1.312281030359103e-14,  1.392514538559349e-15, -1.191315619864441e-16,  8.546868147028377e-18,
 -5.284659840400584e-19,  2.873286013440002e-20, -1.394967002603242e-21,  6.121193085014570e-23, -2.448546237187154e-24,  4.425960584680945e-13, -1.786854836388791e-13,
  3.839533477077297e-14, -5.606599731613329e-15,  6.200888380825336e-16, -5.522642826159075e-17,  4.119616928343780e-18, -2.645228560225361e-19,  1.491764936407235e-20,
 -7.503368175183991e-22,  3.407315761329339e-23, -1.408849174316017e-24,  1.808933609087102e-13, -7.541806009896486e-14,  1.678498405271224e-14, -2.538349039352462e-15,
  2.905273076326057e-16, -2.675169767666318e-17,  2.061102384866024e-18, -1.365557162244428e-19,  7.938241623687244e-21, -4.111898267485871e-22,  1.921139461163204e-23,
 -8.164928392660815e-25,  7.897569012789076e-14, -3.375049764093001e-14,  7.718895159366210e-15, -1.199535635432070e-15,  1.410063644913417e-16, -1.332552879803979e-17,
  1.052891430941194e-18, -7.148434174313419e-20,  4.255129541113864e-21, -2.255259747020683e-22,  1.077374168840301e-23, -4.678276205071618e-25,  3.481849279680933e-14,
 -1.513748057536840e-14,  3.528621629938150e-15, -5.589296582029484e-16,  6.694519972876192e-17, -6.443041137846076e-18,  5.181880321367804e-19, -3.579150258905384e-20,
  2.166292360011739e-21, -1.166839362545919e-22,  5.662032566229313e-24, -2.496043868000141e-25,  1.216088783519059e-14, -5.337804020440052e-15,  1.257610699945486e-15,
 -2.013479153026360e-16,  2.437100957390970e-17, -2.369696813606115e-18,  1.924909216802964e-19, -1.342438605325275e-20,  8.201527182981236e-22, -4.457854983387628e-23,
  2.182236136174193e-24, -9.702114554429645e-26,  7.491427347938925e-02, -2.342225916376410e-04,  7.642745981787549e-07, -2.581096089432886e-09,  8.934738712077175e-12,
 -3.144001471357908e-14,  1.116670925134963e-16, -3.985838118299296e-19,  1.424235881537549e-21, -5.088359921940997e-24,  1.813344800239383e-26, -6.450903253179020e-29,
  6.891475292478856e-02, -2.785969716855583e-04,  1.358230976221651e-06, -6.845733233855937e-09,  3.394935590308029e-11, -1.642739950969812e-13,  7.768883530610456e-16,
 -3.602643241017297e-18,  1.642712361002895e-20, -7.381697469861267e-23,  3.274318961689870e-25, -1.435662659592301e-27,  5.832687217274855e-02, -3.428837476214204e-04,
  2.405121482326309e-06, -1.595410875216484e-08,  9.975004129008188e-11, -5.960379863319270e-13,  3.436407941160282e-15, -1.923528459116732e-17,  1.049877481929140e-19,
 -5.605758107893805e-22,  2.935530330377358e-24, -1.510669411854944e-26,  4.543160667359850e-02, -3.926320931126466e-04,  3.628034574310246e-06, -2.988268537860702e-08,
  2.272968433211964e-10, -1.630483507171768e-12,  1.116328291755709e-14, -7.353183712957965e-17,  4.686692330357706e-19, -2.903045610896430e-21,  1.753520090316579e-23,
 -1.035615688440358e-25,  3.258146760291499e-02, -4.022120282976760e-04,  4.669402191543656e-06, -4.670059312610113e-08,  4.243513123695160e-10, -3.589878225035237e-12,
  2.868927899959285e-14, -2.187509480333987e-16,  1.602781974905514e-18, -1.134546850241569e-20,  7.791114472109731e-23, -5.207434345997859e-25,  2.152621753194059e-02,
 -3.659711808404484e-04,  5.212847365181112e-06, -6.243360011052997e-08,  6.685376641844288e-10, -6.583352321485798e-12,  6.066367746854340e-14, -5.292682572295646e-16,
  4.409027840797071e-18, -3.529071249808976e-20,  2.727337648669018e-22, -2.042821632224881e-24,  1.311259999260591e-02, -2.967328694374333e-04,  5.113483505779930e-06,
 -7.252692720876176e-08,  9.054075336116384e-10, -1.027592867143406e-11,  1.081742260609590e-13, -1.070510712838969e-15,  1.005507548612384e-17, -9.028375216254581e-20,
  7.792146991445618e-22, -6.492275110883508e-24,  7.371576257752354e-03, -2.156277394113588e-04,  4.449076632880288e-06, -7.402364239962717e-08,  1.068048046405751e-09,
 -1.386105107382395e-11,  1.654746549112836e-13, -1.844647600656015e-15,  1.940785529800415e-17, -1.942558118144921e-19,  1.861062076112812e-21, -1.714782529904494e-23,
  3.829190089679031e-03, -1.412580623148471e-04,  3.458671665687503e-06, -6.695329606940329e-08,  1.108517850034913e-09, -1.634363450187178e-11,  2.199361031407617e-13,
 -2.746194989832452e-15,  3.219064508213220e-17, -3.573275211233028e-19,  3.781361090277711e-21, -3.834728122885205e-23,  1.840622427043791e-03, -8.387873345962427e-05,
  2.417134697675588e-06, -5.405229609898846e-08,  1.020613607303344e-09, -1.700065438356118e-11,  2.565741471575822e-13, -3.571324732095223e-15,  4.643034820129759e-17,
 -5.691276482558063e-19,  6.625098929651936e-21, -7.365233233969449e-23,  8.201585817320168e-04, -4.537197237281059e-05,  1.526951033070910e-06, -3.919410096361623e-08,
  8.394576123377295e-10, -1.572214245041586e-11,  2.649386928342221e-13, -4.094125098885648e-15,  5.880671220072501e-17, -7.930594970477423e-19,  1.011944445686487e-20,
 -1.229082870330450e-22,  3.394826671794590e-04, -2.246242413520975e-05,  8.764180833350180e-07, -2.567348017819101e-08,  6.207167559257391e-10, -1.301547858910596e-11,
  2.439456794323802e-13, -4.170073768833069e-15,  6.595266700940673e-17, -9.754088052380071e-19,  1.360100684166445e-20, -1.799454362584518e-22,  1.308594550804156e-04,
 -1.022439933631534e-05,  4.593326589708493e-07, -1.527494126563387e-08,  4.150552437103764e-10, -9.706210693274739e-12,  2.016352872164763e-13, -3.800611187876998e-15,
  6.598650860191679e-17, -1.067198140593024e-18,  1.621734071587462e-20, -2.331077937108079e-22,  4.711263704089074e-05, -4.298578128084293e-06,  2.209272602970469e-07,
 -8.299347229615908e-09,  2.524172568132158e-10, -6.559930060264237e-12,  1.505617132460379e-13, -3.120074091423557e-15,  5.930507861075330e-17, -1.046155043189789e-18,
  1.728274961972785e-20, -2.692598555835172e-22,  1.589709269558367e-05, -1.677228146103049e-06,  9.802173899996731e-08, -4.140501525657314e-09,  1.404166551335387e-10,
 -4.042002198323024e-12,  1.021932518886268e-13, -2.321970934921770e-15,  4.819610583396467e-17, -9.251183009854118e-19,  1.657731683423159e-20, -2.793267540541141e-22,
  5.047885108510231e-06, -6.104596951429950e-07,  4.033825968434279e-08, -1.907569599321497e-09,  7.187231309378091e-11, -2.284404479337133e-12,  6.344397258618565e-14,
 -1.576508842079486e-15,  3.564897473587678e-17, -7.429216150356949e-19,  1.440917527184862e-20, -2.620560830900076e-22,  1.515565457050307e-06, -2.084196626719978e-07,
  1.548761703257560e-08, -8.165015257854389e-10,  3.405947246766605e-11, -1.191704078990648e-12,  3.625802535985603e-14, -9.829051614708816e-16,  2.415827671700563e-17,
 -5.454334168767588e-19,  1.142706696334182e-20, -2.238730002978333e-22,  4.326293574268740e-07, -6.716089192020045e-08,  5.583558572331988e-09, -3.268334110493186e-10,
  1.504277850439713e-11, -5.776847659042319e-13,  1.920412900213734e-14, -5.665705761628322e-16,  1.510217673150939e-17, -3.686233775100108e-19,  8.325465403836557e-21,
 -1.753717880020007e-22,  1.181738600822909e-07, -2.056773395185244e-08,  1.903588222027645e-09, -1.232253454336705e-10,  6.236752225527379e-12, -2.621034623151311e-13,
  9.495009568742644e-15, -3.041280204282282e-16,  8.772004659656519e-18, -2.309910932553801e-19,  5.612895807846421e-21, -1.268798296072569e-22,  3.111795442555589e-08,
 -6.032778411821667e-09,  6.185728593847273e-10, -4.410723395049839e-11,  2.446550498213739e-12, -1.121819236207143e-13,  4.416671238933279e-15, -1.532092913579168e-16,
  4.770755001223359e-18, -1.352381104431620e-19,  3.528318806403848e-21, -8.542318583712014e-23,  7.966766191445053e-09, -1.709633663885638e-09,  1.932770599643034e-10,
 -1.512022751788769e-11,  9.159829029177223e-13, -4.568510943629383e-14,  1.949324243106019e-15, -7.304423106535902e-17,  2.449657252605049e-18, -7.458490606002423e-20,
  2.084797334746145e-21, -5.394849110864145e-23,  2.002390895113827e-09, -4.727248558595593e-10,  5.864042844748200e-11, -5.012585961969521e-12,  3.304602339513259e-13,
 -1.787007026732709e-14,  8.239367232654642e-16, -3.326000163916737e-17,  1.198253926165800e-18, -3.909120040368787e-20,  1.167985323684855e-21, -3.223303099596574e-23,
  4.995409897292442e-10, -1.289446237163574e-10,  1.746505984232159e-11, -1.624357191140841e-12,  1.160992041791979e-13, -6.783726916234204e-15,  3.369170772062454e-16,
 -1.460830312242427e-17,  5.638075017350747e-19, -1.965645528443940e-20,  6.262114272720463e-22, -1.838597146993322e-23,  1.252163962519138e-10, -3.512161922954342e-11,
  5.167887043322447e-12, -5.206360279825121e-13,  4.018134192176186e-14, -2.527502802013005e-15,  1.347545026701996e-16, -6.255625488901793e-18,  2.578607063796459e-19,
 -9.579588141200671e-21,  3.245022920945296e-22, -1.010944723665370e-23,  3.196367502710806e-11, -9.680659671823566e-12,  1.539230005905414e-12, -1.671744662184956e-13,
  1.387125158794475e-14, -9.355393540079486e-16,  5.334251879975357e-17, -2.641843604317001e-18,  1.159146540188135e-19, -4.573908661874798e-21,  1.642371405359307e-22,
 -5.412913001032339e-24,  8.430228991535157e-12, -2.739034732591191e-12,  4.679604112289976e-13, -5.451278599951555e-14,  4.839981311834420e-15, -3.484548075995596e-16,
  2.115948470535180e-17, -1.113590258960161e-18,  5.181246817038835e-20, -2.163722176507047e-21,  8.207110808100631e-23, -2.851968565678822e-24,  2.332230610839611e-12,
 -8.074558871558088e-13,  1.473442442104068e-13, -1.830780770234300e-14,  1.730326515578291e-15, -1.323312644760743e-16,  8.518295662706768e-18, -4.742843538102549e-19,
  2.330167963123338e-20, -1.025670839007330e-21,  4.093577213589881e-23, -1.494210535684989e-24,  6.870778449009944e-13, -2.517188947866505e-13,  4.874574690594054e-14,
 -6.421452723881145e-15,  6.423855749105333e-16, -5.190513792310873e-17,  3.523623048056479e-18, -2.065355785122434e-19,  1.066406484891439e-20, -4.925098855758595e-22,
  2.059229626281779e-23, -7.861790591878129e-25,  2.185708815391494e-13, -8.412585172882787e-14,  1.716953564105646e-14, -2.382306788662400e-15,  2.506765415876748e-16,
 -2.127214562499435e-17,  1.514225784724578e-18, -9.292347992772203e-20,  5.015717330371114e-21, -2.418130169942982e-22,  1.053959403452859e-23, -4.188708875776455e-25,
  7.589575668949317e-14, -3.046084767593387e-14,  6.503867172786004e-15, -9.437624590115548e-16,  1.037440762144860e-16, -9.185253723308955e-18,  6.812815232695552e-19,
 -4.350587810687426e-20,  2.440544181423268e-21, -1.221313953958018e-22,  5.518842106433350e-24, -2.271151098375657e-25,  2.887802448953256e-14, -1.199345837689509e-14,
  2.658042578800393e-15, -4.002918785794587e-16,  4.562928206724436e-17, -4.185001069349556e-18,  3.212106106598165e-19, -2.120334631231564e-20,  1.228229833226856e-21,
 -6.340348534376905e-23,  2.952552433311458e-24, -1.250872572137062e-25,  1.190094379119601e-14, -5.074526118411864e-15,  1.157708286302937e-15, -1.794688514790843e-16,
  2.104609332095385e-17, -1.984290596682987e-18,  1.564319181860817e-19, -1.059757725977814e-20,  6.294983417601328e-22, -3.329628334050369e-23,  1.587498290830877e-24,
 -6.880362656242160e-26,  5.033145782579212e-15, -2.185810358423806e-15,  5.089098213892375e-16, -8.051351765361052e-17,  9.632016621357300e-18, -9.259518960397322e-19,
  7.438738353707080e-20, -5.132406304116669e-21,  3.103144237411552e-22, -1.669759744751597e-23,  8.094444944293038e-25, -3.564947982991672e-26,  1.716692212731000e-15,
 -7.531884277031191e-16,  1.773690356817848e-16, -2.838356142743173e-17,  3.433868823726256e-18, -3.337314636440336e-19,  2.709649452487089e-20, -1.888862139603407e-21,
  1.153474588988868e-22, -6.266876871007091e-24,  3.066501974370748e-25, -1.362790065980893e-26,  7.398941871220981e-02, -2.282299040768226e-04,  7.341388911444585e-07,
 -2.443028762487555e-09,  8.331860447586237e-12, -2.888894300529977e-14,  1.011182320858394e-16, -3.558045333788309e-19,  1.253455279012366e-21, -4.416705729272681e-24,
  1.552223114588726e-26, -5.448463703684645e-29,  6.782158917337607e-02, -2.680507281269206e-04,  1.279236085115496e-06, -6.327847575272850e-09,  3.084245530093531e-11,
 -1.467821303126260e-13,  6.829915274597772e-16, -3.117084578440719e-18,  1.399100567007147e-20, -6.189983250194702e-23,  2.703761133259136e-25, -1.167580909476436e-27,
  5.699264375886757e-02, -3.243823187183766e-04,  2.222868827168459e-06, -1.444916961430573e-08,  8.861227957671750e-11, -5.196654834723034e-13,  2.941974994635901e-15,
 -1.617714426320268e-17,  8.676975288410747e-20, -4.554346317904027e-22,  2.345081299337468e-24, -1.186929012583119e-26,  4.391693989978653e-02, -3.649827477902847e-04,
  3.290232039399042e-06, -2.649292704990411e-08,  1.972079565213389e-10, -1.385668645233361e-12,  9.299559908855846e-15, -6.007963520767701e-17,  3.757594328377304e-19,
 -2.284899598491430e-21,  1.355341009256445e-23, -7.863172932006858e-26,  3.104393673055017e-02, -3.669882391694706e-04,  4.147479214624865e-06, -4.044992469332133e-08,
  3.589714738765134e-10, -2.969397138531757e-12,  2.322493918811499e-14, -1.734375432226589e-16,  1.245328072754372e-18, -8.643049281230430e-21,  5.821962852269933e-23,
 -3.818449532216367e-25,  2.014123755646794e-02, -3.270928891329393e-04,  4.523721902240123e-06, -5.271599454750163e-08,  5.503071951294289e-10, -5.290417917855455e-12,
  4.764246888177007e-14, -4.065653096970631e-16,  3.315046273579080e-18, -2.598706564891273e-20,  1.967928830708923e-22, -1.445015500396078e-24,  1.200230038376866e-02,
 -2.590747740749209e-04,  4.323727966216154e-06, -5.955306964043593e-08,  7.235987622577504e-10, -8.005880882405504e-12,  8.225584094098767e-14, -7.952535942326254e-16,
  7.303266968184963e-18, -6.415826648874159e-20,  5.420838761911842e-22, -4.423832671067587e-24,  6.575008747738666e-03, -1.833175013415392e-04,  3.654831093282258e-06,
 -5.895323931110570e-08,  8.266943145505680e-10, -1.044526450183129e-11,  1.215624070631793e-13, -1.322476386712832e-15,  1.359073105006020e-17, -1.329711283959681e-19,
  1.246082279553513e-21, -1.123698800172403e-23,  3.314803253216967e-03, -1.165240311611819e-04,  2.751725332386951e-06, -5.156938747806700e-08,  8.287561481373930e-10,
 -1.188240687362472e-11,  1.557206532782022e-13, -1.895731789431511e-15,  2.168649907806815e-17, -2.351245354848167e-19,  2.431994686975726e-21, -2.412175489541499e-23,
  1.540034066201636e-03, -6.688238380616407e-05,  1.856263267054678e-06, -4.013921449725214e-08,  7.348720923613699e-10, -1.189219623787649e-11,  1.746286804450296e-13,
 -2.367956823089459e-15,  3.002177577821047e-17, -3.591850516034308e-19,  4.084231612911543e-21, -4.438262138959864e-23,  6.604166103427483e-04, -3.483118064189849e-05,
  1.127854266886104e-06, -2.796830460313512e-08,  5.803109973229342e-10, -1.055042335060702e-11,  1.728577148472920e-13, -2.600472655951007e-15,  3.640315843601564e-17,
 -4.789011955525370e-19,  5.965970131734021e-21, -7.079597459286175e-23,  2.619191299376097e-04, -1.653246938617242e-05,  6.202663593877529e-07, -1.754217346523529e-08,
  4.106037904556298e-10, -8.352485090429340e-12,  1.521190019165513e-13, -2.530181900926425e-15,  3.898082326369834e-17, -5.621364715554207e-19,  7.649561869434533e-21,
 -9.884450926241279e-23,  9.629216658316425e-05, -7.183249057344113e-06,  3.102348377046589e-07, -9.956421974556325e-09,  2.618010616987606e-10, -5.936836387437179e-12,
  1.197928478070806e-13, -2.196206229775094e-15,  3.713107886265766e-17, -5.853701454124981e-19,  8.678734608772345e-21, -1.218077202657262e-22,  3.290763640916788e-05,
 -2.869699967942646e-06,  1.418008112951640e-07, -5.140175407426309e-09,  1.512534505008829e-10, -3.810893195875803e-12,  8.493840573909087e-14, -1.711667380143004e-15,
  3.167580649494423e-17, -5.445824472266646e-19,  8.776288871219163e-21, -1.334938660599371e-22,  1.048864013551806e-05, -1.058981294189518e-06,  5.952603362266120e-08,
 -2.426618586733084e-09,  7.962179414658485e-11, -2.221999514249885e-12,  5.455285851864257e-14, -1.205321010273845e-15,  2.435726375827857e-17, -4.556595342028519e-19,
  7.965067582928401e-21, -1.310354719097898e-22,  3.130100485970493e-06, -3.627685708754312e-07,  2.307140219104247e-08, -1.053356991535333e-09,  3.840946458768225e-11,
 -1.183780526635079e-12,  3.193075700086565e-14, -7.716707772691011e-16,  1.699094491763346e-17, -3.451479866147179e-19,  6.531328057640166e-21, -1.159926003041341e-22,
  8.786622785437904e-07, -1.159916302142502e-07,  8.303702278415995e-09, -4.229325543885504e-10,  1.708268446208523e-11, -5.798204477553856e-13,  1.714010169608109e-14,
 -4.520519397438412e-16,  1.082233515282926e-17, -2.382475638588869e-19,  4.871470789100563e-21, -9.322670987536629e-23,  2.332786122264633e-07, -3.482744675041615e-08,
  2.792835954352167e-09, -1.580847107066391e-10,  7.050593217049817e-12, -2.628339099942523e-13,  8.494287317555512e-15, -2.439455682772794e-16,  6.336997225785429e-18,
 -1.508957805841964e-19,  3.327779791813402e-21, -6.850618479208992e-23,  5.895107759149255e-08, -9.887760858840170e-09,  8.840060473324752e-10, -5.540208591019082e-11,
  2.719927224086194e-12, -1.110588868687570e-13,  3.914468086148215e-15, -1.221437806420805e-16,  3.435836858469743e-18, -8.832429933378423e-20,  2.097082064149122e-21,
 -4.635861127247295e-23,  1.428612087829908e-08, -2.675134689338938e-09,  2.654238606218950e-10, -1.834969677442834e-11,  9.885378401008474e-13, -4.408968803399350e-14,
  1.690676165673856e-15, -5.718914818549696e-17,  1.738353343390529e-18, -4.814907680903365e-20,  1.228494973571842e-21, -2.911078551593542e-23,  3.348964069177647e-09,
 -6.958678663912552e-10,  7.627461947860616e-11, -5.795132551601048e-12,  3.414820042718794e-13, -1.658930291154805e-14,  6.903093755674044e-16, -2.525402394864889e-17,
  8.276904839567919e-19, -2.465050852911195e-20,  6.745473905323921e-22, -1.710187509520660e-23,  7.670620482494912e-10, -1.758073618029649e-10,  2.119128719447384e-11,
 -1.762659165034534e-12,  1.132301770166186e-13, -5.973703133268649e-15,  2.690125175026359e-16, -1.061705072652569e-17,  3.743141708916164e-19, -1.196028201020199e-20,
  3.502797329935066e-22, -9.482406264371501e-24,  1.736419532331159e-10, -4.363732671414787e-11,  5.757123827445378e-12, -5.221607586910687e-13,  3.643766556898591e-14,
 -2.080966925717373e-15,  1.011191181245680e-16, -4.293633331548872e-18,  1.624201958055928e-19, -5.554422281024686e-21,  1.736979228019794e-22, -5.009605593577794e-24,
  3.935704116131403e-11, -1.077931588590194e-11,  1.548968470788331e-12, -1.525396996443248e-13,  1.151932759713032e-14, -7.096821557366721e-16,  3.709131597566948e-17,
 -1.689332376961298e-18,  6.837184399823214e-20, -2.495716945520578e-21,  8.312085528417844e-23, -2.547663536352082e-24,  9.062083230721239e-12, -2.688174593451100e-12,
  4.185719170475220e-13, -4.455182058233493e-14,  3.625783899764203e-15, -2.400456424986666e-16,  1.344578851013178e-17, -6.546586202465154e-19,  2.825754469126621e-20,
 -1.097604486264866e-21,  3.881937532843858e-23, -1.260891757281075e-24,  2.153579152152030e-12, -6.874550792385883e-13,  1.153506944070947e-13, -1.320407228714808e-14,
  1.152775708669788e-15, -8.166477944756493e-17,  4.882749348747119e-18, -2.531769479350605e-19,  1.161247939219699e-20, -4.783232645489324e-22,  1.790453059473135e-23,
 -6.143137381053534e-25,  5.372275133696677e-13, -1.833010349176525e-13,  3.294709946739232e-14, -4.033883751324470e-15,  3.758792233422520e-16, -2.835665887839386e-17,
  1.801568526875485e-18, -9.905240829023111e-20,  4.807870100214748e-21, -2.091762339852480e-22,  8.255336192233603e-24, -2.980976741202818e-25,  1.431270607901542e-13,
 -5.183008565759291e-14,  9.915290418195198e-15, -1.290664943440932e-15,  1.276325229316922e-16, -1.019876796267803e-17,  6.849883642162414e-19, -3.973956102531660e-20,
  2.031680309553207e-21, -9.294232261281751e-23,  3.850549351153883e-24, -1.457177675416986e-25,  4.140111440057014e-14, -1.579469290085984e-14,  3.193452078767562e-15,
 -4.390211784735039e-16,  4.578385814129666e-17, -3.851762872271331e-18,  2.719116575434077e-19, -1.655340352235681e-20,  8.866453392242634e-22, -4.243030862807807e-23,
  1.836194911137950e-24, -7.247587313281837e-26,  1.318120722110387e-14, -5.256983557268998e-15,  1.114843092098430e-15, -1.606894690153846e-16,  1.754910154450631e-17,
 -1.543996687513236e-18,  1.138267138908403e-19, -7.226448190261944e-21,  4.031036805494496e-22, -2.006321588428605e-23,  9.018834948666117e-25, -3.692881850293764e-26,
  4.650953178011143e-15, -1.923612628650611e-15,  4.243987273661708e-16, -6.362729285621498e-17,  7.221321026120584e-18, -6.595332080194249e-19,  5.041537091607770e-20,
 -3.314917835355395e-21,  1.912955261790933e-22, -9.839078463700072e-24,  4.565748293680205e-25, -1.927786219255618e-26,  1.802981705655804e-15, -7.669368031452634e-16,
  1.745071054379721e-16, -2.698096913602824e-17,  3.155891790767939e-18, -2.968057492492391e-19,  2.334236411920849e-20, -1.577663739156585e-21,  9.350309120976216e-23,
 -4.934971789917357e-24,  2.347969629089575e-25, -1.015581325637964e-26,  7.295018887381191e-16, -3.164428186519384e-16,  7.358069890458149e-17, -1.162603621838730e-17,
  1.389092834698406e-18, -1.333732081990687e-19,  1.070191755829563e-20, -7.375333355005018e-22,  4.454272709216309e-23, -2.394189483682985e-24,  1.159407928404263e-25,
 -5.101087059418155e-27,  2.425955745207118e-16, -1.063892598622206e-16,  2.504097850764072e-17, -4.005136833428166e-18,  4.842991264332664e-19, -4.704470528557879e-20,
  3.817815917697639e-21, -2.660083400131984e-22,  1.623682067690932e-23, -8.817528754521412e-25,  4.312671866106410e-26, -1.915775803112117e-27,  7.308806279057486e-02,
 -2.224718351332362e-04,  7.056037559556956e-07, -2.314212675587110e-09,  7.777565814864226e-12, -2.657726601041328e-14,  9.169417785888641e-17, -3.181226884618013e-19,
  1.105075729671049e-21, -3.841192431006001e-24,  1.331428430142783e-26, -4.612524772360363e-29,  6.676938467827950e-02, -2.581124044480202e-04,  1.206168719724710e-06,
 -5.856991600458296e-09,  2.806391410381725e-11, -1.313890694180273e-13,  6.016604474602694e-16, -2.703035820574565e-18,  1.194551546396783e-20, -5.204551589807684e-23,
  2.239050532231126e-25, -9.524863564307836e-28,  5.572961526453481e-02, -3.072695914119187e-04,  2.057654610697440e-06, -1.311083183241610e-08,  7.888991368699877e-11,
 -4.541943713650584e-13,  2.525546385600240e-15, -1.364571213182389e-17,  7.194393035014041e-20, -3.712919370580636e-22,  1.880294364433638e-24, -9.362094927741231e-27,
  4.250771220567227e-02, -3.398809415833762e-04,  2.990372112664321e-06, -2.354772855332366e-08,  1.715969301507936e-10, -1.181379643645255e-12,  7.774013035114370e-15,
 -4.927321071639309e-17,  3.024819583904380e-19, -1.806078733383603e-21,  1.052323370715509e-23, -5.998780853309727e-26,  2.963940137964248e-02, -3.356566861994590e-04,
  3.694675355670998e-06, -3.515277297248905e-08,  3.047862688433407e-10, -2.466042716725644e-12,  1.888284251698296e-14, -1.381468928872130e-16,  9.723420167128741e-19,
 -6.618407304000198e-21,  4.374141240922370e-23, -2.815862380747033e-25,  1.890144033676176e-02, -2.932914542813551e-04,  3.940658944822923e-06, -4.469908591156121e-08,
  4.550694108801960e-10, -4.272430444671863e-12,  3.761329074784097e-14, -3.140492950929761e-16,  2.507114862466117e-18, -1.925356089097205e-20,  1.429061685948439e-22,
 -1.028952326232005e-24,  1.103091755397063e-02, -2.271581866399061e-04,  3.673600579792352e-06, -4.915629039551793e-08,  5.815468544577655e-10, -6.274530744775078e-12,
  6.294114750040991e-14, -5.946724058129966e-16,  5.341116476012743e-18, -4.591959428400538e-20,  3.799200297277668e-22, -3.037566896761385e-24,  5.896033337140468e-03,
 -1.566986532555301e-04,  3.020342091792905e-06, -4.725061448556835e-08,  6.442010193038477e-10, -7.927076443040155e-12,  8.996544012957217e-14, -9.554348459044597e-16,
  9.593334771414644e-18, -9.177381221446518e-20,  8.414370374487420e-22, -7.428235257022140e-24,  2.889111449496398e-03, -9.677696362056101e-05,  2.205222526852374e-06,
 -4.002414496312100e-08,  6.245558247162225e-10, -8.710856658847246e-12,  1.112059453806683e-13, -1.320316874552185e-15,  1.474421777756903e-17, -1.561753667576960e-19,
  1.579301998382898e-21, -1.532396428037656e-23,  1.299414257900857e-03, -5.377577592702006e-05,  1.437971989404741e-06, -3.007702912024843e-08,  5.340826911591094e-10,
 -8.399091148254248e-12,  1.200361890389348e-13, -1.586081441156720e-15,  1.961485510020620e-17, -2.291091098420254e-19,  2.545304908030107e-21, -2.704218382713400e-23,
  5.372153668173694e-04, -2.700766668213779e-05,  8.416489817680123e-07, -2.016856714052658e-08,  4.055087573846879e-10, -7.158385926711823e-12,  1.140574327771622e-13,
 -1.670836029583107e-15,  2.280001625491722e-17, -2.926566983876739e-19,  3.560094595449339e-21, -4.128297971474045e-23,  2.045227313908486e-04, -1.231219569141382e-05,
  4.442479580776017e-07, -1.213231894202677e-08,  2.749803833778518e-10, -5.427596172982641e-12,  9.607142377763375e-14, -1.555108183849342e-15,  2.334247304637578e-17,
 -3.282814150337969e-19,  4.360333151084275e-21, -5.503588614638114e-23,  7.185603647894461e-05, -5.116172618406736e-06,  2.124265558446800e-07, -6.580008970452984e-09,
  1.674528546030358e-10, -3.682780014016853e-12,  7.218886810664287e-14, -1.287436316973326e-15,  2.119865946683379e-17, -3.258044637437819e-19,  4.713283717512031e-21,
 -6.459953681555956e-23,  2.335825739888071e-05, -1.946027187930486e-06,  9.244260252442980e-08, -3.233548082312857e-09,  9.206181447541862e-11, -2.248901747583463e-12,
  4.867891833102464e-14, -9.540097479548834e-16,  1.718990356348015e-17, -2.880518794317914e-19,  4.528726531452155e-21, -6.725791993480363e-23,  7.047350033295136e-06,
 -6.805600033785684e-07,  3.678629223938276e-08, -1.447117491391483e-09,  4.593888268691534e-11, -1.242851990603900e-12,  2.963055565950675e-14, -6.366161471571797e-16,
  1.252498640226399e-17, -2.283595967699671e-19,  3.894064886095174e-21, -6.254684547045874e-23,  1.980791541286777e-06, -2.198723881052697e-07,  1.345430693723678e-08,
 -5.929447879467019e-10,  2.092174243284598e-11, -6.251827266139291e-13,  1.637681146903401e-14, -3.848914123006208e-16,  8.251466228612859e-18, -1.633748936678589e-19,
  3.016178258931084e-21, -5.230402274520393e-23,  5.209698114852915e-07, -6.597122302486684e-08,  4.547906162909004e-09, -2.237193682971489e-10,  8.747589236928368e-12,
 -2.879697050848979e-13,  8.269454751845172e-15, -2.121550493863988e-16,  4.946566919211859e-18, -1.061662400609846e-19,  2.118374082139857e-21, -3.959530994885575e-23,
  1.288988239451152e-07, -1.849266190588978e-08,  1.429608719318286e-09, -7.821849384268532e-11,  3.379329875853721e-12, -1.222507576228511e-13,  3.839952766614238e-15,
 -1.073237309960054e-16,  2.716416212021543e-18, -6.308857819760802e-20,  1.358297685897985e-21, -2.732197660706793e-23,  3.019114403813958e-08, -4.875818982802246e-09,
  4.208187846511757e-10, -2.552013041218654e-11,  1.214769524604438e-12, -4.817283292031315e-14,  1.651451305132547e-15, -5.018360645956443e-17,  1.376294416714309e-18,
 -3.452926833534471e-20,  8.008462577286369e-22, -1.730857095230408e-23,  6.744250566765445e-09, -1.218645831976240e-09,  1.169151201488827e-10, -7.831765030952935e-12,
  4.095519757252905e-13, -1.775896731913577e-14,  6.629808424332657e-16, -2.185951256874919e-17,  6.483685239225781e-19, -1.754097119934271e-20,  4.375294155987717e-22,
 -1.014420592127711e-23,  1.449475453013097e-09, -2.913281118554862e-10,  3.093523450773856e-11, -2.281042799393065e-12,  1.306590543204638e-13, -6.179097419778995e-15,
  2.506220245403902e-16, -8.947040645880945e-18,  2.864416794598970e-19, -8.341011742732034e-21,  2.233574529712037e-22, -5.545958177732521e-24,  3.027991573462185e-10,
 -6.730513616130058e-11,  7.876120823800869e-12, -6.369838852510894e-13,  3.984295706490586e-14, -2.049399039961203e-15,  9.008589049981904e-17, -3.474149683485328e-18,
  1.198004339150205e-19, -3.747334176949798e-21,  1.075240372408592e-22, -2.853988385347298e-24,  6.221881468976993e-11, -1.520639801547906e-11,  1.952297444821501e-12,
 -1.725305334802092e-13,  1.174566264919310e-14, -6.551795078973179e-16,  3.112832970185765e-17, -1.293583069144159e-18,  4.793365453336860e-20, -1.607030931751096e-21,
  4.930508801664957e-23, -1.396130077388653e-24,  1.274781886578982e-11, -3.405581606323006e-12,  4.774601619218324e-13, -4.592149260929602e-14,  3.390502062102328e-15,
 -2.044302209687073e-16,  1.046661043816179e-17, -4.673888044104313e-19,  1.856170749523640e-20, -6.653279640731281e-22,  2.177458392433735e-23, -6.562524760780623e-25,
  2.644913568484994e-12, -7.676582621525476e-13,  1.169441682989646e-13, -1.218763676511842e-14,  9.720549455943668e-16, -6.312418132912560e-17,  3.471019038950105e-18,
 -1.660298404220505e-19,  7.045553655686275e-21, -2.692303190392887e-22,  9.373310555026636e-24, -2.998823093494083e-25,  5.653560888186938e-13, -1.771353568600389e-13,
  2.916390003088716e-14, -3.277621871702820e-15,  2.811503673595767e-16, -1.958341244150013e-17,  1.152074025535145e-18, -5.881493867405024e-20,  2.657685382562022e-21,
 -1.079111228800720e-22,  3.983908645041819e-24, -1.348869784808161e-25,  1.268463233800033e-13, -4.261479193543483e-14,  7.538433450655985e-15, -9.087451974546140e-16,
  8.342043731949471e-17, -6.203578893312105e-18,  3.887327594244628e-19, -2.109193696688136e-20,  1.010834869889365e-21, -4.344383603996170e-23,  1.694490679769557e-24,
 -6.049927025234286e-26,  3.046187084291096e-14, -1.089525432391065e-14,  2.057491243377771e-15, -2.644525617782540e-16,  2.583375692417244e-17, -2.040177099621626e-18,
  1.354865906120292e-19, -7.775359625407962e-21,  3.933863666961271e-22, -1.781627243188488e-23,  7.310199717568305e-25, -2.740854958784404e-26,  7.981693130754060e-15,
 -3.016399470943369e-15,  6.037927417791370e-16, -8.219383596031638e-17,  8.490434462714234e-18, -7.077693593869771e-19,  4.952514730108837e-20, -2.989493366701723e-21,
  1.588229073622790e-22, -7.540955474783245e-24,  3.238795547266462e-25, -1.269116064932916e-26,  2.320411366176303e-15, -9.191835881107292e-16,  1.935168616042407e-16,
 -2.769323407469924e-17,  3.003415201285562e-18, -2.624743578370703e-19,  1.922526103752251e-20, -1.212957989675471e-21,  6.725615556541540e-23, -3.328185960956324e-24,
  1.487792094576342e-25, -6.059494941336797e-27,  7.561476533261499e-16, -3.113467222691549e-16,  6.835895313501679e-17, -1.019949257323828e-17,  1.152187079406844e-18,
 -1.047567401758036e-19,  7.972913852406829e-21, -5.220410481822696e-22,  3.000415659446624e-23, -1.537234748078425e-24,  7.106711165138336e-26, -2.989852015341776e-27,
  2.747190988078365e-16, -1.165551029830710e-16,  2.644531659795500e-17, -4.077212500305827e-18,  4.755857086116684e-19, -4.460849669220749e-20,  3.499195079958896e-21,
 -2.359147458867507e-22,  1.394833220559503e-23, -7.344694137984599e-25,  3.486662312362386e-26, -1.504864005600351e-27,  1.060354797121309e-16, -4.593875791229070e-17,
  1.066714768926638e-17, -1.683125385727494e-18,  2.008302610920591e-19, -1.925732721371306e-20,  1.543249320251099e-21, -1.062235698139538e-22,  6.407640554066316e-24,
 -3.440161406784029e-25,  1.664070864506728e-26, -7.313589055072402e-28,  3.432113971167125e-17, -1.504420842145740e-17,  3.539077357958568e-18, -5.657453772814013e-19,
  6.837306972652273e-20, -6.638261583238694e-21,  5.384382082666797e-22, -3.749718398553905e-23,  2.287663543778961e-24, -1.241740826582428e-25,  6.070555775651117e-27,
 -2.695443091848302e-28,  7.220929216425886e-02, -2.169360114314778e-04,  6.785626883820741e-07, -2.193907374140240e-09,  7.267325717606453e-12, -2.447962320573266e-14,
  8.326173844415496e-17, -2.848738450844153e-19,  9.759096914619433e-22, -3.347064002390584e-24,  1.144299528102748e-26, -3.913867252172744e-29,  6.575579914814952e-02,
 -2.487367516412018e-04,  1.138494712413295e-06, -5.428231638034506e-09,  2.557461684756982e-11, -1.178159151422012e-13,  5.310572301524818e-16, -2.349107703410701e-18,
  1.022348214589267e-20, -4.387381786851604e-23,  1.859398796819186e-25, -7.793481243553018e-28,  5.453249235914862e-02, -2.914168860032639e-04,  1.907608616024763e-06,
 -1.191809638037949e-08,  7.038250282303202e-11, -3.979179190715969e-13,  2.173786903062692e-15, -1.154362319967461e-17,  5.983757077339656e-20, -3.037094188121059e-22,
  1.513016104715401e-24, -7.412509140498784e-27,  4.119430837172453e-02, -3.170433133747554e-04,  2.723524566238086e-06, -2.098151124544924e-08,  1.497287567892227e-10,
 -1.010322650546726e-12,  6.520651185575759e-15, -4.055774278958345e-17,  2.444444702705231e-19, -1.433524290054615e-21,  8.206402870067991e-24, -4.597609128386874e-26,
  2.835333011961830e-02, -3.077073092830396e-04,  3.300550287620798e-06, -3.064739088625709e-08,  2.597012585725430e-10, -2.055964518911953e-12,  1.541679409561365e-14,
 -1.105292840953692e-16,  7.628008295561276e-19, -5.093431358916736e-21,  3.303665025849971e-23, -2.087954918560409e-25,  1.778809450099460e-02, -2.637941496093948e-04,
  3.445287858209185e-06, -3.805535095534427e-08,  3.779800000705501e-10, -3.466769395168731e-12,  2.984627872942075e-14, -2.438912519536700e-16,  1.906831917693053e-18,
 -1.434945772856772e-20,  1.044179971433551e-22, -7.374092630623148e-25,  1.017753791749146e-02, -1.999797340057812e-04,  3.135663593325860e-06, -4.077872277785097e-08,
  4.699070929657330e-10, -4.945868388683966e-12,  4.845411243465254e-14, -4.475161732003081e-16,  3.932145100123334e-18, -3.309358971530744e-20,  2.681827322062967e-22,
 -2.101230232159409e-24,  5.314205546132622e-03, -1.346400530603267e-04,  2.510302728061002e-06, -3.810292404412162e-08,  5.052513932063226e-10, -6.057077906048730e-12,
  6.705725553251764e-14, -6.954034210209754e-16,  6.824029016641547e-18, -6.384697941227634e-20,  5.728842124543529e-22, -4.952184626234854e-24,  2.534468808388687e-03,
 -8.089882027146390e-05,  1.779578542942060e-06, -3.129164899294681e-08,  4.742886230658201e-10, -6.437015020932061e-12,  8.007710281749772e-14, -9.274736295215430e-16,
  1.011329837452241e-17, -1.046830698131561e-19,  1.035194797317906e-21, -9.828507713064966e-24,  1.105222303201655e-03, -4.358224669059887e-05,  1.123244825811426e-06,
 -2.273294801914433e-08,  3.916489278068840e-10, -5.987190823720269e-12,  8.330110233575257e-14, -1.072836382691103e-15,  1.294488387897573e-17, -1.476498471377239e-19,
  1.602996949737750e-21, -1.665428109379272e-23,  4.412607702796170e-04, -2.114225547237305e-05,  6.342721157000425e-07, -1.469157663664206e-08,  2.863134577096220e-10,
 -4.908797231940475e-12,  7.608169788737997e-14, -1.085521540491541e-15,  1.444275720338161e-17, -1.809174539625889e-19,  2.149498567447316e-21, -2.436181758577018e-23,
  1.615555177454924e-04, -9.273272486010759e-06,  3.218447609398461e-07, -8.489186018530355e-09,  1.863525346918318e-10, -3.569816155426777e-12,  6.142424614343821e-14,
 -9.678065534097464e-16,  1.415603811846941e-17, -1.941893532289403e-19,  2.517959569297907e-21, -3.104935284571156e-23,  5.434771417227219e-05, -3.692095361513812e-06,
  1.473857652532605e-07, -4.406878139220693e-09,  1.085571780980472e-10, -2.315833667667716e-12,  4.410480105613786e-14, -7.652757133024879e-16,  1.227380287226180e-17,
 -1.839249283642731e-19,  2.596580258217921e-21, -3.475725015816170e-23,  1.683879504079228e-05, -1.339702725086968e-06,  6.117693567677437e-08, -2.064981370453681e-09,
  5.688774061212407e-11, -1.347457907964437e-12,  2.832807972866702e-14, -5.399630980629448e-16,  9.474020086571747e-18, -1.547491741742834e-19,  2.373696017635049e-21,
 -3.442231514853032e-23,  4.819142729149238e-06, -4.449011219646595e-07,  2.312110124105132e-08, -8.776468973139013e-10,  2.695468781915272e-11, -7.069725226732179e-13,
  1.636731089362709e-14, -3.419619940262290e-16,  6.550313232983745e-18, -1.163977627320041e-19,  1.936302029263199e-21, -3.036591054748060e-23,  1.278443109623062e-06,
 -1.358363322091004e-07,  7.995155336665788e-09, -3.400603687176574e-10,  1.160943908391377e-11, -3.363269059437482e-13,  8.555429067301619e-15, -1.955307507403465e-16,
  4.081281798725014e-18, -7.875892959641219e-20,  1.418503023377180e-21, -2.401821174061535e-23,  3.157081444219589e-07, -3.832367581249842e-08,  2.543080310761348e-09,
 -1.207877261354586e-10,  4.571038173152928e-12, -1.459215842937870e-13,  4.070018555800232e-15, -1.015590051202866e-16,  2.305875059641424e-18, -4.824425774983030e-20,
  9.392925168875941e-22, -1.714582501696179e-23,  7.294553416774404e-08, -1.004882927679651e-08,  7.485186175376539e-10, -3.957064960065792e-11,  1.655551008781887e-12,
 -5.810485876806616e-14,  1.773426838380749e-15, -4.822748750466984e-17,  1.189103986023582e-18, -2.693115534625598e-20,  5.659651362655575e-22, -1.112180242076322e-23,
  1.586648401400900e-08, -2.465102684439219e-09,  2.052587004327485e-10, -1.203898963586779e-11,  5.553912746264133e-13, -2.138262527993238e-14,  7.127326525382521e-16,
 -2.108580957743626e-17,  5.636470903317710e-19, -1.379742210098131e-20,  3.125202316039983e-22, -6.602118888278721e-24,  3.272766831099412e-09, -5.701129206432239e-10,
  5.284916925295811e-11, -3.428201374388687e-12,  1.739303275253754e-13, -7.329066870025283e-15,  2.662625622658647e-16, -8.553982594733065e-18,  2.474858732265517e-19,
 -6.537570954784093e-21,  1.593668456880986e-22, -3.614136542565912e-24,  6.457942156144897e-10, -1.254238956187738e-10,  1.289185261992721e-11, -9.219134133461339e-13,
  5.130169260753910e-14, -2.360492495503355e-15,  9.327295234720919e-17, -3.247771936452804e-18,  1.015245019049474e-19, -2.889333549148089e-21,  7.568382415117125e-23,
 -1.839754783734173e-24,  1.231717384194323e-10, -2.652331000804544e-11,  3.010574058414543e-12, -2.365553861242179e-13,  1.439736000650335e-14, -7.215657152508971e-16,
  3.094235464438230e-17, -1.165382647803440e-18,  3.928559036440556e-20, -1.202390719254684e-21,  3.378609483691204e-23, -8.788933137072490e-25,  2.298536894554729e-11,
 -5.457318378321728e-12,  6.811772655670645e-13, -5.860511269156142e-14,  3.889379519372204e-15, -2.117513106490331e-16,  9.830276351980438e-18, -3.995635931522673e-19,
  1.449484221397865e-20, -4.761517985070353e-22,  1.432516328138702e-23, -3.980556775963947e-25,  4.256724550288513e-12, -1.107992948388071e-12,  1.514091567718031e-13,
 -1.420969796863072e-14,  1.024905598210019e-15, -6.043417318664353e-17,  3.028944103895987e-18, -1.325276622883200e-19,  5.161230336512485e-21, -1.815576436100704e-22,
  5.835579500845800e-24, -1.728466701895699e-25,  7.951953376647861e-13, -2.255731403585046e-13,  3.358683670832675e-14, -3.424237637470228e-15,  2.674284176288435e-16,
 -1.702110218803274e-17,  9.181232578087917e-19, -4.311539112229280e-20,  1.797581221525097e-21, -6.753467597882113e-23,  2.313167517384984e-24, -7.285341962278274e-26,
  1.526409072571435e-13, -4.689313243293351e-14,  7.568320373739449e-15, -8.343596290005901e-16,  7.026139924631842e-17, -4.808278939424587e-18,  2.781168472535032e-19,
 -1.396956630339202e-20,  6.214847583011359e-22, -2.485935408768929e-23,  9.046448200233177e-25, -3.020836834942197e-26,  3.072817828174550e-14, -1.015525070409887e-14,
  1.766415724759713e-15, -2.094813362087114e-16,  1.892952285265125e-17, -1.386599918400373e-18,  8.563860738661928e-20, -4.582459833636431e-21,  2.167034470378891e-22,
 -9.194810634812727e-24,  3.542381119955660e-25, -1.249849400569813e-26,  6.630446073141147e-15, -2.340416932365457e-15,  4.359399054321884e-16, -5.528551143840186e-17,
  5.331313502621679e-18, -4.158306000545129e-19,  2.728734863984721e-20, -1.548130344607386e-21,  7.746822985530539e-23, -3.471549487236385e-24,  1.409979747605224e-25,
 -5.235053638260926e-27,  1.567689824329299e-15, -5.864912929046701e-16,  1.161506556676054e-16, -1.564669777245622e-17,  1.599978834442153e-18, -1.320812980263425e-19,
  9.155968606989264e-21, -5.477261402991544e-22,  2.884814598152438e-23, -1.358358140299825e-24,  5.787508837820648e-26, -2.250439856604571e-27,  4.143928797223567e-16,
 -1.629625201283848e-16,  3.404234974929813e-17, -4.834359936150518e-18,  5.204129387873102e-19, -4.515467841529821e-20,  3.284644416433489e-21, -2.058621361161809e-22,
  1.134194304625606e-23, -5.578186806299322e-25,  2.478895699803556e-26, -1.003886746682218e-27,  1.241770900777832e-16, -5.088529549118127e-17,  1.111428117169231e-17,
 -1.649779090030461e-18,  1.854364930318361e-19, -1.677851598162314e-20,  1.271055132465133e-21, -8.285199491732423e-23,  4.741367652430820e-24, -2.419114047053522e-25,
  1.113899024125086e-26, -4.668273373001523e-28,  4.211665418097172e-17, -1.781898350261501e-17,  4.030607519418314e-18, -6.195313417567710e-19,  7.205118620637776e-20,
 -6.738819876349072e-21,  5.271468407722410e-22, -3.544530568561519e-23,  2.090296956744668e-24, -1.097948342535923e-25,  5.199713298607065e-27, -2.239071814052897e-28,
  1.545972207378124e-17, -6.688809098111856e-18,  1.550867135496477e-18, -2.443431207081362e-19,  2.911282229496747e-20, -2.787666409151241e-21,  2.230949705868420e-22,
 -1.533567174398117e-23,  9.239048399472155e-25, -4.954199671043059e-26,  2.393590423866865e-27, -1.050776613315313e-28,  4.861340935857421e-18, -2.129828011814256e-18,
  5.007481020722482e-19, -8.000222997709883e-20,  9.663204406778640e-21, -9.376707325177188e-22,  7.601464669607261e-23, -5.290919501337845e-24,  3.226275202067102e-25,
 -1.750340540152700e-26,  8.552790157396923e-28, -3.795798857126560e-29,  7.135224112705499e-02, -2.116108772826299e-04,  6.529176510471953e-07, -2.081440978970235e-09,
  6.797087753419601e-12, -2.257363846533404e-14,  7.570497486400856e-17, -2.554875632556273e-19,  8.632558213306313e-22, -2.921988684503169e-24,  9.853366283173011e-27,
 -3.328722992177002e-29,  6.477866510146382e-02, -2.398825674542031e-04,  1.075735521112287e-06, -5.037217532873724e-09,  2.334060954877209e-11, -1.058242834049985e-13,
  4.696347480116910e-16, -2.045856576128536e-18,  8.770035572838772e-21, -3.707873270649082e-23,  1.548318369422361e-25, -6.395444490495544e-28,  5.339646702967234e-02,
 -2.767095286096952e-04,  1.771094444804513e-06, -1.085291471204251e-08,  6.292074920660463e-11, -3.494190183789681e-13,  1.875808734474995e-15, -9.792686033012169e-18,
  4.991917883498803e-20, -2.492364879640589e-22,  1.221704236179994e-24, -5.890528358115947e-27,  3.996817245491224e-02, -2.962229854646470e-04,  2.485480104230369e-06,
 -1.873937062808977e-08,  1.309996488744058e-10, -8.666160263637031e-13,  5.487217045655829e-15, -3.350162956933774e-17,  1.982893909845409e-19, -1.142397333536241e-21,
  6.426907985001259e-24, -3.539528468348454e-26,  2.717307624890087e-02, -2.827063424870529e-04,  2.956418341576293e-06, -2.680202627031167e-08,  2.220448864457602e-10,
 -1.720501747451269e-12,  1.263786263092164e-14, -8.881536756210123e-17,  6.011653389821243e-19, -3.938849692288240e-21,  2.507889415787227e-23, -1.556479479400126e-25,
  1.678528880357005e-02, -2.379607207052221e-04,  3.022741671365936e-06, -3.252563814570610e-08,  3.152882831846571e-10, -2.825961058190766e-12,  2.379932469096068e-14,
 -1.903912358898839e-16,  1.458221109174258e-18, -1.075592369724126e-20,  7.675343411070191e-23, -5.317726507754135e-25,  9.424861441328109e-03, -1.767311165992348e-04,
  2.688359343600629e-06, -3.399238201935981e-08,  3.816728139081773e-10, -3.920147533338004e-12,  3.751993412316174e-14, -3.388472540446420e-16,  2.913489014948507e-18,
 -2.401000615864427e-20,  1.906263843631046e-22, -1.464000930302181e-24,  4.813096911064263e-03, -1.162578130148172e-04,  2.097840275195947e-06, -3.090679357906519e-08,
  3.987454601749786e-10, -4.658659261592282e-12,  5.032680946891421e-14, -5.097812955094235e-16,  4.890398625244855e-18, -4.476192599363282e-20,  3.931589620671134e-22,
 -3.328652274971691e-24,  2.237138649861761e-03, -6.804433173449239e-05,  1.445677645027977e-06, -2.463674645033700e-08,  3.628385147729800e-10, -4.793442085776025e-12,
  5.812448110587443e-14, -6.569293190452905e-16,  6.996390132323950e-18, -7.078819199111210e-20,  6.847062534974959e-22, -6.362520129885668e-24,  9.472767554533647e-04,
 -3.558938337598453e-05,  8.844220562093669e-07, -1.732532114859364e-08,  2.896867594075405e-10, -4.306130738919170e-12,  5.834247959701608e-14, -7.325753360025293e-16,
  8.626423936192739e-18, -9.610504714909320e-20,  1.019872254040733e-21, -1.036389238980222e-23,  3.658244031894839e-04, -1.670226151351632e-05,  4.825147190079607e-07,
 -1.080622454517620e-08,  2.041815310476008e-10, -3.400819542409780e-12,  5.128550432831463e-14, -7.128600289435712e-16,  9.249622170560432e-18, -1.130977140718495e-19,
  1.312658149040308e-21, -1.454353479624915e-23,  1.290317751847366e-04, -7.060255442273431e-06,  2.357446240692532e-07, -6.006987804926315e-09,  1.277425158073790e-10,
 -2.375454437332849e-12,  3.974112073028390e-14, -6.096195291493597e-16,  8.690846195364749e-18, -1.163077474482313e-19,  1.472503176283689e-21, -1.774220459981551e-23,
  4.164005740625000e-05, -2.698191428230796e-06,  1.035644231337440e-07, -2.989542816209694e-09,  7.129581251447371e-11, -1.475538117039414e-12,  2.730761210083816e-14,
 -4.610632048672945e-16,  7.203858647585352e-18, -1.052691086688788e-19,  1.450489847755468e-21, -1.896490024163522e-23,  1.232129504601029e-05, -9.357642489668496e-07,
  4.107602419914924e-08, -1.338015103549465e-09,  3.567006155474361e-11, -8.193125436975004e-13,  1.673124509249023e-14, -3.102094398298491e-16,  5.300514195907031e-18,
 -8.440143504731197e-20,  1.263212849595274e-21, -1.788854163884059e-23,  3.351865364555413e-06, -2.956782116869674e-07,  1.477155435712283e-08, -5.410186716748635e-10,
  1.607556085264395e-11, -4.087660925690558e-13,  9.190093375074933e-15, -1.867242737928548e-16,  3.482471603075671e-18, -6.031537245650358e-20,  9.788521946585432e-22,
 -1.498841251128803e-23,  8.410408984277100e-07, -8.548722412379896e-08,  4.838586287108416e-09, -1.985913863283811e-10,  6.559170766172975e-12, -1.842111164746807e-13,
  4.550265527250894e-15, -1.011257216164621e-16,  2.055044638910414e-18, -3.865129334714976e-20,  6.791160200881762e-22, -1.122733917476985e-23,  1.954239430187513e-07,
 -2.272509657696657e-08,  1.451009926149855e-09, -6.652636389959379e-11,  2.436195920291858e-12, -7.540487912573297e-14,  2.042537389381454e-15, -4.956685478397653e-17,
  1.095805968775464e-18, -2.234764658738193e-20,  4.245108165260400e-22, -7.567043195241558e-24,  4.225491392580964e-08, -5.585057429414145e-09,  4.006549334728714e-10,
 -2.045793720972365e-11,  8.286177454029831e-13, -2.820772703139074e-14,  8.363806620024523e-16, -2.212659966949999e-17,  5.313600956988225e-19, -1.173367167960645e-20,
  2.406531949928032e-22, -4.619343365231219e-24,  8.552215907597421e-09, -1.277167254293626e-09,  1.025349172549925e-10, -5.813744361252637e-12,  2.598319518642655e-13,
 -9.708693474694233e-15,  3.145553883183145e-16, -9.057505516370934e-18,  2.359294336331825e-19, -5.633562279182542e-21,  1.245897943382386e-22, -2.572085359540357e-24,
  1.631876807736114e-09, -2.737959977333209e-10,  2.450651598068869e-11, -1.538501036277720e-12,  7.569223516444554e-14, -3.098128471564272e-15,  1.094882093175286e-16,
 -3.425993678074148e-18,  9.665451035007637e-20, -2.492205368831879e-21,  5.935558575258361e-23, -1.316247648031196e-24,  2.961080842338566e-10, -5.551500061447977e-11,
  5.519008322766219e-12, -3.825042256369086e-13,  2.066595834893356e-14, -9.246571983407678e-16,  3.557802068560991e-17, -1.207774781152809e-18,  3.684827565047081e-20,
 -1.024509213392824e-21,  2.624103992115042e-23, -6.242545725983770e-25,  5.162565458891059e-11, -1.075816633306772e-11,  1.183403922883537e-12, -9.027156155866113e-14,
  5.342337099259188e-15, -2.607193368170236e-16,  1.090059705014147e-17, -4.007361558654492e-19,  1.319963521110612e-20, -3.951101637337079e-22,  1.086739673731967e-23,
 -2.769423596995404e-25,  8.755850141370350e-12, -2.017271529667380e-12,  2.445647389325094e-13, -2.046725647582103e-14,  1.323147149712292e-15, -7.026111018536941e-17,
  3.185070764733510e-18, -1.265492765024041e-19,  4.491824330314363e-21, -1.445008017221600e-22,  4.260786256562405e-24, -1.161268420536587e-25,  1.465860044302022e-12,
 -3.713369553218765e-13,  4.941076447985941e-14, -4.520852038512436e-15,  3.182848984260304e-16, -1.834024868912258e-17,  8.992012521843876e-19, -3.852383171202173e-20,
  1.470326508190748e-21, -5.072980200088395e-23,  1.600460729324821e-24, -4.656353910615639e-26,  2.464130536586543e-13, -6.824158229494866e-14,  9.921210588724530e-15,
 -9.885851907882139e-16,  7.553736943273585e-17, -4.708415574517845e-18,  2.489543979097186e-19, -1.146969709169694e-20,  4.695161708511463e-22, -1.733197831120024e-23,
  5.836902984076667e-25, -1.808693325421318e-26,  4.241747375061050e-14, -1.276364251620328e-14,  2.017371590405686e-15, -2.179633297437363e-16,  1.800369239526948e-17,
 -1.209518336669936e-18,  6.873397683163544e-20, -3.394451287588572e-21,  1.485796118151944e-22, -5.851137973045743e-24,  2.097548033432588e-25, -6.903985860115287e-27,
  7.644351599676782e-15, -2.482789325192332e-15,  4.242473203271957e-16, -4.945204339032144e-17,  4.395292147504829e-18, -3.168891915576211e-19,  1.927618305281047e-20,
 -1.016521494767586e-21,  4.740293816281169e-23, -1.984464722889401e-24,  7.547137125300804e-26, -2.629982637907181e-27,  1.477481030910373e-15, -5.142435482832399e-16,
  9.439982149348129e-17, -1.180284157033632e-17,  1.122710873151406e-18, -8.642624315632351e-20,  5.600376097203235e-21, -3.139140926961517e-22,  1.552685675553210e-23,
 -6.880778182227412e-25,  2.764827422584659e-26, -1.016021062872353e-27,  3.140102110866800e-16, -1.162103018708567e-16,  2.275399047310839e-17, -3.031194319106053e-18,
  3.066386388663234e-19, -2.505270089651272e-20,  1.719473701631362e-21, -1.018835068624319e-22,  5.317051227542963e-24, -2.481618117461154e-25,  1.048400663466829e-26,
 -4.043574737882483e-28,  7.514227152278079e-17, -2.931988601170562e-17,  6.073901816848058e-18, -8.554978812277929e-19,  9.136365371285160e-20, -7.866838968561070e-21,
  5.680487206948043e-22, -3.535067165575474e-23,  1.934425499025069e-24, -9.451809564538584e-26,  4.173939283888197e-27, -1.680150576035255e-28,  2.061330373240608e-17,
 -8.403287069779231e-18,  1.825181453293290e-18, -2.694302287603059e-19,  3.012189916031797e-20, -2.711371911367458e-21,  2.043769665283553e-22, -1.325820419020735e-23,
  7.552295365610966e-25, -3.836202167946880e-26,  1.758869583547723e-27, -7.341095865900604e-29,  6.499526742898098e-18, -2.741583418063144e-18,  6.180969423362151e-19,
 -9.469503617825850e-20,  1.097794443631319e-20, -1.023588702869290e-21,  7.983301102931010e-23, -5.352614844248403e-24,  3.147874597460904e-25, -1.649064509542788e-26,
  7.789754777143533e-28, -3.346142995648155e-29,  2.261381198084711e-18, -9.770030279143207e-19,  2.261677091393787e-19, -3.557676000399338e-20,  4.232302138335260e-21,
 -4.046497143648526e-22,  3.233668239282365e-23, -2.219713498887058e-24,  1.335458969433773e-25, -7.151647531559726e-27,  3.450889813891046e-28, -1.513074885191328e-29,
  6.894383673832156e-19, -3.018921175327825e-19,  7.093594409208924e-20, -1.132626679264184e-20,  1.367247348055102e-21, -1.325936989159052e-22,  1.074292145735508e-23,
 -7.473344979567500e-25,  4.554599404253178e-26, -2.469688925894650e-27,  1.206158333537586e-28, -5.350357888424091e-30,  7.051608867646442e-02, -2.064856301157834e-04,
  6.285782943870940e-07, -1.976203015083001e-09,  6.363220462036404e-12, -2.083953590346143e-14,  6.892277408565722e-17, -2.294731478253572e-19,  7.648195161812487e-22,
 -2.555639097168457e-24,  8.499856136817759e-27, -2.837721390783416e-29,  6.383597252707125e-02, -2.315122780496824e-04,  1.017461697067603e-06, -4.680106183124446e-09,
  2.133235502938147e-11, -9.520993678900968e-14,  4.160872833895613e-16, -1.785430395113009e-18,  7.540220762927161e-21, -3.141319999314644e-23,  1.292688894826240e-25,
 -5.263128657234418e-28,  5.231716508563387e-02, -2.630451141887201e-04,  1.646676919912977e-06, -9.899733794877479e-09,  5.636125202061483e-11, -3.075174090405425e-13,
  1.622692868208557e-15, -8.329885238911044e-18,  4.176725624018917e-20, -2.051798422872747e-22,  9.898064767874655e-25, -4.697803561769192e-27,  3.882167262640963e-02,
 -2.772042748177836e-04,  2.272633992993915e-06, -1.677518598471298e-08,  1.149118293438505e-10, -7.454986497442347e-13,  4.632159266276637e-15, -2.776766619475146e-17,
  1.614384017216691e-19, -9.139454150529800e-22,  5.054078227664164e-24, -2.736817944034763e-26,  2.608759856570765e-02, -2.602836089455458e-04,  2.655025966962138e-06,
 -2.350891661931315e-08,  1.904772080421267e-10, -1.444985611417609e-12,  1.040034385784489e-14, -7.166588342414893e-17,  4.758872125361255e-19, -3.060304973723343e-21,
  1.913207910219447e-23, -1.166295125745997e-25,  1.587945348992179e-02, -2.152583620138573e-04,  2.660932349168150e-06, -2.790386710585819e-08,  2.640748992546145e-10,
 -2.313813473553195e-12,  1.906741568268630e-14, -1.493739402449213e-16,  1.121062395084748e-18, -8.107152441266019e-21,  5.674623489870812e-23, -3.858019279893135e-25,
  8.758506391541999e-03, -1.567577172168375e-04,  2.314654157189680e-06, -2.846696062932735e-08,  3.115573820251637e-10, -3.123735627783054e-12,  2.921731711036225e-14,
 -2.580910756128885e-16,  2.172157581122459e-18, -1.753272063497695e-20,  1.364122480653400e-22, -1.027145958363522e-24,  4.379426478573314e-03, -1.008568357985217e-04,
  1.762363647632365e-06, -2.521117856344980e-08,  3.165799721210467e-10, -3.605805804626374e-12,  3.802166700123748e-14, -3.763012003393286e-16,  3.529977403959209e-18,
 -3.161659293814132e-20,  2.719040642423371e-22, -2.255223975057879e-24,  1.986350080976008e-03, -5.756960522912503e-05,  1.181934976458348e-06, -1.952831383648126e-08,
  2.795510362254666e-10, -3.596062278294109e-12,  4.251647357007823e-14, -4.690357967654656e-16,  4.880243972208904e-18, -4.827713763799312e-20,  4.568645080472728e-22,
 -4.155959276386001e-24,  8.178564436401877e-04, -2.927291106352395e-05,  7.017147348079696e-07, -1.330968658166828e-08,  2.160534620346154e-10, -3.123799342643725e-12,
  4.122624665926939e-14, -5.048259578125178e-16,  5.802877152291602e-18, -6.316010676909755e-20,  6.553005654760375e-22, -6.514706604834087e-24,  3.059864190020152e-04,
 -1.331007132391155e-05,  3.703963477623105e-07, -8.022804414735720e-09,  1.470150134277671e-10, -2.379470297936115e-12,  3.492276221023147e-14, -4.730148423731805e-16,
  5.986899292684671e-18, -7.147024749077890e-20,  8.105004450301914e-22, -8.780145404127262e-24,  1.041508205733418e-04, -5.431188581493860e-06,  1.745095215157800e-07,
 -4.296641863475400e-09,  8.853604295501547e-11, -1.598570892331443e-12,  2.600879861807634e-14, -3.885079369601130e-16,  5.399320801143401e-18, -7.050663150022544e-20,
  8.717234790766037e-22, -1.026479340221506e-23,  3.230180477539111e-05, -1.995813138071257e-06,  7.366484404119440e-08, -2.053248667553342e-09,  4.741428986897985e-11,
 -9.521618497358415e-13,  1.712673323376591e-14, -2.814288391295179e-16,  4.284360016496614e-18, -6.106065911045033e-20,  8.212768838401317e-22, -1.049000497682722e-23,
  9.145982901490927e-06, -6.627955080135677e-07,  2.796678421118994e-08, -8.792077565965926e-10,  2.268405379926839e-11, -5.053199238869982e-13,  1.002474879169110e-14,
 -1.808134534449759e-16,  3.009090315719417e-18, -4.671443363609201e-20,  6.822621299772841e-22, -9.435689542443778e-24,  2.369822131878343e-06, -1.996535735031248e-07,
  9.587254619478505e-09, -3.388027246813841e-10,  9.739827420623911e-12, -2.401155987859082e-13,  5.242753541728735e-15, -1.035966340867076e-16,  1.881307681363042e-18,
 -3.176010139765904e-20,  5.028678080980843e-22, -7.518615102702562e-24,  5.636093176059415e-07, -5.477256564642855e-08,  2.980469834508634e-09, -1.180287084580745e-10,
  3.771220676397596e-12, -1.026716485510271e-13,  2.462658835191784e-15, -5.322020354784852e-17,  1.052959805840335e-18, -1.930155085794933e-20,  3.308411619530267e-22,
 -5.340376590384423e-24,  1.234873508026939e-07, -1.374703145498436e-08,  8.442924290319224e-10, -3.735761432131798e-11,  1.323593605300637e-12, -3.971655688336303e-14,
  1.044703332989443e-15, -2.465340562438282e-17,  5.306538648053512e-19, -1.054792955881677e-20,  1.954774755707422e-22, -3.402399530353707e-24,  2.503982042888320e-08,
 -3.173125810426523e-09,  2.191206944241441e-10, -1.080314289904367e-11,  4.234988156364648e-13, -1.398030055638571e-14,  4.026306391026562e-16, -1.036036161915107e-17,
  2.422882263720401e-19, -5.215854152019790e-21,  1.043872341231558e-22, -1.956961145787648e-24,  4.725480712011588e-09, -6.777388247287370e-10,  5.243151113815198e-11,
 -2.872623766281144e-12,  1.243323928621050e-13, -4.507365441273853e-15,  1.419088271328822e-16, -3.976120012717746e-18,  1.008993712676789e-19, -2.349658769235536e-21,
  5.072628937031660e-23, -1.023167717986970e-24,  8.357257701954470e-10, -1.349248420556473e-10,  1.165266152420111e-11, -7.076012462995955e-13,  3.374290048035962e-14,
 -1.340991460478669e-15,  4.608284234267349e-17, -1.404014709338485e-18,  3.861208772327528e-20, -9.715189902413941e-22,  2.259968097445308e-23, -4.899251954254592e-25,
  1.396847303959847e-10, -2.525473083642714e-11,  2.426424881860520e-12, -1.628757208224414e-13,  8.538957199088478e-15, -3.713321576426062e-16,  1.390624306805880e-17,
 -4.600469396693399e-19,  1.369321022855303e-20, -3.718020889129133e-22,  9.308525871608877e-24, -2.166387531222340e-25,  2.229258436986696e-11, -4.490756534651313e-12,
  4.783064495496155e-13, -3.539412215531466e-14,  2.035409972718536e-15, -9.666757993520118e-17,  3.938375758889697e-18, -1.412522391598167e-19,  4.543895251859363e-21,
 -1.329630742779636e-22,  3.578208329194659e-24, -8.929264589004477e-26,  3.439469564012483e-12, -7.680765179590612e-13,  9.035857595857738e-14, -7.349582986260507e-15,
  4.624755950476355e-16, -2.393641322244315e-17,  1.058894223110288e-18, -4.110144101560447e-20,  1.426640640976852e-21, -4.492102510532504e-23,  1.297531017998487e-24,
 -3.466986515044109e-26,  5.207311660095200e-13, -1.282333761767880e-13,  1.659803903716740e-14, -1.479215970089310e-15,  1.015709078950310e-16, -5.715081155677147e-18,
  2.739135979034112e-19, -1.148310407144430e-20,  4.292531831018513e-22, -1.451768984128450e-23,  4.493147930858335e-25, -1.283351028063838e-26,  7.874256851124176e-14,
 -2.126505445544034e-14,  3.015568685722569e-15, -2.934049597871912e-16,  2.191524159880254e-17, -1.336737283683883e-18,  6.923085522894363e-20, -3.127009073269066e-21,
  1.255982680888379e-22, -4.552698877451900e-24,  1.506603496297248e-25, -4.590653579564733e-27,  1.214138088415560e-14, -3.574430409041103e-15,  5.527086232716100e-16,
 -5.846953265355474e-17,  4.733082983981505e-18, -3.119033479407885e-19,  1.740080608781641e-20, -8.443024901946483e-22,  3.633580891895289e-23, -1.407854738378116e-24,
  4.968741674562575e-26, -1.611087982409026e-27,  1.954753062169236e-15, -6.232876845128617e-16,  1.045255492514140e-16, -1.196483042621924e-17,  1.045084040095967e-18,
 -7.410267283168047e-20,  4.436267438305244e-21, -2.303948652879763e-22,  1.058747356882322e-23, -4.370343347272493e-25,  1.639751438535426e-26, -5.640355724378080e-28,
  3.373986833283802e-16, -1.156885170553214e-16,  2.091113281318296e-17, -2.575500343759002e-18,  2.414686433726159e-19, -1.833212888153585e-20,  1.172216852958546e-21,
 -6.487271723009976e-23,  3.169708372841662e-24, -1.388254155810728e-25,  5.515618225388220e-27, -2.005029666602842e-28,  6.420951605132030e-17, -2.348924387617256e-17,
  4.543662734640495e-18, -5.981419515032987e-19,  5.981945115422515e-20, -4.833816723806761e-21,  3.282793547254690e-22, -1.925525371574896e-23,  9.951523789535108e-25,
 -4.601442707753291e-26,  1.926569989573067e-27, -7.366807395873091e-29,  1.384812119985743e-17, -5.358166148658364e-18,  1.100107506876617e-18, -1.535916977380341e-19,
  1.626408011684904e-20, -1.389000298017682e-21,  9.951138852969526e-23, -6.146176741526572e-24,  3.338943190934682e-25, -1.620112064160321e-26,  7.106678671741086e-28,
 -2.842348911810853e-29,  3.461373057137084e-18, -1.403213113813983e-18,  3.029446353039148e-19, -4.445493674300883e-20,  4.941412822171816e-21, -4.423265252803691e-22,
  3.316366729986385e-23, -2.140335156534398e-24,  1.213190890748483e-25, -6.133208336819172e-27,  2.799207777947173e-28, -1.163209707613534e-29,  1.010147635788894e-18,
 -4.247075244997885e-19,  9.541143176439389e-20, -1.456596502029341e-20,  1.682843856668839e-21, -1.563902142896681e-22,  1.215850437975966e-23, -8.126973777687543e-25,
  4.765359276575365e-26, -2.489312852925527e-27,  1.172669052485973e-28, -5.024042453947155e-30,  3.319498057749668e-19, -1.431927797141880e-19,  3.309117725927924e-20,
 -5.196449168704347e-21,  6.171536500483953e-22, -5.891072142114072e-23,  4.700373007765081e-24, -3.221653385472810e-25,  1.935442205914647e-26, -1.035012331520819e-27,
  4.987483201484575e-29, -2.183954668539105e-30,  9.790655479095738e-20, -4.284714343995481e-20,  1.006145413614351e-20, -1.605474656024447e-21,  1.936823468914044e-22,
 -1.877145850919314e-23,  1.519974325501697e-24, -1.056754984316169e-25,  6.436674501617260e-27, -3.488287224634566e-28,  1.702704490275231e-29, -7.549002957854222e-31,
  6.970005561971912e-02, -2.015501618122732e-04,  6.054612585549460e-07, -1.877638074031973e-09,  5.962464705205190e-12, -1.925980943949963e-14,  6.282678803676772e-17,
 -2.064077179492607e-19,  6.786471216005023e-22, -2.239350075821389e-24,  7.344635861091408e-27, -2.425055778007104e-29,  6.292585511911922e-02, -2.235915684458157e-04,
  9.632872026570641e-07, -4.353496034524208e-09,  1.952410448938430e-11, -8.579749150096116e-14,  3.693101041386893e-16, -1.561282943780816e-18,  6.497099801046423e-21,
 -2.667714037205113e-23,  1.082035410587911e-25, -4.343311775503491e-28,  5.129060012313520e-02, -2.503320098529921e-04,  1.533094477011758e-06, -9.045117224592391e-09,
  5.058221049624138e-11, -2.712271528320752e-13,  1.407109604282764e-15, -7.104261803495594e-18,  3.504632000138855e-20, -1.694291807490247e-22,  8.045531747179259e-25,
 -3.759617212097335e-27,  3.774798543693816e-02, -2.597982509688788e-04,  2.081890136093387e-06, -1.505009038522551e-08,  1.010534903567712e-10, -6.431020645822980e-13,
  3.922307858489490e-15, -2.309129043593861e-17,  1.319028042987892e-19, -7.339452349307556e-22,  3.990430053589316e-24, -2.125096375989160e-26,  2.508722822223752e-02,
 -2.401221309392572e-04,  2.390293227661989e-06, -2.067956949371284e-08,  1.639195199771502e-10, -1.217833043001988e-12,  8.591331875180623e-15, -5.806200817331837e-17,
  3.783387186340119e-19, -2.388545010820743e-21,  1.466534728580481e-23, -8.783129173578573e-26,  1.505897122865039e-02, -1.952418227016775e-04,  2.349986840911237e-06,
 -2.402536737771508e-08,  2.220558899957779e-10, -1.902586177403161e-12,  1.534624649740711e-14, -1.177627456199679e-16,  8.662784659192867e-19, -6.143575934697996e-21,
  4.219053572411574e-23, -2.815425009188481e-25,  8.166460175838098e-03, -1.395266666600119e-04,  2.001015497871842e-06, -2.394606366690358e-08,  2.555477238445383e-10,
 -2.501931731601170e-12,  2.287603215908143e-14, -1.977102143404523e-16,  1.629201868665142e-18, -1.288323329536934e-20,  9.825399252096703e-23, -7.255259750463972e-25,
  4.002395629984284e-03, -8.788712903879839e-05,  1.487992690384986e-06, -2.067661319385816e-08,  2.527973689501112e-10, -2.807939786508110e-12,  2.890946652976616e-14,
 -2.796337801423814e-16,  2.565785267186469e-18, -2.249337221955829e-20,  1.894539553832252e-22, -1.539763074205208e-24,  1.773599037081498e-03, -4.898057336175077e-05,
  9.722268195938416e-07, -1.557959286613833e-08,  2.168547907993514e-10, -2.717104090170280e-12,  3.133176085708761e-14, -3.374776723425911e-16,  3.431439035658917e-18,
 -3.319701143241231e-20,  3.074337386121164e-22, -2.738379723702790e-24,  7.110578159937610e-04, -2.424371292073574e-05,  5.608397821936520e-07, -1.030333372381366e-08,
  1.624269745001846e-10, -2.284940800977723e-12,  2.938204783822494e-14, -3.509672656220169e-16,  3.939138316773625e-18, -4.189755573288236e-20,  4.250921619728203e-22,
 -4.135312439596287e-24,  2.581147746444197e-04, -1.069534887343786e-05,  2.868017706816205e-07, -6.009882172614613e-09,  1.068368257843981e-10, -1.680779427140488e-12,
  2.401426500512115e-14, -3.170287988649762e-16,  3.915021575179074e-18, -4.564007662562760e-20,  5.058186687104213e-22, -5.358694960818449e-24,  8.492272487472280e-05,
 -4.219495929749168e-06,  1.304947622718631e-07, -3.105296218654041e-09,  6.201736154073193e-11, -1.087499377211133e-12,  1.721119556183690e-14, -2.504062002595955e-16,
  3.393196111332078e-18, -4.324419963011724e-20,  5.222243245126904e-22, -6.010679422047718e-24,  2.535760959097440e-05, -1.493468076725903e-06,  5.301484620659244e-08,
 -1.427057095826837e-09,  3.191539421118186e-11, -6.220130516276151e-13,  1.087611887225003e-14, -1.739651025902383e-16,  2.580864053976857e-18, -3.587975924006214e-20,
  4.711478750271497e-22, -5.879696664822144e-24,  6.883245078328076e-06, -4.757841154160985e-07,  1.929852163453420e-08, -5.855855948577915e-10,  1.462377622009361e-11,
 -3.159823309775173e-13,  6.090543340019429e-15, -1.068808799032501e-16,  1.732606279953313e-18, -2.622713836476559e-20,  3.738287754599755e-22, -5.049682598500436e-24,
  1.702164328339662e-06, -1.368938358485691e-07,  6.317887324347031e-09, -2.154235646379443e-10,  5.991952196053845e-12, -1.432273505506120e-13,  3.037318192743679e-15,
 -5.837323797599911e-17,  1.032254134215583e-18, -1.698713622997764e-20,  2.624236593867754e-22, -3.831406618502196e-24,  3.845023003663245e-07, -3.570587345177397e-08,
  1.867565746710571e-09, -7.135089763774573e-11,  2.205374870939401e-12, -5.820328082112554e-14,  1.355610500840968e-15, -2.848777841073120e-17,  5.487502265480186e-19,
 -9.803883261525194e-21,  1.639372541000464e-22, -2.583765447749590e-24,  7.960727176466619e-08, -8.478397633865118e-09,  5.006989262366720e-10, -2.137666667920565e-11,
  7.326807400356659e-13, -2.131175513451732e-14,  5.443252568385635e-16, -1.249043698586385e-17,  2.617460052928889e-19, -5.070741496520019e-21,  9.167526477458847e-23,
 -1.558011297149123e-24,  1.517058434422878e-08, -1.841790997994710e-09,  1.223766949141753e-10, -5.823816811134015e-12,  2.209114008658579e-13, -7.070509546316247e-15,
  1.977541123865882e-16, -4.948677903209804e-18,  1.126868789250536e-19, -2.364623197601817e-21,  4.617405232745332e-23, -8.453377743874990e-25,  2.675134473165571e-09,
 -3.681675770663160e-10,  2.743093565117608e-11, -1.451602359094589e-12,  6.082405550046019e-14, -2.138748096930756e-15,  6.541648475661879e-17, -1.783105755084643e-18,
  4.407277759294767e-20, -1.000729374934771e-21,  2.108592334827552e-23, -4.154692443588439e-25,  4.393827560862892e-10, -6.819566210825346e-11,  5.679096679887580e-12,
 -3.333956954124286e-13,  1.540285052667407e-14, -5.941172036586060e-16,  1.984633302737739e-17, -5.885568934525416e-19,  1.577351736818641e-20, -3.871710565964733e-22,
  8.794540511088100e-24, -1.863299382460029e-25,  6.777049699161261e-11, -1.180398890513258e-11,  1.095193693149061e-12, -7.115701947384063e-14,  3.617900989216571e-15,
 -1.528393397653055e-16,  5.568481292041335e-18, -1.794488045259869e-19,  5.208957791983162e-21, -1.380733911413279e-22,  3.377812283348122e-24, -7.688188670665882e-26,
  9.915502668107373e-12, -1.928806432796090e-12,  1.987422349376451e-13, -1.425611124429580e-14,  7.961226294549020e-16, -3.677409668586307e-17,  1.459168266697565e-18,
 -5.103150867973719e-20,  1.602505859264047e-21, -4.582039723066681e-23,  1.205980230704152e-24, -2.945803901155393e-26,  1.393268023270275e-12, -3.012297361453628e-13,
  3.435463173025522e-14, -2.713603397050930e-15,  1.660842891486107e-16, -8.372781549925946e-18,  3.612295200149585e-19, -1.368991487477867e-20,  4.644268167801835e-22,
 -1.430597411495023e-23,  4.045970314255289e-25, -1.059367447426142e-26,  1.908710902274128e-13, -4.563806989661805e-14,  5.740443025775134e-15, -4.978578807805376e-16,
  3.331433207732355e-17, -1.829039733304562e-18,  8.563525279881816e-20, -3.510668588772333e-21,  1.284544050492968e-22, -4.256149733406105e-24,  1.291525971102158e-25,
 -3.619630023773483e-27,  2.596077780404470e-14, -6.828596126386500e-15,  9.435521898556100e-16, -8.955739821522157e-17,  6.533329052968585e-18, -3.896482459141331e-19,
  1.975195942351941e-20, -8.740419296185228e-22,  3.442352874691020e-23, -1.224492782461791e-24,  3.979451666525901e-26, -1.191639931314675e-27,  3.582199602737854e-15,
 -1.030613913426316e-15,  1.557425219054698e-16, -1.611603058696088e-17,  1.277386112399936e-18, -8.250174955986381e-20,  4.515083219985896e-21, -2.150839256226527e-22,
  9.094781283604157e-24, -3.464759733303157e-25,  1.203118882203417e-26, -3.840685242387216e-28,  5.142655303244408e-16, -1.608092953707967e-16,  2.643989784689086e-17,
 -2.969300899819952e-18,  2.546591026232091e-19, -1.774387009806102e-20,  1.044641735995285e-21, -5.339074210882767e-23,  2.416113252425080e-24, -9.827472035059600e-26,
  3.635447896329965e-27, -1.233636059165892e-28,  7.904278689856995e-17, -2.667400761610795e-17,  4.743031406453266e-18, -5.749479392054724e-19,  5.308704389668460e-20,
 -3.971727693688241e-21,  2.504271865210449e-22, -1.367404042783712e-23,  6.595610548743208e-25, -2.853192541793432e-26,  1.120198166000885e-27, -4.025960345381658e-29,
  1.341827952399911e-17, -4.848202127272796e-18,  9.257454263040218e-19, -1.203369392854223e-19,  1.188906850423710e-20, -9.495519902218141e-22,  6.376814190029360e-23,
 -3.700333137065363e-24,  1.892789247790734e-25, -8.665773133398232e-27,  3.593920256654374e-28, -1.361765405746405e-29,  2.596359228467754e-18, -9.955457413183319e-19,
  2.024479399361129e-19, -2.800003319730614e-20,  2.938137687878665e-21, -2.487418719125941e-22,  1.767156267420555e-23, -1.082703799895236e-24,  5.836554413390626e-26,
 -2.811053386427377e-27,  1.224317739150847e-28, -4.863351336632389e-30,  5.884251450333204e-19, -2.371082541181994e-19,  5.085901714463089e-20, -7.415603579149585e-21,
  8.191943781009943e-22, -7.289323849348423e-23,  5.433950732407704e-24, -3.487722956299026e-25,  1.966486157226026e-26, -9.891027405627233e-28,  4.492281048601458e-29,
 -1.858039981498890e-30,  1.581955257476309e-19, -6.627793898254285e-20,  1.483241489497370e-20, -2.255792171180502e-21,  2.596566795675893e-22, -2.404456926686687e-23,
  1.862931427619852e-24, -1.241113774253251e-25,  7.254364476623599e-27, -3.777956834313749e-28,  1.774505240067429e-29, -7.581077987504479e-31,  4.891167607554381e-20,
 -2.106369012000183e-20,  4.858746872859196e-21, -7.615891990194202e-22,  9.028783382659081e-23, -8.603528509329854e-24,  6.853092549983094e-25, -4.689544772104825e-26,
  2.812902255061994e-27, -1.501988560691035e-28,  7.227238405618533e-30, -3.160299898431628e-31,  1.392322407743656e-20, -6.089593799489373e-21,  1.429007848699444e-21,
 -2.278677407367488e-22,  2.747131644178418e-23, -2.660749449908307e-24,  2.153108384140711e-25, -1.496011476655883e-26,  9.106686684529609e-28, -4.932378563805744e-29,
  2.406221768800968e-30, -1.066216846196199e-31,  6.890340190376187e-02, -1.967950053332088e-04,  5.834895469195460e-07, -1.785240203913280e-09,  5.591891186519263e-12,
 -1.781893804489645e-14,  5.733967896133344e-17, -1.859261975711280e-19,  6.030712858486735e-22, -1.965839494193191e-24,  6.356171065362570e-27, -2.077825017541759e-29,
  6.204657790405109e-02, -2.160890554333015e-04,  9.128644582764260e-07, -4.054370832775128e-09,  1.789336585266532e-11, -7.743600498057994e-14,  3.283662517127876e-16,
 -1.367942423102772e-18,  5.610236643593945e-21, -2.270804082926861e-23,  9.079682406294796e-26, -3.593969055829724e-28,  5.031313306109397e-02, -2.384880619734233e-04,
  1.429235716773628e-06, -8.277428752839048e-09,  4.547989309222991e-11, -2.397222483812995e-13,  1.223016552389950e-15, -6.074469128068963e-18,  2.948840458235650e-20,
 -1.403248226009931e-22,  6.560540914467946e-25, -3.018970592203266e-27,  3.674099642470302e-02, -2.438389930121808e-04,  1.910581726355903e-06, -1.353122773061410e-08,
  8.908279717345485e-11, -5.562717452019587e-13,  3.331081554629281e-15, -1.926408624196650e-17,  1.081420819000143e-19, -5.915599766578504e-22,  3.162894326254406e-24,
 -1.656879051154428e-26,  2.416347333585546e-02, -2.219495993123825e-04,  2.157105734431471e-06, -1.824103648051940e-08,  1.414998415302705e-10, -1.029857424202335e-12,
  7.122930029720271e-15, -4.722490035935538e-17,  3.020411101761814e-19, -1.872471501774006e-21,  1.129370792472538e-23, -6.646629023249209e-26,  1.431385941330742e-02,
 -1.775375136698333e-04,  2.081805980418344e-06, -2.075794267286826e-08,  1.874355420662964e-10, -1.570905368679982e-12,  1.240592240653894e-14, -9.327759062910659e-17,
  6.727218997266310e-19, -4.679865262309172e-21,  3.153965058057544e-23, -2.066274531393998e-25,  7.638643206010257e-03, -1.246020628150423e-04,  1.736635769620532e-06,
 -2.022956026213928e-08,  2.105796521534393e-10, -2.013849295571943e-12,  1.800537126376452e-14, -1.522962804379005e-16,  1.229077491519522e-18, -9.524285988962243e-21,
  7.121729207920037e-23, -5.158390696663031e-25,  3.673175314527411e-03, -7.691093978261060e-05,  1.262403860870961e-06, -1.704593199960074e-08,  2.029875904868190e-10,
 -2.199490691030625e-12,  2.211716583346502e-14, -2.091451871627781e-16,  1.877543420157559e-18, -1.611486416581088e-20,  1.329628722707730e-22, -1.059152169802072e-24,
  1.592126466801789e-03, -4.189547440560983e-05,  8.044205514315164e-07, -1.250679915612646e-08,  1.693266642632506e-10, -2.067151143782404e-12,  2.325565640241450e-14,
 -2.446368795727047e-16,  2.431441120570453e-18, -2.301008103180636e-20,  2.085840089138606e-22, -1.819618323391310e-24,  6.223314349092054e-04, -2.021061433615826e-05,
  4.514002666886029e-07, -8.034880175849079e-09,  1.230519573024251e-10, -1.684737326047482e-12,  2.111443463549917e-14, -2.460917652992039e-16,  2.697581273030243e-18,
 -2.804491161897127e-20,  2.783197719646385e-22, -2.649928711399006e-24,  2.195033526625295e-04, -8.662714784745474e-06,  2.239239684624997e-07, -4.540884642534246e-09,
  7.833283506620754e-11, -1.198191211392630e-12,  1.666976337417935e-14, -2.145507529267272e-16,  2.585685677827005e-18, -2.944240670734498e-20,  3.189582043550829e-22,
 -3.305220304099053e-24,  6.991846040167370e-05, -3.309241512119626e-06,  9.853380516382821e-08, -2.266755156569866e-09,  4.388793402869778e-11, -7.476035546146619e-13,
  1.151193708617643e-14, -1.631672345120564e-16,  2.156315886142553e-18, -2.682534669898822e-20,  3.164728075192441e-22, -3.561023024430145e-24,  2.013463427953632e-05,
 -1.130027967630777e-06,  3.858529906012396e-08, -1.003252765353617e-09,  2.173445159302161e-11, -4.111810511805673e-13,  6.990409800136643e-15, -1.088593032668465e-16,
  1.574094102615151e-18, -2.134992540435446e-20,  2.737487207564305e-22, -3.338303356136065e-24,  5.249422100702715e-06, -3.459597075864443e-07,  1.349002379539351e-08,
 -3.951353080976137e-10,  9.552474831149246e-12, -2.002352309408086e-13,  3.750449287137459e-15, -6.404355705016583e-17,  1.011415024265038e-18, -1.493039308639511e-20,
  2.077146793805108e-22, -2.740795681169272e-24,  1.241346221050773e-06, -9.525574011384923e-08,  4.224960323659369e-09, -1.390031865817306e-10,  3.741103682721578e-12,
 -8.671252711554786e-14,  1.786116683025911e-15, -3.338943878123714e-17,  5.750134957395475e-19, -9.224836941980394e-21,  1.390547633569568e-22, -1.982637645302329e-24,
  2.668803972494253e-07, -2.366852757178355e-08,  1.189719516549450e-09, -4.384898487050268e-11,  1.311065315582821e-12, -3.354206931041268e-14,  7.586133683791419e-16,
 -1.550270228085322e-17,  2.907481879701258e-19, -5.062858215801386e-21,  8.259217262690212e-23, -1.271005154330063e-24,  5.232404158978478e-08, -5.327907408204029e-09,
  3.024615804410520e-10, -1.245767199182069e-11,  4.130136210295436e-13, -1.164460027425451e-14,  2.887742661517937e-16, -6.443094586517578e-18,  1.314466031906940e-19,
 -2.481773187448518e-21,  4.377037576026669e-23, -7.262974454377334e-25,  9.391355058355232e-09, -1.091511819125937e-09,  6.975411696569306e-11, -3.203320127328497e-12,
  1.175519164038956e-13, -3.647200856991502e-15,  9.905118246055149e-17, -2.410277440669109e-18,  5.343563709550752e-20, -1.092876989816270e-21,  2.081995113154725e-23,
 -3.721934990626764e-25,  1.550715417156109e-09, -2.046235062075556e-10,  1.467525511155484e-11, -7.497975069428634e-13,  3.040599612730681e-14, -1.036755817704000e-15,
  3.079971428991155e-17, -8.165600861820418e-19,  1.965462015191032e-20, -4.350756184130402e-22,  8.945736968280708e-24, -1.721571849510363e-25,  2.370339128255670e-10,
 -3.533538448493629e-11,  2.835579064485843e-12, -1.608500270584843e-13,  7.196614204989952e-15, -2.693208967740863e-16,  8.742461407051375e-18, -2.522846403190436e-19,
  6.587215132145846e-21, -1.576928848601346e-22,  3.496847943014175e-24, -7.239148802252043e-26,  3.380320402133160e-11, -5.666331538827138e-12,  5.073111173838077e-13,
 -3.188389046223173e-14,  1.571348236438099e-15, -6.445705454112674e-17,  2.283730677544617e-18, -7.166274876055301e-20,  2.027942633104333e-21, -5.245915938365507e-23,
  1.253616037590826e-24, -2.789673695793763e-26,  4.541770167928615e-12, -8.521986580183436e-13,  8.487599414895475e-14, -5.897504079872258e-15,  3.196181917019134e-16,
 -1.435098055753573e-17,  5.543048046973027e-19, -1.889426810325792e-20,  5.789307445691544e-22, -1.616815341502860e-23,  4.160214933106407e-25, -9.943235700778388e-27,
  5.819774087620060e-13, -1.216795901118883e-13,  1.344052731417171e-14, -1.030124174082437e-15,  6.127902614009930e-17, -3.007030488647332e-18,  1.264469398020117e-19,
 -4.676216126820477e-21,  1.549676692392773e-22, -4.667561914730721e-24,  1.291894672718343e-25, -3.313174564938957e-27,  7.220168756824989e-14, -1.674220694352364e-14,
  2.044327862523754e-15, -1.723871697548372e-16,  1.123224187649036e-17, -6.012779901146640e-19,  2.748179280645320e-20, -1.101021585419064e-21,  3.940929387256948e-23,
 -1.278507918434725e-24,  3.801788881265663e-26, -1.044939837712835e-27,  8.834263989888745e-15, -2.260540392581446e-15,  3.040293095232081e-16, -2.812368797313157e-17,
  2.002074048367790e-18, -1.166559303733134e-19,  5.783658847509191e-21, -2.505604940874067e-22,  9.669794190263666e-24, -3.373353883770312e-25,  1.075988477196380e-26,
 -3.164677011021183e-28,  1.090136656460204e-15, -3.061360632392289e-16,  4.516254296645465e-17, -4.566871536943446e-18,  3.541100336545833e-19, -2.239639666583553e-20,
  1.201411819285337e-21, -5.614694875419915e-23,  2.331066454898193e-24, -8.725814342381265e-26,  2.979305511404259e-27, -9.357981503553875e-29,  1.393207226103364e-16,
 -4.267499796840656e-17,  6.871940301930047e-18, -7.564166722487099e-19,  6.364045117426875e-20, -4.353731592867672e-21,  2.518670050660499e-22, -1.265869003438405e-23,
  5.637220542042531e-25, -2.257875048502570e-26,  8.229871063086038e-28, -2.753337051091500e-29,  1.901678837112430e-17, -6.309521262383917e-18,  1.102602439098746e-18,
 -1.314260455098527e-19,  1.194068404673738e-20, -8.796473099790538e-22,  5.464968901016528e-23, -2.942069275874754e-24,  1.399964877156063e-25, -5.977779256932425e-27,
  2.317801415158471e-28, -8.230870540710115e-30,  2.868938402458392e-18, -1.022914832456456e-18,  1.926421227775159e-19, -2.470670056334283e-20,  2.409580756100449e-21,
 -1.900735643014725e-22,  1.261368462573099e-23, -7.236524222839839e-25,  3.661396842152613e-26, -1.658823526058077e-27,  6.810700105507903e-29, -2.555858651300097e-30,
  4.957497752363225e-19, -1.882482852252163e-19,  3.788912953609194e-20, -5.187805615576954e-21,  5.391075425817100e-22, -4.521650675861809e-23,  3.183709217832511e-24,
 -1.933918273142355e-25,  1.033968679278215e-26, -4.940683471198431e-28,  2.135582491095287e-29, -8.421692946736004e-31,  1.013558431980144e-19, -4.057636960703686e-20,
  8.642858260574576e-21, -1.251545128795666e-21,  1.373393521164658e-22, -1.214262461180610e-23,  8.996395648329015e-25, -5.740236327212764e-26,  3.218228124490482e-27,
 -1.609918853981726e-28,  7.273775949896039e-30, -2.993457229870755e-31,  2.497819802172824e-20, -1.042505492765249e-20,  2.323372608520155e-21, -3.519032445495103e-22,
  4.034539543674897e-23, -3.721719637151324e-24,  2.872890866306316e-25, -1.907180708703873e-26,  1.110958727912630e-27, -5.766757611923416e-29,  2.700122203970033e-30,
 -1.150071226898337e-31,  7.236361171851513e-21, -3.110688220931112e-21,  7.161129201914524e-22, -1.120257324309891e-22,  1.325525981837873e-23, -1.260737800721975e-24,
  1.002425935353499e-25, -6.847658511460865e-27,  4.100522513563275e-28, -2.186003218915960e-29,  1.050223084789545e-30, -4.585520171522147e-32,  1.982976118833294e-21,
 -8.667375183281078e-22,  2.032464007263928e-22, -3.238607958042140e-23,  3.901641481628315e-24, -3.776342513634834e-25,  3.053800235076501e-26, -2.120435009151207e-27,
  1.289952260187094e-28, -6.982332985921285e-30,  3.404224540470606e-31, -1.507559446988406e-32,  6.812542414910272e-02, -1.922112861008727e-04,  5.625919629865269e-07,
 -1.698547935679352e-09,  5.248863266911633e-12, -1.650313992703737e-14,  5.239362199665832e-17, -1.677129041753065e-19,  5.366654093511562e-22, -1.728980435146987e-24,
  5.508061831446490e-27, -1.785516815303278e-29,  6.119652610076497e-02, -2.089759975555651e-04,  8.658800159358037e-07, -3.780051217602965e-09,  1.642045288763934e-11,
 -6.999528802204716e-14,  2.924591779471108e-16, -1.200823511742610e-18,  4.854483708488536e-21, -1.937352174273692e-23,  7.637468007252206e-26, -2.981811997594170e-28,
  4.938143649667001e-02, -2.274394765843854e-04,  1.334119437296462e-06, -7.586567178118712e-09,  4.096572711215300e-11, -2.123087355950417e-13,  1.065417443401208e-15,
 -5.206851239088996e-18,  2.487873763145631e-20, -1.165567396157413e-22,  5.366197922561807e-25, -2.432207208605253e-27,  3.579521451446616e-02, -2.291804258064760e-04,
  1.756405388559152e-06, -1.219073932723862e-08,  7.871507142125482e-11, -4.824263177915099e-13,  2.837099436911666e-15, -1.612121771309915e-17,  8.895790802823404e-20,
 -4.784967479594465e-22,  2.516450041040464e-24, -1.296975251354325e-26,  2.330885465707543e-02, -2.055313424238337e-04,  1.951146480015432e-06, -1.613295860276693e-08,
  1.225104813259078e-10, -8.737417939932582e-13,  5.926403416740915e-15, -3.855635359818082e-17,  2.421052037447982e-19, -1.474185560851393e-21,  8.736447933899359e-24,
 -5.053625933059826e-26,  1.363550960504973e-02, -1.618307515181269e-04,  1.849717760287394e-06, -1.799498768555919e-08,  1.587952440732128e-10, -1.302219325434550e-12,
  1.007184001691269e-14, -7.421933339438164e-17,  5.249233025313136e-19, -3.582899393955065e-21,  2.370230826635122e-23, -1.524835051770375e-25,  7.166560691063900e-03,
 -1.116256332816112e-04,  1.512839829706154e-06, -1.716039648528359e-08,  1.743002401754032e-10, -1.628745795803348e-12,  1.424383366455980e-14, -1.179434973471472e-16,
  9.324446515079005e-19, -7.082538042622215e-21,  5.193671538826439e-23, -3.690879378686412e-25,  3.384508290339717e-03, -6.757786626798041e-05,  1.075976084081350e-06,
 -1.412308371655261e-08,  1.638644947402561e-10, -1.732663778909828e-12,  1.702184876694058e-14, -1.574041708995422e-16,  1.382883266259777e-18, -1.162343771867263e-20,
  9.397189103859550e-23, -7.338446480135533e-25,  1.436525894947506e-03, -3.601733550127764e-05,  6.693222304464152e-07, -1.010017136451989e-08,  1.330525510796553e-10,
 -1.583132778544452e-12,  1.738121209463241e-14, -1.786188365105426e-16,  1.735776540346329e-18, -1.607267586658021e-20,  1.426475982542881e-22, -1.219043612332015e-24,
  5.481448186297886e-04, -1.695400919579168e-05,  3.657659497082597e-07, -6.310252143474873e-09,  9.391325527962488e-11, -1.251784631808893e-12,  1.529469468477328e-14,
 -1.739834523009019e-16,  1.863108667842821e-18, -1.893712121665248e-20,  1.838647418601383e-22, -1.713750564869674e-24,  1.881180147200313e-04, -7.069668491568338e-06,
  1.762277101161282e-07, -3.459418543407442e-09,  5.792761759397169e-11, -8.617540040790122e-13,  1.167742207469822e-14, -1.465641550076650e-16,  1.724196020083435e-18,
 -1.918081289847801e-20,  2.031570182489824e-22, -2.059626890282152e-24,  5.810123069981357e-05, -2.618883807969444e-06,  7.509726310224511e-08, -1.670576912091291e-09,
  3.136547052603499e-11, -5.191560171522204e-13,  7.779896198065553e-15, -1.074501713167491e-16,  1.385144285053795e-18, -1.682402638523569e-20,  1.939393932588434e-22,
 -2.133806564702791e-24,  1.616323079509931e-05, -8.641604681930457e-07,  2.838831764166899e-08, -7.131173558434146e-10,  1.496829292267459e-11, -2.749371964243850e-13,
  4.545549169208594e-15, -6.892996392507980e-17,  9.716616583514165e-19, -1.285989595702109e-20,  1.610321206298131e-22, -1.919240705151387e-24,  4.054696874694958e-06,
 -2.546831028155955e-07,  9.547603995581214e-09, -2.699924983682754e-10,  6.319612493211706e-12, -1.285304654941498e-13,  2.339737428245388e-15, -3.888424507993930e-17,
  5.983356751584543e-19, -8.614645756488344e-21,  1.169941060491671e-22, -1.508150078113260e-24,  9.186384988282534e-07, -6.722874011371541e-08,  2.865595978212738e-09,
 -9.097447909347786e-11,  2.369364900260597e-12, -5.325764521858621e-14,  1.065660135423541e-15, -1.937931913110683e-17,  3.250473887129462e-19, -5.084116885368328e-21,
  7.478692844730932e-23, -1.041408953014717e-24,  1.883527930623101e-07, -1.594413268152242e-08,  7.700985700163595e-10, -2.738006255296301e-11,  7.919249264677457e-13,
 -1.964097102590869e-14,  4.313743970964258e-16, -8.572824951454449e-18,  1.565477035713332e-19, -2.657050058753545e-21,  4.228868307865380e-23, -6.354501548235212e-25,
  3.504302353682513e-08, -3.409369749031814e-09,  1.860040690854605e-10, -7.389765136246167e-12,  2.369601413635370e-13, -6.475446463881831e-15,  1.559137542697006e-16,
 -3.382421717093839e-18,  6.717809421670248e-20, -1.236104703511491e-21,  2.126691860615106e-23, -3.445463125202420e-25,  5.936685534366759e-09, -6.600699731961726e-10,
  4.055525833294390e-11, -1.796763233383324e-12,  6.377664401020713e-14, -1.917914649675820e-15,  5.057146576814297e-17, -1.196505070959471e-18,  2.582382265801319e-20,
 -5.147275937056516e-22,  9.565877160868460e-24, -1.669697738438936e-25,  9.199262493238900e-10, -1.162902261307833e-10,  8.023976974992920e-12, -3.956783894450505e-13,
  1.552468263846579e-14, -5.131825356975885e-16,  1.480462855180061e-17, -3.816917284750240e-19,  8.945429417590181e-21, -1.930138671562418e-22,  3.872147889237794e-24,
 -7.277169250319213e-26,  1.311414077582701e-10, -1.875976676892692e-11,  1.449769689262378e-12, -7.942737842810142e-14,  3.440123122791090e-15, -1.248652873290279e-16,
  3.937610804717784e-18, -1.105408076727256e-19,  2.811235727641973e-21, -6.562097853686144e-23,  1.420254142171479e-24, -2.872275597645386e-26,  1.732670556000560e-11,
 -2.792409229478118e-12,  2.410694750455292e-13, -1.464713005153875e-14,  6.993566765746189e-16, -2.784364749886966e-17,  9.589646676937467e-19, -2.929136532163378e-20,
  8.078085828711837e-22, -2.038656238825520e-23,  4.757460422135558e-25, -1.034760994492975e-26,  2.141739416280776e-12, -3.872131161236568e-13,  3.724517785558871e-14,
 -2.505074794685724e-15,  1.316751468785854e-16, -5.743894871272110e-18,  2.158556549003302e-19, -7.167968853309768e-21,  2.142121057790969e-22, -5.840890973247274e-24,
  1.468736618727369e-25, -3.433577019010359e-27,  2.506447955666327e-13, -5.061890826867659e-14,  5.410201088012311e-15, -4.020208716074880e-16,  2.322745658512830e-17,
 -1.108749528375285e-18,  4.541563894704486e-20, -1.638036212172707e-21,  5.300028668540534e-23, -1.560151577836787e-24,  4.224126247043429e-26, -1.060614454188144e-27,
  2.818923077309941e-14, -6.331360528034435e-15,  7.497389291213857e-16, -6.141429371316500e-17,  3.893297368406386e-18, -2.030603151909018e-19,  9.054022390076407e-21,
 -3.542684114468932e-22,  1.239716082525018e-23, -3.935694743740989e-25,  1.146235970454960e-26, -3.088159945132505e-28,  3.104018083638004e-15, -7.717069620345633e-16,
  1.009147116045754e-16, -9.088937832521973e-18,  6.308337021435019e-19, -3.588226917868236e-20,  1.738638054218401e-21, -7.368907573887302e-23,  2.784860037632052e-24,
 -9.521853550401603e-26,  2.979127503099611e-27, -8.601335737189268e-29,  3.423987711828824e-16, -9.373777029960404e-17,  1.348497220409526e-17, -1.331200100558230e-18,
  1.008828388247710e-19, -6.242879935022254e-21,  3.279923340826060e-22, -1.502675636491450e-23,  6.121132024272962e-25, -2.249902240214323e-26,  7.548679388220705e-28,
 -2.331539051953940e-29,  3.890040790735864e-17, -1.165816181872164e-17,  1.836616670100087e-18, -1.979477199499744e-19,  1.632243559624049e-20, -1.095406552582630e-21,
  6.221887763651873e-23, -3.072741998168378e-24,  1.345591754984368e-25, -5.303481618934624e-27,  1.903481029085718e-28, -6.274556241710047e-30,  4.703573751387984e-18,
 -1.532669211706786e-18,  2.629534038834264e-19, -3.079033151248963e-20,  2.750176367580799e-21, -1.993258358942037e-22,  1.219205453727547e-23, -6.466488708066477e-25,
  3.033423448744470e-26, -1.277651687142852e-27,  4.889290768331769e-29, -1.714542410140724e-30,  6.283066862137733e-19, -2.208602898196857e-19,  4.098584427289684e-20,
 -5.181784211670884e-21,  4.984619742016758e-22, -3.880523850494469e-23,  2.542924668202978e-24, -1.441376331349248e-25,  7.208917583380655e-27, -3.230030941079239e-28,
  1.312129829561951e-29, -4.874091623860623e-31,  9.650821768150474e-20, -3.626445758088295e-20,  7.218908995274349e-21, -9.778106338681337e-22,  1.005614373289061e-22,
 -8.350662363220072e-24,  5.823790544475811e-25, -3.505359709646354e-26,  1.857758692874177e-27, -8.802642905446215e-29,  3.774286160196083e-30, -1.476924302767158e-31,
  1.770601423198378e-20, -7.038550555393358e-21,  1.487963850766238e-21, -2.138763823319461e-22,  2.330243136659173e-23, -2.046111538939918e-24,  1.505971802823840e-25,
 -9.548326161181708e-27,  5.320791335684165e-28, -2.646261445046365e-29,  1.188940567335272e-30, -4.866844046467300e-32,  3.978864681091521e-21, -1.653783767438434e-21,
  3.669179530759056e-22, -5.532823871070057e-23,  6.316121814625398e-24, -5.802320699384462e-25,  4.461170042323892e-26, -2.950269861975737e-27,  1.712278225112793e-28,
 -8.856825015844135e-30,  4.132951235124405e-31, -1.754662013480504e-32,  1.075310742054345e-21, -4.613382841558563e-22,  1.059765284789052e-22, -1.654311179763204e-23,
  1.953367019855054e-24, -1.854158090193977e-25,  1.471404363324655e-26, -1.003253530952148e-27,  5.996901004407727e-29, -3.191439703912200e-30,  1.530711882250880e-31,
 -6.672754373992638e-33,  2.828695408126856e-22, -1.235547604593242e-22,  2.895099958478647e-23, -4.609633827699205e-24,  5.549175640792237e-25, -5.367022902881386e-26,
  4.337028180509278e-27, -3.009364938365724e-28,  1.829491578298586e-29, -9.896294685612971e-31,  4.821849860940098e-32, -2.134037205224998e-33,  6.736545336950474e-02,
 -1.877906776557659e-04,  5.427026035902257e-07, -1.617139866949467e-09,  4.931004355347225e-12, -1.530015998253507e-14,  4.792902403027143e-17, -1.514944724590978e-19,
  4.782055122348585e-22, -1.523615579889087e-24,  4.778083362008304e-27, -1.539608560640164e-29,  6.037419507514191e-02, -2.022260374939629e-04,  8.220507727660811e-07,
 -3.528152974793839e-09,  1.508810192285954e-11, -6.336281461690408e-14,  2.609101384909362e-16, -1.056074290584766e-18,  4.209007091054160e-21, -1.656544992075711e-23,
  6.439386861826211e-26, -2.480392823022010e-28,  4.849246323867388e-02, -2.171198475555417e-04,  1.246877585869684e-06, -6.963743636624932e-09,  3.696389245241615e-11,
 -1.884019915050881e-13,  9.301688448819167e-16, -4.473926101271503e-18,  2.104460507594535e-20, -9.708723732839358e-23,  4.402496411308682e-25, -1.965758957350213e-27,
  3.490569809044907e-02, -2.156936376775168e-04,  1.617366340181914e-06, -1.100493470165937e-08,  6.971248335459046e-11, -4.194462374665348e-13,  2.423101162026607e-15,
 -1.353181491426027e-17,  7.341435351095522e-20, -3.883823206738013e-22,  2.009481326620715e-24, -1.019183577155479e-26,  2.251676688035111e-02, -1.906645093852294e-04,
  1.768759380196918e-06, -1.430521346977979e-08,  1.063748612754791e-10, -7.436343237617554e-13,  4.947767156307037e-15, -3.159479169405145e-17,  1.948236032580669e-19,
 -1.165436560495163e-21,  6.787813472360525e-24, -3.860065991826771e-26,  1.301647293517252e-02, -1.478554739574126e-04,  1.648203478596943e-06, -1.565015907628492e-08,
  1.350090965598684e-10, -1.083647688565375e-12,  8.210706025771506e-15, -5.931491311645400e-17,  4.115030986188139e-19, -2.756498451639838e-21,  1.790388424121996e-23,
 -1.131299612377350e-25,  6.743023217860238e-03, -1.003015643679571e-04,  1.322630160437850e-06, -1.461468305408484e-08,  1.448928240535857e-10, -1.323373090258527e-12,
  1.132350491877892e-14, -9.181359252537651e-17,  7.112597618627304e-19, -5.296812135449088e-21,  3.810096195852327e-23, -2.657155630967383e-25,  3.130398712960196e-03,
 -5.960589100161698e-05,  9.211545250313151e-07, -1.175769474617658e-08,  1.329637624742509e-10, -1.372388890540456e-12,  1.317598585319958e-14, -1.191802990683088e-16,
  1.024979676693924e-18, -8.438892250903361e-21,  6.686706384659964e-23, -5.120306342397656e-25,  1.302446190905406e-03, -3.111364270377658e-05,  5.599173809853473e-07,
 -8.203560699891493e-09,  1.051865837825146e-10, -1.220220768135806e-12,  1.307781023209714e-14, -1.313275894061776e-16,  1.248132133974916e-18, -1.131103740344786e-20,
  9.830928399341023e-23, -8.231946289178983e-25,  4.857351657459824e-04, -1.430701018902494e-05,  2.982927728945317e-07, -4.989524030692933e-09,  7.218601330167576e-11,
 -9.370160004462142e-13,  1.116466849086723e-14, -1.239877492542228e-16,  1.297393248306808e-18, -1.289578264429360e-20,  1.225252523951686e-22, -1.118221688097086e-24,
  1.624167022424186e-04, -5.811360022139109e-06,  1.397527474848132e-07, -2.656520718957356e-09,  4.319241652760798e-11, -6.250927907054100e-13,  8.252491675393015e-15,
 -1.010312846570655e-16,  1.160463865283520e-18, -1.261516490960090e-20,  1.306637737594956e-22, -1.296254818021834e-24,  4.871136902730534e-05, -2.090489928742025e-06,
  5.774905192373664e-08, -1.242588850798495e-09,  2.262952030357608e-11, -3.640434094556857e-13,  5.310481716532836e-15, -7.148520398001140e-17,  8.990984050225285e-19,
 -1.066433302010077e-20,  1.201433266676765e-22, -1.292765052365146e-24,  1.311184675837243e-05, -6.675945980664029e-07,  2.110395537321093e-08, -5.122852974657392e-10,
  1.042064041881661e-11, -1.858780544129797e-13,  2.989206964105836e-15, -4.414928175874345e-17,  6.068133885606108e-19, -7.838129536952643e-21,  9.586955870641987e-23,
 -1.116890614486591e-24,  3.170398756739422e-06, -1.897202118048274e-07,  6.838504591139935e-09, -1.867271845225022e-10,  4.232424417118908e-12, -8.353550497488817e-14,
  1.478168510838088e-15, -2.391198259861965e-17,  3.585678863091871e-19, -5.035914545372946e-21,  6.677220299253290e-23, -8.410153625136107e-25,  6.894724714090289e-07,
 -4.809904038951134e-08,  1.970255023639870e-09, -6.036156737942637e-11,  1.521443569652186e-12, -3.316837990531821e-14,  6.447944235029000e-16, -1.140806781585030e-17,
  1.863837729792544e-19, -2.842570747301231e-21,  4.080824582312742e-23, -5.550373494739434e-25,  1.350858479555276e-07, -1.090875064823755e-08,  5.062209594511002e-10,
 -1.736176298000871e-11,  4.857812232448216e-13, -1.168031553232446e-14,  2.491335020148121e-16, -4.815163083174885e-18,  8.561960814289147e-20, -1.416530140879617e-21,
  2.199658288772358e-23, -3.227625081427683e-25,  2.389949155340842e-08, -2.220258326620488e-09,  1.163813401138986e-10, -4.459467357295865e-12,  1.382993525092471e-13,
 -3.663001566680272e-15,  8.563038787110651e-17, -1.806248260288896e-18,  3.492392006676223e-20, -6.262769622421935e-22,  1.051108585017779e-23, -1.662643527886683e-25,
  3.829860557911939e-09, -4.070625014237784e-10,  2.403693718926985e-11, -1.027164727382252e-12,  3.526035074159960e-14, -1.027645055931656e-15,  2.630613405093327e-17,
 -6.051111513768551e-19,  1.271318617276056e-20, -2.469456510911049e-22,  4.476743940891147e-24, -7.629114883313051e-26,  5.581489900708875e-10, -6.753880534131533e-11,
  4.481352095410321e-12, -2.132120277951514e-13,  8.091838475619623e-15, -2.592619916709892e-16,  7.261791561589612e-18, -1.820394005935642e-19,  4.153405594604659e-21,
 -8.734167989701263e-23,  1.709395150076044e-24, -3.136907051966495e-26,  7.436938667875263e-11, -1.019941409463022e-11,  7.586251535846731e-13, -4.012321074430621e-14,
  1.681663631577768e-15, -5.918338537371106e-17,  1.812598124379795e-18, -4.949015301740944e-20,  1.225631561352064e-21, -2.789006806801492e-23,  5.890406116607648e-25,
 -1.163513425199539e-26,  9.122521491080893e-12, -1.412086298148952e-12,  1.174639498638477e-13, -6.895768600988689e-15,  3.188367634780089e-16, -1.231534390389465e-17,
  4.121596305549403e-19, -1.225025818317101e-20,  3.291437736776000e-22, -8.101475808249518e-24,  1.845707265669442e-25, -3.922727509116491e-27,  1.039425628220691e-12,
 -1.808713911329154e-13,  1.678826783379602e-14, -1.092264434253839e-15,  5.565144169837985e-17, -2.357254784927558e-18,  8.614889171678671e-20, -2.785776883921725e-21,
  8.116543339068102e-23, -2.159947796774045e-24,  5.305932059502664e-26, -1.212847768187983e-27,  1.112808010815828e-13, -2.168238991403749e-14,  2.240289818094298e-15,
 -1.612714194354626e-16,  9.043563503159421e-18, -4.196685543900963e-19,  1.673526783771051e-20, -5.883744818905922e-22,  1.857816966096481e-23, -5.342315407121779e-25,
  1.414299458471061e-26, -3.475222791612503e-28,  1.135973952964608e-14, -2.468272880981516e-15,  2.831627741913034e-16, -2.251198099631196e-17,  1.387405695762873e-18,
 -7.045250306412342e-20,  3.062468260031988e-21, -1.169592899190898e-22,  3.999083012885815e-24, -1.241700837180852e-25,  3.540076494492037e-27, -9.344285664715131e-29,
  1.126442024090546e-15, -2.717495405677746e-16,  3.451392470527573e-17, -3.023661734713437e-18,  2.044314569535140e-19, -1.134231900215320e-20,  5.367119659010171e-22,
 -2.223911066210902e-23,  8.224882313921759e-25, -2.754566362187468e-26,  8.448667592027222e-28, -2.393191320294228e-29,  1.110583815560495e-16, -2.960235492100731e-17,
  4.148020814514549e-18, -3.993400091613605e-19,  2.955051602696996e-20, -1.787661952264473e-21,  9.191363083224068e-23, -4.124978715007040e-24,  1.647472690687605e-25,
 -5.942091814414327e-27,  1.957799797553955e-28, -5.942661634565921e-30,  1.120381522328251e-17, -3.281112267636263e-18,  5.051271001681424e-19, -5.325159682972680e-20,
  4.299457087646840e-21, -2.828000215755749e-22,  1.575803677835350e-23, -7.641048557184359e-25,  3.287992775903179e-26, -1.274348607598849e-27,  4.500721341628275e-29,
 -1.460866841994012e-30,  1.197271726211774e-18, -3.827151797704346e-19,  6.439398596453943e-20, -7.399778609760236e-21,  6.491693698711816e-22, -4.624936899328401e-23,
  2.782900340593363e-24, -1.453050635694353e-25,  6.714738149844262e-27, -2.787824438499229e-28,  1.052231151586424e-29, -3.641460704431667e-31,  1.411105898523235e-19,
 -4.885380075263576e-20,  8.924792449745761e-21, -1.111295653847359e-21,  1.053505701165448e-22, -8.087687472416905e-24,  5.229519874656304e-25, -2.926519668820963e-26,
  1.445861499988256e-27, -6.402779449190392e-29,  2.571894968282557e-30, -9.451290884341432e-32,  1.917670743335071e-20, -7.125069548592365e-21,  1.401642121164081e-21,
 -1.876732401684927e-22,  1.908756289068648e-23, -1.568237860849734e-24,  1.082594584751484e-25, -6.452837309545979e-27,  3.388011080799502e-28, -1.591020042191001e-29,
  6.763394273843415e-31, -2.624912519237349e-32,  3.140041836228910e-21, -1.238749207924770e-21,  2.597517949832193e-22, -3.703919248995030e-23,  4.004548583966394e-24,
 -3.490345504230632e-25,  2.550796414952070e-26, -1.606330564440565e-27,  8.893155352098743e-29, -4.395432284389951e-30,  1.963041154347802e-31, -7.989665966852171e-33,
  6.398619815890365e-22, -2.647607736519819e-22,  5.845626899710230e-23, -8.772530480389663e-24,  9.968071242382489e-25, -9.116352830536297e-26,  6.979178790113887e-27,
 -4.596519780717070e-28,  2.657213483536451e-29, -1.369255719604077e-30,  6.366306310318787e-32, -2.693447815392998e-33,  1.605484622972355e-22, -6.873356257749451e-23,
  1.575240410013575e-23, -2.453296242776128e-24,  2.890282978289866e-25, -2.737540818451295e-26,  2.167893724880551e-27, -1.475173572532671e-28,  8.800738495643353e-30,
 -4.674882787862261e-31,  2.238205903831325e-32, -9.740148099005463e-34,  4.041952820000535e-23, -1.764198702267458e-23,  4.130458695124849e-24, -6.571230105609594e-25,
  7.904250316476191e-26, -7.638821606322345e-27,  6.168155516820449e-28, -4.276787181139151e-29,  2.598138697022887e-30, -1.404438864987583e-31,  6.838346081815373e-33,
 -3.024516245075190e-34,  6.662285286125630e-02, -1.835253611646976e-04,  5.237604020843803e-07, -1.540630735167390e-09,  4.636169258336698e-12, -1.419908575227638e-14,
  4.389342456429145e-17, -1.370338984134699e-19,  4.266381326230595e-22, -1.345406766932882e-24,  4.147379437024442e-27, -1.333270009169451e-29,  5.957818126748116e-02,
 -1.958149728407750e-04,  7.811206506534307e-07, -3.296550954438761e-09,  1.388114526994783e-11, -5.744112625923628e-14,  2.331394657242377e-16, -9.304512171614605e-19,
  3.656501050086712e-21, -1.419526201544581e-23,  5.441522607689025e-26, -2.068639998966691e-28,  4.764341847156174e-02, -2.074693110810671e-04,  1.166740666456496e-06,
 -6.401293998750515e-09,  3.340932628724763e-11, -1.675081931614517e-13,  8.138247472137750e-16, -3.853184400715070e-18,  1.784666313958186e-20, -8.109151425433570e-23,
  3.622439121455079e-25, -1.593716678164158e-27,  3.406799098026989e-02, -2.032645996767653e-04,  1.491732581983922e-06, -9.953610849071670e-09,  6.187573182505948e-11,
 -3.655854185565778e-13,  2.075103774218512e-15, -1.139158667075963e-17,  6.077754716605625e-20, -3.162984469027749e-22,  1.610374764744862e-24, -8.039071050250419e-27,
  2.178136120541430e-02, -1.771732404781153e-04,  1.606838113576425e-06, -1.271603387948745e-08,  9.262146485285800e-11, -6.348362524919855e-13,  4.144441835831947e-15,
 -2.598247497782281e-17,  1.573718975332555e-19, -9.250628930477875e-22,  5.296224678332000e-24, -2.961550142597657e-26,  1.245028263910496e-02, -1.353859115720881e-04,
  1.472680436575933e-06, -1.365322943566033e-08,  1.151795043361987e-10, -9.051195407447972e-13,  6.720255479401519e-15, -4.760551648757440e-17,  3.240445669565658e-19,
 -2.130777849956880e-21,  1.359128094234568e-23, -8.436924994597051e-26,  6.361921429616273e-03, -9.038453677635471e-05,  1.160335797552730e-06, -1.249420166444425e-08,
  1.209473511000326e-10, -1.080052640369409e-12,  9.044674092525666e-15, -7.183153565087097e-17,  5.454060038547312e-19, -3.983206069365583e-21,  2.811199438376533e-23,
 -1.924402694017090e-25,  2.905868478425221e-03, -5.276683778402645e-05,  7.919736408776416e-07, -9.833746620933044e-09,  1.084259478342976e-10, -1.092766774220606e-12,
  1.025589715777375e-14, -9.076658836735828e-17,  7.643480848698432e-19, -6.165805716796768e-21,  4.789417053560040e-23, -3.597013386420555e-25,  1.186364906270593e-03,
 -2.700121365230625e-05,  4.708192289640717e-07, -6.699930823243458e-09,  8.364481383226012e-11, -9.463169187430580e-13,  9.903612257812953e-15, -9.720915834632923e-17,
  9.037788834766252e-19, -8.017855649907599e-21,  6.826023501910264e-23, -5.601779704103129e-25,  4.329265595697675e-04, -1.214186577645219e-05,  2.447740374622654e-07,
 -3.971012789882317e-09,  5.586655079212537e-11, -7.064298519438081e-13,  8.210676393469095e-15, -8.904175669654096e-17,  9.106652550288018e-19, -8.853989019130040e-21,
  8.233964757781065e-23, -7.359672177324565e-25,  1.412208263335264e-04, -4.809987411576749e-06,  1.116408107860892e-07, -2.055587015241380e-09,  3.246204877847674e-11,
 -4.571694126173078e-13,  5.881823710416845e-15, -7.025596326204662e-17,  7.880977252333148e-19, -8.373769785816039e-21,  8.483486452680443e-23, -8.237149872359614e-25,
  4.118697040247220e-05, -1.682498060210210e-06,  4.479085452412752e-08, -9.324648886615946e-10,  1.647644876226122e-11, -2.576838752543645e-13,  3.659996381375795e-15,
 -4.803011776116945e-17,  5.895275385036643e-19, -6.829880999627383e-21,  7.521339242262419e-23, -7.916400221714789e-25,  1.074385653042927e-05, -5.207773824405696e-07,
  1.584580000249844e-08, -3.717815348068264e-10,  7.330681389385033e-12, -1.270134751048451e-13,  1.987227105882113e-15, -2.859243471002373e-17,  3.832590160612780e-19,
 -4.832425738839933e-21,  5.774348354559840e-23, -6.576849432453863e-25,  2.508215064408660e-06, -1.429393537867664e-07,  4.954631285674408e-09, -1.306528355728556e-10,
  2.868294223504306e-12, -5.494803680905289e-14,  9.453114402031854e-16, -1.488765980772604e-17,  2.175894974031554e-19, -2.981443954445477e-21,  3.860098416329609e-23,
 -4.751098782037549e-25,  5.245369538706794e-07, -3.486596986018652e-08,  1.372537285145311e-09, -4.058218757848617e-11,  9.900725414132672e-13, -2.093683240863195e-14,
  3.954810609902580e-16, -6.808375752695475e-18,  1.083629978241740e-19, -1.611645222255434e-21,  2.258294385296573e-23, -3.000394588322226e-25,  9.839642529149053e-08,
 -7.576065413043888e-09,  3.377450832806182e-10, -1.117406294523523e-11,  3.024663538059368e-13, -7.051077703991958e-15,  1.460669625245948e-16, -2.745829496338905e-18,
  4.754534431584755e-20, -7.668163483395464e-22,  1.161863411134229e-23, -1.664870672837437e-25,  1.658822621174966e-08, -1.470563906526224e-09,  7.404654697223817e-11,
 -2.736260296393853e-12,  8.206782649490875e-14, -2.106737133231769e-15,  4.781689032719245e-17, -9.807179058989522e-19,  1.846049860625654e-20, -3.226345851278823e-22,
  5.282401422684590e-24, -8.158262737774531e-26,  2.519867078577041e-09, -2.558448228577192e-10,  1.451486900812605e-11, -5.981469545459890e-13,  1.985528286763743e-14,
 -5.607683782127844e-16,  1.393498103644189e-17, -3.116236837947592e-19,  6.372985801141959e-21, -1.206317579233680e-22,  2.133135620026367e-24, -3.549045064881694e-26,
  3.461471699038481e-10, -4.006136509756659e-11,  2.555027632146530e-12, -1.172510198955118e-13,  4.303378488509557e-15, -1.336183117104264e-16,  3.633163694150371e-18,
 -8.854333115844321e-20,  1.966498189853339e-21, -4.029882900460762e-23,  7.693518291959786e-25, -1.378441080128472e-26,  4.320435826820766e-11, -5.675569038214285e-12,
  4.060632756474181e-13, -2.072417917866920e-14,  8.402645899224680e-16, -2.866479123870549e-17,  8.524244521909455e-19, -2.263112415605828e-20,  5.456661047404632e-22,
 -1.210262494495246e-23,  2.493850330881999e-25, -4.810478705351437e-27,  4.931058107847328e-12, -7.323781524736843e-13,  5.866214919858221e-14, -3.325598993292845e-15,
  1.488338411365893e-16, -5.575243665265131e-18,  1.812495897641738e-19, -5.240405579478275e-21,  1.371362248436600e-22, -3.291217906186826e-24,  7.318326356324215e-26,
 -1.519465942401148e-27,  5.189675417579248e-13, -8.682295155550322e-14,  7.770232918236186e-15, -4.886987233462497e-16,  2.412191791430206e-17, -9.916426191816225e-19,
  3.522829689412034e-20, -1.108856420668148e-21,  3.148563354706459e-23, -8.174607278291900e-25,  1.961065561999584e-26, -4.381652220570849e-28,  5.092069109087664e-14,
 -9.560953144499274e-15,  9.540989743602573e-16, -6.648568406585304e-17,  3.616150209711200e-18, -1.630371873548237e-19,  6.325998346914423e-21, -2.166873507560850e-22,
  6.673780021319957e-24, -1.873886508766411e-25,  4.848568617335959e-27, -1.165467660589868e-28,  4.724933400046055e-15, -9.919435561598394e-16,  1.101324138689267e-16,
 -8.490393029895347e-18,  5.082994669637980e-19, -2.511256891135102e-20,  1.063514476435158e-21, -3.962028093664034e-23,  1.322922923858526e-24, -4.015297946815548e-26,
  1.120050417326980e-27, -2.895141457368251e-29,  4.223041579126841e-16, -9.873037222077717e-17,  1.216521737479878e-17, -1.035658136115995e-18,  6.814965718211094e-20,
 -3.685190560992776e-21,  1.701723814252120e-22, -6.888883364498830e-24,  2.491683324564335e-25, -8.168779048952622e-27,  2.454756062200792e-28, -6.818211106464521e-30,
  3.721868634205004e-17, -9.646164823611850e-18,  1.315061562676415e-18, -1.233405490570794e-19,  8.903607677471120e-21, -5.260913133205903e-22,  2.644968813847601e-23,
 -1.161915089384935e-24,  4.546657009108478e-26, -1.608091445291433e-27,  5.199771717254681e-29, -1.550151720270902e-30,  3.331172398806532e-18, -9.520716634386378e-19,
  1.430647802483941e-19, -1.473675783815112e-20,  1.163867875328609e-21, -7.496355228547580e-23,  4.094305654814897e-24, -1.947746465293336e-25,  8.229535022615034e-27,
 -3.134254248252576e-28,  1.088534114648716e-29, -3.476853027917367e-31,  3.139676517331989e-19, -9.833409894062376e-20,  1.620775311239441e-20, -1.825915772612446e-21,
  1.571781754817254e-22, -1.099745363095935e-23,  6.504211303362888e-25, -3.340590063951080e-26,  1.519598188519785e-27, -6.214595755161578e-29,  2.311945376150093e-30,
 -7.890877007566287e-32,  3.253918025192287e-20, -1.108341404699876e-20,  1.991180152204510e-21, -2.439551227340545e-22,  2.277091539862907e-23, -1.722384887009509e-24,
  1.098037171898786e-25, -6.062158185567372e-27,  2.956499751955122e-28, -1.293105507001628e-29,  5.132832640005016e-31, -1.864892754395272e-32,  3.894208116788931e-21,
 -1.429399552587289e-21,  2.776413792114052e-22, -3.671772163822272e-23,  3.690286912488179e-24, -2.997629554082602e-25,  2.046931860912979e-26, -1.207439180305079e-27,
  6.276694324549856e-29, -2.919557735456058e-30,  1.229800201220029e-31, -4.731347269519318e-33,  5.659143965847985e-22, -2.214155068846809e-22,  4.602221212333539e-23,
 -6.506282449372958e-24,  6.976260512456961e-25, -6.032292552786076e-26,  4.375029269482922e-27, -2.735095949696944e-28,  1.503698627766340e-29, -7.382470995311271e-31,
  3.276015810113587e-32, -1.325204155852754e-33,  1.039601706378574e-22, -4.280667565660513e-23,  9.401506666673351e-24, -1.403570578781326e-24,  1.586859173906330e-25,
 -1.444278453556196e-26,  1.100581806920927e-27, -7.216371194399442e-29,  4.154015869167019e-30, -2.131840986055388e-31,  9.873227445506062e-33, -4.161548381798726e-34,
  2.409375970506779e-23, -1.029116415607748e-23,  2.352581458342743e-24, -3.654769037763231e-25,  4.295305874324091e-26, -4.058780812183070e-27,  3.206954956580354e-28,
 -2.177488798996100e-29,  1.296363179305497e-30, -6.872399494498914e-32,  3.283988061042687e-33, -1.426478916371912e-34,  5.786052529428069e-24, -2.523476854491451e-24,
  5.902996450168262e-25, -9.383016822971713e-26,  1.127678648002335e-26, -1.088903970109385e-27,  8.785520193297243e-29, -6.086803210060747e-30,  3.694908886763992e-31,
 -1.995832328286743e-32,  9.710951567048584e-34, -4.292065311204514e-35,  6.589701624738968e-02, -1.794079884023836e-04,  5.057087160214613e-07, -1.468667921098203e-09,
  4.362418959485339e-12, -1.319018786582777e-14,  4.024054973516113e-17, -1.241255299918150e-19,  3.810530890588462e-22, -1.190714477569505e-24,  3.599765730874997e-27,
 -1.161160883601657e-29,  5.880717398633931e-02, -1.897205517882329e-04,  7.428576791406867e-07, -3.083347822379166e-09,  1.278623233543405e-11, -5.214564638420205e-14,
  2.086510143878890e-16, -8.212167372820723e-19,  3.182553054871117e-21, -1.219023906647604e-23,  4.608260992323563e-26, -1.729724142867665e-28,  4.683173508152031e-02,
 -1.984338084198539e-04,  1.093025218475749e-06, -5.892520416462588e-09,  3.024606376650783e-11, -1.492091363904500e-13,  7.135111930701002e-16, -3.326134902770056e-18,
  1.517213493378135e-20, -6.791179113626175e-23,  2.989087552344757e-25, -1.296008685450899e-27,  3.327806687760549e-02, -1.917922207749583e-04,  1.377996513827155e-06,
 -9.019491495990320e-09,  5.503730496984320e-11, -3.194008228977920e-13,  1.781740666902325e-15, -9.617120909391250e-18,  5.046984871294647e-20, -2.584343860605776e-22,
  1.295013885705612e-24, -6.364238670501517e-27,  2.109744557195496e-02, -1.649046431844531e-04,  1.462735229801694e-06, -1.133049738547108e-08,  8.086329310577217e-11,
 -5.435600734086040e-13,  3.482706093872826e-15, -2.144094174605748e-17,  1.275885907603153e-19, -7.371377846628365e-22,  4.149458784965842e-24, -2.282028151460302e-26,
  1.193130671850828e-02, -1.242298152823628e-04,  1.319328733750552e-06, -1.194684627538417e-08,  9.858777360283989e-11, -7.587244166555874e-13,  5.521649250213271e-15,
 -3.836534478943547e-17,  2.562894433252676e-19, -1.654679259818665e-21,  1.036731512171942e-23, -6.323782662491895e-26,  6.018043467852618e-03, -8.167024270647025e-05,
  1.021339906623392e-06, -1.072070819236256e-08,  1.013637634388226e-10, -8.852687992244362e-13,  7.257632294026236e-15, -5.647138454620845e-17,  4.203646869807921e-19,
 -3.011410257540861e-21,  2.085770288633291e-23, -1.401812889459542e-25,  2.706764890909626e-03, -4.687515485131522e-05,  6.836974204582166e-07, -8.261217324721841e-09,
  8.883962862941113e-11, -8.745515412329978e-13,  8.025958386152306e-15, -6.951808632268651e-17,  5.733618441928931e-19, -4.532751048227346e-21,  3.452407140075600e-23,
 -2.543630908934938e-25,  1.085414288131900e-03, -2.353486397608275e-05,  3.978648307412130e-07, -5.500980073145199e-09,  6.689069504122586e-11, -7.382734308500637e-13,
  7.546751349957415e-15, -7.242424684944214e-17,  6.588716123252591e-19, -5.723434896754461e-21,  4.774023403843240e-23, -3.840513650360457e-25,  3.879938039261764e-04,
 -1.036009458168487e-05,  2.020513297141546e-07, -3.180262025265408e-09,  4.352241609068566e-11, -5.362719507464157e-13,  6.081757294676087e-15, -6.442305652665104e-17,
  6.441511147273422e-19, -6.127391344048212e-21,  5.578741053482877e-23, -4.884573089392170e-25,  1.236225132620284e-04, -4.007347615521490e-06,  8.981152487511909e-08,
 -1.602292359465881e-09,  2.458458360551465e-11, -3.370186583188564e-13,  4.226694226571018e-15, -4.927008027879429e-17,  5.398908069579194e-19, -5.608226968542152e-21,
  5.558582584962594e-23, -5.283521004883804e-25,  3.510861152612336e-05, -1.364810740460763e-06,  3.502724041140176e-08, -7.057201059451005e-10,  1.210236160482794e-11,
 -1.840583500338761e-13,  2.546074082050835e-15, -3.258051988318518e-17,  3.903420556038341e-19, -4.418035536330492e-21,  4.756798415183051e-23, -4.898270724730899e-25,
  8.888604523325516e-06, -4.100400322778440e-07,  1.201204423025053e-08, -2.724706236756625e-10,  5.209032802857569e-12, -8.768732356001637e-14,  1.335063755215847e-15,
 -1.871691036110795e-17,  2.447218230583662e-19, -3.012616600550365e-21,  3.517462900033544e-23, -3.917450523764876e-25,  2.006802737458240e-06, -1.088696261896825e-07,
  3.629525038971911e-09, -9.244787576352292e-11,  1.966124260601520e-12, -3.656546467792529e-14,  6.117105508524729e-16, -9.380714881189018e-18,  1.336526911629730e-19,
 -1.786976275666066e-21,  2.259496047002822e-23, -2.718050615128602e-25,  4.042915148823208e-07, -2.559308569172538e-08,  9.682886880550919e-10, -2.763360893789939e-11,
  6.526283463751223e-13, -1.338902212105303e-14,  2.457787363467648e-16, -4.117657365644259e-18,  6.385391966275021e-20, -9.262251936522428e-22,  1.266935082306560e-23,
 -1.644464920258899e-25,  7.275028722237615e-08, -5.337787340971349e-09,  2.285917406323843e-10, -7.295647358294228e-12,  1.910642471021205e-13, -4.318768297280946e-15,
  8.689907877913693e-17, -1.588983250374886e-18,  2.679567200338510e-20, -4.213234914330686e-22,  6.229430981530329e-24, -8.717731911015630e-26,  1.171051077615135e-08,
 -9.900486241536851e-10,  4.787857395546375e-11, -1.706159648864422e-12,  4.948911680283880e-14, -1.231330848920919e-15,  2.713553821095764e-17, -5.411645041767181e-19,
  9.917400251646737e-21, -1.689290707346517e-22,  2.698225160642221e-24, -4.068849036914040e-26,  1.689899741025067e-09, -1.637838055269092e-10,  8.924757519573386e-12,
 -3.546123655160708e-13,  1.138154238528060e-14, -3.114813624571562e-16,  7.513546780534691e-18, -1.633431382468613e-19,  3.251584836476557e-21, -5.997568078752624e-23,
  1.034470035169389e-24, -1.680279831348075e-26,  2.192900261483612e-10, -2.425471289113951e-11,  1.486269246734444e-12, -6.576854181871236e-14,  2.333905061846484e-15,
 -7.021634962485906e-17,  1.853176890916515e-18, -4.390258018904947e-20,  9.490393955414247e-22, -1.895071373513276e-23,  3.528843621455088e-25, -6.172529127533269e-27,
  2.569721993150171e-11, -3.230561716770553e-12,  2.222071526595550e-13, -1.093925328715883e-14,  4.289335171142494e-16, -1.418032014896569e-17,  4.093594248385763e-19,
 -1.056584838028968e-20,  2.479867036810786e-22, -5.360094184852848e-24,  1.077433395875730e-25, -2.029245016759750e-27,  2.735044119745763e-12, -3.893815059267134e-13,
  3.001140744612601e-14, -1.642140833221631e-15,  7.110618924779988e-17, -2.582254594019399e-18,  8.152110651631065e-20, -2.292146965908130e-21,  5.840668497564686e-23,
 -1.366425638877637e-24,  2.964804728748949e-26, -6.012175867336951e-28,  2.664546310311610e-13, -4.281146322839666e-14,  3.691294656734264e-15, -2.242827899622357e-16,
  1.071905785109933e-17, -4.274748400931333e-19,  1.475565988858053e-20, -4.519217303241503e-22,  1.250139504019805e-23, -3.165558715788799e-25,  7.413869405199283e-27,
 -1.618677265665912e-28,  2.400826407820871e-14, -4.338824100048017e-15,  4.177953623999829e-16, -2.816124009607238e-17,  1.484645823466958e-18, -6.499571844696858e-20,
  2.452534535805322e-21, -8.180744814736306e-23,  2.456544231980270e-24, -6.732191989194785e-26,  1.701807201528718e-27, -4.000141389825694e-29,  2.028291764018969e-15,
 -4.109010593866659e-16,  4.410699751461269e-17, -3.294406251666693e-18,  1.914424230628584e-19, -9.195780328380460e-21,  3.791787185733766e-22, -1.377131561337165e-23,
  4.487934585385518e-25, -1.330861566734907e-26,  3.630485824230170e-28, -9.185299152160253e-30,  1.635858050262907e-16, -3.701339789871035e-17,  4.419655931009869e-18,
 -3.652755773878542e-19,  2.337346138788145e-20, -1.230886445235440e-21,  5.542688607143117e-23, -2.190632943781078e-24,  7.744074415152289e-26, -2.483786680169430e-27,
  7.308609783807290e-29, -1.989456188460930e-30,  1.289308068106123e-17, -3.244729074162970e-18,  4.298678979872395e-19, -3.923709320830761e-20,  2.760460964436709e-21,
 -1.591740458197425e-22,  7.818891151066614e-24, -3.359564102658972e-25,  1.287104251192477e-26, -4.461064417702895e-28,  1.414752249103549e-29, -4.139848503139379e-31,
  1.023230525414573e-18, -2.850222376865934e-19,  4.175440308463809e-20, -4.197923603019817e-21,  3.239830768252857e-22, -2.041491153305727e-23,  1.091969992341971e-24,
 -5.092294692932027e-26,  2.111014864787709e-27, -7.894774377385085e-29,  2.694421184826800e-30, -8.463382558894204e-32,  8.490825497503517e-20, -2.602263130123453e-20,
  4.196692731292934e-21, -4.629973892697175e-22,  3.906845980563676e-23, -2.682085165604538e-24,  1.557780511598591e-25, -7.863643852678084e-27,  3.518443940227975e-28,
 -1.416330783631404e-29,  5.189754967905460e-31, -1.745787292463384e-32,  7.713331817480559e-21, -2.581912341460645e-21,  4.556625500129857e-22, -5.487439860586026e-23,
  5.038394823718316e-24, -3.751623111613014e-25,  2.356102009733101e-26, -1.282285558239839e-27,  6.168642260660706e-29, -2.662907877336792e-30,  1.043829640561138e-31,
 -3.747242448381619e-33,  8.091886771731573e-22, -2.931529809628411e-22,  5.617003515478796e-23, -7.330641760278148e-24,  7.274530679120196e-25, -5.837715395958524e-26,
  3.940245463269240e-27, -2.298601055592967e-28,  1.182275875018468e-29, -5.443687399067634e-31,  2.270837138963785e-32, -8.655585397030622e-34,  1.037662411829550e-22,
 -4.023652986200511e-23,  8.284336474048664e-24, -1.160359702722305e-24,  1.233113388382168e-25, -1.057172937724469e-26,  7.604820326428331e-28, -4.717152215648811e-29,
  2.574037975656691e-30, -1.254707310816806e-31,  5.529747560306553e-33, -2.222247323298945e-34,  1.707869234851248e-23, -6.995000761437213e-24,  1.527515156461055e-24,
 -2.267646998082998e-25,  2.549863290481556e-26, -2.308665481782484e-27,  1.750486937859137e-28, -1.142284164291654e-29,  6.545316424878698e-31, -3.344327107991440e-32,
  1.542355640944833e-33, -6.474886484755694e-35,  3.635920864066489e-24, -1.549111500165936e-24,  3.531588506465597e-25, -5.471483097462725e-26,  6.413493928463528e-27,
 -6.044961429703383e-28,  4.764650943370441e-29, -3.227577415813951e-30,  1.917214475095984e-31, -1.014179259550370e-32,  4.836235673832979e-34, -2.096566442305483e-35,
  8.298780226061486e-25, -3.616324034153057e-25,  8.451546466391613e-26, -1.342151068592167e-26,  1.611564644108746e-27, -1.554770131898233e-28,  1.253342667392568e-29,
 -8.676186966376625e-31,  5.262498854469642e-32, -2.840350724693857e-33,  1.380956320303796e-34, -6.099100914826579e-36,  6.518736566363265e-02, -1.754316478704030e-04,
  4.884949544703191e-07, -1.400928331511054e-09,  4.107998373987048e-12, -1.226478160090239e-14,  3.692949500702753e-17, -1.125908651858434e-19,  3.406600987319896e-22,
 -1.056503690954283e-24,  3.121100841998292e-27, -1.019327191099712e-29,  5.805994797521185e-02, -1.839222907270682e-04,  7.070514279174464e-07, -2.886846943521122e-09,
  1.179159093163216e-11, -4.740283588658869e-14,  1.870192086866946e-16, -7.260552225721022e-19,  2.775128917561995e-21, -1.049053145232608e-23,  3.910624868451258e-26,
 -1.450178810882756e-28,  4.605505174268580e-02, -1.899644416290099e-04,  1.025123047236158e-06, -5.431557145332801e-09,  2.742585429358761e-11, -1.331497658386129e-13,
  6.268248218223018e-16, -2.877543227056303e-18,  1.292946397173238e-20, -5.702178102916407e-23,  2.473309136119805e-25, -1.057029608919340e-27,  3.253228097009501e-02,
 -1.811866849451211e-04,  1.274842676191891e-06, -8.187763736619614e-09,  4.905600260209958e-11, -2.796961527702181e-13,  1.533741354980783e-15, -8.141469267734531e-18,
  4.203489632166418e-20, -2.118259273208830e-22,  1.044925789871587e-24, -5.056265566574956e-27,  2.046039964327356e-02, -1.537254280913736e-04,  1.334187560212571e-06,
 -1.011930897928928e-08,  7.078159738817674e-11, -4.667413448872680e-13,  2.935747524916199e-15, -1.775252922774035e-17,  1.038122153960804e-19, -5.896189839857960e-22,
  3.264031234327313e-24, -1.765822985719166e-26,  1.145462515081717e-02, -1.142229263888062e-04,  1.184952610737271e-06, -1.048398681652797e-08,  8.465603446056350e-11,
 -6.382211567797392e-13,  4.553822732419984e-15, -3.104228230814068e-17,  2.035604664395079e-19, -1.290699249659363e-21,  7.945180790539271e-24, -4.763133115485723e-26,
  5.706926385642834e-03, -7.398783318725985e-05,  9.018673026453493e-07, -9.231578521658114e-09,  8.527959284515406e-11, -7.286346703652990e-13,  5.849540911246074e-15,
 -4.460459716136894e-17,  3.255953602602625e-19, -2.288523009131298e-21,  1.555923178854321e-23, -1.026893572320677e-25,  2.529608021350693e-03, -4.177921400331460e-05,
  5.925463919964769e-07, -6.969872016580026e-09,  7.312726899512903e-11, -7.033551040592308e-13,  6.313567398896168e-15, -5.353529120991765e-17,  4.325605445292824e-19,
 -3.352115171342201e-21,  2.504069778891514e-23, -1.810284979993503e-25,  9.972468781237484e-04, -2.059885960121454e-05,  3.378174078140841e-07, -4.539660667945896e-09,
  5.378373913317337e-11, -5.792814474308412e-13,  5.785519593739444e-15, -5.429918631601131e-17,  4.834841733245192e-19, -4.113418165105050e-21,  3.362395645862798e-23,
 -2.652134512038875e-25,  3.495602462640939e-04, -8.885264916046348e-06,  1.677365069112374e-07, -2.562350136962205e-09,  3.412171321437811e-11, -4.098160760406486e-13,
  4.536173130737548e-15, -4.694770903754905e-17,  4.590404353628150e-19, -4.273163380441006e-21,  3.809769445613285e-23, -3.268311934189595e-25,  1.089171405018192e-04,
 -3.359557096755164e-06,  7.273835584145369e-08, -1.257786572790539e-09,  1.875622281119996e-11, -2.503527635614416e-13,  3.061466181824880e-15, -3.483647835098271e-17,
  3.729817337706596e-19, -3.788656375512923e-21,  3.674541122413205e-23, -3.419864612132114e-25,  3.016047354639157e-05, -1.115435181166294e-06,  2.760891174411456e-08,
 -5.384981091078628e-10,  8.965075504553251e-12, -1.326229552981362e-13,  1.787175044113001e-15, -2.230552486137382e-17,  2.609127265556236e-19, -2.885673699978838e-21,
  3.038258219435809e-23, -3.061484363274015e-25,  7.421767118923618e-06, -3.257282096815257e-07,  9.189778411834167e-09, -2.015786060929992e-10,  3.737432638777653e-12,
 -6.114103843077555e-14,  9.060781554546675e-16, -1.238001359081241e-17,  1.579234390490953e-19, -1.898457572827655e-21,  2.166280364188604e-23, -2.359519779122662e-25,
  1.623058336003199e-06, -8.378694573591140e-08,  2.687124491503186e-09, -6.612400519112697e-11,  1.362616475813277e-12, -2.460678312344469e-14,  4.003759001875115e-16,
 -5.979685408298075e-18,  8.306692922715604e-20, -1.083914873004668e-21,  1.338685578182934e-23, -1.574129153804520e-25,  3.155378187738000e-07, -1.901412260069008e-08,
  6.914412116368326e-10, -1.904871230161861e-11,  4.355702056435585e-13, -8.670603814976781e-15,  1.547012318588127e-16, -2.522629950582937e-18,  3.812005494026451e-20,
 -5.393647967151383e-22,  7.202829475008770e-24, -9.134787639368000e-26,  5.456769393641307e-08, -3.813171930165158e-09,  1.568653182481811e-10, -4.829853798769310e-12,
  1.223878432268787e-13, -2.682660333367984e-15,  5.243559693050911e-17, -9.327363709601936e-19,  1.532002621471527e-20, -2.348661144045264e-22,  3.388923499943859e-24,
 -4.632159879116111e-26,  8.403502817124529e-09, -6.771195731207155e-10,  3.144488841047765e-11, -1.080533957303532e-12,  3.031161612401018e-14, -7.310008385214031e-16,
  1.564209365815126e-17, -3.033445039334126e-19,  5.412479495663757e-21, -8.985937895630556e-23,  1.400266420475761e-24, -2.061813754263020e-26,  1.154428102115855e-09,
 -1.067280983135486e-10,  5.584406472183944e-12, -2.139135375430341e-13,  6.637939021262241e-15, -1.760234686735444e-16,  4.121583532130856e-18, -8.710567907064998e-20,
  1.687792331400207e-21, -3.033596819056171e-23,  5.103684000770553e-25, -8.093093897781207e-27,  1.418260950868671e-10, -1.497950512530743e-11,  8.815774239187420e-13,
 -3.760755732040868e-14,  1.290146656593649e-15, -3.760434515467569e-17,  9.632355570297266e-19, -2.218047656366300e-20,  4.666471616833456e-22, -9.079082470094981e-24,
  1.648898896974083e-25, -2.815552735923004e-27,  1.563902678841636e-11, -1.879845716934308e-12,  1.242433987850148e-13, -5.897839725600179e-15,  2.235836438288187e-16,
 -7.161481924959957e-18,  2.006554853132313e-19, -5.034161812155180e-21,  1.149973966484574e-22, -2.421929821192011e-24,  4.748407088582056e-26, -8.730944197189631e-28,
  1.555782005895677e-12, -2.121012086181840e-13,  1.572036684240100e-14, -8.298313925765094e-16,  3.475233883120552e-17, -1.223103319976763e-18,  3.748585650994724e-20,
 -1.024736239605495e-21,  2.541918464584046e-23, -5.795717919048044e-25,  1.226818772253127e-26, -2.429316095691357e-28,  1.406183343771556e-13, -2.167431825410412e-14,
  1.799069295300758e-15, -1.055386517927941e-16,  4.881378011380048e-18, -1.887627970456844e-19,  6.328577474760121e-21, -1.885283606846811e-22,  5.079097405726294e-24,
 -1.253952637410512e-25,  2.866270939041039e-27, -6.113355543712369e-29,  1.165942113810219e-14, -2.025697340236713e-15,  1.880511356475639e-16, -1.225177309709043e-17,
  6.256766657775164e-19, -2.658230315161561e-20,  9.749749148590699e-22, -3.165516732516157e-23,  9.263687038953823e-25, -2.476860116582520e-26,  6.114672167805163e-28,
 -1.404940591081034e-29,  8.984842649555421e-16, -1.754187946414935e-16,  1.818645059261436e-17, -1.314930539241203e-18,  7.411530104636062e-20, -3.458963763930455e-21,
  1.387838942228097e-22, -4.911144133057160e-24,  1.561273246722247e-25, -4.521190608925630e-27,  1.205569635877751e-28, -2.984159517512218e-30,  6.548040943234380e-17,
 -1.431939500667713e-17,  1.655119635668528e-18, -1.326712944658804e-19,  8.248229362181470e-21, -4.226839421694430e-22,  1.854729561977661e-23, -7.152047377985626e-25,
  2.469538714813545e-26, -7.744371931893445e-28,  2.230151005601892e-29, -5.946219620418662e-31,  4.618538003904066e-18, -1.127061337606303e-18,  1.449271756738128e-19,
 -1.286038595015245e-20,  8.809449342356607e-22, -4.952855600551930e-23,  2.375152470356310e-24, -9.974391592910352e-26,  3.738725021779850e-27, -1.269010097349725e-28,
  3.944580973379608e-30, -1.132290095072218e-31,  3.249358485954949e-19, -8.809036977006052e-20,  1.256535514068740e-20, -1.231644859874925e-21,  9.279337559862883e-23,
 -5.714957020294935e-24,  2.991095129415840e-25, -1.366246914217256e-26,  5.552754749113174e-28, -2.037659246374634e-29,  6.829308137008394e-31, -2.108169113764675e-32,
  2.370400097266152e-20, -7.099411388358109e-21,  1.118877552623248e-21, -1.207477780852579e-22,  9.977295595947124e-24, -6.714094787531412e-25,  3.826151358925017e-26,
 -1.896717846446596e-27,  8.340768054538873e-29, -3.302358859873190e-30,  1.191009053887449e-31, -3.946053251223581e-33,  1.881914917956961e-21, -6.183066354515240e-22,
  1.070709116819937e-22, -1.266080083709157e-23,  1.142362412950485e-24, -8.365757002746316e-26,  5.171191274102482e-27, -2.772086146780629e-28,  1.314410686977245e-29,
 -5.596179233964492e-31,  2.164788776531293e-32, -7.673589964986881e-34,  1.722811683662740e-22, -6.153896506488688e-23,  1.162006633268200e-23, -1.495151081352190e-24,
  1.463677510806193e-25, -1.159433240936522e-26,  7.729382745118930e-28, -4.456017463075370e-29,  2.266171178429840e-30, -1.032220943936650e-31,  4.261603464354383e-33,
 -1.608384974556576e-34,  1.938087158647855e-23, -7.442420203663184e-24,  1.516686075407911e-24, -2.103208467329550e-25,  2.213672495033390e-26, -1.880429880274658e-27,
  1.340843591383612e-28, -8.247402092369095e-30,  4.464386374878102e-31, -2.159490945768545e-32,  9.447576546582092e-34, -3.770133527565458e-35,  2.839449326668608e-24,
 -1.156238099865356e-24,  2.509228218753382e-25, -3.702324987766114e-26,  4.138616969037540e-27, -3.726006884743524e-28,  2.809901579261385e-29, -1.824139491039809e-30,
  1.040072947937204e-31, -5.289126399097809e-33,  2.428229435238109e-34, -1.014975252633765e-35,  5.520014987385340e-25, -2.345404764792122e-25,  5.330979960921107e-26,
 -8.234917901618440e-27,  9.625130484298049e-28, -9.047114400357966e-29,  7.112137018567394e-30, -4.805571914433867e-31,  2.847630926181514e-32, -1.502849617828809e-33,
  7.150513126064450e-35, -3.093207070557768e-36,  1.192743862477353e-25, -5.192890815703360e-26,  1.212394988940040e-26, -1.923426340597746e-27,  2.307264641017955e-28,
 -2.223839212562029e-29,  1.791048184144945e-30, -1.238737706148477e-31,  7.507026777426246e-33, -4.048419405276856e-34,  1.966720638676659e-35, -8.679403675166409e-37,
  6.449335007414984e-02, -1.715898337538296e-04,  4.720702406940906e-07, -1.337115616666752e-09,  3.871316684881060e-12, -1.141510672792813e-14,  3.392401551927961e-17,
 -1.022750488763568e-19,  3.047683401182052e-22, -9.402743121711515e-25,  2.698678042913235e-27, -9.052156213813814e-30,  5.733535666971307e-02, -1.784013111457663e-04,
  6.735107429609972e-07, -2.705528805181058e-09,  1.088682254988560e-11, -4.314863303112374e-14,  1.678782277071399e-16, -6.430037914974829e-19,  2.424153914508896e-21,
 -9.046778671819759e-24,  3.324950595377329e-26, -1.219219949261629e-28,  4.531119341780603e-02, -1.820169093715832e-04,  9.624919394894525e-07, -5.013256636312696e-09,
  2.490700448442718e-11, -1.190279023896474e-13,  5.517505135600002e-16, -2.494822872448356e-18,  1.104409811928305e-20, -4.799906985390942e-23,  2.052050469304656e-25,
 -8.646041765395510e-28,  3.182732773599529e-02, -1.713680254805283e-04,  1.181120561280637e-06, -7.445693940356844e-09,  4.381246928393986e-11, -2.454766639210025e-13,
  1.323520535759802e-15, -6.910713148176661e-18,  3.511083862993882e-20, -1.741585311016205e-22,  8.459040278501803e-25, -4.030998529992590e-27,  1.986610213951169e-02,
 -1.435190872338530e-04,  1.219254791068452e-06, -9.057816314580304e-09,  6.211294713843290e-11, -4.018916175476163e-13,  2.482164784585198e-15, -1.474640473013214e-17,
  8.476018756498232e-20, -4.733604564596664e-22,  2.577545744160464e-24, -1.371974157792097e-26,  1.101592717982905e-02, -1.052244433601442e-04,  1.066868980880262e-06,
 -9.225950274182987e-09,  7.291775450422932e-11, -5.386643816187308e-13,  3.769263320257855e-15, -2.521432859460878e-17,  1.623445295604094e-19, -1.011147468266587e-21,
  6.116656453428420e-24, -3.604712400517570e-26,  5.424734676902620e-03, -6.719387447869633e-05,  7.988178995672973e-07, -7.976463170295746e-09,  7.201540268146429e-11,
 -6.021275202503927e-13,  4.734901229183179e-15, -3.539192762089940e-17,  2.534017818260829e-19, -1.747917135080070e-21,  1.166775302913703e-23, -7.563642577890292e-26,
  2.371468933107463e-03, -3.735452413894931e-05,  5.154892719584301e-07, -5.904622515809300e-09,  6.046163955284965e-11, -5.683581655937410e-13,  4.991517731064849e-15,
 -4.144542641488291e-17,  3.281463377825085e-19, -2.493340495163741e-21,  1.827154230529463e-23, -1.296398784036545e-25,  9.199310548680605e-04, -1.810042881106840e-05,
  2.881454906735521e-07, -3.764748696041086e-09,  4.347197111685993e-11, -4.570533084210391e-13,  4.461207875654038e-15, -4.095866545629003e-17,  3.570393592275169e-19,
 -2.975808776997024e-21,  2.384339517669768e-23, -1.844383960936466e-25,  3.165205594083441e-04, -7.657671154984832e-06,  1.400115188326060e-07, -2.076476929173990e-09,
  2.691560737474279e-11, -3.151947446706138e-13,  3.406105589261410e-15, -3.445163744698776e-17,  3.294918194040249e-19, -3.002315976831430e-21,  2.621753060054022e-23,
 -2.204164560730703e-25,  9.655386548680115e-05, -2.833278465651714e-06,  5.929236208074072e-08, -9.940601965227497e-10,  1.441138050224763e-11, -1.873504975203936e-13,
  2.234500311721731e-15, -2.482668377549599e-17,  2.597811527332128e-19, -2.580968359631604e-21,  2.450046853021378e-23, -2.233142364741805e-25,  2.610274423055100e-05,
 -9.181607312007912e-07,  2.192705768393457e-08, -4.141426241292956e-10,  6.695446651371634e-12, -9.637016241507044e-14,  1.265423100415651e-15, -1.540794998637868e-17,
  1.760040386039830e-19, -1.902553180981196e-21,  1.959275110048427e-23, -1.932265455986724e-25,  6.251892411006956e-06, -2.609549779288003e-07,  7.092803910328068e-09,
 -1.504890617540965e-10,  2.706696311800222e-12, -4.304143423217889e-14,  6.209972079668363e-16, -8.271136408722802e-18,  1.029601211386635e-19, -1.208907244855602e-21,
  1.348393772987562e-23, -1.436607590300068e-25,  1.326357005837078e-06, -6.512754287338920e-08,  2.009754847968719e-09, -4.778908726525333e-11,  9.544209074702707e-13,
 -1.673923606171295e-14,  2.649576660221264e-16, -3.854716754557837e-18,  5.221929356421074e-20, -6.651203613902258e-22,  8.025024750626029e-24, -9.225544837863236e-26,
  2.492480854045130e-07, -1.429043459113954e-08,  4.995421497152849e-10, -1.328690240108784e-11,  2.942080131037310e-13, -5.683667917539172e-15,  9.858144988112973e-17,
 -1.564872817583686e-18,  2.304668359328308e-20, -3.181272199971719e-22,  4.148239652675376e-24, -5.140913936805879e-26,  4.149991358077885e-08, -2.760466641007370e-09,
  1.090851734561232e-10, -3.240472526601243e-12,  7.945999547691123e-14, -1.689175502205610e-15,  3.207696982886736e-17, -5.551448005766801e-19,  8.882021121423562e-21,
 -1.327790766331350e-22,  1.869924901079835e-24, -2.496629121053011e-26,  6.126347903229294e-09, -4.701729671226133e-10,  2.096488826731917e-11, -6.946814749939450e-13,
  1.884745876766255e-14, -4.405852451073865e-16,  9.154795425942051e-18, -1.726512301484103e-19,  2.999510477420572e-21, -4.854068047954663e-23,  7.379936121292450e-25,
 -1.061110436173417e-26,  8.028444495705063e-10, -7.075152656919671e-11,  3.553893125943885e-12, -1.312268335287805e-13,  3.936815886368734e-15, -1.011536696619590e-16,
  2.299087262201872e-18, -4.723537521131512e-20,  8.908873105340058e-22, -1.560361209728361e-23,  2.560581031115547e-25, -3.964053879861195e-27,  9.358433010052809e-11,
 -9.431063898492756e-12,  5.328791550810145e-13, -2.191011092764012e-14,  7.265183953457331e-16, -2.051379225838753e-17,  5.099444696652646e-19, -1.141297999337705e-20,
  2.336772836311704e-22, -4.429553117702000e-24,  7.845781884368081e-26, -1.307747334573833e-27,  9.732690655560456e-12, -1.117576359431564e-12,  7.093938614556337e-14,
 -3.246044118953511e-15,  1.189434020446527e-16, -3.690504317202977e-18,  1.003442255654075e-19, -2.446712713317628e-21,  5.439066181334239e-23, -1.116027772680359e-24,
  2.133928892747434e-26, -3.830134655670050e-28,  9.070777445858496e-13, -1.183015645875530e-13,  8.426553394506701e-15, -4.289280968676191e-16,  1.736684837044214e-17,
 -5.921860999206628e-19,  1.761502543765178e-20, -4.680575976663108e-22,  1.130018625147603e-23, -2.510537734666112e-25,  5.183472152065367e-27, -1.002104994152847e-28,
  7.623947959305964e-14, -1.126092108215836e-14,  8.991550009615738e-16, -5.089712053205632e-17,  2.277127156428375e-18, -8.534994010530826e-20,  2.778283785006570e-21,
 -8.047663043262621e-23,  2.110870694466306e-24, -5.079659105104635e-26,  1.132907082271584e-27, -2.359884168138968e-29,  5.830138397185925e-15, -9.726179787044908e-16,
  8.697037253822141e-17, -5.472942905394571e-18,  2.705767153141622e-19, -1.115024614909819e-20,  3.973283217278565e-22, -1.255120134294697e-23,  3.578134245754636e-25,
 -9.330289026452420e-27,  2.248683557630299e-28, -5.048744910789938e-30,  4.106264490387125e-16, -7.716302445310899e-17,  7.718734127164279e-18, -5.397862341500318e-19,
  2.948863884045636e-20, -1.336284373514400e-21,  5.214033005740718e-23, -1.796774985251396e-24,  5.569230675959013e-26, -1.574163167225698e-27,  4.101103425862219e-29,
 -9.927602009661969e-31,  2.708531802403103e-17, -5.716752469726164e-18,  6.389154568480070e-19, -4.962372945694224e-20,  2.994925107158748e-21, -1.492342788824840e-22,
  6.376631865806010e-24, -2.397506135765225e-25,  8.081034931103839e-27, -2.476363805330862e-28,  6.975166108242003e-30, -1.820722348075185e-31,  1.711353835131048e-18,
 -4.043726753304984e-19,  5.040849210718522e-20, -4.343984598649350e-21,  2.894532444194292e-22, -1.585344911792840e-23,  7.416075920337834e-25, -3.041600215200561e-26,
  1.114658278146932e-27, -3.702657695693242e-29,  1.127383518175986e-30, -3.172653934206089e-32,  1.067445884289495e-19, -2.812372781815590e-20,  3.901133803166166e-21,
 -3.723800828188150e-22,  2.735979890313177e-23, -1.645384063748962e-24,  8.418916194674020e-26, -3.763519795395337e-27,  1.498440973696577e-28, -5.391638749529568e-30,
  1.773312660062860e-31, -5.376244564744085e-33,  6.837837819042609e-21, -1.998515315377077e-21,  3.074100589472929e-22, -3.241419682675289e-23,  2.619938975888101e-24,
 -1.726492994732255e-25,  9.644516838446401e-27, -4.691043349575064e-28,  2.025801268079605e-29, -7.882906921745233e-31,  2.796214588501905e-32, -9.118477261478967e-34,
  4.731688815565391e-22, -1.523922176794426e-22,  2.586246144456312e-23, -2.999410455236719e-24,  2.656729288322250e-25, -1.911623083788897e-26,  1.161995822244357e-27,
 -6.130228826255080e-29,  2.862678414193649e-30, -1.201152986072729e-31,  4.582065751079177e-33, -1.602691821266801e-34,  3.763354974543069e-23, -1.323970361512500e-23,
  2.461060657469034e-24, -3.118919680576677e-25,  3.009235692825632e-26, -2.350926924570219e-27,  1.546679924479912e-28, -8.804991891486357e-30,  4.424347840343027e-31,
 -1.992214769394849e-32,  8.135071465933985e-34, -3.038205594587081e-35,  3.691966292575549e-24, -1.402856234064547e-24,  2.827329122755053e-25, -3.878557451691326e-26,
  4.040150603769696e-27, -3.398106699374720e-28,  2.400208558233010e-29, -1.463071970813463e-30,  7.851717835499452e-32, -3.766824314624431e-33,  1.635017805236534e-34,
 -6.475784379870619e-36,  4.782165963641398e-25, -1.935025561522805e-25,  4.170958263545235e-26, -6.113433831318099e-27,  6.790281594947895e-28, -6.075965976401901e-29,
  4.555319725941884e-30, -2.940728224362632e-31,  1.667775350411651e-32, -8.437948639559477e-34,  3.854948842563613e-35, -1.603824962119654e-36,  8.435452561992950e-26,
 -3.573425051736127e-26,  8.095775482764485e-27, -1.246562860713011e-27,  1.452482530412608e-28, -1.361182481978990e-29,  1.066993592981479e-30, -7.189760630012590e-32,
  4.249236614838496e-33, -2.236909990295903e-34,  1.061748142550836e-35, -4.582374408518005e-37,  1.718097335055068e-26, -7.472888738725737e-27,  1.742837234212379e-27,
 -2.761991706880208e-28,  3.309702093336148e-29, -3.186786381746678e-30,  2.564065111556713e-31, -1.771688894317338e-32,  1.072694796356399e-33, -5.779724205007089e-35,
  2.805372165513318e-36, -1.237021263874483e-37,  6.381444370626474e-02, -1.678764174480513e-04,  4.563891064069302e-07, -1.276957684093737e-09,  3.650929919673139e-12,
 -1.063422328097256e-14,  3.119190570917659e-17, -9.304398833952226e-20,  2.727680768456105e-22, -8.400164928429034e-25,  2.320577052672807e-27, -8.178513707131272e-30,
  5.663232607265347e-02, -1.731401935624148e-04,  6.420617469290413e-07, -2.538030479915119e-09,  1.006272638949974e-11, -3.932713110762786e-14,  1.509129523745011e-16,
 -5.703952601233901e-19,  2.121170742162401e-21, -7.818203570906681e-24,  2.831827935105807e-26, -1.028223122906024e-28,  4.459815397535287e-02, -1.745510118320387e-04,
  9.046476412535293e-07, -4.633092598409197e-09,  2.265340811885818e-11, -1.065857568813553e-13,  4.865943360865098e-16, -2.167546495546415e-18,  9.455153778102669e-21,
 -4.050357109063856e-23,  1.707008815437989e-25, -7.092011763814998e-28,  3.116020403610427e-02, -1.622648995370401e-04,  1.095821632579922e-06, -6.782308405046460e-09,
  3.920553982797435e-11, -2.159127779258439e-13,  1.144852302260280e-15, -5.881282841760354e-18,  2.940975280939715e-20, -1.436182117376993e-22,  6.869809148878742e-25,
 -3.224418171977399e-27,  1.931086854484007e-02, -1.341835198884007e-04,  1.116268703679477e-06, -8.125210142799586e-09,  5.463890917047370e-11, -3.469830244670260e-13,
  2.104811504254764e-15, -1.228795865658293e-17,  6.943828522056530e-20, -3.813854968445575e-22,  2.043155324296562e-24, -1.070204648037837e-26,  1.061142509761790e-02,
 -9.711329148398151e-05,  9.628174535404767e-07, -8.140767277489061e-09,  6.299480104658024e-11, -4.561190587879626e-13,  3.130839656180830e-15, -2.055743945046986e-17,
  1.299901389810005e-19, -7.954756370861874e-22,  4.729779349451553e-24, -2.740638375331489e-26,  5.168160549999096e-03, -6.116749005285396e-05,  7.096355337469582e-07,
 -6.914703979499189e-09,  6.103345975313517e-11, -4.995203539525879e-13,  3.848597908348001e-15, -2.820592302055892e-17,  1.981331119862969e-19, -1.341532420149559e-21,
  8.794212697947556e-24, -5.600646648811448e-26,  2.229872042851701e-03, -3.349840977007388e-05,  4.500830580371859e-07, -5.022038877659887e-09,  5.020424023352777e-11,
 -4.613789845098319e-13,  3.965505959659517e-15, -3.225029675501679e-17,  2.502740806015477e-19, -1.864976771788620e-21,  1.341005898956926e-23, -9.340068621627345e-26,
  8.518693692327052e-04, -1.596480721836985e-05,  2.468579923633357e-07, -3.136876177452706e-09,  3.531497564471253e-11, -3.625481555452952e-13,  3.459439629907619e-15,
 -3.107817819812010e-17,  2.652865839944648e-19, -2.166581799228214e-21,  1.701975434364505e-23, -1.291417348651168e-25,  2.879819852492850e-04, -6.630380636703388e-06,
  1.174832056394780e-07, -1.692124564293284e-09,  2.135680017523008e-11, -2.439255943317680e-13,  2.574163684524862e-15, -2.545239088887120e-17,  2.381601202946531e-19,
 -2.124691458212877e-21,  1.817667634845532e-23, -1.497913210448885e-25,  8.609906185557056e-05, -2.403001513407438e-06,  4.863231207141490e-08, -7.907608860695373e-10,
  1.114885735805520e-11, -1.412044251598445e-13,  1.643011747385063e-15, -1.782886036941669e-17,  1.823698405785236e-19, -1.772575649237476e-21,  1.647269644655173e-23,
 -1.470729339086140e-25,  2.275184998385102e-05, -7.609384005801532e-07,  1.754147501743317e-08, -3.209205860144720e-10,  5.039838769900046e-12, -7.059891229175040e-14,
  9.035428563335427e-16, -1.073563481208435e-17,  1.197845025940664e-19, -1.265819542759916e-21,  1.275268002744618e-23, -1.231181771531634e-25,  5.311079490546084e-06,
 -2.107603275118469e-07,  5.520793681888334e-09, -1.133312936665048e-10,  1.977914124379341e-12, -3.058107542248139e-14,  4.296651197322904e-16, -5.579871598148531e-18,
  6.779528665999448e-20, -7.776444156024946e-22,  8.480044416600681e-24, -8.839158170036327e-26,  1.094706514305510e-06, -5.110714602286007e-08,  1.517888825103327e-09,
 -3.488468849849803e-11,  6.753729934355935e-13, -1.150670340096473e-14,  1.772198098936412e-16, -2.512012421367682e-18,  3.319191134958817e-20, -4.127456246996817e-22,
  4.865929262435938e-24, -5.469726276430293e-26,  1.991717712726019e-07, -1.085971643373846e-08,  3.649711065876613e-10, -9.373934202296609e-12,  2.010347046308871e-13,
 -3.769711586100063e-15,  6.357323219739789e-17, -9.825540533513017e-19,  1.410541317032629e-20, -1.899801719546803e-22,  2.419227947291367e-24, -2.930176298825627e-26,
  3.198457432349974e-08, -2.024034680194707e-09,  7.683513659924699e-11, -2.202311348166684e-12,  5.226485604154423e-14, -1.077688783564292e-15,  1.988513909980769e-17,
 -3.348720365932406e-19,  5.219681053034208e-21, -7.609753759968917e-23,  1.046085225299738e-24, -1.364428199727832e-26,  4.534741562272658e-09, -3.312716269833212e-10,
  1.418188754019633e-11, -4.531452680492989e-13,  1.189120987365326e-14, -2.694662455555434e-16,  5.437515158258019e-18, -9.973266773886512e-20,  1.687228664647639e-21,
 -2.661652445258454e-23,  3.948472600897474e-25, -5.544156518641282e-27,  5.680584884381527e-10, -4.768474964425856e-11,  2.298952981723552e-12, -8.182209457300356e-14,
  2.373072560792320e-15, -5.908119916249997e-17,  1.303502543255852e-18, -2.603541755642083e-20,  4.779856861150982e-22, -8.158168001939058e-24,  1.305883594818363e-25,
 -1.973718529704574e-27,  6.296369689293905e-11, -6.049447335633225e-12,  3.280544863763334e-13, -1.299819974800913e-14,  4.165570281580200e-16, -1.139309501709278e-17,
  2.748386931184500e-19, -5.978247240024562e-21,  1.191175967971075e-22, -2.199863783848044e-24,  3.799996627921018e-26, -6.182659295495441e-28,  6.189939768544030e-12,
 -6.783809943157792e-13,  4.133748658160979e-14, -1.822759231957072e-15,  6.454479151138757e-17, -1.939620858822489e-18,  5.117083378057319e-20, -1.212483971186247e-21,
  2.622717494293176e-23, -5.242473121540040e-25,  9.775043802299710e-27, -1.712512125335589e-28,  5.417441115876388e-13, -6.752426105326835e-14,  4.619583349266829e-15,
 -2.266534933311079e-16,  8.869514890527169e-18, -2.929399477868124e-19,  8.455202527903374e-21, -2.183342664088396e-22,  5.129358833912694e-24, -1.110205196273831e-25,
  2.235452718512722e-27, -4.218681353982559e-29,  4.244306730392111e-14, -6.000871249908719e-15,  4.605937859528632e-16, -2.514393207862155e-17,  1.087668666403603e-18,
 -3.949930053450095e-20,  1.247960700935342e-21, -3.513864569712719e-23,  8.970928642507078e-25, -2.103656822391061e-26,  4.576677574019604e-28, -9.308444325518237e-30,
  3.000420404132654e-15, -4.800524326238703e-16,  4.131154097016897e-17, -2.509289048622126e-18,  1.200299019838818e-19, -4.795321528674964e-21,  1.659406245676337e-22,
 -5.097951235542228e-24,  1.415254528195187e-25, -3.597819958604450e-27,  8.462288150926318e-29, -1.855979049277986e-30,  1.935640964589275e-16, -3.496363866722201e-17,
  3.371218616281139e-18, -2.278388710339377e-19,  1.205542416456042e-20, -5.301044951909066e-22,  2.010355235683400e-23, -6.742848482778822e-25,  2.036761330977353e-26,
 -5.616656058686187e-28,  1.429068762397437e-29, -3.381675271537078e-31,  1.157694342853611e-17, -2.355073983705341e-18,  2.542157675446304e-19, -1.911325462521314e-20,
  1.118876281356789e-21, -5.417105751461723e-23,  2.252430066892314e-24, -8.252091255781879e-26,  2.713544545017305e-27, -8.121203702977627e-29,  2.236269103115619e-30,
 -5.711863989145256e-32,  6.560932624764676e-19, -1.498888618659659e-19,  1.809170814581163e-20, -1.512452786322898e-21,  9.793871741258047e-23, -5.221115873208754e-24,
  2.380584707400215e-25, -9.528500000706855e-27,  3.411669648883996e-28, -1.108374793850404e-29,  3.303691544885359e-31, -9.109403081475656e-33,  3.629656384457444e-20,
 -9.279781072999595e-21,  1.250154778813397e-21, -1.160761570202335e-22,  8.308276826022048e-24, -4.874255211360538e-25,  2.436040358170446e-26, -1.064886355868459e-27,
  4.150292512690520e-29, -1.463190681765995e-30,  4.719375576337349e-32, -1.404292840784997e-33,  2.040050609440179e-21, -5.810016247329689e-22,  8.710924306740729e-23,
 -8.963590443849072e-24,  7.079198803813008e-25, -4.563702014593331e-26,  2.496693917934789e-27, -1.190475742706864e-28,  5.044439829484708e-30, -1.927680332461254e-31,
  6.720344838932366e-33, -2.155473529386837e-34,  1.227507044791635e-22, -3.870051435456639e-23,  6.428498236390349e-24, -7.303686407918258e-25,  6.343819671763419e-26,
 -4.480447411344285e-27,  2.675664538191135e-28, -1.387958140182258e-29,  6.377977875192638e-31, -2.635320798384553e-32,  9.906341006178372e-34, -3.416662728223541e-35,
  8.446406797648953e-24, -2.923151872539501e-24,  5.343017731338971e-25, -6.662111951003550e-26,  6.328850412724156e-27, -4.871781547047195e-28,  3.160343291339098e-29,
 -1.775149571255849e-30,  8.806353266409312e-32, -3.917193402339174e-33,  1.580983017288864e-34, -5.839019220006195e-36,  7.182884508306920e-25, -2.698192182625763e-25,
  5.373084119817293e-26, -7.285369552841343e-27,  7.504549459420577e-28, -6.244975066237993e-29,  4.366410086330223e-30, -2.635894528626721e-31,  1.401545861249677e-32,
 -6.664696269693113e-34,  2.868540881095003e-35, -1.127024798591611e-36,  8.167372869261314e-26, -3.281988986925684e-26,  7.022293695126619e-27, -1.021858853612396e-27,
  1.127136962955504e-28, -1.001886424073354e-29,  7.463908818886119e-31, -4.789298653099677e-32,  2.700494878825164e-33, -1.358764861053974e-34,  6.174961642967186e-36,
 -2.556153495929019e-37,  1.298283441258210e-26, -5.481771136595946e-27,  1.237509247054504e-27, -1.898808457617981e-28,  2.204991805444516e-29, -2.059684140036784e-30,
  1.609511554084088e-31, -1.081316891952753e-32,  6.372525963421057e-34, -3.345527131429521e-35,  1.583811177508167e-36, -6.818503872326420e-38,  2.480788769610162e-27,
 -1.077893147744689e-27,  2.510967345512122e-28, -3.974707284095676e-29,  4.757537816891792e-30, -4.575850765188756e-31,  3.677809545507272e-32, -2.538660287981801e-33,
  1.535555371836494e-34, -8.265769531470203e-36,  4.008368250957380e-37, -1.765915084661667e-38,  6.315014459436476e-02, -1.642856214167826e-04,  4.414092142590271e-07,
 -1.220204475244142e-09,  3.445525468851949e-12, -9.915921313680118e-15,  2.870445167284727e-17, -8.478203624962527e-20,  2.441133985390605e-22, -7.541941098056308e-25,
  1.974885778733490e-27, -7.582725064340637e-30,  5.594984918289189e-02, -1.681228465135553e-04,  6.125460699411855e-07, -2.383127703593957e-09,  9.311147784095244e-12,
 -3.588945536690877e-14,  1.358513663083823e-16, -5.068110181414737e-19,  1.859058965806684e-21, -6.771088594774460e-24,  2.415240564789824e-26, -8.703309043169911e-29,
  4.391408066562908e-02, -1.675302154076563e-04,  8.511569110887517e-07, -4.287077307326019e-09,  2.063373077387993e-11, -9.560290026491729e-14,  4.299287913362702e-16,
 -1.887052486758975e-18,  8.112767837397582e-21, -3.426066190128391e-23,  1.423606237954413e-25, -5.833350877281003e-28,  3.052817676276463e-02, -1.538135321316528e-04,
  1.018059848457552e-06, -6.188127060769361e-09,  3.514924007847634e-11, -1.903106823904373e-13,  9.926109540268860e-16, -5.017856766553729e-18,  2.470175767943753e-20,
 -1.187781187681693e-22,  5.596573982577417e-25, -2.587625291373792e-27,  1.879139755633723e-02, -1.256290287077380e-04,  1.023791090070371e-06, -7.303872826883394e-09,
  4.817778016246746e-11, -3.003573580924318e-13,  1.789900295425528e-15, -1.027071505059820e-17,  5.707270003145405e-20, -3.083495653096201e-22,  1.625532016201394e-24,
 -8.380306074707859e-27,  1.023778162083371e-02, -8.978504181400829e-05,  8.708874181018323e-07, -7.201934471926411e-09,  5.457951865821222e-11, -3.874413736706247e-13,
  2.609409102881553e-15, -1.682166886276842e-17,  1.044866787469773e-19, -6.283604985436928e-22,  3.673079175486159e-24, -2.093046199303167e-26,  4.934341716141780e-03,
 -5.580643842114684e-05,  6.322041673091288e-07, -6.013329487621705e-09,  5.190626695554900e-11, -4.159570565667783e-13,  3.140792817742075e-15, -2.257503642097742e-17,
  1.556178560180762e-19, -1.034506660240590e-21,  6.661212240926647e-24, -4.168509060895356e-26,  2.102716452107001e-03, -3.012581677965411e-05,  3.943496373718821e-07,
 -4.287712152323994e-09,  4.185966503606201e-11, -3.761964750314242e-13,  3.165221211769243e-15, -2.521976130981088e-17,  1.918756696384295e-19, -1.402558236558953e-21,
  9.897788217875025e-24, -6.768697408886229e-26,  7.917343352596723e-04, -1.413143082928547e-05,  2.123802780014098e-07, -2.625612647449884e-09,  2.882846084936925e-11,
 -2.890722287023393e-13,  2.697249616583378e-15, -2.371592654562280e-17,  1.982878896335663e-19, -1.587187457234888e-21,  1.222696188717223e-23, -9.102370567095418e-26,
  2.632193307862615e-04, -5.766278022670196e-06,  9.907721940961568e-08, -1.386314818429450e-09,  1.704252966816531e-11, -1.899024426298301e-13,  1.957624092156631e-15,
 -1.892671416074353e-17,  1.733117817242048e-19, -1.514157734772227e-21,  1.269314816972081e-23, -1.025541854435414e-25,  7.720908971649717e-05, -2.049068558267617e-06,
  4.012678013987398e-08, -6.329879683843434e-10,  8.681829340019826e-12, -1.071579020815521e-13,  1.216750446455979e-15, -1.289852209899920e-17,  1.290073985346630e-19,
 -1.226993483676013e-21,  1.116515243745463e-23, -9.766714385551545e-26,  1.996617289466025e-05, -6.347400854882829e-07,  1.413121218313637e-08, -2.504956889696303e-10,
  3.822434267420396e-12, -5.212674824557747e-14,  6.504028952728663e-16, -7.542894049670992e-18,  8.222554175482743e-20, -8.496306476194627e-22,  8.375703299049004e-24,
 -7.917301743957583e-26,  4.548460219513480e-06, -1.715389775213400e-07,  4.332194103911162e-09, -8.606637601881870e-11,  1.457922240125553e-12, -2.192250410170479e-14,
  3.000184857582686e-16, -3.799799460480986e-18,  4.507147999861265e-20, -5.051615284879701e-22,  5.386730028268508e-24, -5.494263262285005e-26,  9.121509551781663e-07,
 -4.047089832940471e-08,  1.157202019610940e-09, -2.571061705111130e-11,  4.826410053115584e-13, -7.989936723224973e-15,  1.197624752606564e-16, -1.654300183030016e-18,
  2.132467154074114e-20, -2.589372062613226e-22,  2.983262607502176e-24, -3.279576470640008e-26,  1.609302930267593e-07, -8.340449327176546e-09,  2.695402380432461e-10,
 -6.686144397884707e-12,  1.389086461693219e-13, -2.528796313852369e-15,  4.147261397553222e-17, -6.241943742497709e-19,  8.736211767564511e-21, -1.148274355193595e-22,
  1.428189281330352e-24, -1.690851308273168e-26,  2.496852657714915e-08, -1.502332664116918e-09,  5.478958815024678e-11, -1.515451842607265e-12,  3.481179275451695e-14,
 -6.963572990030869e-16,  1.248671849449992e-17, -2.046435004103322e-19,  3.108006040014258e-21, -4.419502935730679e-23,  5.930956828608095e-25, -7.558084066582636e-27,
  3.406205198523896e-09, -2.367009168321510e-10,  9.728468050303563e-12, -2.997600354362639e-13,  7.608830700191200e-15, -1.671621858691497e-16,  3.276078354196368e-18,
 -5.844531077265623e-20,  9.629042837759798e-22, -1.480885800135083e-23,  2.143715678460837e-25, -2.939720522324766e-27,  4.086896674464975e-10, -3.265498606382382e-11,
  1.510805910362934e-12, -5.182607162460183e-14,  1.453140780766930e-15, -3.505577556350650e-17,  7.508062494896879e-19, -1.457942061918619e-20,  2.605582603076186e-22,
 -4.333877299055708e-24,  6.767125901327170e-26, -9.985741846310252e-28,  4.316666482986098e-11, -3.950864641780879e-12,  2.055683330978561e-13, -7.847800149042977e-15,
  2.430476428960138e-16, -6.438799179633191e-18,  1.507255569959549e-19, -3.186352938954745e-21,  6.178371013062151e-23, -1.111641269430062e-24,  1.872654255757401e-26,
 -2.974047495552742e-28,  4.020667720860838e-12, -4.201831451451100e-13,  2.456880094294609e-14, -1.043691215421414e-15,  3.570836050763213e-17, -1.039143745291913e-18,
  2.659694983250211e-20, -6.123603944992278e-22,  1.288783794970306e-23, -2.509370970149532e-25,  4.562391745359328e-27, -7.801113187840816e-29,  3.312326692488557e-13,
 -3.941720176647076e-14,  2.588621044036910e-15, -1.223727883861969e-16,  4.626956818240336e-18, -1.479830736786885e-19,  4.143711231043690e-21, -1.039659388055008e-22,
  2.376380145886678e-24, -5.010126377170315e-26,  9.836849772207741e-28, -1.811861681618783e-29,  2.424819506632380e-14, -3.278101532103246e-15,  2.416937836045662e-16,
 -1.271780137301758e-17,  5.316975806221797e-19, -1.870175815932542e-20,  5.733226490284817e-22, -1.568752419486970e-23,  3.897239983518189e-25, -8.903403885414872e-27,
  1.889075848959050e-28, -3.750702222070827e-30,  1.588487146635548e-15, -2.434491417970858e-16,  2.014558500155142e-17, -1.180332073007995e-18,  5.459790120182069e-20,
 -2.113655431174235e-21,  7.099981492650571e-23, -2.120517314282807e-24,  5.730533011259727e-26, -1.419784996717971e-27,  3.257990983207152e-29, -6.978062530597317e-31,
  9.408147918091949e-17, -1.631373632694907e-17,  1.514717956141740e-18, -9.885349579177517e-20,  5.062598814260675e-21, -2.158875484340442e-22,  7.953188320465262e-24,
 -2.595062838346750e-25,  7.635549806863079e-27, -2.053400664730249e-28,  5.100299650210652e-30, -1.179342367933385e-31,  5.112595928750121e-18, -1.000994423165583e-18,
  1.042437548242150e-19, -7.579878400554518e-21,  4.300377474418708e-22, -2.021520883372211e-23,  8.174021852018100e-25, -2.916268033049369e-26,  9.350149586749021e-28,
 -2.731525019319231e-29,  7.349399291881755e-31, -1.835946077404721e-32,  2.602863676377951e-19, -5.740711012463396e-20,  6.700837205753594e-21, -5.428591525277022e-22,
  3.412970366126363e-23, -1.769435225378937e-24,  7.857517032000488e-26, -3.067075228489847e-27,  1.072198979509948e-28, -3.404597583070768e-30,  9.928208629895459e-32,
 -2.680715952823012e-33,  1.278121752597014e-20, -3.166048025513821e-21,  4.136919619982217e-22, -3.731923183799597e-23,  2.599473859866296e-24, -1.486307904708258e-25,
  7.249159028023031e-27, -3.096201204566453e-28,  1.180318356314488e-29, -4.074237215340957e-31,  1.287803672787627e-32, -3.758526636047449e-34,  6.300350957426070e-22,
 -1.745740567296968e-22,  2.547706922557147e-23, -2.555250891322220e-24,  1.969676211092695e-25, -1.240907061934789e-26,  6.642074955427565e-28, -3.101965778784641e-29,
  1.288635002213096e-30, -4.832154873167549e-32,  1.654415394618665e-33, -5.215383549345299e-35,  3.289655739578540e-23, -1.013810859220706e-23,  1.646092173459862e-24,
 -1.829872548948555e-25,  1.556812518946010e-26, -1.078121684208333e-27,  6.319203563901464e-29, -3.220201144913902e-30,  1.454881481690063e-31, -5.914952224964590e-33,
  2.189350305422054e-34, -7.440276591220489e-36,  1.950534915834188e-24, -6.632168700189735e-25,  1.190567802572139e-25, -1.458921244360551e-26,  1.363167091392841e-27,
 -1.032919527692848e-28,  6.600852342057606e-30, -3.655101806311117e-31,  1.788752318196740e-32, -7.853981461092296e-34,  3.130804313360141e-35, -1.142692460623090e-36,
  1.429291600825291e-25, -5.302493946417510e-26,  1.042294416794188e-26, -1.395560211524835e-27,  1.420328738339904e-28, -1.168441741733578e-29,  8.080722503962078e-31,
 -4.827564299176722e-32,  2.541520234426688e-33, -1.197158685373631e-34,  5.106273989242070e-36, -1.988986540906870e-37,  1.416131428053853e-26, -5.647634651563117e-27,
  1.198699498276525e-27, -1.730640851817927e-28,  1.894583873385437e-29, -1.671950319285919e-30,  1.237039934993227e-31, -7.885710336251378e-33,  4.418711883206762e-34,
 -2.210063070909582e-35,  9.986657151812472e-37, -4.111638076556914e-38,  2.013732320677108e-27, -8.472071459795372e-28,  1.905131297564183e-28, -2.912015026490695e-29,
  3.369106529449898e-30, -3.135958434412645e-31,  2.442264651062412e-32, -1.635481624928223e-33,  9.608611711834594e-35, -5.029550010434338e-36,  2.374321928237969e-37,
 -1.019419927829789e-38,  3.591329485221553e-28, -1.558650947891486e-28,  3.626359110832287e-29, -5.733158034565268e-30,  6.853994110544673e-31, -6.584501054243222e-32,
  5.286245772686391e-33, -3.644913331848655e-34,  2.202366044633445e-35, -1.184308841197212e-36,  5.737497489192614e-38, -2.525305640077061e-39,  6.249997322409745e-02,
 -1.608119951675546e-04,  4.270911055728332e-07, -1.166625976107725e-09,  3.253908282787265e-12, -9.254643082119057e-15,  2.643594071421280e-17, -7.739022290449139e-20,
  2.183049401085242e-22, -6.817643179639422e-25,  1.648642830379167e-27, -7.304069764866739e-30,  5.528698092123071e-02, -1.633343888761129e-04,  5.848192815827698e-07,
 -2.239719208443901e-09,  8.624847367289828e-12, -3.279280746854748e-14,  1.224581582545263e-16, -4.510420680412067e-19,  1.631803519538313e-21, -5.877564752787174e-24,
  2.061853566590737e-26, -7.401763199137823e-29,  4.325726023294687e-02, -1.609212692160747e-04,  8.016314918135949e-07, -3.971690903016759e-09,  1.882072275797016e-11,
 -8.589042470119505e-14,  3.805479772420754e-16, -1.646127313531866e-18,  6.975988797095703e-21, -2.904794068522690e-23,  1.190194462934222e-25, -4.811091524481102e-28,
  2.992875442039385e-02, -1.459568039432537e-04,  9.470551117506998e-07, -5.654940776136457e-09,  3.157031796601329e-11, -1.680884997131669e-13,  8.625640857462731e-16,
 -4.291709296271301e-18,  2.080270477493356e-20, -9.851192162803213e-23,  4.573236216933570e-25, -2.083119669443271e-27,  1.830472492149136e-02, -1.177766233766087e-04,
  9.405787492240324e-07, -6.578845682968485e-09,  4.257793971732850e-11, -2.606541618758950e-13,  1.526305517036132e-15, -8.610135857965141e-18,  4.705880797070152e-20,
 -2.501414823952895e-22,  1.297920439466689e-24, -6.586795521271086e-27,  9.892048514260104e-03, -8.314935726709735e-05,  7.894587273007834e-07, -6.387403726584389e-09,
  4.742066532830701e-11, -3.301097429450085e-13,  2.182003917025096e-15, -1.381338205755754e-17,  8.430253771511217e-20, -4.983205828659337e-22,  2.864382974995700e-24,
 -1.605445856945763e-26,  4.720793346786430e-03, -5.102393306674371e-05,  5.647653863594439e-07, -5.245491965348569e-09,  4.429248449832634e-11, -3.476331853176343e-13,
  2.573156710219947e-15, -1.814309995061810e-17,  1.227603985108626e-19, -8.014131394919131e-22,  5.069845318735416e-24, -3.118132514725660e-26,  1.988212265660259e-03,
 -2.716599018127476e-05,  3.466800723892548e-07, -3.674249680522974e-09,  3.504158750478609e-11, -3.080552436853201e-13,  2.537950361962861e-15, -1.981666860551727e-17,
  1.478463406581935e-19, -1.060359682961336e-21,  7.345574680931147e-24, -4.933216179536687e-26,  7.384176681356176e-04, -1.255099428045918e-05,  1.834604767282418e-07,
 -2.207305137237197e-09,  2.364406171912079e-11, -2.316393858859623e-13,  2.114076974063451e-15, -1.819785352939035e-17,  1.490659261924768e-19, -1.169722141660839e-21,
  8.838554658529606e-24, -6.457006176907454e-26,  2.416402778998700e-04, -5.035840728229631e-06,  8.395999130752623e-08, -1.141635512378753e-09,  1.367442201787353e-11,
 -1.486992151834207e-13,  1.497775803186025e-15, -1.416309314900920e-17,  1.269490067948837e-19, -1.086397724582234e-21,  8.926114630754675e-24, -7.072119407225858e-26,
  6.960986823847999e-05, -1.756229431029077e-06,  3.329847907899749e-08, -5.097522159318419e-10,  6.803685838438571e-12, -8.186123305062321e-14,  9.073157153930025e-16,
 -9.398595371755571e-18,  9.193635707170832e-20, -8.558342728394686e-22,  7.627261287098691e-24, -6.538193274766087e-26,  1.763564415890535e-05, -5.327485373902244e-07,
  1.146037717807792e-08, -1.968956946336280e-10,  2.920313320793318e-12, -3.878027209092059e-14,  4.718650346482268e-16, -5.342653362673253e-18,  5.691446253001126e-20,
 -5.751669760255120e-22,  5.549288010684806e-24, -5.137059561963011e-26,  3.925597276122386e-06, -1.406470047296044e-07,  3.426064328433408e-09, -6.588944012528041e-11,
  1.083634699309178e-12, -1.585124071602181e-14,  2.113533681717421e-16, -2.611209036091124e-18,  3.024434623456649e-20, -3.312912028441202e-22,  3.455161357397615e-24,
 -3.449095505310097e-26,  7.669990986455586e-07, -3.232731642803271e-08,  8.902007525165512e-10, -1.912504495734666e-11,  3.481980653599844e-13, -5.602226908452857e-15,
  8.174333432538617e-17, -1.100582784581522e-18,  1.384318364799877e-20, -1.641696438817505e-22,  1.848766229592369e-24, -1.987965646281034e-26,  1.314216749502233e-07,
 -6.470798969069833e-09,  2.011329422200507e-10, -4.819552481545161e-12,  9.701885580243733e-14, -1.715051434473475e-15,  2.735845943144340e-17, -4.010585108192267e-19,
  5.473461795915182e-21, -7.021947198661979e-23,  8.531749984482981e-25, -9.874732918932514e-27,  1.973274959047155e-08, -1.128250427241177e-09,  3.953437170660363e-11,
 -1.055360995803816e-12,  2.346971994790894e-14, -4.555189080555457e-16,  7.939129603681422e-18, -1.266451756211751e-19,  1.874368256929082e-21, -2.599989479493344e-23,
  3.406705053687184e-25, -4.242072209792738e-27,  2.594893928513263e-09, -1.714209119751867e-10,  6.763924320893144e-12, -2.009922180764135e-13,  4.935393135099569e-15,
 -1.051312161563522e-16,  2.001323914240907e-18, -3.473119611484894e-20,  5.573099762657534e-22, -8.356812266370389e-24,  1.180581034525071e-25, -1.581269871828695e-27,
  2.987988380392669e-10, -2.270848600815601e-11,  1.008087036528094e-12, -3.332921545874936e-14,  9.034719556799132e-16, -2.112034511606331e-17,  4.391370482096321e-19,
 -8.290840808531260e-21,  1.442459295735775e-22, -2.338268718253779e-24,  3.561732967236677e-26, -5.131616033307241e-28,  3.013773630831723e-11, -2.625549231167243e-12,
  1.310402149101993e-13, -4.819441694240241e-15,  1.442338117044663e-16, -3.700969870825372e-18,  8.406972710810028e-20, -1.727259463766622e-21,  3.259247880115124e-23,
 -5.713219914939257e-25,  9.386011655016432e-27, -1.455024148983642e-28,  2.665597200554417e-12, -2.653972852869946e-13,  1.488489860630888e-14, -6.090249977871806e-16,
  2.012944942820677e-17, -5.672040428913659e-19,  1.408343476150379e-20, -3.150464303597175e-22,  6.450862710366988e-24, -1.223425911035295e-25,  2.168835637716952e-27,
 -3.619227821098853e-29,  2.072005596406159e-13, -2.351777647417459e-14,  1.481795718223573e-15, -6.746948350076087e-17,  2.464206306974443e-18, -7.630284854518697e-20,
  2.072401677490201e-21, -5.051406960311360e-23,  1.123208027676973e-24, -2.306370559681340e-26,  4.414971398816494e-28, -7.936016988186901e-30,  1.420835333208378e-14,
 -1.834603721126037e-15,  1.298473068591238e-16, -6.582637740412031e-18,  2.658739345968398e-19, -9.054825535907110e-21,  2.692661209178484e-22, -7.158145735678518e-24,
  1.730034693460748e-25, -3.849663586027994e-27,  7.964276799544164e-29, -1.543339875155545e-30,  8.646958786458055e-16, -1.267879612050258e-16,  1.008054308673948e-17,
 -5.693530595172789e-19,  2.545445119035375e-20, -9.544673099816905e-22,  3.111022277771319e-23, -9.029757858026659e-25,  2.374663230445368e-26, -5.732176924280760e-28,
  1.282921307222377e-29, -2.682650921685949e-31,  4.713256504085919e-17, -7.835217600881870e-18,  6.998731302211857e-19, -4.407213711777641e-20,  2.183180433903105e-21,
 -9.023425153628908e-23,  3.227494179948280e-24, -1.024012116592709e-25,  2.933626629402760e-27, -7.690544116689897e-29,  1.864052798557222e-30, -4.210248133310801e-32,
  2.332366393771668e-18, -4.388767485144315e-19,  4.404546575440024e-20, -3.094531499223920e-21,  1.700167117717322e-22, -7.754315851336045e-24,  3.047172482368469e-25,
 -1.058064533246390e-26,  3.305853255267311e-28, -9.422144284004907e-30,  2.475868736660833e-31, -6.046275552046030e-33,  1.068643363140598e-19, -2.271918233121126e-20,
  2.561366928803492e-21, -2.008752633344483e-22,  1.225010570077294e-23, -6.171218987132496e-25,  2.666975433376223e-26, -1.014491248672005e-27,  3.460351103710814e-29,
 -1.073274083374090e-30,  3.060213615105203e-32, -8.086807066083062e-34,  4.662809465418773e-21, -1.117309082449516e-21,  1.414107078936044e-22, -1.237948889548595e-23,
  8.382667581808762e-25, -4.666755068523482e-26,  2.219284921320340e-27, -9.253823371937718e-29,  3.447881896300267e-30, -1.164422377360772e-31,  3.604429176059636e-33,
 -1.031138049135905e-34,  2.015765462880319e-22, -5.425448001126746e-23,  7.696202829259643e-24, -7.514149323353569e-25,  5.646818739532014e-26, -3.472993637666588e-27,
  1.817035310944145e-28, -8.303889392300056e-30,  3.379142489986717e-31, -1.242393280664598e-32,  4.174279614595376e-34, -1.292415175498161e-35,  9.118253293696422e-24,
 -2.742602127400767e-24,  4.346660522783603e-25, -4.721739802164326e-26,  3.930206474797707e-27, -2.665859885005990e-28,  1.532070307174659e-29, -7.662427465836672e-31,
  3.400674497205771e-32, -1.359252274649894e-33,  4.950012661598120e-35, -1.656308093596451e-36,  4.641496477067984e-25, -1.548412897069972e-25,  2.726379080338284e-26,
 -3.279408811256550e-27,  3.010471014501465e-28, -2.243144895821702e-29,  1.410778542993708e-30, -7.694218282344679e-32,  3.711384446743256e-33, -1.607269853761635e-34,
  6.323251206901958e-36, -2.279104506341705e-37,  2.913279007261641e-26, -1.066235240119079e-26,  2.066608248782815e-27, -2.729668676107820e-28,  2.742265164296270e-29,
 -2.228221197979929e-30,  1.522977850251037e-31, -8.997269535168704e-33,  4.686487145452693e-34, -2.185213920116743e-35,  9.230773417883508e-37, -3.562517110026300e-38,
  2.495901464434345e-27, -9.871494053676385e-28,  2.076860214544046e-28, -2.972916531367386e-29,  3.227920396944987e-30, -2.826375292023033e-31,  2.075625593588967e-32,
 -1.313769905502600e-33,  7.311954399599990e-35, -3.633619558381580e-36,  1.631854720278375e-37, -6.679299533263074e-39,  3.150024352310379e-28, -1.320026272091134e-28,
  2.955712852980675e-29, -4.498933566501807e-30,  5.184143393505208e-31, -4.806777673750749e-32,  3.729694411328018e-33, -2.488833729525410e-34,  1.457303883848289e-35,
 -7.603680330984111e-37,  3.578507654383901e-38, -1.531952852893864e-39,  5.213573506654456e-29, -2.259929281280067e-29,  5.250832958829034e-30, -8.290224156213888e-31,
  9.897982923223659e-32, -9.496758564315828e-33,  7.614985335115520e-34, -5.244420767744459e-35,  3.165244206920386e-36, -1.700231756690336e-37,  8.228265942135515e-39,
 -3.617929366589167e-40,  6.186347126877442e-02, -1.574503931534655e-04,  4.133979706761562e-07, -1.116010436848539e-09,  3.074988510945456e-12, -8.645416467932072e-15,
  2.436321248088367e-17, -7.078506173014959e-20,  1.948710248185311e-22, -6.222491533515621e-25,  1.326233660353654e-27, -7.427629058438079e-30,  5.464283350307773e-02,
 -1.587610440154694e-04,  5.587494989567274e-07, -2.106813004534941e-09,  7.997387898208751e-12, -2.999965117821413e-14,  1.105293178825651e-16, -4.020568275542698e-19,
  1.434301935751135e-21, -5.114664662935778e-24,  1.760396889323758e-26, -6.337254802437200e-29,  4.262610647044458e-02, -1.546938666137651e-04,  7.557228683635740e-07,
 -3.683820801641036e-09,  1.719063874514509e-11, -7.728608124575768e-14,  3.374307667243334e-16, -1.438748296568620e-18,  6.011091903581425e-21, -2.468479679077613e-23,
  9.974361390430687e-26, -3.978656735420162e-28,  2.935966210602694e-02, -1.386434614643814e-04,  8.821191695554645e-07, -5.175624609559336e-09,  2.840620505685620e-11,
 -1.487569083716483e-13,  7.512068608961752e-16, -3.679406755671913e-18,  1.756460706106047e-20, -8.192739695874508e-23,  3.748213535801597e-25, -1.682024477144146e-27,
  1.784818353908544e-02, -1.105565804343368e-04,  8.655542817862088e-07, -5.937392021183813e-09,  3.771248740269848e-11, -2.267536464774370e-13,  1.305018578639779e-15,
 -7.238855885926580e-18,  3.892237922801370e-20, -2.035859965676663e-22,  1.039973833478314e-24, -5.195833126137119e-27,  9.571614552656843e-03, -7.712786831878559e-05,
  7.171532642481265e-07, -5.678771530891124e-09,  4.131233053679136e-11, -2.820939257641734e-13,  1.830449848848617e-15, -1.138193124144075e-17,  6.826581255367911e-20,
 -3.967129769065747e-22,  2.242823535863772e-24, -1.236647620384326e-26,  4.525351541421416e-03, -4.674605346330444e-05,  5.058525389673682e-07, -4.589243190858680e-09,
  3.791841576411265e-11, -2.915549267899599e-13,  2.116073565770602e-15, -1.463977543598855e-17,  9.725179603337890e-20, -6.236084054322138e-22,  3.876703740450405e-24,
 -2.343780897522048e-26,  1.884828807732286e-03, -2.455982991654105e-05,  3.057599792005067e-07, -3.159743101166775e-09,  2.944726684897873e-11, -2.533015679663090e-13,
  2.043961118819975e-15, -1.564363324512190e-17,  1.144778778682049e-19, -8.057532739362259e-22,  5.480555361510697e-24, -3.615380582802667e-26,  6.909899401230182e-04,
 -1.118316493221731e-05,  1.590982418140983e-07, -1.863469716427383e-09,  1.948000883521480e-11, -1.865135958233425e-13,  1.665444163956133e-15, -1.403846326336743e-17,
  1.126897877183706e-19, -8.670813405900783e-22,  6.427791730915183e-24, -4.609095904783807e-26,  2.227584787399442e-04, -4.415453830624145e-06,  7.148094530314645e-08,
 -9.448105484849632e-10,  1.103000959368734e-11, -1.170861645229140e-13,  1.152660933352600e-15, -1.066323753191772e-17,  9.358014492091871e-20, -7.846195718448769e-22,
  6.319798306237463e-24, -4.911157139944510e-26,  6.308144274541112e-05, -1.512576265639335e-06,  2.778417958182870e-08, -4.128917386960762e-10,  5.364505476729659e-12,
 -6.293763668640682e-14,  6.811000847327292e-16, -6.895910605552211e-18,  6.598872034279207e-20, -6.013748908090691e-22,  5.250184548344635e-24, -4.411214868397272e-26,
  1.567410040085716e-05, -4.497773747425032e-07,  9.354246533811671e-09, -1.558076032691403e-10,  2.246826023839702e-12, -2.906254353536606e-14,  3.449372231939602e-16,
 -3.813908216991554e-18,  3.971312731029892e-20, -3.925988975195639e-22,  3.707964815292425e-24, -3.362178928251664e-26,  3.413205152898491e-06, -1.161288537783038e-07,
  2.729787439405235e-09, -5.083490210990621e-11,  8.119341643704812e-13, -1.155689763438114e-14,  1.501702942407374e-16, -1.810250190488903e-18,  2.047854631468244e-20,
 -2.192771311141533e-22,  2.237184290762484e-24, -2.186116497685033e-26,  6.506028357765833e-07, -2.603687413626647e-08,  6.907484378639310e-10, -1.435328111710760e-11,
  2.535130642046817e-13, -3.965115788996433e-15,  5.633291257398899e-17, -7.394420914770716e-19,  9.077205960548268e-21, -1.051570597012253e-22,  1.157709903874840e-24,
 -1.217875649386286e-26,  1.084244089026836e-07, -5.069077525674319e-09,  1.515861147245830e-10, -3.509473340298336e-12,  6.846742729186456e-14, -1.175531784114536e-15,
  1.824335963907987e-17, -2.605331889645286e-19,  3.467755110826371e-21, -4.343025867473404e-23,  5.155666705359964e-25, -5.834545065759897e-27,  1.578026788113402e-08,
 -8.568796723485053e-10,  2.885300208696405e-11, -7.434698196533462e-13,  1.600917523735097e-14, -3.015340056930096e-16,  5.108898310272688e-18, -7.933780916865412e-20,
  1.144448834064373e-21, -1.548823857536907e-23,  1.981695118506460e-25, -2.411534783904950e-27,  2.003861687626749e-09, -1.257590669163171e-10,  4.764059115077122e-12,
 -1.365348455917480e-13,  3.243660258211458e-15, -6.700236731143107e-17,  1.239084334135609e-18, -2.092012921984444e-20,  3.269918871124253e-22, -4.781183253277022e-24,
  6.592443304733252e-26, -8.625239391037346e-28,  2.218701245818633e-10, -1.602658717472990e-11,  6.825901803015932e-13, -2.175073699544671e-14,  5.700524988904975e-16,
 -1.291412793198040e-17,  2.606920001342051e-19, -4.785703168342423e-21,  8.106322230365033e-23, -1.280751844289304e-24,  1.903270236874002e-26, -2.677545512604170e-28,
  2.141468128834819e-11, -1.774316151514229e-12,  8.492552157304045e-14, -3.008772337978601e-15,  8.701069197094701e-17, -2.162494755566113e-18,  4.766797153774584e-20,
 -9.518401998083722e-22,  1.747885966175963e-23, -2.985100575349802e-25,  4.782720327098182e-27, -7.237193129740966e-29,  1.802607547341975e-12, -1.708322719138516e-13,
  9.186871866609881e-15, -3.619680273800726e-16,  1.155610722250351e-17, -3.152709490046990e-19,  7.593455818494590e-21, -1.650346039542794e-22,  3.287536063739811e-24,
 -6.072801547809553e-26,  1.049647663374524e-27, -1.709393556460149e-29,  1.325233715241086e-13, -1.433222629787992e-14,  8.659623389967801e-16, -3.796479918278955e-17,
  1.339089604186301e-18, -4.013677677990629e-20,  1.057224174668818e-21, -2.503148298119207e-23,  5.413862171931136e-25, -1.082593797655762e-26,  2.020279134992463e-28,
 -3.543630875297273e-30,  8.533674128365530e-15, -1.051253993756744e-15,  7.137845490659476e-17, -3.484642050555227e-18,  1.359269149683254e-19, -4.480965871417009e-21,
  1.292262979864517e-22, -3.336857335831254e-24,  7.844332617294216e-26, -1.699852894341184e-27,  3.428369627160684e-29, -6.483061858219628e-31,  4.837102033643878e-16,
 -6.777333428741957e-17,  5.173155096241941e-18, -2.814938145443290e-19,  1.215774097790152e-20, -4.413796239982785e-22,  1.395460748266661e-23, -3.934941435673699e-25,
  1.006716557002876e-26, -2.366973009302958e-28,  5.165492482876980e-30, -1.054252344927412e-31,  2.432704193067216e-17, -3.871847675658550e-18,  3.324044022992601e-19,
 -2.018242681724136e-20,  9.664365078446363e-22, -3.869444522997434e-23,  1.343117106479186e-24, -4.141863665844905e-26,  1.154851533589895e-27, -2.950064283041475e-29,
  6.975169164414159e-31, -1.538364726711894e-32,  1.098881150532886e-18, -1.984358616006472e-19,  1.917094155756881e-20, -1.300256940652790e-21,  6.912647739926003e-23,
 -3.056902399980887e-24,  1.166714905207719e-25, -3.940567679258792e-27,  1.199176455957396e-28, -3.332845802064332e-30,  8.549131879430516e-32, -2.040053462026090e-33,
  4.540572076040273e-20, -9.290483575893729e-21,  1.010403684835765e-21, -7.662864618970956e-23,  4.528709090103851e-24, -2.215021336642187e-25,  9.308901919618614e-27,
 -3.448402948177529e-28,  1.146914519713349e-29, -3.472630581749336e-31,  9.675796018369469e-33, -2.501038265327927e-34,  1.762939732587788e-21, -4.079725615234903e-22,
  4.994559080357551e-23, -4.238072089393378e-24,  2.786872306601000e-25, -1.509192962484665e-26,  6.991681212696126e-28, -2.843829944035137e-29,  1.034823421183028e-30,
 -3.416843857040220e-32,  1.035094736883849e-33, -2.900638600933992e-35,  6.686300128903261e-23, -1.745161893658549e-23,  2.402807495972192e-24, -2.280779223589029e-25,
  1.669036540671062e-26, -1.001061321015217e-27,  5.114335596630947e-29, -2.285052684337614e-30,  9.100854963561112e-32, -3.278137500724046e-33,  1.080035531764382e-34,
 -3.281889277373855e-36,  2.617025527789319e-24, -7.670034696843613e-25,  1.184814116700667e-25, -1.256031582585138e-26,  1.021610878152287e-27, -6.779738611242949e-29,
  3.816375201431522e-30, -1.871482318212493e-31,  8.151632426603604e-33, -3.200516588343966e-34,  1.145824517085542e-35, -3.772089645851407e-37,  1.139805431017263e-25,
 -3.725178126608212e-26,  6.424648115201847e-27, -7.575987186229909e-28,  6.824813313875415e-29, -4.995131491962900e-30,  3.088705198647650e-31, -1.657588742692828e-32,
  7.873769577969297e-34, -3.360354955750990e-35,  1.303704561708263e-36, -4.636913788713360e-38,  6.092208717195135e-27, -2.197048313313460e-27,  4.194073240179893e-28,
 -5.458961375019462e-29,  5.407910195947444e-30, -4.336099733918571e-31,  2.926467708546206e-32, -1.708210423192356e-33,  8.796550082710933e-35, -4.057236337934380e-36,
  1.696162073547034e-37, -6.481799417950076e-39,  4.477538442189939e-28, -1.754834114402223e-28,  3.656674251219055e-29, -5.185656706582719e-30,  5.580342799481822e-31,
 -4.844725070366661e-32,  3.529145595905131e-33, -2.216627315188679e-34,  1.224677101994502e-35, -6.043584349448399e-37,  2.696165899910646e-38, -1.096596701570088e-39,
  4.973354903995228e-29, -2.075026476207125e-29,  4.624497267263334e-30, -7.006717032180375e-31,  8.038259973590667e-32, -7.421713304830300e-33,  5.735526119685202e-34,
 -3.812655427526772e-35,  2.224289498613986e-36, -1.156506877691181e-37,  5.424741151358972e-39, -2.314964607538126e-40,  7.591587452082937e-30, -3.286325259873907e-30,
  7.624383023811517e-31, -1.202011169578628e-31,  1.433087062089749e-32, -1.373113056815770e-33,  1.099580525237432e-34, -7.563177012490842e-36,  4.559147955466018e-37,
 -2.446100962250279e-38,  1.182451923527918e-39, -5.193542609856089e-41,  };
  int offset = -34;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 34;
    if (std::isnan(t)) {
      fill_n(rr+offset, 34, 0.5);
      fill_n(ww+offset, 34, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 34; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=34; ++j) {
        const int boxof = it*408+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
