# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from os.path import join, isdir, isfile, expanduser
from os import listdir, makedirs, environ, removedirs
from pickle import dump
import ConfigParser

class ConfigLoader(object):
    ref = None
    ref2 = None

    def __new__(cls, *args, **kws):
        # Singleton
        if cls.ref is None:
            cls.ref = super(ConfigLoader, cls).__new__(cls, args, kws)
        return cls.ref

    def __init__(self):
        if ConfigLoader.ref2 is None:
            ConfigLoader.ref2 = 42
            self.launch()

    def launch(self):
        self.config = ConfigParser.ConfigParser()

        # Set the configuration directory to XDG_CONFIG_HOME if exists
        # If not, set it to $HOME/.config/bluemindo
        # http://standards.freedesktop.org/basedir-spec/basedir-spec-0.6.html
        if environ.get('XDG_CONFIG_HOME'):
            self.confdir = join(environ.get('XDG_CONFIG_HOME'), 'bluemindo')
        else:
            self.confdir = join(expanduser('~'), '.config', 'bluemindo')

        if not isdir(self.confdir):
            makedirs(self.confdir)

        # Set the data directory to XDG_DATA_HOME if exists
        # If not, set it to $HOME/.local/share/bluemindo
        # http://standards.freedesktop.org/basedir-spec/basedir-spec-0.6.html
        if environ.get('XDG_DATA_HOME'):
            self.datadir = join(environ.get('XDG_DATA_HOME'), 'bluemindo')
        else:
            self.datadir = join(expanduser('~'), '.local', 'share', 'bluemindo')

        if not isdir(self.datadir):
            makedirs(self.datadir)

        # Create directories for extensions config files
        if not isdir(join(self.confdir, 'modules')):
            makedirs(join(self.confdir, 'modules'))

        if not isdir(join(self.confdir, 'plugins')):
            makedirs(join(self.confdir, 'plugins'))

        # Create the plugin configuration file
        if not isfile(join(self.confdir, 'Plugins.cfg')):
            default_plugins = ['notification']
            dump(default_plugins, open(join(self.confdir, 'Plugins.cfg'), 'w'))

        # Create the unofficial plugins directory
        self.unofficial_plugins = join(self.datadir, 'unofficial_plugins')
        if not isdir(self.unofficial_plugins):
            makedirs(self.unofficial_plugins)

        # Store the Bluemindo key for the Last.fm API
        # Don't use it, create your own here: http://www.lastfm.fr/api/account
        self.lastfm_key = 'MjZjOTgyYzk4NTVkZjcxMTIwMTgzY2UzZmJiNmI5ODA='

        # Store the Bluemindo key for the Amazon API
        # Don't use it, create your own here: http://aws.amazon.com/
        self.amazon_key = 'MFQxQ0M4REUxSFFHUldFTUJHODI='