
#include <string>
#include <iostream>
#include <openssl/x509.h>
#include <openssl/rsa.h>
#include <openssl/pem.h>
#include "../nssutil.h"

int main(void) {
  bool res;

  AuthN::Context context(AuthN::Context::EmptyContext);

  //std::string configdir =  "/home/wzqiang/.mozilla/firefox/ruu1txci.default";
  //std::string configdir =  "/Users/qiangweizhong/Library/Application Support/Firefox/Profiles/laixdvyo.default";
  std::string configdir = "./";
  res = AuthN::NSS::nssInit(context, configdir);

  std::string ca_certfile = "./trusted_certificates/a04aa180.0";

  std::string eec_certfile = "testCA/certs/cert.pem"; //"eec_cert.pem";
  std::string eec_keyfile = "testCA/certs/key.pem"; //"eec_key.pem";
  std::string eec_keyname = "eeckey";
  std::string eec_certname = "eeccert";
  const char* slotpw = "secretpw";
  bool ascii = true;
  const char* trusts = "u,u,u";

  res = AuthN::NSS::nssImportCertAndPrivateKey(context, slotpw, eec_keyfile.c_str(), eec_keyname, eec_certfile.c_str(), eec_certname, trusts, ascii);

  const char* eec_p12 = "eec.p12";
  const char* p12pw = "secretpw";
  res = AuthN::NSS::nssOutputPKCS12(context, eec_certname, eec_p12, slotpw, p12pw);

  std::string proxy_csrfile = "proxy.csr";
  std::string proxy_keyname = "myproxykey";
  std::string dn = "CN=Test,OU=EMI,O=Grid";
  std::string proxy_privk_str;
  res = AuthN::NSS::nssGenerateCSR(context, proxy_keyname, dn, slotpw, proxy_csrfile.c_str(), proxy_privk_str, ascii);

  std::string proxy_certfile = "myproxy.pem";
  std::string issuername = "eeccert";  
  //The name of the certificate imported in firefox is 
  //normally "Imported Certificate" by default, if name is not specified
  int duration = 12;
  //char* passwd;
  res = AuthN::NSS::nssCreateCert(context, proxy_csrfile.c_str(), issuername, "", duration, "", proxy_certfile.c_str(), ascii);

  const char* proxy_certname = "proxy";
  res = AuthN::NSS::nssImportCert(context, NULL, proxy_certfile.c_str(), proxy_certname, trusts, ascii);

  const char* proxy_p12 = "proxy.p12";
  res = AuthN::NSS::nssOutputPKCS12(context, proxy_certname, proxy_p12, slotpw, p12pw);

  std::vector<const char*> trusted_certfiles;
  std::vector<const char*> untrusted_certfiles;

  // Don't use pkix library
  std::cout<<"Verify eec cert using trusted cert in db, not using pkix library"<<std::endl;
  res = AuthN::NSS::nssVerifyCert(context, slotpw, eec_certfile.c_str(), false, untrusted_certfiles, trusted_certfiles, "");

  // Use pkix library, use trusted cert in db
  std::cout<<"Verify eec cert using trusted cert in db, using pkix library"<<std::endl;
  res = AuthN::NSS::nssVerifyCert(context, slotpw, eec_certfile.c_str(), true, untrusted_certfiles, trusted_certfiles, "");

  untrusted_certfiles.push_back(eec_certfile.c_str());
  std::cout<<"Verify proxy cert using trusted cert in db, using pkix library"<<std::endl;
  res = AuthN::NSS::nssVerifyCert(context, slotpw, proxy_certfile.c_str(), true, untrusted_certfiles, trusted_certfiles, "");

  trusted_certfiles.push_back(ca_certfile.c_str());
  // Use pkix library, use trusted cert from file, which overrides the trusted cert in db
  std::cout<<"Verify eec cert using trusted cert from external, using pkix library"<<std::endl;
  res = AuthN::NSS::nssVerifyCert(context, slotpw, eec_certfile.c_str(), true, untrusted_certfiles, trusted_certfiles, "");

  std::cout<<"Verify proxy cert using trusted cert from external, using pkix library"<<std::endl;
  res = AuthN::NSS::nssVerifyCert(context, slotpw, proxy_certfile.c_str(), true, untrusted_certfiles, trusted_certfiles, "");

  AuthN::NSS::nssFinish();

  // TODO: Handle res above. Add dummy usage of res
  if(!res) {}
  return 0;

}
