/*******************************************************************************
 * Copyright (c) 2013 Frank Becker and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Frank Becker - initial API and implementation
 *******************************************************************************/

package org.eclipse.mylyn.commons.core;

import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;

import junit.framework.TestCase;

public class HtmlStreamTokenizerTest extends TestCase {

	public void testDivSelfTerminatingNoSpace() throws IOException, ParseException {
		HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer(new StringReader("<div/>"), null);
		HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
		assertEquals("div", ((HtmlTag) token.getValue()).getTagName());
		assertTrue(((HtmlTag) token.getValue()).isSelfTerminating());
	}

	public void testDivSelfTerminatingLeadingSpace() throws IOException, ParseException {
		HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer(new StringReader("<div />"), null);
		HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
		assertEquals("div", ((HtmlTag) token.getValue()).getTagName());
		assertTrue(((HtmlTag) token.getValue()).isSelfTerminating());
	}

	public void testDivSelfTerminatingLeadingSpacePendingSpace() throws IOException, ParseException {
		HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer(new StringReader("<div / >"), null);
		HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
		assertEquals("div", ((HtmlTag) token.getValue()).getTagName());
		assertTrue(((HtmlTag) token.getValue()).isSelfTerminating());
	}

	public void testDivSelfTerminatingPendingSpace() throws IOException, ParseException {
		HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer(new StringReader("<div/ >"), null);
		HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
		assertEquals("div", ((HtmlTag) token.getValue()).getTagName());
		assertTrue(((HtmlTag) token.getValue()).isSelfTerminating());
	}

	public void testImgSelfTerminatingNoSpace() throws IOException, ParseException {
		HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer(new StringReader("<img src=\"test.png\"/>"),
				null);
		HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
		assertEquals("img", ((HtmlTag) token.getValue()).getTagName());
		assertTrue(((HtmlTag) token.getValue()).isSelfTerminating());
	}

	public void testImgSelfTerminatingLeadingSpace() throws IOException, ParseException {
		HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer(new StringReader("<img src=\"test.png\" />"),
				null);
		HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
		assertEquals("img", ((HtmlTag) token.getValue()).getTagName());
		assertTrue(((HtmlTag) token.getValue()).isSelfTerminating());
	}

	public void testImgSelfTerminatingLeadingSpacePendingSpace() throws IOException, ParseException {
		HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer(
				new StringReader("<img src=\"test.png\" / >"), null);
		HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
		assertEquals("img", ((HtmlTag) token.getValue()).getTagName());
		assertTrue(((HtmlTag) token.getValue()).isSelfTerminating());
	}

	public void testImgSelfTerminatingPendingSpace() throws IOException, ParseException {
		HtmlStreamTokenizer htmlStreamTokenizer = new HtmlStreamTokenizer(new StringReader("<img src=\"test.png\"/ >"),
				null);
		HtmlStreamTokenizer.Token token = htmlStreamTokenizer.nextToken();
		assertEquals("img", ((HtmlTag) token.getValue()).getTagName());
		assertTrue(((HtmlTag) token.getValue()).isSelfTerminating());
	}
}
