/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.Field;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.Text;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.VisADError;
import visad.VisADException;

public class Tuple
extends DataImpl
implements TupleIface {
    Data[] tupleComponents;
    public static int cloneCnt = 0;

    public Tuple(TupleType type) {
        super(type);
        if (type instanceof RealTupleType && !(this instanceof RealTuple)) {
            throw new VisADError("must construct as RealTuple");
        }
    }

    public Tuple(TupleType type, Data[] datums) throws VisADException, RemoteException {
        this(type, datums, true);
    }

    public Tuple(TupleType type, Data[] datums, boolean copy) throws VisADException, RemoteException {
        this(type, datums, copy, true);
    }

    public Tuple(TupleType type, Data[] datums, boolean copy, boolean checkType) throws VisADException, RemoteException {
        super(type);
        if (checkType && !Tuple.checkTupleType(type, datums)) {
            throw new TypeException("Tuple: type does not match data");
        }
        if (type instanceof RealTupleType && !(this instanceof RealTuple)) {
            throw new TypeException("must construct as RealTuple");
        }
        int n = datums.length;
        this.tupleComponents = new Data[n];
        for (int i = 0; i < n; ++i) {
            this.tupleComponents[i] = copy ? (Data)datums[i].dataClone() : datums[i];
            if (!(this.tupleComponents[i] instanceof DataImpl)) continue;
            ((DataImpl)this.tupleComponents[i]).setParent(this);
        }
    }

    public Tuple(Data[] datums, boolean copy) throws VisADException, RemoteException {
        this(Tuple.buildTupleType(datums), datums, copy, false);
    }

    public Tuple(Data[] datums) throws VisADException, RemoteException {
        this(Tuple.buildTupleType(datums), datums, true, false);
    }

    public static Tuple makeTuple(Data[] datums) throws VisADException, RemoteException {
        return new Tuple(datums);
    }

    static boolean checkTupleType(TupleType type, Data[] datums) throws VisADException, RemoteException {
        if (datums == null || type == null) {
            return false;
        }
        int n = datums.length;
        if (n != type.getDimension()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (type.getComponent(i).equals(datums[i].getType())) continue;
            return false;
        }
        return true;
    }

    public static TupleType buildTupleType(Data[] datums) throws VisADException, RemoteException {
        if (datums == null) {
            throw new TypeException("Tuple: # components must be > 0");
        }
        int n = datums.length;
        if (n < 1) {
            throw new TypeException("Tuple: # components must be > 0");
        }
        MathType[] types = new MathType[n];
        boolean allReal = true;
        for (int i = 0; i < n; ++i) {
            types[i] = datums[i].getType();
            if (types[i] instanceof RealType) continue;
            allReal = false;
        }
        if (allReal) {
            RealType[] real_types = new RealType[n];
            for (int i = 0; i < n; ++i) {
                real_types[i] = (RealType)types[i];
            }
            return new RealTupleType(real_types);
        }
        return new TupleType(types);
    }

    public Real[] getRealComponents() throws VisADException, RemoteException {
        if (this.getComponents(false) == null) {
            return null;
        }
        Vector<Data> reals = new Vector<Data>();
        for (int i = 0; i < this.getDimension(); ++i) {
            Data comp = this.getComponent(i);
            if (comp instanceof Real) {
                reals.addElement(comp);
                continue;
            }
            if (!(comp instanceof RealTuple)) continue;
            RealTuple rt = (RealTuple)comp;
            for (int j = 0; j < rt.getDimension(); ++j) {
                reals.addElement(rt.getComponent(j));
            }
        }
        if (reals.size() == 0) {
            return null;
        }
        Real[] realComponents = new Real[reals.size()];
        for (int i = 0; i < reals.size(); ++i) {
            realComponents[i] = (Real)reals.elementAt(i);
        }
        return realComponents;
    }

    public final Data[] getComponents() {
        return this.getComponents(true);
    }

    public Data[] getComponents(boolean copy) {
        if (!copy) {
            return this.tupleComponents;
        }
        if (this.tupleComponents == null) {
            return null;
        }
        ++cloneCnt;
        return (Data[])this.tupleComponents.clone();
    }

    public boolean isMissing() {
        return this.getComponents(false) == null;
    }

    public int getDimension() {
        if (this.tupleComponents != null) {
            return this.tupleComponents.length;
        }
        return ((TupleType)this.getType()).getDimension();
    }

    public Data getComponent(int i) throws VisADException, RemoteException {
        if (this.isMissing()) {
            return ((TupleType)this.Type).getComponent(i).missingData();
        }
        if (0 <= i && i < this.getDimension()) {
            return this.tupleComponents[i];
        }
        throw new TypeException("Tuple: component index out of range: " + i);
    }

    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof RealTuple) {
            throw new TypeException("Tuple.binary: types don't match");
        }
        if (data instanceof Tuple) {
            if (!this.Type.equalsExceptName(data.getType())) {
                throw new TypeException("Tuple.binary: types don't match");
            }
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException();
            }
            if (this.isMissing() || data.isMissing()) {
                return new Tuple((TupleType)new_type);
            }
            int dim = this.getDimension();
            Data[] datums = new Data[dim];
            for (int j = 0; j < dim; ++j) {
                MathType m_type = ((TupleType)new_type).getComponent(j);
                System.out.println("m_type = " + m_type);
                datums[j] = this.getComponent(j).binary(((Tuple)data).getComponent(j), op, m_type, sampling_mode, error_mode);
            }
            return new Tuple(datums);
        }
        if (data instanceof Real) {
            if (!this.Type.equalsExceptName(new_type)) {
                throw new TypeException();
            }
            if (this.isMissing() || data.isMissing()) {
                return new Tuple((TupleType)new_type);
            }
            int dim = this.getDimension();
            Data[] datums = new Data[this.getDimension()];
            for (int j = 0; j < dim; ++j) {
                MathType m_type = ((TupleType)new_type).getComponent(j);
                datums[j] = this.getComponent(j).binary(data, op, m_type, sampling_mode, error_mode);
            }
            return new Tuple(datums);
        }
        if (data instanceof Text) {
            throw new TypeException("Tuple.binary: types don't match");
        }
        if (data instanceof Field) {
            if (!data.getType().equalsExceptName(new_type)) {
                throw new TypeException();
            }
            return data.binary(this, Tuple.invertOp(op), new_type, sampling_mode, error_mode);
        }
        throw new TypeException("Tuple.binary");
    }

    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        if (new_type == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        if (!this.Type.equalsExceptName(new_type)) {
            throw new TypeException("unary: new_type doesn't match return type");
        }
        TupleType T_type = (TupleType)new_type;
        if (this.isMissing()) {
            return new Tuple((TupleType)new_type);
        }
        int dim = this.getDimension();
        Data[] datums = new Data[dim];
        for (int j = 0; j < dim; ++j) {
            datums[j] = this.getComponent(j).unary(op, T_type.getComponent(j), sampling_mode, error_mode);
        }
        return new Tuple(datums);
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        if (this.isMissing()) {
            return shadow;
        }
        for (int i = 0; i < this.getDimension(); ++i) {
            shadow = this.getComponent(i).computeRanges(((ShadowTupleType)type).getComponent(i), shadow);
        }
        return shadow;
    }

    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        if (this.isMissing() || error == null || error.isMissing()) {
            return this;
        }
        int n = this.getDimension();
        Data[] newComponents = new Data[n];
        for (int i = 0; i < n; ++i) {
            Data errorComponent = ((Tuple)error).getComponent(i);
            newComponents[i] = this.getComponent(i).adjustSamplingError(errorComponent, error_mode);
        }
        return new Tuple(newComponents);
    }

    public Data __getitem__(int index) throws VisADException, RemoteException {
        return this.getComponent(index);
    }

    public int __len__() {
        return this.getDimension();
    }

    public int getLength() {
        return this.getDimension();
    }

    public Object clone() throws CloneNotSupportedException {
        Tuple clone = (Tuple)super.clone();
        if (clone.tupleComponents != null) {
            clone.tupleComponents = new Data[this.tupleComponents.length];
            for (int i = 0; i < this.tupleComponents.length; ++i) {
                Data comp = this.tupleComponents[i];
                if (comp == null) {
                    clone.tupleComponents[i] = null;
                    continue;
                }
                try {
                    clone.tupleComponents[i] = (Data)this.tupleComponents[i].dataClone();
                    continue;
                }
                catch (RemoteException ex) {
                    throw new RuntimeException(ex.toString());
                }
            }
        }
        return clone;
    }

    public String longString(String pre) throws VisADException, RemoteException {
        String s = pre + "Tuple\n" + pre + "  Type: " + this.Type.toString() + "\n";
        if (this.isMissing()) {
            return s + "  missing\n";
        }
        for (int i = 0; i < this.getDimension(); ++i) {
            s = s + pre + "  Tuple Component " + i + ":\n" + this.getComponent(i).longString(pre + "    ");
        }
        return s;
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (!(obj instanceof Tuple)) {
            equals = false;
        } else {
            Tuple that = (Tuple)obj;
            if (this == that) {
                equals = true;
            } else if (this.tupleComponents == null || that.tupleComponents == null) {
                equals = this.tupleComponents == that.tupleComponents;
            } else if (this.tupleComponents.length != that.tupleComponents.length) {
                equals = false;
            } else {
                equals = true;
                for (int i = 0; i < this.tupleComponents.length; ++i) {
                    if (this.tupleComponents[i].equals(that.tupleComponents[i])) continue;
                    equals = false;
                    break;
                }
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.tupleComponents != null) {
            for (int i = 0; i < this.tupleComponents.length; ++i) {
                hashCode ^= this.tupleComponents[i].hashCode();
            }
        }
        return hashCode;
    }
}

