/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayStackTest
	extends junit.framework.TestCase
{
	public ArrayStackTest(String name) 
	{
		super(name);
	}

	public static ArrayStack<Object> newStack(int size) 
	{
		ArrayStack<Object> stack = new ArrayStack<Object>(1);
		for (int i = 0; i < size; i++)
			stack.add(new Integer(i)); 
		return stack;
	}

	public void testBasic()
	{
		ArrayStack<Object> stack = new ArrayStack<Object>(1);
		Object o = new Object();
		Object o2 = new Object();
		assertEquals("is empty", true, stack.isEmpty()); 
		stack.push(o);
		stack.push(o2);
		assertEquals("is empty", false, stack.isEmpty()); 
		assertEquals("size", 2, stack.size()); 
		assertEquals("same stuff", o2, stack.peek()); 
		assertEquals("same stuff", o2, stack.pop()); 
		assertEquals("same stuff", o, stack.peek()); 
		assertEquals("same stuff", o, stack.pop()); 
		stack.push(o);
		stack.clear();
		assertEquals("is empty", true, stack.isEmpty()); 
		stack.push(o);
		assertEquals("toString", "[" + o + "]", stack.toString()); 
	}

	public void testShrink() 
	{
		final int size = 1024;
		ArrayStack stack = newStack(size);
		stack.clear();
		assertEquals("capacity shrunk again", 1, stack.capacity());
	}

	public void testIterate() 
	{
		final int size = 10;
		ArrayStack stack = newStack(size);
		Iterator iterator = stack.iterator();
		// 9 8 7 6 5 4 3 2 1 0
		for (int i = size - 1; i >= 0; i--) {
			Integer n = (Integer)iterator.next();
			assertEquals("count " + i, i, n.intValue());
		}
		// System.out.println(stack);
	}

	public void testCoverage() 
	{
		new ArrayStack();
		ArrayStack<String> stack2 = new ArrayStack<String>(4);
		for (int i = 0; i < 1000; i++) {
			stack2.add("");
			stack2.add("");
			stack2.pop();
		}
		for (int i = 0; i < 1000; i++)
			stack2.pop();
	}

	public void testRemove() 
	{
		ArrayStack<Object> stack = new ArrayStack<Object>();
		stack.add("a");
		Iterator i = stack.iterator();
		assertTrue(i.hasNext());
		i.next();
		i.remove();
		assertTrue("at end", !i.hasNext());
	}

	public void testExceptions() 
	{
		try {
			new ArrayStack(-1);
			fail("Must not create negative sized stack");
		} catch (IllegalArgumentException e) {
		}
		try {
			new ArrayStack(0);
			fail("Must not create zero sized stack");
		} catch (IllegalArgumentException e) {
		}
		try {
			ArrayStack stack = new ArrayStack(1);
			stack.pop();
			fail("Must not pop from empty stack");
		} catch (NoSuchElementException e) {
		}
		try {
			ArrayStack stack = new ArrayStack(10);
			stack.peek();
			fail("Must not peek from empty stack");
		} catch (NoSuchElementException e) {
		}
		try {
			Collection stack = new ArrayStack(10);
			Iterator i = stack.iterator();
			assertTrue("Iterator empty  ", !i.hasNext());
			assertTrue("Iterator empty 2", !i.hasNext());
			i.next();
			fail("Must not next() from empty iterator");
		} catch (NoSuchElementException e) {
		}
		try {
			Collection<Object> stack = newStack(10);
			stack.add("");
			Iterator i = stack.iterator();
			i.remove();
			fail("Must call next() before remove()");
		} catch (UnsupportedOperationException e) {
		}
		try {
			Collection<Object> stack = newStack(10);
			stack.add(null);
			stack.add(null);
			Iterator i = stack.iterator();
			i.next();
			i.next();
			i.remove();
			fail("Must call remove() from non-top");
		} catch (UnsupportedOperationException e) {
		}
	}

	/*
	public static junit.framework.TestSuite suite() {
		return new org.hansel.CoverageDecorator(ArrayStackTest.class,
			new Class[] { ArrayStack.class });
	} 
	*/

	public static void main(String[] args) 
	{
		junit.textui.TestRunner.run(ArrayStackTest.class);
	}
}
