/*
 * @(#)LogTPUTest.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.tp.v1.log;

import java.io.*;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.*;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.AssertionFailedError;


/**
 * Tests the LogTP class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/29 13:05:55 $
 * @since     July 21, 2002
 */
public class LogTPUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = LogTPUTest.class;
    
    public LogTPUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
    }


    //-------------------------------------------------------------------------
    // Tests
    

    public void testPrintStep1()
    {
        LogTP tp = new LogTP( null, null );
        StringWriter sw = new StringWriter();
        tp.setOutput( new PrintWriter( sw ) );
        
        tp.printStep( "a", "text", 0 );
        
        String s = sw.toString();
        assertTrue(
            "Did not print right text (got "+s+").",
            s.indexOf( "1. a: 0. text" ) >= 0 );
    }
    

    public void testPrintStep2()
    {
        LogTP tp = new LogTP( null, null );
        StringWriter sw = new StringWriter();
        tp.setOutput( new PrintWriter( sw ) );
        tp.printStep( "a", "text", 0 );
        sw = new StringWriter();
        tp.setOutput( new PrintWriter( sw ) );
        
        tp.printStep( "b", "other", 18 );
        
        String s = sw.toString();
        assertTrue(
            "Did not print right text (got "+s+").",
            s.indexOf( "2. b: 18. other" ) >= 0 );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Helpers
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        InterfaceTestSuite suite = AutoDocTPUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new LogTP( ".", THIS_CLASS );
            }
        } );
        suite.addFactory( new CxFactory( "B" ) {
            public Object createImplObject() {
                return new LogTP( null, THIS_CLASS );
            }
        } );
        suite.addFactory( new CxFactory( "C" ) {
            public Object createImplObject() {
                return new LogTP( ".", THIS_CLASS );
            }
        } );
        suite.addFactory( new CxFactory( "D" ) {
            public Object createImplObject() {
                return new LogTP( null, null );
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

