/*
 * Copyright (C) 2005 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <locale.h>
#include <stdlib.h>
#include <translate.h>

int
main (int argc, char **argv)
{
  GError *err = NULL;
  GSList *services;
  TranslateSession *session;
  char *translation;

  setlocale(LC_ALL, "");	/* use user's locale */

  if (argc != 4)
    {
      g_printerr("Usage: translate FROM TO {TEXT | HTTP_URL | HTTPS_URL}\n");
      exit(1);
    }

  /* initialize libtranslate */
  if (! translate_init(&err))
    {
      g_printerr("Unable to initialize libtranslate: %s\n", err->message);
      g_error_free(err);
      exit(1);
    }

  /* create a session which will use all the services */
  services = translate_get_services();
  session = translate_session_new(services);
  g_slist_foreach(services, (GFunc) g_object_unref, NULL);
  g_slist_free(services);

  /* translate text or web page, depending on the string given */
  translation = (g_str_has_prefix(argv[3], "http://")
		 || g_str_has_prefix(argv[3], "https://"))
    ? translate_session_translate_web_page(session, argv[3], argv[1], argv[2],
					   NULL, NULL, &err)
    : translate_session_translate_text(session, argv[3], argv[1], argv[2],
				       NULL, NULL, &err);

  /* handle failure */
  if (! translation)
    {
      g_printerr("Unable to translate: %s\n", err->message);
      g_error_free(err);
      exit(1);
    }

  /* success, print the translation, cleanup and exit */
  g_print("%s\n", translation);
  g_free(translation);
  g_object_unref(session);

  return 0;
}
