// Generated by gmmproc 2.39.4 -- DO NOT MODIFY!


#include <glibmm.h>

#include <wnckmm/application.h>
#include <wnckmm/private/application_p.h>


/** This file is part of wnckmm

    Copyright (c) 2013 Povilas Kanapickas  <povilas@radix.lt>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this library.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <wnckmm/libwnck-wrapper.h>
#include <wnckmm/window.h>

namespace Wnck {

} // namespace Wnck

namespace
{


static const Glib::SignalProxyInfo Application_signal_name_changed_info =
{
  "name-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Application_signal_icon_changed_info =
{
  "icon-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


namespace Glib
{

Wnck::Application* wrap(WnckApplication* object, bool take_copy)
{
  return dynamic_cast<Wnck::Application*> (Glib::wrap_auto ((GObject*)(object), take_copy));
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Wnck
{


/* The *_Class implementation: */

const Glib::Class& Application_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Application_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(wnck_application_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Application_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->name_changed = &name_changed_callback;
  klass->icon_changed = &icon_changed_callback;
}


void Application_Class::name_changed_callback(WnckApplication* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_name_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->name_changed)
    (*base->name_changed)(self);
}
void Application_Class::icon_changed_callback(WnckApplication* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_icon_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->icon_changed)
    (*base->icon_changed)(self);
}


Glib::ObjectBase* Application_Class::wrap_new(GObject* object)
{
  return new Application((WnckApplication*)object);
}


Application::Application(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Application::Application(WnckApplication* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Application::~Application()
{}


Application::CppClassType Application::application_class_; // initialize static member

GType Application::get_type()
{
  return application_class_.init().get_type();
}


GType Application::get_base_type()
{
  return wnck_application_get_type();
}


Application::Application()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(application_class_.init()))
{
  

}

Window* Application::get_for_xid(gulong xid)
{
  return Glib::wrap(wnck_window_get(xid));
}


gulong Application::get_xid() const
{
  return wnck_application_get_xid(const_cast<WnckApplication*>(gobj()));
}

std::string Application::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(wnck_application_get_name(const_cast<WnckApplication*>(gobj())));
}

int Application::get_pid() const
{
  return wnck_application_get_pid(const_cast<WnckApplication*>(gobj()));
}

int Application::is_icon_fallback() const
{
  return wnck_application_get_icon_is_fallback(const_cast<WnckApplication*>(gobj()));
}

Glib::RefPtr<Gdk::Pixbuf> Application::get_icon() const
{
  Glib::RefPtr<Gdk::Pixbuf> retvalue = Glib::wrap(wnck_application_get_icon(const_cast<WnckApplication*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Gdk::Pixbuf> Application::get_mini_icon() const
{
  Glib::RefPtr<Gdk::Pixbuf> retvalue = Glib::wrap(wnck_application_get_mini_icon(const_cast<WnckApplication*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

std::string Application::get_startup_id() const
{
  return Glib::convert_const_gchar_ptr_to_stdstring(wnck_application_get_startup_id(const_cast<WnckApplication*>(gobj())));
}

Glib::ListHandle<Window*> Application::get_windows() const
{
  return Glib::ListHandle<Window*>(wnck_application_get_windows(const_cast<WnckApplication*>(gobj())), Glib::OWNERSHIP_NONE);
}

int Application::get_window_count() const
{
  return wnck_application_get_n_windows(const_cast<WnckApplication*>(gobj()));
}


Glib::SignalProxy0< void > Application::signal_name_changed()
{
  return Glib::SignalProxy0< void >(this, &Application_signal_name_changed_info);
}


Glib::SignalProxy0< void > Application::signal_icon_changed()
{
  return Glib::SignalProxy0< void >(this, &Application_signal_icon_changed_info);
}


void Wnck::Application::on_name_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->name_changed)
    (*base->name_changed)(gobj());
}
void Wnck::Application::on_icon_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->icon_changed)
    (*base->icon_changed)(gobj());
}


} // namespace Wnck


