/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// Local includes
#include "MsXpS/libXpertMassCore/FragmentationPathway.hpp"
#include "MsXpS/libXpertMassCore/FragmentationConfig.hpp"
#include "MsXpS/libXpertMassCore/CalcOptions.hpp"
#include "MsXpS/libXpertMassCore/Polymer.hpp"
#include "MsXpS/libXpertMassCore/Ionizer.hpp"
#include "MsXpS/libXpertMassCore/OligomerCollection.hpp"
#include "MsXpS/libXpertMassCore/CrossLinkedRegion.hpp"


namespace MsXpS
{
namespace libXpertMassCore
{


class DECLSPEC Fragmenter
{

  public:
  Fragmenter(PolymerCstQSPtr polymer_cqsp,
             PolChemDefCstSPtr pol_chem_def_csp,
             const std::vector<FragmentationConfig> &fragmentation_configs,
             const CalcOptions &calc_options,
             const Ionizer &ionizer);

  Fragmenter(const Fragmenter &other);
  ~Fragmenter();

  void addFragmentationConfig(const FragmentationConfig &fragmentation_config);

  std::size_t transferOligomers(OligomerCollection &source,
                                OligomerCollection &dest_oligomers);

  void transferOligomer(OligomerSPtr &&source_oligomer_sp,
                        OligomerCollection &dest_oligomers);

  const OligomerCollection &getOligomerCollectionCstRef() const;
  OligomerCollection &getOligomerCollectionRef();

  bool fragment();
  int fragmentEndNone(const FragmentationConfig &fragmentation_config);
  int fragmentEndLeft(const FragmentationConfig &fragmentation_config);
  int fragmentEndRight(const FragmentationConfig &fragmentation_config);

  bool accountFragmentationRule(FragmentationRuleSPtr fragmentation_rule_sp,
                                bool only_for_checking,
                                std::size_t monomer_index,
                                Enums::FragEnd frag_end,
                                double &mono,
                                double &avg);

  std::size_t accountFormulas(OligomerSPtr &&template_oligomer_sp,
                      OligomerCollection &oligomers,
                      const FragmentationConfig &fragmentation_config,
                      const QString &name,
                      int charge);

  OligomerCollection
  accountIonizationLevels(OligomerCollection &oligomers,
                          const FragmentationConfig &fragmentation_config);

  protected:
  PolymerCstQSPtr mcsp_polymer;
  PolChemDefCstSPtr mcsp_polChemDef;

  std::vector<FragmentationConfig> m_fragmentationConfigs;
  CalcOptions m_calcOptions;
  Ionizer m_ionizer;

  OligomerCollection m_oligomers;

  // A container of CrossLinkedRegion instances that we compute in case
  // there are cross-links in the fragmented sequence.
  std::vector<CrossLinkedRegion> m_crossLinkedRegions;
};


} // namespace libXpertMassCore
} // namespace MsXpS
