/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui.mdi;

import gr.zeus.ui.mdi.JInternalFrameComparator;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public final class WindowManager {
    private int m_lastMenuItemsCount = 0;
    private final Hashtable<JRadioButtonMenuItem, JInternalFrame> m_radioMenuItemsAndFrames = new Hashtable();
    private final Hashtable<JInternalFrame, JRadioButtonMenuItem> m_framesAndRadioMenuItems = new Hashtable();
    private final JInternalFrameComparator m_frameComparator = new JInternalFrameComparator();
    private final FrameListener m_frameListener = new FrameListener();
    private final SelectFrameListener m_selectFrameListener = new SelectFrameListener();
    private final MenuItemActionListener m_radioMenuItemListener = new MenuItemActionListener();
    private JDesktopPane m_desktop = null;
    private JMenu m_windowsMenu = null;
    private boolean m_outlineDragMode = false;
    private boolean m_deiconifiablePolicy = false;
    private boolean m_closePolicy = false;
    private boolean m_autoPositionPolicy = true;
    private Point m_nextFramePos = new Point(0, 0);

    private void close_frame(JInternalFrame f) {
        if (f != null && !f.isClosed() && f.isClosable()) {
            try {
                if (this.m_closePolicy) {
                    f.setClosed(true);
                } else {
                    f.doDefaultCloseAction();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void iconify_frame(JInternalFrame f) {
        if (f != null && !f.isIcon() && f.isIconifiable()) {
            try {
                f.setIcon(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void deiconify_frame(JInternalFrame f) {
        if (f != null && f.isIcon() && f.isIconifiable()) {
            try {
                f.setIcon(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void restore_frame(JInternalFrame f) {
        if (f != null) {
            try {
                f.setMaximum(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void maximize_frame(JInternalFrame f) {
        if (f != null && !f.isMaximum() && f.isMaximizable()) {
            try {
                f.setMaximum(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void reset_frame(JInternalFrame f) {
        if (f != null) {
            f.pack();
        }
    }

    private void select_frame(JInternalFrame f) {
        if (f != null && !f.isSelected()) {
            try {
                f.setSelected(true);
                f.toFront();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void hide_frame(JInternalFrame f) {
        if (f != null && f.isVisible()) {
            f.setVisible(false);
            if (f.isSelected()) {
                try {
                    f.setSelected(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.m_frameListener.manualFireEvent();
        }
    }

    private boolean is_internal_frame_listener_attached(JInternalFrame jif) {
        boolean found = false;
        InternalFrameListener[] all = jif.getInternalFrameListeners();
        for (int i = 0; i < all.length; ++i) {
            if (all[i] != this.m_selectFrameListener) continue;
            found = true;
            break;
        }
        return found;
    }

    public WindowManager(JDesktopPane d, JMenu windowsMenu) {
        this.m_desktop = d;
        this.m_windowsMenu = windowsMenu;
        if (this.m_desktop == null) {
            throw new NullPointerException("JDesktopPane instance provided to WindowManager is NULL!");
        }
        if (this.m_windowsMenu == null) {
            throw new NullPointerException("JMenu instance provided to WindowManager is NULL!");
        }
        windowsMenu.addSeparator();
        this.m_lastMenuItemsCount = this.m_windowsMenu.getMenuComponentCount();
        this.m_desktop.addContainerListener(this.m_frameListener);
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        for (int i = 0; frames != null && i < frames.length; ++i) {
            frames[i].addInternalFrameListener(this.m_selectFrameListener);
        }
        this.m_frameListener.manualFireEvent();
    }

    public void setOutlineDragMode(boolean outline) {
        this.m_outlineDragMode = outline;
        if (this.m_desktop != null) {
            if (this.m_outlineDragMode) {
                this.m_desktop.setDragMode(1);
            } else {
                this.m_desktop.setDragMode(0);
            }
        }
    }

    public boolean getOutlineDragMode() {
        return this.m_outlineDragMode;
    }

    public void setDeiconifiablePolicy(boolean p) {
        this.m_deiconifiablePolicy = p;
    }

    public boolean getDeiconifiablePolicy() {
        return this.m_deiconifiablePolicy;
    }

    public void setClosePolicy(boolean p) {
        this.m_closePolicy = p;
    }

    public boolean getClosePolicy() {
        return this.m_closePolicy;
    }

    public void setAutoPositionPolicy(boolean p) {
        this.m_autoPositionPolicy = p;
    }

    public boolean getAutoPositionPolicy() {
        return this.m_autoPositionPolicy;
    }

    public int countFrames() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return 0;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        return frames.length;
    }

    public int countVisibleFrames() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return 0;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        int count = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible()) continue;
            ++count;
        }
        return count;
    }

    public void close() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame activeframe = this.m_desktop.getSelectedFrame();
        this.close_frame(activeframe);
    }

    public void closeAll() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            this.close_frame(frames[i]);
        }
    }

    public void minimize() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame activeframe = this.m_desktop.getSelectedFrame();
        this.iconify_frame(activeframe);
    }

    public void minimizeAll() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible()) continue;
            this.iconify_frame(frames[i]);
        }
    }

    public void restore() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame activeframe = this.m_desktop.getSelectedFrame();
        if (activeframe != null && (activeframe.isMaximum() || activeframe.isIcon())) {
            this.deiconify_frame(activeframe);
            this.restore_frame(activeframe);
        }
    }

    public void restoreAll() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible() || !frames[i].isMaximum() && !frames[i].isIcon()) continue;
            this.deiconify_frame(frames[i]);
            this.restore_frame(frames[i]);
        }
    }

    public void maximize() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame activeframe = this.m_desktop.getSelectedFrame();
        this.maximize_frame(activeframe);
    }

    public void maximizeAll() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible()) continue;
            this.maximize_frame(frames[i]);
        }
    }

    public void reset() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame activeframe = this.m_desktop.getSelectedFrame();
        this.reset_frame(activeframe);
    }

    public void resetAll() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible()) continue;
            this.reset_frame(frames[i]);
        }
    }

    public void hide() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        if (this.m_windowsMenu == null) {
            return;
        }
        JInternalFrame activeframe = this.m_desktop.getSelectedFrame();
        this.hide_frame(activeframe);
    }

    public void hideAll() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        if (this.m_windowsMenu == null) {
            return;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible()) continue;
            this.hide_frame(frames[i]);
        }
    }

    public void selectNext() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        if (frames.length < 2) {
            return;
        }
        JInternalFrame activeframe = this.m_desktop.getSelectedFrame();
        if (activeframe == null) {
            return;
        }
        Arrays.sort(frames, this.m_frameComparator);
        int next_frame = -1;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible() || frames[i] != activeframe) continue;
            for (int j = i + 1; j < frames.length; ++j) {
                if (frames[j].isIcon()) continue;
                next_frame = j;
                break;
            }
            if (next_frame == -1) {
                for (int k = 0; k < i; ++k) {
                    if (frames[k].isIcon()) continue;
                    next_frame = k;
                    break;
                }
            }
            if (next_frame != -1) break;
        }
        if (next_frame != -1) {
            this.select_frame(frames[next_frame]);
        }
    }

    public void selectPrevious() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        if (frames.length < 2) {
            return;
        }
        JInternalFrame activeframe = this.m_desktop.getSelectedFrame();
        if (activeframe == null) {
            return;
        }
        Arrays.sort(frames, this.m_frameComparator);
        int previous_frame = -1;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible() || frames[i] != activeframe) continue;
            for (int j = i - 1; j >= 0; --j) {
                if (frames[j].isIcon()) continue;
                previous_frame = j;
                break;
            }
            if (previous_frame == -1) {
                for (int k = frames.length - 1; k > i; --k) {
                    if (frames[k].isIcon()) continue;
                    previous_frame = k;
                    break;
                }
            }
            if (previous_frame != -1) break;
        }
        if (previous_frame != -1) {
            this.select_frame(frames[previous_frame]);
        }
    }

    public void cascade() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame activeframe = this.m_desktop.getSelectedFrame();
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        Arrays.sort(frames, this.m_frameComparator);
        int x = 0;
        int y = 0;
        int width = this.m_desktop.getWidth() / 2;
        int height = this.m_desktop.getHeight() / 2;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible() || !this.m_deiconifiablePolicy && frames[i].isIcon()) continue;
            this.deiconify_frame(frames[i]);
            frames[i].reshape(x, y, width, height);
            frames[i].moveToFront();
            if (frames[i] != activeframe) {
                int next_pos = frames[i].getHeight() - frames[i].getContentPane().getHeight();
                frames[i].setLocation(x, y);
                x += next_pos;
                y += next_pos;
            }
            if (x + width > this.m_desktop.getWidth()) {
                x = 0;
            }
            if (y + height <= this.m_desktop.getHeight()) continue;
            y = 0;
        }
        if (activeframe != null) {
            activeframe.moveToFront();
            activeframe.setLocation(x, y);
        }
    }

    public void tileVertically() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        int visibleFrames = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible()) continue;
            ++visibleFrames;
        }
        if (visibleFrames == 0) {
            return;
        }
        Arrays.sort(frames, this.m_frameComparator);
        int width = this.m_desktop.getWidth() / visibleFrames;
        int height = this.m_desktop.getHeight();
        int x = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible()) continue;
            try {
                frames[i].setMaximum(false);
                frames[i].setIcon(false);
                frames[i].moveToFront();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            frames[i].reshape(x, 0, width, height);
            x += width;
        }
    }

    public void tileHorizontally() {
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        int visibleFrames = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible()) continue;
            ++visibleFrames;
        }
        if (visibleFrames == 0) {
            return;
        }
        Arrays.sort(frames, this.m_frameComparator);
        int width = this.m_desktop.getWidth();
        int height = this.m_desktop.getHeight() / visibleFrames;
        int y = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible()) continue;
            try {
                frames[i].setMaximum(false);
                frames[i].setIcon(false);
                frames[i].moveToFront();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            frames[i].reshape(0, y, width, height);
            y += height;
        }
    }

    public void tile() {
        int sqrt;
        if (this.m_desktop == null || this.m_desktop.getAllFrames() == null || this.m_desktop.getAllFrames().length < 1) {
            return;
        }
        JInternalFrame[] frames = this.m_desktop.getAllFrames();
        int visibleFrames = 0;
        for (int i = 0; i < frames.length; ++i) {
            if (!frames[i].isVisible()) continue;
            ++visibleFrames;
        }
        if (visibleFrames == 0) {
            return;
        }
        Arrays.sort(frames, this.m_frameComparator);
        int numRows = sqrt = (int)Math.sqrt(frames.length);
        int numCols = sqrt;
        if (numRows * numCols < frames.length && numRows * ++numCols < frames.length) {
            ++numRows;
        }
        int width = this.m_desktop.getWidth() / numCols;
        int height = this.m_desktop.getHeight() / numRows;
        int x = 0;
        int y = 0;
        for (int i = 0; i < numRows; ++i) {
            int index;
            for (int j = 0; j < numCols && (index = i * numCols + j) < frames.length; ++j) {
                if (!frames[index].isVisible()) continue;
                try {
                    frames[index].setMaximum(false);
                    frames[index].setIcon(false);
                    frames[index].moveToFront();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                frames[index].reshape(x, y, width, height);
                x += width;
            }
            y += height;
            x = 0;
        }
    }

    private final class SelectFrameListener
    implements InternalFrameListener {
        private SelectFrameListener() {
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent ife) {
            JInternalFrame jif = ife.getInternalFrame();
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)WindowManager.this.m_framesAndRadioMenuItems.get(jif);
            item.setSelected(true);
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent ife) {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent ife) {
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent ife) {
            JInternalFrame jif = ife.getInternalFrame();
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)WindowManager.this.m_framesAndRadioMenuItems.get(jif);
            item.setSelected(false);
            if (jif.getDefaultCloseOperation() == 1) {
                WindowManager.this.m_frameListener.manualFireEvent();
            }
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent ife) {
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent ife) {
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent ife) {
        }
    }

    private final class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object o = ae.getSource();
            if (o instanceof JRadioButtonMenuItem) {
                JRadioButtonMenuItem item = (JRadioButtonMenuItem)o;
                JInternalFrame frame = (JInternalFrame)WindowManager.this.m_radioMenuItemsAndFrames.get(item);
                if (item.isSelected()) {
                    try {
                        if (!frame.isVisible()) {
                            frame.setVisible(true);
                            frame.toFront();
                        }
                        if (!frame.isSelected()) {
                            frame.setSelected(true);
                        }
                        if (frame.isIcon()) {
                            frame.setIcon(false);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    item.setSelected(true);
                }
                WindowManager.this.m_frameListener.manualFireEvent();
            }
        }
    }

    private final class FrameListener
    implements ContainerListener {
        private FrameListener() {
        }

        private void rebuild_menu() {
            if (WindowManager.this.m_desktop != null && WindowManager.this.m_windowsMenu != null) {
                while (WindowManager.this.m_windowsMenu.getMenuComponentCount() > WindowManager.this.m_lastMenuItemsCount) {
                    WindowManager.this.m_windowsMenu.remove(WindowManager.this.m_windowsMenu.getMenuComponentCount() - 1);
                }
                WindowManager.this.m_radioMenuItemsAndFrames.clear();
                WindowManager.this.m_framesAndRadioMenuItems.clear();
                JInternalFrame[] frames = WindowManager.this.m_desktop.getAllFrames();
                Arrays.sort(frames, WindowManager.this.m_frameComparator);
                for (int i = 0; i < frames.length; ++i) {
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem("" + (i + 1) + ": " + frames[i].getTitle(), frames[i].isSelected());
                    if (!frames[i].isVisible()) {
                        item.setForeground(UIManager.getColor("RadioButtonMenuItem.disabledForeground"));
                    }
                    item.addActionListener(WindowManager.this.m_radioMenuItemListener);
                    WindowManager.this.m_windowsMenu.add(item);
                    WindowManager.this.m_radioMenuItemsAndFrames.put(item, frames[i]);
                    WindowManager.this.m_framesAndRadioMenuItems.put(frames[i], item);
                }
            }
        }

        public void manualFireEvent() {
            this.rebuild_menu();
        }

        @Override
        public void componentAdded(ContainerEvent ce) {
            if (WindowManager.this.m_desktop != null && WindowManager.this.m_autoPositionPolicy && ce.getChild() != null && ce.getChild() instanceof JInternalFrame) {
                JInternalFrame jif = (JInternalFrame)ce.getChild();
                int w = jif.getWidth();
                int h = jif.getHeight();
                int visibleFrames = WindowManager.this.countVisibleFrames();
                if (visibleFrames == 1) {
                    Dimension desktopSize = WindowManager.this.m_desktop.getSize();
                    Dimension jifSize = jif.getSize();
                    WindowManager.this.m_nextFramePos.setLocation((desktopSize.width - jifSize.width) / 2, (desktopSize.height - jifSize.height) / 2);
                } else if (visibleFrames == 2) {
                    WindowManager.this.m_nextFramePos.setLocation(0, 0);
                }
                jif.setLocation(WindowManager.this.m_nextFramePos);
                int next_pos = h - jif.getContentPane().getHeight();
                ((WindowManager)WindowManager.this).m_nextFramePos.x += next_pos;
                ((WindowManager)WindowManager.this).m_nextFramePos.y += next_pos;
                if (((WindowManager)WindowManager.this).m_nextFramePos.x + w > WindowManager.this.m_desktop.getWidth()) {
                    ((WindowManager)WindowManager.this).m_nextFramePos.x = 0;
                }
                if (((WindowManager)WindowManager.this).m_nextFramePos.y + h > WindowManager.this.m_desktop.getHeight()) {
                    ((WindowManager)WindowManager.this).m_nextFramePos.y = 0;
                }
            }
            if (WindowManager.this.m_desktop != null) {
                JInternalFrame[] frames = WindowManager.this.m_desktop.getAllFrames();
                for (int i = 0; frames != null && i < frames.length; ++i) {
                    if (WindowManager.this.is_internal_frame_listener_attached(frames[i])) continue;
                    frames[i].addInternalFrameListener(WindowManager.this.m_selectFrameListener);
                }
            }
            this.rebuild_menu();
        }

        @Override
        public void componentRemoved(ContainerEvent ce) {
            this.rebuild_menu();
        }
    }
}

