/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef PICTURESCROLLAREA_H
#define PICTURESCROLLAREA_H

#include <QScrollArea>
#include <QResizeEvent>
#include <QScrollBar>
#include <QMouseEvent>
/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class PictureScrollArea : public QScrollArea
{
  Q_OBJECT
  private:
    int  m_lastX;
    int  m_lastY;

  public:
    PictureScrollArea(QWidget *parent = 0);
    ~PictureScrollArea(){};

  protected:
    void resizeEvent          (QResizeEvent* ev);
    void mousePressEvent      (QMouseEvent* ev);
    void mouseMoveEvent       (QMouseEvent* ev);
    void mouseDoubleClickEvent(QMouseEvent* ev);
};

#endif
