package azqueue

// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/xml"
	"errors"
	"net/http"
	"reflect"
	"strconv"
	"strings"
	"time"
	"unsafe"
)

// Metadata contains metadata key/value pairs.
type Metadata map[string]string

const mdPrefix = "x-ms-meta-"

const mdPrefixLen = len(mdPrefix)

// UnmarshalXML implements the xml.Unmarshaler interface for Metadata.
func (md *Metadata) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	tokName := ""
	for t, err := d.Token(); err == nil; t, err = d.Token() {
		switch tt := t.(type) {
		case xml.StartElement:
			tokName = strings.ToLower(tt.Name.Local)
			break
		case xml.CharData:
			if *md == nil {
				*md = Metadata{}
			}
			(*md)[tokName] = string(tt)
			break
		}
	}
	return nil
}

// Marker represents an opaque value used in paged responses.
type Marker struct {
	Val *string
}

// NotDone returns true if the list enumeration should be started or is not yet complete. Specifically, NotDone returns true
// for a just-initialized (zero value) Marker indicating that you should make an initial request to get a result portion from
// the service. NotDone also returns true whenever the service returns an interim result portion. NotDone returns false only
// after the service has returned the final result portion.
func (m Marker) NotDone() bool {
	return m.Val == nil || *m.Val != ""
}

// UnmarshalXML implements the xml.Unmarshaler interface for Marker.
func (m *Marker) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	var out string
	err := d.DecodeElement(&out, &start)
	m.Val = &out
	return err
}

// concatenates a slice of const values with the specified separator between each item
func joinConst(s interface{}, sep string) string {
	v := reflect.ValueOf(s)
	if v.Kind() != reflect.Slice && v.Kind() != reflect.Array {
		panic("s wasn't a slice or array")
	}
	ss := make([]string, 0, v.Len())
	for i := 0; i < v.Len(); i++ {
		ss = append(ss, v.Index(i).String())
	}
	return strings.Join(ss, sep)
}

func validateError(err error) {
	if err != nil {
		panic(err)
	}
}

// GeoReplicationStatusType enumerates the values for geo replication status type.
type GeoReplicationStatusType string

const (
	// GeoReplicationStatusBootstrap ...
	GeoReplicationStatusBootstrap GeoReplicationStatusType = "bootstrap"
	// GeoReplicationStatusLive ...
	GeoReplicationStatusLive GeoReplicationStatusType = "live"
	// GeoReplicationStatusNone represents an empty GeoReplicationStatusType.
	GeoReplicationStatusNone GeoReplicationStatusType = ""
	// GeoReplicationStatusUnavailable ...
	GeoReplicationStatusUnavailable GeoReplicationStatusType = "unavailable"
)

// PossibleGeoReplicationStatusTypeValues returns an array of possible values for the GeoReplicationStatusType const type.
func PossibleGeoReplicationStatusTypeValues() []GeoReplicationStatusType {
	return []GeoReplicationStatusType{GeoReplicationStatusBootstrap, GeoReplicationStatusLive, GeoReplicationStatusNone, GeoReplicationStatusUnavailable}
}

// ListQueuesIncludeType enumerates the values for list queues include type.
type ListQueuesIncludeType string

const (
	// ListQueuesIncludeMetadata ...
	ListQueuesIncludeMetadata ListQueuesIncludeType = "metadata"
	// ListQueuesIncludeNone represents an empty ListQueuesIncludeType.
	ListQueuesIncludeNone ListQueuesIncludeType = ""
)

// PossibleListQueuesIncludeTypeValues returns an array of possible values for the ListQueuesIncludeType const type.
func PossibleListQueuesIncludeTypeValues() []ListQueuesIncludeType {
	return []ListQueuesIncludeType{ListQueuesIncludeMetadata, ListQueuesIncludeNone}
}

// StorageErrorCodeType enumerates the values for storage error code type.
type StorageErrorCodeType string

const (
	// StorageErrorCodeAccountAlreadyExists ...
	StorageErrorCodeAccountAlreadyExists StorageErrorCodeType = "AccountAlreadyExists"
	// StorageErrorCodeAccountBeingCreated ...
	StorageErrorCodeAccountBeingCreated StorageErrorCodeType = "AccountBeingCreated"
	// StorageErrorCodeAccountIsDisabled ...
	StorageErrorCodeAccountIsDisabled StorageErrorCodeType = "AccountIsDisabled"
	// StorageErrorCodeAuthenticationFailed ...
	StorageErrorCodeAuthenticationFailed StorageErrorCodeType = "AuthenticationFailed"
	// StorageErrorCodeConditionHeadersNotSupported ...
	StorageErrorCodeConditionHeadersNotSupported StorageErrorCodeType = "ConditionHeadersNotSupported"
	// StorageErrorCodeConditionNotMet ...
	StorageErrorCodeConditionNotMet StorageErrorCodeType = "ConditionNotMet"
	// StorageErrorCodeEmptyMetadataKey ...
	StorageErrorCodeEmptyMetadataKey StorageErrorCodeType = "EmptyMetadataKey"
	// StorageErrorCodeInsufficientAccountPermissions ...
	StorageErrorCodeInsufficientAccountPermissions StorageErrorCodeType = "InsufficientAccountPermissions"
	// StorageErrorCodeInternalError ...
	StorageErrorCodeInternalError StorageErrorCodeType = "InternalError"
	// StorageErrorCodeInvalidAuthenticationInfo ...
	StorageErrorCodeInvalidAuthenticationInfo StorageErrorCodeType = "InvalidAuthenticationInfo"
	// StorageErrorCodeInvalidHeaderValue ...
	StorageErrorCodeInvalidHeaderValue StorageErrorCodeType = "InvalidHeaderValue"
	// StorageErrorCodeInvalidHTTPVerb ...
	StorageErrorCodeInvalidHTTPVerb StorageErrorCodeType = "InvalidHttpVerb"
	// StorageErrorCodeInvalidInput ...
	StorageErrorCodeInvalidInput StorageErrorCodeType = "InvalidInput"
	// StorageErrorCodeInvalidMarker ...
	StorageErrorCodeInvalidMarker StorageErrorCodeType = "InvalidMarker"
	// StorageErrorCodeInvalidMd5 ...
	StorageErrorCodeInvalidMd5 StorageErrorCodeType = "InvalidMd5"
	// StorageErrorCodeInvalidMetadata ...
	StorageErrorCodeInvalidMetadata StorageErrorCodeType = "InvalidMetadata"
	// StorageErrorCodeInvalidQueryParameterValue ...
	StorageErrorCodeInvalidQueryParameterValue StorageErrorCodeType = "InvalidQueryParameterValue"
	// StorageErrorCodeInvalidRange ...
	StorageErrorCodeInvalidRange StorageErrorCodeType = "InvalidRange"
	// StorageErrorCodeInvalidResourceName ...
	StorageErrorCodeInvalidResourceName StorageErrorCodeType = "InvalidResourceName"
	// StorageErrorCodeInvalidURI ...
	StorageErrorCodeInvalidURI StorageErrorCodeType = "InvalidUri"
	// StorageErrorCodeInvalidXMLDocument ...
	StorageErrorCodeInvalidXMLDocument StorageErrorCodeType = "InvalidXmlDocument"
	// StorageErrorCodeInvalidXMLNodeValue ...
	StorageErrorCodeInvalidXMLNodeValue StorageErrorCodeType = "InvalidXmlNodeValue"
	// StorageErrorCodeMd5Mismatch ...
	StorageErrorCodeMd5Mismatch StorageErrorCodeType = "Md5Mismatch"
	// StorageErrorCodeMessageNotFound ...
	StorageErrorCodeMessageNotFound StorageErrorCodeType = "MessageNotFound"
	// StorageErrorCodeMessageTooLarge ...
	StorageErrorCodeMessageTooLarge StorageErrorCodeType = "MessageTooLarge"
	// StorageErrorCodeMetadataTooLarge ...
	StorageErrorCodeMetadataTooLarge StorageErrorCodeType = "MetadataTooLarge"
	// StorageErrorCodeMissingContentLengthHeader ...
	StorageErrorCodeMissingContentLengthHeader StorageErrorCodeType = "MissingContentLengthHeader"
	// StorageErrorCodeMissingRequiredHeader ...
	StorageErrorCodeMissingRequiredHeader StorageErrorCodeType = "MissingRequiredHeader"
	// StorageErrorCodeMissingRequiredQueryParameter ...
	StorageErrorCodeMissingRequiredQueryParameter StorageErrorCodeType = "MissingRequiredQueryParameter"
	// StorageErrorCodeMissingRequiredXMLNode ...
	StorageErrorCodeMissingRequiredXMLNode StorageErrorCodeType = "MissingRequiredXmlNode"
	// StorageErrorCodeMultipleConditionHeadersNotSupported ...
	StorageErrorCodeMultipleConditionHeadersNotSupported StorageErrorCodeType = "MultipleConditionHeadersNotSupported"
	// StorageErrorCodeNone represents an empty StorageErrorCodeType.
	StorageErrorCodeNone StorageErrorCodeType = ""
	// StorageErrorCodeOperationTimedOut ...
	StorageErrorCodeOperationTimedOut StorageErrorCodeType = "OperationTimedOut"
	// StorageErrorCodeOutOfRangeInput ...
	StorageErrorCodeOutOfRangeInput StorageErrorCodeType = "OutOfRangeInput"
	// StorageErrorCodeOutOfRangeQueryParameterValue ...
	StorageErrorCodeOutOfRangeQueryParameterValue StorageErrorCodeType = "OutOfRangeQueryParameterValue"
	// StorageErrorCodePopReceiptMismatch ...
	StorageErrorCodePopReceiptMismatch StorageErrorCodeType = "PopReceiptMismatch"
	// StorageErrorCodeQueueAlreadyExists ...
	StorageErrorCodeQueueAlreadyExists StorageErrorCodeType = "QueueAlreadyExists"
	// StorageErrorCodeQueueBeingDeleted ...
	StorageErrorCodeQueueBeingDeleted StorageErrorCodeType = "QueueBeingDeleted"
	// StorageErrorCodeQueueDisabled ...
	StorageErrorCodeQueueDisabled StorageErrorCodeType = "QueueDisabled"
	// StorageErrorCodeQueueNotEmpty ...
	StorageErrorCodeQueueNotEmpty StorageErrorCodeType = "QueueNotEmpty"
	// StorageErrorCodeQueueNotFound ...
	StorageErrorCodeQueueNotFound StorageErrorCodeType = "QueueNotFound"
	// StorageErrorCodeRequestBodyTooLarge ...
	StorageErrorCodeRequestBodyTooLarge StorageErrorCodeType = "RequestBodyTooLarge"
	// StorageErrorCodeRequestURLFailedToParse ...
	StorageErrorCodeRequestURLFailedToParse StorageErrorCodeType = "RequestUrlFailedToParse"
	// StorageErrorCodeResourceAlreadyExists ...
	StorageErrorCodeResourceAlreadyExists StorageErrorCodeType = "ResourceAlreadyExists"
	// StorageErrorCodeResourceNotFound ...
	StorageErrorCodeResourceNotFound StorageErrorCodeType = "ResourceNotFound"
	// StorageErrorCodeResourceTypeMismatch ...
	StorageErrorCodeResourceTypeMismatch StorageErrorCodeType = "ResourceTypeMismatch"
	// StorageErrorCodeServerBusy ...
	StorageErrorCodeServerBusy StorageErrorCodeType = "ServerBusy"
	// StorageErrorCodeUnsupportedHeader ...
	StorageErrorCodeUnsupportedHeader StorageErrorCodeType = "UnsupportedHeader"
	// StorageErrorCodeUnsupportedHTTPVerb ...
	StorageErrorCodeUnsupportedHTTPVerb StorageErrorCodeType = "UnsupportedHttpVerb"
	// StorageErrorCodeUnsupportedQueryParameter ...
	StorageErrorCodeUnsupportedQueryParameter StorageErrorCodeType = "UnsupportedQueryParameter"
	// StorageErrorCodeUnsupportedXMLNode ...
	StorageErrorCodeUnsupportedXMLNode StorageErrorCodeType = "UnsupportedXmlNode"
)

// PossibleStorageErrorCodeTypeValues returns an array of possible values for the StorageErrorCodeType const type.
func PossibleStorageErrorCodeTypeValues() []StorageErrorCodeType {
	return []StorageErrorCodeType{StorageErrorCodeAccountAlreadyExists, StorageErrorCodeAccountBeingCreated, StorageErrorCodeAccountIsDisabled, StorageErrorCodeAuthenticationFailed, StorageErrorCodeConditionHeadersNotSupported, StorageErrorCodeConditionNotMet, StorageErrorCodeEmptyMetadataKey, StorageErrorCodeInsufficientAccountPermissions, StorageErrorCodeInternalError, StorageErrorCodeInvalidAuthenticationInfo, StorageErrorCodeInvalidHeaderValue, StorageErrorCodeInvalidHTTPVerb, StorageErrorCodeInvalidInput, StorageErrorCodeInvalidMarker, StorageErrorCodeInvalidMd5, StorageErrorCodeInvalidMetadata, StorageErrorCodeInvalidQueryParameterValue, StorageErrorCodeInvalidRange, StorageErrorCodeInvalidResourceName, StorageErrorCodeInvalidURI, StorageErrorCodeInvalidXMLDocument, StorageErrorCodeInvalidXMLNodeValue, StorageErrorCodeMd5Mismatch, StorageErrorCodeMessageNotFound, StorageErrorCodeMessageTooLarge, StorageErrorCodeMetadataTooLarge, StorageErrorCodeMissingContentLengthHeader, StorageErrorCodeMissingRequiredHeader, StorageErrorCodeMissingRequiredQueryParameter, StorageErrorCodeMissingRequiredXMLNode, StorageErrorCodeMultipleConditionHeadersNotSupported, StorageErrorCodeNone, StorageErrorCodeOperationTimedOut, StorageErrorCodeOutOfRangeInput, StorageErrorCodeOutOfRangeQueryParameterValue, StorageErrorCodePopReceiptMismatch, StorageErrorCodeQueueAlreadyExists, StorageErrorCodeQueueBeingDeleted, StorageErrorCodeQueueDisabled, StorageErrorCodeQueueNotEmpty, StorageErrorCodeQueueNotFound, StorageErrorCodeRequestBodyTooLarge, StorageErrorCodeRequestURLFailedToParse, StorageErrorCodeResourceAlreadyExists, StorageErrorCodeResourceNotFound, StorageErrorCodeResourceTypeMismatch, StorageErrorCodeServerBusy, StorageErrorCodeUnsupportedHeader, StorageErrorCodeUnsupportedHTTPVerb, StorageErrorCodeUnsupportedQueryParameter, StorageErrorCodeUnsupportedXMLNode}
}

// AccessPolicy - An Access policy
type AccessPolicy struct {
	// Start - the date-time the policy is active
	Start time.Time `xml:"Start"`
	// Expiry - the date-time the policy expires
	Expiry time.Time `xml:"Expiry"`
	// Permission - the permissions for the acl policy
	Permission string `xml:"Permission"`
}

// MarshalXML implements the xml.Marshaler interface for AccessPolicy.
func (ap AccessPolicy) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	ap2 := (*accessPolicy)(unsafe.Pointer(&ap))
	return e.EncodeElement(*ap2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for AccessPolicy.
func (ap *AccessPolicy) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	ap2 := (*accessPolicy)(unsafe.Pointer(ap))
	return d.DecodeElement(ap2, &start)
}

// CorsRule - CORS is an HTTP feature that enables a web application running under one domain to access
// resources in another domain. Web browsers implement a security restriction known as same-origin policy that
// prevents a web page from calling APIs in a different domain; CORS provides a secure way to allow one domain
// (the origin domain) to call APIs in another domain
type CorsRule struct {
	// AllowedOrigins - The origin domains that are permitted to make a request against the storage service via CORS. The origin domain is the domain from which the request originates. Note that the origin must be an exact case-sensitive match with the origin that the user age sends to the service. You can also use the wildcard character '*' to allow all origin domains to make requests via CORS.
	AllowedOrigins string `xml:"AllowedOrigins"`
	// AllowedMethods - The methods (HTTP request verbs) that the origin domain may use for a CORS request. (comma separated)
	AllowedMethods string `xml:"AllowedMethods"`
	// AllowedHeaders - the request headers that the origin domain may specify on the CORS request.
	AllowedHeaders string `xml:"AllowedHeaders"`
	// ExposedHeaders - The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer
	ExposedHeaders string `xml:"ExposedHeaders"`
	// MaxAgeInSeconds - The maximum amount time that a browser should cache the preflight OPTIONS request.
	MaxAgeInSeconds int32 `xml:"MaxAgeInSeconds"`
}

// DequeuedMessageItem - The object returned in the QueueMessageList array when calling Get Messages on a
// Queue.
type DequeuedMessageItem struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName xml.Name `xml:"QueueMessage"`
	// MessageID - The Id of the Message.
	MessageID string `xml:"MessageId"`
	// InsertionTime - The time the Message was inserted into the Queue.
	InsertionTime time.Time `xml:"InsertionTime"`
	// ExpirationTime - The time that the Message will expire and be automatically deleted.
	ExpirationTime time.Time `xml:"ExpirationTime"`
	// PopReceipt - This value is required to delete the Message. If deletion fails using this popreceipt then the message has been dequeued by another client.
	PopReceipt string `xml:"PopReceipt"`
	// TimeNextVisible - The time that the message will again become visible in the Queue.
	TimeNextVisible time.Time `xml:"TimeNextVisible"`
	// DequeueCount - The number of times the message has been dequeued.
	DequeueCount int64 `xml:"DequeueCount"`
	// MessageText - The content of the Message.
	MessageText string `xml:"MessageText"`
}

// MarshalXML implements the xml.Marshaler interface for DequeuedMessageItem.
func (dmi DequeuedMessageItem) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	dmi2 := (*dequeuedMessageItem)(unsafe.Pointer(&dmi))
	return e.EncodeElement(*dmi2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for DequeuedMessageItem.
func (dmi *DequeuedMessageItem) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	dmi2 := (*dequeuedMessageItem)(unsafe.Pointer(dmi))
	return d.DecodeElement(dmi2, &start)
}

// EnqueuedMessage - The object returned in the QueueMessageList array when calling Put Message on a Queue
type EnqueuedMessage struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName xml.Name `xml:"QueueMessage"`
	// MessageID - The Id of the Message.
	MessageID string `xml:"MessageId"`
	// InsertionTime - The time the Message was inserted into the Queue.
	InsertionTime time.Time `xml:"InsertionTime"`
	// ExpirationTime - The time that the Message will expire and be automatically deleted.
	ExpirationTime time.Time `xml:"ExpirationTime"`
	// PopReceipt - This value is required to delete the Message. If deletion fails using this popreceipt then the message has been dequeued by another client.
	PopReceipt string `xml:"PopReceipt"`
	// TimeNextVisible - The time that the message will again become visible in the Queue.
	TimeNextVisible time.Time `xml:"TimeNextVisible"`
}

// MarshalXML implements the xml.Marshaler interface for EnqueuedMessage.
func (em EnqueuedMessage) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	em2 := (*enqueuedMessage)(unsafe.Pointer(&em))
	return e.EncodeElement(*em2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for EnqueuedMessage.
func (em *EnqueuedMessage) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	em2 := (*enqueuedMessage)(unsafe.Pointer(em))
	return d.DecodeElement(em2, &start)
}

// EnqueueResponse - Wraps the response from the messagesClient.Enqueue method.
type EnqueueResponse struct {
	rawResponse *http.Response
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName xml.Name          `xml:"QueueMessagesList"`
	Items   []EnqueuedMessage `xml:"QueueMessage"`
}

// Response returns the raw HTTP response object.
func (er EnqueueResponse) Response() *http.Response {
	return er.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (er EnqueueResponse) StatusCode() int {
	return er.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (er EnqueueResponse) Status() string {
	return er.rawResponse.Status
}

// Date returns the value for header Date.
func (er EnqueueResponse) Date() time.Time {
	s := er.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (er EnqueueResponse) ErrorCode() string {
	return er.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (er EnqueueResponse) RequestID() string {
	return er.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (er EnqueueResponse) Version() string {
	return er.rawResponse.Header.Get("x-ms-version")
}

// GeoReplication ...
type GeoReplication struct {
	// Status - The status of the secondary location. Possible values include: 'GeoReplicationStatusLive', 'GeoReplicationStatusBootstrap', 'GeoReplicationStatusUnavailable', 'GeoReplicationStatusNone'
	Status GeoReplicationStatusType `xml:"Status"`
	// LastSyncTime - A GMT date/time value, to the second. All primary writes preceding this value are guaranteed to be available for read operations at the secondary. Primary writes after this point in time may or may not be available for reads.
	LastSyncTime time.Time `xml:"LastSyncTime"`
}

// MarshalXML implements the xml.Marshaler interface for GeoReplication.
func (gr GeoReplication) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	gr2 := (*geoReplication)(unsafe.Pointer(&gr))
	return e.EncodeElement(*gr2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for GeoReplication.
func (gr *GeoReplication) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	gr2 := (*geoReplication)(unsafe.Pointer(gr))
	return d.DecodeElement(gr2, &start)
}

// ListQueuesSegmentResponse - The object returned when calling List Queues on a Queue Service.
type ListQueuesSegmentResponse struct {
	rawResponse *http.Response
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName         xml.Name    `xml:"EnumerationResults"`
	ServiceEndpoint string      `xml:"ServiceEndpoint,attr"`
	Prefix          string      `xml:"Prefix"`
	Marker          *string     `xml:"Marker"`
	MaxResults      int32       `xml:"MaxResults"`
	QueueItems      []QueueItem `xml:"Queues>Queue"`
	NextMarker      Marker      `xml:"NextMarker"`
}

// Response returns the raw HTTP response object.
func (lqsr ListQueuesSegmentResponse) Response() *http.Response {
	return lqsr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (lqsr ListQueuesSegmentResponse) StatusCode() int {
	return lqsr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (lqsr ListQueuesSegmentResponse) Status() string {
	return lqsr.rawResponse.Status
}

// Date returns the value for header Date.
func (lqsr ListQueuesSegmentResponse) Date() time.Time {
	s := lqsr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (lqsr ListQueuesSegmentResponse) ErrorCode() string {
	return lqsr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (lqsr ListQueuesSegmentResponse) RequestID() string {
	return lqsr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (lqsr ListQueuesSegmentResponse) Version() string {
	return lqsr.rawResponse.Header.Get("x-ms-version")
}

// Logging - Azure Analytics Logging settings.
type Logging struct {
	// Version - The version of Storage Analytics to configure.
	Version string `xml:"Version"`
	// Delete - Indicates whether all delete requests should be logged.
	Delete bool `xml:"Delete"`
	// Read - Indicates whether all read requests should be logged.
	Read bool `xml:"Read"`
	// Write - Indicates whether all write requests should be logged.
	Write           bool            `xml:"Write"`
	RetentionPolicy RetentionPolicy `xml:"RetentionPolicy"`
}

// MessageIDDeleteResponse ...
type MessageIDDeleteResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (midr MessageIDDeleteResponse) Response() *http.Response {
	return midr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (midr MessageIDDeleteResponse) StatusCode() int {
	return midr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (midr MessageIDDeleteResponse) Status() string {
	return midr.rawResponse.Status
}

// Date returns the value for header Date.
func (midr MessageIDDeleteResponse) Date() time.Time {
	s := midr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (midr MessageIDDeleteResponse) ErrorCode() string {
	return midr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (midr MessageIDDeleteResponse) RequestID() string {
	return midr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (midr MessageIDDeleteResponse) Version() string {
	return midr.rawResponse.Header.Get("x-ms-version")
}

// MessageIDUpdateResponse ...
type MessageIDUpdateResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (miur MessageIDUpdateResponse) Response() *http.Response {
	return miur.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (miur MessageIDUpdateResponse) StatusCode() int {
	return miur.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (miur MessageIDUpdateResponse) Status() string {
	return miur.rawResponse.Status
}

// Date returns the value for header Date.
func (miur MessageIDUpdateResponse) Date() time.Time {
	s := miur.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (miur MessageIDUpdateResponse) ErrorCode() string {
	return miur.rawResponse.Header.Get("x-ms-error-code")
}

// PopReceipt returns the value for header x-ms-popreceipt.
func (miur MessageIDUpdateResponse) PopReceipt() string {
	return miur.rawResponse.Header.Get("x-ms-popreceipt")
}

// RequestID returns the value for header x-ms-request-id.
func (miur MessageIDUpdateResponse) RequestID() string {
	return miur.rawResponse.Header.Get("x-ms-request-id")
}

// TimeNextVisible returns the value for header x-ms-time-next-visible.
func (miur MessageIDUpdateResponse) TimeNextVisible() time.Time {
	s := miur.rawResponse.Header.Get("x-ms-time-next-visible")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// Version returns the value for header x-ms-version.
func (miur MessageIDUpdateResponse) Version() string {
	return miur.rawResponse.Header.Get("x-ms-version")
}

// MessagesClearResponse ...
type MessagesClearResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (mcr MessagesClearResponse) Response() *http.Response {
	return mcr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (mcr MessagesClearResponse) StatusCode() int {
	return mcr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (mcr MessagesClearResponse) Status() string {
	return mcr.rawResponse.Status
}

// Date returns the value for header Date.
func (mcr MessagesClearResponse) Date() time.Time {
	s := mcr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (mcr MessagesClearResponse) ErrorCode() string {
	return mcr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (mcr MessagesClearResponse) RequestID() string {
	return mcr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (mcr MessagesClearResponse) Version() string {
	return mcr.rawResponse.Header.Get("x-ms-version")
}

// Metrics ...
type Metrics struct {
	// Version - The version of Storage Analytics to configure.
	Version *string `xml:"Version"`
	// Enabled - Indicates whether metrics are enabled for the Queue service.
	Enabled bool `xml:"Enabled"`
	// IncludeAPIs - Indicates whether metrics should generate summary statistics for called API operations.
	IncludeAPIs     *bool            `xml:"IncludeAPIs"`
	RetentionPolicy *RetentionPolicy `xml:"RetentionPolicy"`
}

// PeekedMessageItem - The object returned in the QueueMessageList array when calling Peek Messages on a Queue
type PeekedMessageItem struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName xml.Name `xml:"QueueMessage"`
	// MessageID - The Id of the Message.
	MessageID string `xml:"MessageId"`
	// InsertionTime - The time the Message was inserted into the Queue.
	InsertionTime time.Time `xml:"InsertionTime"`
	// ExpirationTime - The time that the Message will expire and be automatically deleted.
	ExpirationTime time.Time `xml:"ExpirationTime"`
	// DequeueCount - The number of times the message has been dequeued.
	DequeueCount int64 `xml:"DequeueCount"`
	// MessageText - The content of the Message.
	MessageText string `xml:"MessageText"`
}

// MarshalXML implements the xml.Marshaler interface for PeekedMessageItem.
func (pmi PeekedMessageItem) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	pmi2 := (*peekedMessageItem)(unsafe.Pointer(&pmi))
	return e.EncodeElement(*pmi2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for PeekedMessageItem.
func (pmi *PeekedMessageItem) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	pmi2 := (*peekedMessageItem)(unsafe.Pointer(pmi))
	return d.DecodeElement(pmi2, &start)
}

// PeekResponse - Wraps the response from the messagesClient.Peek method.
type PeekResponse struct {
	rawResponse *http.Response
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName xml.Name            `xml:"QueueMessagesList"`
	Items   []PeekedMessageItem `xml:"QueueMessage"`
}

// Response returns the raw HTTP response object.
func (pr PeekResponse) Response() *http.Response {
	return pr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (pr PeekResponse) StatusCode() int {
	return pr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (pr PeekResponse) Status() string {
	return pr.rawResponse.Status
}

// Date returns the value for header Date.
func (pr PeekResponse) Date() time.Time {
	s := pr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (pr PeekResponse) ErrorCode() string {
	return pr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (pr PeekResponse) RequestID() string {
	return pr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (pr PeekResponse) Version() string {
	return pr.rawResponse.Header.Get("x-ms-version")
}

// QueueCreateResponse ...
type QueueCreateResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (qcr QueueCreateResponse) Response() *http.Response {
	return qcr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (qcr QueueCreateResponse) StatusCode() int {
	return qcr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (qcr QueueCreateResponse) Status() string {
	return qcr.rawResponse.Status
}

// Date returns the value for header Date.
func (qcr QueueCreateResponse) Date() time.Time {
	s := qcr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (qcr QueueCreateResponse) ErrorCode() string {
	return qcr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (qcr QueueCreateResponse) RequestID() string {
	return qcr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (qcr QueueCreateResponse) Version() string {
	return qcr.rawResponse.Header.Get("x-ms-version")
}

// QueueDeleteResponse ...
type QueueDeleteResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (qdr QueueDeleteResponse) Response() *http.Response {
	return qdr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (qdr QueueDeleteResponse) StatusCode() int {
	return qdr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (qdr QueueDeleteResponse) Status() string {
	return qdr.rawResponse.Status
}

// Date returns the value for header Date.
func (qdr QueueDeleteResponse) Date() time.Time {
	s := qdr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (qdr QueueDeleteResponse) ErrorCode() string {
	return qdr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (qdr QueueDeleteResponse) RequestID() string {
	return qdr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (qdr QueueDeleteResponse) Version() string {
	return qdr.rawResponse.Header.Get("x-ms-version")
}

// QueueGetPropertiesResponse ...
type QueueGetPropertiesResponse struct {
	rawResponse *http.Response
}

// NewMetadata returns user-defined key/value pairs.
func (qgpr QueueGetPropertiesResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range qgpr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// Response returns the raw HTTP response object.
func (qgpr QueueGetPropertiesResponse) Response() *http.Response {
	return qgpr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (qgpr QueueGetPropertiesResponse) StatusCode() int {
	return qgpr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (qgpr QueueGetPropertiesResponse) Status() string {
	return qgpr.rawResponse.Status
}

// ApproximateMessagesCount returns the value for header x-ms-approximate-messages-count.
func (qgpr QueueGetPropertiesResponse) ApproximateMessagesCount() int32 {
	s := qgpr.rawResponse.Header.Get("x-ms-approximate-messages-count")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		i = 0
	}
	return int32(i)
}

// Date returns the value for header Date.
func (qgpr QueueGetPropertiesResponse) Date() time.Time {
	s := qgpr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (qgpr QueueGetPropertiesResponse) ErrorCode() string {
	return qgpr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (qgpr QueueGetPropertiesResponse) RequestID() string {
	return qgpr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (qgpr QueueGetPropertiesResponse) Version() string {
	return qgpr.rawResponse.Header.Get("x-ms-version")
}

// QueueItem - An Azure Storage Queue.
type QueueItem struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName xml.Name `xml:"Queue"`
	// Name - The name of the Queue.
	Name     string   `xml:"Name"`
	Metadata Metadata `xml:"Metadata"`
}

// QueueMessage - A Message object which can be stored in a Queue
type QueueMessage struct {
	// MessageText - The content of the message
	MessageText string `xml:"MessageText"`
}

// QueueMessagesList - Wraps the response from the messagesClient.Dequeue method.
type QueueMessagesList struct {
	rawResponse *http.Response
	Items       []DequeuedMessageItem `xml:"QueueMessage"`
}

// Response returns the raw HTTP response object.
func (qml QueueMessagesList) Response() *http.Response {
	return qml.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (qml QueueMessagesList) StatusCode() int {
	return qml.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (qml QueueMessagesList) Status() string {
	return qml.rawResponse.Status
}

// Date returns the value for header Date.
func (qml QueueMessagesList) Date() time.Time {
	s := qml.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (qml QueueMessagesList) ErrorCode() string {
	return qml.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (qml QueueMessagesList) RequestID() string {
	return qml.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (qml QueueMessagesList) Version() string {
	return qml.rawResponse.Header.Get("x-ms-version")
}

// QueueSetAccessPolicyResponse ...
type QueueSetAccessPolicyResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (qsapr QueueSetAccessPolicyResponse) Response() *http.Response {
	return qsapr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (qsapr QueueSetAccessPolicyResponse) StatusCode() int {
	return qsapr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (qsapr QueueSetAccessPolicyResponse) Status() string {
	return qsapr.rawResponse.Status
}

// Date returns the value for header Date.
func (qsapr QueueSetAccessPolicyResponse) Date() time.Time {
	s := qsapr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (qsapr QueueSetAccessPolicyResponse) ErrorCode() string {
	return qsapr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (qsapr QueueSetAccessPolicyResponse) RequestID() string {
	return qsapr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (qsapr QueueSetAccessPolicyResponse) Version() string {
	return qsapr.rawResponse.Header.Get("x-ms-version")
}

// QueueSetMetadataResponse ...
type QueueSetMetadataResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (qsmr QueueSetMetadataResponse) Response() *http.Response {
	return qsmr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (qsmr QueueSetMetadataResponse) StatusCode() int {
	return qsmr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (qsmr QueueSetMetadataResponse) Status() string {
	return qsmr.rawResponse.Status
}

// Date returns the value for header Date.
func (qsmr QueueSetMetadataResponse) Date() time.Time {
	s := qsmr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (qsmr QueueSetMetadataResponse) ErrorCode() string {
	return qsmr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (qsmr QueueSetMetadataResponse) RequestID() string {
	return qsmr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (qsmr QueueSetMetadataResponse) Version() string {
	return qsmr.rawResponse.Header.Get("x-ms-version")
}

// RetentionPolicy - the retention policy
type RetentionPolicy struct {
	// Enabled - Indicates whether a retention policy is enabled for the storage service
	Enabled bool `xml:"Enabled"`
	// Days - Indicates the number of days that metrics or logging or soft-deleted data should be retained. All data older than this value will be deleted
	Days *int32 `xml:"Days"`
}

// ServiceSetPropertiesResponse ...
type ServiceSetPropertiesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (sspr ServiceSetPropertiesResponse) Response() *http.Response {
	return sspr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (sspr ServiceSetPropertiesResponse) StatusCode() int {
	return sspr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (sspr ServiceSetPropertiesResponse) Status() string {
	return sspr.rawResponse.Status
}

// ErrorCode returns the value for header x-ms-error-code.
func (sspr ServiceSetPropertiesResponse) ErrorCode() string {
	return sspr.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (sspr ServiceSetPropertiesResponse) RequestID() string {
	return sspr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (sspr ServiceSetPropertiesResponse) Version() string {
	return sspr.rawResponse.Header.Get("x-ms-version")
}

// SignedIdentifier - signed identifier
type SignedIdentifier struct {
	// ID - a unique id
	ID string `xml:"Id"`
	// AccessPolicy - The access policy
	AccessPolicy AccessPolicy `xml:"AccessPolicy"`
}

// SignedIdentifiers - Wraps the response from the queueClient.GetAccessPolicy method.
type SignedIdentifiers struct {
	rawResponse *http.Response
	Items       []SignedIdentifier `xml:"SignedIdentifier"`
}

// Response returns the raw HTTP response object.
func (si SignedIdentifiers) Response() *http.Response {
	return si.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (si SignedIdentifiers) StatusCode() int {
	return si.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (si SignedIdentifiers) Status() string {
	return si.rawResponse.Status
}

// Date returns the value for header Date.
func (si SignedIdentifiers) Date() time.Time {
	s := si.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (si SignedIdentifiers) ErrorCode() string {
	return si.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (si SignedIdentifiers) RequestID() string {
	return si.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (si SignedIdentifiers) Version() string {
	return si.rawResponse.Header.Get("x-ms-version")
}

// StorageServiceProperties - Storage Service Properties.
type StorageServiceProperties struct {
	rawResponse *http.Response
	// Logging - Azure Analytics Logging settings
	Logging *Logging `xml:"Logging"`
	// HourMetrics - A summary of request statistics grouped by API in hourly aggregates for queues
	HourMetrics *Metrics `xml:"HourMetrics"`
	// MinuteMetrics - a summary of request statistics grouped by API in minute aggregates for queues
	MinuteMetrics *Metrics `xml:"MinuteMetrics"`
	// Cors - The set of CORS rules.
	Cors []CorsRule `xml:"Cors>CorsRule"`
}

// Response returns the raw HTTP response object.
func (ssp StorageServiceProperties) Response() *http.Response {
	return ssp.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ssp StorageServiceProperties) StatusCode() int {
	return ssp.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ssp StorageServiceProperties) Status() string {
	return ssp.rawResponse.Status
}

// ErrorCode returns the value for header x-ms-error-code.
func (ssp StorageServiceProperties) ErrorCode() string {
	return ssp.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (ssp StorageServiceProperties) RequestID() string {
	return ssp.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ssp StorageServiceProperties) Version() string {
	return ssp.rawResponse.Header.Get("x-ms-version")
}

// StorageServiceStats - Stats for the storage service.
type StorageServiceStats struct {
	rawResponse *http.Response
	// GeoReplication - Geo-Replication information for the Secondary Storage Service
	GeoReplication *GeoReplication `xml:"GeoReplication"`
}

// Response returns the raw HTTP response object.
func (sss StorageServiceStats) Response() *http.Response {
	return sss.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (sss StorageServiceStats) StatusCode() int {
	return sss.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (sss StorageServiceStats) Status() string {
	return sss.rawResponse.Status
}

// Date returns the value for header Date.
func (sss StorageServiceStats) Date() time.Time {
	s := sss.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		t = time.Time{}
	}
	return t
}

// ErrorCode returns the value for header x-ms-error-code.
func (sss StorageServiceStats) ErrorCode() string {
	return sss.rawResponse.Header.Get("x-ms-error-code")
}

// RequestID returns the value for header x-ms-request-id.
func (sss StorageServiceStats) RequestID() string {
	return sss.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (sss StorageServiceStats) Version() string {
	return sss.rawResponse.Header.Get("x-ms-version")
}

func init() {
	if reflect.TypeOf((*AccessPolicy)(nil)).Elem().Size() != reflect.TypeOf((*accessPolicy)(nil)).Elem().Size() {
		validateError(errors.New("size mismatch between AccessPolicy and accessPolicy"))
	}
	if reflect.TypeOf((*GeoReplication)(nil)).Elem().Size() != reflect.TypeOf((*geoReplication)(nil)).Elem().Size() {
		validateError(errors.New("size mismatch between GeoReplication and geoReplication"))
	}
	if reflect.TypeOf((*DequeuedMessageItem)(nil)).Elem().Size() != reflect.TypeOf((*dequeuedMessageItem)(nil)).Elem().Size() {
		validateError(errors.New("size mismatch between DequeuedMessageItem and dequeuedMessageItem"))
	}
	if reflect.TypeOf((*PeekedMessageItem)(nil)).Elem().Size() != reflect.TypeOf((*peekedMessageItem)(nil)).Elem().Size() {
		validateError(errors.New("size mismatch between PeekedMessageItem and peekedMessageItem"))
	}
	if reflect.TypeOf((*EnqueuedMessage)(nil)).Elem().Size() != reflect.TypeOf((*enqueuedMessage)(nil)).Elem().Size() {
		validateError(errors.New("size mismatch between EnqueuedMessage and enqueuedMessage"))
	}
}

const (
	rfc3339Format = "2006-01-02T15:04:05.0000000Z07:00"
)

// used to convert times from UTC to GMT before sending across the wire
var gmt = time.FixedZone("GMT", 0)

// internal type used for marshalling time in RFC1123 format
type timeRFC1123 struct {
	time.Time
}

// MarshalText implements the encoding.TextMarshaler interface for timeRFC1123.
func (t timeRFC1123) MarshalText() ([]byte, error) {
	return []byte(t.Format(time.RFC1123)), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface for timeRFC1123.
func (t *timeRFC1123) UnmarshalText(data []byte) (err error) {
	t.Time, err = time.Parse(time.RFC1123, string(data))
	return
}

// internal type used for marshalling time in RFC3339 format
type timeRFC3339 struct {
	time.Time
}

// MarshalText implements the encoding.TextMarshaler interface for timeRFC3339.
func (t timeRFC3339) MarshalText() ([]byte, error) {
	return []byte(t.Format(rfc3339Format)), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface for timeRFC3339.
func (t *timeRFC3339) UnmarshalText(data []byte) (err error) {
	t.Time, err = time.Parse(rfc3339Format, string(data))
	return
}

// internal type used for marshalling
type accessPolicy struct {
	Start      timeRFC3339 `xml:"Start"`
	Expiry     timeRFC3339 `xml:"Expiry"`
	Permission string      `xml:"Permission"`
}

// internal type used for marshalling
type geoReplication struct {
	Status       GeoReplicationStatusType `xml:"Status"`
	LastSyncTime timeRFC1123              `xml:"LastSyncTime"`
}

// internal type used for marshalling
type dequeuedMessageItem struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName         xml.Name    `xml:"QueueMessage"`
	MessageID       string      `xml:"MessageId"`
	InsertionTime   timeRFC1123 `xml:"InsertionTime"`
	ExpirationTime  timeRFC1123 `xml:"ExpirationTime"`
	PopReceipt      string      `xml:"PopReceipt"`
	TimeNextVisible timeRFC1123 `xml:"TimeNextVisible"`
	DequeueCount    int64       `xml:"DequeueCount"`
	MessageText     string      `xml:"MessageText"`
}

// internal type used for marshalling
type peekedMessageItem struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName        xml.Name    `xml:"QueueMessage"`
	MessageID      string      `xml:"MessageId"`
	InsertionTime  timeRFC1123 `xml:"InsertionTime"`
	ExpirationTime timeRFC1123 `xml:"ExpirationTime"`
	DequeueCount   int64       `xml:"DequeueCount"`
	MessageText    string      `xml:"MessageText"`
}

// internal type used for marshalling
type enqueuedMessage struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName         xml.Name    `xml:"QueueMessage"`
	MessageID       string      `xml:"MessageId"`
	InsertionTime   timeRFC1123 `xml:"InsertionTime"`
	ExpirationTime  timeRFC1123 `xml:"ExpirationTime"`
	PopReceipt      string      `xml:"PopReceipt"`
	TimeNextVisible timeRFC1123 `xml:"TimeNextVisible"`
}
