/***************************************************************
 *		CalendarDB.h
 *			Header for Rex addin program.
 ***************************************************************/
#ifndef CALENDARDB_H
#define CALENDARDB_H

	// Table 2000
	enum CAL_SCHED_FIELD {
		CAL_SCHED_RECID = 1,
		CAL_SCHED_SCHEDULEID,
		CAL_SCHED_RPT_TYPE,		//see CAL_RPT_TYPE
		CAL_SCHED_SCHED_REP_TYPE,	//see CAL_SCD_RPT_TYPE
		CAL_SCHED_FREQUENCY,
		CAL_SCHED_NUMBER_OF_DAYS,
		CAL_SCHED_RPT_DAY,
		CAL_SCHED_RPT_MONTH,
		CAL_SCHED_RPT_DAYOFWEEK,
		CAL_SCHED_RPT_WEEKOFMONTH,
		CAL_SCHED_RPT_STARTDATE,
		CAL_SCHED_RPT_ENDDATE,
		CAL_SCHED_TIMEZONE,
		CAL_SCHED_SEARCHTYPE,		//see CAL_SRCH_TYPE
		CAL_SCHED_SEARCHKEY,
		CAL_SCHED_ALARM,
		CAL_SCHED_ALARM_UNIT,		//see ALARM_UNIT
		CAL_SCHED_STARTTIME,
		CAL_SCHED_ENDTIME,
		CAL_SCHED_TYPE,			//see CAL_TYPE
		CAL_SCHED_EXCLUDE,
		CAL_SCHED_TITLE,
		CAL_SCHED_PLACE,
		CAL_SCHED_NOTE
	};

	enum CAL_RPT_TYPE {
		CAL_RPT_NOREPEAT = 1,
		CAL_RPT_DAYLY,
		CAL_RPT_WEEKLY,
		CAL_RPT_MONTHLY,
		CAL_RPT_MONTHLY_BY_POS,
		CAL_RPT_YEARLY
	};

	enum CAL_SCD_RPT_TYPE {
		CAL_SRPT_NOREPEAT = 1,
		CAL_SRPT_REPEAT
	};

	enum CAL_SRCH_TYPE {
		CAL_SRCH_ALL = 1,
		CAL_SRCH_SINGLE,
		CAL_SRCH_YEARLY
	};

	enum CAL_TYPE {
		CAL_TYPE_SYUKUJITU = 1,
		CAL_TYPE_KINENBI,
		CAL_TYPE_EVENT,
		CAL_TYPE_YOTEI
	};

	enum ALARM_UNIT {
		CAL_ALM_NONE = 0,
		CAL_ALM_MINS,
		CAL_ALM_HOURS,
		CAL_ALM_DAYS
	};


	enum CAL_SCHED_INX {
		CAL_SCHED_INX_RECID = 1,
		CAL_SCHED_INX_SCHEDID,
		CAL_SCHED_INX_SEARCH
	};

	//Table 2001: see StatusDB.h

	//Table 2002
	enum CAL_ALARM_FIELD {
		CAL_ALARM_RECID = 1,
		CAL_ALARM_RPT_TYPE,
		CAL_ALARM_FREQUENCY,
		CAL_ALARM_RPT_DAY,
		CAL_ALARM_RPT_MONTH,
		CAL_ALARM_RPT_DAYOFWEEK,
		CAL_ALARM_RPT_WEEKOFMONTH,
		CAL_ALARM_RPT_STARTDATE,
		CAL_ALARM_RPT_ENDDATE,
		CAL_ALARM_SEARCHTYPE,
		CAL_ALARM_SEARCHKEY,
		CAL_ALARM_ALARM,
		CAL_ALARM_ALARM_UNIT,
		CAL_ALARM_STARTTIME,
		CAL_ALARM_EXCLUDE
	};


	enum CAL_ALARM_INX {
		CAL_ALARM_INX_RECID = 1,
		CAL_ALARM_INX_SEARCH
	};

#endif


