package ONVIF::Device::Types::PaneLayoutOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Area_of :ATTR(:get<Area>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Area
        Extension

    ) ],
    {
        'Area' => \%Area_of,
        'Extension' => \%Extension_of,
    },
    {
        'Area' => 'ONVIF::Device::Types::Rectangle',
        'Extension' => 'ONVIF::Device::Types::PaneOptionExtension',
    },
    {

        'Area' => 'Area',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::PaneLayoutOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PaneLayoutOptions from the namespace http://www.onvif.org/ver10/schema.

Description of a pane layout describing a complete display layout.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Area


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::PaneLayoutOptions
   Area => ,
   Extension =>  { # ONVIF::Device::Types::PaneOptionExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

